"""6.0 add_decimal_precision

Revision ID: 8b8ac63f8333
Revises: 6bb1388dbe67
Create Date: 2020-11-09 14:40:41.546700

"""

# revision identifiers, used by Alembic.
revision = "8b8ac63f8333"
down_revision = "6bb1388dbe67"

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import mysql

from caerp.alembic.utils import column_exists


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "company", sa.Column("decimal_to_display", sa.Integer(), nullable=True)
    )
    op.add_column("task", sa.Column("decimal_to_display", sa.Integer(), nullable=True))
    for tbl_name, column in (
        ("user_datas", "parcours_end_date"),
        ("user_datas", "parcours_salary_letters"),
        ("user_datas", "parcours_taux_horaire"),
        ("user_datas", "parcours_contract_type"),
        ("user_datas", "parcours_start_date"),
        ("user_datas", "situation_situation"),
        ("user_datas", "parcours_taux_horaire_letters"),
        ("user_datas", "parcours_employee_quality_id"),
        ("user_datas", "parcours_num_hours"),
        ("user_datas", "parcours_last_avenant"),
        ("user_datas", "parcours_salary"),
        ("user_datas", "sortie_date"),
        ("workshop", "info2"),
        ("workshop", "info1"),
        ("workshop", "info3"),
    ):
        if column_exists(tbl_name, column):
            op.drop_column(tbl_name, column)

    # ### end Alembic commands ###


def migrate_datas():
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed

    conn = get_bind()

    conn.execute("update task set decimal_to_display='2'")
    conn.execute("update company set decimal_to_display='2'")
    mark_changed(session)


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    pass
