"""6.0 ref 1898 type de projet par defaut

Revision ID: 2cae2c8225a9
Revises: 701c65a78b84
Create Date: 2020-09-09 17:25:56.371328

"""

# revision identifiers, used by Alembic.
revision = "2cae2c8225a9"
down_revision = "701c65a78b84"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "project_type", sa.Column("with_business", sa.Boolean(), nullable=True)
    )
    # ### end Alembic commands ###


def migrate_datas():
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed

    conn = get_bind()

    op.execute(
        """
update project_type as p join base_project_type as b on b.id=p.id set p.with_business=0 where b.name='default'
"""
    )
    op.execute(
        """
update project_type as p join base_project_type as b on b.id=p.id set p.with_business=1 where b.name!='default'
"""
    )
    mark_changed(session)


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("project_type", "with_business")
    # ### end Alembic commands ###
