"""6.3.0 Ajout d'un booleen display_details au modèle TaskLineGroup

Revision ID: a9bb2ebf988d
Revises: b1b7468b8889
Create Date: 2021-09-28 11:34:56.866025

"""

# revision identifiers, used by Alembic.
revision = "a9bb2ebf988d"
down_revision = "b1b7468b8889"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def update_database_structure():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "task_line_group",
        sa.Column("display_details", mysql.TINYINT(display_width=1), nullable=True),
    )
    # ### end Alembic commands ###


def migrate_datas():
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    conn = get_bind()

    op.execute(
        """
        UPDATE task_line_group
        SET display_details = 1
    """
    )

    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("task_line_group", "display_details")
    # ### end Alembic commands ###
