"""6.4.0 update de champs catalogue-etude

Revision ID: 4f714e529447
Revises: 842820ac6955
Create Date: 2022-03-09 17:13:19.374826

"""

# revision identifiers, used by Alembic.
revision = "4f714e529447"
down_revision = "842820ac6955"

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql
from caerp.alembic.utils import (
    drop_index_if_exists,
    foreign_key_exists,
    drop_foreign_key_if_exists,
)


def update_database_structure():
    drop_foreign_key_if_exists(
        "price_study_work", "fk_price_study_work_sale_product_work_id"
    )
    op.drop_column("price_study_work", "sale_product_work_id")

    drop_foreign_key_if_exists(
        "price_study_work_item", "fk_price_study_work_item_work_item_id"
    )
    op.drop_column("price_study_work_item", "work_item_id")

    op.drop_column("base_price_study_product", "general_overhead")
    op.drop_column("base_price_study_product", "uptodate")
    drop_foreign_key_if_exists(
        "price_study_work_item", "fk_price_study_work_item__product_id"
    )
    drop_foreign_key_if_exists(
        "price_study_work_item", "fk_price_study_work_item__tva_id"
    )

    op.drop_column("price_study_work_item", "_tva_id")
    op.drop_column("price_study_work_item", "uptodate")
    op.drop_column("price_study_work_item", "_general_overhead")
    op.drop_column("price_study_work_item", "_product_id")
    op.drop_column("price_study_work_item", "_margin_rate")

    op.drop_constraint(
        "fk_price_study_product_base_sale_product_id",
        "price_study_product",
        type_="foreignkey",
    )
    op.create_foreign_key(
        op.f("fk_price_study_product_base_sale_product_id"),
        "price_study_product",
        "base_sale_product",
        ["base_sale_product_id"],
        ["id"],
        ondelete="SET NULL",
    )
    op.drop_constraint(
        "fk_price_study_work_item_base_sale_product_id",
        "price_study_work_item",
        type_="foreignkey",
    )
    op.create_foreign_key(
        op.f("fk_price_study_work_item_base_sale_product_id"),
        "price_study_work_item",
        "base_sale_product",
        ["base_sale_product_id"],
        ["id"],
        ondelete="SET NULL",
    )

    drop_index_if_exists("task", "fk_task_status_person_id")
    drop_index_if_exists("config_files", "key")

    if foreign_key_exists(
        "business_payment_deadline", "fk_business_payment_deadline_business_id"
    ):
        op.drop_constraint(
            "fk_business_payment_deadline_business_id",
            "business_payment_deadline",
            type_="foreignkey",
        )
        op.create_foreign_key(
            op.f("fk_business_payment_deadline_business_id"),
            "business_payment_deadline",
            "business",
            ["business_id"],
            ["id"],
            ondelete="CASCADE",
        )

    if foreign_key_exists(
        "progress_invoicing_group", "fk_progress_invoicing_group_task_line_group_id"
    ):
        op.drop_constraint(
            "fk_progress_invoicing_group_task_line_group_id",
            "progress_invoicing_group",
            type_="foreignkey",
        )
        op.create_foreign_key(
            op.f("fk_progress_invoicing_group_task_line_group_id"),
            "progress_invoicing_group",
            "task_line_group",
            ["task_line_group_id"],
            ["id"],
            ondelete="SET NULL",
        )
    if foreign_key_exists(
        "progress_invoicing_line", "fk_progress_invoicing_line_task_line_id"
    ):
        op.drop_constraint(
            "fk_progress_invoicing_line_task_line_id",
            "progress_invoicing_line",
            type_="foreignkey",
        )
        op.create_foreign_key(
            op.f("fk_progress_invoicing_line_task_line_id"),
            "progress_invoicing_line",
            "task_line",
            ["task_line_id"],
            ["id"],
            ondelete="SET NULL",
        )
    # ### end Alembic commands ###


def migrate_datas():
    from alembic.context import get_bind
    from zope.sqlalchemy import mark_changed
    from caerp_base.models.base import DBSESSION

    session = DBSESSION()
    conn = get_bind()

    mark_changed(session)
    session.flush()


def upgrade():
    update_database_structure()
    migrate_datas()


def downgrade():
    pass
    # ### commands auto generated by Alembic - please adjust! ###
    # ### end Alembic commands ###
