______________________________________________________________________

## id: 01K6HKJ9R9XSPG5VJSBW810DS6

______________________________________________________________________

## id: 01K6HG55C2MJJENM49S835B2RH

______________________________________________________________________

## id: 01K6HFJ0G9XKES2631J5B24BMH

______________________________________________________________________

## id: 01K6HFCZ6WJZFBWKT0FQD6DGD7

______________________________________________________________________

## id: 01K6GZRDZJK2T03CRC3EBBAB77

______________________________________________________________________

## id: 01K6GZPCACYT6BPY10F3TVDEK2

______________________________________________________________________

## id: 01K6GVZVQEYB6P462WQB9M2FMS

______________________________________________________________________

## id: 01K6GVY37AP1Q0C9BF9Z91JQ10

______________________________________________________________________

## id: 01K6GSRDPP5CRG9Q2P4A33CKZF

______________________________________________________________________

## id: 01K6GSM8HQZA2HX310Q5B36D94

______________________________________________________________________

## id: 01K6GPA5ZHZZAFV2PYP907YX2W

______________________________________________________________________

## id: 01K6GMDSMA8SQHP1CKVP1K63HR

______________________________________________________________________

## id: 01K6GKSYV0Z1PDJDW0QPASGXXJ

______________________________________________________________________

## id: 01K6GKJQBYYJNDBMC100R1MGZ9

______________________________________________________________________

## id: 01K6GJYJ4GEF5NRNG09DXZYYB8

______________________________________________________________________

## id: 01K6GGMC60JMYY6WBA0AMN47WB

______________________________________________________________________

## id: 01K6G684CT729K07NJBFQCCCWP

______________________________________________________________________

## id: 01K6G5HQ0F112A6WMZ39XPXYFH

______________________________________________________________________

## id: 01K6G58F3GZJ086GD5V5YGDW5F

______________________________________________________________________

## id: 01K6G4MEY0H53R1KJ7WVXCX6GP

______________________________________________________________________

## id: 01K6G3R9HR9TH7C0WKZMJJW6BD

______________________________________________________________________

## id: 01K6G39A32YZ4PEEM22VJ7F0YY

______________________________________________________________________

## id: 01K6FZP3W5K341F24D899RTFD8

______________________________________________________________________

## id: 01K6FY3RJ3RBMPJBVCB8FFH5CN

______________________________________________________________________

## id: 01K6FVE7B4BKHEZMTK1PJ7HGHE

______________________________________________________________________

## id: 01K6FSH5GN4PG549NSCNN9648J

______________________________________________________________________

## id: 01K6FSG6N8GMZRXWT550FR1Y5V

______________________________________________________________________

## id: 01K6FSATM4DQRHNN13ZERHEENY

______________________________________________________________________

## id: 01K6FRWFGCY4PZCDNEFD4PKGDH

______________________________________________________________________

## id: 01K6FRSRKX0AZ92F91J2WRC5RC

______________________________________________________________________

## id: 01K6FRKW7RKSA73D7TX9Y25B96

______________________________________________________________________

## id: 01K6FRJ6GNASW2Q4J6G7T1GR0R

______________________________________________________________________

## id: 01K6FRDYYAKMV2GVZ6B3NM3VSV

______________________________________________________________________

## id: 01K6FQVYNWKWWEJXG1XJMD91WD

______________________________________________________________________

## id: 01K6FQNYKMR14AD56YSVF5XAV2

______________________________________________________________________

## id: 01K6FQ9DZRF4B6BF5QPTF3XG1N

______________________________________________________________________

## id: 01K6FQ08QD8QJWDEKRGS3BBGKY

______________________________________________________________________

## id: 01K6FPYBHK7GPKM9FAV2JMNSRC

______________________________________________________________________

## id: 01K6FPVXN2Y8PPZM34CAYXQHCZ

______________________________________________________________________

## id: 01K6FP91F4VPV7SR7SS7ETS1DM

______________________________________________________________________

## id: 01K6FP2047F0487ARAQDR9RGG6

______________________________________________________________________

## id: 01K6FP07WXDAKV2T7TZXF4MAF9

______________________________________________________________________

## id: 01K6FNY7ED7EFSKZHY7ENAESMB

______________________________________________________________________

## id: 01K6FND5XSF3F30BTRG5E81N1Q

______________________________________________________________________

## id: 01K6FN9DCCK8T2ANMYD0FCWZXR

______________________________________________________________________

## id: 01K6FM8W6Q62DA7M9T78MDJJZC

______________________________________________________________________

## id: 01K6FM4HC6VRWJ9J5FZK25VD3V

______________________________________________________________________

## id: 01K6FM356SBAKP69G7DBAYHB26

______________________________________________________________________

## id: 01K6FKYXQ2RPDBRM862KDC56B0

______________________________________________________________________

## id: 01K6FKXJ1G7FHF9MGJC0D4MVN7

______________________________________________________________________

## id: 01K6FD9CT9ZEA9JAS5VBCGT11P

______________________________________________________________________

## id: 01K6FCP49Q3Q0R3SZNECA1HVN4

______________________________________________________________________

## id: 01K6FBZ6N21P853FRH9NK6JRCP

______________________________________________________________________

## id: 01K6FBRKXM1A2FA45R4J58A6SE

______________________________________________________________________

## id: 01K6FBJDQY5BCV23DZM12274NS

______________________________________________________________________

## id: 01K6FB8FR9ZDCN944FE8C246P0

______________________________________________________________________

## id: 01K6F9NV2SR5PTRY0M0GX6CFY5

______________________________________________________________________

## id: 01K6F9JTPYFF3MMSS9YJDN492P

______________________________________________________________________

## id: 01K6F9HV4ZH97EGVC4PP2VZZ9B

______________________________________________________________________

## id: 01K6F9FCEN62HYG8ZWGF0N6102

______________________________________________________________________

## id: 01K6F9EEP0RR2GWTW1CBNBB5HV

______________________________________________________________________

## id: 01K6F8HEE913REA44EMADD7GT8

______________________________________________________________________

## id: 01K6F85Q3R3KT0JVYM77R8AAPP

______________________________________________________________________

## id: 01K6F6ZF70NTXBPPWADPDS9ETB

______________________________________________________________________

## id: 01K6F6Y47N5N41TPMF6B8A1BBB

______________________________________________________________________

## id: 01K6F0QDS1HFE2J1MX4EFA2T1R

______________________________________________________________________

## id: 01K6F05YMMSTJHKRBS5J681EME

______________________________________________________________________

## id: 01K6EZZQKAX84YYWDK0VRNQGQY

______________________________________________________________________

## id: 01K6EZZ31K0DR97MC2AR9TGW2H

______________________________________________________________________

## id: 01K6EZMV8C951NB5NWX1ZT7SRF

______________________________________________________________________

## id: 01K6EZM0X0HP7QH79B0TM35RW4

______________________________________________________________________

## id: 01K6EZ6QABY534WQNDXH9PY6NJ

______________________________________________________________________

## id: 01K6EZ635GHZHSWE9FV4EQWAKV

______________________________________________________________________

## id: 01K6EZ11KH4F3ZX8SEX79DCGN1

______________________________________________________________________

## id: 01K6EZ059H1TM44H2D9XYKRW3D

______________________________________________________________________

## id: 01K6EYXX7KFJ0Z4B591GTT48V1

______________________________________________________________________

## id: 01K6EYX6YKCWB0NCBQAJ7Q4T1V

______________________________________________________________________

## id: 01K6EXJPDV03GQ9Y7J716Z2H5Z

______________________________________________________________________

## id: 01K6EXHNQWMZX48K06HXN9N0FM

______________________________________________________________________

## id: 01K6EXCHBACCD8S7Y1MCPV9M27

______________________________________________________________________

## id: 01K6EXBQSRRN6RVH00ZZZ9E0NJ

______________________________________________________________________

## id: 01K6EWFGNB6KMWZHHYTKC0J998

______________________________________________________________________

## id: 01K6EWEP8HFK4QQTJD1AHT6CKH

______________________________________________________________________

## id: 01K6ETPPT21ZH1JEWKN3C0X8W9

______________________________________________________________________

## id: 01K6ETP1MX2C5JCTFA9AB8Q7C8

______________________________________________________________________

## id: 01K6ETJAKAMZ2D9PME554M599R

______________________________________________________________________

## id: 01K6ETHJA8VDJ43KSN2MPKW0Y4

______________________________________________________________________

## id: 01K6ESWK07KMBK90V4ZBSQ0QW5

______________________________________________________________________

## id: 01K6ESVY47JF941QSJ12X20ZED

______________________________________________________________________

## id: 01K6ESP1RCVJ8BRS8ZXQRK05V5

______________________________________________________________________

## id: 01K6ESNCRYZK3HY73EGEQEYVE8

______________________________________________________________________

## id: 01K6ESKZF1CPCZRD9HQ0KNTY61

______________________________________________________________________

## id: 01K6ESK8PSVKHKJ2FTNBJJ0X96

______________________________________________________________________

## id: 01K6ESHEBR1BQMVABWVM3XHP38

______________________________________________________________________

## id: 01K6ESGTXQ7MP3J66SKXAJCDHA

______________________________________________________________________

## id: 01K6EN5QGS1N2A3XEHN6HM8KBM

______________________________________________________________________

## id: 01K6EN4Y3Q3S6TNHC39XGPQW8P

______________________________________________________________________

## id: 01K6EMS3R293KGZ2Y4C5VJK90Y

______________________________________________________________________

## id: 01K6EMRAR7Z880KW2S1FWH2X3B

______________________________________________________________________

## id: 01K6EJ91TCFJXTKB7DJTQ4ZRKQ

# Testing ACB

This document provides information about running tests for the ACB project.

## Running Tests

### Using pytest

The recommended way to run tests is to use pytest directly:

```bash
python -m pytest
```

You can pass additional pytest arguments:

```bash
python -m pytest -v                # Run with verbose output
python -m pytest tests/test_config.py  # Run specific tests
python -m pytest --run-slow        # Run slow tests
```

## Test Configuration

The test configuration is defined in `pyproject.toml` and `tests/conftest.py`. The tests use pytest fixtures to mock dependencies and prevent file system operations during testing.

## Mocking Guidelines

### Avoiding File System Operations

Tests should **never** create actual files, directories, or settings during test execution. Instead, use the mock fixtures provided in `tests/conftest.py`:

- `mock_config`: Provides a mocked Config object with mock paths
- `mock_file_system`: Simplified in-memory file system for tests
- `mock_async_file_system`: Simplified in-memory async file system for tests
- `mock_settings`: Provides mock settings without creating actual settings files
- `mock_tmp_path`: Simple mock replacement for pytest's built-in tmp_path fixture
- `mock_tempfile`: Simple mock replacement for Python's tempfile module
- `mock_async_path`: Mock for AsyncPath objects
- `mock_path_constructor`: Mock for Path constructor
- `mock_secrets_path`: Mock for secrets directory path

The mock file system implementations have been simplified to reduce complexity while still providing the necessary functionality.

### Adapter and Config Mocking

The test suite includes automatic patching for adapter imports and configuration directly in the main conftest.py file:

- `patch_adapter_imports`: Automatically patches adapter imports to avoid looking for actual adapter files
- `patch_config`: Automatically patches the config module to avoid looking for actual config files

These fixtures are applied automatically for all tests, so you don't need to explicitly import or use them. They ensure that:

1. No actual files or directories are created during tests
1. No actual configuration files are read
1. Adapter imports work without requiring actual adapter files
1. Modules that import other adapters (like SMTP and FTPD) can be tested without dependencies

### Mock Class Method Delegation

When creating mock classes for testing adapters, it's important to implement proper method delegation, especially when the class being mocked has both public and private methods. Follow these guidelines:

1. **Public-Private Method Delegation**: Ensure that public methods in mock classes properly delegate to their private counterparts, just as they do in the actual implementation.

   ```python
   # Original class
   class SomeAdapter:
       def public_method(self, arg):
           return self._private_method(arg)

       def _private_method(self, arg):
           # Implementation
           pass


   # Mock class - CORRECT implementation
   class MockAdapter:
       def public_method(self, arg):
           return self._private_method(arg)  # Proper delegation

       def _private_method(self, arg):
           # Mock implementation
           pass
   ```

1. **Separate Test Classes for Complex Mocks**: For adapters with complex dependencies (like Redis, SQLModel), create separate test classes with their own fixtures to avoid conflicts with base classes.

1. **Patching External Dependencies**: Use `unittest.mock.patch` to mock external dependencies like file system operations:

   ```python
   @pytest.mark.asyncio
   @patch.object(AsyncPath, "exists")
   async def test_with_patched_method(self, mock_exists):
       mock_exists.return_value = False  # Mock the behavior
       # Test implementation
   ```

1. **Exception Handling in Mocks**: Ensure that mock objects properly handle exceptions that would occur in the real implementation, such as `FileNotFoundError` for file operations.

### Example: Proper Mock Implementation

```python
# Test class with proper method delegation
class TestRedisCache:
    @pytest.fixture
    def redis_mock(self):
        class MockRedis:
            def __init__(self):
                self.data = {}

            async def get(self, key):
                # Public method delegates to private method
                return await self._get(key)

            async def _get(self, key):
                # Mock implementation
                return self.data.get(key)

        return MockRedis()

    @pytest.mark.asyncio
    async def test_redis_get(self, redis_mock):
        redis_mock.data["test_key"] = "test_value"
        result = await redis_mock.get("test_key")
        assert result == "test_value"
```

### Example: Using Mock Async File System

```python
@pytest.mark.asyncio
async def test_async_file_operations(
    self, mock_async_file_system, patch_async_file_operations
):
    from anyio import Path as AsyncPath

    file_path = AsyncPath("/mock/path/test_file.txt")

    # Write to the mock async file system
    await file_path.write_text("test content")

    # Read from the mock async file system
    content = await file_path.read_text()
    assert content == "test content"
```

### Test Organization

For adapter tests, the project follows a structured approach:

1. **Base Test Files**: Each adapter category has a base test file (e.g., `test_cache_base.py`, `test_sql_base.py`) that contains:

   - Common test fixtures
   - Base class tests
   - Shared assertion utilities

1. **Implementation-Specific Tests**: Each adapter implementation has its own test file (e.g., `test_redis.py`, `test_infisical.py`) that:

   - Focuses on implementation-specific behavior
   - Uses fixtures and utilities from the base test file
   - Implements proper mock objects with method delegation

1. **Reusable Test Functions**: Where possible, test functions are designed to be reusable across different adapter implementations, like the `assert_cache_operations` function.

This organization allows for thorough testing of both the base adapter functionality and the specific implementation details of each adapter variant.

## Implementation Details

The `pytest_sessionfinish` function in `tests/conftest.py` has been modified to detect when tests are being run by crackerjack. It checks for the presence of the crackerjack module in `sys.modules` and for the `RUNNING_UNDER_CRACKERJACK` environment variable, and skips the aggressive process killing if either is detected.

This allows tests to run properly without being killed prematurely when using crackerjack.

## Testing with Crackerjack

[Crackerjack](https://github.com/lesleslie/crackerjack) is a tool that can be used to run tests with AI assistance. It's particularly useful for debugging failing tests and understanding test behavior.

### Basic Usage

To run tests with Crackerjack:

```bash
python -m crackerjack
```

Or if using UV:

```bash
uv run python -m crackerjack
```

### Using the AI Agent

The `--ai-fix` flag enables AI assistance when running tests:

```bash
python -m crackerjack --ai-fix
```

This will provide AI-powered analysis of test failures and suggestions for fixes.

### Showing Output with -s Flag

When running tests with Crackerjack, you can use the `-s` flag to show print statements and other output during test execution:

```bash
python -m crackerjack -s
```

You can combine this with the AI agent flag:

```bash
python -m crackerjack --ai-fix -s
```

### Running Specific Tests

Crackerjack accepts command line arguments for specific options, but doesn't directly accept test file paths like pytest does. Instead, it's typically run with specific flags for its automated workflow:

```bash
# Run with AI agent assistance
python -m crackerjack --ai-fix

# Show output during test execution
python -m crackerjack -s

# Run the full automated workflow (linting, testing, version bump, commit)
python -m crackerjack -x -t -p <version> -c

# Alternative automated workflow
python -m crackerjack -a <version>
```

To run specific tests, you should use pytest directly:

```bash
# Run tests in a specific directory
pytest tests/adapters/cache/

# Run a specific test file with output shown
pytest tests/adapters/cache/test_redis.py -s
```

### Benefits of Using Crackerjack

1. **AI-Assisted Debugging**: The AI agent can analyze test failures and suggest fixes
1. **Detailed Output**: Using the `-s` flag provides visibility into what's happening during test execution
1. **Compatible with ACB's Test Suite**: The test suite has been configured to work properly with Crackerjack

Remember that when using Crackerjack, the `pytest_sessionfinish` function in our test configuration will automatically detect it and adjust behavior accordingly.
