# Solana: We Are Waiting for the Next One

![img](./img/cover.jpg)

**Chapter 0**

- [Solana/We Are Waiting for the Next One](./content/foreword.md)

---

**Chapter 1**

- [Solana/Private Key, Public Key and Address/Introduction](./content/prikey_introduction.md)
- [Solana/Private Key, Public Key and Address/Private Key](./content/prikey_prikey.md)
- [Solana/Private Key, Public Key and Address/A Cryptographic Explanation of Private Key (Part 1)](./content/prikey_crypto_field.md)
- [Solana/Private Key, Public Key and Address/A Cryptographic Explanation of Private Key (Part 2)](./content/prikey_crypto_asymmetric.md)
- [Solana/Private Key, Public Key and Address/A Cryptographic Explanation of Private Key (Part 3)](./content/prikey_crypto_secp256k1.md)
- [Solana/Private Key, Public Key and Address/A Cryptographic Explanation of Private Key (Part 4)](./content/prikey_crypto_ecdsa.md)
- [Solana/Private Key, Public Key and Address/A Cryptographic Explanation of Private Key (Part 5)](./content/prikey_crypto_issue.md)
- [Solana/Private Key, Public Key and Address/A Cryptographic Explanation of Private Key (Part 6)](./content/prikey_crypto_ed25519.md)
- [Solana/Private Key, Public Key and Address/A Cryptographic Explanation of Private Key (Part 7)](./content/prikey_crypto_eddsa.md)
- [Solana/Private Key, Public Key and Address/A Cryptographic Explanation of Private Key (Part 8)](./content/prikey_crypto_eddsa_advantages.md)
- [Solana/Private Key, Public Key and Address/Public Key](./content/prikey_pubkey.md)
- [Solana/Private Key, Public Key and Address/Address](./content/prikey_addr.md)
- [Solana/Private Key, Public Key and Address/Address Spoofing Attack and Vanity Address](./content/prikey_vanity.md)
- [Solana/Private Key, Public Key and Address/Base58](./content/prikey_base58.md)
- [Solana/Private Key, Public Key and Address/Keypair](./content/prikey_keypair.md)

---

**Chapter 2**

- [Solana/Transactions/Introduction](./content/tx_introduction.md)
- [Solana/Transactions/Currency Denomination](./content/tx_denomination.md)
- [Solana/Transactions/Building a Local Development Environment](./content/tx_devnet.md)
- [Solana/Transactions/Using Built-in Wallet for Transfers](./content/tx_wallet.md)
- [Solana/Transactions/Transaction Detail](./content/tx_info.md)
- [Solana/Transactions/Signing and Verification](./content/tx_signature.md)
- [Solana/Transactions/Serialization and Deserialization](./content/tx_serialize.md)
- [Solana/Transactions/Account and Permission](./content/tx_permission.md)
- [Solana/Transactions/Block Hash and Timeliness](./content/tx_recent_blockhash.md)
- [Solana/Transactions/Instruction](./content/tx_instruction.md)
- [Solana/Transactions/System Program](./content/tx_system_program.md)
- [Solana/Transactions/Manually Constructing a Transaction](./content/tx_handmade.md)
- [Solana/Transactions/Transaction Fee](./content/tx_fee.md)

---

**Chapter 3**

- [Solana/Account Model/Introduction](./content/account_introduction.md)
- [Solana/Account Model/Account Data Structure](./content/account_type.md)
- [Solana/Account Model/UTXO vs Account-Based Models](./content/account_utxo_vs_account.md)
- [Solana/Account Model/Ownership and Access Control](./content/account_owner.md)
- [Solana/Account Model/Regular Accounts](./content/account_wallet.md)
- [Solana/Account Model/Program Accounts](./content/account_program.md)
- [Solana/Account Model/Data Accounts](./content/account_data.md)
- [Solana/Account Model/Program Derived Addresses](./content/account_pda.md)
- [Solana/Account Model/Rent and Rent Exemption Mechanism](./content/account_rent.md)
- [Solana/Account Model/Unexplored Issues](./content/account_epilog.md)

---

**Chapter 4**

- [Solana/Program Development Basics/Introduction](./content/ss_introduction.md)
- [Solana/Program Development Basics/Setting Up the Rust Development Environment](./content/ss_rust_env.md)
- [Solana/Program Development Basics/An On-Chain Program for Users to Store Arbitrary Data](./content/ss_requirement.md)
- [Solana/Program Development Basics/Setting Up the Initial Project Structure](./content/ss_skeleton.md)
- [Solana/Program Development Basics/Entry Point Explanation](./content/ss_entrypoint.md)
- [Solana/Program Development Basics/Creating a Data Account with Rent-Exemption](./content/ss_pda_create.md)
- [Solana/Program Development Basics/Updating Data Accounts and Dynamic Rent Adjustment](./content/ss_pda_update.md)
- [Solana/Program Development Basics/Complete Code](./content/ss_code.md)
- [Solana/Program Development Basics/Compiling and Deploying the Program](./content/ss_deploy.md)
- [Solana/Program Development Basics/Program Interaction](./content/ss_interaction.md)
- [Solana/Program Development Basics/Upgrading Programs](./content/ss_upgrade.md)
- [Solana/Program Development Basics/Get Complete Repo from Github](./content/ss_github.md)

---

**Chapter 5**

- [Solana/Thai Baht Coin/Introduction](./content/thaibaht_introduction.md)
- [Solana/Thai Baht Coin/Evolution](./content/thaibaht_evolution.md)
- [Solana/Thai Baht Coin/Core Mechanism Implementation](./content/thaibaht_core.md)
- [Solana/Thai Baht Coin/Complete Code](./content/thaibaht_code.md)
- [Solana/Thai Baht Coin/Program Interaction](./content/thaibaht_interaction.md)
- [Solana/Thai Baht Coin/Get Complete Repo from Github](./content/thaibaht_github.md)

---

**Chapter 6**

- [Solana/SPL Token/Introduction](./content/spl_introduction.md)
- [Solana/SPL Token/History and Core Specification Overview](./content/spl_spec.md)
- [Solana/SPL Token/Create Your Token](./content/spl_create.md)
- [Solana/SPL Token/Analyzing the Mint Account](./content/spl_mint_account.md)
- [Solana/SPL Token/Minting Tokens and Querying Balances](./content/spl_mint.md)
- [Solana/SPL Token/Transfers](./content/spl_transfer.md)
- [Solana/SPL Token/Instruction Deep Dive (Part 1)](./content/spl_detail_create.md)
- [Solana/SPL Token/Instruction Deep Dive (Part 2)](./content/spl_detail_mint.md)
- [Solana/SPL Token/Instruction Deep Dive (Part 3)](./content/spl_detail_transfer.md)
- [Solana/SPL Token/Epilogue](./content/spl_epilog.md)

---

**Chapter 7**

- [Solana/Deploying Your Token on the Mainnet/Introduction](./content/project_introduction.md)
- [Solana/Deploying Your Token on the Mainnet/Migrating from Testnet to Mainnet](./content/project_mainnet.md)
- [Solana/Deploying Your Token on the Mainnet/Deploying Your Token on the Mainnet](./content/project_deploy.md)
- [Solana/Deploying Your Token on the Mainnet/Listing on a Decentralized Exchange](./content/project_raydium.md)
- [Solana/Deploying Your Token on the Mainnet/Designing Airdrop Rules](./content/project_rule.md)
- [Solana/Deploying Your Token on the Mainnet/Program-Controlled Tokens](./content/project_control_by_program.md)
- [Solana/Deploying Your Token on the Mainnet/Implementing the Airdrop Program](./content/project_code.md)
- [Solana/Deploying Your Token on the Mainnet/Claiming the Airdrop](./content/project_airdrop.md)
- [Solana/Deploying Your Token on the Mainnet/Get Complete Repo from Github](./content/project_github.md)

---

**Chapter 8**

- [Solana/Economic System/Introduction](./content/economy_introduction.md)
- [Solana/Economic System/Typical Case Analysis](./content/economy_typical_case.md)
- [Solana/Economic System/Overview](./content/economy_overview.md)
- [Solana/Economic System/Genesis Block (Part 1)](./content/economy_genesis_data.md)
- [Solana/Economic System/Genesis Block (Part 2)](./content/economy_genesis_analysis.md)
- [Solana/Economic System/Inflation Rewards](./content/economy_inflation.md)
- [Solana/Economic System/Transaction Fees and Fee Burning](./content/economy_fee.md)
- [Solana/Economic System/Validator Costs and Expected Returns](./content/economy_validator.md)
- [Solana/Economic System/Staking](./content/economy_stake.md)
- [Solana/Economic System/Controversies in Community Governance](./content/economy_governance.md)

---

**Chapter 9**

- [Solana/More Developer Tools/Introduction](./content/tool_introduction.md)
- [Solana/More Developer Tools/Setting Up the Anchor Environment](./content/tool_anchor_install.md)
- [Solana/More Developer Tools/A Simple Data-Storage Program in Anchor](./content/tool_anchor_ss.md)
- [Solana/More Developer Tools/The Anchor Testing Framework](./content/tool_anchor_test.md)
- [Solana/More Developer Tools/Pinocchio? Pinocchio!](./content/tool_pinocchio.md)
- [Solana/More Developer Tools/Rewriting the Simple Data Storage Program with Pinocchio](./content/tool_pinocchio_ss.md)
- [Solana/More Developer Tools/web3.js Quick Start](./content/tool_web3.md)
- [Solana/More Developer Tools/Common Pitfalls and Workarounds in web3.js](./content/tool_web3_pitfall.md)
- [Solana/More Developer Tools/Using solana-py Together with the solders Library](./content/tool_solana_py.md)
