# Solana/Economic System/Controversies in Community Governance

In this article, I want to primarily discuss some exploratory questions. These questions will not have standard answers.

During Solana's rapid development, its economic system has gradually exposed some structural issues, particularly in inflation mechanisms and staking incentives. This article will analyze the main controversial points in Solana's economic system, especially discussions around the SIMD-0228 proposal and the community's governance dynamics regarding inflation rates and staking ratios.

## Core Controversies

**High Inflation's Dilution Effect on Non-Stakers**

Solana's current nominal inflation rate is 4.3%, but since the staking rate is only 65%, the actual annualized yield for stakers is approximately 6.61%, meaning non-stakers' token holdings are diluted by about 6.61% annually. This high inflation rate creates significant economic pressure on non-stakers and may affect their willingness to continue holding SOL.

A 65% staking rate is actually unhealthy. Two-thirds of SOL holders have staked their assets to earn interest returns, which significantly reduces the amount of SOL circulating in the market, making the market structure fragile.

**Validators' Dependence on Inflation Rewards**

Validators' revenue comes almost entirely from inflation rewards rather than transaction fees generated by normal network operations. Currently, I believe validators' dependence on inflation rewards is still increasing. As staking rates rise and inflation rates decline in the future, this may lead to reduced validator income, subsequently causing a decrease in validator numbers and affecting network security and decentralization.

## The Rejected SIMD-0228 Proposal: Dynamic Inflation Mechanism

To address the above issues, the Solana community proposed SIMD-0228 in March 2025, aiming to introduce a dynamic inflation mechanism.

**This proposal had the highest participation rate in Solana's history, approaching 50% of total token supply, but the final vote rejected the proposal, with opposition winning by a narrow margin.**

The proposal was led by Tushar Jain and Vishal Kankani from Multicoin Capital, with supporters including Max Resnick, chief economist at Anza. Since the proposal failed to pass, you can only find its specific content in the GitHub pull request: <https://github.com/solana-foundation/solana-improvement-documents/pull/228>.

The proposal's core content was to link SOL's annual inflation rate to the staking rate:

- When the staking rate exceeds 50%, inflation rate decreases;
- When the staking rate falls below 50%, inflation rate increases.

Although the SIMD-0228 proposal aimed to optimize Solana's economic model, there were different opinions within the community. Supporters believed the dynamic inflation mechanism could reduce SOL's inflation rate, enhance its value stability, and attract more DeFi capital inflow. Opponents argued that market-based feedback adjustment mechanisms could create a "death spiral" - forming a vicious cycle of "inflation-selling-more inflation" that would ultimately affect network security.

## Inequality in Voting Rights in Community Governance

The discussions sparked by the SIMD-0228 proposal marked an important step for the Solana community in economic governance. Although the proposal ultimately failed, the discussions it generated prompted the community to pay more attention to the balance between inflation mechanisms, staking incentives, and network security. However, while tracking this event, the author also discovered structural problems in community governance.

In Solana's community governance model, voting rights distribution is unequal. Stakers can only participate in voting through their delegated validators, while validators exercise voting rights on behalf of their stakers. Validators' voting weight is typically proportional to the amount of SOL they stake, and stakers participate indirectly in voting by delegating their SOL to validators. This mechanism leads to the following problems:

- The vast majority of stakers only care about staking yields and don't care about their delegated validator's views on proposals. Therefore, before important votes, validators can artificially inflate staking yields through "subsidies" to bribe stakers and attract more funds to expand their voting power. Even worse, some validators decide voting directions on their own without communicating with stakers before important votes. For example, in the SIMD-0228 vote, multiple leading validators directly voted for or against without any communication with their stakers.
- Large holders possess substantial tokens and excessive voting power, influencing project development direction. For most people, they only focus on their own interests while ignoring the network's overall healthy development.

## Not the End

Despite various controversies and imperfections, this is precisely the key factor in Solana's continuous growth and adaptation to market changes. The most frightening thing in this world is not having opposing opinions, but having no opposing opinions at all. Through continuous discussion and debate, the community can identify problems, explore solutions, and drive the project forward. The discussion around SIMD-0228 is just one chapter in Solana's economic governance journey.

In the future, I hope to see more innovation in governance mechanisms within the Solana community to ensure all token holders' voices can be heard fairly. This might include introducing more transparent voting processes, increasing staker participation, and exploring new economic incentive mechanisms.
