# Solana/Transactions/Building a Local Development Environment

Transactions are one of the most core components of the Solana system. In this section, we will dive deep into the various transaction forms in Solana, including how to create transactions, sign them, and send them to validators to become a permanent part of Solana's transaction record.

Executing transactions on the blockchain requires paying fees, and testing on the mainnet can be costly. Therefore, setting up a local Solana test validator is crucial for development and testing. This article will provide a detailed guide on how to set up a local Solana test validator and obtain SOL airdrops for your account to use in testing and development.

## Get the Official Solana Release Package

On March 2, 2024, Solana underwent a significant personnel change: the development of the Solana client was transferred from Solana Labs to the Anza team. This team forked Solana's source code, and all subsequent development has been carried out in the new forked repository.

You can learn more about the details through recent news articles: <https://solana.com/news/solana-labs-anza-fork>.

This change led to the original Solana repository becoming obsolete, while the new repository is named Agave. Therefore, the official repository URL for Solana is now: <https://github.com/anza-xyz/agave>.

On the release page of this repository, locate the binary release package, download it, and unzip it. For example, on an Ubuntu system, you can use the following commands to complete the process:

```sh
$ wget https://github.com/anza-xyz/agave/releases/download/v2.0.20/solana-release-x86_64-unknown-linux-gnu.tar.bz2
$ tar -xvf solana-release-x86_64-unknown-linux-gnu.tar.bz2
$ cd solana-release
```

Note: At the time of writing, the latest version of Agave is v2.0.20, but it may not be the latest version. Please always choose the version displayed on the release page.

After installation is complete, you can check if Solana has been successfully installed using the following command:

```sh
$ solana --version
# solana-cli 2.0.20 (src:20a8749f; feat:607245837, client:Agave)
```

If the solana version information is displayed, it means the installation is successful.

## Run a local validator

Solana provides a tool called "solana-test-validator" that allows us to launch a local Solana test validator. Run the following command to start it:

```sh
$ solana-test-validator
```

This command will launch a local Solana blockchain instance, which, by default, provides an API interface on port 8899. You should see output similar to the following, indicating that the local chain is running:

```sh
# Identity: H3SmeomgugZP3AYzgeLuL9ZfHQrUWahFBkzeiwdzCmaE
# Genesis Hash: B1Kc8gnygWEW6ZXxV4STaheM9WAWNYqukTLuxoiCWjUX
# Version: 2.0.20
# Shred Version: 57683
# Gossip Address: 127.0.0.1:1024
# TPU Address: 127.0.0.1:1027
# JSON RPC URL: http://127.0.0.1:8899
# WebSocket PubSub URL: ws://127.0.0.1:8900
```

## Configure the Solana Command-Line Tool

To enable the Solana command-line tool to interact with the test validator, you need to configure it first. Run the following command:

```sh
$ solana config set --url http://localhost:8899
```

## Create a Solana Wallet

Execute the following command:

```sh
$ solana-keygen new
```

This will generate a new keypair and save it to the ~/.config/solana/id.json file. You can view the public key of this account with the following command:

```sh
$ solana address
# 6ASf5EcmmEHTgDJ4X4ZT5vT6iHVJBXPg5AN5YoTCpGWt
```

Q: The wallet created this way is random, and the private keys and addresses generated will differ between users. Recalling the content from Chapter 1, if you want the Solana command-line tool to use an account with a private key of 0x01, how would you proceed?

A: The id.json file stores the account's public-private keypair. We can edit ~/.config/solana/id.json and replace its contents with the target public-private keypair generated by the following code:

```py
import pxsol

prikey = pxsol.core.PriKey.int_decode(0x01)
pubkey = prikey.pubkey()
print(list(prikey.p + pubkey.p))
```

## Get Solana Test Coins

On the test validator, you can provide some test coins to your wallet account by requesting an airdrop of SOL. Use the following command to get the airdrop SOL for your account:

```sh
$ solana airdrop 10
```

This command will airdrop 10 SOL to the currently configured account. If you need more SOL, you can adjust the number, for example:

```sh
$ solana airdrop 100
```

You can also airdrop to a specific account by adding the target address as a parameter, for example:

```sh
$ solana airdrop 10 6ASf5EcmmEHTgDJ4X4ZT5vT6iHVJBXPg5AN5YoTCpGWt
```

You can check the account balance to confirm whether the airdrop was successful with the following command:

```sh
$ solana balance
```

If everything goes smoothly, you'll see that the account now has the airdropped SOL.

## Notes

0. The test validator consumes a certain amount of memory, CPU, and disk space. Running it continuously for 24 hours may take up about 8 GB of disk space, so plan accordingly.
0. Data on the test validator may not persist; after a restart, you'll need to request airdrops again. However, you won't need to recreate the account.
0. If you want to switch back to the mainnet or another network (e.g., devnet), you can use `solana config set --url <URL>` to switch, for example: `solana config set --url https://api.devnet.solana.com`

## Ready to Go

At this point, you have successfully set up a test validator and airdropped SOL test coins to your account.

Next up is…
