# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReleaseArgs', 'Release']

@pulumi.input_type
class ReleaseArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[_builtins.str],
                 tag_name: pulumi.Input[_builtins.str],
                 assets: Optional[pulumi.Input['ReleaseAssetsArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 milestones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 ref: Optional[pulumi.Input[_builtins.str]] = None,
                 released_at: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_message: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Release resource.
        :param pulumi.Input[_builtins.str] project: The ID or full path of the project.
        :param pulumi.Input[_builtins.str] tag_name: The tag where the release is created from.
        :param pulumi.Input['ReleaseAssetsArgs'] assets: The release assets.
        :param pulumi.Input[_builtins.str] description: The description of the release. You can use Markdown.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] milestones: The title of each milestone the release is associated with. GitLab Premium customers can specify group milestones.
        :param pulumi.Input[_builtins.str] name: The name of the release.
        :param pulumi.Input[_builtins.str] ref: If a tag specified in tag*name doesn't exist, the release is created from ref and tagged with tag*name. It can be a commit SHA, another tag name, or a branch name.
        :param pulumi.Input[_builtins.str] released_at: Date and time for the release. Defaults to the current time. Expected in ISO 8601 format (2019-03-15T08:00:00Z). Only provide this field if creating an upcoming or historical release.
        :param pulumi.Input[_builtins.str] tag_message: Message to use if creating a new annotated tag.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "tag_name", tag_name)
        if assets is not None:
            pulumi.set(__self__, "assets", assets)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if milestones is not None:
            pulumi.set(__self__, "milestones", milestones)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ref is not None:
            pulumi.set(__self__, "ref", ref)
        if released_at is not None:
            pulumi.set(__self__, "released_at", released_at)
        if tag_message is not None:
            pulumi.set(__self__, "tag_message", tag_message)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The ID or full path of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> pulumi.Input[_builtins.str]:
        """
        The tag where the release is created from.
        """
        return pulumi.get(self, "tag_name")

    @tag_name.setter
    def tag_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tag_name", value)

    @_builtins.property
    @pulumi.getter
    def assets(self) -> Optional[pulumi.Input['ReleaseAssetsArgs']]:
        """
        The release assets.
        """
        return pulumi.get(self, "assets")

    @assets.setter
    def assets(self, value: Optional[pulumi.Input['ReleaseAssetsArgs']]):
        pulumi.set(self, "assets", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the release. You can use Markdown.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def milestones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The title of each milestone the release is associated with. GitLab Premium customers can specify group milestones.
        """
        return pulumi.get(self, "milestones")

    @milestones.setter
    def milestones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "milestones", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the release.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If a tag specified in tag*name doesn't exist, the release is created from ref and tagged with tag*name. It can be a commit SHA, another tag name, or a branch name.
        """
        return pulumi.get(self, "ref")

    @ref.setter
    def ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ref", value)

    @_builtins.property
    @pulumi.getter(name="releasedAt")
    def released_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time for the release. Defaults to the current time. Expected in ISO 8601 format (2019-03-15T08:00:00Z). Only provide this field if creating an upcoming or historical release.
        """
        return pulumi.get(self, "released_at")

    @released_at.setter
    def released_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "released_at", value)

    @_builtins.property
    @pulumi.getter(name="tagMessage")
    def tag_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Message to use if creating a new annotated tag.
        """
        return pulumi.get(self, "tag_message")

    @tag_message.setter
    def tag_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_message", value)


@pulumi.input_type
class _ReleaseState:
    def __init__(__self__, *,
                 assets: Optional[pulumi.Input['ReleaseAssetsArgs']] = None,
                 author: Optional[pulumi.Input['ReleaseAuthorArgs']] = None,
                 commit: Optional[pulumi.Input['ReleaseCommitArgs']] = None,
                 commit_path: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 description_html: Optional[pulumi.Input[_builtins.str]] = None,
                 links: Optional[pulumi.Input['ReleaseLinksArgs']] = None,
                 milestones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 ref: Optional[pulumi.Input[_builtins.str]] = None,
                 released_at: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_message: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_path: Optional[pulumi.Input[_builtins.str]] = None,
                 upcoming_release: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Release resources.
        :param pulumi.Input['ReleaseAssetsArgs'] assets: The release assets.
        :param pulumi.Input['ReleaseAuthorArgs'] author: The author of the release.
        :param pulumi.Input['ReleaseCommitArgs'] commit: The release commit.
        :param pulumi.Input[_builtins.str] commit_path: The path to the commit
        :param pulumi.Input[_builtins.str] created_at: Date and time the release was created. In ISO 8601 format (2019-03-15T08:00:00Z).
        :param pulumi.Input[_builtins.str] description: The description of the release. You can use Markdown.
        :param pulumi.Input[_builtins.str] description_html: HTML rendered Markdown of the release description.
        :param pulumi.Input['ReleaseLinksArgs'] links: Links of the release
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] milestones: The title of each milestone the release is associated with. GitLab Premium customers can specify group milestones.
        :param pulumi.Input[_builtins.str] name: The name of the release.
        :param pulumi.Input[_builtins.str] project: The ID or full path of the project.
        :param pulumi.Input[_builtins.str] ref: If a tag specified in tag*name doesn't exist, the release is created from ref and tagged with tag*name. It can be a commit SHA, another tag name, or a branch name.
        :param pulumi.Input[_builtins.str] released_at: Date and time for the release. Defaults to the current time. Expected in ISO 8601 format (2019-03-15T08:00:00Z). Only provide this field if creating an upcoming or historical release.
        :param pulumi.Input[_builtins.str] tag_message: Message to use if creating a new annotated tag.
        :param pulumi.Input[_builtins.str] tag_name: The tag where the release is created from.
        :param pulumi.Input[_builtins.str] tag_path: The path to the tag.
        :param pulumi.Input[_builtins.bool] upcoming_release: Whether the release_at attribute is set to a future date.
        """
        if assets is not None:
            pulumi.set(__self__, "assets", assets)
        if author is not None:
            pulumi.set(__self__, "author", author)
        if commit is not None:
            pulumi.set(__self__, "commit", commit)
        if commit_path is not None:
            pulumi.set(__self__, "commit_path", commit_path)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if description_html is not None:
            pulumi.set(__self__, "description_html", description_html)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if milestones is not None:
            pulumi.set(__self__, "milestones", milestones)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if ref is not None:
            pulumi.set(__self__, "ref", ref)
        if released_at is not None:
            pulumi.set(__self__, "released_at", released_at)
        if tag_message is not None:
            pulumi.set(__self__, "tag_message", tag_message)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)
        if tag_path is not None:
            pulumi.set(__self__, "tag_path", tag_path)
        if upcoming_release is not None:
            pulumi.set(__self__, "upcoming_release", upcoming_release)

    @_builtins.property
    @pulumi.getter
    def assets(self) -> Optional[pulumi.Input['ReleaseAssetsArgs']]:
        """
        The release assets.
        """
        return pulumi.get(self, "assets")

    @assets.setter
    def assets(self, value: Optional[pulumi.Input['ReleaseAssetsArgs']]):
        pulumi.set(self, "assets", value)

    @_builtins.property
    @pulumi.getter
    def author(self) -> Optional[pulumi.Input['ReleaseAuthorArgs']]:
        """
        The author of the release.
        """
        return pulumi.get(self, "author")

    @author.setter
    def author(self, value: Optional[pulumi.Input['ReleaseAuthorArgs']]):
        pulumi.set(self, "author", value)

    @_builtins.property
    @pulumi.getter
    def commit(self) -> Optional[pulumi.Input['ReleaseCommitArgs']]:
        """
        The release commit.
        """
        return pulumi.get(self, "commit")

    @commit.setter
    def commit(self, value: Optional[pulumi.Input['ReleaseCommitArgs']]):
        pulumi.set(self, "commit", value)

    @_builtins.property
    @pulumi.getter(name="commitPath")
    def commit_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the commit
        """
        return pulumi.get(self, "commit_path")

    @commit_path.setter
    def commit_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commit_path", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time the release was created. In ISO 8601 format (2019-03-15T08:00:00Z).
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the release. You can use Markdown.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="descriptionHtml")
    def description_html(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        HTML rendered Markdown of the release description.
        """
        return pulumi.get(self, "description_html")

    @description_html.setter
    def description_html(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description_html", value)

    @_builtins.property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input['ReleaseLinksArgs']]:
        """
        Links of the release
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input['ReleaseLinksArgs']]):
        pulumi.set(self, "links", value)

    @_builtins.property
    @pulumi.getter
    def milestones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The title of each milestone the release is associated with. GitLab Premium customers can specify group milestones.
        """
        return pulumi.get(self, "milestones")

    @milestones.setter
    def milestones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "milestones", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the release.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID or full path of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def ref(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If a tag specified in tag*name doesn't exist, the release is created from ref and tagged with tag*name. It can be a commit SHA, another tag name, or a branch name.
        """
        return pulumi.get(self, "ref")

    @ref.setter
    def ref(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ref", value)

    @_builtins.property
    @pulumi.getter(name="releasedAt")
    def released_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time for the release. Defaults to the current time. Expected in ISO 8601 format (2019-03-15T08:00:00Z). Only provide this field if creating an upcoming or historical release.
        """
        return pulumi.get(self, "released_at")

    @released_at.setter
    def released_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "released_at", value)

    @_builtins.property
    @pulumi.getter(name="tagMessage")
    def tag_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Message to use if creating a new annotated tag.
        """
        return pulumi.get(self, "tag_message")

    @tag_message.setter
    def tag_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_message", value)

    @_builtins.property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tag where the release is created from.
        """
        return pulumi.get(self, "tag_name")

    @tag_name.setter
    def tag_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_name", value)

    @_builtins.property
    @pulumi.getter(name="tagPath")
    def tag_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path to the tag.
        """
        return pulumi.get(self, "tag_path")

    @tag_path.setter
    def tag_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_path", value)

    @_builtins.property
    @pulumi.getter(name="upcomingRelease")
    def upcoming_release(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the release_at attribute is set to a future date.
        """
        return pulumi.get(self, "upcoming_release")

    @upcoming_release.setter
    def upcoming_release(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "upcoming_release", value)


@pulumi.type_token("gitlab:index/release:Release")
class Release(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assets: Optional[pulumi.Input[Union['ReleaseAssetsArgs', 'ReleaseAssetsArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 milestones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 ref: Optional[pulumi.Input[_builtins.str]] = None,
                 released_at: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_message: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The `Release` resource allows to manage the lifecycle of releases in gitlab.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/releases/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        # Create a project
        example = gitlab.Project("example",
            name="example",
            description="An example project")
        # Create a release
        example_release = gitlab.Release("example",
            project=example.id,
            name="test-release",
            tag_name="v1.0.0",
            description="Test release description",
            ref="main")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_release`. For example:

        terraform

        import {

          to = gitlab_release.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        Gitlab release link can be imported with a key composed of `<project>:<tag_name>`, e.g.

        ```sh
        $ pulumi import gitlab:index/release:Release example "12345:test"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ReleaseAssetsArgs', 'ReleaseAssetsArgsDict']] assets: The release assets.
        :param pulumi.Input[_builtins.str] description: The description of the release. You can use Markdown.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] milestones: The title of each milestone the release is associated with. GitLab Premium customers can specify group milestones.
        :param pulumi.Input[_builtins.str] name: The name of the release.
        :param pulumi.Input[_builtins.str] project: The ID or full path of the project.
        :param pulumi.Input[_builtins.str] ref: If a tag specified in tag*name doesn't exist, the release is created from ref and tagged with tag*name. It can be a commit SHA, another tag name, or a branch name.
        :param pulumi.Input[_builtins.str] released_at: Date and time for the release. Defaults to the current time. Expected in ISO 8601 format (2019-03-15T08:00:00Z). Only provide this field if creating an upcoming or historical release.
        :param pulumi.Input[_builtins.str] tag_message: Message to use if creating a new annotated tag.
        :param pulumi.Input[_builtins.str] tag_name: The tag where the release is created from.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReleaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `Release` resource allows to manage the lifecycle of releases in gitlab.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/releases/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        # Create a project
        example = gitlab.Project("example",
            name="example",
            description="An example project")
        # Create a release
        example_release = gitlab.Release("example",
            project=example.id,
            name="test-release",
            tag_name="v1.0.0",
            description="Test release description",
            ref="main")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_release`. For example:

        terraform

        import {

          to = gitlab_release.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        Gitlab release link can be imported with a key composed of `<project>:<tag_name>`, e.g.

        ```sh
        $ pulumi import gitlab:index/release:Release example "12345:test"
        ```

        :param str resource_name: The name of the resource.
        :param ReleaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReleaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assets: Optional[pulumi.Input[Union['ReleaseAssetsArgs', 'ReleaseAssetsArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 milestones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 ref: Optional[pulumi.Input[_builtins.str]] = None,
                 released_at: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_message: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReleaseArgs.__new__(ReleaseArgs)

            __props__.__dict__["assets"] = assets
            __props__.__dict__["description"] = description
            __props__.__dict__["milestones"] = milestones
            __props__.__dict__["name"] = name
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["ref"] = ref
            __props__.__dict__["released_at"] = released_at
            __props__.__dict__["tag_message"] = tag_message
            if tag_name is None and not opts.urn:
                raise TypeError("Missing required property 'tag_name'")
            __props__.__dict__["tag_name"] = tag_name
            __props__.__dict__["author"] = None
            __props__.__dict__["commit"] = None
            __props__.__dict__["commit_path"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["description_html"] = None
            __props__.__dict__["links"] = None
            __props__.__dict__["tag_path"] = None
            __props__.__dict__["upcoming_release"] = None
        super(Release, __self__).__init__(
            'gitlab:index/release:Release',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assets: Optional[pulumi.Input[Union['ReleaseAssetsArgs', 'ReleaseAssetsArgsDict']]] = None,
            author: Optional[pulumi.Input[Union['ReleaseAuthorArgs', 'ReleaseAuthorArgsDict']]] = None,
            commit: Optional[pulumi.Input[Union['ReleaseCommitArgs', 'ReleaseCommitArgsDict']]] = None,
            commit_path: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            description_html: Optional[pulumi.Input[_builtins.str]] = None,
            links: Optional[pulumi.Input[Union['ReleaseLinksArgs', 'ReleaseLinksArgsDict']]] = None,
            milestones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            ref: Optional[pulumi.Input[_builtins.str]] = None,
            released_at: Optional[pulumi.Input[_builtins.str]] = None,
            tag_message: Optional[pulumi.Input[_builtins.str]] = None,
            tag_name: Optional[pulumi.Input[_builtins.str]] = None,
            tag_path: Optional[pulumi.Input[_builtins.str]] = None,
            upcoming_release: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Release':
        """
        Get an existing Release resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ReleaseAssetsArgs', 'ReleaseAssetsArgsDict']] assets: The release assets.
        :param pulumi.Input[Union['ReleaseAuthorArgs', 'ReleaseAuthorArgsDict']] author: The author of the release.
        :param pulumi.Input[Union['ReleaseCommitArgs', 'ReleaseCommitArgsDict']] commit: The release commit.
        :param pulumi.Input[_builtins.str] commit_path: The path to the commit
        :param pulumi.Input[_builtins.str] created_at: Date and time the release was created. In ISO 8601 format (2019-03-15T08:00:00Z).
        :param pulumi.Input[_builtins.str] description: The description of the release. You can use Markdown.
        :param pulumi.Input[_builtins.str] description_html: HTML rendered Markdown of the release description.
        :param pulumi.Input[Union['ReleaseLinksArgs', 'ReleaseLinksArgsDict']] links: Links of the release
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] milestones: The title of each milestone the release is associated with. GitLab Premium customers can specify group milestones.
        :param pulumi.Input[_builtins.str] name: The name of the release.
        :param pulumi.Input[_builtins.str] project: The ID or full path of the project.
        :param pulumi.Input[_builtins.str] ref: If a tag specified in tag*name doesn't exist, the release is created from ref and tagged with tag*name. It can be a commit SHA, another tag name, or a branch name.
        :param pulumi.Input[_builtins.str] released_at: Date and time for the release. Defaults to the current time. Expected in ISO 8601 format (2019-03-15T08:00:00Z). Only provide this field if creating an upcoming or historical release.
        :param pulumi.Input[_builtins.str] tag_message: Message to use if creating a new annotated tag.
        :param pulumi.Input[_builtins.str] tag_name: The tag where the release is created from.
        :param pulumi.Input[_builtins.str] tag_path: The path to the tag.
        :param pulumi.Input[_builtins.bool] upcoming_release: Whether the release_at attribute is set to a future date.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReleaseState.__new__(_ReleaseState)

        __props__.__dict__["assets"] = assets
        __props__.__dict__["author"] = author
        __props__.__dict__["commit"] = commit
        __props__.__dict__["commit_path"] = commit_path
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["description_html"] = description_html
        __props__.__dict__["links"] = links
        __props__.__dict__["milestones"] = milestones
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["ref"] = ref
        __props__.__dict__["released_at"] = released_at
        __props__.__dict__["tag_message"] = tag_message
        __props__.__dict__["tag_name"] = tag_name
        __props__.__dict__["tag_path"] = tag_path
        __props__.__dict__["upcoming_release"] = upcoming_release
        return Release(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def assets(self) -> pulumi.Output['outputs.ReleaseAssets']:
        """
        The release assets.
        """
        return pulumi.get(self, "assets")

    @_builtins.property
    @pulumi.getter
    def author(self) -> pulumi.Output['outputs.ReleaseAuthor']:
        """
        The author of the release.
        """
        return pulumi.get(self, "author")

    @_builtins.property
    @pulumi.getter
    def commit(self) -> pulumi.Output['outputs.ReleaseCommit']:
        """
        The release commit.
        """
        return pulumi.get(self, "commit")

    @_builtins.property
    @pulumi.getter(name="commitPath")
    def commit_path(self) -> pulumi.Output[_builtins.str]:
        """
        The path to the commit
        """
        return pulumi.get(self, "commit_path")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time the release was created. In ISO 8601 format (2019-03-15T08:00:00Z).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the release. You can use Markdown.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="descriptionHtml")
    def description_html(self) -> pulumi.Output[_builtins.str]:
        """
        HTML rendered Markdown of the release description.
        """
        return pulumi.get(self, "description_html")

    @_builtins.property
    @pulumi.getter
    def links(self) -> pulumi.Output['outputs.ReleaseLinks']:
        """
        Links of the release
        """
        return pulumi.get(self, "links")

    @_builtins.property
    @pulumi.getter
    def milestones(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The title of each milestone the release is associated with. GitLab Premium customers can specify group milestones.
        """
        return pulumi.get(self, "milestones")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the release.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID or full path of the project.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def ref(self) -> pulumi.Output[_builtins.str]:
        """
        If a tag specified in tag*name doesn't exist, the release is created from ref and tagged with tag*name. It can be a commit SHA, another tag name, or a branch name.
        """
        return pulumi.get(self, "ref")

    @_builtins.property
    @pulumi.getter(name="releasedAt")
    def released_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time for the release. Defaults to the current time. Expected in ISO 8601 format (2019-03-15T08:00:00Z). Only provide this field if creating an upcoming or historical release.
        """
        return pulumi.get(self, "released_at")

    @_builtins.property
    @pulumi.getter(name="tagMessage")
    def tag_message(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Message to use if creating a new annotated tag.
        """
        return pulumi.get(self, "tag_message")

    @_builtins.property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> pulumi.Output[_builtins.str]:
        """
        The tag where the release is created from.
        """
        return pulumi.get(self, "tag_name")

    @_builtins.property
    @pulumi.getter(name="tagPath")
    def tag_path(self) -> pulumi.Output[_builtins.str]:
        """
        The path to the tag.
        """
        return pulumi.get(self, "tag_path")

    @_builtins.property
    @pulumi.getter(name="upcomingRelease")
    def upcoming_release(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the release_at attribute is set to a future date.
        """
        return pulumi.get(self, "upcoming_release")

