# in10t-api-client
IN10T Client Data API

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install in10t-api-client
```
(you may need to run `pip` with root permission: `sudo pip install in10t-api-client`)

Then import the package:
```python
import in10t_api_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import in10t_api_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import in10t_api_client
from in10t_api_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: Bearer
configuration = in10t_api_client.Configuration()

# Set auth credentials
configuration.api_key["client_id"] = "YOUR_CLIENT_ID_HERE"
configuration.api_key["client_secret"] = "YOUR_CLIENT_SECRET_HERE"
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = in10t_api_client.DataApi(in10t_api_client.ApiClient(configuration))

page = 0 # int | The page of data to retrieve. (Starts at 0) (optional)
page_size = 500 # int | The page size for querying the data (Defaults to 500) (optional)
year = '2019'

try:
    # view harvest data from geodatabase
    harvest_api_response = api_instance.data_harvest(year=year, page=page, page_size=page_size)
    pprint(harvest_api_response)

    # view all processed harvest data from geodatabase
    processed_api_response = api_instance.processed_data_harvest(year=year, page=page, page_size=page_size)
    pprint(processed_api_response)
except ApiException as e:
    print("Exception when calling DataApi: %s\n" % e)


```

## Documentation for API Endpoints

All URIs are relative to *https://client.in10t.solutions/api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DataApi* | [**data_as_applied**](docs/DataApi.md#data_as_applied) | **GET** /data/as-applied | view all applied data from geodatabase
*DataApi* | [**data_harvest**](docs/DataApi.md#data_harvest) | **GET** /data/harvest | view all harvest data from geodatabase
*DataApi* | [**data_planting**](docs/DataApi.md#data_planting) | **GET** /data/planting | view all planting data from geodatabase
*DataApi* | [**processed_data_harvest**](docs/DataApi.md#processed_data_harvest) | **GET** /data/processed-harvest | view all processed harvest data from geodatabase
*SecurityApi* | [**token**](docs/SecurityApi.md#token) | **POST** /auth/token | create auth token
*ShapefileDataApi* | [**data_shapefile**](docs/ShapefileDataApi.md#data_shapefile) | **GET** /data/{type}/shapefile | 
*TrialsApi* | [**trial_list**](docs/TrialsApi.md#trial_list) | **GET** /trials | View a list of active trials.


## Documentation For Models

 - [AccessToken](docs/AccessToken.md)
 - [AsAppliedData](docs/AsAppliedData.md)
 - [AsAppliedDataItem](docs/AsAppliedDataItem.md)
 - [HarvestData](docs/HarvestData.md)
 - [HarvestDataItem](docs/HarvestDataItem.md)
 - [PlantingData](docs/PlantingData.md)
 - [PlantingDataItem](docs/PlantingDataItem.md)
 - [ProcessedHarvestData](docs/ProcessedHarvestData.md)
 - [ProcessedHarvestDataItem](docs/ProcessedHarvestDataItem.md)
 - [TokenCredentials](docs/TokenCredentials.md)


## Documentation For Authorization


## Bearer

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

matt@in10t.ag

