# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'ClusterAuthentication',
    'ClusterAuthenticationWebhook',
    'ClusterAuthorization',
    'ClusterBastionHost',
    'ClusterCertificate',
    'ClusterCloudProvider',
    'ClusterCloudProviderAwsCloudConfig',
    'ClusterCloudProviderAwsCloudConfigGlobal',
    'ClusterCloudProviderAwsCloudConfigServiceOverride',
    'ClusterCloudProviderAwsCloudProvider',
    'ClusterCloudProviderAwsCloudProviderGlobal',
    'ClusterCloudProviderAwsCloudProviderServiceOverride',
    'ClusterCloudProviderAzureCloudConfig',
    'ClusterCloudProviderAzureCloudProvider',
    'ClusterCloudProviderOpenstackCloudConfig',
    'ClusterCloudProviderOpenstackCloudConfigBlockStorage',
    'ClusterCloudProviderOpenstackCloudConfigGlobal',
    'ClusterCloudProviderOpenstackCloudConfigLoadBalancer',
    'ClusterCloudProviderOpenstackCloudConfigMetadata',
    'ClusterCloudProviderOpenstackCloudConfigRoute',
    'ClusterCloudProviderOpenstackCloudProvider',
    'ClusterCloudProviderOpenstackCloudProviderBlockStorage',
    'ClusterCloudProviderOpenstackCloudProviderGlobal',
    'ClusterCloudProviderOpenstackCloudProviderLoadBalancer',
    'ClusterCloudProviderOpenstackCloudProviderMetadata',
    'ClusterCloudProviderOpenstackCloudProviderRoute',
    'ClusterCloudProviderVsphereCloudConfig',
    'ClusterCloudProviderVsphereCloudConfigDisk',
    'ClusterCloudProviderVsphereCloudConfigGlobal',
    'ClusterCloudProviderVsphereCloudConfigNetwork',
    'ClusterCloudProviderVsphereCloudConfigVirtualCenter',
    'ClusterCloudProviderVsphereCloudConfigWorkspace',
    'ClusterCloudProviderVsphereCloudProvider',
    'ClusterCloudProviderVsphereCloudProviderDisk',
    'ClusterCloudProviderVsphereCloudProviderGlobal',
    'ClusterCloudProviderVsphereCloudProviderNetwork',
    'ClusterCloudProviderVsphereCloudProviderVirtualCenter',
    'ClusterCloudProviderVsphereCloudProviderWorkspace',
    'ClusterControlPlaneHost',
    'ClusterDns',
    'ClusterDnsNodelocal',
    'ClusterEtcdHost',
    'ClusterInactiveHost',
    'ClusterIngress',
    'ClusterMonitoring',
    'ClusterNetwork',
    'ClusterNetworkAciNetworkProvider',
    'ClusterNetworkCalicoNetworkProvider',
    'ClusterNetworkCanalNetworkProvider',
    'ClusterNetworkFlannelNetworkProvider',
    'ClusterNetworkWeaveNetworkProvider',
    'ClusterNode',
    'ClusterNodeTaint',
    'ClusterPrivateRegistry',
    'ClusterRestore',
    'ClusterRotateCertificates',
    'ClusterRunningSystemImages',
    'ClusterServices',
    'ClusterServicesEtcd',
    'ClusterServicesEtcdBackupConfig',
    'ClusterServicesEtcdBackupConfigS3BackupConfig',
    'ClusterServicesEtcdDeprecated',
    'ClusterServicesEtcdDeprecatedBackupConfig',
    'ClusterServicesEtcdDeprecatedBackupConfigS3BackupConfig',
    'ClusterServicesKubeApi',
    'ClusterServicesKubeApiAuditLog',
    'ClusterServicesKubeApiAuditLogConfiguration',
    'ClusterServicesKubeApiDeprecated',
    'ClusterServicesKubeApiDeprecatedAuditLog',
    'ClusterServicesKubeApiDeprecatedAuditLogConfiguration',
    'ClusterServicesKubeApiDeprecatedEventRateLimit',
    'ClusterServicesKubeApiDeprecatedSecretsEncryptionConfig',
    'ClusterServicesKubeApiEventRateLimit',
    'ClusterServicesKubeApiSecretsEncryptionConfig',
    'ClusterServicesKubeController',
    'ClusterServicesKubeControllerDeprecated',
    'ClusterServicesKubeProxyDeprecated',
    'ClusterServicesKubeSchedulerDeprecated',
    'ClusterServicesKubelet',
    'ClusterServicesKubeletDeprecated',
    'ClusterServicesKubeproxy',
    'ClusterServicesScheduler',
    'ClusterSystemImages',
    'ClusterUpgradeStrategy',
    'ClusterUpgradeStrategyDrainInput',
    'ClusterWorkerHost',
]

@pulumi.output_type
class ClusterAuthentication(dict):
    def __init__(__self__, *,
                 sans: Optional[Sequence[str]] = None,
                 strategy: Optional[str] = None,
                 webhook: Optional['outputs.ClusterAuthenticationWebhook'] = None):
        """
        :param Sequence[str] sans: List of additional hostnames and IPs to include in the api server PKI cert (list)
        :param str strategy: Authentication strategy that will be used in RKE k8s cluster. Default: `x509` (string)
        :param 'ClusterAuthenticationWebhookArgs' webhook: Webhook configuration options (list maxitem: 1)
        """
        if sans is not None:
            pulumi.set(__self__, "sans", sans)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)
        if webhook is not None:
            pulumi.set(__self__, "webhook", webhook)

    @property
    @pulumi.getter
    def sans(self) -> Optional[Sequence[str]]:
        """
        List of additional hostnames and IPs to include in the api server PKI cert (list)
        """
        return pulumi.get(self, "sans")

    @property
    @pulumi.getter
    def strategy(self) -> Optional[str]:
        """
        Authentication strategy that will be used in RKE k8s cluster. Default: `x509` (string)
        """
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter
    def webhook(self) -> Optional['outputs.ClusterAuthenticationWebhook']:
        """
        Webhook configuration options (list maxitem: 1)
        """
        return pulumi.get(self, "webhook")


@pulumi.output_type
class ClusterAuthenticationWebhook(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheTimeout":
            suggest = "cache_timeout"
        elif key == "configFile":
            suggest = "config_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAuthenticationWebhook. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAuthenticationWebhook.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAuthenticationWebhook.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cache_timeout: Optional[str] = None,
                 config_file: Optional[str] = None):
        """
        :param str cache_timeout: Controls how long to cache authentication decisions (string)
        :param str config_file: Multiline string that represent a custom webhook config file (string)
        """
        if cache_timeout is not None:
            pulumi.set(__self__, "cache_timeout", cache_timeout)
        if config_file is not None:
            pulumi.set(__self__, "config_file", config_file)

    @property
    @pulumi.getter(name="cacheTimeout")
    def cache_timeout(self) -> Optional[str]:
        """
        Controls how long to cache authentication decisions (string)
        """
        return pulumi.get(self, "cache_timeout")

    @property
    @pulumi.getter(name="configFile")
    def config_file(self) -> Optional[str]:
        """
        Multiline string that represent a custom webhook config file (string)
        """
        return pulumi.get(self, "config_file")


@pulumi.output_type
class ClusterAuthorization(dict):
    def __init__(__self__, *,
                 mode: Optional[str] = None,
                 options: Optional[Mapping[str, Any]] = None):
        """
        :param str mode: RKE mode for authorization. `rbac` and `none` modes are available. Default `rbac` (string)
        :param Mapping[str, Any] options: Network provider options (map)
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if options is not None:
            pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        """
        RKE mode for authorization. `rbac` and `none` modes are available. Default `rbac` (string)
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def options(self) -> Optional[Mapping[str, Any]]:
        """
        Network provider options (map)
        """
        return pulumi.get(self, "options")


@pulumi.output_type
class ClusterBastionHost(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sshAgentAuth":
            suggest = "ssh_agent_auth"
        elif key == "sshCert":
            suggest = "ssh_cert"
        elif key == "sshCertPath":
            suggest = "ssh_cert_path"
        elif key == "sshKey":
            suggest = "ssh_key"
        elif key == "sshKeyPath":
            suggest = "ssh_key_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBastionHost. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBastionHost.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBastionHost.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 user: str,
                 port: Optional[str] = None,
                 ssh_agent_auth: Optional[bool] = None,
                 ssh_cert: Optional[str] = None,
                 ssh_cert_path: Optional[str] = None,
                 ssh_key: Optional[str] = None,
                 ssh_key_path: Optional[str] = None):
        """
        :param str address: Address ip for node (string)
        :param str user: Registry user (string)
        :param str port: Port used for SSH communication (string)
        :param bool ssh_agent_auth: SSH Agent Auth enable (bool)
        :param str ssh_cert: SSH Certificate (string)
        :param str ssh_cert_path: SSH Certificate path (string)
        :param str ssh_key: SSH Private Key (string)
        :param str ssh_key_path: SSH Private Key path (string)
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "user", user)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssh_agent_auth is not None:
            pulumi.set(__self__, "ssh_agent_auth", ssh_agent_auth)
        if ssh_cert is not None:
            pulumi.set(__self__, "ssh_cert", ssh_cert)
        if ssh_cert_path is not None:
            pulumi.set(__self__, "ssh_cert_path", ssh_cert_path)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if ssh_key_path is not None:
            pulumi.set(__self__, "ssh_key_path", ssh_key_path)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        Address ip for node (string)
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        Registry user (string)
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        Port used for SSH communication (string)
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="sshAgentAuth")
    def ssh_agent_auth(self) -> Optional[bool]:
        """
        SSH Agent Auth enable (bool)
        """
        return pulumi.get(self, "ssh_agent_auth")

    @property
    @pulumi.getter(name="sshCert")
    def ssh_cert(self) -> Optional[str]:
        """
        SSH Certificate (string)
        """
        return pulumi.get(self, "ssh_cert")

    @property
    @pulumi.getter(name="sshCertPath")
    def ssh_cert_path(self) -> Optional[str]:
        """
        SSH Certificate path (string)
        """
        return pulumi.get(self, "ssh_cert_path")

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[str]:
        """
        SSH Private Key (string)
        """
        return pulumi.get(self, "ssh_key")

    @property
    @pulumi.getter(name="sshKeyPath")
    def ssh_key_path(self) -> Optional[str]:
        """
        SSH Private Key path (string)
        """
        return pulumi.get(self, "ssh_key_path")


@pulumi.output_type
class ClusterCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "configEnvName":
            suggest = "config_env_name"
        elif key == "configPath":
            suggest = "config_path"
        elif key == "envName":
            suggest = "env_name"
        elif key == "keyEnvName":
            suggest = "key_env_name"
        elif key == "keyPath":
            suggest = "key_path"
        elif key == "ouName":
            suggest = "ou_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate: Optional[str] = None,
                 common_name: Optional[str] = None,
                 config: Optional[str] = None,
                 config_env_name: Optional[str] = None,
                 config_path: Optional[str] = None,
                 env_name: Optional[str] = None,
                 id: Optional[str] = None,
                 key: Optional[str] = None,
                 key_env_name: Optional[str] = None,
                 key_path: Optional[str] = None,
                 name: Optional[str] = None,
                 ou_name: Optional[str] = None,
                 path: Optional[str] = None):
        """
        :param str id: (Computed) The ID of the resource (string)
        :param str key: TLS key for etcd service (string)
        :param str name: Name of virtualcenter config for Vsphere Cloud Provider config (string)
        :param str path: Audit log path. Default: `/var/log/kube-audit/audit-log.json` (string)
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if config_env_name is not None:
            pulumi.set(__self__, "config_env_name", config_env_name)
        if config_path is not None:
            pulumi.set(__self__, "config_path", config_path)
        if env_name is not None:
            pulumi.set(__self__, "env_name", env_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if key_env_name is not None:
            pulumi.set(__self__, "key_env_name", key_env_name)
        if key_path is not None:
            pulumi.set(__self__, "key_path", key_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ou_name is not None:
            pulumi.set(__self__, "ou_name", ou_name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[str]:
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[str]:
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter
    def config(self) -> Optional[str]:
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="configEnvName")
    def config_env_name(self) -> Optional[str]:
        return pulumi.get(self, "config_env_name")

    @property
    @pulumi.getter(name="configPath")
    def config_path(self) -> Optional[str]:
        return pulumi.get(self, "config_path")

    @property
    @pulumi.getter(name="envName")
    def env_name(self) -> Optional[str]:
        return pulumi.get(self, "env_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        (Computed) The ID of the resource (string)
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        TLS key for etcd service (string)
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="keyEnvName")
    def key_env_name(self) -> Optional[str]:
        return pulumi.get(self, "key_env_name")

    @property
    @pulumi.getter(name="keyPath")
    def key_path(self) -> Optional[str]:
        return pulumi.get(self, "key_path")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of virtualcenter config for Vsphere Cloud Provider config (string)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ouName")
    def ou_name(self) -> Optional[str]:
        return pulumi.get(self, "ou_name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Audit log path. Default: `/var/log/kube-audit/audit-log.json` (string)
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class ClusterCloudProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsCloudConfig":
            suggest = "aws_cloud_config"
        elif key == "awsCloudProvider":
            suggest = "aws_cloud_provider"
        elif key == "azureCloudConfig":
            suggest = "azure_cloud_config"
        elif key == "azureCloudProvider":
            suggest = "azure_cloud_provider"
        elif key == "customCloudConfig":
            suggest = "custom_cloud_config"
        elif key == "customCloudProvider":
            suggest = "custom_cloud_provider"
        elif key == "openstackCloudConfig":
            suggest = "openstack_cloud_config"
        elif key == "openstackCloudProvider":
            suggest = "openstack_cloud_provider"
        elif key == "vsphereCloudConfig":
            suggest = "vsphere_cloud_config"
        elif key == "vsphereCloudProvider":
            suggest = "vsphere_cloud_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 aws_cloud_config: Optional['outputs.ClusterCloudProviderAwsCloudConfig'] = None,
                 aws_cloud_provider: Optional['outputs.ClusterCloudProviderAwsCloudProvider'] = None,
                 azure_cloud_config: Optional['outputs.ClusterCloudProviderAzureCloudConfig'] = None,
                 azure_cloud_provider: Optional['outputs.ClusterCloudProviderAzureCloudProvider'] = None,
                 custom_cloud_config: Optional[str] = None,
                 custom_cloud_provider: Optional[str] = None,
                 openstack_cloud_config: Optional['outputs.ClusterCloudProviderOpenstackCloudConfig'] = None,
                 openstack_cloud_provider: Optional['outputs.ClusterCloudProviderOpenstackCloudProvider'] = None,
                 vsphere_cloud_config: Optional['outputs.ClusterCloudProviderVsphereCloudConfig'] = None,
                 vsphere_cloud_provider: Optional['outputs.ClusterCloudProviderVsphereCloudProvider'] = None):
        """
        :param str name: Name of virtualcenter config for Vsphere Cloud Provider config (string)
        :param 'ClusterCloudProviderAwsCloudConfigArgs' aws_cloud_config: Use aws_cloud_provider instead
        :param 'ClusterCloudProviderAwsCloudProviderArgs' aws_cloud_provider: AWS Cloud Provider config [rke-aws-cloud-provider](https://rancher.com/docs/rke/latest/en/config-options/cloud-providers/aws/) (list maxitems:1)
        :param 'ClusterCloudProviderAzureCloudConfigArgs' azure_cloud_config: Use azure_cloud_provider instead
        :param 'ClusterCloudProviderAzureCloudProviderArgs' azure_cloud_provider: Azure Cloud Provider config [rke-azure-cloud-provider](https://rancher.com/docs/rke/latest/en/config-options/cloud-providers/azure/) (list maxitems:1)
        :param str custom_cloud_config: Use custom_cloud_provider instead
        :param str custom_cloud_provider: Custom Cloud Provider config (string)
        :param 'ClusterCloudProviderOpenstackCloudConfigArgs' openstack_cloud_config: Use openstack_cloud_provider instead
        :param 'ClusterCloudProviderOpenstackCloudProviderArgs' openstack_cloud_provider: Openstack Cloud Provider config [rke-openstack-cloud-provider](https://rancher.com/docs/rke/latest/en/config-options/cloud-providers/openstack/) (list maxitems:1)
        :param 'ClusterCloudProviderVsphereCloudConfigArgs' vsphere_cloud_config: Use vsphere_cloud_provider instead
        :param 'ClusterCloudProviderVsphereCloudProviderArgs' vsphere_cloud_provider: Vsphere Cloud Provider config [rke-vsphere-cloud-provider](https://rancher.com/docs/rke/latest/en/config-options/cloud-providers/vsphere/) Extra argument `name` is required on `virtual_center` configuration. (list maxitems:1)
        """
        pulumi.set(__self__, "name", name)
        if aws_cloud_config is not None:
            pulumi.set(__self__, "aws_cloud_config", aws_cloud_config)
        if aws_cloud_provider is not None:
            pulumi.set(__self__, "aws_cloud_provider", aws_cloud_provider)
        if azure_cloud_config is not None:
            pulumi.set(__self__, "azure_cloud_config", azure_cloud_config)
        if azure_cloud_provider is not None:
            pulumi.set(__self__, "azure_cloud_provider", azure_cloud_provider)
        if custom_cloud_config is not None:
            pulumi.set(__self__, "custom_cloud_config", custom_cloud_config)
        if custom_cloud_provider is not None:
            pulumi.set(__self__, "custom_cloud_provider", custom_cloud_provider)
        if openstack_cloud_config is not None:
            pulumi.set(__self__, "openstack_cloud_config", openstack_cloud_config)
        if openstack_cloud_provider is not None:
            pulumi.set(__self__, "openstack_cloud_provider", openstack_cloud_provider)
        if vsphere_cloud_config is not None:
            pulumi.set(__self__, "vsphere_cloud_config", vsphere_cloud_config)
        if vsphere_cloud_provider is not None:
            pulumi.set(__self__, "vsphere_cloud_provider", vsphere_cloud_provider)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of virtualcenter config for Vsphere Cloud Provider config (string)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="awsCloudConfig")
    def aws_cloud_config(self) -> Optional['outputs.ClusterCloudProviderAwsCloudConfig']:
        """
        Use aws_cloud_provider instead
        """
        return pulumi.get(self, "aws_cloud_config")

    @property
    @pulumi.getter(name="awsCloudProvider")
    def aws_cloud_provider(self) -> Optional['outputs.ClusterCloudProviderAwsCloudProvider']:
        """
        AWS Cloud Provider config [rke-aws-cloud-provider](https://rancher.com/docs/rke/latest/en/config-options/cloud-providers/aws/) (list maxitems:1)
        """
        return pulumi.get(self, "aws_cloud_provider")

    @property
    @pulumi.getter(name="azureCloudConfig")
    def azure_cloud_config(self) -> Optional['outputs.ClusterCloudProviderAzureCloudConfig']:
        """
        Use azure_cloud_provider instead
        """
        return pulumi.get(self, "azure_cloud_config")

    @property
    @pulumi.getter(name="azureCloudProvider")
    def azure_cloud_provider(self) -> Optional['outputs.ClusterCloudProviderAzureCloudProvider']:
        """
        Azure Cloud Provider config [rke-azure-cloud-provider](https://rancher.com/docs/rke/latest/en/config-options/cloud-providers/azure/) (list maxitems:1)
        """
        return pulumi.get(self, "azure_cloud_provider")

    @property
    @pulumi.getter(name="customCloudConfig")
    def custom_cloud_config(self) -> Optional[str]:
        """
        Use custom_cloud_provider instead
        """
        return pulumi.get(self, "custom_cloud_config")

    @property
    @pulumi.getter(name="customCloudProvider")
    def custom_cloud_provider(self) -> Optional[str]:
        """
        Custom Cloud Provider config (string)
        """
        return pulumi.get(self, "custom_cloud_provider")

    @property
    @pulumi.getter(name="openstackCloudConfig")
    def openstack_cloud_config(self) -> Optional['outputs.ClusterCloudProviderOpenstackCloudConfig']:
        """
        Use openstack_cloud_provider instead
        """
        return pulumi.get(self, "openstack_cloud_config")

    @property
    @pulumi.getter(name="openstackCloudProvider")
    def openstack_cloud_provider(self) -> Optional['outputs.ClusterCloudProviderOpenstackCloudProvider']:
        """
        Openstack Cloud Provider config [rke-openstack-cloud-provider](https://rancher.com/docs/rke/latest/en/config-options/cloud-providers/openstack/) (list maxitems:1)
        """
        return pulumi.get(self, "openstack_cloud_provider")

    @property
    @pulumi.getter(name="vsphereCloudConfig")
    def vsphere_cloud_config(self) -> Optional['outputs.ClusterCloudProviderVsphereCloudConfig']:
        """
        Use vsphere_cloud_provider instead
        """
        return pulumi.get(self, "vsphere_cloud_config")

    @property
    @pulumi.getter(name="vsphereCloudProvider")
    def vsphere_cloud_provider(self) -> Optional['outputs.ClusterCloudProviderVsphereCloudProvider']:
        """
        Vsphere Cloud Provider config [rke-vsphere-cloud-provider](https://rancher.com/docs/rke/latest/en/config-options/cloud-providers/vsphere/) Extra argument `name` is required on `virtual_center` configuration. (list maxitems:1)
        """
        return pulumi.get(self, "vsphere_cloud_provider")


@pulumi.output_type
class ClusterCloudProviderAwsCloudConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "global":
            suggest = "global_"
        elif key == "serviceOverrides":
            suggest = "service_overrides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderAwsCloudConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderAwsCloudConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderAwsCloudConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 global_: Optional['outputs.ClusterCloudProviderAwsCloudConfigGlobal'] = None,
                 service_overrides: Optional[Sequence['outputs.ClusterCloudProviderAwsCloudConfigServiceOverride']] = None):
        """
        :param 'ClusterCloudProviderAwsCloudConfigGlobalArgs' global_: (list maxitems:1)
        :param Sequence['ClusterCloudProviderAwsCloudConfigServiceOverrideArgs'] service_overrides: (list)
        """
        if global_ is not None:
            pulumi.set(__self__, "global_", global_)
        if service_overrides is not None:
            pulumi.set(__self__, "service_overrides", service_overrides)

    @property
    @pulumi.getter(name="global")
    def global_(self) -> Optional['outputs.ClusterCloudProviderAwsCloudConfigGlobal']:
        """
        (list maxitems:1)
        """
        return pulumi.get(self, "global_")

    @property
    @pulumi.getter(name="serviceOverrides")
    def service_overrides(self) -> Optional[Sequence['outputs.ClusterCloudProviderAwsCloudConfigServiceOverride']]:
        """
        (list)
        """
        return pulumi.get(self, "service_overrides")


@pulumi.output_type
class ClusterCloudProviderAwsCloudConfigGlobal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableSecurityGroupIngress":
            suggest = "disable_security_group_ingress"
        elif key == "disableStrictZoneCheck":
            suggest = "disable_strict_zone_check"
        elif key == "elbSecurityGroup":
            suggest = "elb_security_group"
        elif key == "kubernetesClusterId":
            suggest = "kubernetes_cluster_id"
        elif key == "kubernetesClusterTag":
            suggest = "kubernetes_cluster_tag"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "routeTableId":
            suggest = "route_table_id"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderAwsCloudConfigGlobal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderAwsCloudConfigGlobal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderAwsCloudConfigGlobal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_security_group_ingress: Optional[bool] = None,
                 disable_strict_zone_check: Optional[bool] = None,
                 elb_security_group: Optional[str] = None,
                 kubernetes_cluster_id: Optional[str] = None,
                 kubernetes_cluster_tag: Optional[str] = None,
                 role_arn: Optional[str] = None,
                 route_table_id: Optional[str] = None,
                 subnet_id: Optional[str] = None,
                 vpc: Optional[str] = None,
                 zone: Optional[str] = None):
        """
        :param bool disable_security_group_ingress: Disables the automatic ingress creation. Default `false` (bool)
        :param bool disable_strict_zone_check: Setting this to true will disable the check and provide a warning that the check was skipped. Default `false` (bool)
        :param str elb_security_group: Use these ELB security groups instead create new (string)
        :param str kubernetes_cluster_id: The cluster id we'll use to identify our cluster resources (string)
        :param str kubernetes_cluster_tag: Legacy cluster id we'll use to identify our cluster resources (string)
        :param str role_arn: IAM role to assume when interaction with AWS APIs (string)
        :param str route_table_id: Enables using a specific RouteTable (string)
        :param str subnet_id: (string)
        :param str vpc: The AWS VPC flag enables the possibility to run the master components on a different aws account, on a different cloud provider or on-premises. If the flag is set also the KubernetesClusterTag must be provided (string)
        :param str zone: The AWS zone (string)
        """
        if disable_security_group_ingress is not None:
            pulumi.set(__self__, "disable_security_group_ingress", disable_security_group_ingress)
        if disable_strict_zone_check is not None:
            pulumi.set(__self__, "disable_strict_zone_check", disable_strict_zone_check)
        if elb_security_group is not None:
            pulumi.set(__self__, "elb_security_group", elb_security_group)
        if kubernetes_cluster_id is not None:
            pulumi.set(__self__, "kubernetes_cluster_id", kubernetes_cluster_id)
        if kubernetes_cluster_tag is not None:
            pulumi.set(__self__, "kubernetes_cluster_tag", kubernetes_cluster_tag)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="disableSecurityGroupIngress")
    def disable_security_group_ingress(self) -> Optional[bool]:
        """
        Disables the automatic ingress creation. Default `false` (bool)
        """
        return pulumi.get(self, "disable_security_group_ingress")

    @property
    @pulumi.getter(name="disableStrictZoneCheck")
    def disable_strict_zone_check(self) -> Optional[bool]:
        """
        Setting this to true will disable the check and provide a warning that the check was skipped. Default `false` (bool)
        """
        return pulumi.get(self, "disable_strict_zone_check")

    @property
    @pulumi.getter(name="elbSecurityGroup")
    def elb_security_group(self) -> Optional[str]:
        """
        Use these ELB security groups instead create new (string)
        """
        return pulumi.get(self, "elb_security_group")

    @property
    @pulumi.getter(name="kubernetesClusterId")
    def kubernetes_cluster_id(self) -> Optional[str]:
        """
        The cluster id we'll use to identify our cluster resources (string)
        """
        return pulumi.get(self, "kubernetes_cluster_id")

    @property
    @pulumi.getter(name="kubernetesClusterTag")
    def kubernetes_cluster_tag(self) -> Optional[str]:
        """
        Legacy cluster id we'll use to identify our cluster resources (string)
        """
        return pulumi.get(self, "kubernetes_cluster_tag")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        IAM role to assume when interaction with AWS APIs (string)
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[str]:
        """
        Enables using a specific RouteTable (string)
        """
        return pulumi.get(self, "route_table_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def vpc(self) -> Optional[str]:
        """
        The AWS VPC flag enables the possibility to run the master components on a different aws account, on a different cloud provider or on-premises. If the flag is set also the KubernetesClusterTag must be provided (string)
        """
        return pulumi.get(self, "vpc")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        """
        The AWS zone (string)
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class ClusterCloudProviderAwsCloudConfigServiceOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signingMethod":
            suggest = "signing_method"
        elif key == "signingName":
            suggest = "signing_name"
        elif key == "signingRegion":
            suggest = "signing_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderAwsCloudConfigServiceOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderAwsCloudConfigServiceOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderAwsCloudConfigServiceOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service: str,
                 key: Optional[str] = None,
                 region: Optional[str] = None,
                 signing_method: Optional[str] = None,
                 signing_name: Optional[str] = None,
                 signing_region: Optional[str] = None,
                 url: Optional[str] = None):
        """
        :param str service: (string)
        :param str key: TLS key for etcd service (string)
        :param str region: Region for S3 service (string)
        :param str signing_method: (string)
        :param str signing_name: (string)
        :param str signing_region: (string)
        :param str url: Registry URL (string)
        """
        pulumi.set(__self__, "service", service)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if signing_method is not None:
            pulumi.set(__self__, "signing_method", signing_method)
        if signing_name is not None:
            pulumi.set(__self__, "signing_name", signing_name)
        if signing_region is not None:
            pulumi.set(__self__, "signing_region", signing_region)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        (string)
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        TLS key for etcd service (string)
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Region for S3 service (string)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="signingMethod")
    def signing_method(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "signing_method")

    @property
    @pulumi.getter(name="signingName")
    def signing_name(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "signing_name")

    @property
    @pulumi.getter(name="signingRegion")
    def signing_region(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "signing_region")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        Registry URL (string)
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ClusterCloudProviderAwsCloudProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "global":
            suggest = "global_"
        elif key == "serviceOverrides":
            suggest = "service_overrides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderAwsCloudProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderAwsCloudProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderAwsCloudProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 global_: Optional['outputs.ClusterCloudProviderAwsCloudProviderGlobal'] = None,
                 service_overrides: Optional[Sequence['outputs.ClusterCloudProviderAwsCloudProviderServiceOverride']] = None):
        """
        :param 'ClusterCloudProviderAwsCloudProviderGlobalArgs' global_: (list maxitems:1)
        :param Sequence['ClusterCloudProviderAwsCloudProviderServiceOverrideArgs'] service_overrides: (list)
        """
        if global_ is not None:
            pulumi.set(__self__, "global_", global_)
        if service_overrides is not None:
            pulumi.set(__self__, "service_overrides", service_overrides)

    @property
    @pulumi.getter(name="global")
    def global_(self) -> Optional['outputs.ClusterCloudProviderAwsCloudProviderGlobal']:
        """
        (list maxitems:1)
        """
        return pulumi.get(self, "global_")

    @property
    @pulumi.getter(name="serviceOverrides")
    def service_overrides(self) -> Optional[Sequence['outputs.ClusterCloudProviderAwsCloudProviderServiceOverride']]:
        """
        (list)
        """
        return pulumi.get(self, "service_overrides")


@pulumi.output_type
class ClusterCloudProviderAwsCloudProviderGlobal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableSecurityGroupIngress":
            suggest = "disable_security_group_ingress"
        elif key == "disableStrictZoneCheck":
            suggest = "disable_strict_zone_check"
        elif key == "elbSecurityGroup":
            suggest = "elb_security_group"
        elif key == "kubernetesClusterId":
            suggest = "kubernetes_cluster_id"
        elif key == "kubernetesClusterTag":
            suggest = "kubernetes_cluster_tag"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "routeTableId":
            suggest = "route_table_id"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderAwsCloudProviderGlobal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderAwsCloudProviderGlobal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderAwsCloudProviderGlobal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_security_group_ingress: Optional[bool] = None,
                 disable_strict_zone_check: Optional[bool] = None,
                 elb_security_group: Optional[str] = None,
                 kubernetes_cluster_id: Optional[str] = None,
                 kubernetes_cluster_tag: Optional[str] = None,
                 role_arn: Optional[str] = None,
                 route_table_id: Optional[str] = None,
                 subnet_id: Optional[str] = None,
                 vpc: Optional[str] = None,
                 zone: Optional[str] = None):
        """
        :param bool disable_security_group_ingress: Disables the automatic ingress creation. Default `false` (bool)
        :param bool disable_strict_zone_check: Setting this to true will disable the check and provide a warning that the check was skipped. Default `false` (bool)
        :param str elb_security_group: Use these ELB security groups instead create new (string)
        :param str kubernetes_cluster_id: The cluster id we'll use to identify our cluster resources (string)
        :param str kubernetes_cluster_tag: Legacy cluster id we'll use to identify our cluster resources (string)
        :param str role_arn: IAM role to assume when interaction with AWS APIs (string)
        :param str route_table_id: Enables using a specific RouteTable (string)
        :param str subnet_id: (string)
        :param str vpc: The AWS VPC flag enables the possibility to run the master components on a different aws account, on a different cloud provider or on-premises. If the flag is set also the KubernetesClusterTag must be provided (string)
        :param str zone: The AWS zone (string)
        """
        if disable_security_group_ingress is not None:
            pulumi.set(__self__, "disable_security_group_ingress", disable_security_group_ingress)
        if disable_strict_zone_check is not None:
            pulumi.set(__self__, "disable_strict_zone_check", disable_strict_zone_check)
        if elb_security_group is not None:
            pulumi.set(__self__, "elb_security_group", elb_security_group)
        if kubernetes_cluster_id is not None:
            pulumi.set(__self__, "kubernetes_cluster_id", kubernetes_cluster_id)
        if kubernetes_cluster_tag is not None:
            pulumi.set(__self__, "kubernetes_cluster_tag", kubernetes_cluster_tag)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="disableSecurityGroupIngress")
    def disable_security_group_ingress(self) -> Optional[bool]:
        """
        Disables the automatic ingress creation. Default `false` (bool)
        """
        return pulumi.get(self, "disable_security_group_ingress")

    @property
    @pulumi.getter(name="disableStrictZoneCheck")
    def disable_strict_zone_check(self) -> Optional[bool]:
        """
        Setting this to true will disable the check and provide a warning that the check was skipped. Default `false` (bool)
        """
        return pulumi.get(self, "disable_strict_zone_check")

    @property
    @pulumi.getter(name="elbSecurityGroup")
    def elb_security_group(self) -> Optional[str]:
        """
        Use these ELB security groups instead create new (string)
        """
        return pulumi.get(self, "elb_security_group")

    @property
    @pulumi.getter(name="kubernetesClusterId")
    def kubernetes_cluster_id(self) -> Optional[str]:
        """
        The cluster id we'll use to identify our cluster resources (string)
        """
        return pulumi.get(self, "kubernetes_cluster_id")

    @property
    @pulumi.getter(name="kubernetesClusterTag")
    def kubernetes_cluster_tag(self) -> Optional[str]:
        """
        Legacy cluster id we'll use to identify our cluster resources (string)
        """
        return pulumi.get(self, "kubernetes_cluster_tag")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        IAM role to assume when interaction with AWS APIs (string)
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[str]:
        """
        Enables using a specific RouteTable (string)
        """
        return pulumi.get(self, "route_table_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def vpc(self) -> Optional[str]:
        """
        The AWS VPC flag enables the possibility to run the master components on a different aws account, on a different cloud provider or on-premises. If the flag is set also the KubernetesClusterTag must be provided (string)
        """
        return pulumi.get(self, "vpc")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        """
        The AWS zone (string)
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class ClusterCloudProviderAwsCloudProviderServiceOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signingMethod":
            suggest = "signing_method"
        elif key == "signingName":
            suggest = "signing_name"
        elif key == "signingRegion":
            suggest = "signing_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderAwsCloudProviderServiceOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderAwsCloudProviderServiceOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderAwsCloudProviderServiceOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service: str,
                 key: Optional[str] = None,
                 region: Optional[str] = None,
                 signing_method: Optional[str] = None,
                 signing_name: Optional[str] = None,
                 signing_region: Optional[str] = None,
                 url: Optional[str] = None):
        """
        :param str service: (string)
        :param str key: TLS key for etcd service (string)
        :param str region: Region for S3 service (string)
        :param str signing_method: (string)
        :param str signing_name: (string)
        :param str signing_region: (string)
        :param str url: Registry URL (string)
        """
        pulumi.set(__self__, "service", service)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if signing_method is not None:
            pulumi.set(__self__, "signing_method", signing_method)
        if signing_name is not None:
            pulumi.set(__self__, "signing_name", signing_name)
        if signing_region is not None:
            pulumi.set(__self__, "signing_region", signing_region)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        (string)
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        TLS key for etcd service (string)
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Region for S3 service (string)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="signingMethod")
    def signing_method(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "signing_method")

    @property
    @pulumi.getter(name="signingName")
    def signing_name(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "signing_name")

    @property
    @pulumi.getter(name="signingRegion")
    def signing_region(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "signing_region")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        Registry URL (string)
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ClusterCloudProviderAzureCloudConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aadClientId":
            suggest = "aad_client_id"
        elif key == "aadClientSecret":
            suggest = "aad_client_secret"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "aadClientCertPassword":
            suggest = "aad_client_cert_password"
        elif key == "aadClientCertPath":
            suggest = "aad_client_cert_path"
        elif key == "cloudProviderBackoff":
            suggest = "cloud_provider_backoff"
        elif key == "cloudProviderBackoffDuration":
            suggest = "cloud_provider_backoff_duration"
        elif key == "cloudProviderBackoffExponent":
            suggest = "cloud_provider_backoff_exponent"
        elif key == "cloudProviderBackoffJitter":
            suggest = "cloud_provider_backoff_jitter"
        elif key == "cloudProviderBackoffRetries":
            suggest = "cloud_provider_backoff_retries"
        elif key == "cloudProviderRateLimit":
            suggest = "cloud_provider_rate_limit"
        elif key == "cloudProviderRateLimitBucket":
            suggest = "cloud_provider_rate_limit_bucket"
        elif key == "cloudProviderRateLimitQps":
            suggest = "cloud_provider_rate_limit_qps"
        elif key == "loadBalancerSku":
            suggest = "load_balancer_sku"
        elif key == "maximumLoadBalancerRuleCount":
            suggest = "maximum_load_balancer_rule_count"
        elif key == "primaryAvailabilitySetName":
            suggest = "primary_availability_set_name"
        elif key == "primaryScaleSetName":
            suggest = "primary_scale_set_name"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "routeTableName":
            suggest = "route_table_name"
        elif key == "securityGroupName":
            suggest = "security_group_name"
        elif key == "subnetName":
            suggest = "subnet_name"
        elif key == "useInstanceMetadata":
            suggest = "use_instance_metadata"
        elif key == "useManagedIdentityExtension":
            suggest = "use_managed_identity_extension"
        elif key == "vmType":
            suggest = "vm_type"
        elif key == "vnetName":
            suggest = "vnet_name"
        elif key == "vnetResourceGroup":
            suggest = "vnet_resource_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderAzureCloudConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderAzureCloudConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderAzureCloudConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aad_client_id: str,
                 aad_client_secret: str,
                 subscription_id: str,
                 tenant_id: str,
                 aad_client_cert_password: Optional[str] = None,
                 aad_client_cert_path: Optional[str] = None,
                 cloud: Optional[str] = None,
                 cloud_provider_backoff: Optional[bool] = None,
                 cloud_provider_backoff_duration: Optional[int] = None,
                 cloud_provider_backoff_exponent: Optional[int] = None,
                 cloud_provider_backoff_jitter: Optional[int] = None,
                 cloud_provider_backoff_retries: Optional[int] = None,
                 cloud_provider_rate_limit: Optional[bool] = None,
                 cloud_provider_rate_limit_bucket: Optional[int] = None,
                 cloud_provider_rate_limit_qps: Optional[int] = None,
                 load_balancer_sku: Optional[str] = None,
                 location: Optional[str] = None,
                 maximum_load_balancer_rule_count: Optional[int] = None,
                 primary_availability_set_name: Optional[str] = None,
                 primary_scale_set_name: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 route_table_name: Optional[str] = None,
                 security_group_name: Optional[str] = None,
                 subnet_name: Optional[str] = None,
                 use_instance_metadata: Optional[bool] = None,
                 use_managed_identity_extension: Optional[bool] = None,
                 vm_type: Optional[str] = None,
                 vnet_name: Optional[str] = None,
                 vnet_resource_group: Optional[str] = None):
        """
        :param str aad_client_id: (string)
        :param str aad_client_secret: (string)
        :param str subscription_id: (string)
        :param str tenant_id: Required if `tenant_name` not provided. (string)
        :param str aad_client_cert_password: (string)
        :param str aad_client_cert_path: (string)
        :param str cloud: (string)
        :param bool cloud_provider_backoff: (bool)
        :param int cloud_provider_backoff_duration: (int)
        :param int cloud_provider_backoff_exponent: (int)
        :param int cloud_provider_backoff_jitter: (int)
        :param int cloud_provider_backoff_retries: (int)
        :param bool cloud_provider_rate_limit: (bool)
        :param int cloud_provider_rate_limit_bucket: (int)
        :param int cloud_provider_rate_limit_qps: (int)
        :param str location: (string)
        :param int maximum_load_balancer_rule_count: (int)
        :param str primary_availability_set_name: (string)
        :param str primary_scale_set_name: (string)
        :param str resource_group: (string)
        :param str route_table_name: (string)
        :param str security_group_name: (string)
        :param str subnet_name: (string)
        :param bool use_instance_metadata: (bool)
        :param bool use_managed_identity_extension: (bool)
        :param str vm_type: (string)
        :param str vnet_name: (string)
        :param str vnet_resource_group: (string)
        """
        pulumi.set(__self__, "aad_client_id", aad_client_id)
        pulumi.set(__self__, "aad_client_secret", aad_client_secret)
        pulumi.set(__self__, "subscription_id", subscription_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if aad_client_cert_password is not None:
            pulumi.set(__self__, "aad_client_cert_password", aad_client_cert_password)
        if aad_client_cert_path is not None:
            pulumi.set(__self__, "aad_client_cert_path", aad_client_cert_path)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if cloud_provider_backoff is not None:
            pulumi.set(__self__, "cloud_provider_backoff", cloud_provider_backoff)
        if cloud_provider_backoff_duration is not None:
            pulumi.set(__self__, "cloud_provider_backoff_duration", cloud_provider_backoff_duration)
        if cloud_provider_backoff_exponent is not None:
            pulumi.set(__self__, "cloud_provider_backoff_exponent", cloud_provider_backoff_exponent)
        if cloud_provider_backoff_jitter is not None:
            pulumi.set(__self__, "cloud_provider_backoff_jitter", cloud_provider_backoff_jitter)
        if cloud_provider_backoff_retries is not None:
            pulumi.set(__self__, "cloud_provider_backoff_retries", cloud_provider_backoff_retries)
        if cloud_provider_rate_limit is not None:
            pulumi.set(__self__, "cloud_provider_rate_limit", cloud_provider_rate_limit)
        if cloud_provider_rate_limit_bucket is not None:
            pulumi.set(__self__, "cloud_provider_rate_limit_bucket", cloud_provider_rate_limit_bucket)
        if cloud_provider_rate_limit_qps is not None:
            pulumi.set(__self__, "cloud_provider_rate_limit_qps", cloud_provider_rate_limit_qps)
        if load_balancer_sku is not None:
            pulumi.set(__self__, "load_balancer_sku", load_balancer_sku)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maximum_load_balancer_rule_count is not None:
            pulumi.set(__self__, "maximum_load_balancer_rule_count", maximum_load_balancer_rule_count)
        if primary_availability_set_name is not None:
            pulumi.set(__self__, "primary_availability_set_name", primary_availability_set_name)
        if primary_scale_set_name is not None:
            pulumi.set(__self__, "primary_scale_set_name", primary_scale_set_name)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if route_table_name is not None:
            pulumi.set(__self__, "route_table_name", route_table_name)
        if security_group_name is not None:
            pulumi.set(__self__, "security_group_name", security_group_name)
        if subnet_name is not None:
            pulumi.set(__self__, "subnet_name", subnet_name)
        if use_instance_metadata is not None:
            pulumi.set(__self__, "use_instance_metadata", use_instance_metadata)
        if use_managed_identity_extension is not None:
            pulumi.set(__self__, "use_managed_identity_extension", use_managed_identity_extension)
        if vm_type is not None:
            pulumi.set(__self__, "vm_type", vm_type)
        if vnet_name is not None:
            pulumi.set(__self__, "vnet_name", vnet_name)
        if vnet_resource_group is not None:
            pulumi.set(__self__, "vnet_resource_group", vnet_resource_group)

    @property
    @pulumi.getter(name="aadClientId")
    def aad_client_id(self) -> str:
        """
        (string)
        """
        return pulumi.get(self, "aad_client_id")

    @property
    @pulumi.getter(name="aadClientSecret")
    def aad_client_secret(self) -> str:
        """
        (string)
        """
        return pulumi.get(self, "aad_client_secret")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> str:
        """
        (string)
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        Required if `tenant_name` not provided. (string)
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="aadClientCertPassword")
    def aad_client_cert_password(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "aad_client_cert_password")

    @property
    @pulumi.getter(name="aadClientCertPath")
    def aad_client_cert_path(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "aad_client_cert_path")

    @property
    @pulumi.getter
    def cloud(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "cloud")

    @property
    @pulumi.getter(name="cloudProviderBackoff")
    def cloud_provider_backoff(self) -> Optional[bool]:
        """
        (bool)
        """
        return pulumi.get(self, "cloud_provider_backoff")

    @property
    @pulumi.getter(name="cloudProviderBackoffDuration")
    def cloud_provider_backoff_duration(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "cloud_provider_backoff_duration")

    @property
    @pulumi.getter(name="cloudProviderBackoffExponent")
    def cloud_provider_backoff_exponent(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "cloud_provider_backoff_exponent")

    @property
    @pulumi.getter(name="cloudProviderBackoffJitter")
    def cloud_provider_backoff_jitter(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "cloud_provider_backoff_jitter")

    @property
    @pulumi.getter(name="cloudProviderBackoffRetries")
    def cloud_provider_backoff_retries(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "cloud_provider_backoff_retries")

    @property
    @pulumi.getter(name="cloudProviderRateLimit")
    def cloud_provider_rate_limit(self) -> Optional[bool]:
        """
        (bool)
        """
        return pulumi.get(self, "cloud_provider_rate_limit")

    @property
    @pulumi.getter(name="cloudProviderRateLimitBucket")
    def cloud_provider_rate_limit_bucket(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "cloud_provider_rate_limit_bucket")

    @property
    @pulumi.getter(name="cloudProviderRateLimitQps")
    def cloud_provider_rate_limit_qps(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "cloud_provider_rate_limit_qps")

    @property
    @pulumi.getter(name="loadBalancerSku")
    def load_balancer_sku(self) -> Optional[str]:
        return pulumi.get(self, "load_balancer_sku")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maximumLoadBalancerRuleCount")
    def maximum_load_balancer_rule_count(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "maximum_load_balancer_rule_count")

    @property
    @pulumi.getter(name="primaryAvailabilitySetName")
    def primary_availability_set_name(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "primary_availability_set_name")

    @property
    @pulumi.getter(name="primaryScaleSetName")
    def primary_scale_set_name(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "primary_scale_set_name")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="routeTableName")
    def route_table_name(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "route_table_name")

    @property
    @pulumi.getter(name="securityGroupName")
    def security_group_name(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "security_group_name")

    @property
    @pulumi.getter(name="subnetName")
    def subnet_name(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "subnet_name")

    @property
    @pulumi.getter(name="useInstanceMetadata")
    def use_instance_metadata(self) -> Optional[bool]:
        """
        (bool)
        """
        return pulumi.get(self, "use_instance_metadata")

    @property
    @pulumi.getter(name="useManagedIdentityExtension")
    def use_managed_identity_extension(self) -> Optional[bool]:
        """
        (bool)
        """
        return pulumi.get(self, "use_managed_identity_extension")

    @property
    @pulumi.getter(name="vmType")
    def vm_type(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "vm_type")

    @property
    @pulumi.getter(name="vnetName")
    def vnet_name(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "vnet_name")

    @property
    @pulumi.getter(name="vnetResourceGroup")
    def vnet_resource_group(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "vnet_resource_group")


@pulumi.output_type
class ClusterCloudProviderAzureCloudProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aadClientId":
            suggest = "aad_client_id"
        elif key == "aadClientSecret":
            suggest = "aad_client_secret"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "aadClientCertPassword":
            suggest = "aad_client_cert_password"
        elif key == "aadClientCertPath":
            suggest = "aad_client_cert_path"
        elif key == "cloudProviderBackoff":
            suggest = "cloud_provider_backoff"
        elif key == "cloudProviderBackoffDuration":
            suggest = "cloud_provider_backoff_duration"
        elif key == "cloudProviderBackoffExponent":
            suggest = "cloud_provider_backoff_exponent"
        elif key == "cloudProviderBackoffJitter":
            suggest = "cloud_provider_backoff_jitter"
        elif key == "cloudProviderBackoffRetries":
            suggest = "cloud_provider_backoff_retries"
        elif key == "cloudProviderRateLimit":
            suggest = "cloud_provider_rate_limit"
        elif key == "cloudProviderRateLimitBucket":
            suggest = "cloud_provider_rate_limit_bucket"
        elif key == "cloudProviderRateLimitQps":
            suggest = "cloud_provider_rate_limit_qps"
        elif key == "loadBalancerSku":
            suggest = "load_balancer_sku"
        elif key == "maximumLoadBalancerRuleCount":
            suggest = "maximum_load_balancer_rule_count"
        elif key == "primaryAvailabilitySetName":
            suggest = "primary_availability_set_name"
        elif key == "primaryScaleSetName":
            suggest = "primary_scale_set_name"
        elif key == "resourceGroup":
            suggest = "resource_group"
        elif key == "routeTableName":
            suggest = "route_table_name"
        elif key == "securityGroupName":
            suggest = "security_group_name"
        elif key == "subnetName":
            suggest = "subnet_name"
        elif key == "useInstanceMetadata":
            suggest = "use_instance_metadata"
        elif key == "useManagedIdentityExtension":
            suggest = "use_managed_identity_extension"
        elif key == "vmType":
            suggest = "vm_type"
        elif key == "vnetName":
            suggest = "vnet_name"
        elif key == "vnetResourceGroup":
            suggest = "vnet_resource_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderAzureCloudProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderAzureCloudProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderAzureCloudProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aad_client_id: str,
                 aad_client_secret: str,
                 subscription_id: str,
                 tenant_id: str,
                 aad_client_cert_password: Optional[str] = None,
                 aad_client_cert_path: Optional[str] = None,
                 cloud: Optional[str] = None,
                 cloud_provider_backoff: Optional[bool] = None,
                 cloud_provider_backoff_duration: Optional[int] = None,
                 cloud_provider_backoff_exponent: Optional[int] = None,
                 cloud_provider_backoff_jitter: Optional[int] = None,
                 cloud_provider_backoff_retries: Optional[int] = None,
                 cloud_provider_rate_limit: Optional[bool] = None,
                 cloud_provider_rate_limit_bucket: Optional[int] = None,
                 cloud_provider_rate_limit_qps: Optional[int] = None,
                 load_balancer_sku: Optional[str] = None,
                 location: Optional[str] = None,
                 maximum_load_balancer_rule_count: Optional[int] = None,
                 primary_availability_set_name: Optional[str] = None,
                 primary_scale_set_name: Optional[str] = None,
                 resource_group: Optional[str] = None,
                 route_table_name: Optional[str] = None,
                 security_group_name: Optional[str] = None,
                 subnet_name: Optional[str] = None,
                 use_instance_metadata: Optional[bool] = None,
                 use_managed_identity_extension: Optional[bool] = None,
                 vm_type: Optional[str] = None,
                 vnet_name: Optional[str] = None,
                 vnet_resource_group: Optional[str] = None):
        """
        :param str aad_client_id: (string)
        :param str aad_client_secret: (string)
        :param str subscription_id: (string)
        :param str tenant_id: Required if `tenant_name` not provided. (string)
        :param str aad_client_cert_password: (string)
        :param str aad_client_cert_path: (string)
        :param str cloud: (string)
        :param bool cloud_provider_backoff: (bool)
        :param int cloud_provider_backoff_duration: (int)
        :param int cloud_provider_backoff_exponent: (int)
        :param int cloud_provider_backoff_jitter: (int)
        :param int cloud_provider_backoff_retries: (int)
        :param bool cloud_provider_rate_limit: (bool)
        :param int cloud_provider_rate_limit_bucket: (int)
        :param int cloud_provider_rate_limit_qps: (int)
        :param str location: (string)
        :param int maximum_load_balancer_rule_count: (int)
        :param str primary_availability_set_name: (string)
        :param str primary_scale_set_name: (string)
        :param str resource_group: (string)
        :param str route_table_name: (string)
        :param str security_group_name: (string)
        :param str subnet_name: (string)
        :param bool use_instance_metadata: (bool)
        :param bool use_managed_identity_extension: (bool)
        :param str vm_type: (string)
        :param str vnet_name: (string)
        :param str vnet_resource_group: (string)
        """
        pulumi.set(__self__, "aad_client_id", aad_client_id)
        pulumi.set(__self__, "aad_client_secret", aad_client_secret)
        pulumi.set(__self__, "subscription_id", subscription_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if aad_client_cert_password is not None:
            pulumi.set(__self__, "aad_client_cert_password", aad_client_cert_password)
        if aad_client_cert_path is not None:
            pulumi.set(__self__, "aad_client_cert_path", aad_client_cert_path)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if cloud_provider_backoff is not None:
            pulumi.set(__self__, "cloud_provider_backoff", cloud_provider_backoff)
        if cloud_provider_backoff_duration is not None:
            pulumi.set(__self__, "cloud_provider_backoff_duration", cloud_provider_backoff_duration)
        if cloud_provider_backoff_exponent is not None:
            pulumi.set(__self__, "cloud_provider_backoff_exponent", cloud_provider_backoff_exponent)
        if cloud_provider_backoff_jitter is not None:
            pulumi.set(__self__, "cloud_provider_backoff_jitter", cloud_provider_backoff_jitter)
        if cloud_provider_backoff_retries is not None:
            pulumi.set(__self__, "cloud_provider_backoff_retries", cloud_provider_backoff_retries)
        if cloud_provider_rate_limit is not None:
            pulumi.set(__self__, "cloud_provider_rate_limit", cloud_provider_rate_limit)
        if cloud_provider_rate_limit_bucket is not None:
            pulumi.set(__self__, "cloud_provider_rate_limit_bucket", cloud_provider_rate_limit_bucket)
        if cloud_provider_rate_limit_qps is not None:
            pulumi.set(__self__, "cloud_provider_rate_limit_qps", cloud_provider_rate_limit_qps)
        if load_balancer_sku is not None:
            pulumi.set(__self__, "load_balancer_sku", load_balancer_sku)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maximum_load_balancer_rule_count is not None:
            pulumi.set(__self__, "maximum_load_balancer_rule_count", maximum_load_balancer_rule_count)
        if primary_availability_set_name is not None:
            pulumi.set(__self__, "primary_availability_set_name", primary_availability_set_name)
        if primary_scale_set_name is not None:
            pulumi.set(__self__, "primary_scale_set_name", primary_scale_set_name)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if route_table_name is not None:
            pulumi.set(__self__, "route_table_name", route_table_name)
        if security_group_name is not None:
            pulumi.set(__self__, "security_group_name", security_group_name)
        if subnet_name is not None:
            pulumi.set(__self__, "subnet_name", subnet_name)
        if use_instance_metadata is not None:
            pulumi.set(__self__, "use_instance_metadata", use_instance_metadata)
        if use_managed_identity_extension is not None:
            pulumi.set(__self__, "use_managed_identity_extension", use_managed_identity_extension)
        if vm_type is not None:
            pulumi.set(__self__, "vm_type", vm_type)
        if vnet_name is not None:
            pulumi.set(__self__, "vnet_name", vnet_name)
        if vnet_resource_group is not None:
            pulumi.set(__self__, "vnet_resource_group", vnet_resource_group)

    @property
    @pulumi.getter(name="aadClientId")
    def aad_client_id(self) -> str:
        """
        (string)
        """
        return pulumi.get(self, "aad_client_id")

    @property
    @pulumi.getter(name="aadClientSecret")
    def aad_client_secret(self) -> str:
        """
        (string)
        """
        return pulumi.get(self, "aad_client_secret")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> str:
        """
        (string)
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        Required if `tenant_name` not provided. (string)
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="aadClientCertPassword")
    def aad_client_cert_password(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "aad_client_cert_password")

    @property
    @pulumi.getter(name="aadClientCertPath")
    def aad_client_cert_path(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "aad_client_cert_path")

    @property
    @pulumi.getter
    def cloud(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "cloud")

    @property
    @pulumi.getter(name="cloudProviderBackoff")
    def cloud_provider_backoff(self) -> Optional[bool]:
        """
        (bool)
        """
        return pulumi.get(self, "cloud_provider_backoff")

    @property
    @pulumi.getter(name="cloudProviderBackoffDuration")
    def cloud_provider_backoff_duration(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "cloud_provider_backoff_duration")

    @property
    @pulumi.getter(name="cloudProviderBackoffExponent")
    def cloud_provider_backoff_exponent(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "cloud_provider_backoff_exponent")

    @property
    @pulumi.getter(name="cloudProviderBackoffJitter")
    def cloud_provider_backoff_jitter(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "cloud_provider_backoff_jitter")

    @property
    @pulumi.getter(name="cloudProviderBackoffRetries")
    def cloud_provider_backoff_retries(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "cloud_provider_backoff_retries")

    @property
    @pulumi.getter(name="cloudProviderRateLimit")
    def cloud_provider_rate_limit(self) -> Optional[bool]:
        """
        (bool)
        """
        return pulumi.get(self, "cloud_provider_rate_limit")

    @property
    @pulumi.getter(name="cloudProviderRateLimitBucket")
    def cloud_provider_rate_limit_bucket(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "cloud_provider_rate_limit_bucket")

    @property
    @pulumi.getter(name="cloudProviderRateLimitQps")
    def cloud_provider_rate_limit_qps(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "cloud_provider_rate_limit_qps")

    @property
    @pulumi.getter(name="loadBalancerSku")
    def load_balancer_sku(self) -> Optional[str]:
        return pulumi.get(self, "load_balancer_sku")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maximumLoadBalancerRuleCount")
    def maximum_load_balancer_rule_count(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "maximum_load_balancer_rule_count")

    @property
    @pulumi.getter(name="primaryAvailabilitySetName")
    def primary_availability_set_name(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "primary_availability_set_name")

    @property
    @pulumi.getter(name="primaryScaleSetName")
    def primary_scale_set_name(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "primary_scale_set_name")

    @property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "resource_group")

    @property
    @pulumi.getter(name="routeTableName")
    def route_table_name(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "route_table_name")

    @property
    @pulumi.getter(name="securityGroupName")
    def security_group_name(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "security_group_name")

    @property
    @pulumi.getter(name="subnetName")
    def subnet_name(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "subnet_name")

    @property
    @pulumi.getter(name="useInstanceMetadata")
    def use_instance_metadata(self) -> Optional[bool]:
        """
        (bool)
        """
        return pulumi.get(self, "use_instance_metadata")

    @property
    @pulumi.getter(name="useManagedIdentityExtension")
    def use_managed_identity_extension(self) -> Optional[bool]:
        """
        (bool)
        """
        return pulumi.get(self, "use_managed_identity_extension")

    @property
    @pulumi.getter(name="vmType")
    def vm_type(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "vm_type")

    @property
    @pulumi.getter(name="vnetName")
    def vnet_name(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "vnet_name")

    @property
    @pulumi.getter(name="vnetResourceGroup")
    def vnet_resource_group(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "vnet_resource_group")


@pulumi.output_type
class ClusterCloudProviderOpenstackCloudConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "global":
            suggest = "global_"
        elif key == "blockStorage":
            suggest = "block_storage"
        elif key == "loadBalancer":
            suggest = "load_balancer"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderOpenstackCloudConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderOpenstackCloudConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderOpenstackCloudConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 global_: 'outputs.ClusterCloudProviderOpenstackCloudConfigGlobal',
                 block_storage: Optional['outputs.ClusterCloudProviderOpenstackCloudConfigBlockStorage'] = None,
                 load_balancer: Optional['outputs.ClusterCloudProviderOpenstackCloudConfigLoadBalancer'] = None,
                 metadata: Optional['outputs.ClusterCloudProviderOpenstackCloudConfigMetadata'] = None,
                 route: Optional['outputs.ClusterCloudProviderOpenstackCloudConfigRoute'] = None):
        """
        :param 'ClusterCloudProviderOpenstackCloudConfigGlobalArgs' global_: (list maxitems:1)
        :param 'ClusterCloudProviderOpenstackCloudConfigBlockStorageArgs' block_storage: (list maxitems:1)
        :param 'ClusterCloudProviderOpenstackCloudConfigLoadBalancerArgs' load_balancer: (list maxitems:1)
        :param 'ClusterCloudProviderOpenstackCloudConfigMetadataArgs' metadata: (list maxitems:1)
        :param 'ClusterCloudProviderOpenstackCloudConfigRouteArgs' route: (list maxitems:1)
        """
        pulumi.set(__self__, "global_", global_)
        if block_storage is not None:
            pulumi.set(__self__, "block_storage", block_storage)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if route is not None:
            pulumi.set(__self__, "route", route)

    @property
    @pulumi.getter(name="global")
    def global_(self) -> 'outputs.ClusterCloudProviderOpenstackCloudConfigGlobal':
        """
        (list maxitems:1)
        """
        return pulumi.get(self, "global_")

    @property
    @pulumi.getter(name="blockStorage")
    def block_storage(self) -> Optional['outputs.ClusterCloudProviderOpenstackCloudConfigBlockStorage']:
        """
        (list maxitems:1)
        """
        return pulumi.get(self, "block_storage")

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional['outputs.ClusterCloudProviderOpenstackCloudConfigLoadBalancer']:
        """
        (list maxitems:1)
        """
        return pulumi.get(self, "load_balancer")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['outputs.ClusterCloudProviderOpenstackCloudConfigMetadata']:
        """
        (list maxitems:1)
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def route(self) -> Optional['outputs.ClusterCloudProviderOpenstackCloudConfigRoute']:
        """
        (list maxitems:1)
        """
        return pulumi.get(self, "route")


@pulumi.output_type
class ClusterCloudProviderOpenstackCloudConfigBlockStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bsVersion":
            suggest = "bs_version"
        elif key == "ignoreVolumeAz":
            suggest = "ignore_volume_az"
        elif key == "trustDevicePath":
            suggest = "trust_device_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderOpenstackCloudConfigBlockStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderOpenstackCloudConfigBlockStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderOpenstackCloudConfigBlockStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bs_version: Optional[str] = None,
                 ignore_volume_az: Optional[bool] = None,
                 trust_device_path: Optional[bool] = None):
        """
        :param str bs_version: (string)
        :param bool ignore_volume_az: (string)
        :param bool trust_device_path: (string)
        """
        if bs_version is not None:
            pulumi.set(__self__, "bs_version", bs_version)
        if ignore_volume_az is not None:
            pulumi.set(__self__, "ignore_volume_az", ignore_volume_az)
        if trust_device_path is not None:
            pulumi.set(__self__, "trust_device_path", trust_device_path)

    @property
    @pulumi.getter(name="bsVersion")
    def bs_version(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "bs_version")

    @property
    @pulumi.getter(name="ignoreVolumeAz")
    def ignore_volume_az(self) -> Optional[bool]:
        """
        (string)
        """
        return pulumi.get(self, "ignore_volume_az")

    @property
    @pulumi.getter(name="trustDevicePath")
    def trust_device_path(self) -> Optional[bool]:
        """
        (string)
        """
        return pulumi.get(self, "trust_device_path")


@pulumi.output_type
class ClusterCloudProviderOpenstackCloudConfigGlobal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authUrl":
            suggest = "auth_url"
        elif key == "caFile":
            suggest = "ca_file"
        elif key == "domainId":
            suggest = "domain_id"
        elif key == "domainName":
            suggest = "domain_name"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "tenantName":
            suggest = "tenant_name"
        elif key == "trustId":
            suggest = "trust_id"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderOpenstackCloudConfigGlobal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderOpenstackCloudConfigGlobal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderOpenstackCloudConfigGlobal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_url: str,
                 password: str,
                 ca_file: Optional[str] = None,
                 domain_id: Optional[str] = None,
                 domain_name: Optional[str] = None,
                 region: Optional[str] = None,
                 tenant_id: Optional[str] = None,
                 tenant_name: Optional[str] = None,
                 trust_id: Optional[str] = None,
                 user_id: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str auth_url: (string)
        :param str password: Registry password (string)
        :param str ca_file: (string)
        :param str domain_id: Required if `domain_name` not provided. (string)
        :param str domain_name: Required if `domain_id` not provided. (string)
        :param str region: Region for S3 service (string)
        :param str tenant_id: Required if `tenant_name` not provided. (string)
        :param str tenant_name: Required if `tenant_id` not provided. (string)
        :param str trust_id: (string)
        :param str user_id: Required if `username` not provided. (string)
        :param str username: Required if `user_id` not provided. (string)
        """
        pulumi.set(__self__, "auth_url", auth_url)
        pulumi.set(__self__, "password", password)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if tenant_name is not None:
            pulumi.set(__self__, "tenant_name", tenant_name)
        if trust_id is not None:
            pulumi.set(__self__, "trust_id", trust_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="authUrl")
    def auth_url(self) -> str:
        """
        (string)
        """
        return pulumi.get(self, "auth_url")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Registry password (string)
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[str]:
        """
        Required if `domain_name` not provided. (string)
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[str]:
        """
        Required if `domain_id` not provided. (string)
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Region for S3 service (string)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Required if `tenant_name` not provided. (string)
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="tenantName")
    def tenant_name(self) -> Optional[str]:
        """
        Required if `tenant_id` not provided. (string)
        """
        return pulumi.get(self, "tenant_name")

    @property
    @pulumi.getter(name="trustId")
    def trust_id(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "trust_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[str]:
        """
        Required if `username` not provided. (string)
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Required if `user_id` not provided. (string)
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ClusterCloudProviderOpenstackCloudConfigLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createMonitor":
            suggest = "create_monitor"
        elif key == "floatingNetworkId":
            suggest = "floating_network_id"
        elif key == "lbMethod":
            suggest = "lb_method"
        elif key == "lbProvider":
            suggest = "lb_provider"
        elif key == "lbVersion":
            suggest = "lb_version"
        elif key == "manageSecurityGroups":
            suggest = "manage_security_groups"
        elif key == "monitorDelay":
            suggest = "monitor_delay"
        elif key == "monitorMaxRetries":
            suggest = "monitor_max_retries"
        elif key == "monitorTimeout":
            suggest = "monitor_timeout"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "useOctavia":
            suggest = "use_octavia"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderOpenstackCloudConfigLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderOpenstackCloudConfigLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderOpenstackCloudConfigLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_monitor: Optional[bool] = None,
                 floating_network_id: Optional[str] = None,
                 lb_method: Optional[str] = None,
                 lb_provider: Optional[str] = None,
                 lb_version: Optional[str] = None,
                 manage_security_groups: Optional[bool] = None,
                 monitor_delay: Optional[str] = None,
                 monitor_max_retries: Optional[int] = None,
                 monitor_timeout: Optional[str] = None,
                 subnet_id: Optional[str] = None,
                 use_octavia: Optional[bool] = None):
        """
        :param bool create_monitor: (bool)
        :param str floating_network_id: (string)
        :param str lb_method: (string)
        :param str lb_provider: (string)
        :param str lb_version: (string)
        :param bool manage_security_groups: (bool)
        :param str monitor_delay: (string)
        :param int monitor_max_retries: (int)
        :param str monitor_timeout: (string)
        :param str subnet_id: (string)
        :param bool use_octavia: (bool)
        """
        if create_monitor is not None:
            pulumi.set(__self__, "create_monitor", create_monitor)
        if floating_network_id is not None:
            pulumi.set(__self__, "floating_network_id", floating_network_id)
        if lb_method is not None:
            pulumi.set(__self__, "lb_method", lb_method)
        if lb_provider is not None:
            pulumi.set(__self__, "lb_provider", lb_provider)
        if lb_version is not None:
            pulumi.set(__self__, "lb_version", lb_version)
        if manage_security_groups is not None:
            pulumi.set(__self__, "manage_security_groups", manage_security_groups)
        if monitor_delay is not None:
            pulumi.set(__self__, "monitor_delay", monitor_delay)
        if monitor_max_retries is not None:
            pulumi.set(__self__, "monitor_max_retries", monitor_max_retries)
        if monitor_timeout is not None:
            pulumi.set(__self__, "monitor_timeout", monitor_timeout)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if use_octavia is not None:
            pulumi.set(__self__, "use_octavia", use_octavia)

    @property
    @pulumi.getter(name="createMonitor")
    def create_monitor(self) -> Optional[bool]:
        """
        (bool)
        """
        return pulumi.get(self, "create_monitor")

    @property
    @pulumi.getter(name="floatingNetworkId")
    def floating_network_id(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "floating_network_id")

    @property
    @pulumi.getter(name="lbMethod")
    def lb_method(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "lb_method")

    @property
    @pulumi.getter(name="lbProvider")
    def lb_provider(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "lb_provider")

    @property
    @pulumi.getter(name="lbVersion")
    def lb_version(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "lb_version")

    @property
    @pulumi.getter(name="manageSecurityGroups")
    def manage_security_groups(self) -> Optional[bool]:
        """
        (bool)
        """
        return pulumi.get(self, "manage_security_groups")

    @property
    @pulumi.getter(name="monitorDelay")
    def monitor_delay(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "monitor_delay")

    @property
    @pulumi.getter(name="monitorMaxRetries")
    def monitor_max_retries(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "monitor_max_retries")

    @property
    @pulumi.getter(name="monitorTimeout")
    def monitor_timeout(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "monitor_timeout")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="useOctavia")
    def use_octavia(self) -> Optional[bool]:
        """
        (bool)
        """
        return pulumi.get(self, "use_octavia")


@pulumi.output_type
class ClusterCloudProviderOpenstackCloudConfigMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestTimeout":
            suggest = "request_timeout"
        elif key == "searchOrder":
            suggest = "search_order"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderOpenstackCloudConfigMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderOpenstackCloudConfigMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderOpenstackCloudConfigMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 request_timeout: Optional[int] = None,
                 search_order: Optional[str] = None):
        """
        :param int request_timeout: (int)
        :param str search_order: (string)
        """
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)
        if search_order is not None:
            pulumi.set(__self__, "search_order", search_order)

    @property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "request_timeout")

    @property
    @pulumi.getter(name="searchOrder")
    def search_order(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "search_order")


@pulumi.output_type
class ClusterCloudProviderOpenstackCloudConfigRoute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "routerId":
            suggest = "router_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderOpenstackCloudConfigRoute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderOpenstackCloudConfigRoute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderOpenstackCloudConfigRoute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 router_id: Optional[str] = None):
        """
        :param str router_id: (string)
        """
        if router_id is not None:
            pulumi.set(__self__, "router_id", router_id)

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "router_id")


@pulumi.output_type
class ClusterCloudProviderOpenstackCloudProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "global":
            suggest = "global_"
        elif key == "blockStorage":
            suggest = "block_storage"
        elif key == "loadBalancer":
            suggest = "load_balancer"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderOpenstackCloudProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderOpenstackCloudProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderOpenstackCloudProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 global_: 'outputs.ClusterCloudProviderOpenstackCloudProviderGlobal',
                 block_storage: Optional['outputs.ClusterCloudProviderOpenstackCloudProviderBlockStorage'] = None,
                 load_balancer: Optional['outputs.ClusterCloudProviderOpenstackCloudProviderLoadBalancer'] = None,
                 metadata: Optional['outputs.ClusterCloudProviderOpenstackCloudProviderMetadata'] = None,
                 route: Optional['outputs.ClusterCloudProviderOpenstackCloudProviderRoute'] = None):
        """
        :param 'ClusterCloudProviderOpenstackCloudProviderGlobalArgs' global_: (list maxitems:1)
        :param 'ClusterCloudProviderOpenstackCloudProviderBlockStorageArgs' block_storage: (list maxitems:1)
        :param 'ClusterCloudProviderOpenstackCloudProviderLoadBalancerArgs' load_balancer: (list maxitems:1)
        :param 'ClusterCloudProviderOpenstackCloudProviderMetadataArgs' metadata: (list maxitems:1)
        :param 'ClusterCloudProviderOpenstackCloudProviderRouteArgs' route: (list maxitems:1)
        """
        pulumi.set(__self__, "global_", global_)
        if block_storage is not None:
            pulumi.set(__self__, "block_storage", block_storage)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if route is not None:
            pulumi.set(__self__, "route", route)

    @property
    @pulumi.getter(name="global")
    def global_(self) -> 'outputs.ClusterCloudProviderOpenstackCloudProviderGlobal':
        """
        (list maxitems:1)
        """
        return pulumi.get(self, "global_")

    @property
    @pulumi.getter(name="blockStorage")
    def block_storage(self) -> Optional['outputs.ClusterCloudProviderOpenstackCloudProviderBlockStorage']:
        """
        (list maxitems:1)
        """
        return pulumi.get(self, "block_storage")

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional['outputs.ClusterCloudProviderOpenstackCloudProviderLoadBalancer']:
        """
        (list maxitems:1)
        """
        return pulumi.get(self, "load_balancer")

    @property
    @pulumi.getter
    def metadata(self) -> Optional['outputs.ClusterCloudProviderOpenstackCloudProviderMetadata']:
        """
        (list maxitems:1)
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def route(self) -> Optional['outputs.ClusterCloudProviderOpenstackCloudProviderRoute']:
        """
        (list maxitems:1)
        """
        return pulumi.get(self, "route")


@pulumi.output_type
class ClusterCloudProviderOpenstackCloudProviderBlockStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bsVersion":
            suggest = "bs_version"
        elif key == "ignoreVolumeAz":
            suggest = "ignore_volume_az"
        elif key == "trustDevicePath":
            suggest = "trust_device_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderOpenstackCloudProviderBlockStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderOpenstackCloudProviderBlockStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderOpenstackCloudProviderBlockStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bs_version: Optional[str] = None,
                 ignore_volume_az: Optional[bool] = None,
                 trust_device_path: Optional[bool] = None):
        """
        :param str bs_version: (string)
        :param bool ignore_volume_az: (string)
        :param bool trust_device_path: (string)
        """
        if bs_version is not None:
            pulumi.set(__self__, "bs_version", bs_version)
        if ignore_volume_az is not None:
            pulumi.set(__self__, "ignore_volume_az", ignore_volume_az)
        if trust_device_path is not None:
            pulumi.set(__self__, "trust_device_path", trust_device_path)

    @property
    @pulumi.getter(name="bsVersion")
    def bs_version(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "bs_version")

    @property
    @pulumi.getter(name="ignoreVolumeAz")
    def ignore_volume_az(self) -> Optional[bool]:
        """
        (string)
        """
        return pulumi.get(self, "ignore_volume_az")

    @property
    @pulumi.getter(name="trustDevicePath")
    def trust_device_path(self) -> Optional[bool]:
        """
        (string)
        """
        return pulumi.get(self, "trust_device_path")


@pulumi.output_type
class ClusterCloudProviderOpenstackCloudProviderGlobal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authUrl":
            suggest = "auth_url"
        elif key == "caFile":
            suggest = "ca_file"
        elif key == "domainId":
            suggest = "domain_id"
        elif key == "domainName":
            suggest = "domain_name"
        elif key == "tenantId":
            suggest = "tenant_id"
        elif key == "tenantName":
            suggest = "tenant_name"
        elif key == "trustId":
            suggest = "trust_id"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderOpenstackCloudProviderGlobal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderOpenstackCloudProviderGlobal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderOpenstackCloudProviderGlobal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_url: str,
                 password: str,
                 ca_file: Optional[str] = None,
                 domain_id: Optional[str] = None,
                 domain_name: Optional[str] = None,
                 region: Optional[str] = None,
                 tenant_id: Optional[str] = None,
                 tenant_name: Optional[str] = None,
                 trust_id: Optional[str] = None,
                 user_id: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str auth_url: (string)
        :param str password: Registry password (string)
        :param str ca_file: (string)
        :param str domain_id: Required if `domain_name` not provided. (string)
        :param str domain_name: Required if `domain_id` not provided. (string)
        :param str region: Region for S3 service (string)
        :param str tenant_id: Required if `tenant_name` not provided. (string)
        :param str tenant_name: Required if `tenant_id` not provided. (string)
        :param str trust_id: (string)
        :param str user_id: Required if `username` not provided. (string)
        :param str username: Required if `user_id` not provided. (string)
        """
        pulumi.set(__self__, "auth_url", auth_url)
        pulumi.set(__self__, "password", password)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if tenant_name is not None:
            pulumi.set(__self__, "tenant_name", tenant_name)
        if trust_id is not None:
            pulumi.set(__self__, "trust_id", trust_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="authUrl")
    def auth_url(self) -> str:
        """
        (string)
        """
        return pulumi.get(self, "auth_url")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Registry password (string)
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[str]:
        """
        Required if `domain_name` not provided. (string)
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[str]:
        """
        Required if `domain_id` not provided. (string)
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Region for S3 service (string)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[str]:
        """
        Required if `tenant_name` not provided. (string)
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="tenantName")
    def tenant_name(self) -> Optional[str]:
        """
        Required if `tenant_id` not provided. (string)
        """
        return pulumi.get(self, "tenant_name")

    @property
    @pulumi.getter(name="trustId")
    def trust_id(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "trust_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[str]:
        """
        Required if `username` not provided. (string)
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Required if `user_id` not provided. (string)
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ClusterCloudProviderOpenstackCloudProviderLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createMonitor":
            suggest = "create_monitor"
        elif key == "floatingNetworkId":
            suggest = "floating_network_id"
        elif key == "lbMethod":
            suggest = "lb_method"
        elif key == "lbProvider":
            suggest = "lb_provider"
        elif key == "lbVersion":
            suggest = "lb_version"
        elif key == "manageSecurityGroups":
            suggest = "manage_security_groups"
        elif key == "monitorDelay":
            suggest = "monitor_delay"
        elif key == "monitorMaxRetries":
            suggest = "monitor_max_retries"
        elif key == "monitorTimeout":
            suggest = "monitor_timeout"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "useOctavia":
            suggest = "use_octavia"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderOpenstackCloudProviderLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderOpenstackCloudProviderLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderOpenstackCloudProviderLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_monitor: Optional[bool] = None,
                 floating_network_id: Optional[str] = None,
                 lb_method: Optional[str] = None,
                 lb_provider: Optional[str] = None,
                 lb_version: Optional[str] = None,
                 manage_security_groups: Optional[bool] = None,
                 monitor_delay: Optional[str] = None,
                 monitor_max_retries: Optional[int] = None,
                 monitor_timeout: Optional[str] = None,
                 subnet_id: Optional[str] = None,
                 use_octavia: Optional[bool] = None):
        """
        :param bool create_monitor: (bool)
        :param str floating_network_id: (string)
        :param str lb_method: (string)
        :param str lb_provider: (string)
        :param str lb_version: (string)
        :param bool manage_security_groups: (bool)
        :param str monitor_delay: (string)
        :param int monitor_max_retries: (int)
        :param str monitor_timeout: (string)
        :param str subnet_id: (string)
        :param bool use_octavia: (bool)
        """
        if create_monitor is not None:
            pulumi.set(__self__, "create_monitor", create_monitor)
        if floating_network_id is not None:
            pulumi.set(__self__, "floating_network_id", floating_network_id)
        if lb_method is not None:
            pulumi.set(__self__, "lb_method", lb_method)
        if lb_provider is not None:
            pulumi.set(__self__, "lb_provider", lb_provider)
        if lb_version is not None:
            pulumi.set(__self__, "lb_version", lb_version)
        if manage_security_groups is not None:
            pulumi.set(__self__, "manage_security_groups", manage_security_groups)
        if monitor_delay is not None:
            pulumi.set(__self__, "monitor_delay", monitor_delay)
        if monitor_max_retries is not None:
            pulumi.set(__self__, "monitor_max_retries", monitor_max_retries)
        if monitor_timeout is not None:
            pulumi.set(__self__, "monitor_timeout", monitor_timeout)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if use_octavia is not None:
            pulumi.set(__self__, "use_octavia", use_octavia)

    @property
    @pulumi.getter(name="createMonitor")
    def create_monitor(self) -> Optional[bool]:
        """
        (bool)
        """
        return pulumi.get(self, "create_monitor")

    @property
    @pulumi.getter(name="floatingNetworkId")
    def floating_network_id(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "floating_network_id")

    @property
    @pulumi.getter(name="lbMethod")
    def lb_method(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "lb_method")

    @property
    @pulumi.getter(name="lbProvider")
    def lb_provider(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "lb_provider")

    @property
    @pulumi.getter(name="lbVersion")
    def lb_version(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "lb_version")

    @property
    @pulumi.getter(name="manageSecurityGroups")
    def manage_security_groups(self) -> Optional[bool]:
        """
        (bool)
        """
        return pulumi.get(self, "manage_security_groups")

    @property
    @pulumi.getter(name="monitorDelay")
    def monitor_delay(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "monitor_delay")

    @property
    @pulumi.getter(name="monitorMaxRetries")
    def monitor_max_retries(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "monitor_max_retries")

    @property
    @pulumi.getter(name="monitorTimeout")
    def monitor_timeout(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "monitor_timeout")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="useOctavia")
    def use_octavia(self) -> Optional[bool]:
        """
        (bool)
        """
        return pulumi.get(self, "use_octavia")


@pulumi.output_type
class ClusterCloudProviderOpenstackCloudProviderMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestTimeout":
            suggest = "request_timeout"
        elif key == "searchOrder":
            suggest = "search_order"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderOpenstackCloudProviderMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderOpenstackCloudProviderMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderOpenstackCloudProviderMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 request_timeout: Optional[int] = None,
                 search_order: Optional[str] = None):
        """
        :param int request_timeout: (int)
        :param str search_order: (string)
        """
        if request_timeout is not None:
            pulumi.set(__self__, "request_timeout", request_timeout)
        if search_order is not None:
            pulumi.set(__self__, "search_order", search_order)

    @property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "request_timeout")

    @property
    @pulumi.getter(name="searchOrder")
    def search_order(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "search_order")


@pulumi.output_type
class ClusterCloudProviderOpenstackCloudProviderRoute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "routerId":
            suggest = "router_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderOpenstackCloudProviderRoute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderOpenstackCloudProviderRoute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderOpenstackCloudProviderRoute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 router_id: Optional[str] = None):
        """
        :param str router_id: (string)
        """
        if router_id is not None:
            pulumi.set(__self__, "router_id", router_id)

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "router_id")


@pulumi.output_type
class ClusterCloudProviderVsphereCloudConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "virtualCenters":
            suggest = "virtual_centers"
        elif key == "global":
            suggest = "global_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderVsphereCloudConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderVsphereCloudConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderVsphereCloudConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 virtual_centers: Sequence['outputs.ClusterCloudProviderVsphereCloudConfigVirtualCenter'],
                 workspace: 'outputs.ClusterCloudProviderVsphereCloudConfigWorkspace',
                 disk: Optional['outputs.ClusterCloudProviderVsphereCloudConfigDisk'] = None,
                 global_: Optional['outputs.ClusterCloudProviderVsphereCloudConfigGlobal'] = None,
                 network: Optional['outputs.ClusterCloudProviderVsphereCloudConfigNetwork'] = None):
        """
        :param Sequence['ClusterCloudProviderVsphereCloudConfigVirtualCenterArgs'] virtual_centers: (List)
        :param 'ClusterCloudProviderVsphereCloudConfigWorkspaceArgs' workspace: (list maxitems:1)
        :param 'ClusterCloudProviderVsphereCloudConfigDiskArgs' disk: (list maxitems:1)
        :param 'ClusterCloudProviderVsphereCloudConfigGlobalArgs' global_: (list maxitems:1)
        :param 'ClusterCloudProviderVsphereCloudConfigNetworkArgs' network: (list maxitems:1)
        """
        pulumi.set(__self__, "virtual_centers", virtual_centers)
        pulumi.set(__self__, "workspace", workspace)
        if disk is not None:
            pulumi.set(__self__, "disk", disk)
        if global_ is not None:
            pulumi.set(__self__, "global_", global_)
        if network is not None:
            pulumi.set(__self__, "network", network)

    @property
    @pulumi.getter(name="virtualCenters")
    def virtual_centers(self) -> Sequence['outputs.ClusterCloudProviderVsphereCloudConfigVirtualCenter']:
        """
        (List)
        """
        return pulumi.get(self, "virtual_centers")

    @property
    @pulumi.getter
    def workspace(self) -> 'outputs.ClusterCloudProviderVsphereCloudConfigWorkspace':
        """
        (list maxitems:1)
        """
        return pulumi.get(self, "workspace")

    @property
    @pulumi.getter
    def disk(self) -> Optional['outputs.ClusterCloudProviderVsphereCloudConfigDisk']:
        """
        (list maxitems:1)
        """
        return pulumi.get(self, "disk")

    @property
    @pulumi.getter(name="global")
    def global_(self) -> Optional['outputs.ClusterCloudProviderVsphereCloudConfigGlobal']:
        """
        (list maxitems:1)
        """
        return pulumi.get(self, "global_")

    @property
    @pulumi.getter
    def network(self) -> Optional['outputs.ClusterCloudProviderVsphereCloudConfigNetwork']:
        """
        (list maxitems:1)
        """
        return pulumi.get(self, "network")


@pulumi.output_type
class ClusterCloudProviderVsphereCloudConfigDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scsiControllerType":
            suggest = "scsi_controller_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderVsphereCloudConfigDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderVsphereCloudConfigDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderVsphereCloudConfigDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scsi_controller_type: Optional[str] = None):
        """
        :param str scsi_controller_type: (string)
        """
        if scsi_controller_type is not None:
            pulumi.set(__self__, "scsi_controller_type", scsi_controller_type)

    @property
    @pulumi.getter(name="scsiControllerType")
    def scsi_controller_type(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "scsi_controller_type")


@pulumi.output_type
class ClusterCloudProviderVsphereCloudConfigGlobal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "insecureFlag":
            suggest = "insecure_flag"
        elif key == "soapRoundtripCount":
            suggest = "soap_roundtrip_count"
        elif key == "vmName":
            suggest = "vm_name"
        elif key == "vmUuid":
            suggest = "vm_uuid"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderVsphereCloudConfigGlobal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderVsphereCloudConfigGlobal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderVsphereCloudConfigGlobal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datacenter: Optional[str] = None,
                 datacenters: Optional[str] = None,
                 datastore: Optional[str] = None,
                 insecure_flag: Optional[bool] = None,
                 password: Optional[str] = None,
                 port: Optional[str] = None,
                 soap_roundtrip_count: Optional[int] = None,
                 user: Optional[str] = None,
                 vm_name: Optional[str] = None,
                 vm_uuid: Optional[str] = None,
                 working_dir: Optional[str] = None):
        """
        :param str datacenter: (string)
        :param str datacenters: (string)
        :param str datastore: (string)
        :param bool insecure_flag: (bool)
        :param str password: Registry password (string)
        :param str port: Port used for SSH communication (string)
        :param int soap_roundtrip_count: (int)
        :param str user: Registry user (string)
        :param str vm_name: (string)
        :param str vm_uuid: (string)
        :param str working_dir: (string)
        """
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if datacenters is not None:
            pulumi.set(__self__, "datacenters", datacenters)
        if datastore is not None:
            pulumi.set(__self__, "datastore", datastore)
        if insecure_flag is not None:
            pulumi.set(__self__, "insecure_flag", insecure_flag)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if soap_roundtrip_count is not None:
            pulumi.set(__self__, "soap_roundtrip_count", soap_roundtrip_count)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if vm_name is not None:
            pulumi.set(__self__, "vm_name", vm_name)
        if vm_uuid is not None:
            pulumi.set(__self__, "vm_uuid", vm_uuid)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def datacenter(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "datacenter")

    @property
    @pulumi.getter
    def datacenters(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "datacenters")

    @property
    @pulumi.getter
    def datastore(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "datastore")

    @property
    @pulumi.getter(name="insecureFlag")
    def insecure_flag(self) -> Optional[bool]:
        """
        (bool)
        """
        return pulumi.get(self, "insecure_flag")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Registry password (string)
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        Port used for SSH communication (string)
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="soapRoundtripCount")
    def soap_roundtrip_count(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "soap_roundtrip_count")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        Registry user (string)
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="vmName")
    def vm_name(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "vm_name")

    @property
    @pulumi.getter(name="vmUuid")
    def vm_uuid(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "vm_uuid")

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class ClusterCloudProviderVsphereCloudConfigNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicNetwork":
            suggest = "public_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderVsphereCloudConfigNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderVsphereCloudConfigNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderVsphereCloudConfigNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_network: Optional[str] = None):
        """
        :param str public_network: (string)
        """
        if public_network is not None:
            pulumi.set(__self__, "public_network", public_network)

    @property
    @pulumi.getter(name="publicNetwork")
    def public_network(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "public_network")


@pulumi.output_type
class ClusterCloudProviderVsphereCloudConfigVirtualCenter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "soapRoundtripCount":
            suggest = "soap_roundtrip_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderVsphereCloudConfigVirtualCenter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderVsphereCloudConfigVirtualCenter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderVsphereCloudConfigVirtualCenter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datacenters: str,
                 name: str,
                 password: str,
                 user: str,
                 port: Optional[str] = None,
                 soap_roundtrip_count: Optional[int] = None):
        """
        :param str datacenters: (string)
        :param str name: Name of virtualcenter config for Vsphere Cloud Provider config (string)
        :param str password: Registry password (string)
        :param str user: Registry user (string)
        :param str port: Port used for SSH communication (string)
        :param int soap_roundtrip_count: (int)
        """
        pulumi.set(__self__, "datacenters", datacenters)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user", user)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if soap_roundtrip_count is not None:
            pulumi.set(__self__, "soap_roundtrip_count", soap_roundtrip_count)

    @property
    @pulumi.getter
    def datacenters(self) -> str:
        """
        (string)
        """
        return pulumi.get(self, "datacenters")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of virtualcenter config for Vsphere Cloud Provider config (string)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Registry password (string)
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        Registry user (string)
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        Port used for SSH communication (string)
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="soapRoundtripCount")
    def soap_roundtrip_count(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "soap_roundtrip_count")


@pulumi.output_type
class ClusterCloudProviderVsphereCloudConfigWorkspace(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultDatastore":
            suggest = "default_datastore"
        elif key == "resourcepoolPath":
            suggest = "resourcepool_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderVsphereCloudConfigWorkspace. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderVsphereCloudConfigWorkspace.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderVsphereCloudConfigWorkspace.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datacenter: str,
                 server: str,
                 default_datastore: Optional[str] = None,
                 folder: Optional[str] = None,
                 resourcepool_path: Optional[str] = None):
        """
        :param str datacenter: (string)
        :param str server: (string)
        :param str default_datastore: (string)
        :param str folder: Folder for S3 service. Available from Rancher v2.2.7 (string)
        :param str resourcepool_path: (string)
        """
        pulumi.set(__self__, "datacenter", datacenter)
        pulumi.set(__self__, "server", server)
        if default_datastore is not None:
            pulumi.set(__self__, "default_datastore", default_datastore)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if resourcepool_path is not None:
            pulumi.set(__self__, "resourcepool_path", resourcepool_path)

    @property
    @pulumi.getter
    def datacenter(self) -> str:
        """
        (string)
        """
        return pulumi.get(self, "datacenter")

    @property
    @pulumi.getter
    def server(self) -> str:
        """
        (string)
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter(name="defaultDatastore")
    def default_datastore(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "default_datastore")

    @property
    @pulumi.getter
    def folder(self) -> Optional[str]:
        """
        Folder for S3 service. Available from Rancher v2.2.7 (string)
        """
        return pulumi.get(self, "folder")

    @property
    @pulumi.getter(name="resourcepoolPath")
    def resourcepool_path(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "resourcepool_path")


@pulumi.output_type
class ClusterCloudProviderVsphereCloudProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "virtualCenters":
            suggest = "virtual_centers"
        elif key == "global":
            suggest = "global_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderVsphereCloudProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderVsphereCloudProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderVsphereCloudProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 virtual_centers: Sequence['outputs.ClusterCloudProviderVsphereCloudProviderVirtualCenter'],
                 workspace: 'outputs.ClusterCloudProviderVsphereCloudProviderWorkspace',
                 disk: Optional['outputs.ClusterCloudProviderVsphereCloudProviderDisk'] = None,
                 global_: Optional['outputs.ClusterCloudProviderVsphereCloudProviderGlobal'] = None,
                 network: Optional['outputs.ClusterCloudProviderVsphereCloudProviderNetwork'] = None):
        """
        :param Sequence['ClusterCloudProviderVsphereCloudProviderVirtualCenterArgs'] virtual_centers: (List)
        :param 'ClusterCloudProviderVsphereCloudProviderWorkspaceArgs' workspace: (list maxitems:1)
        :param 'ClusterCloudProviderVsphereCloudProviderDiskArgs' disk: (list maxitems:1)
        :param 'ClusterCloudProviderVsphereCloudProviderGlobalArgs' global_: (list maxitems:1)
        :param 'ClusterCloudProviderVsphereCloudProviderNetworkArgs' network: (list maxitems:1)
        """
        pulumi.set(__self__, "virtual_centers", virtual_centers)
        pulumi.set(__self__, "workspace", workspace)
        if disk is not None:
            pulumi.set(__self__, "disk", disk)
        if global_ is not None:
            pulumi.set(__self__, "global_", global_)
        if network is not None:
            pulumi.set(__self__, "network", network)

    @property
    @pulumi.getter(name="virtualCenters")
    def virtual_centers(self) -> Sequence['outputs.ClusterCloudProviderVsphereCloudProviderVirtualCenter']:
        """
        (List)
        """
        return pulumi.get(self, "virtual_centers")

    @property
    @pulumi.getter
    def workspace(self) -> 'outputs.ClusterCloudProviderVsphereCloudProviderWorkspace':
        """
        (list maxitems:1)
        """
        return pulumi.get(self, "workspace")

    @property
    @pulumi.getter
    def disk(self) -> Optional['outputs.ClusterCloudProviderVsphereCloudProviderDisk']:
        """
        (list maxitems:1)
        """
        return pulumi.get(self, "disk")

    @property
    @pulumi.getter(name="global")
    def global_(self) -> Optional['outputs.ClusterCloudProviderVsphereCloudProviderGlobal']:
        """
        (list maxitems:1)
        """
        return pulumi.get(self, "global_")

    @property
    @pulumi.getter
    def network(self) -> Optional['outputs.ClusterCloudProviderVsphereCloudProviderNetwork']:
        """
        (list maxitems:1)
        """
        return pulumi.get(self, "network")


@pulumi.output_type
class ClusterCloudProviderVsphereCloudProviderDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scsiControllerType":
            suggest = "scsi_controller_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderVsphereCloudProviderDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderVsphereCloudProviderDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderVsphereCloudProviderDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scsi_controller_type: Optional[str] = None):
        """
        :param str scsi_controller_type: (string)
        """
        if scsi_controller_type is not None:
            pulumi.set(__self__, "scsi_controller_type", scsi_controller_type)

    @property
    @pulumi.getter(name="scsiControllerType")
    def scsi_controller_type(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "scsi_controller_type")


@pulumi.output_type
class ClusterCloudProviderVsphereCloudProviderGlobal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "insecureFlag":
            suggest = "insecure_flag"
        elif key == "soapRoundtripCount":
            suggest = "soap_roundtrip_count"
        elif key == "vmName":
            suggest = "vm_name"
        elif key == "vmUuid":
            suggest = "vm_uuid"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderVsphereCloudProviderGlobal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderVsphereCloudProviderGlobal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderVsphereCloudProviderGlobal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datacenter: Optional[str] = None,
                 datacenters: Optional[str] = None,
                 datastore: Optional[str] = None,
                 insecure_flag: Optional[bool] = None,
                 password: Optional[str] = None,
                 port: Optional[str] = None,
                 soap_roundtrip_count: Optional[int] = None,
                 user: Optional[str] = None,
                 vm_name: Optional[str] = None,
                 vm_uuid: Optional[str] = None,
                 working_dir: Optional[str] = None):
        """
        :param str datacenter: (string)
        :param str datacenters: (string)
        :param str datastore: (string)
        :param bool insecure_flag: (bool)
        :param str password: Registry password (string)
        :param str port: Port used for SSH communication (string)
        :param int soap_roundtrip_count: (int)
        :param str user: Registry user (string)
        :param str vm_name: (string)
        :param str vm_uuid: (string)
        :param str working_dir: (string)
        """
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if datacenters is not None:
            pulumi.set(__self__, "datacenters", datacenters)
        if datastore is not None:
            pulumi.set(__self__, "datastore", datastore)
        if insecure_flag is not None:
            pulumi.set(__self__, "insecure_flag", insecure_flag)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if soap_roundtrip_count is not None:
            pulumi.set(__self__, "soap_roundtrip_count", soap_roundtrip_count)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if vm_name is not None:
            pulumi.set(__self__, "vm_name", vm_name)
        if vm_uuid is not None:
            pulumi.set(__self__, "vm_uuid", vm_uuid)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def datacenter(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "datacenter")

    @property
    @pulumi.getter
    def datacenters(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "datacenters")

    @property
    @pulumi.getter
    def datastore(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "datastore")

    @property
    @pulumi.getter(name="insecureFlag")
    def insecure_flag(self) -> Optional[bool]:
        """
        (bool)
        """
        return pulumi.get(self, "insecure_flag")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Registry password (string)
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        Port used for SSH communication (string)
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="soapRoundtripCount")
    def soap_roundtrip_count(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "soap_roundtrip_count")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        Registry user (string)
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="vmName")
    def vm_name(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "vm_name")

    @property
    @pulumi.getter(name="vmUuid")
    def vm_uuid(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "vm_uuid")

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class ClusterCloudProviderVsphereCloudProviderNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicNetwork":
            suggest = "public_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderVsphereCloudProviderNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderVsphereCloudProviderNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderVsphereCloudProviderNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_network: Optional[str] = None):
        """
        :param str public_network: (string)
        """
        if public_network is not None:
            pulumi.set(__self__, "public_network", public_network)

    @property
    @pulumi.getter(name="publicNetwork")
    def public_network(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "public_network")


@pulumi.output_type
class ClusterCloudProviderVsphereCloudProviderVirtualCenter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "soapRoundtripCount":
            suggest = "soap_roundtrip_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderVsphereCloudProviderVirtualCenter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderVsphereCloudProviderVirtualCenter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderVsphereCloudProviderVirtualCenter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datacenters: str,
                 name: str,
                 password: str,
                 user: str,
                 port: Optional[str] = None,
                 soap_roundtrip_count: Optional[int] = None):
        """
        :param str datacenters: (string)
        :param str name: Name of virtualcenter config for Vsphere Cloud Provider config (string)
        :param str password: Registry password (string)
        :param str user: Registry user (string)
        :param str port: Port used for SSH communication (string)
        :param int soap_roundtrip_count: (int)
        """
        pulumi.set(__self__, "datacenters", datacenters)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user", user)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if soap_roundtrip_count is not None:
            pulumi.set(__self__, "soap_roundtrip_count", soap_roundtrip_count)

    @property
    @pulumi.getter
    def datacenters(self) -> str:
        """
        (string)
        """
        return pulumi.get(self, "datacenters")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of virtualcenter config for Vsphere Cloud Provider config (string)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Registry password (string)
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        Registry user (string)
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        Port used for SSH communication (string)
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="soapRoundtripCount")
    def soap_roundtrip_count(self) -> Optional[int]:
        """
        (int)
        """
        return pulumi.get(self, "soap_roundtrip_count")


@pulumi.output_type
class ClusterCloudProviderVsphereCloudProviderWorkspace(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultDatastore":
            suggest = "default_datastore"
        elif key == "resourcepoolPath":
            suggest = "resourcepool_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCloudProviderVsphereCloudProviderWorkspace. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCloudProviderVsphereCloudProviderWorkspace.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCloudProviderVsphereCloudProviderWorkspace.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datacenter: str,
                 server: str,
                 default_datastore: Optional[str] = None,
                 folder: Optional[str] = None,
                 resourcepool_path: Optional[str] = None):
        """
        :param str datacenter: (string)
        :param str server: (string)
        :param str default_datastore: (string)
        :param str folder: Folder for S3 service. Available from Rancher v2.2.7 (string)
        :param str resourcepool_path: (string)
        """
        pulumi.set(__self__, "datacenter", datacenter)
        pulumi.set(__self__, "server", server)
        if default_datastore is not None:
            pulumi.set(__self__, "default_datastore", default_datastore)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if resourcepool_path is not None:
            pulumi.set(__self__, "resourcepool_path", resourcepool_path)

    @property
    @pulumi.getter
    def datacenter(self) -> str:
        """
        (string)
        """
        return pulumi.get(self, "datacenter")

    @property
    @pulumi.getter
    def server(self) -> str:
        """
        (string)
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter(name="defaultDatastore")
    def default_datastore(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "default_datastore")

    @property
    @pulumi.getter
    def folder(self) -> Optional[str]:
        """
        Folder for S3 service. Available from Rancher v2.2.7 (string)
        """
        return pulumi.get(self, "folder")

    @property
    @pulumi.getter(name="resourcepoolPath")
    def resourcepool_path(self) -> Optional[str]:
        """
        (string)
        """
        return pulumi.get(self, "resourcepool_path")


@pulumi.output_type
class ClusterControlPlaneHost(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeName":
            suggest = "node_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterControlPlaneHost. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterControlPlaneHost.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterControlPlaneHost.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 node_name: Optional[str] = None):
        """
        :param str address: Address ip for node (string)
        :param str node_name: Name of the host provisioned via docker machine (string)
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Address ip for node (string)
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[str]:
        """
        Name of the host provisioned via docker machine (string)
        """
        return pulumi.get(self, "node_name")


@pulumi.output_type
class ClusterDns(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeSelector":
            suggest = "node_selector"
        elif key == "reverseCidrs":
            suggest = "reverse_cidrs"
        elif key == "upstreamNameservers":
            suggest = "upstream_nameservers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterDns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterDns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterDns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_selector: Optional[Mapping[str, Any]] = None,
                 nodelocal: Optional['outputs.ClusterDnsNodelocal'] = None,
                 provider: Optional[str] = None,
                 reverse_cidrs: Optional[Sequence[str]] = None,
                 upstream_nameservers: Optional[Sequence[str]] = None):
        """
        :param Mapping[str, Any] node_selector: Node selector key pair (map)
        :param 'ClusterDnsNodelocalArgs' nodelocal: Docker image for nodelocal (string)
        :param str provider: Monitoring provider (string)
        :param Sequence[str] reverse_cidrs: Reverse CIDRs  (list)
        :param Sequence[str] upstream_nameservers: Upstream nameservers  (list)
        """
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if nodelocal is not None:
            pulumi.set(__self__, "nodelocal", nodelocal)
        if provider is not None:
            pulumi.set(__self__, "provider", provider)
        if reverse_cidrs is not None:
            pulumi.set(__self__, "reverse_cidrs", reverse_cidrs)
        if upstream_nameservers is not None:
            pulumi.set(__self__, "upstream_nameservers", upstream_nameservers)

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional[Mapping[str, Any]]:
        """
        Node selector key pair (map)
        """
        return pulumi.get(self, "node_selector")

    @property
    @pulumi.getter
    def nodelocal(self) -> Optional['outputs.ClusterDnsNodelocal']:
        """
        Docker image for nodelocal (string)
        """
        return pulumi.get(self, "nodelocal")

    @property
    @pulumi.getter
    def provider(self) -> Optional[str]:
        """
        Monitoring provider (string)
        """
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter(name="reverseCidrs")
    def reverse_cidrs(self) -> Optional[Sequence[str]]:
        """
        Reverse CIDRs  (list)
        """
        return pulumi.get(self, "reverse_cidrs")

    @property
    @pulumi.getter(name="upstreamNameservers")
    def upstream_nameservers(self) -> Optional[Sequence[str]]:
        """
        Upstream nameservers  (list)
        """
        return pulumi.get(self, "upstream_nameservers")


@pulumi.output_type
class ClusterDnsNodelocal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "nodeSelector":
            suggest = "node_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterDnsNodelocal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterDnsNodelocal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterDnsNodelocal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: Optional[str] = None,
                 node_selector: Optional[Mapping[str, Any]] = None):
        """
        :param str ip_address: Nodelocal dns ip address (string)
        :param Mapping[str, Any] node_selector: Node selector key pair (map)
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        Nodelocal dns ip address (string)
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional[Mapping[str, Any]]:
        """
        Node selector key pair (map)
        """
        return pulumi.get(self, "node_selector")


@pulumi.output_type
class ClusterEtcdHost(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeName":
            suggest = "node_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEtcdHost. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEtcdHost.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEtcdHost.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 node_name: Optional[str] = None):
        """
        :param str address: Address ip for node (string)
        :param str node_name: Name of the host provisioned via docker machine (string)
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Address ip for node (string)
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[str]:
        """
        Name of the host provisioned via docker machine (string)
        """
        return pulumi.get(self, "node_name")


@pulumi.output_type
class ClusterInactiveHost(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeName":
            suggest = "node_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterInactiveHost. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterInactiveHost.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterInactiveHost.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 node_name: Optional[str] = None):
        """
        :param str address: Address ip for node (string)
        :param str node_name: Name of the host provisioned via docker machine (string)
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Address ip for node (string)
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[str]:
        """
        Name of the host provisioned via docker machine (string)
        """
        return pulumi.get(self, "node_name")


@pulumi.output_type
class ClusterIngress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultBackend":
            suggest = "default_backend"
        elif key == "dnsPolicy":
            suggest = "dns_policy"
        elif key == "extraArgs":
            suggest = "extra_args"
        elif key == "nodeSelector":
            suggest = "node_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterIngress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterIngress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterIngress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_backend: Optional[bool] = None,
                 dns_policy: Optional[str] = None,
                 extra_args: Optional[Mapping[str, Any]] = None,
                 node_selector: Optional[Mapping[str, Any]] = None,
                 options: Optional[Mapping[str, Any]] = None,
                 provider: Optional[str] = None):
        """
        :param str dns_policy: Ingress controller DNS policy. `ClusterFirstWithHostNet`, `ClusterFirst`, `Default`, and `None` are supported. [K8S dns Policy](https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy) (string)
        :param Mapping[str, Any] extra_args: Extra arguments for scheduler service (map)
        :param Mapping[str, Any] node_selector: Node selector key pair (map)
        :param Mapping[str, Any] options: Network provider options (map)
        :param str provider: Monitoring provider (string)
        """
        if default_backend is not None:
            pulumi.set(__self__, "default_backend", default_backend)
        if dns_policy is not None:
            pulumi.set(__self__, "dns_policy", dns_policy)
        if extra_args is not None:
            pulumi.set(__self__, "extra_args", extra_args)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if provider is not None:
            pulumi.set(__self__, "provider", provider)

    @property
    @pulumi.getter(name="defaultBackend")
    def default_backend(self) -> Optional[bool]:
        return pulumi.get(self, "default_backend")

    @property
    @pulumi.getter(name="dnsPolicy")
    def dns_policy(self) -> Optional[str]:
        """
        Ingress controller DNS policy. `ClusterFirstWithHostNet`, `ClusterFirst`, `Default`, and `None` are supported. [K8S dns Policy](https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy) (string)
        """
        return pulumi.get(self, "dns_policy")

    @property
    @pulumi.getter(name="extraArgs")
    def extra_args(self) -> Optional[Mapping[str, Any]]:
        """
        Extra arguments for scheduler service (map)
        """
        return pulumi.get(self, "extra_args")

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional[Mapping[str, Any]]:
        """
        Node selector key pair (map)
        """
        return pulumi.get(self, "node_selector")

    @property
    @pulumi.getter
    def options(self) -> Optional[Mapping[str, Any]]:
        """
        Network provider options (map)
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def provider(self) -> Optional[str]:
        """
        Monitoring provider (string)
        """
        return pulumi.get(self, "provider")


@pulumi.output_type
class ClusterMonitoring(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeSelector":
            suggest = "node_selector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMonitoring. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMonitoring.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMonitoring.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_selector: Optional[Mapping[str, Any]] = None,
                 options: Optional[Mapping[str, Any]] = None,
                 provider: Optional[str] = None):
        """
        :param Mapping[str, Any] node_selector: Node selector key pair (map)
        :param Mapping[str, Any] options: Network provider options (map)
        :param str provider: Monitoring provider (string)
        """
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if provider is not None:
            pulumi.set(__self__, "provider", provider)

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional[Mapping[str, Any]]:
        """
        Node selector key pair (map)
        """
        return pulumi.get(self, "node_selector")

    @property
    @pulumi.getter
    def options(self) -> Optional[Mapping[str, Any]]:
        """
        Network provider options (map)
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def provider(self) -> Optional[str]:
        """
        Monitoring provider (string)
        """
        return pulumi.get(self, "provider")


@pulumi.output_type
class ClusterNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aciNetworkProvider":
            suggest = "aci_network_provider"
        elif key == "calicoNetworkProvider":
            suggest = "calico_network_provider"
        elif key == "canalNetworkProvider":
            suggest = "canal_network_provider"
        elif key == "flannelNetworkProvider":
            suggest = "flannel_network_provider"
        elif key == "weaveNetworkProvider":
            suggest = "weave_network_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aci_network_provider: Optional['outputs.ClusterNetworkAciNetworkProvider'] = None,
                 calico_network_provider: Optional['outputs.ClusterNetworkCalicoNetworkProvider'] = None,
                 canal_network_provider: Optional['outputs.ClusterNetworkCanalNetworkProvider'] = None,
                 flannel_network_provider: Optional['outputs.ClusterNetworkFlannelNetworkProvider'] = None,
                 mtu: Optional[int] = None,
                 options: Optional[Mapping[str, Any]] = None,
                 plugin: Optional[str] = None,
                 weave_network_provider: Optional['outputs.ClusterNetworkWeaveNetworkProvider'] = None):
        """
        :param 'ClusterNetworkAciNetworkProviderArgs' aci_network_provider: Aci network provider config (list maxitems:1)
        :param 'ClusterNetworkCalicoNetworkProviderArgs' calico_network_provider: Calico network provider config (list maxitems:1)
        :param 'ClusterNetworkCanalNetworkProviderArgs' canal_network_provider: Canal network provider config (list maxitems:1)
        :param 'ClusterNetworkFlannelNetworkProviderArgs' flannel_network_provider: Flannel network provider config (list maxitems:1)
        :param int mtu: Network provider MTU. Default `0` (int)
        :param Mapping[str, Any] options: Network provider options (map)
        :param str plugin: Network provider plugin. `calico`, `canal` (default), `flannel`, `none` and `weave` are supported. (string)
        :param 'ClusterNetworkWeaveNetworkProviderArgs' weave_network_provider: Weave network provider config (list maxitems:1)
        """
        if aci_network_provider is not None:
            pulumi.set(__self__, "aci_network_provider", aci_network_provider)
        if calico_network_provider is not None:
            pulumi.set(__self__, "calico_network_provider", calico_network_provider)
        if canal_network_provider is not None:
            pulumi.set(__self__, "canal_network_provider", canal_network_provider)
        if flannel_network_provider is not None:
            pulumi.set(__self__, "flannel_network_provider", flannel_network_provider)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if plugin is not None:
            pulumi.set(__self__, "plugin", plugin)
        if weave_network_provider is not None:
            pulumi.set(__self__, "weave_network_provider", weave_network_provider)

    @property
    @pulumi.getter(name="aciNetworkProvider")
    def aci_network_provider(self) -> Optional['outputs.ClusterNetworkAciNetworkProvider']:
        """
        Aci network provider config (list maxitems:1)
        """
        return pulumi.get(self, "aci_network_provider")

    @property
    @pulumi.getter(name="calicoNetworkProvider")
    def calico_network_provider(self) -> Optional['outputs.ClusterNetworkCalicoNetworkProvider']:
        """
        Calico network provider config (list maxitems:1)
        """
        return pulumi.get(self, "calico_network_provider")

    @property
    @pulumi.getter(name="canalNetworkProvider")
    def canal_network_provider(self) -> Optional['outputs.ClusterNetworkCanalNetworkProvider']:
        """
        Canal network provider config (list maxitems:1)
        """
        return pulumi.get(self, "canal_network_provider")

    @property
    @pulumi.getter(name="flannelNetworkProvider")
    def flannel_network_provider(self) -> Optional['outputs.ClusterNetworkFlannelNetworkProvider']:
        """
        Flannel network provider config (list maxitems:1)
        """
        return pulumi.get(self, "flannel_network_provider")

    @property
    @pulumi.getter
    def mtu(self) -> Optional[int]:
        """
        Network provider MTU. Default `0` (int)
        """
        return pulumi.get(self, "mtu")

    @property
    @pulumi.getter
    def options(self) -> Optional[Mapping[str, Any]]:
        """
        Network provider options (map)
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def plugin(self) -> Optional[str]:
        """
        Network provider plugin. `calico`, `canal` (default), `flannel`, `none` and `weave` are supported. (string)
        """
        return pulumi.get(self, "plugin")

    @property
    @pulumi.getter(name="weaveNetworkProvider")
    def weave_network_provider(self) -> Optional['outputs.ClusterNetworkWeaveNetworkProvider']:
        """
        Weave network provider config (list maxitems:1)
        """
        return pulumi.get(self, "weave_network_provider")


@pulumi.output_type
class ClusterNetworkAciNetworkProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apicHosts":
            suggest = "apic_hosts"
        elif key == "apicUserCrt":
            suggest = "apic_user_crt"
        elif key == "apicUserKey":
            suggest = "apic_user_key"
        elif key == "apicUserName":
            suggest = "apic_user_name"
        elif key == "encapType":
            suggest = "encap_type"
        elif key == "externDynamic":
            suggest = "extern_dynamic"
        elif key == "externStatic":
            suggest = "extern_static"
        elif key == "infraVlan":
            suggest = "infra_vlan"
        elif key == "kubeApiVlan":
            suggest = "kube_api_vlan"
        elif key == "l3outExternalNetworks":
            suggest = "l3out_external_networks"
        elif key == "mcastRangeEnd":
            suggest = "mcast_range_end"
        elif key == "mcastRangeStart":
            suggest = "mcast_range_start"
        elif key == "nodeSubnet":
            suggest = "node_subnet"
        elif key == "nodeSvcSubnet":
            suggest = "node_svc_subnet"
        elif key == "serviceVlan":
            suggest = "service_vlan"
        elif key == "systemId":
            suggest = "system_id"
        elif key == "vrfName":
            suggest = "vrf_name"
        elif key == "vrfTenant":
            suggest = "vrf_tenant"
        elif key == "snatPortRangeEnd":
            suggest = "snat_port_range_end"
        elif key == "snatPortRangeStart":
            suggest = "snat_port_range_start"
        elif key == "snatPortsPerNode":
            suggest = "snat_ports_per_node"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNetworkAciNetworkProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNetworkAciNetworkProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNetworkAciNetworkProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aep: str,
                 apic_hosts: Sequence[str],
                 apic_user_crt: str,
                 apic_user_key: str,
                 apic_user_name: str,
                 encap_type: str,
                 extern_dynamic: str,
                 extern_static: str,
                 infra_vlan: str,
                 kube_api_vlan: str,
                 l3out: str,
                 l3out_external_networks: Sequence[str],
                 mcast_range_end: str,
                 mcast_range_start: str,
                 node_subnet: str,
                 node_svc_subnet: str,
                 service_vlan: str,
                 system_id: str,
                 token: str,
                 vrf_name: str,
                 vrf_tenant: str,
                 snat_port_range_end: Optional[str] = None,
                 snat_port_range_start: Optional[str] = None,
                 snat_ports_per_node: Optional[str] = None):
        """
        :param str aep: Attachment entity profile name on aci (string)
        :param Sequence[str] apic_hosts: Ip address for apic hosts (list)
        :param str apic_user_crt: Base64 encoded certificate for aci apic user (string)
        :param str apic_user_key: Base64 encoded private key for aci apic user (string)
        :param str apic_user_name: User name for aci apic (string)
        :param str encap_type: One of the supported encap types for aci(vlan/vxlan) (string)
        :param str extern_dynamic: Subnet to use for dynamic external IPs on aci (string)
               * `extern_static"` - (Required) Subnet to use for static external IPs on aci (string)
        :param str infra_vlan: Vlan for infra network on aci (string)
        :param str kube_api_vlan: Vlan for node network on aci (string)
        :param str l3out: L3Out on aci (string)
        :param Sequence[str] l3out_external_networks: L3out external networks on aci (list)
        :param str mcast_range_end: Mcast range end address for endpoint groups on aci (string)
        :param str mcast_range_start: Mcast range start address for endpoint groups on aci (string)
        :param str node_subnet: Kubernetes node address subnet (string)
        :param str node_svc_subnet: Subnet to use for service graph endpoints on aci (string)
        :param str service_vlan: Vlan for service graph nodes on aci (string)
        :param str system_id: Unique suffix for all cluster related objects in aci (string)
        :param str token: UUID for this version of the input configuration (string)
        :param str vrf_name: VRF Name on aci (string)
        :param str vrf_tenant: Tenant for VRF on aci (string)
        :param str snat_port_range_end: Port end range for Source Network Address Translation on aci (string)
        :param str snat_port_range_start: Port start range for Source Network Address Translation on aci (string)
        :param str snat_ports_per_node: Ports per node for Source Network Address Translation on aci (string)
        """
        pulumi.set(__self__, "aep", aep)
        pulumi.set(__self__, "apic_hosts", apic_hosts)
        pulumi.set(__self__, "apic_user_crt", apic_user_crt)
        pulumi.set(__self__, "apic_user_key", apic_user_key)
        pulumi.set(__self__, "apic_user_name", apic_user_name)
        pulumi.set(__self__, "encap_type", encap_type)
        pulumi.set(__self__, "extern_dynamic", extern_dynamic)
        pulumi.set(__self__, "extern_static", extern_static)
        pulumi.set(__self__, "infra_vlan", infra_vlan)
        pulumi.set(__self__, "kube_api_vlan", kube_api_vlan)
        pulumi.set(__self__, "l3out", l3out)
        pulumi.set(__self__, "l3out_external_networks", l3out_external_networks)
        pulumi.set(__self__, "mcast_range_end", mcast_range_end)
        pulumi.set(__self__, "mcast_range_start", mcast_range_start)
        pulumi.set(__self__, "node_subnet", node_subnet)
        pulumi.set(__self__, "node_svc_subnet", node_svc_subnet)
        pulumi.set(__self__, "service_vlan", service_vlan)
        pulumi.set(__self__, "system_id", system_id)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "vrf_name", vrf_name)
        pulumi.set(__self__, "vrf_tenant", vrf_tenant)
        if snat_port_range_end is not None:
            pulumi.set(__self__, "snat_port_range_end", snat_port_range_end)
        if snat_port_range_start is not None:
            pulumi.set(__self__, "snat_port_range_start", snat_port_range_start)
        if snat_ports_per_node is not None:
            pulumi.set(__self__, "snat_ports_per_node", snat_ports_per_node)

    @property
    @pulumi.getter
    def aep(self) -> str:
        """
        Attachment entity profile name on aci (string)
        """
        return pulumi.get(self, "aep")

    @property
    @pulumi.getter(name="apicHosts")
    def apic_hosts(self) -> Sequence[str]:
        """
        Ip address for apic hosts (list)
        """
        return pulumi.get(self, "apic_hosts")

    @property
    @pulumi.getter(name="apicUserCrt")
    def apic_user_crt(self) -> str:
        """
        Base64 encoded certificate for aci apic user (string)
        """
        return pulumi.get(self, "apic_user_crt")

    @property
    @pulumi.getter(name="apicUserKey")
    def apic_user_key(self) -> str:
        """
        Base64 encoded private key for aci apic user (string)
        """
        return pulumi.get(self, "apic_user_key")

    @property
    @pulumi.getter(name="apicUserName")
    def apic_user_name(self) -> str:
        """
        User name for aci apic (string)
        """
        return pulumi.get(self, "apic_user_name")

    @property
    @pulumi.getter(name="encapType")
    def encap_type(self) -> str:
        """
        One of the supported encap types for aci(vlan/vxlan) (string)
        """
        return pulumi.get(self, "encap_type")

    @property
    @pulumi.getter(name="externDynamic")
    def extern_dynamic(self) -> str:
        """
        Subnet to use for dynamic external IPs on aci (string)
        * `extern_static"` - (Required) Subnet to use for static external IPs on aci (string)
        """
        return pulumi.get(self, "extern_dynamic")

    @property
    @pulumi.getter(name="externStatic")
    def extern_static(self) -> str:
        return pulumi.get(self, "extern_static")

    @property
    @pulumi.getter(name="infraVlan")
    def infra_vlan(self) -> str:
        """
        Vlan for infra network on aci (string)
        """
        return pulumi.get(self, "infra_vlan")

    @property
    @pulumi.getter(name="kubeApiVlan")
    def kube_api_vlan(self) -> str:
        """
        Vlan for node network on aci (string)
        """
        return pulumi.get(self, "kube_api_vlan")

    @property
    @pulumi.getter
    def l3out(self) -> str:
        """
        L3Out on aci (string)
        """
        return pulumi.get(self, "l3out")

    @property
    @pulumi.getter(name="l3outExternalNetworks")
    def l3out_external_networks(self) -> Sequence[str]:
        """
        L3out external networks on aci (list)
        """
        return pulumi.get(self, "l3out_external_networks")

    @property
    @pulumi.getter(name="mcastRangeEnd")
    def mcast_range_end(self) -> str:
        """
        Mcast range end address for endpoint groups on aci (string)
        """
        return pulumi.get(self, "mcast_range_end")

    @property
    @pulumi.getter(name="mcastRangeStart")
    def mcast_range_start(self) -> str:
        """
        Mcast range start address for endpoint groups on aci (string)
        """
        return pulumi.get(self, "mcast_range_start")

    @property
    @pulumi.getter(name="nodeSubnet")
    def node_subnet(self) -> str:
        """
        Kubernetes node address subnet (string)
        """
        return pulumi.get(self, "node_subnet")

    @property
    @pulumi.getter(name="nodeSvcSubnet")
    def node_svc_subnet(self) -> str:
        """
        Subnet to use for service graph endpoints on aci (string)
        """
        return pulumi.get(self, "node_svc_subnet")

    @property
    @pulumi.getter(name="serviceVlan")
    def service_vlan(self) -> str:
        """
        Vlan for service graph nodes on aci (string)
        """
        return pulumi.get(self, "service_vlan")

    @property
    @pulumi.getter(name="systemId")
    def system_id(self) -> str:
        """
        Unique suffix for all cluster related objects in aci (string)
        """
        return pulumi.get(self, "system_id")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        UUID for this version of the input configuration (string)
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="vrfName")
    def vrf_name(self) -> str:
        """
        VRF Name on aci (string)
        """
        return pulumi.get(self, "vrf_name")

    @property
    @pulumi.getter(name="vrfTenant")
    def vrf_tenant(self) -> str:
        """
        Tenant for VRF on aci (string)
        """
        return pulumi.get(self, "vrf_tenant")

    @property
    @pulumi.getter(name="snatPortRangeEnd")
    def snat_port_range_end(self) -> Optional[str]:
        """
        Port end range for Source Network Address Translation on aci (string)
        """
        return pulumi.get(self, "snat_port_range_end")

    @property
    @pulumi.getter(name="snatPortRangeStart")
    def snat_port_range_start(self) -> Optional[str]:
        """
        Port start range for Source Network Address Translation on aci (string)
        """
        return pulumi.get(self, "snat_port_range_start")

    @property
    @pulumi.getter(name="snatPortsPerNode")
    def snat_ports_per_node(self) -> Optional[str]:
        """
        Ports per node for Source Network Address Translation on aci (string)
        """
        return pulumi.get(self, "snat_ports_per_node")


@pulumi.output_type
class ClusterNetworkCalicoNetworkProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudProvider":
            suggest = "cloud_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNetworkCalicoNetworkProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNetworkCalicoNetworkProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNetworkCalicoNetworkProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_provider: Optional[str] = None):
        """
        :param str cloud_provider: Calico cloud provider (string)
        """
        if cloud_provider is not None:
            pulumi.set(__self__, "cloud_provider", cloud_provider)

    @property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> Optional[str]:
        """
        Calico cloud provider (string)
        """
        return pulumi.get(self, "cloud_provider")


@pulumi.output_type
class ClusterNetworkCanalNetworkProvider(dict):
    def __init__(__self__, *,
                 iface: Optional[str] = None):
        """
        :param str iface: Flannel network interface (string)
        """
        if iface is not None:
            pulumi.set(__self__, "iface", iface)

    @property
    @pulumi.getter
    def iface(self) -> Optional[str]:
        """
        Flannel network interface (string)
        """
        return pulumi.get(self, "iface")


@pulumi.output_type
class ClusterNetworkFlannelNetworkProvider(dict):
    def __init__(__self__, *,
                 iface: Optional[str] = None):
        """
        :param str iface: Flannel network interface (string)
        """
        if iface is not None:
            pulumi.set(__self__, "iface", iface)

    @property
    @pulumi.getter
    def iface(self) -> Optional[str]:
        """
        Flannel network interface (string)
        """
        return pulumi.get(self, "iface")


@pulumi.output_type
class ClusterNetworkWeaveNetworkProvider(dict):
    def __init__(__self__, *,
                 password: str):
        """
        :param str password: Registry password (string)
        """
        pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Registry password (string)
        """
        return pulumi.get(self, "password")


@pulumi.output_type
class ClusterNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dockerSocket":
            suggest = "docker_socket"
        elif key == "hostnameOverride":
            suggest = "hostname_override"
        elif key == "internalAddress":
            suggest = "internal_address"
        elif key == "nodeName":
            suggest = "node_name"
        elif key == "rolesDeprecated":
            suggest = "roles_deprecated"
        elif key == "sshAgentAuth":
            suggest = "ssh_agent_auth"
        elif key == "sshCert":
            suggest = "ssh_cert"
        elif key == "sshCertPath":
            suggest = "ssh_cert_path"
        elif key == "sshKey":
            suggest = "ssh_key"
        elif key == "sshKeyPath":
            suggest = "ssh_key_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 roles: Sequence[str],
                 user: str,
                 docker_socket: Optional[str] = None,
                 hostname_override: Optional[str] = None,
                 internal_address: Optional[str] = None,
                 labels: Optional[Mapping[str, Any]] = None,
                 node_name: Optional[str] = None,
                 port: Optional[str] = None,
                 roles_deprecated: Optional[str] = None,
                 ssh_agent_auth: Optional[bool] = None,
                 ssh_cert: Optional[str] = None,
                 ssh_cert_path: Optional[str] = None,
                 ssh_key: Optional[str] = None,
                 ssh_key_path: Optional[str] = None,
                 taints: Optional[Sequence['outputs.ClusterNodeTaint']] = None):
        """
        :param str address: Address ip for node (string)
        :param Sequence[str] roles: Node roles in k8s cluster. `controlplane`, `etcd` and `worker` are supported. (list)
        :param str user: Registry user (string)
        :param str docker_socket: Docker socket on the node that will be used in tunneling (string)
        :param str hostname_override: Hostname override for node (string)
        :param str internal_address: Internal address that will be used for components communication (string)
        :param Mapping[str, Any] labels: Node labels (map)
        :param str node_name: Name of the host provisioned via docker machine (string)
        :param str port: Port used for SSH communication (string)
        :param bool ssh_agent_auth: SSH Agent Auth enable (bool)
        :param str ssh_cert: SSH Certificate (string)
        :param str ssh_cert_path: SSH Certificate path (string)
        :param str ssh_key: SSH Private Key (string)
        :param str ssh_key_path: SSH Private Key path (string)
        :param Sequence['ClusterNodeTaintArgs'] taints: Node taints (list)
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "roles", roles)
        pulumi.set(__self__, "user", user)
        if docker_socket is not None:
            pulumi.set(__self__, "docker_socket", docker_socket)
        if hostname_override is not None:
            pulumi.set(__self__, "hostname_override", hostname_override)
        if internal_address is not None:
            pulumi.set(__self__, "internal_address", internal_address)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if roles_deprecated is not None:
            pulumi.set(__self__, "roles_deprecated", roles_deprecated)
        if ssh_agent_auth is not None:
            pulumi.set(__self__, "ssh_agent_auth", ssh_agent_auth)
        if ssh_cert is not None:
            pulumi.set(__self__, "ssh_cert", ssh_cert)
        if ssh_cert_path is not None:
            pulumi.set(__self__, "ssh_cert_path", ssh_cert_path)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if ssh_key_path is not None:
            pulumi.set(__self__, "ssh_key_path", ssh_key_path)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        Address ip for node (string)
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def roles(self) -> Sequence[str]:
        """
        Node roles in k8s cluster. `controlplane`, `etcd` and `worker` are supported. (list)
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        Registry user (string)
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="dockerSocket")
    def docker_socket(self) -> Optional[str]:
        """
        Docker socket on the node that will be used in tunneling (string)
        """
        return pulumi.get(self, "docker_socket")

    @property
    @pulumi.getter(name="hostnameOverride")
    def hostname_override(self) -> Optional[str]:
        """
        Hostname override for node (string)
        """
        return pulumi.get(self, "hostname_override")

    @property
    @pulumi.getter(name="internalAddress")
    def internal_address(self) -> Optional[str]:
        """
        Internal address that will be used for components communication (string)
        """
        return pulumi.get(self, "internal_address")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, Any]]:
        """
        Node labels (map)
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[str]:
        """
        Name of the host provisioned via docker machine (string)
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        Port used for SSH communication (string)
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="rolesDeprecated")
    def roles_deprecated(self) -> Optional[str]:
        return pulumi.get(self, "roles_deprecated")

    @property
    @pulumi.getter(name="sshAgentAuth")
    def ssh_agent_auth(self) -> Optional[bool]:
        """
        SSH Agent Auth enable (bool)
        """
        return pulumi.get(self, "ssh_agent_auth")

    @property
    @pulumi.getter(name="sshCert")
    def ssh_cert(self) -> Optional[str]:
        """
        SSH Certificate (string)
        """
        return pulumi.get(self, "ssh_cert")

    @property
    @pulumi.getter(name="sshCertPath")
    def ssh_cert_path(self) -> Optional[str]:
        """
        SSH Certificate path (string)
        """
        return pulumi.get(self, "ssh_cert_path")

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[str]:
        """
        SSH Private Key (string)
        """
        return pulumi.get(self, "ssh_key")

    @property
    @pulumi.getter(name="sshKeyPath")
    def ssh_key_path(self) -> Optional[str]:
        """
        SSH Private Key path (string)
        """
        return pulumi.get(self, "ssh_key_path")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.ClusterNodeTaint']]:
        """
        Node taints (list)
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class ClusterNodeTaint(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str,
                 effect: Optional[str] = None):
        """
        :param str key: TLS key for etcd service (string)
        :param str value: Taint value (string)
        :param str effect: Taint effect. `NoExecute`, `NoSchedule` (default) and `PreferNoSchedule` are supported (string)
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if effect is not None:
            pulumi.set(__self__, "effect", effect)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        TLS key for etcd service (string)
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Taint value (string)
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def effect(self) -> Optional[str]:
        """
        Taint effect. `NoExecute`, `NoSchedule` (default) and `PreferNoSchedule` are supported (string)
        """
        return pulumi.get(self, "effect")


@pulumi.output_type
class ClusterPrivateRegistry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isDefault":
            suggest = "is_default"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterPrivateRegistry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterPrivateRegistry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterPrivateRegistry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 url: str,
                 is_default: Optional[bool] = None,
                 password: Optional[str] = None,
                 user: Optional[str] = None):
        """
        :param str url: Registry URL (string)
        :param bool is_default: Set as default registry. Default `false` (bool)
        :param str password: Registry password (string)
        :param str user: Registry user (string)
        """
        pulumi.set(__self__, "url", url)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Registry URL (string)
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[bool]:
        """
        Set as default registry. Default `false` (bool)
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Registry password (string)
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        Registry user (string)
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ClusterRestore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotName":
            suggest = "snapshot_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterRestore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterRestore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterRestore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 restore: Optional[bool] = None,
                 snapshot_name: Optional[str] = None):
        """
        :param bool restore: Restore cluster. Default `false` (bool)
        :param str snapshot_name: Snapshot name (string)
        """
        if restore is not None:
            pulumi.set(__self__, "restore", restore)
        if snapshot_name is not None:
            pulumi.set(__self__, "snapshot_name", snapshot_name)

    @property
    @pulumi.getter
    def restore(self) -> Optional[bool]:
        """
        Restore cluster. Default `false` (bool)
        """
        return pulumi.get(self, "restore")

    @property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> Optional[str]:
        """
        Snapshot name (string)
        """
        return pulumi.get(self, "snapshot_name")


@pulumi.output_type
class ClusterRotateCertificates(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCertificates":
            suggest = "ca_certificates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterRotateCertificates. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterRotateCertificates.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterRotateCertificates.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certificates: Optional[bool] = None,
                 services: Optional[Sequence[str]] = None):
        """
        :param bool ca_certificates: Rotate CA Certificates. Default `false` (bool)
        :param Sequence[str] services: Services to rotate their certs. `etcd`, `kubelet`, `kube-apiserver`, `kube-proxy`, `kube-scheduler` and `kube-controller-manager` are supported (list)
        """
        if ca_certificates is not None:
            pulumi.set(__self__, "ca_certificates", ca_certificates)
        if services is not None:
            pulumi.set(__self__, "services", services)

    @property
    @pulumi.getter(name="caCertificates")
    def ca_certificates(self) -> Optional[bool]:
        """
        Rotate CA Certificates. Default `false` (bool)
        """
        return pulumi.get(self, "ca_certificates")

    @property
    @pulumi.getter
    def services(self) -> Optional[Sequence[str]]:
        """
        Services to rotate their certs. `etcd`, `kubelet`, `kube-apiserver`, `kube-proxy`, `kube-scheduler` and `kube-controller-manager` are supported (list)
        """
        return pulumi.get(self, "services")


@pulumi.output_type
class ClusterRunningSystemImages(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aciCniDeployContainer":
            suggest = "aci_cni_deploy_container"
        elif key == "aciControllerContainer":
            suggest = "aci_controller_container"
        elif key == "aciHostContainer":
            suggest = "aci_host_container"
        elif key == "aciMcastContainer":
            suggest = "aci_mcast_container"
        elif key == "aciOpflexContainer":
            suggest = "aci_opflex_container"
        elif key == "aciOvsContainer":
            suggest = "aci_ovs_container"
        elif key == "calicoCni":
            suggest = "calico_cni"
        elif key == "calicoControllers":
            suggest = "calico_controllers"
        elif key == "calicoCtl":
            suggest = "calico_ctl"
        elif key == "calicoFlexVol":
            suggest = "calico_flex_vol"
        elif key == "calicoNode":
            suggest = "calico_node"
        elif key == "canalCni":
            suggest = "canal_cni"
        elif key == "canalFlannel":
            suggest = "canal_flannel"
        elif key == "canalFlexVol":
            suggest = "canal_flex_vol"
        elif key == "canalNode":
            suggest = "canal_node"
        elif key == "certDownloader":
            suggest = "cert_downloader"
        elif key == "corednsAutoscaler":
            suggest = "coredns_autoscaler"
        elif key == "flannelCni":
            suggest = "flannel_cni"
        elif key == "ingressBackend":
            suggest = "ingress_backend"
        elif key == "kubeDns":
            suggest = "kube_dns"
        elif key == "kubeDnsAutoscaler":
            suggest = "kube_dns_autoscaler"
        elif key == "kubeDnsSidecar":
            suggest = "kube_dns_sidecar"
        elif key == "kubernetesServicesSidecar":
            suggest = "kubernetes_services_sidecar"
        elif key == "metricsServer":
            suggest = "metrics_server"
        elif key == "nginxProxy":
            suggest = "nginx_proxy"
        elif key == "podInfraContainer":
            suggest = "pod_infra_container"
        elif key == "weaveCni":
            suggest = "weave_cni"
        elif key == "weaveNode":
            suggest = "weave_node"
        elif key == "windowsPodInfraContainer":
            suggest = "windows_pod_infra_container"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterRunningSystemImages. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterRunningSystemImages.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterRunningSystemImages.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aci_cni_deploy_container: Optional[str] = None,
                 aci_controller_container: Optional[str] = None,
                 aci_host_container: Optional[str] = None,
                 aci_mcast_container: Optional[str] = None,
                 aci_opflex_container: Optional[str] = None,
                 aci_ovs_container: Optional[str] = None,
                 alpine: Optional[str] = None,
                 calico_cni: Optional[str] = None,
                 calico_controllers: Optional[str] = None,
                 calico_ctl: Optional[str] = None,
                 calico_flex_vol: Optional[str] = None,
                 calico_node: Optional[str] = None,
                 canal_cni: Optional[str] = None,
                 canal_flannel: Optional[str] = None,
                 canal_flex_vol: Optional[str] = None,
                 canal_node: Optional[str] = None,
                 cert_downloader: Optional[str] = None,
                 coredns: Optional[str] = None,
                 coredns_autoscaler: Optional[str] = None,
                 dnsmasq: Optional[str] = None,
                 etcd: Optional[str] = None,
                 flannel: Optional[str] = None,
                 flannel_cni: Optional[str] = None,
                 ingress: Optional[str] = None,
                 ingress_backend: Optional[str] = None,
                 kube_dns: Optional[str] = None,
                 kube_dns_autoscaler: Optional[str] = None,
                 kube_dns_sidecar: Optional[str] = None,
                 kubernetes: Optional[str] = None,
                 kubernetes_services_sidecar: Optional[str] = None,
                 metrics_server: Optional[str] = None,
                 nginx_proxy: Optional[str] = None,
                 nodelocal: Optional[str] = None,
                 pod_infra_container: Optional[str] = None,
                 weave_cni: Optional[str] = None,
                 weave_node: Optional[str] = None,
                 windows_pod_infra_container: Optional[str] = None):
        """
        :param str aci_cni_deploy_container: Docker image for aci_cni_deploy_container (string)
        :param str aci_controller_container: Docker image for aci_controller_container (string)
        :param str aci_host_container: Docker image for aci_host_container (string)
        :param str aci_mcast_container: Docker image for aci_mcast_container (string)
        :param str aci_opflex_container: Docker image for aci_opflex_container (string)
        :param str aci_ovs_container: Docker image for aci_ovs_container (string)
        :param str alpine: Docker image for alpine (string)
        :param str calico_cni: Docker image for calico_cni (string)
        :param str calico_controllers: Docker image for calico_controllers (string)
        :param str calico_ctl: Docker image for calico_ctl (string)
        :param str calico_flex_vol: Docker image for calico_flex_vol (string)
        :param str calico_node: Docker image for calico_node (string)
        :param str canal_cni: Docker image for canal_cni (string)
        :param str canal_flannel: Docker image for canal_flannel (string)
        :param str canal_flex_vol: Docker image for canal_flex_vol (string)
        :param str canal_node: Docker image for canal_node (string)
        :param str cert_downloader: Docker image for cert_downloader (string)
        :param str coredns: Docker image for coredns (string)
        :param str coredns_autoscaler: Docker image for coredns_autoscaler (string)
        :param str dnsmasq: Docker image for dnsmasq (string)
        :param str etcd: Docker image for etcd (string)
        :param str flannel: Docker image for flannel (string)
        :param str flannel_cni: Docker image for flannel_cni (string)
        :param str ingress: Docker image for ingress (string)
        :param str ingress_backend: Docker image for ingress_backend (string)
        :param str kube_dns: Docker image for kube_dns (string)
        :param str kube_dns_autoscaler: Docker image for kube_dns_autoscaler (string)
        :param str kube_dns_sidecar: Docker image for kube_dns_sidecar (string)
        :param str kubernetes: Docker image for kubernetes (string)
        :param str kubernetes_services_sidecar: Docker image for kubernetes_services_sidecar (string)
        :param str metrics_server: Docker image for metrics_server (string)
        :param str nginx_proxy: Docker image for nginx_proxy (string)
        :param str nodelocal: Docker image for nodelocal (string)
        :param str pod_infra_container: Docker image for pod_infra_container (string)
        :param str weave_cni: Docker image for weave_cni (string)
        :param str weave_node: Docker image for weave_node (string)
        :param str windows_pod_infra_container: Docker image for windows_pod_infra_container (string)
        """
        if aci_cni_deploy_container is not None:
            pulumi.set(__self__, "aci_cni_deploy_container", aci_cni_deploy_container)
        if aci_controller_container is not None:
            pulumi.set(__self__, "aci_controller_container", aci_controller_container)
        if aci_host_container is not None:
            pulumi.set(__self__, "aci_host_container", aci_host_container)
        if aci_mcast_container is not None:
            pulumi.set(__self__, "aci_mcast_container", aci_mcast_container)
        if aci_opflex_container is not None:
            pulumi.set(__self__, "aci_opflex_container", aci_opflex_container)
        if aci_ovs_container is not None:
            pulumi.set(__self__, "aci_ovs_container", aci_ovs_container)
        if alpine is not None:
            pulumi.set(__self__, "alpine", alpine)
        if calico_cni is not None:
            pulumi.set(__self__, "calico_cni", calico_cni)
        if calico_controllers is not None:
            pulumi.set(__self__, "calico_controllers", calico_controllers)
        if calico_ctl is not None:
            pulumi.set(__self__, "calico_ctl", calico_ctl)
        if calico_flex_vol is not None:
            pulumi.set(__self__, "calico_flex_vol", calico_flex_vol)
        if calico_node is not None:
            pulumi.set(__self__, "calico_node", calico_node)
        if canal_cni is not None:
            pulumi.set(__self__, "canal_cni", canal_cni)
        if canal_flannel is not None:
            pulumi.set(__self__, "canal_flannel", canal_flannel)
        if canal_flex_vol is not None:
            pulumi.set(__self__, "canal_flex_vol", canal_flex_vol)
        if canal_node is not None:
            pulumi.set(__self__, "canal_node", canal_node)
        if cert_downloader is not None:
            pulumi.set(__self__, "cert_downloader", cert_downloader)
        if coredns is not None:
            pulumi.set(__self__, "coredns", coredns)
        if coredns_autoscaler is not None:
            pulumi.set(__self__, "coredns_autoscaler", coredns_autoscaler)
        if dnsmasq is not None:
            pulumi.set(__self__, "dnsmasq", dnsmasq)
        if etcd is not None:
            pulumi.set(__self__, "etcd", etcd)
        if flannel is not None:
            pulumi.set(__self__, "flannel", flannel)
        if flannel_cni is not None:
            pulumi.set(__self__, "flannel_cni", flannel_cni)
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)
        if ingress_backend is not None:
            pulumi.set(__self__, "ingress_backend", ingress_backend)
        if kube_dns is not None:
            pulumi.set(__self__, "kube_dns", kube_dns)
        if kube_dns_autoscaler is not None:
            pulumi.set(__self__, "kube_dns_autoscaler", kube_dns_autoscaler)
        if kube_dns_sidecar is not None:
            pulumi.set(__self__, "kube_dns_sidecar", kube_dns_sidecar)
        if kubernetes is not None:
            pulumi.set(__self__, "kubernetes", kubernetes)
        if kubernetes_services_sidecar is not None:
            pulumi.set(__self__, "kubernetes_services_sidecar", kubernetes_services_sidecar)
        if metrics_server is not None:
            pulumi.set(__self__, "metrics_server", metrics_server)
        if nginx_proxy is not None:
            pulumi.set(__self__, "nginx_proxy", nginx_proxy)
        if nodelocal is not None:
            pulumi.set(__self__, "nodelocal", nodelocal)
        if pod_infra_container is not None:
            pulumi.set(__self__, "pod_infra_container", pod_infra_container)
        if weave_cni is not None:
            pulumi.set(__self__, "weave_cni", weave_cni)
        if weave_node is not None:
            pulumi.set(__self__, "weave_node", weave_node)
        if windows_pod_infra_container is not None:
            pulumi.set(__self__, "windows_pod_infra_container", windows_pod_infra_container)

    @property
    @pulumi.getter(name="aciCniDeployContainer")
    def aci_cni_deploy_container(self) -> Optional[str]:
        """
        Docker image for aci_cni_deploy_container (string)
        """
        return pulumi.get(self, "aci_cni_deploy_container")

    @property
    @pulumi.getter(name="aciControllerContainer")
    def aci_controller_container(self) -> Optional[str]:
        """
        Docker image for aci_controller_container (string)
        """
        return pulumi.get(self, "aci_controller_container")

    @property
    @pulumi.getter(name="aciHostContainer")
    def aci_host_container(self) -> Optional[str]:
        """
        Docker image for aci_host_container (string)
        """
        return pulumi.get(self, "aci_host_container")

    @property
    @pulumi.getter(name="aciMcastContainer")
    def aci_mcast_container(self) -> Optional[str]:
        """
        Docker image for aci_mcast_container (string)
        """
        return pulumi.get(self, "aci_mcast_container")

    @property
    @pulumi.getter(name="aciOpflexContainer")
    def aci_opflex_container(self) -> Optional[str]:
        """
        Docker image for aci_opflex_container (string)
        """
        return pulumi.get(self, "aci_opflex_container")

    @property
    @pulumi.getter(name="aciOvsContainer")
    def aci_ovs_container(self) -> Optional[str]:
        """
        Docker image for aci_ovs_container (string)
        """
        return pulumi.get(self, "aci_ovs_container")

    @property
    @pulumi.getter
    def alpine(self) -> Optional[str]:
        """
        Docker image for alpine (string)
        """
        return pulumi.get(self, "alpine")

    @property
    @pulumi.getter(name="calicoCni")
    def calico_cni(self) -> Optional[str]:
        """
        Docker image for calico_cni (string)
        """
        return pulumi.get(self, "calico_cni")

    @property
    @pulumi.getter(name="calicoControllers")
    def calico_controllers(self) -> Optional[str]:
        """
        Docker image for calico_controllers (string)
        """
        return pulumi.get(self, "calico_controllers")

    @property
    @pulumi.getter(name="calicoCtl")
    def calico_ctl(self) -> Optional[str]:
        """
        Docker image for calico_ctl (string)
        """
        return pulumi.get(self, "calico_ctl")

    @property
    @pulumi.getter(name="calicoFlexVol")
    def calico_flex_vol(self) -> Optional[str]:
        """
        Docker image for calico_flex_vol (string)
        """
        return pulumi.get(self, "calico_flex_vol")

    @property
    @pulumi.getter(name="calicoNode")
    def calico_node(self) -> Optional[str]:
        """
        Docker image for calico_node (string)
        """
        return pulumi.get(self, "calico_node")

    @property
    @pulumi.getter(name="canalCni")
    def canal_cni(self) -> Optional[str]:
        """
        Docker image for canal_cni (string)
        """
        return pulumi.get(self, "canal_cni")

    @property
    @pulumi.getter(name="canalFlannel")
    def canal_flannel(self) -> Optional[str]:
        """
        Docker image for canal_flannel (string)
        """
        return pulumi.get(self, "canal_flannel")

    @property
    @pulumi.getter(name="canalFlexVol")
    def canal_flex_vol(self) -> Optional[str]:
        """
        Docker image for canal_flex_vol (string)
        """
        return pulumi.get(self, "canal_flex_vol")

    @property
    @pulumi.getter(name="canalNode")
    def canal_node(self) -> Optional[str]:
        """
        Docker image for canal_node (string)
        """
        return pulumi.get(self, "canal_node")

    @property
    @pulumi.getter(name="certDownloader")
    def cert_downloader(self) -> Optional[str]:
        """
        Docker image for cert_downloader (string)
        """
        return pulumi.get(self, "cert_downloader")

    @property
    @pulumi.getter
    def coredns(self) -> Optional[str]:
        """
        Docker image for coredns (string)
        """
        return pulumi.get(self, "coredns")

    @property
    @pulumi.getter(name="corednsAutoscaler")
    def coredns_autoscaler(self) -> Optional[str]:
        """
        Docker image for coredns_autoscaler (string)
        """
        return pulumi.get(self, "coredns_autoscaler")

    @property
    @pulumi.getter
    def dnsmasq(self) -> Optional[str]:
        """
        Docker image for dnsmasq (string)
        """
        return pulumi.get(self, "dnsmasq")

    @property
    @pulumi.getter
    def etcd(self) -> Optional[str]:
        """
        Docker image for etcd (string)
        """
        return pulumi.get(self, "etcd")

    @property
    @pulumi.getter
    def flannel(self) -> Optional[str]:
        """
        Docker image for flannel (string)
        """
        return pulumi.get(self, "flannel")

    @property
    @pulumi.getter(name="flannelCni")
    def flannel_cni(self) -> Optional[str]:
        """
        Docker image for flannel_cni (string)
        """
        return pulumi.get(self, "flannel_cni")

    @property
    @pulumi.getter
    def ingress(self) -> Optional[str]:
        """
        Docker image for ingress (string)
        """
        return pulumi.get(self, "ingress")

    @property
    @pulumi.getter(name="ingressBackend")
    def ingress_backend(self) -> Optional[str]:
        """
        Docker image for ingress_backend (string)
        """
        return pulumi.get(self, "ingress_backend")

    @property
    @pulumi.getter(name="kubeDns")
    def kube_dns(self) -> Optional[str]:
        """
        Docker image for kube_dns (string)
        """
        return pulumi.get(self, "kube_dns")

    @property
    @pulumi.getter(name="kubeDnsAutoscaler")
    def kube_dns_autoscaler(self) -> Optional[str]:
        """
        Docker image for kube_dns_autoscaler (string)
        """
        return pulumi.get(self, "kube_dns_autoscaler")

    @property
    @pulumi.getter(name="kubeDnsSidecar")
    def kube_dns_sidecar(self) -> Optional[str]:
        """
        Docker image for kube_dns_sidecar (string)
        """
        return pulumi.get(self, "kube_dns_sidecar")

    @property
    @pulumi.getter
    def kubernetes(self) -> Optional[str]:
        """
        Docker image for kubernetes (string)
        """
        return pulumi.get(self, "kubernetes")

    @property
    @pulumi.getter(name="kubernetesServicesSidecar")
    def kubernetes_services_sidecar(self) -> Optional[str]:
        """
        Docker image for kubernetes_services_sidecar (string)
        """
        return pulumi.get(self, "kubernetes_services_sidecar")

    @property
    @pulumi.getter(name="metricsServer")
    def metrics_server(self) -> Optional[str]:
        """
        Docker image for metrics_server (string)
        """
        return pulumi.get(self, "metrics_server")

    @property
    @pulumi.getter(name="nginxProxy")
    def nginx_proxy(self) -> Optional[str]:
        """
        Docker image for nginx_proxy (string)
        """
        return pulumi.get(self, "nginx_proxy")

    @property
    @pulumi.getter
    def nodelocal(self) -> Optional[str]:
        """
        Docker image for nodelocal (string)
        """
        return pulumi.get(self, "nodelocal")

    @property
    @pulumi.getter(name="podInfraContainer")
    def pod_infra_container(self) -> Optional[str]:
        """
        Docker image for pod_infra_container (string)
        """
        return pulumi.get(self, "pod_infra_container")

    @property
    @pulumi.getter(name="weaveCni")
    def weave_cni(self) -> Optional[str]:
        """
        Docker image for weave_cni (string)
        """
        return pulumi.get(self, "weave_cni")

    @property
    @pulumi.getter(name="weaveNode")
    def weave_node(self) -> Optional[str]:
        """
        Docker image for weave_node (string)
        """
        return pulumi.get(self, "weave_node")

    @property
    @pulumi.getter(name="windowsPodInfraContainer")
    def windows_pod_infra_container(self) -> Optional[str]:
        """
        Docker image for windows_pod_infra_container (string)
        """
        return pulumi.get(self, "windows_pod_infra_container")


@pulumi.output_type
class ClusterServices(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kubeApi":
            suggest = "kube_api"
        elif key == "kubeController":
            suggest = "kube_controller"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServices. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServices.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServices.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 etcd: Optional['outputs.ClusterServicesEtcd'] = None,
                 kube_api: Optional['outputs.ClusterServicesKubeApi'] = None,
                 kube_controller: Optional['outputs.ClusterServicesKubeController'] = None,
                 kubelet: Optional['outputs.ClusterServicesKubelet'] = None,
                 kubeproxy: Optional['outputs.ClusterServicesKubeproxy'] = None,
                 scheduler: Optional['outputs.ClusterServicesScheduler'] = None):
        """
        :param 'ClusterServicesEtcdArgs' etcd: Docker image for etcd (string)
        :param 'ClusterServicesKubeApiArgs' kube_api: Kube API options for RKE services (list maxitems:1)
        :param 'ClusterServicesKubeControllerArgs' kube_controller: Kube Controller options for RKE services (list maxitems:1)
        :param 'ClusterServicesKubeletArgs' kubelet: Kubelet options for RKE services (list maxitems:1)
        :param 'ClusterServicesKubeproxyArgs' kubeproxy: Kubeproxy options for RKE services (list maxitems:1)
        :param 'ClusterServicesSchedulerArgs' scheduler: Scheduler options for RKE services (list maxitems:1)
        """
        if etcd is not None:
            pulumi.set(__self__, "etcd", etcd)
        if kube_api is not None:
            pulumi.set(__self__, "kube_api", kube_api)
        if kube_controller is not None:
            pulumi.set(__self__, "kube_controller", kube_controller)
        if kubelet is not None:
            pulumi.set(__self__, "kubelet", kubelet)
        if kubeproxy is not None:
            pulumi.set(__self__, "kubeproxy", kubeproxy)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)

    @property
    @pulumi.getter
    def etcd(self) -> Optional['outputs.ClusterServicesEtcd']:
        """
        Docker image for etcd (string)
        """
        return pulumi.get(self, "etcd")

    @property
    @pulumi.getter(name="kubeApi")
    def kube_api(self) -> Optional['outputs.ClusterServicesKubeApi']:
        """
        Kube API options for RKE services (list maxitems:1)
        """
        return pulumi.get(self, "kube_api")

    @property
    @pulumi.getter(name="kubeController")
    def kube_controller(self) -> Optional['outputs.ClusterServicesKubeController']:
        """
        Kube Controller options for RKE services (list maxitems:1)
        """
        return pulumi.get(self, "kube_controller")

    @property
    @pulumi.getter
    def kubelet(self) -> Optional['outputs.ClusterServicesKubelet']:
        """
        Kubelet options for RKE services (list maxitems:1)
        """
        return pulumi.get(self, "kubelet")

    @property
    @pulumi.getter
    def kubeproxy(self) -> Optional['outputs.ClusterServicesKubeproxy']:
        """
        Kubeproxy options for RKE services (list maxitems:1)
        """
        return pulumi.get(self, "kubeproxy")

    @property
    @pulumi.getter
    def scheduler(self) -> Optional['outputs.ClusterServicesScheduler']:
        """
        Scheduler options for RKE services (list maxitems:1)
        """
        return pulumi.get(self, "scheduler")


@pulumi.output_type
class ClusterServicesEtcd(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupConfig":
            suggest = "backup_config"
        elif key == "caCert":
            suggest = "ca_cert"
        elif key == "externalUrls":
            suggest = "external_urls"
        elif key == "extraArgs":
            suggest = "extra_args"
        elif key == "extraBinds":
            suggest = "extra_binds"
        elif key == "extraEnvs":
            suggest = "extra_envs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServicesEtcd. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServicesEtcd.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServicesEtcd.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_config: Optional['outputs.ClusterServicesEtcdBackupConfig'] = None,
                 ca_cert: Optional[str] = None,
                 cert: Optional[str] = None,
                 creation: Optional[str] = None,
                 external_urls: Optional[Sequence[str]] = None,
                 extra_args: Optional[Mapping[str, Any]] = None,
                 extra_binds: Optional[Sequence[str]] = None,
                 extra_envs: Optional[Sequence[str]] = None,
                 gid: Optional[int] = None,
                 image: Optional[str] = None,
                 key: Optional[str] = None,
                 path: Optional[str] = None,
                 retention: Optional[str] = None,
                 snapshot: Optional[bool] = None,
                 uid: Optional[int] = None):
        """
        :param 'ClusterServicesEtcdBackupConfigArgs' backup_config: Backup options for etcd service. Just for Rancher v2.2.x (list maxitems:1)
        :param str ca_cert: TLS CA certificate for etcd service (string)
        :param str cert: TLS certificate for etcd service (string)
        :param str creation: Creation option for etcd service (string)
        :param Sequence[str] external_urls: External urls for etcd service (list)
        :param Mapping[str, Any] extra_args: Extra arguments for scheduler service (map)
        :param Sequence[str] extra_binds: Extra binds for scheduler service (list)
        :param Sequence[str] extra_envs: Extra environment for scheduler service (list)
        :param int gid: Etcd service GID. Default: `0`. For Rancher v2.3.x or above (int)
        :param str image: Docker image for scheduler service (string)
        :param str key: TLS key for etcd service (string)
        :param str path: Audit log path. Default: `/var/log/kube-audit/audit-log.json` (string)
        :param str retention: Retention for etcd backup. Default `6` (int)
        :param bool snapshot: Snapshot option for etcd service. Default `true` (bool)
        :param int uid: Etcd service UID. Default: `0`. For Rancher v2.3.x or above (int)
        """
        if backup_config is not None:
            pulumi.set(__self__, "backup_config", backup_config)
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if creation is not None:
            pulumi.set(__self__, "creation", creation)
        if external_urls is not None:
            pulumi.set(__self__, "external_urls", external_urls)
        if extra_args is not None:
            pulumi.set(__self__, "extra_args", extra_args)
        if extra_binds is not None:
            pulumi.set(__self__, "extra_binds", extra_binds)
        if extra_envs is not None:
            pulumi.set(__self__, "extra_envs", extra_envs)
        if gid is not None:
            pulumi.set(__self__, "gid", gid)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="backupConfig")
    def backup_config(self) -> Optional['outputs.ClusterServicesEtcdBackupConfig']:
        """
        Backup options for etcd service. Just for Rancher v2.2.x (list maxitems:1)
        """
        return pulumi.get(self, "backup_config")

    @property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[str]:
        """
        TLS CA certificate for etcd service (string)
        """
        return pulumi.get(self, "ca_cert")

    @property
    @pulumi.getter
    def cert(self) -> Optional[str]:
        """
        TLS certificate for etcd service (string)
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter
    def creation(self) -> Optional[str]:
        """
        Creation option for etcd service (string)
        """
        return pulumi.get(self, "creation")

    @property
    @pulumi.getter(name="externalUrls")
    def external_urls(self) -> Optional[Sequence[str]]:
        """
        External urls for etcd service (list)
        """
        return pulumi.get(self, "external_urls")

    @property
    @pulumi.getter(name="extraArgs")
    def extra_args(self) -> Optional[Mapping[str, Any]]:
        """
        Extra arguments for scheduler service (map)
        """
        return pulumi.get(self, "extra_args")

    @property
    @pulumi.getter(name="extraBinds")
    def extra_binds(self) -> Optional[Sequence[str]]:
        """
        Extra binds for scheduler service (list)
        """
        return pulumi.get(self, "extra_binds")

    @property
    @pulumi.getter(name="extraEnvs")
    def extra_envs(self) -> Optional[Sequence[str]]:
        """
        Extra environment for scheduler service (list)
        """
        return pulumi.get(self, "extra_envs")

    @property
    @pulumi.getter
    def gid(self) -> Optional[int]:
        """
        Etcd service GID. Default: `0`. For Rancher v2.3.x or above (int)
        """
        return pulumi.get(self, "gid")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        Docker image for scheduler service (string)
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        TLS key for etcd service (string)
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Audit log path. Default: `/var/log/kube-audit/audit-log.json` (string)
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def retention(self) -> Optional[str]:
        """
        Retention for etcd backup. Default `6` (int)
        """
        return pulumi.get(self, "retention")

    @property
    @pulumi.getter
    def snapshot(self) -> Optional[bool]:
        """
        Snapshot option for etcd service. Default `true` (bool)
        """
        return pulumi.get(self, "snapshot")

    @property
    @pulumi.getter
    def uid(self) -> Optional[int]:
        """
        Etcd service UID. Default: `0`. For Rancher v2.3.x or above (int)
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ClusterServicesEtcdBackupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalHours":
            suggest = "interval_hours"
        elif key == "s3BackupConfig":
            suggest = "s3_backup_config"
        elif key == "safeTimestamp":
            suggest = "safe_timestamp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServicesEtcdBackupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServicesEtcdBackupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServicesEtcdBackupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 interval_hours: Optional[int] = None,
                 retention: Optional[int] = None,
                 s3_backup_config: Optional['outputs.ClusterServicesEtcdBackupConfigS3BackupConfig'] = None,
                 safe_timestamp: Optional[bool] = None,
                 timeout: Optional[int] = None):
        """
        :param bool enabled: Enable secrets encryption (bool)
        :param int interval_hours: Interval hours for etcd backup. Default `12` (int)
        :param int retention: Retention for etcd backup. Default `6` (int)
        :param 'ClusterServicesEtcdBackupConfigS3BackupConfigArgs' s3_backup_config: S3 config options for etcd backup (list maxitems:1)
        :param bool safe_timestamp: Safe timestamp for etcd backup. Default: `false` (bool)
        :param int timeout: RKE node drain timeout (int)
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if interval_hours is not None:
            pulumi.set(__self__, "interval_hours", interval_hours)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if s3_backup_config is not None:
            pulumi.set(__self__, "s3_backup_config", s3_backup_config)
        if safe_timestamp is not None:
            pulumi.set(__self__, "safe_timestamp", safe_timestamp)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Enable secrets encryption (bool)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="intervalHours")
    def interval_hours(self) -> Optional[int]:
        """
        Interval hours for etcd backup. Default `12` (int)
        """
        return pulumi.get(self, "interval_hours")

    @property
    @pulumi.getter
    def retention(self) -> Optional[int]:
        """
        Retention for etcd backup. Default `6` (int)
        """
        return pulumi.get(self, "retention")

    @property
    @pulumi.getter(name="s3BackupConfig")
    def s3_backup_config(self) -> Optional['outputs.ClusterServicesEtcdBackupConfigS3BackupConfig']:
        """
        S3 config options for etcd backup (list maxitems:1)
        """
        return pulumi.get(self, "s3_backup_config")

    @property
    @pulumi.getter(name="safeTimestamp")
    def safe_timestamp(self) -> Optional[bool]:
        """
        Safe timestamp for etcd backup. Default: `false` (bool)
        """
        return pulumi.get(self, "safe_timestamp")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        RKE node drain timeout (int)
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ClusterServicesEtcdBackupConfigS3BackupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "customCa":
            suggest = "custom_ca"
        elif key == "secretKey":
            suggest = "secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServicesEtcdBackupConfigS3BackupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServicesEtcdBackupConfigS3BackupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServicesEtcdBackupConfigS3BackupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: Optional[str] = None,
                 bucket_name: Optional[str] = None,
                 custom_ca: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 folder: Optional[str] = None,
                 region: Optional[str] = None,
                 secret_key: Optional[str] = None):
        """
        :param str access_key: Access key for S3 service (string)
        :param str bucket_name: Bucket name for S3 service (string)
        :param str custom_ca: Base64 encoded custom CA for S3 service. Use filebase64(<FILE>) for encoding file. Available from Rancher v2.2.5 (string)
        :param str endpoint: Endpoint for S3 service (string)
        :param str folder: Folder for S3 service. Available from Rancher v2.2.7 (string)
        :param str region: Region for S3 service (string)
        :param str secret_key: Secret key for S3 service (string)
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if custom_ca is not None:
            pulumi.set(__self__, "custom_ca", custom_ca)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[str]:
        """
        Access key for S3 service (string)
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[str]:
        """
        Bucket name for S3 service (string)
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="customCa")
    def custom_ca(self) -> Optional[str]:
        """
        Base64 encoded custom CA for S3 service. Use filebase64(<FILE>) for encoding file. Available from Rancher v2.2.5 (string)
        """
        return pulumi.get(self, "custom_ca")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        Endpoint for S3 service (string)
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def folder(self) -> Optional[str]:
        """
        Folder for S3 service. Available from Rancher v2.2.7 (string)
        """
        return pulumi.get(self, "folder")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Region for S3 service (string)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        Secret key for S3 service (string)
        """
        return pulumi.get(self, "secret_key")


@pulumi.output_type
class ClusterServicesEtcdDeprecated(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupConfig":
            suggest = "backup_config"
        elif key == "caCert":
            suggest = "ca_cert"
        elif key == "externalUrls":
            suggest = "external_urls"
        elif key == "extraArgs":
            suggest = "extra_args"
        elif key == "extraBinds":
            suggest = "extra_binds"
        elif key == "extraEnvs":
            suggest = "extra_envs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServicesEtcdDeprecated. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServicesEtcdDeprecated.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServicesEtcdDeprecated.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_config: Optional['outputs.ClusterServicesEtcdDeprecatedBackupConfig'] = None,
                 ca_cert: Optional[str] = None,
                 cert: Optional[str] = None,
                 creation: Optional[str] = None,
                 external_urls: Optional[Sequence[str]] = None,
                 extra_args: Optional[Mapping[str, Any]] = None,
                 extra_binds: Optional[Sequence[str]] = None,
                 extra_envs: Optional[Sequence[str]] = None,
                 gid: Optional[int] = None,
                 image: Optional[str] = None,
                 key: Optional[str] = None,
                 path: Optional[str] = None,
                 retention: Optional[str] = None,
                 snapshot: Optional[bool] = None,
                 uid: Optional[int] = None):
        """
        :param 'ClusterServicesEtcdDeprecatedBackupConfigArgs' backup_config: Backup options for etcd service. Just for Rancher v2.2.x (list maxitems:1)
        :param str ca_cert: TLS CA certificate for etcd service (string)
        :param str cert: TLS certificate for etcd service (string)
        :param str creation: Creation option for etcd service (string)
        :param Sequence[str] external_urls: External urls for etcd service (list)
        :param Mapping[str, Any] extra_args: Extra arguments for scheduler service (map)
        :param Sequence[str] extra_binds: Extra binds for scheduler service (list)
        :param Sequence[str] extra_envs: Extra environment for scheduler service (list)
        :param int gid: Etcd service GID. Default: `0`. For Rancher v2.3.x or above (int)
        :param str image: Docker image for scheduler service (string)
        :param str key: TLS key for etcd service (string)
        :param str path: Audit log path. Default: `/var/log/kube-audit/audit-log.json` (string)
        :param str retention: Retention for etcd backup. Default `6` (int)
        :param bool snapshot: Snapshot option for etcd service. Default `true` (bool)
        :param int uid: Etcd service UID. Default: `0`. For Rancher v2.3.x or above (int)
        """
        if backup_config is not None:
            pulumi.set(__self__, "backup_config", backup_config)
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if creation is not None:
            pulumi.set(__self__, "creation", creation)
        if external_urls is not None:
            pulumi.set(__self__, "external_urls", external_urls)
        if extra_args is not None:
            pulumi.set(__self__, "extra_args", extra_args)
        if extra_binds is not None:
            pulumi.set(__self__, "extra_binds", extra_binds)
        if extra_envs is not None:
            pulumi.set(__self__, "extra_envs", extra_envs)
        if gid is not None:
            pulumi.set(__self__, "gid", gid)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="backupConfig")
    def backup_config(self) -> Optional['outputs.ClusterServicesEtcdDeprecatedBackupConfig']:
        """
        Backup options for etcd service. Just for Rancher v2.2.x (list maxitems:1)
        """
        return pulumi.get(self, "backup_config")

    @property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[str]:
        """
        TLS CA certificate for etcd service (string)
        """
        return pulumi.get(self, "ca_cert")

    @property
    @pulumi.getter
    def cert(self) -> Optional[str]:
        """
        TLS certificate for etcd service (string)
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter
    def creation(self) -> Optional[str]:
        """
        Creation option for etcd service (string)
        """
        return pulumi.get(self, "creation")

    @property
    @pulumi.getter(name="externalUrls")
    def external_urls(self) -> Optional[Sequence[str]]:
        """
        External urls for etcd service (list)
        """
        return pulumi.get(self, "external_urls")

    @property
    @pulumi.getter(name="extraArgs")
    def extra_args(self) -> Optional[Mapping[str, Any]]:
        """
        Extra arguments for scheduler service (map)
        """
        return pulumi.get(self, "extra_args")

    @property
    @pulumi.getter(name="extraBinds")
    def extra_binds(self) -> Optional[Sequence[str]]:
        """
        Extra binds for scheduler service (list)
        """
        return pulumi.get(self, "extra_binds")

    @property
    @pulumi.getter(name="extraEnvs")
    def extra_envs(self) -> Optional[Sequence[str]]:
        """
        Extra environment for scheduler service (list)
        """
        return pulumi.get(self, "extra_envs")

    @property
    @pulumi.getter
    def gid(self) -> Optional[int]:
        """
        Etcd service GID. Default: `0`. For Rancher v2.3.x or above (int)
        """
        return pulumi.get(self, "gid")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        Docker image for scheduler service (string)
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        TLS key for etcd service (string)
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Audit log path. Default: `/var/log/kube-audit/audit-log.json` (string)
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def retention(self) -> Optional[str]:
        """
        Retention for etcd backup. Default `6` (int)
        """
        return pulumi.get(self, "retention")

    @property
    @pulumi.getter
    def snapshot(self) -> Optional[bool]:
        """
        Snapshot option for etcd service. Default `true` (bool)
        """
        return pulumi.get(self, "snapshot")

    @property
    @pulumi.getter
    def uid(self) -> Optional[int]:
        """
        Etcd service UID. Default: `0`. For Rancher v2.3.x or above (int)
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ClusterServicesEtcdDeprecatedBackupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intervalHours":
            suggest = "interval_hours"
        elif key == "s3BackupConfig":
            suggest = "s3_backup_config"
        elif key == "safeTimestamp":
            suggest = "safe_timestamp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServicesEtcdDeprecatedBackupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServicesEtcdDeprecatedBackupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServicesEtcdDeprecatedBackupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 interval_hours: Optional[int] = None,
                 retention: Optional[int] = None,
                 s3_backup_config: Optional['outputs.ClusterServicesEtcdDeprecatedBackupConfigS3BackupConfig'] = None,
                 safe_timestamp: Optional[bool] = None,
                 timeout: Optional[int] = None):
        """
        :param bool enabled: Enable secrets encryption (bool)
        :param int interval_hours: Interval hours for etcd backup. Default `12` (int)
        :param int retention: Retention for etcd backup. Default `6` (int)
        :param 'ClusterServicesEtcdDeprecatedBackupConfigS3BackupConfigArgs' s3_backup_config: S3 config options for etcd backup (list maxitems:1)
        :param bool safe_timestamp: Safe timestamp for etcd backup. Default: `false` (bool)
        :param int timeout: RKE node drain timeout (int)
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if interval_hours is not None:
            pulumi.set(__self__, "interval_hours", interval_hours)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if s3_backup_config is not None:
            pulumi.set(__self__, "s3_backup_config", s3_backup_config)
        if safe_timestamp is not None:
            pulumi.set(__self__, "safe_timestamp", safe_timestamp)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Enable secrets encryption (bool)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="intervalHours")
    def interval_hours(self) -> Optional[int]:
        """
        Interval hours for etcd backup. Default `12` (int)
        """
        return pulumi.get(self, "interval_hours")

    @property
    @pulumi.getter
    def retention(self) -> Optional[int]:
        """
        Retention for etcd backup. Default `6` (int)
        """
        return pulumi.get(self, "retention")

    @property
    @pulumi.getter(name="s3BackupConfig")
    def s3_backup_config(self) -> Optional['outputs.ClusterServicesEtcdDeprecatedBackupConfigS3BackupConfig']:
        """
        S3 config options for etcd backup (list maxitems:1)
        """
        return pulumi.get(self, "s3_backup_config")

    @property
    @pulumi.getter(name="safeTimestamp")
    def safe_timestamp(self) -> Optional[bool]:
        """
        Safe timestamp for etcd backup. Default: `false` (bool)
        """
        return pulumi.get(self, "safe_timestamp")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        RKE node drain timeout (int)
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ClusterServicesEtcdDeprecatedBackupConfigS3BackupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "bucketName":
            suggest = "bucket_name"
        elif key == "customCa":
            suggest = "custom_ca"
        elif key == "secretKey":
            suggest = "secret_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServicesEtcdDeprecatedBackupConfigS3BackupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServicesEtcdDeprecatedBackupConfigS3BackupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServicesEtcdDeprecatedBackupConfigS3BackupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key: Optional[str] = None,
                 bucket_name: Optional[str] = None,
                 custom_ca: Optional[str] = None,
                 endpoint: Optional[str] = None,
                 folder: Optional[str] = None,
                 region: Optional[str] = None,
                 secret_key: Optional[str] = None):
        """
        :param str access_key: Access key for S3 service (string)
        :param str bucket_name: Bucket name for S3 service (string)
        :param str custom_ca: Base64 encoded custom CA for S3 service. Use filebase64(<FILE>) for encoding file. Available from Rancher v2.2.5 (string)
        :param str endpoint: Endpoint for S3 service (string)
        :param str folder: Folder for S3 service. Available from Rancher v2.2.7 (string)
        :param str region: Region for S3 service (string)
        :param str secret_key: Secret key for S3 service (string)
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if custom_ca is not None:
            pulumi.set(__self__, "custom_ca", custom_ca)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[str]:
        """
        Access key for S3 service (string)
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[str]:
        """
        Bucket name for S3 service (string)
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="customCa")
    def custom_ca(self) -> Optional[str]:
        """
        Base64 encoded custom CA for S3 service. Use filebase64(<FILE>) for encoding file. Available from Rancher v2.2.5 (string)
        """
        return pulumi.get(self, "custom_ca")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[str]:
        """
        Endpoint for S3 service (string)
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def folder(self) -> Optional[str]:
        """
        Folder for S3 service. Available from Rancher v2.2.7 (string)
        """
        return pulumi.get(self, "folder")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        Region for S3 service (string)
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        Secret key for S3 service (string)
        """
        return pulumi.get(self, "secret_key")


@pulumi.output_type
class ClusterServicesKubeApi(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alwaysPullImages":
            suggest = "always_pull_images"
        elif key == "auditLog":
            suggest = "audit_log"
        elif key == "eventRateLimit":
            suggest = "event_rate_limit"
        elif key == "extraArgs":
            suggest = "extra_args"
        elif key == "extraBinds":
            suggest = "extra_binds"
        elif key == "extraEnvs":
            suggest = "extra_envs"
        elif key == "podSecurityPolicy":
            suggest = "pod_security_policy"
        elif key == "secretsEncryptionConfig":
            suggest = "secrets_encryption_config"
        elif key == "serviceClusterIpRange":
            suggest = "service_cluster_ip_range"
        elif key == "serviceNodePortRange":
            suggest = "service_node_port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServicesKubeApi. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServicesKubeApi.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServicesKubeApi.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 always_pull_images: Optional[bool] = None,
                 audit_log: Optional['outputs.ClusterServicesKubeApiAuditLog'] = None,
                 event_rate_limit: Optional['outputs.ClusterServicesKubeApiEventRateLimit'] = None,
                 extra_args: Optional[Mapping[str, Any]] = None,
                 extra_binds: Optional[Sequence[str]] = None,
                 extra_envs: Optional[Sequence[str]] = None,
                 image: Optional[str] = None,
                 pod_security_policy: Optional[bool] = None,
                 secrets_encryption_config: Optional['outputs.ClusterServicesKubeApiSecretsEncryptionConfig'] = None,
                 service_cluster_ip_range: Optional[str] = None,
                 service_node_port_range: Optional[str] = None):
        """
        :param bool always_pull_images: Enable [AlwaysPullImages](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/#alwayspullimages) Admission controller plugin. [Rancher docs](https://rancher.com/docs/rke/latest/en/config-options/services/#kubernetes-api-server-options) (bool)
        :param 'ClusterServicesKubeApiAuditLogArgs' audit_log: K8s audit log configuration. (list maxitem: 1)
        :param 'ClusterServicesKubeApiEventRateLimitArgs' event_rate_limit: K8s event rate limit configuration. (list maxitem: 1)
        :param Mapping[str, Any] extra_args: Extra arguments for scheduler service (map)
        :param Sequence[str] extra_binds: Extra binds for scheduler service (list)
        :param Sequence[str] extra_envs: Extra environment for scheduler service (list)
        :param str image: Docker image for scheduler service (string)
        :param bool pod_security_policy: Pod Security Policy option for kube API service (bool)
        :param 'ClusterServicesKubeApiSecretsEncryptionConfigArgs' secrets_encryption_config: [Encrypt k8s secret data configration](https://rancher.com/docs/rke/latest/en/config-options/secrets-encryption/). (list maxitem: 1)
        :param str service_cluster_ip_range: Service Cluster ip Range option for kube controller service (string)
        :param str service_node_port_range: Service Node Port Range option for kube API service (string)
        """
        if always_pull_images is not None:
            pulumi.set(__self__, "always_pull_images", always_pull_images)
        if audit_log is not None:
            pulumi.set(__self__, "audit_log", audit_log)
        if event_rate_limit is not None:
            pulumi.set(__self__, "event_rate_limit", event_rate_limit)
        if extra_args is not None:
            pulumi.set(__self__, "extra_args", extra_args)
        if extra_binds is not None:
            pulumi.set(__self__, "extra_binds", extra_binds)
        if extra_envs is not None:
            pulumi.set(__self__, "extra_envs", extra_envs)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if pod_security_policy is not None:
            pulumi.set(__self__, "pod_security_policy", pod_security_policy)
        if secrets_encryption_config is not None:
            pulumi.set(__self__, "secrets_encryption_config", secrets_encryption_config)
        if service_cluster_ip_range is not None:
            pulumi.set(__self__, "service_cluster_ip_range", service_cluster_ip_range)
        if service_node_port_range is not None:
            pulumi.set(__self__, "service_node_port_range", service_node_port_range)

    @property
    @pulumi.getter(name="alwaysPullImages")
    def always_pull_images(self) -> Optional[bool]:
        """
        Enable [AlwaysPullImages](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/#alwayspullimages) Admission controller plugin. [Rancher docs](https://rancher.com/docs/rke/latest/en/config-options/services/#kubernetes-api-server-options) (bool)
        """
        return pulumi.get(self, "always_pull_images")

    @property
    @pulumi.getter(name="auditLog")
    def audit_log(self) -> Optional['outputs.ClusterServicesKubeApiAuditLog']:
        """
        K8s audit log configuration. (list maxitem: 1)
        """
        return pulumi.get(self, "audit_log")

    @property
    @pulumi.getter(name="eventRateLimit")
    def event_rate_limit(self) -> Optional['outputs.ClusterServicesKubeApiEventRateLimit']:
        """
        K8s event rate limit configuration. (list maxitem: 1)
        """
        return pulumi.get(self, "event_rate_limit")

    @property
    @pulumi.getter(name="extraArgs")
    def extra_args(self) -> Optional[Mapping[str, Any]]:
        """
        Extra arguments for scheduler service (map)
        """
        return pulumi.get(self, "extra_args")

    @property
    @pulumi.getter(name="extraBinds")
    def extra_binds(self) -> Optional[Sequence[str]]:
        """
        Extra binds for scheduler service (list)
        """
        return pulumi.get(self, "extra_binds")

    @property
    @pulumi.getter(name="extraEnvs")
    def extra_envs(self) -> Optional[Sequence[str]]:
        """
        Extra environment for scheduler service (list)
        """
        return pulumi.get(self, "extra_envs")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        Docker image for scheduler service (string)
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="podSecurityPolicy")
    def pod_security_policy(self) -> Optional[bool]:
        """
        Pod Security Policy option for kube API service (bool)
        """
        return pulumi.get(self, "pod_security_policy")

    @property
    @pulumi.getter(name="secretsEncryptionConfig")
    def secrets_encryption_config(self) -> Optional['outputs.ClusterServicesKubeApiSecretsEncryptionConfig']:
        """
        [Encrypt k8s secret data configration](https://rancher.com/docs/rke/latest/en/config-options/secrets-encryption/). (list maxitem: 1)
        """
        return pulumi.get(self, "secrets_encryption_config")

    @property
    @pulumi.getter(name="serviceClusterIpRange")
    def service_cluster_ip_range(self) -> Optional[str]:
        """
        Service Cluster ip Range option for kube controller service (string)
        """
        return pulumi.get(self, "service_cluster_ip_range")

    @property
    @pulumi.getter(name="serviceNodePortRange")
    def service_node_port_range(self) -> Optional[str]:
        """
        Service Node Port Range option for kube API service (string)
        """
        return pulumi.get(self, "service_node_port_range")


@pulumi.output_type
class ClusterServicesKubeApiAuditLog(dict):
    def __init__(__self__, *,
                 configuration: Optional['outputs.ClusterServicesKubeApiAuditLogConfiguration'] = None,
                 enabled: Optional[bool] = None):
        """
        :param 'ClusterServicesKubeApiAuditLogConfigurationArgs' configuration: Event rate limit yaml encoded configuration. `"apiVersion"` and `"kind":"Configuration"` fields are required in the yaml. Ex. `apiVersion: eventratelimit.admission.k8s.io/v1alpha1\nkind: Configuration\nlimits:\n- type: Server\n  burst: 30000\n  qps: 6000\n` [More info](https://rancher.com/docs/rke/latest/en/config-options/rate-limiting/) (string)
        :param bool enabled: Enable secrets encryption (bool)
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def configuration(self) -> Optional['outputs.ClusterServicesKubeApiAuditLogConfiguration']:
        """
        Event rate limit yaml encoded configuration. `"apiVersion"` and `"kind":"Configuration"` fields are required in the yaml. Ex. `apiVersion: eventratelimit.admission.k8s.io/v1alpha1\nkind: Configuration\nlimits:\n- type: Server\n  burst: 30000\n  qps: 6000\n` [More info](https://rancher.com/docs/rke/latest/en/config-options/rate-limiting/) (string)
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Enable secrets encryption (bool)
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterServicesKubeApiAuditLogConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxAge":
            suggest = "max_age"
        elif key == "maxBackup":
            suggest = "max_backup"
        elif key == "maxSize":
            suggest = "max_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServicesKubeApiAuditLogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServicesKubeApiAuditLogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServicesKubeApiAuditLogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 format: Optional[str] = None,
                 max_age: Optional[int] = None,
                 max_backup: Optional[int] = None,
                 max_size: Optional[int] = None,
                 path: Optional[str] = None,
                 policy: Optional[str] = None):
        """
        :param str format: Audit log format (string)
        :param int max_age: Audit log max age (int)
        :param int max_backup: Audit log max backup. Default: `10` (int)
        :param int max_size: Audit log max size. Default: `100` (int)
        :param str path: Audit log path. Default: `/var/log/kube-audit/audit-log.json` (string)
        :param str policy: Audit policy json encoded definition. `"apiVersion"` and `"kind":"Policy","rules"` fields are required in the json. Ex. `jsonencode({"apiVersion":"audit.k8s.io/v1","kind":"Policy","rules":[{"level":"RequestResponse","resources":[{"group":"","resources":["pods"]}]}]})` [More info](https://rancher.com/docs/rke/latest/en/config-options/audit-log/) (string)
        """
        if format is not None:
            pulumi.set(__self__, "format", format)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)
        if max_backup is not None:
            pulumi.set(__self__, "max_backup", max_backup)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Audit log format (string)
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[int]:
        """
        Audit log max age (int)
        """
        return pulumi.get(self, "max_age")

    @property
    @pulumi.getter(name="maxBackup")
    def max_backup(self) -> Optional[int]:
        """
        Audit log max backup. Default: `10` (int)
        """
        return pulumi.get(self, "max_backup")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[int]:
        """
        Audit log max size. Default: `100` (int)
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Audit log path. Default: `/var/log/kube-audit/audit-log.json` (string)
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def policy(self) -> Optional[str]:
        """
        Audit policy json encoded definition. `"apiVersion"` and `"kind":"Policy","rules"` fields are required in the json. Ex. `jsonencode({"apiVersion":"audit.k8s.io/v1","kind":"Policy","rules":[{"level":"RequestResponse","resources":[{"group":"","resources":["pods"]}]}]})` [More info](https://rancher.com/docs/rke/latest/en/config-options/audit-log/) (string)
        """
        return pulumi.get(self, "policy")


@pulumi.output_type
class ClusterServicesKubeApiDeprecated(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alwaysPullImages":
            suggest = "always_pull_images"
        elif key == "auditLog":
            suggest = "audit_log"
        elif key == "eventRateLimit":
            suggest = "event_rate_limit"
        elif key == "extraArgs":
            suggest = "extra_args"
        elif key == "extraBinds":
            suggest = "extra_binds"
        elif key == "extraEnvs":
            suggest = "extra_envs"
        elif key == "podSecurityPolicy":
            suggest = "pod_security_policy"
        elif key == "secretsEncryptionConfig":
            suggest = "secrets_encryption_config"
        elif key == "serviceClusterIpRange":
            suggest = "service_cluster_ip_range"
        elif key == "serviceNodePortRange":
            suggest = "service_node_port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServicesKubeApiDeprecated. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServicesKubeApiDeprecated.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServicesKubeApiDeprecated.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 always_pull_images: Optional[bool] = None,
                 audit_log: Optional['outputs.ClusterServicesKubeApiDeprecatedAuditLog'] = None,
                 event_rate_limit: Optional['outputs.ClusterServicesKubeApiDeprecatedEventRateLimit'] = None,
                 extra_args: Optional[Mapping[str, Any]] = None,
                 extra_binds: Optional[Sequence[str]] = None,
                 extra_envs: Optional[Sequence[str]] = None,
                 image: Optional[str] = None,
                 pod_security_policy: Optional[bool] = None,
                 secrets_encryption_config: Optional['outputs.ClusterServicesKubeApiDeprecatedSecretsEncryptionConfig'] = None,
                 service_cluster_ip_range: Optional[str] = None,
                 service_node_port_range: Optional[str] = None):
        """
        :param bool always_pull_images: Enable [AlwaysPullImages](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/#alwayspullimages) Admission controller plugin. [Rancher docs](https://rancher.com/docs/rke/latest/en/config-options/services/#kubernetes-api-server-options) (bool)
        :param 'ClusterServicesKubeApiDeprecatedAuditLogArgs' audit_log: K8s audit log configuration. (list maxitem: 1)
        :param 'ClusterServicesKubeApiDeprecatedEventRateLimitArgs' event_rate_limit: K8s event rate limit configuration. (list maxitem: 1)
        :param Mapping[str, Any] extra_args: Extra arguments for scheduler service (map)
        :param Sequence[str] extra_binds: Extra binds for scheduler service (list)
        :param Sequence[str] extra_envs: Extra environment for scheduler service (list)
        :param str image: Docker image for scheduler service (string)
        :param bool pod_security_policy: Pod Security Policy option for kube API service (bool)
        :param 'ClusterServicesKubeApiDeprecatedSecretsEncryptionConfigArgs' secrets_encryption_config: [Encrypt k8s secret data configration](https://rancher.com/docs/rke/latest/en/config-options/secrets-encryption/). (list maxitem: 1)
        :param str service_cluster_ip_range: Service Cluster ip Range option for kube controller service (string)
        :param str service_node_port_range: Service Node Port Range option for kube API service (string)
        """
        if always_pull_images is not None:
            pulumi.set(__self__, "always_pull_images", always_pull_images)
        if audit_log is not None:
            pulumi.set(__self__, "audit_log", audit_log)
        if event_rate_limit is not None:
            pulumi.set(__self__, "event_rate_limit", event_rate_limit)
        if extra_args is not None:
            pulumi.set(__self__, "extra_args", extra_args)
        if extra_binds is not None:
            pulumi.set(__self__, "extra_binds", extra_binds)
        if extra_envs is not None:
            pulumi.set(__self__, "extra_envs", extra_envs)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if pod_security_policy is not None:
            pulumi.set(__self__, "pod_security_policy", pod_security_policy)
        if secrets_encryption_config is not None:
            pulumi.set(__self__, "secrets_encryption_config", secrets_encryption_config)
        if service_cluster_ip_range is not None:
            pulumi.set(__self__, "service_cluster_ip_range", service_cluster_ip_range)
        if service_node_port_range is not None:
            pulumi.set(__self__, "service_node_port_range", service_node_port_range)

    @property
    @pulumi.getter(name="alwaysPullImages")
    def always_pull_images(self) -> Optional[bool]:
        """
        Enable [AlwaysPullImages](https://kubernetes.io/docs/reference/access-authn-authz/admission-controllers/#alwayspullimages) Admission controller plugin. [Rancher docs](https://rancher.com/docs/rke/latest/en/config-options/services/#kubernetes-api-server-options) (bool)
        """
        return pulumi.get(self, "always_pull_images")

    @property
    @pulumi.getter(name="auditLog")
    def audit_log(self) -> Optional['outputs.ClusterServicesKubeApiDeprecatedAuditLog']:
        """
        K8s audit log configuration. (list maxitem: 1)
        """
        return pulumi.get(self, "audit_log")

    @property
    @pulumi.getter(name="eventRateLimit")
    def event_rate_limit(self) -> Optional['outputs.ClusterServicesKubeApiDeprecatedEventRateLimit']:
        """
        K8s event rate limit configuration. (list maxitem: 1)
        """
        return pulumi.get(self, "event_rate_limit")

    @property
    @pulumi.getter(name="extraArgs")
    def extra_args(self) -> Optional[Mapping[str, Any]]:
        """
        Extra arguments for scheduler service (map)
        """
        return pulumi.get(self, "extra_args")

    @property
    @pulumi.getter(name="extraBinds")
    def extra_binds(self) -> Optional[Sequence[str]]:
        """
        Extra binds for scheduler service (list)
        """
        return pulumi.get(self, "extra_binds")

    @property
    @pulumi.getter(name="extraEnvs")
    def extra_envs(self) -> Optional[Sequence[str]]:
        """
        Extra environment for scheduler service (list)
        """
        return pulumi.get(self, "extra_envs")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        Docker image for scheduler service (string)
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="podSecurityPolicy")
    def pod_security_policy(self) -> Optional[bool]:
        """
        Pod Security Policy option for kube API service (bool)
        """
        return pulumi.get(self, "pod_security_policy")

    @property
    @pulumi.getter(name="secretsEncryptionConfig")
    def secrets_encryption_config(self) -> Optional['outputs.ClusterServicesKubeApiDeprecatedSecretsEncryptionConfig']:
        """
        [Encrypt k8s secret data configration](https://rancher.com/docs/rke/latest/en/config-options/secrets-encryption/). (list maxitem: 1)
        """
        return pulumi.get(self, "secrets_encryption_config")

    @property
    @pulumi.getter(name="serviceClusterIpRange")
    def service_cluster_ip_range(self) -> Optional[str]:
        """
        Service Cluster ip Range option for kube controller service (string)
        """
        return pulumi.get(self, "service_cluster_ip_range")

    @property
    @pulumi.getter(name="serviceNodePortRange")
    def service_node_port_range(self) -> Optional[str]:
        """
        Service Node Port Range option for kube API service (string)
        """
        return pulumi.get(self, "service_node_port_range")


@pulumi.output_type
class ClusterServicesKubeApiDeprecatedAuditLog(dict):
    def __init__(__self__, *,
                 configuration: Optional['outputs.ClusterServicesKubeApiDeprecatedAuditLogConfiguration'] = None,
                 enabled: Optional[bool] = None):
        """
        :param 'ClusterServicesKubeApiDeprecatedAuditLogConfigurationArgs' configuration: Event rate limit yaml encoded configuration. `"apiVersion"` and `"kind":"Configuration"` fields are required in the yaml. Ex. `apiVersion: eventratelimit.admission.k8s.io/v1alpha1\nkind: Configuration\nlimits:\n- type: Server\n  burst: 30000\n  qps: 6000\n` [More info](https://rancher.com/docs/rke/latest/en/config-options/rate-limiting/) (string)
        :param bool enabled: Enable secrets encryption (bool)
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def configuration(self) -> Optional['outputs.ClusterServicesKubeApiDeprecatedAuditLogConfiguration']:
        """
        Event rate limit yaml encoded configuration. `"apiVersion"` and `"kind":"Configuration"` fields are required in the yaml. Ex. `apiVersion: eventratelimit.admission.k8s.io/v1alpha1\nkind: Configuration\nlimits:\n- type: Server\n  burst: 30000\n  qps: 6000\n` [More info](https://rancher.com/docs/rke/latest/en/config-options/rate-limiting/) (string)
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Enable secrets encryption (bool)
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterServicesKubeApiDeprecatedAuditLogConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxAge":
            suggest = "max_age"
        elif key == "maxBackup":
            suggest = "max_backup"
        elif key == "maxSize":
            suggest = "max_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServicesKubeApiDeprecatedAuditLogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServicesKubeApiDeprecatedAuditLogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServicesKubeApiDeprecatedAuditLogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 format: Optional[str] = None,
                 max_age: Optional[int] = None,
                 max_backup: Optional[int] = None,
                 max_size: Optional[int] = None,
                 path: Optional[str] = None,
                 policy: Optional[str] = None):
        """
        :param str format: Audit log format (string)
        :param int max_age: Audit log max age (int)
        :param int max_backup: Audit log max backup. Default: `10` (int)
        :param int max_size: Audit log max size. Default: `100` (int)
        :param str path: Audit log path. Default: `/var/log/kube-audit/audit-log.json` (string)
        :param str policy: Audit policy json encoded definition. `"apiVersion"` and `"kind":"Policy","rules"` fields are required in the json. Ex. `jsonencode({"apiVersion":"audit.k8s.io/v1","kind":"Policy","rules":[{"level":"RequestResponse","resources":[{"group":"","resources":["pods"]}]}]})` [More info](https://rancher.com/docs/rke/latest/en/config-options/audit-log/) (string)
        """
        if format is not None:
            pulumi.set(__self__, "format", format)
        if max_age is not None:
            pulumi.set(__self__, "max_age", max_age)
        if max_backup is not None:
            pulumi.set(__self__, "max_backup", max_backup)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Audit log format (string)
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="maxAge")
    def max_age(self) -> Optional[int]:
        """
        Audit log max age (int)
        """
        return pulumi.get(self, "max_age")

    @property
    @pulumi.getter(name="maxBackup")
    def max_backup(self) -> Optional[int]:
        """
        Audit log max backup. Default: `10` (int)
        """
        return pulumi.get(self, "max_backup")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[int]:
        """
        Audit log max size. Default: `100` (int)
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Audit log path. Default: `/var/log/kube-audit/audit-log.json` (string)
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def policy(self) -> Optional[str]:
        """
        Audit policy json encoded definition. `"apiVersion"` and `"kind":"Policy","rules"` fields are required in the json. Ex. `jsonencode({"apiVersion":"audit.k8s.io/v1","kind":"Policy","rules":[{"level":"RequestResponse","resources":[{"group":"","resources":["pods"]}]}]})` [More info](https://rancher.com/docs/rke/latest/en/config-options/audit-log/) (string)
        """
        return pulumi.get(self, "policy")


@pulumi.output_type
class ClusterServicesKubeApiDeprecatedEventRateLimit(dict):
    def __init__(__self__, *,
                 configuration: Optional[str] = None,
                 enabled: Optional[bool] = None):
        """
        :param str configuration: Event rate limit yaml encoded configuration. `"apiVersion"` and `"kind":"Configuration"` fields are required in the yaml. Ex. `apiVersion: eventratelimit.admission.k8s.io/v1alpha1\nkind: Configuration\nlimits:\n- type: Server\n  burst: 30000\n  qps: 6000\n` [More info](https://rancher.com/docs/rke/latest/en/config-options/rate-limiting/) (string)
        :param bool enabled: Enable secrets encryption (bool)
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[str]:
        """
        Event rate limit yaml encoded configuration. `"apiVersion"` and `"kind":"Configuration"` fields are required in the yaml. Ex. `apiVersion: eventratelimit.admission.k8s.io/v1alpha1\nkind: Configuration\nlimits:\n- type: Server\n  burst: 30000\n  qps: 6000\n` [More info](https://rancher.com/docs/rke/latest/en/config-options/rate-limiting/) (string)
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Enable secrets encryption (bool)
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterServicesKubeApiDeprecatedSecretsEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customConfig":
            suggest = "custom_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServicesKubeApiDeprecatedSecretsEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServicesKubeApiDeprecatedSecretsEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServicesKubeApiDeprecatedSecretsEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_config: Optional[str] = None,
                 enabled: Optional[bool] = None):
        """
        :param str custom_config: Secrets encryption yaml encoded custom configuration. `"apiVersion"` and `"kind":"EncryptionConfiguration"` fields are required in the yaml. Ex. `apiVersion: apiserver.config.k8s.io/v1\nkind: EncryptionConfiguration\nresources:\n- resources:\n  - secrets\n  providers:\n  - aescbc:\n      keys:\n      - name: k-fw5hn\n        secret: RTczRjFDODMwQzAyMDVBREU4NDJBMUZFNDhCNzM5N0I=\n    identity: {}\n` [More info](https://rancher.com/docs/rke/latest/en/config-options/secrets-encryption/) (string)
        :param bool enabled: Enable secrets encryption (bool)
        """
        if custom_config is not None:
            pulumi.set(__self__, "custom_config", custom_config)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="customConfig")
    def custom_config(self) -> Optional[str]:
        """
        Secrets encryption yaml encoded custom configuration. `"apiVersion"` and `"kind":"EncryptionConfiguration"` fields are required in the yaml. Ex. `apiVersion: apiserver.config.k8s.io/v1\nkind: EncryptionConfiguration\nresources:\n- resources:\n  - secrets\n  providers:\n  - aescbc:\n      keys:\n      - name: k-fw5hn\n        secret: RTczRjFDODMwQzAyMDVBREU4NDJBMUZFNDhCNzM5N0I=\n    identity: {}\n` [More info](https://rancher.com/docs/rke/latest/en/config-options/secrets-encryption/) (string)
        """
        return pulumi.get(self, "custom_config")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Enable secrets encryption (bool)
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterServicesKubeApiEventRateLimit(dict):
    def __init__(__self__, *,
                 configuration: Optional[str] = None,
                 enabled: Optional[bool] = None):
        """
        :param str configuration: Event rate limit yaml encoded configuration. `"apiVersion"` and `"kind":"Configuration"` fields are required in the yaml. Ex. `apiVersion: eventratelimit.admission.k8s.io/v1alpha1\nkind: Configuration\nlimits:\n- type: Server\n  burst: 30000\n  qps: 6000\n` [More info](https://rancher.com/docs/rke/latest/en/config-options/rate-limiting/) (string)
        :param bool enabled: Enable secrets encryption (bool)
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[str]:
        """
        Event rate limit yaml encoded configuration. `"apiVersion"` and `"kind":"Configuration"` fields are required in the yaml. Ex. `apiVersion: eventratelimit.admission.k8s.io/v1alpha1\nkind: Configuration\nlimits:\n- type: Server\n  burst: 30000\n  qps: 6000\n` [More info](https://rancher.com/docs/rke/latest/en/config-options/rate-limiting/) (string)
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Enable secrets encryption (bool)
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterServicesKubeApiSecretsEncryptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customConfig":
            suggest = "custom_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServicesKubeApiSecretsEncryptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServicesKubeApiSecretsEncryptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServicesKubeApiSecretsEncryptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_config: Optional[str] = None,
                 enabled: Optional[bool] = None):
        """
        :param str custom_config: Secrets encryption yaml encoded custom configuration. `"apiVersion"` and `"kind":"EncryptionConfiguration"` fields are required in the yaml. Ex. `apiVersion: apiserver.config.k8s.io/v1\nkind: EncryptionConfiguration\nresources:\n- resources:\n  - secrets\n  providers:\n  - aescbc:\n      keys:\n      - name: k-fw5hn\n        secret: RTczRjFDODMwQzAyMDVBREU4NDJBMUZFNDhCNzM5N0I=\n    identity: {}\n` [More info](https://rancher.com/docs/rke/latest/en/config-options/secrets-encryption/) (string)
        :param bool enabled: Enable secrets encryption (bool)
        """
        if custom_config is not None:
            pulumi.set(__self__, "custom_config", custom_config)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="customConfig")
    def custom_config(self) -> Optional[str]:
        """
        Secrets encryption yaml encoded custom configuration. `"apiVersion"` and `"kind":"EncryptionConfiguration"` fields are required in the yaml. Ex. `apiVersion: apiserver.config.k8s.io/v1\nkind: EncryptionConfiguration\nresources:\n- resources:\n  - secrets\n  providers:\n  - aescbc:\n      keys:\n      - name: k-fw5hn\n        secret: RTczRjFDODMwQzAyMDVBREU4NDJBMUZFNDhCNzM5N0I=\n    identity: {}\n` [More info](https://rancher.com/docs/rke/latest/en/config-options/secrets-encryption/) (string)
        """
        return pulumi.get(self, "custom_config")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Enable secrets encryption (bool)
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterServicesKubeController(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterCidr":
            suggest = "cluster_cidr"
        elif key == "extraArgs":
            suggest = "extra_args"
        elif key == "extraBinds":
            suggest = "extra_binds"
        elif key == "extraEnvs":
            suggest = "extra_envs"
        elif key == "serviceClusterIpRange":
            suggest = "service_cluster_ip_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServicesKubeController. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServicesKubeController.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServicesKubeController.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_cidr: Optional[str] = None,
                 extra_args: Optional[Mapping[str, Any]] = None,
                 extra_binds: Optional[Sequence[str]] = None,
                 extra_envs: Optional[Sequence[str]] = None,
                 image: Optional[str] = None,
                 service_cluster_ip_range: Optional[str] = None):
        """
        :param str cluster_cidr: Cluster CIDR option for kube controller service (string)
        :param Mapping[str, Any] extra_args: Extra arguments for scheduler service (map)
        :param Sequence[str] extra_binds: Extra binds for scheduler service (list)
        :param Sequence[str] extra_envs: Extra environment for scheduler service (list)
        :param str image: Docker image for scheduler service (string)
        :param str service_cluster_ip_range: Service Cluster ip Range option for kube controller service (string)
        """
        if cluster_cidr is not None:
            pulumi.set(__self__, "cluster_cidr", cluster_cidr)
        if extra_args is not None:
            pulumi.set(__self__, "extra_args", extra_args)
        if extra_binds is not None:
            pulumi.set(__self__, "extra_binds", extra_binds)
        if extra_envs is not None:
            pulumi.set(__self__, "extra_envs", extra_envs)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if service_cluster_ip_range is not None:
            pulumi.set(__self__, "service_cluster_ip_range", service_cluster_ip_range)

    @property
    @pulumi.getter(name="clusterCidr")
    def cluster_cidr(self) -> Optional[str]:
        """
        Cluster CIDR option for kube controller service (string)
        """
        return pulumi.get(self, "cluster_cidr")

    @property
    @pulumi.getter(name="extraArgs")
    def extra_args(self) -> Optional[Mapping[str, Any]]:
        """
        Extra arguments for scheduler service (map)
        """
        return pulumi.get(self, "extra_args")

    @property
    @pulumi.getter(name="extraBinds")
    def extra_binds(self) -> Optional[Sequence[str]]:
        """
        Extra binds for scheduler service (list)
        """
        return pulumi.get(self, "extra_binds")

    @property
    @pulumi.getter(name="extraEnvs")
    def extra_envs(self) -> Optional[Sequence[str]]:
        """
        Extra environment for scheduler service (list)
        """
        return pulumi.get(self, "extra_envs")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        Docker image for scheduler service (string)
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="serviceClusterIpRange")
    def service_cluster_ip_range(self) -> Optional[str]:
        """
        Service Cluster ip Range option for kube controller service (string)
        """
        return pulumi.get(self, "service_cluster_ip_range")


@pulumi.output_type
class ClusterServicesKubeControllerDeprecated(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterCidr":
            suggest = "cluster_cidr"
        elif key == "extraArgs":
            suggest = "extra_args"
        elif key == "extraBinds":
            suggest = "extra_binds"
        elif key == "extraEnvs":
            suggest = "extra_envs"
        elif key == "serviceClusterIpRange":
            suggest = "service_cluster_ip_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServicesKubeControllerDeprecated. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServicesKubeControllerDeprecated.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServicesKubeControllerDeprecated.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_cidr: Optional[str] = None,
                 extra_args: Optional[Mapping[str, Any]] = None,
                 extra_binds: Optional[Sequence[str]] = None,
                 extra_envs: Optional[Sequence[str]] = None,
                 image: Optional[str] = None,
                 service_cluster_ip_range: Optional[str] = None):
        """
        :param str cluster_cidr: Cluster CIDR option for kube controller service (string)
        :param Mapping[str, Any] extra_args: Extra arguments for scheduler service (map)
        :param Sequence[str] extra_binds: Extra binds for scheduler service (list)
        :param Sequence[str] extra_envs: Extra environment for scheduler service (list)
        :param str image: Docker image for scheduler service (string)
        :param str service_cluster_ip_range: Service Cluster ip Range option for kube controller service (string)
        """
        if cluster_cidr is not None:
            pulumi.set(__self__, "cluster_cidr", cluster_cidr)
        if extra_args is not None:
            pulumi.set(__self__, "extra_args", extra_args)
        if extra_binds is not None:
            pulumi.set(__self__, "extra_binds", extra_binds)
        if extra_envs is not None:
            pulumi.set(__self__, "extra_envs", extra_envs)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if service_cluster_ip_range is not None:
            pulumi.set(__self__, "service_cluster_ip_range", service_cluster_ip_range)

    @property
    @pulumi.getter(name="clusterCidr")
    def cluster_cidr(self) -> Optional[str]:
        """
        Cluster CIDR option for kube controller service (string)
        """
        return pulumi.get(self, "cluster_cidr")

    @property
    @pulumi.getter(name="extraArgs")
    def extra_args(self) -> Optional[Mapping[str, Any]]:
        """
        Extra arguments for scheduler service (map)
        """
        return pulumi.get(self, "extra_args")

    @property
    @pulumi.getter(name="extraBinds")
    def extra_binds(self) -> Optional[Sequence[str]]:
        """
        Extra binds for scheduler service (list)
        """
        return pulumi.get(self, "extra_binds")

    @property
    @pulumi.getter(name="extraEnvs")
    def extra_envs(self) -> Optional[Sequence[str]]:
        """
        Extra environment for scheduler service (list)
        """
        return pulumi.get(self, "extra_envs")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        Docker image for scheduler service (string)
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="serviceClusterIpRange")
    def service_cluster_ip_range(self) -> Optional[str]:
        """
        Service Cluster ip Range option for kube controller service (string)
        """
        return pulumi.get(self, "service_cluster_ip_range")


@pulumi.output_type
class ClusterServicesKubeProxyDeprecated(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extraArgs":
            suggest = "extra_args"
        elif key == "extraBinds":
            suggest = "extra_binds"
        elif key == "extraEnvs":
            suggest = "extra_envs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServicesKubeProxyDeprecated. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServicesKubeProxyDeprecated.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServicesKubeProxyDeprecated.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extra_args: Optional[Mapping[str, Any]] = None,
                 extra_binds: Optional[Sequence[str]] = None,
                 extra_envs: Optional[Sequence[str]] = None,
                 image: Optional[str] = None):
        """
        :param Mapping[str, Any] extra_args: Extra arguments for scheduler service (map)
        :param Sequence[str] extra_binds: Extra binds for scheduler service (list)
        :param Sequence[str] extra_envs: Extra environment for scheduler service (list)
        :param str image: Docker image for scheduler service (string)
        """
        if extra_args is not None:
            pulumi.set(__self__, "extra_args", extra_args)
        if extra_binds is not None:
            pulumi.set(__self__, "extra_binds", extra_binds)
        if extra_envs is not None:
            pulumi.set(__self__, "extra_envs", extra_envs)
        if image is not None:
            pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter(name="extraArgs")
    def extra_args(self) -> Optional[Mapping[str, Any]]:
        """
        Extra arguments for scheduler service (map)
        """
        return pulumi.get(self, "extra_args")

    @property
    @pulumi.getter(name="extraBinds")
    def extra_binds(self) -> Optional[Sequence[str]]:
        """
        Extra binds for scheduler service (list)
        """
        return pulumi.get(self, "extra_binds")

    @property
    @pulumi.getter(name="extraEnvs")
    def extra_envs(self) -> Optional[Sequence[str]]:
        """
        Extra environment for scheduler service (list)
        """
        return pulumi.get(self, "extra_envs")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        Docker image for scheduler service (string)
        """
        return pulumi.get(self, "image")


@pulumi.output_type
class ClusterServicesKubeSchedulerDeprecated(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extraArgs":
            suggest = "extra_args"
        elif key == "extraBinds":
            suggest = "extra_binds"
        elif key == "extraEnvs":
            suggest = "extra_envs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServicesKubeSchedulerDeprecated. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServicesKubeSchedulerDeprecated.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServicesKubeSchedulerDeprecated.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extra_args: Optional[Mapping[str, Any]] = None,
                 extra_binds: Optional[Sequence[str]] = None,
                 extra_envs: Optional[Sequence[str]] = None,
                 image: Optional[str] = None):
        """
        :param Mapping[str, Any] extra_args: Extra arguments for scheduler service (map)
        :param Sequence[str] extra_binds: Extra binds for scheduler service (list)
        :param Sequence[str] extra_envs: Extra environment for scheduler service (list)
        :param str image: Docker image for scheduler service (string)
        """
        if extra_args is not None:
            pulumi.set(__self__, "extra_args", extra_args)
        if extra_binds is not None:
            pulumi.set(__self__, "extra_binds", extra_binds)
        if extra_envs is not None:
            pulumi.set(__self__, "extra_envs", extra_envs)
        if image is not None:
            pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter(name="extraArgs")
    def extra_args(self) -> Optional[Mapping[str, Any]]:
        """
        Extra arguments for scheduler service (map)
        """
        return pulumi.get(self, "extra_args")

    @property
    @pulumi.getter(name="extraBinds")
    def extra_binds(self) -> Optional[Sequence[str]]:
        """
        Extra binds for scheduler service (list)
        """
        return pulumi.get(self, "extra_binds")

    @property
    @pulumi.getter(name="extraEnvs")
    def extra_envs(self) -> Optional[Sequence[str]]:
        """
        Extra environment for scheduler service (list)
        """
        return pulumi.get(self, "extra_envs")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        Docker image for scheduler service (string)
        """
        return pulumi.get(self, "image")


@pulumi.output_type
class ClusterServicesKubelet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterDnsServer":
            suggest = "cluster_dns_server"
        elif key == "clusterDomain":
            suggest = "cluster_domain"
        elif key == "extraArgs":
            suggest = "extra_args"
        elif key == "extraBinds":
            suggest = "extra_binds"
        elif key == "extraEnvs":
            suggest = "extra_envs"
        elif key == "failSwapOn":
            suggest = "fail_swap_on"
        elif key == "generateServingCertificate":
            suggest = "generate_serving_certificate"
        elif key == "infraContainerImage":
            suggest = "infra_container_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServicesKubelet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServicesKubelet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServicesKubelet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_dns_server: Optional[str] = None,
                 cluster_domain: Optional[str] = None,
                 extra_args: Optional[Mapping[str, Any]] = None,
                 extra_binds: Optional[Sequence[str]] = None,
                 extra_envs: Optional[Sequence[str]] = None,
                 fail_swap_on: Optional[bool] = None,
                 generate_serving_certificate: Optional[bool] = None,
                 image: Optional[str] = None,
                 infra_container_image: Optional[str] = None):
        """
        :param str cluster_dns_server: Cluster DNS Server option for kubelet service (string)
        :param str cluster_domain: Cluster Domain option for kubelet service. Default `cluster.local` (string)
        :param Mapping[str, Any] extra_args: Extra arguments for scheduler service (map)
        :param Sequence[str] extra_binds: Extra binds for scheduler service (list)
        :param Sequence[str] extra_envs: Extra environment for scheduler service (list)
        :param bool fail_swap_on: Enable or disable failing when swap on is not supported (bool)
        :param bool generate_serving_certificate: [Generate a certificate signed by the kube-ca](https://rancher.com/docs/rke/latest/en/config-options/services/#kubelet-serving-certificate-requirements). Default `false` (bool)
        :param str image: Docker image for scheduler service (string)
        :param str infra_container_image: Infra container image for kubelet service (string)
        """
        if cluster_dns_server is not None:
            pulumi.set(__self__, "cluster_dns_server", cluster_dns_server)
        if cluster_domain is not None:
            pulumi.set(__self__, "cluster_domain", cluster_domain)
        if extra_args is not None:
            pulumi.set(__self__, "extra_args", extra_args)
        if extra_binds is not None:
            pulumi.set(__self__, "extra_binds", extra_binds)
        if extra_envs is not None:
            pulumi.set(__self__, "extra_envs", extra_envs)
        if fail_swap_on is not None:
            pulumi.set(__self__, "fail_swap_on", fail_swap_on)
        if generate_serving_certificate is not None:
            pulumi.set(__self__, "generate_serving_certificate", generate_serving_certificate)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if infra_container_image is not None:
            pulumi.set(__self__, "infra_container_image", infra_container_image)

    @property
    @pulumi.getter(name="clusterDnsServer")
    def cluster_dns_server(self) -> Optional[str]:
        """
        Cluster DNS Server option for kubelet service (string)
        """
        return pulumi.get(self, "cluster_dns_server")

    @property
    @pulumi.getter(name="clusterDomain")
    def cluster_domain(self) -> Optional[str]:
        """
        Cluster Domain option for kubelet service. Default `cluster.local` (string)
        """
        return pulumi.get(self, "cluster_domain")

    @property
    @pulumi.getter(name="extraArgs")
    def extra_args(self) -> Optional[Mapping[str, Any]]:
        """
        Extra arguments for scheduler service (map)
        """
        return pulumi.get(self, "extra_args")

    @property
    @pulumi.getter(name="extraBinds")
    def extra_binds(self) -> Optional[Sequence[str]]:
        """
        Extra binds for scheduler service (list)
        """
        return pulumi.get(self, "extra_binds")

    @property
    @pulumi.getter(name="extraEnvs")
    def extra_envs(self) -> Optional[Sequence[str]]:
        """
        Extra environment for scheduler service (list)
        """
        return pulumi.get(self, "extra_envs")

    @property
    @pulumi.getter(name="failSwapOn")
    def fail_swap_on(self) -> Optional[bool]:
        """
        Enable or disable failing when swap on is not supported (bool)
        """
        return pulumi.get(self, "fail_swap_on")

    @property
    @pulumi.getter(name="generateServingCertificate")
    def generate_serving_certificate(self) -> Optional[bool]:
        """
        [Generate a certificate signed by the kube-ca](https://rancher.com/docs/rke/latest/en/config-options/services/#kubelet-serving-certificate-requirements). Default `false` (bool)
        """
        return pulumi.get(self, "generate_serving_certificate")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        Docker image for scheduler service (string)
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="infraContainerImage")
    def infra_container_image(self) -> Optional[str]:
        """
        Infra container image for kubelet service (string)
        """
        return pulumi.get(self, "infra_container_image")


@pulumi.output_type
class ClusterServicesKubeletDeprecated(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterDnsServer":
            suggest = "cluster_dns_server"
        elif key == "clusterDomain":
            suggest = "cluster_domain"
        elif key == "extraArgs":
            suggest = "extra_args"
        elif key == "extraBinds":
            suggest = "extra_binds"
        elif key == "extraEnvs":
            suggest = "extra_envs"
        elif key == "failSwapOn":
            suggest = "fail_swap_on"
        elif key == "generateServingCertificate":
            suggest = "generate_serving_certificate"
        elif key == "infraContainerImage":
            suggest = "infra_container_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServicesKubeletDeprecated. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServicesKubeletDeprecated.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServicesKubeletDeprecated.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_dns_server: Optional[str] = None,
                 cluster_domain: Optional[str] = None,
                 extra_args: Optional[Mapping[str, Any]] = None,
                 extra_binds: Optional[Sequence[str]] = None,
                 extra_envs: Optional[Sequence[str]] = None,
                 fail_swap_on: Optional[bool] = None,
                 generate_serving_certificate: Optional[bool] = None,
                 image: Optional[str] = None,
                 infra_container_image: Optional[str] = None):
        """
        :param str cluster_dns_server: Cluster DNS Server option for kubelet service (string)
        :param str cluster_domain: Cluster Domain option for kubelet service. Default `cluster.local` (string)
        :param Mapping[str, Any] extra_args: Extra arguments for scheduler service (map)
        :param Sequence[str] extra_binds: Extra binds for scheduler service (list)
        :param Sequence[str] extra_envs: Extra environment for scheduler service (list)
        :param bool fail_swap_on: Enable or disable failing when swap on is not supported (bool)
        :param bool generate_serving_certificate: [Generate a certificate signed by the kube-ca](https://rancher.com/docs/rke/latest/en/config-options/services/#kubelet-serving-certificate-requirements). Default `false` (bool)
        :param str image: Docker image for scheduler service (string)
        :param str infra_container_image: Infra container image for kubelet service (string)
        """
        if cluster_dns_server is not None:
            pulumi.set(__self__, "cluster_dns_server", cluster_dns_server)
        if cluster_domain is not None:
            pulumi.set(__self__, "cluster_domain", cluster_domain)
        if extra_args is not None:
            pulumi.set(__self__, "extra_args", extra_args)
        if extra_binds is not None:
            pulumi.set(__self__, "extra_binds", extra_binds)
        if extra_envs is not None:
            pulumi.set(__self__, "extra_envs", extra_envs)
        if fail_swap_on is not None:
            pulumi.set(__self__, "fail_swap_on", fail_swap_on)
        if generate_serving_certificate is not None:
            pulumi.set(__self__, "generate_serving_certificate", generate_serving_certificate)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if infra_container_image is not None:
            pulumi.set(__self__, "infra_container_image", infra_container_image)

    @property
    @pulumi.getter(name="clusterDnsServer")
    def cluster_dns_server(self) -> Optional[str]:
        """
        Cluster DNS Server option for kubelet service (string)
        """
        return pulumi.get(self, "cluster_dns_server")

    @property
    @pulumi.getter(name="clusterDomain")
    def cluster_domain(self) -> Optional[str]:
        """
        Cluster Domain option for kubelet service. Default `cluster.local` (string)
        """
        return pulumi.get(self, "cluster_domain")

    @property
    @pulumi.getter(name="extraArgs")
    def extra_args(self) -> Optional[Mapping[str, Any]]:
        """
        Extra arguments for scheduler service (map)
        """
        return pulumi.get(self, "extra_args")

    @property
    @pulumi.getter(name="extraBinds")
    def extra_binds(self) -> Optional[Sequence[str]]:
        """
        Extra binds for scheduler service (list)
        """
        return pulumi.get(self, "extra_binds")

    @property
    @pulumi.getter(name="extraEnvs")
    def extra_envs(self) -> Optional[Sequence[str]]:
        """
        Extra environment for scheduler service (list)
        """
        return pulumi.get(self, "extra_envs")

    @property
    @pulumi.getter(name="failSwapOn")
    def fail_swap_on(self) -> Optional[bool]:
        """
        Enable or disable failing when swap on is not supported (bool)
        """
        return pulumi.get(self, "fail_swap_on")

    @property
    @pulumi.getter(name="generateServingCertificate")
    def generate_serving_certificate(self) -> Optional[bool]:
        """
        [Generate a certificate signed by the kube-ca](https://rancher.com/docs/rke/latest/en/config-options/services/#kubelet-serving-certificate-requirements). Default `false` (bool)
        """
        return pulumi.get(self, "generate_serving_certificate")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        Docker image for scheduler service (string)
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="infraContainerImage")
    def infra_container_image(self) -> Optional[str]:
        """
        Infra container image for kubelet service (string)
        """
        return pulumi.get(self, "infra_container_image")


@pulumi.output_type
class ClusterServicesKubeproxy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extraArgs":
            suggest = "extra_args"
        elif key == "extraBinds":
            suggest = "extra_binds"
        elif key == "extraEnvs":
            suggest = "extra_envs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServicesKubeproxy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServicesKubeproxy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServicesKubeproxy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extra_args: Optional[Mapping[str, Any]] = None,
                 extra_binds: Optional[Sequence[str]] = None,
                 extra_envs: Optional[Sequence[str]] = None,
                 image: Optional[str] = None):
        """
        :param Mapping[str, Any] extra_args: Extra arguments for scheduler service (map)
        :param Sequence[str] extra_binds: Extra binds for scheduler service (list)
        :param Sequence[str] extra_envs: Extra environment for scheduler service (list)
        :param str image: Docker image for scheduler service (string)
        """
        if extra_args is not None:
            pulumi.set(__self__, "extra_args", extra_args)
        if extra_binds is not None:
            pulumi.set(__self__, "extra_binds", extra_binds)
        if extra_envs is not None:
            pulumi.set(__self__, "extra_envs", extra_envs)
        if image is not None:
            pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter(name="extraArgs")
    def extra_args(self) -> Optional[Mapping[str, Any]]:
        """
        Extra arguments for scheduler service (map)
        """
        return pulumi.get(self, "extra_args")

    @property
    @pulumi.getter(name="extraBinds")
    def extra_binds(self) -> Optional[Sequence[str]]:
        """
        Extra binds for scheduler service (list)
        """
        return pulumi.get(self, "extra_binds")

    @property
    @pulumi.getter(name="extraEnvs")
    def extra_envs(self) -> Optional[Sequence[str]]:
        """
        Extra environment for scheduler service (list)
        """
        return pulumi.get(self, "extra_envs")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        Docker image for scheduler service (string)
        """
        return pulumi.get(self, "image")


@pulumi.output_type
class ClusterServicesScheduler(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extraArgs":
            suggest = "extra_args"
        elif key == "extraBinds":
            suggest = "extra_binds"
        elif key == "extraEnvs":
            suggest = "extra_envs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterServicesScheduler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterServicesScheduler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterServicesScheduler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 extra_args: Optional[Mapping[str, Any]] = None,
                 extra_binds: Optional[Sequence[str]] = None,
                 extra_envs: Optional[Sequence[str]] = None,
                 image: Optional[str] = None):
        """
        :param Mapping[str, Any] extra_args: Extra arguments for scheduler service (map)
        :param Sequence[str] extra_binds: Extra binds for scheduler service (list)
        :param Sequence[str] extra_envs: Extra environment for scheduler service (list)
        :param str image: Docker image for scheduler service (string)
        """
        if extra_args is not None:
            pulumi.set(__self__, "extra_args", extra_args)
        if extra_binds is not None:
            pulumi.set(__self__, "extra_binds", extra_binds)
        if extra_envs is not None:
            pulumi.set(__self__, "extra_envs", extra_envs)
        if image is not None:
            pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter(name="extraArgs")
    def extra_args(self) -> Optional[Mapping[str, Any]]:
        """
        Extra arguments for scheduler service (map)
        """
        return pulumi.get(self, "extra_args")

    @property
    @pulumi.getter(name="extraBinds")
    def extra_binds(self) -> Optional[Sequence[str]]:
        """
        Extra binds for scheduler service (list)
        """
        return pulumi.get(self, "extra_binds")

    @property
    @pulumi.getter(name="extraEnvs")
    def extra_envs(self) -> Optional[Sequence[str]]:
        """
        Extra environment for scheduler service (list)
        """
        return pulumi.get(self, "extra_envs")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        Docker image for scheduler service (string)
        """
        return pulumi.get(self, "image")


@pulumi.output_type
class ClusterSystemImages(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aciCniDeployContainer":
            suggest = "aci_cni_deploy_container"
        elif key == "aciControllerContainer":
            suggest = "aci_controller_container"
        elif key == "aciHostContainer":
            suggest = "aci_host_container"
        elif key == "aciMcastContainer":
            suggest = "aci_mcast_container"
        elif key == "aciOpflexContainer":
            suggest = "aci_opflex_container"
        elif key == "aciOvsContainer":
            suggest = "aci_ovs_container"
        elif key == "calicoCni":
            suggest = "calico_cni"
        elif key == "calicoControllers":
            suggest = "calico_controllers"
        elif key == "calicoCtl":
            suggest = "calico_ctl"
        elif key == "calicoFlexVol":
            suggest = "calico_flex_vol"
        elif key == "calicoNode":
            suggest = "calico_node"
        elif key == "canalCni":
            suggest = "canal_cni"
        elif key == "canalFlannel":
            suggest = "canal_flannel"
        elif key == "canalFlexVol":
            suggest = "canal_flex_vol"
        elif key == "canalNode":
            suggest = "canal_node"
        elif key == "certDownloader":
            suggest = "cert_downloader"
        elif key == "corednsAutoscaler":
            suggest = "coredns_autoscaler"
        elif key == "flannelCni":
            suggest = "flannel_cni"
        elif key == "ingressBackend":
            suggest = "ingress_backend"
        elif key == "kubeDns":
            suggest = "kube_dns"
        elif key == "kubeDnsAutoscaler":
            suggest = "kube_dns_autoscaler"
        elif key == "kubeDnsSidecar":
            suggest = "kube_dns_sidecar"
        elif key == "kubernetesServicesSidecar":
            suggest = "kubernetes_services_sidecar"
        elif key == "metricsServer":
            suggest = "metrics_server"
        elif key == "nginxProxy":
            suggest = "nginx_proxy"
        elif key == "podInfraContainer":
            suggest = "pod_infra_container"
        elif key == "weaveCni":
            suggest = "weave_cni"
        elif key == "weaveNode":
            suggest = "weave_node"
        elif key == "windowsPodInfraContainer":
            suggest = "windows_pod_infra_container"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterSystemImages. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterSystemImages.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterSystemImages.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aci_cni_deploy_container: Optional[str] = None,
                 aci_controller_container: Optional[str] = None,
                 aci_host_container: Optional[str] = None,
                 aci_mcast_container: Optional[str] = None,
                 aci_opflex_container: Optional[str] = None,
                 aci_ovs_container: Optional[str] = None,
                 alpine: Optional[str] = None,
                 calico_cni: Optional[str] = None,
                 calico_controllers: Optional[str] = None,
                 calico_ctl: Optional[str] = None,
                 calico_flex_vol: Optional[str] = None,
                 calico_node: Optional[str] = None,
                 canal_cni: Optional[str] = None,
                 canal_flannel: Optional[str] = None,
                 canal_flex_vol: Optional[str] = None,
                 canal_node: Optional[str] = None,
                 cert_downloader: Optional[str] = None,
                 coredns: Optional[str] = None,
                 coredns_autoscaler: Optional[str] = None,
                 dnsmasq: Optional[str] = None,
                 etcd: Optional[str] = None,
                 flannel: Optional[str] = None,
                 flannel_cni: Optional[str] = None,
                 ingress: Optional[str] = None,
                 ingress_backend: Optional[str] = None,
                 kube_dns: Optional[str] = None,
                 kube_dns_autoscaler: Optional[str] = None,
                 kube_dns_sidecar: Optional[str] = None,
                 kubernetes: Optional[str] = None,
                 kubernetes_services_sidecar: Optional[str] = None,
                 metrics_server: Optional[str] = None,
                 nginx_proxy: Optional[str] = None,
                 nodelocal: Optional[str] = None,
                 pod_infra_container: Optional[str] = None,
                 weave_cni: Optional[str] = None,
                 weave_node: Optional[str] = None,
                 windows_pod_infra_container: Optional[str] = None):
        """
        :param str aci_cni_deploy_container: Docker image for aci_cni_deploy_container (string)
        :param str aci_controller_container: Docker image for aci_controller_container (string)
        :param str aci_host_container: Docker image for aci_host_container (string)
        :param str aci_mcast_container: Docker image for aci_mcast_container (string)
        :param str aci_opflex_container: Docker image for aci_opflex_container (string)
        :param str aci_ovs_container: Docker image for aci_ovs_container (string)
        :param str alpine: Docker image for alpine (string)
        :param str calico_cni: Docker image for calico_cni (string)
        :param str calico_controllers: Docker image for calico_controllers (string)
        :param str calico_ctl: Docker image for calico_ctl (string)
        :param str calico_flex_vol: Docker image for calico_flex_vol (string)
        :param str calico_node: Docker image for calico_node (string)
        :param str canal_cni: Docker image for canal_cni (string)
        :param str canal_flannel: Docker image for canal_flannel (string)
        :param str canal_flex_vol: Docker image for canal_flex_vol (string)
        :param str canal_node: Docker image for canal_node (string)
        :param str cert_downloader: Docker image for cert_downloader (string)
        :param str coredns: Docker image for coredns (string)
        :param str coredns_autoscaler: Docker image for coredns_autoscaler (string)
        :param str dnsmasq: Docker image for dnsmasq (string)
        :param str etcd: Docker image for etcd (string)
        :param str flannel: Docker image for flannel (string)
        :param str flannel_cni: Docker image for flannel_cni (string)
        :param str ingress: Docker image for ingress (string)
        :param str ingress_backend: Docker image for ingress_backend (string)
        :param str kube_dns: Docker image for kube_dns (string)
        :param str kube_dns_autoscaler: Docker image for kube_dns_autoscaler (string)
        :param str kube_dns_sidecar: Docker image for kube_dns_sidecar (string)
        :param str kubernetes: Docker image for kubernetes (string)
        :param str kubernetes_services_sidecar: Docker image for kubernetes_services_sidecar (string)
        :param str metrics_server: Docker image for metrics_server (string)
        :param str nginx_proxy: Docker image for nginx_proxy (string)
        :param str nodelocal: Docker image for nodelocal (string)
        :param str pod_infra_container: Docker image for pod_infra_container (string)
        :param str weave_cni: Docker image for weave_cni (string)
        :param str weave_node: Docker image for weave_node (string)
        :param str windows_pod_infra_container: Docker image for windows_pod_infra_container (string)
        """
        if aci_cni_deploy_container is not None:
            pulumi.set(__self__, "aci_cni_deploy_container", aci_cni_deploy_container)
        if aci_controller_container is not None:
            pulumi.set(__self__, "aci_controller_container", aci_controller_container)
        if aci_host_container is not None:
            pulumi.set(__self__, "aci_host_container", aci_host_container)
        if aci_mcast_container is not None:
            pulumi.set(__self__, "aci_mcast_container", aci_mcast_container)
        if aci_opflex_container is not None:
            pulumi.set(__self__, "aci_opflex_container", aci_opflex_container)
        if aci_ovs_container is not None:
            pulumi.set(__self__, "aci_ovs_container", aci_ovs_container)
        if alpine is not None:
            pulumi.set(__self__, "alpine", alpine)
        if calico_cni is not None:
            pulumi.set(__self__, "calico_cni", calico_cni)
        if calico_controllers is not None:
            pulumi.set(__self__, "calico_controllers", calico_controllers)
        if calico_ctl is not None:
            pulumi.set(__self__, "calico_ctl", calico_ctl)
        if calico_flex_vol is not None:
            pulumi.set(__self__, "calico_flex_vol", calico_flex_vol)
        if calico_node is not None:
            pulumi.set(__self__, "calico_node", calico_node)
        if canal_cni is not None:
            pulumi.set(__self__, "canal_cni", canal_cni)
        if canal_flannel is not None:
            pulumi.set(__self__, "canal_flannel", canal_flannel)
        if canal_flex_vol is not None:
            pulumi.set(__self__, "canal_flex_vol", canal_flex_vol)
        if canal_node is not None:
            pulumi.set(__self__, "canal_node", canal_node)
        if cert_downloader is not None:
            pulumi.set(__self__, "cert_downloader", cert_downloader)
        if coredns is not None:
            pulumi.set(__self__, "coredns", coredns)
        if coredns_autoscaler is not None:
            pulumi.set(__self__, "coredns_autoscaler", coredns_autoscaler)
        if dnsmasq is not None:
            pulumi.set(__self__, "dnsmasq", dnsmasq)
        if etcd is not None:
            pulumi.set(__self__, "etcd", etcd)
        if flannel is not None:
            pulumi.set(__self__, "flannel", flannel)
        if flannel_cni is not None:
            pulumi.set(__self__, "flannel_cni", flannel_cni)
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)
        if ingress_backend is not None:
            pulumi.set(__self__, "ingress_backend", ingress_backend)
        if kube_dns is not None:
            pulumi.set(__self__, "kube_dns", kube_dns)
        if kube_dns_autoscaler is not None:
            pulumi.set(__self__, "kube_dns_autoscaler", kube_dns_autoscaler)
        if kube_dns_sidecar is not None:
            pulumi.set(__self__, "kube_dns_sidecar", kube_dns_sidecar)
        if kubernetes is not None:
            pulumi.set(__self__, "kubernetes", kubernetes)
        if kubernetes_services_sidecar is not None:
            pulumi.set(__self__, "kubernetes_services_sidecar", kubernetes_services_sidecar)
        if metrics_server is not None:
            pulumi.set(__self__, "metrics_server", metrics_server)
        if nginx_proxy is not None:
            pulumi.set(__self__, "nginx_proxy", nginx_proxy)
        if nodelocal is not None:
            pulumi.set(__self__, "nodelocal", nodelocal)
        if pod_infra_container is not None:
            pulumi.set(__self__, "pod_infra_container", pod_infra_container)
        if weave_cni is not None:
            pulumi.set(__self__, "weave_cni", weave_cni)
        if weave_node is not None:
            pulumi.set(__self__, "weave_node", weave_node)
        if windows_pod_infra_container is not None:
            pulumi.set(__self__, "windows_pod_infra_container", windows_pod_infra_container)

    @property
    @pulumi.getter(name="aciCniDeployContainer")
    def aci_cni_deploy_container(self) -> Optional[str]:
        """
        Docker image for aci_cni_deploy_container (string)
        """
        return pulumi.get(self, "aci_cni_deploy_container")

    @property
    @pulumi.getter(name="aciControllerContainer")
    def aci_controller_container(self) -> Optional[str]:
        """
        Docker image for aci_controller_container (string)
        """
        return pulumi.get(self, "aci_controller_container")

    @property
    @pulumi.getter(name="aciHostContainer")
    def aci_host_container(self) -> Optional[str]:
        """
        Docker image for aci_host_container (string)
        """
        return pulumi.get(self, "aci_host_container")

    @property
    @pulumi.getter(name="aciMcastContainer")
    def aci_mcast_container(self) -> Optional[str]:
        """
        Docker image for aci_mcast_container (string)
        """
        return pulumi.get(self, "aci_mcast_container")

    @property
    @pulumi.getter(name="aciOpflexContainer")
    def aci_opflex_container(self) -> Optional[str]:
        """
        Docker image for aci_opflex_container (string)
        """
        return pulumi.get(self, "aci_opflex_container")

    @property
    @pulumi.getter(name="aciOvsContainer")
    def aci_ovs_container(self) -> Optional[str]:
        """
        Docker image for aci_ovs_container (string)
        """
        return pulumi.get(self, "aci_ovs_container")

    @property
    @pulumi.getter
    def alpine(self) -> Optional[str]:
        """
        Docker image for alpine (string)
        """
        return pulumi.get(self, "alpine")

    @property
    @pulumi.getter(name="calicoCni")
    def calico_cni(self) -> Optional[str]:
        """
        Docker image for calico_cni (string)
        """
        return pulumi.get(self, "calico_cni")

    @property
    @pulumi.getter(name="calicoControllers")
    def calico_controllers(self) -> Optional[str]:
        """
        Docker image for calico_controllers (string)
        """
        return pulumi.get(self, "calico_controllers")

    @property
    @pulumi.getter(name="calicoCtl")
    def calico_ctl(self) -> Optional[str]:
        """
        Docker image for calico_ctl (string)
        """
        return pulumi.get(self, "calico_ctl")

    @property
    @pulumi.getter(name="calicoFlexVol")
    def calico_flex_vol(self) -> Optional[str]:
        """
        Docker image for calico_flex_vol (string)
        """
        return pulumi.get(self, "calico_flex_vol")

    @property
    @pulumi.getter(name="calicoNode")
    def calico_node(self) -> Optional[str]:
        """
        Docker image for calico_node (string)
        """
        return pulumi.get(self, "calico_node")

    @property
    @pulumi.getter(name="canalCni")
    def canal_cni(self) -> Optional[str]:
        """
        Docker image for canal_cni (string)
        """
        return pulumi.get(self, "canal_cni")

    @property
    @pulumi.getter(name="canalFlannel")
    def canal_flannel(self) -> Optional[str]:
        """
        Docker image for canal_flannel (string)
        """
        return pulumi.get(self, "canal_flannel")

    @property
    @pulumi.getter(name="canalFlexVol")
    def canal_flex_vol(self) -> Optional[str]:
        """
        Docker image for canal_flex_vol (string)
        """
        return pulumi.get(self, "canal_flex_vol")

    @property
    @pulumi.getter(name="canalNode")
    def canal_node(self) -> Optional[str]:
        """
        Docker image for canal_node (string)
        """
        return pulumi.get(self, "canal_node")

    @property
    @pulumi.getter(name="certDownloader")
    def cert_downloader(self) -> Optional[str]:
        """
        Docker image for cert_downloader (string)
        """
        return pulumi.get(self, "cert_downloader")

    @property
    @pulumi.getter
    def coredns(self) -> Optional[str]:
        """
        Docker image for coredns (string)
        """
        return pulumi.get(self, "coredns")

    @property
    @pulumi.getter(name="corednsAutoscaler")
    def coredns_autoscaler(self) -> Optional[str]:
        """
        Docker image for coredns_autoscaler (string)
        """
        return pulumi.get(self, "coredns_autoscaler")

    @property
    @pulumi.getter
    def dnsmasq(self) -> Optional[str]:
        """
        Docker image for dnsmasq (string)
        """
        return pulumi.get(self, "dnsmasq")

    @property
    @pulumi.getter
    def etcd(self) -> Optional[str]:
        """
        Docker image for etcd (string)
        """
        return pulumi.get(self, "etcd")

    @property
    @pulumi.getter
    def flannel(self) -> Optional[str]:
        """
        Docker image for flannel (string)
        """
        return pulumi.get(self, "flannel")

    @property
    @pulumi.getter(name="flannelCni")
    def flannel_cni(self) -> Optional[str]:
        """
        Docker image for flannel_cni (string)
        """
        return pulumi.get(self, "flannel_cni")

    @property
    @pulumi.getter
    def ingress(self) -> Optional[str]:
        """
        Docker image for ingress (string)
        """
        return pulumi.get(self, "ingress")

    @property
    @pulumi.getter(name="ingressBackend")
    def ingress_backend(self) -> Optional[str]:
        """
        Docker image for ingress_backend (string)
        """
        return pulumi.get(self, "ingress_backend")

    @property
    @pulumi.getter(name="kubeDns")
    def kube_dns(self) -> Optional[str]:
        """
        Docker image for kube_dns (string)
        """
        return pulumi.get(self, "kube_dns")

    @property
    @pulumi.getter(name="kubeDnsAutoscaler")
    def kube_dns_autoscaler(self) -> Optional[str]:
        """
        Docker image for kube_dns_autoscaler (string)
        """
        return pulumi.get(self, "kube_dns_autoscaler")

    @property
    @pulumi.getter(name="kubeDnsSidecar")
    def kube_dns_sidecar(self) -> Optional[str]:
        """
        Docker image for kube_dns_sidecar (string)
        """
        return pulumi.get(self, "kube_dns_sidecar")

    @property
    @pulumi.getter
    def kubernetes(self) -> Optional[str]:
        """
        Docker image for kubernetes (string)
        """
        return pulumi.get(self, "kubernetes")

    @property
    @pulumi.getter(name="kubernetesServicesSidecar")
    def kubernetes_services_sidecar(self) -> Optional[str]:
        """
        Docker image for kubernetes_services_sidecar (string)
        """
        return pulumi.get(self, "kubernetes_services_sidecar")

    @property
    @pulumi.getter(name="metricsServer")
    def metrics_server(self) -> Optional[str]:
        """
        Docker image for metrics_server (string)
        """
        return pulumi.get(self, "metrics_server")

    @property
    @pulumi.getter(name="nginxProxy")
    def nginx_proxy(self) -> Optional[str]:
        """
        Docker image for nginx_proxy (string)
        """
        return pulumi.get(self, "nginx_proxy")

    @property
    @pulumi.getter
    def nodelocal(self) -> Optional[str]:
        """
        Docker image for nodelocal (string)
        """
        return pulumi.get(self, "nodelocal")

    @property
    @pulumi.getter(name="podInfraContainer")
    def pod_infra_container(self) -> Optional[str]:
        """
        Docker image for pod_infra_container (string)
        """
        return pulumi.get(self, "pod_infra_container")

    @property
    @pulumi.getter(name="weaveCni")
    def weave_cni(self) -> Optional[str]:
        """
        Docker image for weave_cni (string)
        """
        return pulumi.get(self, "weave_cni")

    @property
    @pulumi.getter(name="weaveNode")
    def weave_node(self) -> Optional[str]:
        """
        Docker image for weave_node (string)
        """
        return pulumi.get(self, "weave_node")

    @property
    @pulumi.getter(name="windowsPodInfraContainer")
    def windows_pod_infra_container(self) -> Optional[str]:
        """
        Docker image for windows_pod_infra_container (string)
        """
        return pulumi.get(self, "windows_pod_infra_container")


@pulumi.output_type
class ClusterUpgradeStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "drainInput":
            suggest = "drain_input"
        elif key == "maxUnavailableControlplane":
            suggest = "max_unavailable_controlplane"
        elif key == "maxUnavailableWorker":
            suggest = "max_unavailable_worker"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterUpgradeStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterUpgradeStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterUpgradeStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 drain: Optional[bool] = None,
                 drain_input: Optional['outputs.ClusterUpgradeStrategyDrainInput'] = None,
                 max_unavailable_controlplane: Optional[str] = None,
                 max_unavailable_worker: Optional[str] = None):
        """
        :param bool drain: RKE drain nodes (bool)
        :param 'ClusterUpgradeStrategyDrainInputArgs' drain_input: RKE drain node input (list Maxitems: 1)
        :param str max_unavailable_controlplane: RKE max unavailable controlplane nodes (string)
        :param str max_unavailable_worker: RKE max unavailable worker nodes (string)
        """
        if drain is not None:
            pulumi.set(__self__, "drain", drain)
        if drain_input is not None:
            pulumi.set(__self__, "drain_input", drain_input)
        if max_unavailable_controlplane is not None:
            pulumi.set(__self__, "max_unavailable_controlplane", max_unavailable_controlplane)
        if max_unavailable_worker is not None:
            pulumi.set(__self__, "max_unavailable_worker", max_unavailable_worker)

    @property
    @pulumi.getter
    def drain(self) -> Optional[bool]:
        """
        RKE drain nodes (bool)
        """
        return pulumi.get(self, "drain")

    @property
    @pulumi.getter(name="drainInput")
    def drain_input(self) -> Optional['outputs.ClusterUpgradeStrategyDrainInput']:
        """
        RKE drain node input (list Maxitems: 1)
        """
        return pulumi.get(self, "drain_input")

    @property
    @pulumi.getter(name="maxUnavailableControlplane")
    def max_unavailable_controlplane(self) -> Optional[str]:
        """
        RKE max unavailable controlplane nodes (string)
        """
        return pulumi.get(self, "max_unavailable_controlplane")

    @property
    @pulumi.getter(name="maxUnavailableWorker")
    def max_unavailable_worker(self) -> Optional[str]:
        """
        RKE max unavailable worker nodes (string)
        """
        return pulumi.get(self, "max_unavailable_worker")


@pulumi.output_type
class ClusterUpgradeStrategyDrainInput(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteLocalData":
            suggest = "delete_local_data"
        elif key == "gracePeriod":
            suggest = "grace_period"
        elif key == "ignoreDaemonSets":
            suggest = "ignore_daemon_sets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterUpgradeStrategyDrainInput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterUpgradeStrategyDrainInput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterUpgradeStrategyDrainInput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_local_data: Optional[bool] = None,
                 force: Optional[bool] = None,
                 grace_period: Optional[int] = None,
                 ignore_daemon_sets: Optional[bool] = None,
                 timeout: Optional[int] = None):
        """
        :param bool delete_local_data: Delete RKE node local data (bool)
        :param bool force: Force RKE node drain (bool)
        :param int grace_period: RKE node drain grace period (int)
        :param bool ignore_daemon_sets: Ignore RKE daemon sets (bool)
        :param int timeout: RKE node drain timeout (int)
        """
        if delete_local_data is not None:
            pulumi.set(__self__, "delete_local_data", delete_local_data)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)
        if ignore_daemon_sets is not None:
            pulumi.set(__self__, "ignore_daemon_sets", ignore_daemon_sets)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="deleteLocalData")
    def delete_local_data(self) -> Optional[bool]:
        """
        Delete RKE node local data (bool)
        """
        return pulumi.get(self, "delete_local_data")

    @property
    @pulumi.getter
    def force(self) -> Optional[bool]:
        """
        Force RKE node drain (bool)
        """
        return pulumi.get(self, "force")

    @property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[int]:
        """
        RKE node drain grace period (int)
        """
        return pulumi.get(self, "grace_period")

    @property
    @pulumi.getter(name="ignoreDaemonSets")
    def ignore_daemon_sets(self) -> Optional[bool]:
        """
        Ignore RKE daemon sets (bool)
        """
        return pulumi.get(self, "ignore_daemon_sets")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        RKE node drain timeout (int)
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ClusterWorkerHost(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeName":
            suggest = "node_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterWorkerHost. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterWorkerHost.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterWorkerHost.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: Optional[str] = None,
                 node_name: Optional[str] = None):
        """
        :param str address: Address ip for node (string)
        :param str node_name: Name of the host provisioned via docker machine (string)
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if node_name is not None:
            pulumi.set(__self__, "node_name", node_name)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Address ip for node (string)
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> Optional[str]:
        """
        Name of the host provisioned via docker machine (string)
        """
        return pulumi.get(self, "node_name")


