# DO NOT MODIFY -- This file is generated by type_spec
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from enum import StrEnum
import dataclasses
from pkgs.serialization import serial_class
from pkgs.serialization import serial_union_annotation
from ... import async_batch_t
from ... import base_t
from ... import entity_t
from ... import field_values_t
from ... import identifier_t

__all__: list[str] = [
    "Arguments",
    "Data",
    "ENDPOINT_METHOD",
    "ENDPOINT_PATH",
    "LookupEntityCompositeFieldValues",
    "LookupEntityFieldValue",
    "LookupEntityQuery",
    "LookupEntityQueryBase",
    "LookupEntityQueryType",
    "LookupFieldArgumentValue",
]

ENDPOINT_METHOD = "GET"
ENDPOINT_PATH = "api/external/entity/lookup_entity"


# DO NOT MODIFY -- This file is generated by type_spec
class LookupEntityQueryType(StrEnum):
    FIELD_VALUE = "field_value"
    COMPOSITE_FIELD_VALUES = "composite_field_values"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.entity.lookup_entity.LookupEntityQueryBase",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class LookupEntityQueryBase:
    type: LookupEntityQueryType


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.entity.lookup_entity.LookupFieldArgumentValue",
    unconverted_values={"field_value"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class LookupFieldArgumentValue:
    field_key: identifier_t.IdentifierKey
    field_value: base_t.JsonValue
    value_resolution: field_values_t.ValueResolution = field_values_t.ValueResolution.DIRECT


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.entity.lookup_entity.LookupEntityFieldValue",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class LookupEntityFieldValue:
    type: typing.Literal[LookupEntityQueryType.FIELD_VALUE] = LookupEntityQueryType.FIELD_VALUE
    value: LookupFieldArgumentValue


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.entity.lookup_entity.LookupEntityCompositeFieldValues",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class LookupEntityCompositeFieldValues:
    type: typing.Literal[LookupEntityQueryType.COMPOSITE_FIELD_VALUES] = LookupEntityQueryType.COMPOSITE_FIELD_VALUES
    values: list[LookupFieldArgumentValue]


# DO NOT MODIFY -- This file is generated by type_spec
LookupEntityQuery = typing.Annotated[
    LookupEntityFieldValue | LookupEntityCompositeFieldValues,
    serial_union_annotation(
    named_type_path="sdk.api.entity.lookup_entity.LookupEntityQuery",
        discriminator="type",
        discriminator_map={
            "field_value": LookupEntityFieldValue,
            "composite_field_values": LookupEntityCompositeFieldValues,
        },
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.entity.lookup_entity.Arguments",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class Arguments:
    entity_type: entity_t.EntityType
    query: LookupEntityQuery


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.entity.lookup_entity.Data",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class Data(async_batch_t.AsyncBatchActionReturn):
    pass
# DO NOT MODIFY -- This file is generated by type_spec
