# DO NOT MODIFY -- This file is generated by type_spec
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from enum import StrEnum
import dataclasses
from pkgs.serialization import serial_class
from pkgs.serialization import serial_union_annotation
from pkgs.serialization import serial_alias_annotation
from ... import base_t

__all__: list[str] = [
    "Arguments",
    "Data",
    "ENDPOINT_METHOD",
    "ENDPOINT_PATH",
    "OrganizationParameter",
    "OrganizationParameterBase",
    "OrganizationParameterCategory",
    "OrganizationParameterConditionParameter",
    "OrganizationParameterRecipeInput",
    "OrganizationParameterType",
    "OutputOrganizationRequest",
    "OutputOrganizationRequestMaterialFamily",
    "OutputOrganizationRequestProject",
    "OutputOrganizationRequestScope",
    "OutputOrganizationRequestUser",
]

ENDPOINT_METHOD = "GET"
ENDPOINT_PATH = "api/external/outputs/get_output_organization"


# DO NOT MODIFY -- This file is generated by type_spec
class OutputOrganizationRequestScope(StrEnum):
    MATERIAL_FAMILY = "material_family"
    PROJECT = "project"
    USER = "user"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.outputs.get_output_organization.OutputOrganizationRequestMaterialFamily",
    parse_require={"scope"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class OutputOrganizationRequestMaterialFamily:
    scope: typing.Literal[OutputOrganizationRequestScope.MATERIAL_FAMILY] = OutputOrganizationRequestScope.MATERIAL_FAMILY
    material_family_id: base_t.ObjectId


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.outputs.get_output_organization.OutputOrganizationRequestProject",
    parse_require={"scope"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class OutputOrganizationRequestProject:
    scope: typing.Literal[OutputOrganizationRequestScope.PROJECT] = OutputOrganizationRequestScope.PROJECT
    project_id: base_t.ObjectId


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.outputs.get_output_organization.OutputOrganizationRequestUser",
    parse_require={"scope"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class OutputOrganizationRequestUser:
    scope: typing.Literal[OutputOrganizationRequestScope.USER] = OutputOrganizationRequestScope.USER
    material_family_id: base_t.ObjectId
    user_id: base_t.ObjectId
    project_id: base_t.ObjectId | None = None


# DO NOT MODIFY -- This file is generated by type_spec
OutputOrganizationRequest = typing.Annotated[
    OutputOrganizationRequestMaterialFamily | OutputOrganizationRequestProject | OutputOrganizationRequestUser,
    serial_alias_annotation(
    named_type_path="sdk.api.outputs.get_output_organization.OutputOrganizationRequest",
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.outputs.get_output_organization.Arguments",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class Arguments:
    request: OutputOrganizationRequest


# DO NOT MODIFY -- This file is generated by type_spec
class OrganizationParameterType(StrEnum):
    CATEGORY = "category"
    RECIPE_INPUT = "recipe_input"
    CONDITION_PARAMETER = "condition_parameter"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.outputs.get_output_organization.OrganizationParameterBase",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class OrganizationParameterBase:
    output_organization_parameter_id: base_t.ObjectId
    null_on_top: bool
    sort_asc: bool
    type: OrganizationParameterType


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.outputs.get_output_organization.OrganizationParameterCategory",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class OrganizationParameterCategory(OrganizationParameterBase):
    type: typing.Literal[OrganizationParameterType.CATEGORY] = OrganizationParameterType.CATEGORY


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.outputs.get_output_organization.OrganizationParameterRecipeInput",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class OrganizationParameterRecipeInput(OrganizationParameterBase):
    input_id: base_t.ObjectId
    type: typing.Literal[OrganizationParameterType.RECIPE_INPUT] = OrganizationParameterType.RECIPE_INPUT


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.outputs.get_output_organization.OrganizationParameterConditionParameter",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class OrganizationParameterConditionParameter(OrganizationParameterBase):
    condition_parameter_id: base_t.ObjectId
    type: typing.Literal[OrganizationParameterType.CONDITION_PARAMETER] = OrganizationParameterType.CONDITION_PARAMETER


# DO NOT MODIFY -- This file is generated by type_spec
OrganizationParameter = typing.Annotated[
    OrganizationParameterCategory | OrganizationParameterRecipeInput | OrganizationParameterConditionParameter,
    serial_union_annotation(
    named_type_path="sdk.api.outputs.get_output_organization.OrganizationParameter",
        discriminator="type",
        discriminator_map={
            "category": OrganizationParameterCategory,
            "recipe_input": OrganizationParameterRecipeInput,
            "condition_parameter": OrganizationParameterConditionParameter,
        },
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.outputs.get_output_organization.Data",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class Data:
    organization_id: base_t.ObjectId | None
    column_definitions: list[OrganizationParameter]
    table_definitions: list[OrganizationParameter]
# DO NOT MODIFY -- This file is generated by type_spec
