# DO NOT MODIFY -- This file is generated by type_spec
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from enum import StrEnum
import dataclasses
from pkgs.serialization import serial_class
from pkgs.serialization import serial_union_annotation
from ... import base_t
from ... import identifier_t
from ... import inputs_t
from ... import recipe_inputs_t
from ... import recipe_workflow_steps_t

__all__: list[str] = [
    "AnnotationEdit",
    "Arguments",
    "Data",
    "ENDPOINT_METHOD",
    "ENDPOINT_PATH",
    "MixStepMatchStrategy",
    "PlaceholderBase",
    "PlaceholderDisplayMode",
    "PlaceholderType",
    "RecipeInputEdit",
    "RecipeInputEditAddInput",
    "RecipeInputEditAddInstructions",
    "RecipeInputEditBase",
    "RecipeInputEditChangeBasisViewed",
    "RecipeInputEditClearInputs",
    "RecipeInputEditInputBase",
    "RecipeInputEditPlaceholder",
    "RecipeInputEditSetLot",
    "RecipeInputEditSetRole",
    "RecipeInputEditType",
    "RecipeInputEditUpdateAnnotations",
    "RecipeInputEditUpsertInput",
    "RecipeInputPlaceholder",
    "SubcategoryPlaceholder",
]

ENDPOINT_METHOD = "POST"
ENDPOINT_PATH = "api/external/recipes/edit_recipe_inputs"


# DO NOT MODIFY -- This file is generated by type_spec
class RecipeInputEditType(StrEnum):
    CLEAR_INPUTS = "clear_inputs"
    UPSERT_INPUT = "upsert_input"
    ADD_INPUT = "add_input"
    UPDATE_ANNOTATIONS = "update_annotations"
    SET_LOT = "set_lot"
    CHANGE_BASIS = "change_basis"
    ADD_INSTRUCTIONS = "add_instructions"
    SET_ROLE = "set_role"
    SET_PLACEHOLDER = "set_placeholder"


# DO NOT MODIFY -- This file is generated by type_spec
class MixStepMatchStrategy(StrEnum):
    FIRST = "first"
    LAST = "last"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.edit_recipe_inputs.RecipeInputEditBase",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RecipeInputEditBase:
    type: RecipeInputEditType


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.edit_recipe_inputs.RecipeInputEditClearInputs",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RecipeInputEditClearInputs(RecipeInputEditBase):
    type: typing.Literal[RecipeInputEditType.CLEAR_INPUTS] = RecipeInputEditType.CLEAR_INPUTS


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.edit_recipe_inputs.RecipeInputEditInputBase",
    to_string_values={"value_numeric"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RecipeInputEditInputBase(RecipeInputEditBase):
    ingredient_key: identifier_t.IdentifierKey
    quantity_basis: recipe_inputs_t.QuantityBasis | None = recipe_inputs_t.QuantityBasis.MASS
    input_value_type: recipe_inputs_t.InputValueType = recipe_inputs_t.InputValueType.VALUE
    value_numeric: Decimal | None = None
    value_str: str | None = None
    behavior: inputs_t.IngredientBehavior | None = None
    calculation_key: identifier_t.IdentifierKey | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.edit_recipe_inputs.RecipeInputEditChangeBasisViewed",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RecipeInputEditChangeBasisViewed(RecipeInputEditInputBase):
    type: typing.Literal[RecipeInputEditType.CHANGE_BASIS] = RecipeInputEditType.CHANGE_BASIS
    mix_step_match_strategy: MixStepMatchStrategy = MixStepMatchStrategy.FIRST


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.edit_recipe_inputs.RecipeInputEditUpsertInput",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RecipeInputEditUpsertInput(RecipeInputEditInputBase):
    type: typing.Literal[RecipeInputEditType.UPSERT_INPUT] = RecipeInputEditType.UPSERT_INPUT
    clear_first: bool
    mix_step_match_strategy: MixStepMatchStrategy = MixStepMatchStrategy.FIRST


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.edit_recipe_inputs.RecipeInputEditAddInput",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RecipeInputEditAddInput(RecipeInputEditInputBase):
    type: typing.Literal[RecipeInputEditType.ADD_INPUT] = RecipeInputEditType.ADD_INPUT


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.edit_recipe_inputs.RecipeInputEditSetLot",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RecipeInputEditSetLot(RecipeInputEditBase):
    type: typing.Literal[RecipeInputEditType.SET_LOT] = RecipeInputEditType.SET_LOT
    ingredient_key: identifier_t.IdentifierKey
    ingredient_lot_recipe_key: identifier_t.IdentifierKey
    mix_step_match_strategy: MixStepMatchStrategy = MixStepMatchStrategy.FIRST


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.edit_recipe_inputs.RecipeInputEditAddInstructions",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RecipeInputEditAddInstructions(RecipeInputEditBase):
    type: typing.Literal[RecipeInputEditType.ADD_INSTRUCTIONS] = RecipeInputEditType.ADD_INSTRUCTIONS
    instructions: str


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.edit_recipe_inputs.AnnotationEdit",
    to_string_values={"lower_value", "upper_value"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class AnnotationEdit:
    annotation_type_key: identifier_t.IdentifierKey
    lower_value: Decimal | None = None
    upper_value: Decimal | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.edit_recipe_inputs.RecipeInputEditUpdateAnnotations",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RecipeInputEditUpdateAnnotations(RecipeInputEditInputBase):
    type: typing.Literal[RecipeInputEditType.UPDATE_ANNOTATIONS] = RecipeInputEditType.UPDATE_ANNOTATIONS
    clear_first: bool
    annotations: list[AnnotationEdit]
    mix_step_match_strategy: MixStepMatchStrategy = MixStepMatchStrategy.FIRST


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.edit_recipe_inputs.RecipeInputEditSetRole",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RecipeInputEditSetRole(RecipeInputEditBase):
    type: typing.Literal[RecipeInputEditType.SET_ROLE] = RecipeInputEditType.SET_ROLE
    ingredient_key: identifier_t.IdentifierKey
    ingredient_role_key: identifier_t.IdentifierKey | None


# DO NOT MODIFY -- This file is generated by type_spec
class PlaceholderType(StrEnum):
    SUBCATEGORY = "subcategory"


# DO NOT MODIFY -- This file is generated by type_spec
class PlaceholderDisplayMode(StrEnum):
    INLINE = "inline"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.edit_recipe_inputs.PlaceholderBase",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class PlaceholderBase:
    type: PlaceholderType
    require_for_creation: bool = True
    display_mode: PlaceholderDisplayMode = PlaceholderDisplayMode.INLINE


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.edit_recipe_inputs.SubcategoryPlaceholder",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class SubcategoryPlaceholder(PlaceholderBase):
    type: typing.Literal[PlaceholderType.SUBCATEGORY] = PlaceholderType.SUBCATEGORY
    subcategory_identifier: identifier_t.IdentifierKey


# DO NOT MODIFY -- This file is generated by type_spec
RecipeInputPlaceholder = typing.Annotated[
    typing.Union[SubcategoryPlaceholder],
    serial_union_annotation(
    named_type_path="sdk.api.recipes.edit_recipe_inputs.RecipeInputPlaceholder",
        discriminator="type",
        discriminator_map={
            "subcategory": SubcategoryPlaceholder,
        },
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.edit_recipe_inputs.RecipeInputEditPlaceholder",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RecipeInputEditPlaceholder(RecipeInputEditBase):
    type: typing.Literal[RecipeInputEditType.SET_PLACEHOLDER] = RecipeInputEditType.SET_PLACEHOLDER
    ingredient_key: identifier_t.IdentifierKey
    placeholder: RecipeInputPlaceholder
    mix_step_match_strategy: MixStepMatchStrategy = MixStepMatchStrategy.FIRST


# DO NOT MODIFY -- This file is generated by type_spec
RecipeInputEdit = typing.Annotated[
    RecipeInputEditClearInputs | RecipeInputEditUpsertInput | RecipeInputEditAddInput | RecipeInputEditUpdateAnnotations | RecipeInputEditSetLot | RecipeInputEditChangeBasisViewed | RecipeInputEditAddInstructions | RecipeInputEditSetRole | RecipeInputEditPlaceholder,
    serial_union_annotation(
    named_type_path="sdk.api.recipes.edit_recipe_inputs.RecipeInputEdit",
        discriminator="type",
        discriminator_map={
            "clear_inputs": RecipeInputEditClearInputs,
            "upsert_input": RecipeInputEditUpsertInput,
            "add_input": RecipeInputEditAddInput,
            "update_annotations": RecipeInputEditUpdateAnnotations,
            "set_lot": RecipeInputEditSetLot,
            "change_basis": RecipeInputEditChangeBasisViewed,
            "add_instructions": RecipeInputEditAddInstructions,
            "set_role": RecipeInputEditSetRole,
            "set_placeholder": RecipeInputEditPlaceholder,
        },
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.edit_recipe_inputs.Arguments",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class Arguments:
    recipe_key: identifier_t.IdentifierKey
    recipe_workflow_step_identifier: recipe_workflow_steps_t.RecipeWorkflowStepIdentifier
    edits: list[RecipeInputEdit]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.edit_recipe_inputs.Data",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class Data:
    pass
# DO NOT MODIFY -- This file is generated by type_spec
