# DO NOT MODIFY -- This file is generated by type_spec
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from enum import StrEnum
import dataclasses
from pkgs.serialization import serial_class
from pkgs.serialization import serial_string_enum
from ... import base_t
from ... import experiment_groups_t
from ... import inputs_t
from ... import outputs_t
from ... import recipe_metadata_t
from ... import recipe_tags_t
from ... import workflows_t

__all__: list[str] = [
    "Arguments",
    "ConditionParameterValue",
    "Data",
    "ENDPOINT_METHOD",
    "ENDPOINT_PATH",
    "Recipe",
    "RecipeInput",
    "RecipeLockStatus",
    "RecipeOutput",
    "RecipeOutputInclusion",
    "RecipeStep",
    "RecipeStepGroup",
    "RecipeStepRelationship",
    "RecipeWorkflowStep",
    "SimpleOutputCondition",
]

ENDPOINT_METHOD = "GET"
ENDPOINT_PATH = "api/external/recipes/external_get_recipes_data"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.get_recipes_data.Arguments",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class Arguments:
    recipe_ids: list[base_t.ObjectId] | None = None
    project_id: base_t.ObjectId | None = None
    offset: int | None = None
    limit: int | None = None
    empty_output_behavior: RecipeOutputInclusion | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_string_enum(
    labels={
        "include_null": "Include Outputs without values",
        "exclude_null": "Exclude Outputs without values",
    },
)
class RecipeOutputInclusion(StrEnum):
    INCLUDE_NULL = "include_null"
    EXCLUDE_NULL = "exclude_null"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.get_recipes_data.RecipeOutput",
    unconverted_values={"quantity_json"},
    to_string_values={"quantity_dec"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RecipeOutput:
    id: base_t.ObjectId
    output_id: base_t.ObjectId
    replicate_num: int
    quantity_json: base_t.JsonValue
    curve_id: base_t.ObjectId | None
    output_condition_id: base_t.ObjectId | None
    quantity_dec: Decimal | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.get_recipes_data.ConditionParameterValue",
    unconverted_values={"quantity_json"},
    to_string_values={"quantity_dec"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class ConditionParameterValue:
    condition_parameter_id: base_t.ObjectId
    condition_parameter_name: str
    quantity_json: base_t.JsonValue
    quantity_dec: Decimal | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.get_recipes_data.SimpleOutputCondition",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class SimpleOutputCondition:
    output_condition_id: base_t.ObjectId
    condition_parameter_values: list[ConditionParameterValue]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.get_recipes_data.RecipeInput",
    unconverted_values={"actual_quantity_json", "quantity_json"},
    to_string_values={"actual_quantity_dec", "quantity_dec"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RecipeInput:
    id: base_t.ObjectId
    input_id: base_t.ObjectId
    input_lot_recipe_id: base_t.ObjectId | None
    recipe_step_id: base_t.ObjectId
    quantity_json: base_t.JsonValue
    curve_id: base_t.ObjectId | None
    actual_quantity_json: base_t.JsonValue
    behavior: str
    ingredient_role_id: base_t.ObjectId | None
    quantity_dec: Decimal | None = None
    actual_quantity_dec: Decimal | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.get_recipes_data.RecipeStep",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RecipeStep:
    name: str | None
    recipe_step_id: base_t.ObjectId
    recipe_step_number: int
    instructions: str | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.get_recipes_data.RecipeStepGroup",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RecipeStepGroup:
    name: str | None
    recipe_steps: list[RecipeStep]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.get_recipes_data.RecipeWorkflowStep",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RecipeWorkflowStep:
    recipe_workflow_step_name: str | None
    recipe_workflow_step_id: base_t.ObjectId
    workflow_step_id: base_t.ObjectId
    recipe_step_groups: list[RecipeStepGroup]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.get_recipes_data.RecipeStepRelationship",
    to_string_values={"actual_quantity_dec", "quantity_dec"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RecipeStepRelationship:
    step_relationship_id: base_t.ObjectId
    name: str | None
    source_recipe_workflow_step_id: base_t.ObjectId
    target_recipe_step_id: base_t.ObjectId
    quantity_dec: Decimal | None = None
    actual_quantity_dec: Decimal | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.get_recipes_data.RecipeLockStatus",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class RecipeLockStatus:
    has_locked_inputs: bool
    has_locked_outputs: bool


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.get_recipes_data.Recipe",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class Recipe:
    recipe_id: base_t.ObjectId
    create_datetime: str
    last_modified_datetime: str
    name: str
    notes: str | None
    workflow_id: base_t.ObjectId
    metadata: list[recipe_metadata_t.RecipeMetadata]
    inputs: list[RecipeInput]
    outputs: list[RecipeOutput]
    workflow_steps: list[RecipeWorkflowStep]
    tag_ids: list[base_t.ObjectId]
    experiment_group_ids: list[base_t.ObjectId]
    step_relationships: list[RecipeStepRelationship]
    recipe_lock_status: RecipeLockStatus
    creating_user_id: base_t.ObjectId | None = None
    barcode_value: str | None = None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.api.recipes.get_recipes_data.Data",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class Data:
    recipes: list[Recipe]
    workflows: list[workflows_t.SimpleWorkflow]
    metadata: list[recipe_metadata_t.SimpleRecipeMetadataField]
    inputs: list[inputs_t.SimpleInput]
    outputs: list[outputs_t.SimpleOutput]
    output_conditions: list[SimpleOutputCondition]
    recipe_tags: list[recipe_tags_t.SimpleRecipeTag]
    experiment_groups: list[experiment_groups_t.SimpleExperimentGroup]
# DO NOT MODIFY -- This file is generated by type_spec
