# DO NOT MODIFY -- This file is generated by type_spec
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
# ruff: noqa: PLR0904
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
import uncountable.types.api.equipment.associate_equipment_input as associate_equipment_input_t
import uncountable.types.api.recipes.associate_recipe_as_input as associate_recipe_as_input_t
import uncountable.types.api.recipes.associate_recipe_as_lot as associate_recipe_as_lot_t
from uncountable.types import async_batch_t
from uncountable.types import base_t
import uncountable.types.api.recipes.clear_recipe_outputs as clear_recipe_outputs_t
from uncountable.types import client_config_t
import uncountable.types.api.uploader.complete_async_parse as complete_async_parse_t
import uncountable.types.api.runsheet.complete_async_upload as complete_async_upload_t
import uncountable.types.api.recipes.create_mix_order as create_mix_order_t
import uncountable.types.api.entity.create_or_update_entity as create_or_update_entity_t
import uncountable.types.api.recipes.create_recipe as create_recipe_t
import uncountable.types.api.recipes.edit_recipe_inputs as edit_recipe_inputs_t
from uncountable.types import entity_t
from uncountable.types import field_values_t
from uncountable.types import generic_upload_t
import uncountable.types.api.entity.grant_entity_permissions as grant_entity_permissions_t
from uncountable.types import identifier_t
import uncountable.types.api.uploader.invoke_uploader as invoke_uploader_t
import uncountable.types.api.recipes.lock_recipes as lock_recipes_t
import uncountable.types.api.entity.lookup_entity as lookup_entity_t
from uncountable.types import notices_t
from uncountable.types import notifications_t
import uncountable.types.api.integrations.push_notification as push_notification_t
from uncountable.types import recipe_identifiers_t
from uncountable.types import recipe_metadata_t
from uncountable.types import recipe_workflow_steps_t
import uncountable.types.api.entity.set_entity_field_values as set_entity_field_values_t
import uncountable.types.api.recipes.set_recipe_metadata as set_recipe_metadata_t
import uncountable.types.api.entity.transition_entity_phase as transition_entity_phase_t
import uncountable.types.api.recipes.unlock_recipes as unlock_recipes_t
from uncountable.types import uploader_t
import uncountable.types.api.condition_parameters.upsert_condition_match as upsert_condition_match_t
import uuid
from abc import ABC, abstractmethod
from pkgs.serialization_util import serialize_for_api


class AsyncBatchProcessorBase(ABC):
    @abstractmethod
    def _enqueue(self, req: async_batch_t.AsyncBatchRequest) -> None:
        ...

    @abstractmethod
    def send(self) -> base_t.ObjectId:
        ...

    def associate_equipment_input(
        self,
        *,
        equipment_key: identifier_t.IdentifierKey,
        material_family_ids: list[base_t.ObjectId],
        depends_on: list[str] | None = None,
        _request_options: client_config_t.RequestOptions | None = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Create or return the input association for equipment

        :param equipment_key: Identifier of the equipment to associate
        :param material_family_ids: The list of material families to add the input to. This must be non-empty
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = associate_equipment_input_t.Arguments(
            equipment_key=equipment_key,
            material_family_ids=material_family_ids,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.ASSOCIATE_EQUIPMENT_INPUT,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def associate_recipe_as_input(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
        input_key: identifier_t.IdentifierKey | None = None,
        show_in_listings: bool | None = None,
        depends_on: list[str] | None = None,
        _request_options: client_config_t.RequestOptions | None = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Create or return the input association for a recipe

        :param recipe_key: Identifier for the recipe
        :param input_key: Identifier for an input to use for the association.  Optionally supplied.  If not supplied, one is created
        :param show_in_listings: After associating the input should it be present in listings
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = associate_recipe_as_input_t.Arguments(
            recipe_key=recipe_key,
            input_key=input_key,
            show_in_listings=show_in_listings,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.ASSOCIATE_RECIPE_AS_INPUT,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def associate_recipe_as_lot(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
        ingredient_key: identifier_t.IdentifierKey,
        depends_on: list[str] | None = None,
        _request_options: client_config_t.RequestOptions | None = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Create a new lot association for the provided recipe with the provided ingredient

        :param recipe_key: Identifier for the recipe
        :param ingredient_key: Identifier for the ingredient
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = associate_recipe_as_lot_t.Arguments(
            recipe_key=recipe_key,
            ingredient_key=ingredient_key,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.ASSOCIATE_RECIPE_AS_LOT,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def clear_recipe_outputs(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
        depends_on: list[str] | None = None,
        _request_options: client_config_t.RequestOptions | None = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Clears all output values & output metadata for a given recipe

        :param recipe_key: The identifier of the recipe
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = clear_recipe_outputs_t.Arguments(
            recipe_key=recipe_key,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.CLEAR_RECIPE_OUTPUTS,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def complete_async_parse(
        self,
        *,
        parsed_file_data: list[uploader_t.ParsedFileData],
        async_job_key: identifier_t.IdentifierKey,
        upload_destination: generic_upload_t.UploadDestinationRecipe,
        depends_on: list[str] | None = None,
        _request_options: client_config_t.RequestOptions | None = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Parses uploaded files asynchronously

        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = complete_async_parse_t.Arguments(
            parsed_file_data=parsed_file_data,
            async_job_key=async_job_key,
            upload_destination=upload_destination,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.COMPLETE_ASYNC_PARSE,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def complete_async_upload(
        self,
        *,
        async_job_id: base_t.ObjectId,
        file_id: base_t.ObjectId,
        depends_on: list[str] | None = None,
        _request_options: client_config_t.RequestOptions | None = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Processes an file id with a given async job id to be uploaded asynchronously

        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = complete_async_upload_t.Arguments(
            async_job_id=async_job_id,
            file_id=file_id,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.COMPLETE_ASYNC_UPLOAD,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def create_mix_order(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
        recipe_workflow_step_identifier: recipe_workflow_steps_t.RecipeWorkflowStepIdentifier,
        depends_on: list[str] | None = None,
        _request_options: client_config_t.RequestOptions | None = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Creates mix order on a recipe workflow step

        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = create_mix_order_t.Arguments(
            recipe_key=recipe_key,
            recipe_workflow_step_identifier=recipe_workflow_step_identifier,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.CREATE_MIX_ORDER,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def create_or_update_entity(
        self,
        *,
        entity_type: entity_t.EntityType,
        definition_key: identifier_t.IdentifierKey,
        field_values: list[field_values_t.FieldArgumentValue],
        entity_key: identifier_t.IdentifierKey | None = None,
        on_create_init_field_values: list[field_values_t.FieldArgumentValue] | None = None,
        depends_on: list[str] | None = None,
        _request_options: client_config_t.RequestOptions | None = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Creates or updates field values for an entity

        :param on_create_init_field_values: Field values set only when the entity is created (will be ignored if entity already exists)
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = create_or_update_entity_t.Arguments(
            entity_key=entity_key,
            entity_type=entity_type,
            definition_key=definition_key,
            field_values=field_values,
            on_create_init_field_values=on_create_init_field_values,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.CREATE_OR_UPDATE_ENTITY,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def create_recipe(
        self,
        *,
        material_family_id: base_t.ObjectId,
        workflow_id: base_t.ObjectId,
        name: str | None = None,
        project_id: base_t.ObjectId | None = None,
        workflow_variant_id: base_t.ObjectId | None = None,
        recipe_metadata: list[recipe_metadata_t.MetadataValue] | None = None,
        identifiers: recipe_identifiers_t.RecipeIdentifiers | None = None,
        definition_key: identifier_t.IdentifierKey | None = None,
        depends_on: list[str] | None = None,
        _request_options: client_config_t.RequestOptions | None = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Returns the id of the recipe being created.

        :param name: The name for the recipe
        :param material_family_id: The material family for the recipe
        :param project_id: The identifier of the project to create the recipe in
        :param workflow_id: The identifier of the workflow to create the recipe with
        :param workflow_variant_id: The identifier of the workflow variant to create the recipe with
        :param recipe_metadata: Metadata values to populate the recipe with
        :param identifiers: A recipe won't be created if it matches the identifier.  An identifier must be unique in the schema
        :param definition_key: The entity definition identifier, default is used if not supplied
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = create_recipe_t.Arguments(
            name=name,
            material_family_id=material_family_id,
            project_id=project_id,
            workflow_id=workflow_id,
            workflow_variant_id=workflow_variant_id,
            recipe_metadata=recipe_metadata,
            identifiers=identifiers,
            definition_key=definition_key,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.CREATE_RECIPE,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def edit_recipe_inputs(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
        recipe_workflow_step_identifier: recipe_workflow_steps_t.RecipeWorkflowStepIdentifier,
        edits: list[edit_recipe_inputs_t.RecipeInputEdit],
        depends_on: list[str] | None = None,
        _request_options: client_config_t.RequestOptions | None = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Clear, update, or add inputs on a recipe

        :param recipe_key: Identifier for the recipe
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = edit_recipe_inputs_t.Arguments(
            recipe_key=recipe_key,
            recipe_workflow_step_identifier=recipe_workflow_step_identifier,
            edits=edits,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.EDIT_RECIPE_INPUTS,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def grant_entity_permissions(
        self,
        *,
        entity_type: entity_t.LimitedEntityType,
        entity_key: identifier_t.IdentifierKey,
        permission_types: list[entity_t.GrantableEntityPermissionType],
        user_keys: list[identifier_t.IdentifierKey] | None = None,
        user_group_keys: list[identifier_t.IdentifierKey] | None = None,
        all_users: bool | None = None,
        depends_on: list[str] | None = None,
        _request_options: client_config_t.RequestOptions | None = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Grant entity permissions to a list of users or user groups or to all users.

        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = grant_entity_permissions_t.Arguments(
            entity_type=entity_type,
            entity_key=entity_key,
            permission_types=permission_types,
            user_keys=user_keys,
            user_group_keys=user_group_keys,
            all_users=all_users,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.GRANT_ENTITY_PERMISSIONS,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def invoke_uploader(
        self,
        *,
        uploader_key: identifier_t.IdentifierKey,
        destination: generic_upload_t.UploadDestination,
        file_id: base_t.ObjectId | None = None,
        file_ids: list[base_t.ObjectId] | None = None,
        depends_on: list[str] | None = None,
        _request_options: client_config_t.RequestOptions | None = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Runs a file through an uploader.

        :param file_id: DEPRECATED: use file_ids
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = invoke_uploader_t.Arguments(
            file_id=file_id,
            file_ids=file_ids,
            uploader_key=uploader_key,
            destination=destination,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.INVOKE_UPLOADER,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def lock_recipes(
        self,
        *,
        type: lock_recipes_t.RecipeLockType = lock_recipes_t.RecipeLockType.ALL,
        recipes: list[identifier_t.IdentifierKey],
        globally_removable: bool,
        lock_samples: bool | None = None,
        comments: str | None = None,
        depends_on: list[str] | None = None,
        _request_options: client_config_t.RequestOptions | None = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Lock experiments. Experiments will require unlocking to be editable. Edits to the experiments are blocked while they are locked.

        :param type: The type of lock to set.
    All = both inputs and measurements are locked.
    Inputs Only = only inputs are locked from editing.

        :param recipes: The recipes to lock, a maximum of 100 can be sent
        :param globally_removable: If true any user can unlock the experiment. If false the locking user is the only user that can unlock.
        :param lock_samples: Should associated experiment test samples also be locked.
        :param comments: Optional comment describing the purpose of locking
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = lock_recipes_t.Arguments(
            type=type,
            recipes=recipes,
            globally_removable=globally_removable,
            lock_samples=lock_samples,
            comments=comments,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.LOCK_RECIPES,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def lookup_entity(
        self,
        *,
        entity_type: entity_t.EntityType,
        query: lookup_entity_t.LookupEntityQuery,
        depends_on: list[str] | None = None,
        _request_options: client_config_t.RequestOptions | None = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Look up an entity based on an identifier or field values

        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = lookup_entity_t.Arguments(
            entity_type=entity_type,
            query=query,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.LOOKUP_ENTITY,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def push_notification(
        self,
        *,
        notification_targets: list[notifications_t.NotificationTarget],
        subject: str,
        message: str,
        display_notice: bool = False,
        entity: entity_t.EntityIdentifier | None = None,
        notice_configuration: notices_t.NotificationNoticeConfiguration | None = None,
        depends_on: list[str] | None = None,
        _request_options: client_config_t.RequestOptions | None = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Push a notification to a user or user group

        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = push_notification_t.Arguments(
            notification_targets=notification_targets,
            subject=subject,
            message=message,
            entity=entity,
            display_notice=display_notice,
            notice_configuration=notice_configuration,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.PUSH_NOTIFICATION,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def set_entity_field_values(
        self,
        *,
        entity_identifier: entity_t.EntityIdentifier,
        field_values: list[field_values_t.FieldArgumentValue],
        depends_on: list[str] | None = None,
        _request_options: client_config_t.RequestOptions | None = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Sets field values for an entity

        :param entity_identifier: Entity to update
        :param field_values: Field values to set
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = set_entity_field_values_t.Arguments(
            entity_identifier=entity_identifier,
            field_values=field_values,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.SET_ENTITY_FIELD_VALUES,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def set_recipe_metadata(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
        recipe_metadata: list[recipe_metadata_t.MetadataValue],
        depends_on: list[str] | None = None,
        _request_options: client_config_t.RequestOptions | None = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Set metadata values on a recipe

        :param recipe_key: Identifier for the recipe
        :param recipe_metadata: Metadata values to populate the recipe with
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = set_recipe_metadata_t.Arguments(
            recipe_key=recipe_key,
            recipe_metadata=recipe_metadata,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.SET_RECIPE_METADATA,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def transition_entity_phase(
        self,
        *,
        transition: transition_entity_phase_t.TransitionIdentifier,
        entity: entity_t.Entity | None = None,
        entity_identifier: entity_t.EntityIdentifier | None = None,
        depends_on: list[str] | None = None,
        _request_options: client_config_t.RequestOptions | None = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Transitions an entity from one phase to another

        :param entity: Entity to transition. If entity_identifier is provided, this should be omitted.
        :param entity_identifier: Identifier of the entity to transition. If entity is provided, this should be omitted.
        :param transition: Identifier of the transition to perform
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = transition_entity_phase_t.Arguments(
            entity=entity,
            entity_identifier=entity_identifier,
            transition=transition,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.TRANSITION_ENTITY_PHASE,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def unlock_recipes(
        self,
        *,
        type: unlock_recipes_t.RecipeUnlockType = unlock_recipes_t.RecipeUnlockType.STANDARD,
        recipes: list[identifier_t.IdentifierKey],
        unlock_samples: bool | None = None,
        depends_on: list[str] | None = None,
        _request_options: client_config_t.RequestOptions | None = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Unlock experiments. Experiments will edtiable after unlocking if they are currently locked.

        :param type: The method to unlock recipes. Default is standard.
        :param recipes: The recipes to unlock, a maximum of 100 can be sent
        :param unlock_samples: Should associated experiment test samples also be unlocked.
        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = unlock_recipes_t.Arguments(
            type=type,
            recipes=recipes,
            unlock_samples=unlock_samples,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.UNLOCK_RECIPES,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )

    def upsert_condition_match(
        self,
        *,
        explicit_name: bool = False,
        name: str | None = None,
        condition_parameters: list[upsert_condition_match_t.ConditionParameter] | None = None,
        output_conditions: list[identifier_t.IdentifierKey] | None = None,
        existing_condition_match: identifier_t.IdentifierKey | None = None,
        depends_on: list[str] | None = None,
        _request_options: client_config_t.RequestOptions | None = None,
    ) -> async_batch_t.QueuedAsyncBatchRequest:
        """Creates or updates condition match

        :param depends_on: A list of batch reference keys to process before processing this request
        """
        args = upsert_condition_match_t.Arguments(
            name=name,
            condition_parameters=condition_parameters,
            output_conditions=output_conditions,
            explicit_name=explicit_name,
            existing_condition_match=existing_condition_match,
        )
        json_data = serialize_for_api(args)

        batch_reference = str(uuid.uuid4())

        req = async_batch_t.AsyncBatchRequest(
            path=async_batch_t.AsyncBatchRequestPath.UPSERT_CONDITION_MATCH,
            data=json_data,
            depends_on=depends_on,
            batch_reference=batch_reference,
        )

        self._enqueue(req)

        return async_batch_t.QueuedAsyncBatchRequest(
            path=req.path,
            batch_reference=req.batch_reference,
        )
