# DO NOT MODIFY -- This file is generated by type_spec
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401

__all__: list[str] = [
    "JsonScalar",
    "JsonValue",
    "ObjectId",
]
# DO NOT MODIFY -- This file is generated by type_spec
# === START section from base.prepart.py ===
"""
    Types that type_spec will use in the emitted files.
"""
from typing import Union, Any, TYPE_CHECKING
from collections.abc import Mapping, Sequence

# These two are part of the core output, thus don't duplicate here
# from decimal import Decimal
# import datetime

# Decimal/datetime are included as this list includes JSON serializable objects
# It is preferred to use ExtJsonScalar and leave JsonScalar as deprecated, as
# a type that we intend on migrating.
JsonScalar = Union[str, float, bool, Decimal, None, datetime.datetime, datetime.date]
ExtJsonScalar = JsonScalar

# PureJsonScalar/PureJsonValue should be used in places where the type
# is expected to already serialized and not expecting any high-order types.
# this type is fully representable in the JSON format, and in JavaScript
PureJsonScalar = Union[str, float, bool, None]

# Regular expressions for identifying ref names and IDs. Ref names should be
# using this regular expression as a constriant in the database.
REF_NAME_REGEX = r"^[a-zA-Z0-9_/-]+$"
REF_NAME_STRICT_REGEX_STRING = "^[a-zA-Z_][a-zA-Z0-9_]*$"
REF_NAME_STRICT_REGEX = rf"{REF_NAME_STRICT_REGEX_STRING}"
# Ids matching a strict integer number are converted to integers
ID_REGEX = r"-?[1-9][0-9]{0,20}"


# ENABLE_SLOTS should be removed after slots have been tested locally
import os
ENABLE_SLOTS = os.environ.get("UNC_ENABLE_DATACLASS_SLOTS") == "true"

if TYPE_CHECKING:
    JsonValue = Union[JsonScalar, Mapping[str, "JsonValue"], Sequence["JsonValue"]]
    ExtJsonValue = JsonValue
    PureJsonValue = Union[
        PureJsonScalar,
        Mapping[str, "PureJsonValue"],
        Sequence["PureJsonValue"]
    ]
else:
    JsonValue = Union[JsonScalar, dict[str, Any], list[Any]]
    ExtJsonValue = JsonValue
    PureJsonValue = Union[PureJsonScalar, dict[str, Any], list[Any]]

ObjectId = int


def is_pure_json_value(value: ExtJsonValue) -> bool:
    """
    Checks if the runtime type of value is a PureJsonValue.
    """
    if value is None:
        return True
    if isinstance(value, (int, float, bool, str)):
        return True

    if isinstance(value, list):
        return all(is_pure_json_value(item) for item in value)

    if isinstance(value, dict):
        return all(
            is_pure_json_value(key) and is_pure_json_value(item)
            for key, item in value.items()
        )

    return False
# === END section from base.prepart.py ===
# DO NOT MODIFY -- This file is generated by type_spec
