# DO NOT MODIFY -- This file is generated by type_spec
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from enum import StrEnum
import dataclasses
from pkgs.serialization import serial_class
from pkgs.serialization import serial_union_annotation
from . import base_t
from . import identifier_t

__all__: list[str] = [
    "GenericRemoteDirectoryScope",
    "GenericUploadStrategy",
    "UploadDestination",
    "UploadDestinationBase",
    "UploadDestinationMaterialFamily",
    "UploadDestinationProject",
    "UploadDestinationRecipe",
    "UploadDestinationType",
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.generic_upload.GenericRemoteDirectoryScope",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class GenericRemoteDirectoryScope:
    src_path: str
    success_archive_path: str
    failure_archive_path: str
    recursive: bool
    prepend_date_on_archive: bool
    valid_file_extensions: list[str] | None = None
    filename_regex: str | None = None
    max_files: int | None = None
    detection_keyword: str | None = None
    delimiter: str | None = None


# DO NOT MODIFY -- This file is generated by type_spec
class UploadDestinationType(StrEnum):
    PROJECT = "project"
    MATERIAL_FAMILY = "material_family"
    RECIPE = "recipe"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.generic_upload.UploadDestinationBase",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class UploadDestinationBase:
    type: UploadDestinationType


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.generic_upload.UploadDestinationProject",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class UploadDestinationProject(UploadDestinationBase):
    type: typing.Literal[UploadDestinationType.PROJECT] = UploadDestinationType.PROJECT
    project_key: identifier_t.IdentifierKey


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.generic_upload.UploadDestinationMaterialFamily",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class UploadDestinationMaterialFamily(UploadDestinationBase):
    type: typing.Literal[UploadDestinationType.MATERIAL_FAMILY] = UploadDestinationType.MATERIAL_FAMILY
    material_family_key: identifier_t.IdentifierKey


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.generic_upload.UploadDestinationRecipe",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class UploadDestinationRecipe(UploadDestinationBase):
    type: typing.Literal[UploadDestinationType.RECIPE] = UploadDestinationType.RECIPE
    recipe_key: identifier_t.IdentifierKey


# DO NOT MODIFY -- This file is generated by type_spec
UploadDestination = typing.Annotated[
    UploadDestinationProject | UploadDestinationMaterialFamily | UploadDestinationRecipe,
    serial_union_annotation(
    named_type_path="sdk.generic_upload.UploadDestination",
        discriminator="type",
        discriminator_map={
            "project": UploadDestinationProject,
            "material_family": UploadDestinationMaterialFamily,
            "recipe": UploadDestinationRecipe,
        },
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.generic_upload.GenericUploadStrategy",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class GenericUploadStrategy:
    uploader_key: identifier_t.IdentifierKey
    destinations: list[UploadDestination]
    skip_moving_files: bool = False
# DO NOT MODIFY -- This file is generated by type_spec
