# DO NOT MODIFY -- This file is generated by type_spec
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from enum import StrEnum
import dataclasses
from pkgs.serialization import serial_class
from pkgs.serialization import serial_union_annotation
from pkgs.serialization import serial_alias_annotation
from . import base_t
from . import integration_session_t

__all__: list[str] = [
    "BaseSocketEventData",
    "JoinRoomWithTokenSocketClientMessage",
    "SendInstrumentReadingClientMessage",
    "SocketClientMessage",
    "SocketClientMessageType",
    "SocketEventData",
    "SocketEventType",
    "SocketRequestBase",
    "SocketRequestIntegrationSession",
    "SocketRequestType",
    "SocketResponse",
    "SocketTokenRequest",
    "SocketTokenResponse",
    "UsersInRoomUpdatedEventData",
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.sockets.SocketRequestBase",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class SocketRequestBase:
    type: SocketRequestType


# DO NOT MODIFY -- This file is generated by type_spec
class SocketRequestType(StrEnum):
    INTEGRATION_SESSION = "integration_session"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.sockets.SocketRequestIntegrationSession",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class SocketRequestIntegrationSession(SocketRequestBase):
    type: typing.Literal[SocketRequestType.INTEGRATION_SESSION] = SocketRequestType.INTEGRATION_SESSION
    integration_session: integration_session_t.IntegrationSession


# DO NOT MODIFY -- This file is generated by type_spec
SocketTokenRequest = typing.Annotated[
    typing.Union[SocketRequestIntegrationSession],
    serial_union_annotation(
    named_type_path="sdk.sockets.SocketTokenRequest",
        discriminator="type",
        discriminator_map={
            "integration_session": SocketRequestIntegrationSession,
        },
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.sockets.SocketTokenResponse",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class SocketTokenResponse:
    token: str
    room_key: str


# DO NOT MODIFY -- This file is generated by type_spec
class SocketEventType(StrEnum):
    USERS_IN_ROOM_UPDATED = "users_in_room_updated"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.sockets.BaseSocketEventData",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class BaseSocketEventData:
    pass


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.sockets.UsersInRoomUpdatedEventData",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class UsersInRoomUpdatedEventData(BaseSocketEventData):
    type: typing.Literal[SocketEventType.USERS_IN_ROOM_UPDATED] = SocketEventType.USERS_IN_ROOM_UPDATED
    user_ids: list[base_t.ObjectId]
    number_of_connections: int


# DO NOT MODIFY -- This file is generated by type_spec
SocketEventData = typing.Annotated[
    typing.Union[UsersInRoomUpdatedEventData],
    serial_alias_annotation(
    named_type_path="sdk.sockets.SocketEventData",
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.sockets.SocketResponse",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class SocketResponse:
    data: SocketEventData


# DO NOT MODIFY -- This file is generated by type_spec
class SocketClientMessageType(StrEnum):
    JOIN_ROOM_WITH_TOKEN = "join_room_with_token"
    SEND_INSTRUMENT_READING = "send_instrument_reading"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.sockets.JoinRoomWithTokenSocketClientMessage",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class JoinRoomWithTokenSocketClientMessage:
    type: typing.Literal[SocketClientMessageType.JOIN_ROOM_WITH_TOKEN] = SocketClientMessageType.JOIN_ROOM_WITH_TOKEN
    token: str


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.sockets.SendInstrumentReadingClientMessage",
    to_string_values={"value"},
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class SendInstrumentReadingClientMessage:
    type: typing.Literal[SocketClientMessageType.SEND_INSTRUMENT_READING] = SocketClientMessageType.SEND_INSTRUMENT_READING
    room_key: str
    value: Decimal


# DO NOT MODIFY -- This file is generated by type_spec
SocketClientMessage = typing.Annotated[
    JoinRoomWithTokenSocketClientMessage | SendInstrumentReadingClientMessage,
    serial_union_annotation(
    named_type_path="sdk.sockets.SocketClientMessage",
        discriminator="type",
        discriminator_map={
            "join_room_with_token": JoinRoomWithTokenSocketClientMessage,
            "send_instrument_reading": SendInstrumentReadingClientMessage,
        },
    ),
]
# DO NOT MODIFY -- This file is generated by type_spec
