# DO NOT MODIFY -- This file is generated by type_spec
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from enum import StrEnum
import dataclasses
from pkgs.serialization import serial_class
from pkgs.serialization import serial_union_annotation
from pkgs.serialization import serial_alias_annotation
from . import base_t
from . import listing_t

__all__: list[str] = [
    "FilterIdType",
    "FilterLess",
    "FilterNode",
    "FilterNodeBase",
    "FilterNodeColumnAnd",
    "FilterNodeType",
    "FilterRelation",
    "FilterScalarType",
    "FilterSpec",
    "FilterSpecBase",
    "FilterSpecEquals",
    "FilterSpecExists",
    "FilterSpecGeq",
    "FilterSpecGreater",
    "FilterSpecIStrContains",
    "FilterSpecIStrStartsWith",
    "FilterSpecInclude",
    "FilterSpecLeq",
    "StringFilterValue",
]


# DO NOT MODIFY -- This file is generated by type_spec
class FilterRelation(StrEnum):
    EQUALS = "equals"
    GREATER = "greater"
    GEQ = "geq"
    LESS = "less"
    LEQ = "leq"
    ISTR_CONTAINS = "istr_contains"
    ISTR_STARTS_WITH = "istr_starts_with"
    INCLUDE = "include"
    EXISTS = "exists"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.structured_filters.FilterSpecBase",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True, frozen=True, eq=True)  # type: ignore[literal-required]
class FilterSpecBase:
    relation: FilterRelation
    column: listing_t.ColumnIdentifier


# DO NOT MODIFY -- This file is generated by type_spec
FilterScalarType = typing.Annotated[
    str | int | Decimal,
    serial_alias_annotation(
    named_type_path="sdk.structured_filters.FilterScalarType",
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
FilterIdType = typing.Annotated[
    base_t.ObjectId | str,
    serial_alias_annotation(
    named_type_path="sdk.structured_filters.FilterIdType",
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
StringFilterValue = typing.Annotated[
    typing.Union[str],
    serial_alias_annotation(
    named_type_path="sdk.structured_filters.StringFilterValue",
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.structured_filters.FilterSpecEquals",
    parse_require={"relation"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True, frozen=True, eq=True)  # type: ignore[literal-required]
class FilterSpecEquals(FilterSpecBase):
    relation: typing.Literal[FilterRelation.EQUALS] = FilterRelation.EQUALS
    value: FilterScalarType


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.structured_filters.FilterSpecInclude",
    parse_require={"relation"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True, frozen=True, eq=True)  # type: ignore[literal-required]
class FilterSpecInclude(FilterSpecBase):
    relation: typing.Literal[FilterRelation.INCLUDE] = FilterRelation.INCLUDE
    value: FilterIdType | tuple[FilterIdType, ...]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.structured_filters.FilterSpecIStrContains",
    parse_require={"relation"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True, frozen=True, eq=True)  # type: ignore[literal-required]
class FilterSpecIStrContains(FilterSpecBase):
    relation: typing.Literal[FilterRelation.ISTR_CONTAINS] = FilterRelation.ISTR_CONTAINS
    value: str


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.structured_filters.FilterSpecIStrStartsWith",
    parse_require={"relation"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True, frozen=True, eq=True)  # type: ignore[literal-required]
class FilterSpecIStrStartsWith(FilterSpecBase):
    relation: typing.Literal[FilterRelation.ISTR_STARTS_WITH] = FilterRelation.ISTR_STARTS_WITH
    value: str


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.structured_filters.FilterSpecExists",
    parse_require={"relation"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True, frozen=True, eq=True)  # type: ignore[literal-required]
class FilterSpecExists(FilterSpecBase):
    relation: typing.Literal[FilterRelation.EXISTS] = FilterRelation.EXISTS


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.structured_filters.FilterSpecGreater",
    to_string_values={"value"},
    parse_require={"relation"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True, frozen=True, eq=True)  # type: ignore[literal-required]
class FilterSpecGreater(FilterSpecBase):
    relation: typing.Literal[FilterRelation.GREATER] = FilterRelation.GREATER
    value: Decimal


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.structured_filters.FilterLess",
    to_string_values={"value"},
    parse_require={"relation"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True, frozen=True, eq=True)  # type: ignore[literal-required]
class FilterLess(FilterSpecBase):
    relation: typing.Literal[FilterRelation.LESS] = FilterRelation.LESS
    value: Decimal


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.structured_filters.FilterSpecGeq",
    to_string_values={"value"},
    parse_require={"relation"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True, frozen=True, eq=True)  # type: ignore[literal-required]
class FilterSpecGeq(FilterSpecBase):
    relation: typing.Literal[FilterRelation.GEQ] = FilterRelation.GEQ
    value: Decimal


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.structured_filters.FilterSpecLeq",
    to_string_values={"value"},
    parse_require={"relation"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True, frozen=True, eq=True)  # type: ignore[literal-required]
class FilterSpecLeq(FilterSpecBase):
    relation: typing.Literal[FilterRelation.LEQ] = FilterRelation.LEQ
    value: Decimal


# DO NOT MODIFY -- This file is generated by type_spec
FilterSpec = typing.Annotated[
    FilterSpecEquals | FilterSpecGreater | FilterSpecGeq | FilterSpecLeq | FilterSpecIStrContains | FilterSpecIStrStartsWith | FilterSpecInclude | FilterSpecExists,
    serial_union_annotation(
    named_type_path="sdk.structured_filters.FilterSpec",
        discriminator="relation",
        discriminator_map={
            "equals": FilterSpecEquals,
            "greater": FilterSpecGreater,
            "geq": FilterSpecGeq,
            "leq": FilterSpecLeq,
            "istr_contains": FilterSpecIStrContains,
            "istr_starts_with": FilterSpecIStrStartsWith,
            "include": FilterSpecInclude,
            "exists": FilterSpecExists,
        },
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
class FilterNodeType(StrEnum):
    COLUMN_AND = "column_and"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.structured_filters.FilterNodeBase",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class FilterNodeBase:
    type: FilterNodeType


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.structured_filters.FilterNodeColumnAnd",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True, frozen=True, eq=True)  # type: ignore[literal-required]
class FilterNodeColumnAnd:
    type: typing.Literal[FilterNodeType.COLUMN_AND] = FilterNodeType.COLUMN_AND
    filters: tuple[FilterSpec, ...]


# DO NOT MODIFY -- This file is generated by type_spec
FilterNode = typing.Annotated[
    typing.Union[FilterNodeColumnAnd],
    serial_union_annotation(
    named_type_path="sdk.structured_filters.FilterNode",
        discriminator="type",
        discriminator_map={
            "column_and": FilterNodeColumnAnd,
        },
    ),
]
# DO NOT MODIFY -- This file is generated by type_spec
