# DO NOT MODIFY -- This file is generated by type_spec
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from enum import StrEnum
import dataclasses
from pkgs.serialization import serial_class
from pkgs.serialization import serial_union_annotation
from . import base_t

__all__: list[str] = [
    "BaseData",
    "Channel",
    "ChannelType",
    "DataChannel",
    "DecimalValue",
    "HeaderEntry",
    "HeaderType",
    "HeaderValue",
    "NumericChannelData",
    "NumericHeaderData",
    "ParsedFileData",
    "StringValue",
    "StructureElement",
    "StructureElementBase",
    "StructureElementType",
    "TextChannelData",
    "TextHeaderData",
    "TimestampChannelData",
]


# DO NOT MODIFY -- This file is generated by type_spec
class HeaderType(StrEnum):
    NUMERIC_HEADER = "numeric_header"
    TEXT_HEADER = "text_header"


# DO NOT MODIFY -- This file is generated by type_spec
class ChannelType(StrEnum):
    NUMERIC_CHANNEL = "numeric_channel"
    TIMESTAMP_CHANNEL = "timestamp_channel"
    TEXT_CHANNEL = "text_channel"


# DO NOT MODIFY -- This file is generated by type_spec
class StructureElementType(StrEnum):
    CHANNEL = "channel"
    HEADER = "header"


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.uploader.StructureElementBase",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class StructureElementBase:
    type: StructureElementType


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.uploader.DecimalValue",
    to_string_values={"value"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class DecimalValue:
    value: Decimal


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.uploader.StringValue",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class StringValue:
    value: str


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.uploader.BaseData",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class BaseData:
    name: str
    type: str


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.uploader.NumericHeaderData",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class NumericHeaderData(BaseData):
    type: typing.Literal[HeaderType.NUMERIC_HEADER] = HeaderType.NUMERIC_HEADER
    data: DecimalValue | None


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.uploader.TextHeaderData",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class TextHeaderData(BaseData):
    type: typing.Literal[HeaderType.TEXT_HEADER] = HeaderType.TEXT_HEADER
    data: StringValue | None


# DO NOT MODIFY -- This file is generated by type_spec
HeaderValue = typing.Annotated[
    NumericHeaderData | TextHeaderData,
    serial_union_annotation(
    named_type_path="sdk.uploader.HeaderValue",
        discriminator="type",
        discriminator_map={
            "numeric_header": NumericHeaderData,
            "text_header": TextHeaderData,
        },
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.uploader.NumericChannelData",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class NumericChannelData(BaseData):
    type: typing.Literal[ChannelType.NUMERIC_CHANNEL] = ChannelType.NUMERIC_CHANNEL
    data: list[DecimalValue]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.uploader.TimestampChannelData",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class TimestampChannelData(BaseData):
    type: typing.Literal[ChannelType.TIMESTAMP_CHANNEL] = ChannelType.TIMESTAMP_CHANNEL
    data: list[DecimalValue]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.uploader.TextChannelData",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class TextChannelData(BaseData):
    type: typing.Literal[ChannelType.TEXT_CHANNEL] = ChannelType.TEXT_CHANNEL
    data: list[StringValue]


# DO NOT MODIFY -- This file is generated by type_spec
Channel = typing.Annotated[
    TextChannelData | TimestampChannelData | NumericChannelData,
    serial_union_annotation(
    named_type_path="sdk.uploader.Channel",
        discriminator="type",
        discriminator_map={
            "text_channel": TextChannelData,
            "timestamp_channel": TimestampChannelData,
            "numeric_channel": NumericChannelData,
        },
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.uploader.DataChannel",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class DataChannel(StructureElementBase):
    type: typing.Literal[StructureElementType.CHANNEL] = StructureElementType.CHANNEL
    channel: Channel


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.uploader.HeaderEntry",
    parse_require={"type"},
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class HeaderEntry(StructureElementBase):
    type: typing.Literal[StructureElementType.HEADER] = StructureElementType.HEADER
    value: HeaderValue


# DO NOT MODIFY -- This file is generated by type_spec
StructureElement = typing.Annotated[
    DataChannel | HeaderEntry,
    serial_union_annotation(
    named_type_path="sdk.uploader.StructureElement",
        discriminator="type",
        discriminator_map={
            "channel": DataChannel,
            "header": HeaderEntry,
        },
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    named_type_path="sdk.uploader.ParsedFileData",
)
@dataclasses.dataclass(slots=base_t.ENABLE_SLOTS, kw_only=True)  # type: ignore[literal-required]
class ParsedFileData:
    file_name: str
    file_structures: list[StructureElement]
# DO NOT MODIFY -- This file is generated by type_spec
