# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Dict, List


class CreateFlowRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        name: str = None,
        description: str = None,
        start_schedule: int = None,
        end_schedule: int = None,
        cron_expression: str = None,
        create_cluster: bool = None,
        cluster_id: str = None,
        host_name: str = None,
        namespace: str = None,
        application: str = None,
        alert_conf: str = None,
        alert_user_group_biz_id: str = None,
        alert_ding_ding_group_biz_id: str = None,
        parent_flow_list: str = None,
        parent_category: str = None,
        client_token: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.name = name
        self.description = description
        self.start_schedule = start_schedule
        self.end_schedule = end_schedule
        self.cron_expression = cron_expression
        self.create_cluster = create_cluster
        self.cluster_id = cluster_id
        self.host_name = host_name
        self.namespace = namespace
        self.application = application
        self.alert_conf = alert_conf
        self.alert_user_group_biz_id = alert_user_group_biz_id
        self.alert_ding_ding_group_biz_id = alert_ding_ding_group_biz_id
        self.parent_flow_list = parent_flow_list
        self.parent_category = parent_category
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.start_schedule is not None:
            result['StartSchedule'] = self.start_schedule
        if self.end_schedule is not None:
            result['EndSchedule'] = self.end_schedule
        if self.cron_expression is not None:
            result['CronExpression'] = self.cron_expression
        if self.create_cluster is not None:
            result['CreateCluster'] = self.create_cluster
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.application is not None:
            result['Application'] = self.application
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        if self.alert_user_group_biz_id is not None:
            result['AlertUserGroupBizId'] = self.alert_user_group_biz_id
        if self.alert_ding_ding_group_biz_id is not None:
            result['AlertDingDingGroupBizId'] = self.alert_ding_ding_group_biz_id
        if self.parent_flow_list is not None:
            result['ParentFlowList'] = self.parent_flow_list
        if self.parent_category is not None:
            result['ParentCategory'] = self.parent_category
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('StartSchedule') is not None:
            self.start_schedule = m.get('StartSchedule')
        if m.get('EndSchedule') is not None:
            self.end_schedule = m.get('EndSchedule')
        if m.get('CronExpression') is not None:
            self.cron_expression = m.get('CronExpression')
        if m.get('CreateCluster') is not None:
            self.create_cluster = m.get('CreateCluster')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Application') is not None:
            self.application = m.get('Application')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        if m.get('AlertUserGroupBizId') is not None:
            self.alert_user_group_biz_id = m.get('AlertUserGroupBizId')
        if m.get('AlertDingDingGroupBizId') is not None:
            self.alert_ding_ding_group_biz_id = m.get('AlertDingDingGroupBizId')
        if m.get('ParentFlowList') is not None:
            self.parent_flow_list = m.get('ParentFlowList')
        if m.get('ParentCategory') is not None:
            self.parent_category = m.get('ParentCategory')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateFlowResponseBody(TeaModel):
    def __init__(
        self,
        id: str = None,
        request_id: str = None,
    ):
        self.id = id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateFlowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFlowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListUsersRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        type: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListUsersResponseBodyUserListUser(TeaModel):
    def __init__(
        self,
        linux_status: str = None,
        k_8s_status: str = None,
        knox_status: str = None,
        group_name: str = None,
        user_id: str = None,
        kerberos_status: str = None,
        user_name: str = None,
    ):
        self.linux_status = linux_status
        self.k_8s_status = k_8s_status
        self.knox_status = knox_status
        self.group_name = group_name
        self.user_id = user_id
        self.kerberos_status = kerberos_status
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.linux_status is not None:
            result['LinuxStatus'] = self.linux_status
        if self.k_8s_status is not None:
            result['K8sStatus'] = self.k_8s_status
        if self.knox_status is not None:
            result['KnoxStatus'] = self.knox_status
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.kerberos_status is not None:
            result['KerberosStatus'] = self.kerberos_status
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LinuxStatus') is not None:
            self.linux_status = m.get('LinuxStatus')
        if m.get('K8sStatus') is not None:
            self.k_8s_status = m.get('K8sStatus')
        if m.get('KnoxStatus') is not None:
            self.knox_status = m.get('KnoxStatus')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('KerberosStatus') is not None:
            self.kerberos_status = m.get('KerberosStatus')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class ListUsersResponseBodyUserList(TeaModel):
    def __init__(
        self,
        user: List[ListUsersResponseBodyUserListUser] = None,
    ):
        self.user = user

    def validate(self):
        if self.user:
            for k in self.user:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['User'] = []
        if self.user is not None:
            for k in self.user:
                result['User'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.user = []
        if m.get('User') is not None:
            for k in m.get('User'):
                temp_model = ListUsersResponseBodyUserListUser()
                self.user.append(temp_model.from_map(k))
        return self


class ListUsersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        user_list: ListUsersResponseBodyUserList = None,
    ):
        self.request_id = request_id
        self.user_list = user_list

    def validate(self):
        if self.user_list:
            self.user_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_list is not None:
            result['UserList'] = self.user_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserList') is not None:
            temp_model = ListUsersResponseBodyUserList()
            self.user_list = temp_model.from_map(m['UserList'])
        return self


class ListUsersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListUsersResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyFlowProjectRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        region_id: str = None,
        name: str = None,
        description: str = None,
    ):
        self.project_id = project_id
        self.region_id = region_id
        self.name = name
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class ModifyFlowProjectResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyFlowProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyFlowProjectResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyFlowProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryKnoxUserPasswordRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        user_id: str = None,
        owner_id: str = None,
        cluster_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.user_id = user_id
        self.owner_id = owner_id
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class QueryKnoxUserPasswordResponseBodyUserInfoListUserInfo(TeaModel):
    def __init__(
        self,
        password: str = None,
        user_name: str = None,
        user_id: str = None,
    ):
        self.password = password
        self.user_name = user_name
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.password is not None:
            result['Password'] = self.password
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class QueryKnoxUserPasswordResponseBodyUserInfoList(TeaModel):
    def __init__(
        self,
        user_info: List[QueryKnoxUserPasswordResponseBodyUserInfoListUserInfo] = None,
    ):
        self.user_info = user_info

    def validate(self):
        if self.user_info:
            for k in self.user_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['UserInfo'] = []
        if self.user_info is not None:
            for k in self.user_info:
                result['UserInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.user_info = []
        if m.get('UserInfo') is not None:
            for k in m.get('UserInfo'):
                temp_model = QueryKnoxUserPasswordResponseBodyUserInfoListUserInfo()
                self.user_info.append(temp_model.from_map(k))
        return self


class QueryKnoxUserPasswordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        user_info_list: QueryKnoxUserPasswordResponseBodyUserInfoList = None,
    ):
        self.request_id = request_id
        self.user_info_list = user_info_list

    def validate(self):
        if self.user_info_list:
            self.user_info_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_info_list is not None:
            result['UserInfoList'] = self.user_info_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserInfoList') is not None:
            temp_model = QueryKnoxUserPasswordResponseBodyUserInfoList()
            self.user_info_list = temp_model.from_map(m['UserInfoList'])
        return self


class QueryKnoxUserPasswordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: QueryKnoxUserPasswordResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryKnoxUserPasswordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowNodeInstanceLauncherLogRequest(TeaModel):
    def __init__(
        self,
        start: int = None,
        lines: int = None,
        offset: int = None,
        length: int = None,
        reverse: bool = None,
        start_time: int = None,
        end_time: int = None,
        node_instance_id: str = None,
        project_id: str = None,
        region_id: str = None,
    ):
        self.start = start
        self.lines = lines
        self.offset = offset
        self.length = length
        self.reverse = reverse
        self.start_time = start_time
        self.end_time = end_time
        self.node_instance_id = node_instance_id
        self.project_id = project_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.start is not None:
            result['Start'] = self.start
        if self.lines is not None:
            result['Lines'] = self.lines
        if self.offset is not None:
            result['Offset'] = self.offset
        if self.length is not None:
            result['Length'] = self.length
        if self.reverse is not None:
            result['Reverse'] = self.reverse
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.node_instance_id is not None:
            result['NodeInstanceId'] = self.node_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Start') is not None:
            self.start = m.get('Start')
        if m.get('Lines') is not None:
            self.lines = m.get('Lines')
        if m.get('Offset') is not None:
            self.offset = m.get('Offset')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('Reverse') is not None:
            self.reverse = m.get('Reverse')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('NodeInstanceId') is not None:
            self.node_instance_id = m.get('NodeInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowNodeInstanceLauncherLogResponseBodyLogEntrysLogEntry(TeaModel):
    def __init__(
        self,
        content: str = None,
    ):
        self.content = content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class DescribeFlowNodeInstanceLauncherLogResponseBodyLogEntrys(TeaModel):
    def __init__(
        self,
        log_entry: List[DescribeFlowNodeInstanceLauncherLogResponseBodyLogEntrysLogEntry] = None,
    ):
        self.log_entry = log_entry

    def validate(self):
        if self.log_entry:
            for k in self.log_entry:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LogEntry'] = []
        if self.log_entry is not None:
            for k in self.log_entry:
                result['LogEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.log_entry = []
        if m.get('LogEntry') is not None:
            for k in m.get('LogEntry'):
                temp_model = DescribeFlowNodeInstanceLauncherLogResponseBodyLogEntrysLogEntry()
                self.log_entry.append(temp_model.from_map(k))
        return self


class DescribeFlowNodeInstanceLauncherLogResponseBody(TeaModel):
    def __init__(
        self,
        log_end: bool = None,
        request_id: str = None,
        log_entrys: DescribeFlowNodeInstanceLauncherLogResponseBodyLogEntrys = None,
    ):
        self.log_end = log_end
        self.request_id = request_id
        self.log_entrys = log_entrys

    def validate(self):
        if self.log_entrys:
            self.log_entrys.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_end is not None:
            result['LogEnd'] = self.log_end
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.log_entrys is not None:
            result['LogEntrys'] = self.log_entrys.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LogEnd') is not None:
            self.log_end = m.get('LogEnd')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LogEntrys') is not None:
            temp_model = DescribeFlowNodeInstanceLauncherLogResponseBodyLogEntrys()
            self.log_entrys = temp_model.from_map(m['LogEntrys'])
        return self


class DescribeFlowNodeInstanceLauncherLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowNodeInstanceLauncherLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowNodeInstanceLauncherLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        job_id: str = None,
        name: str = None,
        id: str = None,
        cluster_id: str = None,
        status: str = None,
        periodic: bool = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.job_id = job_id
        self.name = name
        self.id = id
        self.cluster_id = cluster_id
        self.status = status
        self.periodic = periodic
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.status is not None:
            result['Status'] = self.status
        if self.periodic is not None:
            result['Periodic'] = self.periodic
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Periodic') is not None:
            self.periodic = m.get('Periodic')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListFlowResponseBodyFlowFlow(TeaModel):
    def __init__(
        self,
        status: str = None,
        type: str = None,
        alert_user_group_biz_id: str = None,
        periodic: bool = None,
        project_id: str = None,
        host_name: str = None,
        gmt_modified: int = None,
        description: str = None,
        create_cluster: bool = None,
        start_schedule: int = None,
        end_schedule: int = None,
        graph: str = None,
        alert_ding_ding_group_biz_id: str = None,
        gmt_create: int = None,
        category_id: str = None,
        cron_expr: str = None,
        name: str = None,
        id: str = None,
        alert_conf: str = None,
        cluster_id: str = None,
    ):
        self.status = status
        self.type = type
        self.alert_user_group_biz_id = alert_user_group_biz_id
        self.periodic = periodic
        self.project_id = project_id
        self.host_name = host_name
        self.gmt_modified = gmt_modified
        self.description = description
        self.create_cluster = create_cluster
        self.start_schedule = start_schedule
        self.end_schedule = end_schedule
        self.graph = graph
        self.alert_ding_ding_group_biz_id = alert_ding_ding_group_biz_id
        self.gmt_create = gmt_create
        self.category_id = category_id
        self.cron_expr = cron_expr
        self.name = name
        self.id = id
        self.alert_conf = alert_conf
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.alert_user_group_biz_id is not None:
            result['AlertUserGroupBizId'] = self.alert_user_group_biz_id
        if self.periodic is not None:
            result['Periodic'] = self.periodic
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.description is not None:
            result['Description'] = self.description
        if self.create_cluster is not None:
            result['CreateCluster'] = self.create_cluster
        if self.start_schedule is not None:
            result['StartSchedule'] = self.start_schedule
        if self.end_schedule is not None:
            result['EndSchedule'] = self.end_schedule
        if self.graph is not None:
            result['Graph'] = self.graph
        if self.alert_ding_ding_group_biz_id is not None:
            result['AlertDingDingGroupBizId'] = self.alert_ding_ding_group_biz_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.cron_expr is not None:
            result['CronExpr'] = self.cron_expr
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('AlertUserGroupBizId') is not None:
            self.alert_user_group_biz_id = m.get('AlertUserGroupBizId')
        if m.get('Periodic') is not None:
            self.periodic = m.get('Periodic')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('CreateCluster') is not None:
            self.create_cluster = m.get('CreateCluster')
        if m.get('StartSchedule') is not None:
            self.start_schedule = m.get('StartSchedule')
        if m.get('EndSchedule') is not None:
            self.end_schedule = m.get('EndSchedule')
        if m.get('Graph') is not None:
            self.graph = m.get('Graph')
        if m.get('AlertDingDingGroupBizId') is not None:
            self.alert_ding_ding_group_biz_id = m.get('AlertDingDingGroupBizId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('CronExpr') is not None:
            self.cron_expr = m.get('CronExpr')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class ListFlowResponseBodyFlow(TeaModel):
    def __init__(
        self,
        flow: List[ListFlowResponseBodyFlowFlow] = None,
    ):
        self.flow = flow

    def validate(self):
        if self.flow:
            for k in self.flow:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Flow'] = []
        if self.flow is not None:
            for k in self.flow:
                result['Flow'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.flow = []
        if m.get('Flow') is not None:
            for k in m.get('Flow'):
                temp_model = ListFlowResponseBodyFlowFlow()
                self.flow.append(temp_model.from_map(k))
        return self


class ListFlowResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_number: int = None,
        page_size: int = None,
        total: int = None,
        flow: ListFlowResponseBodyFlow = None,
    ):
        self.request_id = request_id
        self.page_number = page_number
        self.page_size = page_size
        self.total = total
        self.flow = flow

    def validate(self):
        if self.flow:
            self.flow.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        if self.flow is not None:
            result['Flow'] = self.flow.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Flow') is not None:
            temp_model = ListFlowResponseBodyFlow()
            self.flow = temp_model.from_map(m['Flow'])
        return self


class ListFlowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListFlowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UntagResourcesRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        resource_type: str = None,
        resource_ids: List[str] = None,
        tag_keys: List[str] = None,
        all: bool = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        # 资源类型
        self.resource_type = resource_type
        # 集群ID列表
        self.resource_ids = resource_ids
        # 解绑的标签键列表
        self.tag_keys = tag_keys
        # 是否解绑资源的所有标签
        self.all = all

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_ids is not None:
            result['ResourceIds'] = self.resource_ids
        if self.tag_keys is not None:
            result['TagKeys'] = self.tag_keys
        if self.all is not None:
            result['All'] = self.all
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceIds') is not None:
            self.resource_ids = m.get('ResourceIds')
        if m.get('TagKeys') is not None:
            self.tag_keys = m.get('TagKeys')
        if m.get('All') is not None:
            self.all = m.get('All')
        return self


class UntagResourcesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_code: str = None,
        message: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 请求是否成功被处理
        self.success = success
        # 响应码
        self.code = code
        # 错误码
        self.error_code = error_code
        # 响应消息
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class UntagResourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UntagResourcesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UntagResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowClusterHostRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        cluster_id: str = None,
        resource_group_id: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.cluster_id = cluster_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class ListFlowClusterHostResponseBodyHostListHost(TeaModel):
    def __init__(
        self,
        status: str = None,
        type: str = None,
        serial_number: str = None,
        private_ip: str = None,
        host_name: str = None,
        instance_type: str = None,
        host_id: str = None,
        host_instance_id: str = None,
        cpu: int = None,
        public_ip: str = None,
        memory: int = None,
        role: str = None,
    ):
        self.status = status
        self.type = type
        self.serial_number = serial_number
        self.private_ip = private_ip
        self.host_name = host_name
        self.instance_type = instance_type
        self.host_id = host_id
        self.host_instance_id = host_instance_id
        self.cpu = cpu
        self.public_ip = public_ip
        self.memory = memory
        self.role = role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.private_ip is not None:
            result['PrivateIp'] = self.private_ip
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.host_id is not None:
            result['HostId'] = self.host_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.public_ip is not None:
            result['PublicIp'] = self.public_ip
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.role is not None:
            result['Role'] = self.role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('PrivateIp') is not None:
            self.private_ip = m.get('PrivateIp')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('PublicIp') is not None:
            self.public_ip = m.get('PublicIp')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        return self


class ListFlowClusterHostResponseBodyHostList(TeaModel):
    def __init__(
        self,
        host: List[ListFlowClusterHostResponseBodyHostListHost] = None,
    ):
        self.host = host

    def validate(self):
        if self.host:
            for k in self.host:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Host'] = []
        if self.host is not None:
            for k in self.host:
                result['Host'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.host = []
        if m.get('Host') is not None:
            for k in m.get('Host'):
                temp_model = ListFlowClusterHostResponseBodyHostListHost()
                self.host.append(temp_model.from_map(k))
        return self


class ListFlowClusterHostResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        host_list: ListFlowClusterHostResponseBodyHostList = None,
    ):
        self.request_id = request_id
        self.host_list = host_list

    def validate(self):
        if self.host_list:
            self.host_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.host_list is not None:
            result['HostList'] = self.host_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HostList') is not None:
            temp_model = ListFlowClusterHostResponseBodyHostList()
            self.host_list = temp_model.from_map(m['HostList'])
        return self


class ListFlowClusterHostResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListFlowClusterHostResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowClusterHostResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterOperationRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        service_name: str = None,
        status: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.service_name = service_name
        self.status = status
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.status is not None:
            result['Status'] = self.status
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListClusterOperationResponseBodyClusterOperationListClusterOperation(TeaModel):
    def __init__(
        self,
        status: str = None,
        start_time: str = None,
        comment: str = None,
        operation_name: str = None,
        operation_id: str = None,
        duration: str = None,
        percentage: str = None,
    ):
        self.status = status
        self.start_time = start_time
        self.comment = comment
        self.operation_name = operation_name
        self.operation_id = operation_id
        self.duration = duration
        self.percentage = percentage

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.operation_name is not None:
            result['OperationName'] = self.operation_name
        if self.operation_id is not None:
            result['OperationId'] = self.operation_id
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.percentage is not None:
            result['Percentage'] = self.percentage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('OperationName') is not None:
            self.operation_name = m.get('OperationName')
        if m.get('OperationId') is not None:
            self.operation_id = m.get('OperationId')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Percentage') is not None:
            self.percentage = m.get('Percentage')
        return self


class ListClusterOperationResponseBodyClusterOperationList(TeaModel):
    def __init__(
        self,
        cluster_operation: List[ListClusterOperationResponseBodyClusterOperationListClusterOperation] = None,
    ):
        self.cluster_operation = cluster_operation

    def validate(self):
        if self.cluster_operation:
            for k in self.cluster_operation:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterOperation'] = []
        if self.cluster_operation is not None:
            for k in self.cluster_operation:
                result['ClusterOperation'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_operation = []
        if m.get('ClusterOperation') is not None:
            for k in m.get('ClusterOperation'):
                temp_model = ListClusterOperationResponseBodyClusterOperationListClusterOperation()
                self.cluster_operation.append(temp_model.from_map(k))
        return self


class ListClusterOperationResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        total_count: int = None,
        cluster_operation_list: ListClusterOperationResponseBodyClusterOperationList = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.total_count = total_count
        self.cluster_operation_list = cluster_operation_list

    def validate(self):
        if self.cluster_operation_list:
            self.cluster_operation_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.cluster_operation_list is not None:
            result['ClusterOperationList'] = self.cluster_operation_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('ClusterOperationList') is not None:
            temp_model = ListClusterOperationResponseBodyClusterOperationList()
            self.cluster_operation_list = temp_model.from_map(m['ClusterOperationList'])
        return self


class ListClusterOperationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterOperationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterOperationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowEntitySnapshotRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        limit: int = None,
        page_number: int = None,
        page_size: int = None,
        current_size: int = None,
        page_count: int = None,
        order_field: str = None,
        order_mode: str = None,
        committer_id: str = None,
        entity_type: str = None,
        entity_group_id: str = None,
        entity_id: str = None,
        revision: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.limit = limit
        self.page_number = page_number
        self.page_size = page_size
        self.current_size = current_size
        self.page_count = page_count
        self.order_field = order_field
        self.order_mode = order_mode
        self.committer_id = committer_id
        self.entity_type = entity_type
        self.entity_group_id = entity_group_id
        self.entity_id = entity_id
        self.revision = revision

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_size is not None:
            result['CurrentSize'] = self.current_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.order_field is not None:
            result['OrderField'] = self.order_field
        if self.order_mode is not None:
            result['OrderMode'] = self.order_mode
        if self.committer_id is not None:
            result['CommitterId'] = self.committer_id
        if self.entity_type is not None:
            result['EntityType'] = self.entity_type
        if self.entity_group_id is not None:
            result['EntityGroupId'] = self.entity_group_id
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.revision is not None:
            result['Revision'] = self.revision
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentSize') is not None:
            self.current_size = m.get('CurrentSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('OrderField') is not None:
            self.order_field = m.get('OrderField')
        if m.get('OrderMode') is not None:
            self.order_mode = m.get('OrderMode')
        if m.get('CommitterId') is not None:
            self.committer_id = m.get('CommitterId')
        if m.get('EntityType') is not None:
            self.entity_type = m.get('EntityType')
        if m.get('EntityGroupId') is not None:
            self.entity_group_id = m.get('EntityGroupId')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('Revision') is not None:
            self.revision = m.get('Revision')
        return self


class ListFlowEntitySnapshotResponseBodyItemsItem(TeaModel):
    def __init__(
        self,
        active: bool = None,
        data: str = None,
        entity_id: str = None,
        entity_type: str = None,
        user_id: str = None,
        gmt_create: int = None,
        message: str = None,
        entity_group_id: str = None,
        committer_id: str = None,
        revision: str = None,
    ):
        self.active = active
        self.data = data
        self.entity_id = entity_id
        self.entity_type = entity_type
        self.user_id = user_id
        self.gmt_create = gmt_create
        self.message = message
        self.entity_group_id = entity_group_id
        self.committer_id = committer_id
        self.revision = revision

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.data is not None:
            result['Data'] = self.data
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.entity_type is not None:
            result['EntityType'] = self.entity_type
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.message is not None:
            result['Message'] = self.message
        if self.entity_group_id is not None:
            result['EntityGroupId'] = self.entity_group_id
        if self.committer_id is not None:
            result['CommitterId'] = self.committer_id
        if self.revision is not None:
            result['Revision'] = self.revision
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('EntityType') is not None:
            self.entity_type = m.get('EntityType')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('EntityGroupId') is not None:
            self.entity_group_id = m.get('EntityGroupId')
        if m.get('CommitterId') is not None:
            self.committer_id = m.get('CommitterId')
        if m.get('Revision') is not None:
            self.revision = m.get('Revision')
        return self


class ListFlowEntitySnapshotResponseBodyItems(TeaModel):
    def __init__(
        self,
        item: List[ListFlowEntitySnapshotResponseBodyItemsItem] = None,
    ):
        self.item = item

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = ListFlowEntitySnapshotResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class ListFlowEntitySnapshotResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        items: ListFlowEntitySnapshotResponseBodyItems = None,
    ):
        self.request_id = request_id
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Items') is not None:
            temp_model = ListFlowEntitySnapshotResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class ListFlowEntitySnapshotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListFlowEntitySnapshotResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowEntitySnapshotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteClusterTemplateRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        biz_id: str = None,
        resource_group_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.biz_id = biz_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DeleteClusterTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteClusterTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteClusterTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteClusterTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOrderRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class CancelOrderResponseBody(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        request_id: str = None,
    ):
        self.cluster_id = cluster_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['clusterId'] = self.cluster_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterId') is not None:
            self.cluster_id = m.get('clusterId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CancelOrderResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloneFlowJobRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        id: str = None,
        name: str = None,
        region_id: str = None,
    ):
        self.project_id = project_id
        self.id = id
        self.name = name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CloneFlowJobResponseBody(TeaModel):
    def __init__(
        self,
        id: str = None,
        request_id: str = None,
    ):
        self.id = id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CloneFlowJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CloneFlowJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CloneFlowJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartFlowRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        flow_instance_id: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.flow_instance_id = flow_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.flow_instance_id is not None:
            result['FlowInstanceId'] = self.flow_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FlowInstanceId') is not None:
            self.flow_instance_id = m.get('FlowInstanceId')
        return self


class StartFlowResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class StartFlowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: StartFlowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = StartFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowJobRequestResourceList(TeaModel):
    def __init__(
        self,
        path: str = None,
        alias: str = None,
    ):
        self.path = path
        self.alias = alias

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.alias is not None:
            result['Alias'] = self.alias
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        return self


class CreateFlowJobRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        name: str = None,
        description: str = None,
        type: str = None,
        fail_act: str = None,
        retry_policy: str = None,
        params: str = None,
        param_conf: str = None,
        custom_variables: str = None,
        env_conf: str = None,
        run_conf: str = None,
        monitor_conf: str = None,
        mode: str = None,
        parent_category: str = None,
        adhoc: bool = None,
        cluster_id: str = None,
        alert_conf: str = None,
        client_token: str = None,
        resource_list: List[CreateFlowJobRequestResourceList] = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.name = name
        self.description = description
        self.type = type
        self.fail_act = fail_act
        self.retry_policy = retry_policy
        self.params = params
        self.param_conf = param_conf
        self.custom_variables = custom_variables
        self.env_conf = env_conf
        self.run_conf = run_conf
        self.monitor_conf = monitor_conf
        self.mode = mode
        self.parent_category = parent_category
        self.adhoc = adhoc
        self.cluster_id = cluster_id
        self.alert_conf = alert_conf
        self.client_token = client_token
        self.resource_list = resource_list

    def validate(self):
        if self.resource_list:
            for k in self.resource_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        if self.fail_act is not None:
            result['FailAct'] = self.fail_act
        if self.retry_policy is not None:
            result['RetryPolicy'] = self.retry_policy
        if self.params is not None:
            result['Params'] = self.params
        if self.param_conf is not None:
            result['ParamConf'] = self.param_conf
        if self.custom_variables is not None:
            result['CustomVariables'] = self.custom_variables
        if self.env_conf is not None:
            result['EnvConf'] = self.env_conf
        if self.run_conf is not None:
            result['RunConf'] = self.run_conf
        if self.monitor_conf is not None:
            result['MonitorConf'] = self.monitor_conf
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.parent_category is not None:
            result['ParentCategory'] = self.parent_category
        if self.adhoc is not None:
            result['Adhoc'] = self.adhoc
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        result['ResourceList'] = []
        if self.resource_list is not None:
            for k in self.resource_list:
                result['ResourceList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('FailAct') is not None:
            self.fail_act = m.get('FailAct')
        if m.get('RetryPolicy') is not None:
            self.retry_policy = m.get('RetryPolicy')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('ParamConf') is not None:
            self.param_conf = m.get('ParamConf')
        if m.get('CustomVariables') is not None:
            self.custom_variables = m.get('CustomVariables')
        if m.get('EnvConf') is not None:
            self.env_conf = m.get('EnvConf')
        if m.get('RunConf') is not None:
            self.run_conf = m.get('RunConf')
        if m.get('MonitorConf') is not None:
            self.monitor_conf = m.get('MonitorConf')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('ParentCategory') is not None:
            self.parent_category = m.get('ParentCategory')
        if m.get('Adhoc') is not None:
            self.adhoc = m.get('Adhoc')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        self.resource_list = []
        if m.get('ResourceList') is not None:
            for k in m.get('ResourceList'):
                temp_model = CreateFlowJobRequestResourceList()
                self.resource_list.append(temp_model.from_map(k))
        return self


class CreateFlowJobResponseBody(TeaModel):
    def __init__(
        self,
        id: str = None,
        request_id: str = None,
    ):
        self.id = id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateFlowJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFlowJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowCategoryRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        region_id: str = None,
        project_id: str = None,
    ):
        self.id = id
        self.region_id = region_id
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteFlowCategoryResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteFlowCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteFlowCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFlowCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowEditLockRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        entity_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.entity_id = entity_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        return self


class DeleteFlowEditLockResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteFlowEditLockResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteFlowEditLockResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFlowEditLockResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ResizeClusterRequestHostComponentInfo(TeaModel):
    def __init__(
        self,
        component_name_list: List[str] = None,
        host_name: str = None,
        service_name: str = None,
    ):
        self.component_name_list = component_name_list
        self.host_name = host_name
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_name_list is not None:
            result['ComponentNameList'] = self.component_name_list
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComponentNameList') is not None:
            self.component_name_list = m.get('ComponentNameList')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class ResizeClusterRequestHostGroup(TeaModel):
    def __init__(
        self,
        sys_disk_capacity: int = None,
        host_group_type: str = None,
        comment: str = None,
        vswitch_id: int = None,
        sys_disk_type: str = None,
        auto_renew: bool = None,
        charge_type: str = None,
        disk_type: str = None,
        host_group_id: str = None,
        instance_type: str = None,
        host_key_pair_name: str = None,
        disk_count: int = None,
        create_type: str = None,
        period: int = None,
        host_password: str = None,
        disk_capacity: int = None,
        node_count: int = None,
        host_group_name: str = None,
        cluster_id: str = None,
    ):
        self.sys_disk_capacity = sys_disk_capacity
        self.host_group_type = host_group_type
        self.comment = comment
        self.vswitch_id = vswitch_id
        self.sys_disk_type = sys_disk_type
        self.auto_renew = auto_renew
        self.charge_type = charge_type
        self.disk_type = disk_type
        self.host_group_id = host_group_id
        self.instance_type = instance_type
        self.host_key_pair_name = host_key_pair_name
        self.disk_count = disk_count
        self.create_type = create_type
        self.period = period
        self.host_password = host_password
        self.disk_capacity = disk_capacity
        self.node_count = node_count
        self.host_group_name = host_group_name
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sys_disk_capacity is not None:
            result['SysDiskCapacity'] = self.sys_disk_capacity
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        if self.sys_disk_type is not None:
            result['SysDiskType'] = self.sys_disk_type
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.host_key_pair_name is not None:
            result['HostKeyPairName'] = self.host_key_pair_name
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        if self.create_type is not None:
            result['CreateType'] = self.create_type
        if self.period is not None:
            result['Period'] = self.period
        if self.host_password is not None:
            result['HostPassword'] = self.host_password
        if self.disk_capacity is not None:
            result['DiskCapacity'] = self.disk_capacity
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SysDiskCapacity') is not None:
            self.sys_disk_capacity = m.get('SysDiskCapacity')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        if m.get('SysDiskType') is not None:
            self.sys_disk_type = m.get('SysDiskType')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('HostKeyPairName') is not None:
            self.host_key_pair_name = m.get('HostKeyPairName')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        if m.get('CreateType') is not None:
            self.create_type = m.get('CreateType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('HostPassword') is not None:
            self.host_password = m.get('HostPassword')
        if m.get('DiskCapacity') is not None:
            self.disk_capacity = m.get('DiskCapacity')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class ResizeClusterRequestPromotionInfo(TeaModel):
    def __init__(
        self,
        promotion_option_no: str = None,
        promotion_option_code: str = None,
        product_code: str = None,
    ):
        self.promotion_option_no = promotion_option_no
        self.promotion_option_code = promotion_option_code
        self.product_code = product_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.promotion_option_no is not None:
            result['PromotionOptionNo'] = self.promotion_option_no
        if self.promotion_option_code is not None:
            result['PromotionOptionCode'] = self.promotion_option_code
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PromotionOptionNo') is not None:
            self.promotion_option_no = m.get('PromotionOptionNo')
        if m.get('PromotionOptionCode') is not None:
            self.promotion_option_code = m.get('PromotionOptionCode')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        return self


class ResizeClusterRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        cluster_id: str = None,
        auto_pay_order: bool = None,
        vswitch_id: str = None,
        is_open_public_ip: bool = None,
        host_component_info: List[ResizeClusterRequestHostComponentInfo] = None,
        host_group: List[ResizeClusterRequestHostGroup] = None,
        promotion_info: List[ResizeClusterRequestPromotionInfo] = None,
    ):
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.auto_pay_order = auto_pay_order
        self.vswitch_id = vswitch_id
        self.is_open_public_ip = is_open_public_ip
        self.host_component_info = host_component_info
        self.host_group = host_group
        self.promotion_info = promotion_info

    def validate(self):
        if self.host_component_info:
            for k in self.host_component_info:
                if k:
                    k.validate()
        if self.host_group:
            for k in self.host_group:
                if k:
                    k.validate()
        if self.promotion_info:
            for k in self.promotion_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.auto_pay_order is not None:
            result['AutoPayOrder'] = self.auto_pay_order
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        if self.is_open_public_ip is not None:
            result['IsOpenPublicIp'] = self.is_open_public_ip
        result['HostComponentInfo'] = []
        if self.host_component_info is not None:
            for k in self.host_component_info:
                result['HostComponentInfo'].append(k.to_map() if k else None)
        result['HostGroup'] = []
        if self.host_group is not None:
            for k in self.host_group:
                result['HostGroup'].append(k.to_map() if k else None)
        result['PromotionInfo'] = []
        if self.promotion_info is not None:
            for k in self.promotion_info:
                result['PromotionInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('AutoPayOrder') is not None:
            self.auto_pay_order = m.get('AutoPayOrder')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        if m.get('IsOpenPublicIp') is not None:
            self.is_open_public_ip = m.get('IsOpenPublicIp')
        self.host_component_info = []
        if m.get('HostComponentInfo') is not None:
            for k in m.get('HostComponentInfo'):
                temp_model = ResizeClusterRequestHostComponentInfo()
                self.host_component_info.append(temp_model.from_map(k))
        self.host_group = []
        if m.get('HostGroup') is not None:
            for k in m.get('HostGroup'):
                temp_model = ResizeClusterRequestHostGroup()
                self.host_group.append(temp_model.from_map(k))
        self.promotion_info = []
        if m.get('PromotionInfo') is not None:
            for k in m.get('PromotionInfo'):
                temp_model = ResizeClusterRequestPromotionInfo()
                self.promotion_info.append(temp_model.from_map(k))
        return self


class ResizeClusterResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        cluster_id: str = None,
    ):
        self.request_id = request_id
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class ResizeClusterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ResizeClusterResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ResizeClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeMetaTablePreviewTaskRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        task_id: str = None,
        resource_group_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.task_id = task_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DescribeMetaTablePreviewTaskResponseBodyDataRowsRowColumns(TeaModel):
    def __init__(
        self,
        column: List[str] = None,
    ):
        self.column = column

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.column is not None:
            result['Column'] = self.column
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Column') is not None:
            self.column = m.get('Column')
        return self


class DescribeMetaTablePreviewTaskResponseBodyDataRowsRow(TeaModel):
    def __init__(
        self,
        columns: DescribeMetaTablePreviewTaskResponseBodyDataRowsRowColumns = None,
    ):
        self.columns = columns

    def validate(self):
        if self.columns:
            self.columns.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.columns is not None:
            result['Columns'] = self.columns.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Columns') is not None:
            temp_model = DescribeMetaTablePreviewTaskResponseBodyDataRowsRowColumns()
            self.columns = temp_model.from_map(m['Columns'])
        return self


class DescribeMetaTablePreviewTaskResponseBodyDataRows(TeaModel):
    def __init__(
        self,
        row: List[DescribeMetaTablePreviewTaskResponseBodyDataRowsRow] = None,
    ):
        self.row = row

    def validate(self):
        if self.row:
            for k in self.row:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Row'] = []
        if self.row is not None:
            for k in self.row:
                result['Row'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.row = []
        if m.get('Row') is not None:
            for k in m.get('Row'):
                temp_model = DescribeMetaTablePreviewTaskResponseBodyDataRowsRow()
                self.row.append(temp_model.from_map(k))
        return self


class DescribeMetaTablePreviewTaskResponseBodyDataHeaders(TeaModel):
    def __init__(
        self,
        header: List[str] = None,
    ):
        self.header = header

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.header is not None:
            result['Header'] = self.header
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Header') is not None:
            self.header = m.get('Header')
        return self


class DescribeMetaTablePreviewTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        rows: DescribeMetaTablePreviewTaskResponseBodyDataRows = None,
        headers: DescribeMetaTablePreviewTaskResponseBodyDataHeaders = None,
    ):
        self.rows = rows
        self.headers = headers

    def validate(self):
        if self.rows:
            self.rows.validate()
        if self.headers:
            self.headers.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rows is not None:
            result['Rows'] = self.rows.to_map()
        if self.headers is not None:
            result['Headers'] = self.headers.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Rows') is not None:
            temp_model = DescribeMetaTablePreviewTaskResponseBodyDataRows()
            self.rows = temp_model.from_map(m['Rows'])
        if m.get('Headers') is not None:
            temp_model = DescribeMetaTablePreviewTaskResponseBodyDataHeaders()
            self.headers = temp_model.from_map(m['Headers'])
        return self


class DescribeMetaTablePreviewTaskResponseBody(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        start_time: int = None,
        request_id: str = None,
        task_status: str = None,
        task_process: int = None,
        execute_time: int = None,
        task_id: str = None,
        data: DescribeMetaTablePreviewTaskResponseBodyData = None,
    ):
        self.end_time = end_time
        self.start_time = start_time
        self.request_id = request_id
        self.task_status = task_status
        self.task_process = task_process
        self.execute_time = execute_time
        self.task_id = task_id
        self.data = data

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.task_process is not None:
            result['TaskProcess'] = self.task_process
        if self.execute_time is not None:
            result['ExecuteTime'] = self.execute_time
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TaskProcess') is not None:
            self.task_process = m.get('TaskProcess')
        if m.get('ExecuteTime') is not None:
            self.execute_time = m.get('ExecuteTime')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Data') is not None:
            temp_model = DescribeMetaTablePreviewTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class DescribeMetaTablePreviewTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeMetaTablePreviewTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeMetaTablePreviewTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterServiceConfigHistoryRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        service_name: str = None,
        config_version: str = None,
        host_group_id: str = None,
        host_instance_id: str = None,
        config_file_name: str = None,
        config_item_key: str = None,
        author: str = None,
        comment: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.service_name = service_name
        self.config_version = config_version
        self.host_group_id = host_group_id
        self.host_instance_id = host_instance_id
        self.config_file_name = config_file_name
        self.config_item_key = config_item_key
        self.author = author
        self.comment = comment
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_version is not None:
            result['ConfigVersion'] = self.config_version
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.config_file_name is not None:
            result['ConfigFileName'] = self.config_file_name
        if self.config_item_key is not None:
            result['ConfigItemKey'] = self.config_item_key
        if self.author is not None:
            result['Author'] = self.author
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigVersion') is not None:
            self.config_version = m.get('ConfigVersion')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('ConfigFileName') is not None:
            self.config_file_name = m.get('ConfigFileName')
        if m.get('ConfigItemKey') is not None:
            self.config_item_key = m.get('ConfigItemKey')
        if m.get('Author') is not None:
            self.author = m.get('Author')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListClusterServiceConfigHistoryResponseBodyConfigHistoryListConfigHistory(TeaModel):
    def __init__(
        self,
        old_value: str = None,
        comment: str = None,
        create_time: int = None,
        host_name: str = None,
        author: str = None,
        config_item_name: str = None,
        host_group_id: str = None,
        new_value: str = None,
        host_instance_id: str = None,
        config_file_name: str = None,
        applied: bool = None,
        config_version: str = None,
        service_name: str = None,
        host_group_name: str = None,
    ):
        self.old_value = old_value
        self.comment = comment
        self.create_time = create_time
        self.host_name = host_name
        self.author = author
        self.config_item_name = config_item_name
        self.host_group_id = host_group_id
        self.new_value = new_value
        self.host_instance_id = host_instance_id
        self.config_file_name = config_file_name
        self.applied = applied
        self.config_version = config_version
        self.service_name = service_name
        self.host_group_name = host_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.old_value is not None:
            result['OldValue'] = self.old_value
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.author is not None:
            result['Author'] = self.author
        if self.config_item_name is not None:
            result['ConfigItemName'] = self.config_item_name
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.new_value is not None:
            result['NewValue'] = self.new_value
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.config_file_name is not None:
            result['ConfigFileName'] = self.config_file_name
        if self.applied is not None:
            result['Applied'] = self.applied
        if self.config_version is not None:
            result['ConfigVersion'] = self.config_version
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OldValue') is not None:
            self.old_value = m.get('OldValue')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Author') is not None:
            self.author = m.get('Author')
        if m.get('ConfigItemName') is not None:
            self.config_item_name = m.get('ConfigItemName')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('NewValue') is not None:
            self.new_value = m.get('NewValue')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('ConfigFileName') is not None:
            self.config_file_name = m.get('ConfigFileName')
        if m.get('Applied') is not None:
            self.applied = m.get('Applied')
        if m.get('ConfigVersion') is not None:
            self.config_version = m.get('ConfigVersion')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        return self


class ListClusterServiceConfigHistoryResponseBodyConfigHistoryList(TeaModel):
    def __init__(
        self,
        config_history: List[ListClusterServiceConfigHistoryResponseBodyConfigHistoryListConfigHistory] = None,
    ):
        self.config_history = config_history

    def validate(self):
        if self.config_history:
            for k in self.config_history:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigHistory'] = []
        if self.config_history is not None:
            for k in self.config_history:
                result['ConfigHistory'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config_history = []
        if m.get('ConfigHistory') is not None:
            for k in m.get('ConfigHistory'):
                temp_model = ListClusterServiceConfigHistoryResponseBodyConfigHistoryListConfigHistory()
                self.config_history.append(temp_model.from_map(k))
        return self


class ListClusterServiceConfigHistoryResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        total_count: int = None,
        config_history_list: ListClusterServiceConfigHistoryResponseBodyConfigHistoryList = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.total_count = total_count
        self.config_history_list = config_history_list

    def validate(self):
        if self.config_history_list:
            self.config_history_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.config_history_list is not None:
            result['ConfigHistoryList'] = self.config_history_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('ConfigHistoryList') is not None:
            temp_model = ListClusterServiceConfigHistoryResponseBodyConfigHistoryList()
            self.config_history_list = temp_model.from_map(m['ConfigHistoryList'])
        return self


class ListClusterServiceConfigHistoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterServiceConfigHistoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterServiceConfigHistoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyScalingConfigItemRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        config_item_information: str = None,
        config_item_type: str = None,
        config_item_biz_id: str = None,
        scaling_group_biz_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.config_item_information = config_item_information
        self.config_item_type = config_item_type
        self.config_item_biz_id = config_item_biz_id
        self.scaling_group_biz_id = scaling_group_biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['resourceGroupId'] = self.resource_group_id
        if self.config_item_information is not None:
            result['ConfigItemInformation'] = self.config_item_information
        if self.config_item_type is not None:
            result['ConfigItemType'] = self.config_item_type
        if self.config_item_biz_id is not None:
            result['ConfigItemBizId'] = self.config_item_biz_id
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('resourceGroupId') is not None:
            self.resource_group_id = m.get('resourceGroupId')
        if m.get('ConfigItemInformation') is not None:
            self.config_item_information = m.get('ConfigItemInformation')
        if m.get('ConfigItemType') is not None:
            self.config_item_type = m.get('ConfigItemType')
        if m.get('ConfigItemBizId') is not None:
            self.config_item_biz_id = m.get('ConfigItemBizId')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        return self


class ModifyScalingConfigItemResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: bool = None,
    ):
        # requestId
        self.request_id = request_id
        # data
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class ModifyScalingConfigItemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyScalingConfigItemResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyScalingConfigItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowClusterAllRequest(TeaModel):
    def __init__(
        self,
        product_type: str = None,
        region_id: str = None,
        resource_group_id: str = None,
    ):
        self.product_type = product_type
        self.region_id = region_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class ListFlowClusterAllResponseBodyClustersClusterInfoOrderTaskInfo(TeaModel):
    def __init__(
        self,
        target_count: int = None,
        current_count: int = None,
        order_id_list: str = None,
    ):
        self.target_count = target_count
        self.current_count = current_count
        self.order_id_list = order_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_count is not None:
            result['TargetCount'] = self.target_count
        if self.current_count is not None:
            result['CurrentCount'] = self.current_count
        if self.order_id_list is not None:
            result['OrderIdList'] = self.order_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TargetCount') is not None:
            self.target_count = m.get('TargetCount')
        if m.get('CurrentCount') is not None:
            self.current_count = m.get('CurrentCount')
        if m.get('OrderIdList') is not None:
            self.order_id_list = m.get('OrderIdList')
        return self


class ListFlowClusterAllResponseBodyClustersClusterInfoFailReason(TeaModel):
    def __init__(
        self,
        error_msg: str = None,
        request_id: str = None,
        error_code: str = None,
    ):
        self.error_msg = error_msg
        self.request_id = request_id
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_msg is not None:
            result['ErrorMsg'] = self.error_msg
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMsg') is not None:
            self.error_msg = m.get('ErrorMsg')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class ListFlowClusterAllResponseBodyClustersClusterInfo(TeaModel):
    def __init__(
        self,
        type: str = None,
        status: str = None,
        running_time: int = None,
        order_list: str = None,
        create_time: int = None,
        charge_type: str = None,
        period: int = None,
        k_8s_cluster_id: str = None,
        expired_time: int = None,
        has_uncompleted_order: bool = None,
        name: str = None,
        id: str = None,
        create_resource: str = None,
        order_task_info: ListFlowClusterAllResponseBodyClustersClusterInfoOrderTaskInfo = None,
        fail_reason: ListFlowClusterAllResponseBodyClustersClusterInfoFailReason = None,
    ):
        self.type = type
        self.status = status
        self.running_time = running_time
        self.order_list = order_list
        self.create_time = create_time
        self.charge_type = charge_type
        self.period = period
        self.k_8s_cluster_id = k_8s_cluster_id
        self.expired_time = expired_time
        self.has_uncompleted_order = has_uncompleted_order
        self.name = name
        self.id = id
        self.create_resource = create_resource
        self.order_task_info = order_task_info
        self.fail_reason = fail_reason

    def validate(self):
        if self.order_task_info:
            self.order_task_info.validate()
        if self.fail_reason:
            self.fail_reason.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.status is not None:
            result['Status'] = self.status
        if self.running_time is not None:
            result['RunningTime'] = self.running_time
        if self.order_list is not None:
            result['OrderList'] = self.order_list
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.period is not None:
            result['Period'] = self.period
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.has_uncompleted_order is not None:
            result['HasUncompletedOrder'] = self.has_uncompleted_order
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        if self.create_resource is not None:
            result['CreateResource'] = self.create_resource
        if self.order_task_info is not None:
            result['OrderTaskInfo'] = self.order_task_info.to_map()
        if self.fail_reason is not None:
            result['FailReason'] = self.fail_reason.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('RunningTime') is not None:
            self.running_time = m.get('RunningTime')
        if m.get('OrderList') is not None:
            self.order_list = m.get('OrderList')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('HasUncompletedOrder') is not None:
            self.has_uncompleted_order = m.get('HasUncompletedOrder')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('CreateResource') is not None:
            self.create_resource = m.get('CreateResource')
        if m.get('OrderTaskInfo') is not None:
            temp_model = ListFlowClusterAllResponseBodyClustersClusterInfoOrderTaskInfo()
            self.order_task_info = temp_model.from_map(m['OrderTaskInfo'])
        if m.get('FailReason') is not None:
            temp_model = ListFlowClusterAllResponseBodyClustersClusterInfoFailReason()
            self.fail_reason = temp_model.from_map(m['FailReason'])
        return self


class ListFlowClusterAllResponseBodyClusters(TeaModel):
    def __init__(
        self,
        cluster_info: List[ListFlowClusterAllResponseBodyClustersClusterInfo] = None,
    ):
        self.cluster_info = cluster_info

    def validate(self):
        if self.cluster_info:
            for k in self.cluster_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterInfo'] = []
        if self.cluster_info is not None:
            for k in self.cluster_info:
                result['ClusterInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_info = []
        if m.get('ClusterInfo') is not None:
            for k in m.get('ClusterInfo'):
                temp_model = ListFlowClusterAllResponseBodyClustersClusterInfo()
                self.cluster_info.append(temp_model.from_map(k))
        return self


class ListFlowClusterAllResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        total_count: int = None,
        clusters: ListFlowClusterAllResponseBodyClusters = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.total_count = total_count
        self.clusters = clusters

    def validate(self):
        if self.clusters:
            self.clusters.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.clusters is not None:
            result['Clusters'] = self.clusters.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Clusters') is not None:
            temp_model = ListFlowClusterAllResponseBodyClusters()
            self.clusters = temp_model.from_map(m['Clusters'])
        return self


class ListFlowClusterAllResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListFlowClusterAllResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowClusterAllResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScalingGroupRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        scaling_group_biz_id: str = None,
        host_group_biz_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.scaling_group_biz_id = scaling_group_biz_id
        self.host_group_biz_id = host_group_biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.host_group_biz_id is not None:
            result['HostGroupBizId'] = self.host_group_biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('HostGroupBizId') is not None:
            self.host_group_biz_id = m.get('HostGroupBizId')
        return self


class DescribeScalingGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        scaling_group_id: str = None,
        name: str = None,
        description: str = None,
        active_status: str = None,
        host_group_biz_id: str = None,
        scaling_in_mode: str = None,
        scaling_min_size: int = None,
        scaling_max_size: int = None,
        config_state: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        self.scaling_group_id = scaling_group_id
        self.name = name
        self.description = description
        self.active_status = active_status
        self.host_group_biz_id = host_group_biz_id
        self.scaling_in_mode = scaling_in_mode
        self.scaling_min_size = scaling_min_size
        self.scaling_max_size = scaling_max_size
        self.config_state = config_state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.active_status is not None:
            result['ActiveStatus'] = self.active_status
        if self.host_group_biz_id is not None:
            result['HostGroupBizId'] = self.host_group_biz_id
        if self.scaling_in_mode is not None:
            result['ScalingInMode'] = self.scaling_in_mode
        if self.scaling_min_size is not None:
            result['ScalingMinSize'] = self.scaling_min_size
        if self.scaling_max_size is not None:
            result['ScalingMaxSize'] = self.scaling_max_size
        if self.config_state is not None:
            result['ConfigState'] = self.config_state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ActiveStatus') is not None:
            self.active_status = m.get('ActiveStatus')
        if m.get('HostGroupBizId') is not None:
            self.host_group_biz_id = m.get('HostGroupBizId')
        if m.get('ScalingInMode') is not None:
            self.scaling_in_mode = m.get('ScalingInMode')
        if m.get('ScalingMinSize') is not None:
            self.scaling_min_size = m.get('ScalingMinSize')
        if m.get('ScalingMaxSize') is not None:
            self.scaling_max_size = m.get('ScalingMaxSize')
        if m.get('ConfigState') is not None:
            self.config_state = m.get('ConfigState')
        return self


class DescribeScalingGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeScalingGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeScalingGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListScalingGroupRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        limit: int = None,
        page_number: int = None,
        page_size: int = None,
        current_size: int = None,
        page_count: int = None,
        order_field: str = None,
        order_mode: str = None,
        cluster_biz_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.limit = limit
        self.page_number = page_number
        self.page_size = page_size
        self.current_size = current_size
        self.page_count = page_count
        self.order_field = order_field
        self.order_mode = order_mode
        self.cluster_biz_id = cluster_biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.limit is not None:
            result['limit'] = self.limit
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_size is not None:
            result['CurrentSize'] = self.current_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.order_field is not None:
            result['OrderField'] = self.order_field
        if self.order_mode is not None:
            result['OrderMode'] = self.order_mode
        if self.cluster_biz_id is not None:
            result['ClusterBizId'] = self.cluster_biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('limit') is not None:
            self.limit = m.get('limit')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentSize') is not None:
            self.current_size = m.get('CurrentSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('OrderField') is not None:
            self.order_field = m.get('OrderField')
        if m.get('OrderMode') is not None:
            self.order_mode = m.get('OrderMode')
        if m.get('ClusterBizId') is not None:
            self.cluster_biz_id = m.get('ClusterBizId')
        return self


class ListScalingGroupResponseBodyItemsItem(TeaModel):
    def __init__(
        self,
        scaling_group_id: str = None,
        name: str = None,
        description: str = None,
        active_status: str = None,
        host_group_biz_id: str = None,
        scaling_in_mode: str = None,
        scaling_min_size: str = None,
        scaling_max_size: str = None,
    ):
        self.scaling_group_id = scaling_group_id
        self.name = name
        self.description = description
        self.active_status = active_status
        self.host_group_biz_id = host_group_biz_id
        self.scaling_in_mode = scaling_in_mode
        self.scaling_min_size = scaling_min_size
        self.scaling_max_size = scaling_max_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.active_status is not None:
            result['ActiveStatus'] = self.active_status
        if self.host_group_biz_id is not None:
            result['HostGroupBizId'] = self.host_group_biz_id
        if self.scaling_in_mode is not None:
            result['ScalingInMode'] = self.scaling_in_mode
        if self.scaling_min_size is not None:
            result['ScalingMinSize'] = self.scaling_min_size
        if self.scaling_max_size is not None:
            result['ScalingMaxSize'] = self.scaling_max_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ActiveStatus') is not None:
            self.active_status = m.get('ActiveStatus')
        if m.get('HostGroupBizId') is not None:
            self.host_group_biz_id = m.get('HostGroupBizId')
        if m.get('ScalingInMode') is not None:
            self.scaling_in_mode = m.get('ScalingInMode')
        if m.get('ScalingMinSize') is not None:
            self.scaling_min_size = m.get('ScalingMinSize')
        if m.get('ScalingMaxSize') is not None:
            self.scaling_max_size = m.get('ScalingMaxSize')
        return self


class ListScalingGroupResponseBodyItems(TeaModel):
    def __init__(
        self,
        item: List[ListScalingGroupResponseBodyItemsItem] = None,
    ):
        self.item = item

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = ListScalingGroupResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class ListScalingGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        next_token: str = None,
        items: ListScalingGroupResponseBodyItems = None,
    ):
        # Id of the request
        self.request_id = request_id
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.next_token = next_token
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Items') is not None:
            temp_model = ListScalingGroupResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class ListScalingGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListScalingGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListScalingGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyFlowCategoryRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        region_id: str = None,
        id: str = None,
        name: str = None,
        parent_id: str = None,
    ):
        self.project_id = project_id
        self.region_id = region_id
        self.id = id
        self.name = name
        self.parent_id = parent_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        return self


class ModifyFlowCategoryResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyFlowCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyFlowCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyFlowCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyClusterServiceConfigRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        service_name: str = None,
        comment: str = None,
        config_params: str = None,
        custom_config_params: str = None,
        group_id: str = None,
        host_instance_id: str = None,
        config_type: str = None,
        refresh_host_config: bool = None,
        gateway_cluster_id_list: List[str] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.service_name = service_name
        self.comment = comment
        self.config_params = config_params
        self.custom_config_params = custom_config_params
        self.group_id = group_id
        self.host_instance_id = host_instance_id
        self.config_type = config_type
        self.refresh_host_config = refresh_host_config
        self.gateway_cluster_id_list = gateway_cluster_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.config_params is not None:
            result['ConfigParams'] = self.config_params
        if self.custom_config_params is not None:
            result['CustomConfigParams'] = self.custom_config_params
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.config_type is not None:
            result['ConfigType'] = self.config_type
        if self.refresh_host_config is not None:
            result['RefreshHostConfig'] = self.refresh_host_config
        if self.gateway_cluster_id_list is not None:
            result['GatewayClusterIdList'] = self.gateway_cluster_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('ConfigParams') is not None:
            self.config_params = m.get('ConfigParams')
        if m.get('CustomConfigParams') is not None:
            self.custom_config_params = m.get('CustomConfigParams')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('ConfigType') is not None:
            self.config_type = m.get('ConfigType')
        if m.get('RefreshHostConfig') is not None:
            self.refresh_host_config = m.get('RefreshHostConfig')
        if m.get('GatewayClusterIdList') is not None:
            self.gateway_cluster_id_list = m.get('GatewayClusterIdList')
        return self


class ModifyClusterServiceConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyClusterServiceConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyClusterServiceConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyClusterServiceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloneFlowRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        id: str = None,
        region_id: str = None,
    ):
        self.project_id = project_id
        self.id = id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CloneFlowResponseBody(TeaModel):
    def __init__(
        self,
        id: str = None,
        request_id: str = None,
    ):
        self.id = id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CloneFlowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CloneFlowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CloneFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateClusterTemplateRequestHostGroup(TeaModel):
    def __init__(
        self,
        sys_disk_capacity: int = None,
        host_group_type: str = None,
        comment: str = None,
        multi_instance_types: str = None,
        sys_disk_type: str = None,
        auto_renew: bool = None,
        charge_type: str = None,
        disk_type: str = None,
        host_group_id: str = None,
        instance_type: str = None,
        disk_count: int = None,
        create_type: str = None,
        period: int = None,
        disk_capacity: int = None,
        v_switch_id: str = None,
        node_count: int = None,
        host_group_name: str = None,
        cluster_id: str = None,
    ):
        self.sys_disk_capacity = sys_disk_capacity
        self.host_group_type = host_group_type
        self.comment = comment
        self.multi_instance_types = multi_instance_types
        self.sys_disk_type = sys_disk_type
        self.auto_renew = auto_renew
        self.charge_type = charge_type
        self.disk_type = disk_type
        self.host_group_id = host_group_id
        self.instance_type = instance_type
        self.disk_count = disk_count
        self.create_type = create_type
        self.period = period
        self.disk_capacity = disk_capacity
        self.v_switch_id = v_switch_id
        self.node_count = node_count
        self.host_group_name = host_group_name
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sys_disk_capacity is not None:
            result['SysDiskCapacity'] = self.sys_disk_capacity
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.multi_instance_types is not None:
            result['MultiInstanceTypes'] = self.multi_instance_types
        if self.sys_disk_type is not None:
            result['SysDiskType'] = self.sys_disk_type
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        if self.create_type is not None:
            result['CreateType'] = self.create_type
        if self.period is not None:
            result['Period'] = self.period
        if self.disk_capacity is not None:
            result['DiskCapacity'] = self.disk_capacity
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SysDiskCapacity') is not None:
            self.sys_disk_capacity = m.get('SysDiskCapacity')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('MultiInstanceTypes') is not None:
            self.multi_instance_types = m.get('MultiInstanceTypes')
        if m.get('SysDiskType') is not None:
            self.sys_disk_type = m.get('SysDiskType')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        if m.get('CreateType') is not None:
            self.create_type = m.get('CreateType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('DiskCapacity') is not None:
            self.disk_capacity = m.get('DiskCapacity')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class CreateClusterTemplateRequestBootstrapAction(TeaModel):
    def __init__(
        self,
        arg: str = None,
        path: str = None,
        name: str = None,
    ):
        self.arg = arg
        self.path = path
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arg is not None:
            result['Arg'] = self.arg
        if self.path is not None:
            result['Path'] = self.path
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arg') is not None:
            self.arg = m.get('Arg')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateClusterTemplateRequestConfig(TeaModel):
    def __init__(
        self,
        config_value: str = None,
        replace: str = None,
        file_name: str = None,
        service_name: str = None,
        config_key: str = None,
        encrypt: str = None,
    ):
        self.config_value = config_value
        self.replace = replace
        self.file_name = file_name
        self.service_name = service_name
        self.config_key = config_key
        self.encrypt = encrypt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        if self.replace is not None:
            result['Replace'] = self.replace
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_key is not None:
            result['ConfigKey'] = self.config_key
        if self.encrypt is not None:
            result['Encrypt'] = self.encrypt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        if m.get('Replace') is not None:
            self.replace = m.get('Replace')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigKey') is not None:
            self.config_key = m.get('ConfigKey')
        if m.get('Encrypt') is not None:
            self.encrypt = m.get('Encrypt')
        return self


class CreateClusterTemplateRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateClusterTemplateRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        template_name: str = None,
        region_id: str = None,
        zone_id: str = None,
        log_path: str = None,
        security_group_id: str = None,
        is_open_public_ip: bool = None,
        security_group_name: str = None,
        period: int = None,
        renew_auto: bool = None,
        vpc_id: str = None,
        v_switch_id: str = None,
        net_type: str = None,
        user_defined_emr_ecs_role: str = None,
        emr_ver: str = None,
        cluster_type: str = None,
        enable_high_availability: bool = None,
        use_local_meta_db: bool = None,
        io_optimized_option: bool = None,
        enable_ssh: bool = None,
        instance_generation: str = None,
        master_pwd: str = None,
        key_pair_name: str = None,
        meta_store_type: str = None,
        meta_store_conf: str = None,
        configurations: str = None,
        enable_eas: bool = None,
        deposit_type: str = None,
        machine_type: str = None,
        use_custom_hive_meta_db: bool = None,
        init_custom_hive_meta_db: bool = None,
        resource_group_id: str = None,
        client_token: str = None,
        option_soft_ware_list: List[str] = None,
        host_group: List[CreateClusterTemplateRequestHostGroup] = None,
        bootstrap_action: List[CreateClusterTemplateRequestBootstrapAction] = None,
        config: List[CreateClusterTemplateRequestConfig] = None,
        tag: List[CreateClusterTemplateRequestTag] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.template_name = template_name
        self.region_id = region_id
        self.zone_id = zone_id
        self.log_path = log_path
        self.security_group_id = security_group_id
        self.is_open_public_ip = is_open_public_ip
        self.security_group_name = security_group_name
        self.period = period
        self.renew_auto = renew_auto
        self.vpc_id = vpc_id
        self.v_switch_id = v_switch_id
        self.net_type = net_type
        self.user_defined_emr_ecs_role = user_defined_emr_ecs_role
        self.emr_ver = emr_ver
        self.cluster_type = cluster_type
        self.enable_high_availability = enable_high_availability
        self.use_local_meta_db = use_local_meta_db
        self.io_optimized_option = io_optimized_option
        self.enable_ssh = enable_ssh
        self.instance_generation = instance_generation
        self.master_pwd = master_pwd
        self.key_pair_name = key_pair_name
        self.meta_store_type = meta_store_type
        self.meta_store_conf = meta_store_conf
        self.configurations = configurations
        self.enable_eas = enable_eas
        self.deposit_type = deposit_type
        self.machine_type = machine_type
        self.use_custom_hive_meta_db = use_custom_hive_meta_db
        self.init_custom_hive_meta_db = init_custom_hive_meta_db
        self.resource_group_id = resource_group_id
        self.client_token = client_token
        self.option_soft_ware_list = option_soft_ware_list
        self.host_group = host_group
        self.bootstrap_action = bootstrap_action
        self.config = config
        self.tag = tag

    def validate(self):
        if self.host_group:
            for k in self.host_group:
                if k:
                    k.validate()
        if self.bootstrap_action:
            for k in self.bootstrap_action:
                if k:
                    k.validate()
        if self.config:
            for k in self.config:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.is_open_public_ip is not None:
            result['IsOpenPublicIp'] = self.is_open_public_ip
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        if self.period is not None:
            result['Period'] = self.period
        if self.renew_auto is not None:
            result['RenewAuto'] = self.renew_auto
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.user_defined_emr_ecs_role is not None:
            result['UserDefinedEmrEcsRole'] = self.user_defined_emr_ecs_role
        if self.emr_ver is not None:
            result['EmrVer'] = self.emr_ver
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.enable_high_availability is not None:
            result['EnableHighAvailability'] = self.enable_high_availability
        if self.use_local_meta_db is not None:
            result['UseLocalMetaDb'] = self.use_local_meta_db
        if self.io_optimized_option is not None:
            result['IoOptimizedOption'] = self.io_optimized_option
        if self.enable_ssh is not None:
            result['EnableSsh'] = self.enable_ssh
        if self.instance_generation is not None:
            result['InstanceGeneration'] = self.instance_generation
        if self.master_pwd is not None:
            result['MasterPwd'] = self.master_pwd
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        if self.meta_store_conf is not None:
            result['MetaStoreConf'] = self.meta_store_conf
        if self.configurations is not None:
            result['Configurations'] = self.configurations
        if self.enable_eas is not None:
            result['EnableEas'] = self.enable_eas
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.use_custom_hive_meta_db is not None:
            result['UseCustomHiveMetaDb'] = self.use_custom_hive_meta_db
        if self.init_custom_hive_meta_db is not None:
            result['InitCustomHiveMetaDb'] = self.init_custom_hive_meta_db
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.option_soft_ware_list is not None:
            result['OptionSoftWareList'] = self.option_soft_ware_list
        result['HostGroup'] = []
        if self.host_group is not None:
            for k in self.host_group:
                result['HostGroup'].append(k.to_map() if k else None)
        result['BootstrapAction'] = []
        if self.bootstrap_action is not None:
            for k in self.bootstrap_action:
                result['BootstrapAction'].append(k.to_map() if k else None)
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('IsOpenPublicIp') is not None:
            self.is_open_public_ip = m.get('IsOpenPublicIp')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RenewAuto') is not None:
            self.renew_auto = m.get('RenewAuto')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('UserDefinedEmrEcsRole') is not None:
            self.user_defined_emr_ecs_role = m.get('UserDefinedEmrEcsRole')
        if m.get('EmrVer') is not None:
            self.emr_ver = m.get('EmrVer')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('EnableHighAvailability') is not None:
            self.enable_high_availability = m.get('EnableHighAvailability')
        if m.get('UseLocalMetaDb') is not None:
            self.use_local_meta_db = m.get('UseLocalMetaDb')
        if m.get('IoOptimizedOption') is not None:
            self.io_optimized_option = m.get('IoOptimizedOption')
        if m.get('EnableSsh') is not None:
            self.enable_ssh = m.get('EnableSsh')
        if m.get('InstanceGeneration') is not None:
            self.instance_generation = m.get('InstanceGeneration')
        if m.get('MasterPwd') is not None:
            self.master_pwd = m.get('MasterPwd')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('MetaStoreType') is not None:
            self.meta_store_type = m.get('MetaStoreType')
        if m.get('MetaStoreConf') is not None:
            self.meta_store_conf = m.get('MetaStoreConf')
        if m.get('Configurations') is not None:
            self.configurations = m.get('Configurations')
        if m.get('EnableEas') is not None:
            self.enable_eas = m.get('EnableEas')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('UseCustomHiveMetaDb') is not None:
            self.use_custom_hive_meta_db = m.get('UseCustomHiveMetaDb')
        if m.get('InitCustomHiveMetaDb') is not None:
            self.init_custom_hive_meta_db = m.get('InitCustomHiveMetaDb')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OptionSoftWareList') is not None:
            self.option_soft_ware_list = m.get('OptionSoftWareList')
        self.host_group = []
        if m.get('HostGroup') is not None:
            for k in m.get('HostGroup'):
                temp_model = CreateClusterTemplateRequestHostGroup()
                self.host_group.append(temp_model.from_map(k))
        self.bootstrap_action = []
        if m.get('BootstrapAction') is not None:
            for k in m.get('BootstrapAction'):
                temp_model = CreateClusterTemplateRequestBootstrapAction()
                self.bootstrap_action.append(temp_model.from_map(k))
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = CreateClusterTemplateRequestConfig()
                self.config.append(temp_model.from_map(k))
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateClusterTemplateRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateClusterTemplateResponseBody(TeaModel):
    def __init__(
        self,
        cluster_template_id: str = None,
        request_id: str = None,
    ):
        self.cluster_template_id = cluster_template_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_template_id is not None:
            result['ClusterTemplateId'] = self.cluster_template_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterTemplateId') is not None:
            self.cluster_template_id = m.get('ClusterTemplateId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateClusterTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateClusterTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateClusterTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateLibraryInstallTaskStatusRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        task_biz_id: str = None,
        status: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.task_biz_id = task_biz_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_biz_id is not None:
            result['TaskBizId'] = self.task_biz_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskBizId') is not None:
            self.task_biz_id = m.get('TaskBizId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class UpdateLibraryInstallTaskStatusResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UpdateLibraryInstallTaskStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UpdateLibraryInstallTaskStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UpdateLibraryInstallTaskStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListScalingConfigItemRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        limit: int = None,
        page_number: int = None,
        page_size: int = None,
        current_size: int = None,
        page_count: int = None,
        order_field: str = None,
        order_mode: str = None,
        scaling_group_biz_id: str = None,
        config_item_type: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.limit = limit
        self.page_number = page_number
        self.page_size = page_size
        self.current_size = current_size
        self.page_count = page_count
        self.order_field = order_field
        self.order_mode = order_mode
        self.scaling_group_biz_id = scaling_group_biz_id
        self.config_item_type = config_item_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.limit is not None:
            result['limit'] = self.limit
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_size is not None:
            result['CurrentSize'] = self.current_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.order_field is not None:
            result['OrderField'] = self.order_field
        if self.order_mode is not None:
            result['OrderMode'] = self.order_mode
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.config_item_type is not None:
            result['ConfigItemType'] = self.config_item_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('limit') is not None:
            self.limit = m.get('limit')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentSize') is not None:
            self.current_size = m.get('CurrentSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('OrderField') is not None:
            self.order_field = m.get('OrderField')
        if m.get('OrderMode') is not None:
            self.order_mode = m.get('OrderMode')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('ConfigItemType') is not None:
            self.config_item_type = m.get('ConfigItemType')
        return self


class ListScalingConfigItemResponseBodyItemsItems(TeaModel):
    def __init__(
        self,
        config_item_type: str = None,
        scaling_group_biz_id: str = None,
        scaling_config_item_biz_id: str = None,
        config_item_information: str = None,
    ):
        self.config_item_type = config_item_type
        self.scaling_group_biz_id = scaling_group_biz_id
        self.scaling_config_item_biz_id = scaling_config_item_biz_id
        self.config_item_information = config_item_information

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_item_type is not None:
            result['ConfigItemType'] = self.config_item_type
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.scaling_config_item_biz_id is not None:
            result['ScalingConfigItemBizId'] = self.scaling_config_item_biz_id
        if self.config_item_information is not None:
            result['ConfigItemInformation'] = self.config_item_information
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigItemType') is not None:
            self.config_item_type = m.get('ConfigItemType')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('ScalingConfigItemBizId') is not None:
            self.scaling_config_item_biz_id = m.get('ScalingConfigItemBizId')
        if m.get('ConfigItemInformation') is not None:
            self.config_item_information = m.get('ConfigItemInformation')
        return self


class ListScalingConfigItemResponseBodyItems(TeaModel):
    def __init__(
        self,
        items: List[ListScalingConfigItemResponseBodyItemsItems] = None,
    ):
        self.items = items

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = ListScalingConfigItemResponseBodyItemsItems()
                self.items.append(temp_model.from_map(k))
        return self


class ListScalingConfigItemResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        next_token: str = None,
        items: ListScalingConfigItemResponseBodyItems = None,
    ):
        # Id of the request
        self.request_id = request_id
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.next_token = next_token
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Items') is not None:
            temp_model = ListScalingConfigItemResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class ListScalingConfigItemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListScalingConfigItemResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListScalingConfigItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowInstanceRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        flow_id: str = None,
        flow_name: str = None,
        owner: str = None,
        instance_id: str = None,
        time_range: str = None,
        order_by: str = None,
        order_type: str = None,
        region_id: str = None,
        project_id: str = None,
        page_number: int = None,
        page_size: int = None,
        status_list: List[str] = None,
    ):
        self.id = id
        self.flow_id = flow_id
        self.flow_name = flow_name
        self.owner = owner
        self.instance_id = instance_id
        self.time_range = time_range
        self.order_by = order_by
        self.order_type = order_type
        self.region_id = region_id
        self.project_id = project_id
        self.page_number = page_number
        self.page_size = page_size
        self.status_list = status_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.flow_name is not None:
            result['FlowName'] = self.flow_name
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.time_range is not None:
            result['TimeRange'] = self.time_range
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('FlowName') is not None:
            self.flow_name = m.get('FlowName')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TimeRange') is not None:
            self.time_range = m.get('TimeRange')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        return self


class ListFlowInstanceResponseBodyFlowInstancesFlowInstance(TeaModel):
    def __init__(
        self,
        status: str = None,
        owner: str = None,
        project_id: str = None,
        flow_name: str = None,
        gmt_modified: int = None,
        flow_id: str = None,
        end_time: int = None,
        start_time: int = None,
        has_node_failed: bool = None,
        gmt_create: int = None,
        schedule_time: int = None,
        duration: int = None,
        id: str = None,
        cluster_id: str = None,
    ):
        self.status = status
        self.owner = owner
        self.project_id = project_id
        self.flow_name = flow_name
        self.gmt_modified = gmt_modified
        self.flow_id = flow_id
        self.end_time = end_time
        self.start_time = start_time
        self.has_node_failed = has_node_failed
        self.gmt_create = gmt_create
        self.schedule_time = schedule_time
        self.duration = duration
        self.id = id
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.flow_name is not None:
            result['FlowName'] = self.flow_name
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.has_node_failed is not None:
            result['HasNodeFailed'] = self.has_node_failed
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.schedule_time is not None:
            result['ScheduleTime'] = self.schedule_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.id is not None:
            result['Id'] = self.id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FlowName') is not None:
            self.flow_name = m.get('FlowName')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('HasNodeFailed') is not None:
            self.has_node_failed = m.get('HasNodeFailed')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('ScheduleTime') is not None:
            self.schedule_time = m.get('ScheduleTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class ListFlowInstanceResponseBodyFlowInstances(TeaModel):
    def __init__(
        self,
        flow_instance: List[ListFlowInstanceResponseBodyFlowInstancesFlowInstance] = None,
    ):
        self.flow_instance = flow_instance

    def validate(self):
        if self.flow_instance:
            for k in self.flow_instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FlowInstance'] = []
        if self.flow_instance is not None:
            for k in self.flow_instance:
                result['FlowInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.flow_instance = []
        if m.get('FlowInstance') is not None:
            for k in m.get('FlowInstance'):
                temp_model = ListFlowInstanceResponseBodyFlowInstancesFlowInstance()
                self.flow_instance.append(temp_model.from_map(k))
        return self


class ListFlowInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_number: int = None,
        page_size: int = None,
        total: int = None,
        flow_instances: ListFlowInstanceResponseBodyFlowInstances = None,
    ):
        self.request_id = request_id
        self.page_number = page_number
        self.page_size = page_size
        self.total = total
        self.flow_instances = flow_instances

    def validate(self):
        if self.flow_instances:
            self.flow_instances.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        if self.flow_instances is not None:
            result['FlowInstances'] = self.flow_instances.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('FlowInstances') is not None:
            temp_model = ListFlowInstanceResponseBodyFlowInstances()
            self.flow_instances = temp_model.from_map(m['FlowInstances'])
        return self


class ListFlowInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListFlowInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScalingMetricsRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        host_group_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.host_group_id = host_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        return self


class DescribeScalingMetricsResponseBodyMetricList(TeaModel):
    def __init__(
        self,
        metric_name: str = None,
        unit: str = None,
        display_name: str = None,
        min_value: int = None,
        max_value: int = None,
    ):
        self.metric_name = metric_name
        self.unit = unit
        self.display_name = display_name
        self.min_value = min_value
        self.max_value = max_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.min_value is not None:
            result['MinValue'] = self.min_value
        if self.max_value is not None:
            result['MaxValue'] = self.max_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('MinValue') is not None:
            self.min_value = m.get('MinValue')
        if m.get('MaxValue') is not None:
            self.max_value = m.get('MaxValue')
        return self


class DescribeScalingMetricsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        metric_list: List[DescribeScalingMetricsResponseBodyMetricList] = None,
    ):
        # Id of the request
        self.request_id = request_id
        self.metric_list = metric_list

    def validate(self):
        if self.metric_list:
            for k in self.metric_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['MetricList'] = []
        if self.metric_list is not None:
            for k in self.metric_list:
                result['MetricList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.metric_list = []
        if m.get('MetricList') is not None:
            for k in m.get('MetricList'):
                temp_model = DescribeScalingMetricsResponseBodyMetricList()
                self.metric_list.append(temp_model.from_map(k))
        return self


class DescribeScalingMetricsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeScalingMetricsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeScalingMetricsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UntagResourcesSystemTagsRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_type: str = None,
        tag_owner_uid: int = None,
        resource_ids: List[str] = None,
        tag_keys: List[str] = None,
        all: bool = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        # 资源类型：cluster
        self.resource_type = resource_type
        self.tag_owner_uid = tag_owner_uid
        # 资源ID
        self.resource_ids = resource_ids
        self.tag_keys = tag_keys
        self.all = all

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.tag_owner_uid is not None:
            result['TagOwnerUid'] = self.tag_owner_uid
        if self.resource_ids is not None:
            result['ResourceIds'] = self.resource_ids
        if self.tag_keys is not None:
            result['TagKeys'] = self.tag_keys
        if self.all is not None:
            result['All'] = self.all
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('TagOwnerUid') is not None:
            self.tag_owner_uid = m.get('TagOwnerUid')
        if m.get('ResourceIds') is not None:
            self.resource_ids = m.get('ResourceIds')
        if m.get('TagKeys') is not None:
            self.tag_keys = m.get('TagKeys')
        if m.get('All') is not None:
            self.all = m.get('All')
        return self


class UntagResourcesSystemTagsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_code: str = None,
        message: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 请求是否成功被处理
        self.success = success
        # 响应码
        self.code = code
        # 错误码
        self.error_code = error_code
        # 响应消息
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class UntagResourcesSystemTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UntagResourcesSystemTagsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UntagResourcesSystemTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowProjectRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        region_id: str = None,
    ):
        self.project_id = project_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowProjectResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        description: str = None,
        user_id: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        name: str = None,
        id: str = None,
    ):
        self.request_id = request_id
        self.description = description
        self.user_id = user_id
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.name = name
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.description is not None:
            result['Description'] = self.description
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeFlowProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowProjectResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSecurityWhiteListRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        port_range: str = None,
        white_ip: str = None,
    ):
        self.cluster_id = cluster_id
        self.port_range = port_range
        self.white_ip = white_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.white_ip is not None:
            result['WhiteIp'] = self.white_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('WhiteIp') is not None:
            self.white_ip = m.get('WhiteIp')
        return self


class DeleteSecurityWhiteListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSecurityWhiteListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteSecurityWhiteListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSecurityWhiteListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListScalingActivityRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        limit: int = None,
        page_number: int = None,
        page_size: int = None,
        current_size: int = None,
        page_count: int = None,
        order_field: str = None,
        order_mode: str = None,
        cluster_biz_id: str = None,
        host_group_id: str = None,
        scaling_group_biz_id: str = None,
        scaling_rule_name: str = None,
        host_group_name: str = None,
        status: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.limit = limit
        self.page_number = page_number
        self.page_size = page_size
        self.current_size = current_size
        self.page_count = page_count
        self.order_field = order_field
        self.order_mode = order_mode
        self.cluster_biz_id = cluster_biz_id
        self.host_group_id = host_group_id
        self.scaling_group_biz_id = scaling_group_biz_id
        self.scaling_rule_name = scaling_rule_name
        self.host_group_name = host_group_name
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_size is not None:
            result['CurrentSize'] = self.current_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.order_field is not None:
            result['OrderField'] = self.order_field
        if self.order_mode is not None:
            result['OrderMode'] = self.order_mode
        if self.cluster_biz_id is not None:
            result['ClusterBizId'] = self.cluster_biz_id
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.scaling_rule_name is not None:
            result['ScalingRuleName'] = self.scaling_rule_name
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentSize') is not None:
            self.current_size = m.get('CurrentSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('OrderField') is not None:
            self.order_field = m.get('OrderField')
        if m.get('OrderMode') is not None:
            self.order_mode = m.get('OrderMode')
        if m.get('ClusterBizId') is not None:
            self.cluster_biz_id = m.get('ClusterBizId')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('ScalingRuleName') is not None:
            self.scaling_rule_name = m.get('ScalingRuleName')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListScalingActivityResponseBodyItemsItem(TeaModel):
    def __init__(
        self,
        biz_id: str = None,
        start_time: int = None,
        end_time: int = None,
        expect_num: int = None,
        instance_ids: str = None,
        total_capacity: int = None,
        cause: str = None,
        description: str = None,
        transition: str = None,
        status: str = None,
        scaling_rule_id: str = None,
        scaling_rule_name: str = None,
        host_group_biz_id: str = None,
        host_group_name: str = None,
    ):
        # bizId
        self.biz_id = biz_id
        # startTime
        self.start_time = start_time
        # endTime
        self.end_time = end_time
        self.expect_num = expect_num
        # instanceIds
        self.instance_ids = instance_ids
        # totalCapacity
        self.total_capacity = total_capacity
        # cause
        self.cause = cause
        # description
        self.description = description
        # transition
        self.transition = transition
        # status
        self.status = status
        # scalingRuleId
        self.scaling_rule_id = scaling_rule_id
        # scalingRuleName
        self.scaling_rule_name = scaling_rule_name
        # hostGroupBizId
        self.host_group_biz_id = host_group_biz_id
        # hostGroupName
        self.host_group_name = host_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.expect_num is not None:
            result['ExpectNum'] = self.expect_num
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.total_capacity is not None:
            result['TotalCapacity'] = self.total_capacity
        if self.cause is not None:
            result['Cause'] = self.cause
        if self.description is not None:
            result['Description'] = self.description
        if self.transition is not None:
            result['Transition'] = self.transition
        if self.status is not None:
            result['Status'] = self.status
        if self.scaling_rule_id is not None:
            result['ScalingRuleId'] = self.scaling_rule_id
        if self.scaling_rule_name is not None:
            result['ScalingRuleName'] = self.scaling_rule_name
        if self.host_group_biz_id is not None:
            result['HostGroupBizId'] = self.host_group_biz_id
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ExpectNum') is not None:
            self.expect_num = m.get('ExpectNum')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('TotalCapacity') is not None:
            self.total_capacity = m.get('TotalCapacity')
        if m.get('Cause') is not None:
            self.cause = m.get('Cause')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Transition') is not None:
            self.transition = m.get('Transition')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ScalingRuleId') is not None:
            self.scaling_rule_id = m.get('ScalingRuleId')
        if m.get('ScalingRuleName') is not None:
            self.scaling_rule_name = m.get('ScalingRuleName')
        if m.get('HostGroupBizId') is not None:
            self.host_group_biz_id = m.get('HostGroupBizId')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        return self


class ListScalingActivityResponseBodyItems(TeaModel):
    def __init__(
        self,
        item: List[ListScalingActivityResponseBodyItemsItem] = None,
    ):
        self.item = item

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = ListScalingActivityResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class ListScalingActivityResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        next_token: int = None,
        items: ListScalingActivityResponseBodyItems = None,
    ):
        # requestId
        self.request_id = request_id
        # pageNumber
        self.page_number = page_number
        # pageSize
        self.page_size = page_size
        # totalCount
        self.total_count = total_count
        # nextToken
        self.next_token = next_token
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Items') is not None:
            temp_model = ListScalingActivityResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class ListScalingActivityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListScalingActivityResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListScalingActivityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTagValuesRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        resource_type: str = None,
        scope: str = None,
        next_token: str = None,
        page_size: int = None,
        key: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        # 资源组类型
        self.resource_type = resource_type
        self.scope = scope
        self.next_token = next_token
        self.page_size = page_size
        self.key = key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class ListTagValuesResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        next_token: str = None,
        items: List[str] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.next_token = next_token
        # 标签键集合
        self.items = items

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.items is not None:
            result['Items'] = self.items
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Items') is not None:
            self.items = m.get('Items')
        return self


class ListTagValuesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        paging: bool = None,
        data: List[ListTagValuesResponseBodyData] = None,
        code: str = None,
        error_code: str = None,
        message: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 是否成功响应
        self.success = success
        # 是否分页
        self.paging = paging
        # 标签值集合
        self.data = data
        self.code = code
        self.error_code = error_code
        self.message = message

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.paging is not None:
            result['Paging'] = self.paging
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Paging') is not None:
            self.paging = m.get('Paging')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListTagValuesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class ListTagValuesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListTagValuesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListTagValuesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterInstalledServiceRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledServiceServiceActionListServiceAction(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        action_name: str = None,
        component_name: str = None,
        service_name: str = None,
        command: str = None,
    ):
        self.display_name = display_name
        self.action_name = action_name
        self.component_name = component_name
        self.service_name = service_name
        self.command = command

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.action_name is not None:
            result['ActionName'] = self.action_name
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.command is not None:
            result['Command'] = self.command
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('ActionName') is not None:
            self.action_name = m.get('ActionName')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        return self


class ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledServiceServiceActionList(TeaModel):
    def __init__(
        self,
        service_action: List[ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledServiceServiceActionListServiceAction] = None,
    ):
        self.service_action = service_action

    def validate(self):
        if self.service_action:
            for k in self.service_action:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ServiceAction'] = []
        if self.service_action is not None:
            for k in self.service_action:
                result['ServiceAction'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.service_action = []
        if m.get('ServiceAction') is not None:
            for k in m.get('ServiceAction'):
                temp_model = ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledServiceServiceActionListServiceAction()
                self.service_action.append(temp_model.from_map(k))
        return self


class ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledService(TeaModel):
    def __init__(
        self,
        service_ecm_version: str = None,
        service_display_name: str = None,
        only_client: bool = None,
        comment: str = None,
        not_started_num: int = None,
        need_restart_num: int = None,
        service_version: str = None,
        service_status: str = None,
        service_name: str = None,
        abnormal_num: int = None,
        service_action_list: ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledServiceServiceActionList = None,
    ):
        self.service_ecm_version = service_ecm_version
        self.service_display_name = service_display_name
        self.only_client = only_client
        self.comment = comment
        self.not_started_num = not_started_num
        self.need_restart_num = need_restart_num
        self.service_version = service_version
        self.service_status = service_status
        self.service_name = service_name
        self.abnormal_num = abnormal_num
        self.service_action_list = service_action_list

    def validate(self):
        if self.service_action_list:
            self.service_action_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_ecm_version is not None:
            result['ServiceEcmVersion'] = self.service_ecm_version
        if self.service_display_name is not None:
            result['ServiceDisplayName'] = self.service_display_name
        if self.only_client is not None:
            result['OnlyClient'] = self.only_client
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.not_started_num is not None:
            result['NotStartedNum'] = self.not_started_num
        if self.need_restart_num is not None:
            result['NeedRestartNum'] = self.need_restart_num
        if self.service_version is not None:
            result['ServiceVersion'] = self.service_version
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.abnormal_num is not None:
            result['AbnormalNum'] = self.abnormal_num
        if self.service_action_list is not None:
            result['ServiceActionList'] = self.service_action_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ServiceEcmVersion') is not None:
            self.service_ecm_version = m.get('ServiceEcmVersion')
        if m.get('ServiceDisplayName') is not None:
            self.service_display_name = m.get('ServiceDisplayName')
        if m.get('OnlyClient') is not None:
            self.only_client = m.get('OnlyClient')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('NotStartedNum') is not None:
            self.not_started_num = m.get('NotStartedNum')
        if m.get('NeedRestartNum') is not None:
            self.need_restart_num = m.get('NeedRestartNum')
        if m.get('ServiceVersion') is not None:
            self.service_version = m.get('ServiceVersion')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('AbnormalNum') is not None:
            self.abnormal_num = m.get('AbnormalNum')
        if m.get('ServiceActionList') is not None:
            temp_model = ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledServiceServiceActionList()
            self.service_action_list = temp_model.from_map(m['ServiceActionList'])
        return self


class ListClusterInstalledServiceResponseBodyClusterInstalledServiceList(TeaModel):
    def __init__(
        self,
        cluster_installed_service: List[ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledService] = None,
    ):
        self.cluster_installed_service = cluster_installed_service

    def validate(self):
        if self.cluster_installed_service:
            for k in self.cluster_installed_service:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterInstalledService'] = []
        if self.cluster_installed_service is not None:
            for k in self.cluster_installed_service:
                result['ClusterInstalledService'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_installed_service = []
        if m.get('ClusterInstalledService') is not None:
            for k in m.get('ClusterInstalledService'):
                temp_model = ListClusterInstalledServiceResponseBodyClusterInstalledServiceListClusterInstalledService()
                self.cluster_installed_service.append(temp_model.from_map(k))
        return self


class ListClusterInstalledServiceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        cluster_installed_service_list: ListClusterInstalledServiceResponseBodyClusterInstalledServiceList = None,
    ):
        self.request_id = request_id
        self.cluster_installed_service_list = cluster_installed_service_list

    def validate(self):
        if self.cluster_installed_service_list:
            self.cluster_installed_service_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cluster_installed_service_list is not None:
            result['ClusterInstalledServiceList'] = self.cluster_installed_service_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ClusterInstalledServiceList') is not None:
            temp_model = ListClusterInstalledServiceResponseBodyClusterInstalledServiceList()
            self.cluster_installed_service_list = temp_model.from_map(m['ClusterInstalledServiceList'])
        return self


class ListClusterInstalledServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterInstalledServiceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterInstalledServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RunClusterServiceActionRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        host_id_list: str = None,
        service_name: str = None,
        service_action_name: str = None,
        custom_command: str = None,
        component_name_list: str = None,
        comment: str = None,
        is_rolling: bool = None,
        execute_strategy: str = None,
        custom_params: str = None,
        interval: int = None,
        node_count_per_batch: int = None,
        tolerate_fail_count: int = None,
        only_restart_stale_config_nodes: bool = None,
        turn_on_maintenance_mode: bool = None,
        host_group_id_list: List[str] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.host_id_list = host_id_list
        self.service_name = service_name
        self.service_action_name = service_action_name
        self.custom_command = custom_command
        self.component_name_list = component_name_list
        self.comment = comment
        self.is_rolling = is_rolling
        self.execute_strategy = execute_strategy
        self.custom_params = custom_params
        self.interval = interval
        self.node_count_per_batch = node_count_per_batch
        self.tolerate_fail_count = tolerate_fail_count
        self.only_restart_stale_config_nodes = only_restart_stale_config_nodes
        self.turn_on_maintenance_mode = turn_on_maintenance_mode
        self.host_group_id_list = host_group_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_id_list is not None:
            result['HostIdList'] = self.host_id_list
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.service_action_name is not None:
            result['ServiceActionName'] = self.service_action_name
        if self.custom_command is not None:
            result['CustomCommand'] = self.custom_command
        if self.component_name_list is not None:
            result['ComponentNameList'] = self.component_name_list
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.is_rolling is not None:
            result['IsRolling'] = self.is_rolling
        if self.execute_strategy is not None:
            result['ExecuteStrategy'] = self.execute_strategy
        if self.custom_params is not None:
            result['CustomParams'] = self.custom_params
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.node_count_per_batch is not None:
            result['NodeCountPerBatch'] = self.node_count_per_batch
        if self.tolerate_fail_count is not None:
            result['TolerateFailCount'] = self.tolerate_fail_count
        if self.only_restart_stale_config_nodes is not None:
            result['OnlyRestartStaleConfigNodes'] = self.only_restart_stale_config_nodes
        if self.turn_on_maintenance_mode is not None:
            result['TurnOnMaintenanceMode'] = self.turn_on_maintenance_mode
        if self.host_group_id_list is not None:
            result['HostGroupIdList'] = self.host_group_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostIdList') is not None:
            self.host_id_list = m.get('HostIdList')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ServiceActionName') is not None:
            self.service_action_name = m.get('ServiceActionName')
        if m.get('CustomCommand') is not None:
            self.custom_command = m.get('CustomCommand')
        if m.get('ComponentNameList') is not None:
            self.component_name_list = m.get('ComponentNameList')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('IsRolling') is not None:
            self.is_rolling = m.get('IsRolling')
        if m.get('ExecuteStrategy') is not None:
            self.execute_strategy = m.get('ExecuteStrategy')
        if m.get('CustomParams') is not None:
            self.custom_params = m.get('CustomParams')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('NodeCountPerBatch') is not None:
            self.node_count_per_batch = m.get('NodeCountPerBatch')
        if m.get('TolerateFailCount') is not None:
            self.tolerate_fail_count = m.get('TolerateFailCount')
        if m.get('OnlyRestartStaleConfigNodes') is not None:
            self.only_restart_stale_config_nodes = m.get('OnlyRestartStaleConfigNodes')
        if m.get('TurnOnMaintenanceMode') is not None:
            self.turn_on_maintenance_mode = m.get('TurnOnMaintenanceMode')
        if m.get('HostGroupIdList') is not None:
            self.host_group_id_list = m.get('HostGroupIdList')
        return self


class RunClusterServiceActionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RunClusterServiceActionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: RunClusterServiceActionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RunClusterServiceActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SuspendFlowRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        flow_instance_id: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.flow_instance_id = flow_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.flow_instance_id is not None:
            result['FlowInstanceId'] = self.flow_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FlowInstanceId') is not None:
            self.flow_instance_id = m.get('FlowInstanceId')
        return self


class SuspendFlowResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SuspendFlowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SuspendFlowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SuspendFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowProjectRequest(TeaModel):
    def __init__(
        self,
        product_type: str = None,
        region_id: str = None,
        name: str = None,
        description: str = None,
        resource_group_id: str = None,
        client_token: str = None,
    ):
        self.product_type = product_type
        self.region_id = region_id
        self.name = name
        self.description = description
        self.resource_group_id = resource_group_id
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateFlowProjectResponseBody(TeaModel):
    def __init__(
        self,
        id: str = None,
        request_id: str = None,
    ):
        self.id = id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateFlowProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFlowProjectResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowNodeInstanceContainerStatusRequest(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        node_instance_id: str = None,
        project_id: str = None,
        region_id: str = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.node_instance_id = node_instance_id
        self.project_id = project_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.node_instance_id is not None:
            result['NodeInstanceId'] = self.node_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('NodeInstanceId') is not None:
            self.node_instance_id = m.get('NodeInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ListFlowNodeInstanceContainerStatusResponseBodyContainerStatusListContainerStatus(TeaModel):
    def __init__(
        self,
        status: str = None,
        host_name: str = None,
        container_id: str = None,
        application_id: str = None,
    ):
        self.status = status
        self.host_name = host_name
        self.container_id = container_id
        self.application_id = application_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        return self


class ListFlowNodeInstanceContainerStatusResponseBodyContainerStatusList(TeaModel):
    def __init__(
        self,
        container_status: List[ListFlowNodeInstanceContainerStatusResponseBodyContainerStatusListContainerStatus] = None,
    ):
        self.container_status = container_status

    def validate(self):
        if self.container_status:
            for k in self.container_status:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ContainerStatus'] = []
        if self.container_status is not None:
            for k in self.container_status:
                result['ContainerStatus'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.container_status = []
        if m.get('ContainerStatus') is not None:
            for k in m.get('ContainerStatus'):
                temp_model = ListFlowNodeInstanceContainerStatusResponseBodyContainerStatusListContainerStatus()
                self.container_status.append(temp_model.from_map(k))
        return self


class ListFlowNodeInstanceContainerStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_number: int = None,
        page_size: int = None,
        total: int = None,
        container_status_list: ListFlowNodeInstanceContainerStatusResponseBodyContainerStatusList = None,
    ):
        self.request_id = request_id
        self.page_number = page_number
        self.page_size = page_size
        self.total = total
        self.container_status_list = container_status_list

    def validate(self):
        if self.container_status_list:
            self.container_status_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        if self.container_status_list is not None:
            result['ContainerStatusList'] = self.container_status_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('ContainerStatusList') is not None:
            temp_model = ListFlowNodeInstanceContainerStatusResponseBodyContainerStatusList()
            self.container_status_list = temp_model.from_map(m['ContainerStatusList'])
        return self


class ListFlowNodeInstanceContainerStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListFlowNodeInstanceContainerStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowNodeInstanceContainerStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyClusterTemplateRequestHostGroup(TeaModel):
    def __init__(
        self,
        sys_disk_capacity: int = None,
        host_group_type: str = None,
        comment: str = None,
        multi_instance_types: str = None,
        sys_disk_type: str = None,
        charge_type: str = None,
        disk_type: str = None,
        host_group_id: str = None,
        instance_type: str = None,
        disk_count: int = None,
        create_type: str = None,
        period: int = None,
        disk_capacity: int = None,
        v_switch_id: str = None,
        node_count: int = None,
        host_group_name: str = None,
        renew_auto: bool = None,
        cluster_id: str = None,
    ):
        self.sys_disk_capacity = sys_disk_capacity
        self.host_group_type = host_group_type
        self.comment = comment
        self.multi_instance_types = multi_instance_types
        self.sys_disk_type = sys_disk_type
        self.charge_type = charge_type
        self.disk_type = disk_type
        self.host_group_id = host_group_id
        self.instance_type = instance_type
        self.disk_count = disk_count
        self.create_type = create_type
        self.period = period
        self.disk_capacity = disk_capacity
        self.v_switch_id = v_switch_id
        self.node_count = node_count
        self.host_group_name = host_group_name
        self.renew_auto = renew_auto
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sys_disk_capacity is not None:
            result['SysDiskCapacity'] = self.sys_disk_capacity
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.multi_instance_types is not None:
            result['MultiInstanceTypes'] = self.multi_instance_types
        if self.sys_disk_type is not None:
            result['SysDiskType'] = self.sys_disk_type
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        if self.create_type is not None:
            result['CreateType'] = self.create_type
        if self.period is not None:
            result['Period'] = self.period
        if self.disk_capacity is not None:
            result['DiskCapacity'] = self.disk_capacity
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        if self.renew_auto is not None:
            result['RenewAuto'] = self.renew_auto
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SysDiskCapacity') is not None:
            self.sys_disk_capacity = m.get('SysDiskCapacity')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('MultiInstanceTypes') is not None:
            self.multi_instance_types = m.get('MultiInstanceTypes')
        if m.get('SysDiskType') is not None:
            self.sys_disk_type = m.get('SysDiskType')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        if m.get('CreateType') is not None:
            self.create_type = m.get('CreateType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('DiskCapacity') is not None:
            self.disk_capacity = m.get('DiskCapacity')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        if m.get('RenewAuto') is not None:
            self.renew_auto = m.get('RenewAuto')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class ModifyClusterTemplateRequestBootstrapAction(TeaModel):
    def __init__(
        self,
        arg: str = None,
        path: str = None,
        name: str = None,
    ):
        self.arg = arg
        self.path = path
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arg is not None:
            result['Arg'] = self.arg
        if self.path is not None:
            result['Path'] = self.path
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arg') is not None:
            self.arg = m.get('Arg')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ModifyClusterTemplateRequestConfig(TeaModel):
    def __init__(
        self,
        config_value: str = None,
        replace: str = None,
        file_name: str = None,
        service_name: str = None,
        config_key: str = None,
        encrypt: str = None,
    ):
        self.config_value = config_value
        self.replace = replace
        self.file_name = file_name
        self.service_name = service_name
        self.config_key = config_key
        self.encrypt = encrypt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        if self.replace is not None:
            result['Replace'] = self.replace
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_key is not None:
            result['ConfigKey'] = self.config_key
        if self.encrypt is not None:
            result['Encrypt'] = self.encrypt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        if m.get('Replace') is not None:
            self.replace = m.get('Replace')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigKey') is not None:
            self.config_key = m.get('ConfigKey')
        if m.get('Encrypt') is not None:
            self.encrypt = m.get('Encrypt')
        return self


class ModifyClusterTemplateRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ModifyClusterTemplateRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        biz_id: str = None,
        template_name: str = None,
        region_id: str = None,
        zone_id: str = None,
        log_path: str = None,
        security_group_id: str = None,
        is_open_public_ip: bool = None,
        security_group_name: str = None,
        charge_type: str = None,
        period: int = None,
        renew_auto: bool = None,
        vpc_id: str = None,
        v_switch_id: str = None,
        net_type: str = None,
        user_defined_emr_ecs_role: str = None,
        emr_ver: str = None,
        cluster_type: str = None,
        enable_high_availability: bool = None,
        use_local_meta_db: bool = None,
        io_optimized_option: bool = None,
        enable_ssh: bool = None,
        instance_generation: str = None,
        master_pwd: str = None,
        key_pair_name: str = None,
        meta_store_type: str = None,
        meta_store_conf: str = None,
        configurations: str = None,
        enable_eas: bool = None,
        deposit_type: str = None,
        machine_type: str = None,
        use_custom_hive_meta_db: bool = None,
        init_custom_hive_meta_db: bool = None,
        resource_group_id: str = None,
        option_soft_ware_list: List[str] = None,
        host_group: List[ModifyClusterTemplateRequestHostGroup] = None,
        bootstrap_action: List[ModifyClusterTemplateRequestBootstrapAction] = None,
        config: List[ModifyClusterTemplateRequestConfig] = None,
        tag: List[ModifyClusterTemplateRequestTag] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.biz_id = biz_id
        self.template_name = template_name
        self.region_id = region_id
        self.zone_id = zone_id
        self.log_path = log_path
        self.security_group_id = security_group_id
        self.is_open_public_ip = is_open_public_ip
        self.security_group_name = security_group_name
        self.charge_type = charge_type
        self.period = period
        self.renew_auto = renew_auto
        self.vpc_id = vpc_id
        self.v_switch_id = v_switch_id
        self.net_type = net_type
        self.user_defined_emr_ecs_role = user_defined_emr_ecs_role
        self.emr_ver = emr_ver
        self.cluster_type = cluster_type
        self.enable_high_availability = enable_high_availability
        self.use_local_meta_db = use_local_meta_db
        self.io_optimized_option = io_optimized_option
        self.enable_ssh = enable_ssh
        self.instance_generation = instance_generation
        self.master_pwd = master_pwd
        self.key_pair_name = key_pair_name
        self.meta_store_type = meta_store_type
        self.meta_store_conf = meta_store_conf
        self.configurations = configurations
        self.enable_eas = enable_eas
        self.deposit_type = deposit_type
        self.machine_type = machine_type
        self.use_custom_hive_meta_db = use_custom_hive_meta_db
        self.init_custom_hive_meta_db = init_custom_hive_meta_db
        self.resource_group_id = resource_group_id
        self.option_soft_ware_list = option_soft_ware_list
        self.host_group = host_group
        self.bootstrap_action = bootstrap_action
        self.config = config
        self.tag = tag

    def validate(self):
        if self.host_group:
            for k in self.host_group:
                if k:
                    k.validate()
        if self.bootstrap_action:
            for k in self.bootstrap_action:
                if k:
                    k.validate()
        if self.config:
            for k in self.config:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.is_open_public_ip is not None:
            result['IsOpenPublicIp'] = self.is_open_public_ip
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.period is not None:
            result['Period'] = self.period
        if self.renew_auto is not None:
            result['RenewAuto'] = self.renew_auto
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.user_defined_emr_ecs_role is not None:
            result['UserDefinedEmrEcsRole'] = self.user_defined_emr_ecs_role
        if self.emr_ver is not None:
            result['EmrVer'] = self.emr_ver
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.enable_high_availability is not None:
            result['EnableHighAvailability'] = self.enable_high_availability
        if self.use_local_meta_db is not None:
            result['UseLocalMetaDb'] = self.use_local_meta_db
        if self.io_optimized_option is not None:
            result['IoOptimizedOption'] = self.io_optimized_option
        if self.enable_ssh is not None:
            result['EnableSsh'] = self.enable_ssh
        if self.instance_generation is not None:
            result['InstanceGeneration'] = self.instance_generation
        if self.master_pwd is not None:
            result['MasterPwd'] = self.master_pwd
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        if self.meta_store_conf is not None:
            result['MetaStoreConf'] = self.meta_store_conf
        if self.configurations is not None:
            result['Configurations'] = self.configurations
        if self.enable_eas is not None:
            result['EnableEas'] = self.enable_eas
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.use_custom_hive_meta_db is not None:
            result['UseCustomHiveMetaDb'] = self.use_custom_hive_meta_db
        if self.init_custom_hive_meta_db is not None:
            result['InitCustomHiveMetaDb'] = self.init_custom_hive_meta_db
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.option_soft_ware_list is not None:
            result['OptionSoftWareList'] = self.option_soft_ware_list
        result['HostGroup'] = []
        if self.host_group is not None:
            for k in self.host_group:
                result['HostGroup'].append(k.to_map() if k else None)
        result['BootstrapAction'] = []
        if self.bootstrap_action is not None:
            for k in self.bootstrap_action:
                result['BootstrapAction'].append(k.to_map() if k else None)
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('IsOpenPublicIp') is not None:
            self.is_open_public_ip = m.get('IsOpenPublicIp')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RenewAuto') is not None:
            self.renew_auto = m.get('RenewAuto')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('UserDefinedEmrEcsRole') is not None:
            self.user_defined_emr_ecs_role = m.get('UserDefinedEmrEcsRole')
        if m.get('EmrVer') is not None:
            self.emr_ver = m.get('EmrVer')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('EnableHighAvailability') is not None:
            self.enable_high_availability = m.get('EnableHighAvailability')
        if m.get('UseLocalMetaDb') is not None:
            self.use_local_meta_db = m.get('UseLocalMetaDb')
        if m.get('IoOptimizedOption') is not None:
            self.io_optimized_option = m.get('IoOptimizedOption')
        if m.get('EnableSsh') is not None:
            self.enable_ssh = m.get('EnableSsh')
        if m.get('InstanceGeneration') is not None:
            self.instance_generation = m.get('InstanceGeneration')
        if m.get('MasterPwd') is not None:
            self.master_pwd = m.get('MasterPwd')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('MetaStoreType') is not None:
            self.meta_store_type = m.get('MetaStoreType')
        if m.get('MetaStoreConf') is not None:
            self.meta_store_conf = m.get('MetaStoreConf')
        if m.get('Configurations') is not None:
            self.configurations = m.get('Configurations')
        if m.get('EnableEas') is not None:
            self.enable_eas = m.get('EnableEas')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('UseCustomHiveMetaDb') is not None:
            self.use_custom_hive_meta_db = m.get('UseCustomHiveMetaDb')
        if m.get('InitCustomHiveMetaDb') is not None:
            self.init_custom_hive_meta_db = m.get('InitCustomHiveMetaDb')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('OptionSoftWareList') is not None:
            self.option_soft_ware_list = m.get('OptionSoftWareList')
        self.host_group = []
        if m.get('HostGroup') is not None:
            for k in m.get('HostGroup'):
                temp_model = ModifyClusterTemplateRequestHostGroup()
                self.host_group.append(temp_model.from_map(k))
        self.bootstrap_action = []
        if m.get('BootstrapAction') is not None:
            for k in m.get('BootstrapAction'):
                temp_model = ModifyClusterTemplateRequestBootstrapAction()
                self.bootstrap_action.append(temp_model.from_map(k))
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = ModifyClusterTemplateRequestConfig()
                self.config.append(temp_model.from_map(k))
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = ModifyClusterTemplateRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class ModifyClusterTemplateResponseBody(TeaModel):
    def __init__(
        self,
        cluster_template_id: str = None,
        request_id: str = None,
    ):
        self.cluster_template_id = cluster_template_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_template_id is not None:
            result['ClusterTemplateId'] = self.cluster_template_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterTemplateId') is not None:
            self.cluster_template_id = m.get('ClusterTemplateId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyClusterTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyClusterTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyClusterTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddSecurityWhiteListRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        port_range: str = None,
        white_ip_list: List[str] = None,
        description: str = None,
    ):
        self.cluster_id = cluster_id
        self.port_range = port_range
        self.white_ip_list = white_ip_list
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.white_ip_list is not None:
            result['WhiteIpList'] = self.white_ip_list
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('WhiteIpList') is not None:
            self.white_ip_list = m.get('WhiteIpList')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class AddSecurityWhiteListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddSecurityWhiteListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddSecurityWhiteListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddSecurityWhiteListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListMetaClusterRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        page_number: int = None,
        page_size: int = None,
        source_type: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.page_number = page_number
        self.page_size = page_size
        self.source_type = source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class ListMetaClusterResponseBodyItemsItemSoftwareInfo(TeaModel):
    def __init__(
        self,
        cluster_type: str = None,
        emr_ver: str = None,
    ):
        self.cluster_type = cluster_type
        self.emr_ver = emr_ver

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.emr_ver is not None:
            result['EmrVer'] = self.emr_ver
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('EmrVer') is not None:
            self.emr_ver = m.get('EmrVer')
        return self


class ListMetaClusterResponseBodyItemsItem(TeaModel):
    def __init__(
        self,
        name: str = None,
        id: str = None,
        software_info: ListMetaClusterResponseBodyItemsItemSoftwareInfo = None,
    ):
        self.name = name
        self.id = id
        self.software_info = software_info

    def validate(self):
        if self.software_info:
            self.software_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        if self.software_info is not None:
            result['SoftwareInfo'] = self.software_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('SoftwareInfo') is not None:
            temp_model = ListMetaClusterResponseBodyItemsItemSoftwareInfo()
            self.software_info = temp_model.from_map(m['SoftwareInfo'])
        return self


class ListMetaClusterResponseBodyItems(TeaModel):
    def __init__(
        self,
        item: List[ListMetaClusterResponseBodyItemsItem] = None,
    ):
        self.item = item

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = ListMetaClusterResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class ListMetaClusterResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        items: ListMetaClusterResponseBodyItems = None,
    ):
        self.request_id = request_id
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Items') is not None:
            temp_model = ListMetaClusterResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class ListMetaClusterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListMetaClusterResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListMetaClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterOperationHostRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        operation_id: str = None,
        status: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.operation_id = operation_id
        self.status = status
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.operation_id is not None:
            result['OperationId'] = self.operation_id
        if self.status is not None:
            result['Status'] = self.status
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('OperationId') is not None:
            self.operation_id = m.get('OperationId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListClusterOperationHostResponseBodyClusterOperationHostListClusterOperationHost(TeaModel):
    def __init__(
        self,
        status: str = None,
        host_name: str = None,
        percentage: str = None,
        host_id: str = None,
    ):
        self.status = status
        self.host_name = host_name
        self.percentage = percentage
        self.host_id = host_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.percentage is not None:
            result['Percentage'] = self.percentage
        if self.host_id is not None:
            result['HostId'] = self.host_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Percentage') is not None:
            self.percentage = m.get('Percentage')
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        return self


class ListClusterOperationHostResponseBodyClusterOperationHostList(TeaModel):
    def __init__(
        self,
        cluster_operation_host: List[ListClusterOperationHostResponseBodyClusterOperationHostListClusterOperationHost] = None,
    ):
        self.cluster_operation_host = cluster_operation_host

    def validate(self):
        if self.cluster_operation_host:
            for k in self.cluster_operation_host:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterOperationHost'] = []
        if self.cluster_operation_host is not None:
            for k in self.cluster_operation_host:
                result['ClusterOperationHost'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_operation_host = []
        if m.get('ClusterOperationHost') is not None:
            for k in m.get('ClusterOperationHost'):
                temp_model = ListClusterOperationHostResponseBodyClusterOperationHostListClusterOperationHost()
                self.cluster_operation_host.append(temp_model.from_map(k))
        return self


class ListClusterOperationHostResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        total_count: int = None,
        cluster_operation_host_list: ListClusterOperationHostResponseBodyClusterOperationHostList = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.total_count = total_count
        self.cluster_operation_host_list = cluster_operation_host_list

    def validate(self):
        if self.cluster_operation_host_list:
            self.cluster_operation_host_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.cluster_operation_host_list is not None:
            result['ClusterOperationHostList'] = self.cluster_operation_host_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('ClusterOperationHostList') is not None:
            temp_model = ListClusterOperationHostResponseBodyClusterOperationHostList()
            self.cluster_operation_host_list = temp_model.from_map(m['ClusterOperationHostList'])
        return self


class ListClusterOperationHostResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterOperationHostResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterOperationHostResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterTemplatesRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        biz_id: str = None,
        page_number: int = None,
        page_size: int = None,
        product_type: str = None,
        resource_group_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.biz_id = biz_id
        self.page_number = page_number
        self.page_size = page_size
        self.product_type = product_type
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoBootstrapActionListBootstrapAction(TeaModel):
    def __init__(
        self,
        path: str = None,
        name: str = None,
        arg: str = None,
    ):
        self.path = path
        self.name = name
        self.arg = arg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.name is not None:
            result['Name'] = self.name
        if self.arg is not None:
            result['Arg'] = self.arg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Arg') is not None:
            self.arg = m.get('Arg')
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoBootstrapActionList(TeaModel):
    def __init__(
        self,
        bootstrap_action: List[ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoBootstrapActionListBootstrapAction] = None,
    ):
        self.bootstrap_action = bootstrap_action

    def validate(self):
        if self.bootstrap_action:
            for k in self.bootstrap_action:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BootstrapAction'] = []
        if self.bootstrap_action is not None:
            for k in self.bootstrap_action:
                result['BootstrapAction'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bootstrap_action = []
        if m.get('BootstrapAction') is not None:
            for k in m.get('BootstrapAction'):
                temp_model = ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoBootstrapActionListBootstrapAction()
                self.bootstrap_action.append(temp_model.from_map(k))
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoHostGroupListHostGroup(TeaModel):
    def __init__(
        self,
        sys_disk_capacity: int = None,
        host_group_type: str = None,
        multi_instance_types: str = None,
        sys_disk_type: str = None,
        charge_type: str = None,
        disk_type: str = None,
        host_group_id: str = None,
        instance_type: str = None,
        disk_count: int = None,
        period: str = None,
        disk_capacity: int = None,
        node_count: int = None,
        host_group_name: str = None,
    ):
        self.sys_disk_capacity = sys_disk_capacity
        self.host_group_type = host_group_type
        self.multi_instance_types = multi_instance_types
        self.sys_disk_type = sys_disk_type
        self.charge_type = charge_type
        self.disk_type = disk_type
        self.host_group_id = host_group_id
        self.instance_type = instance_type
        self.disk_count = disk_count
        self.period = period
        self.disk_capacity = disk_capacity
        self.node_count = node_count
        self.host_group_name = host_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sys_disk_capacity is not None:
            result['SysDiskCapacity'] = self.sys_disk_capacity
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.multi_instance_types is not None:
            result['MultiInstanceTypes'] = self.multi_instance_types
        if self.sys_disk_type is not None:
            result['SysDiskType'] = self.sys_disk_type
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        if self.period is not None:
            result['Period'] = self.period
        if self.disk_capacity is not None:
            result['DiskCapacity'] = self.disk_capacity
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SysDiskCapacity') is not None:
            self.sys_disk_capacity = m.get('SysDiskCapacity')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('MultiInstanceTypes') is not None:
            self.multi_instance_types = m.get('MultiInstanceTypes')
        if m.get('SysDiskType') is not None:
            self.sys_disk_type = m.get('SysDiskType')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('DiskCapacity') is not None:
            self.disk_capacity = m.get('DiskCapacity')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoHostGroupList(TeaModel):
    def __init__(
        self,
        host_group: List[ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoHostGroupListHostGroup] = None,
    ):
        self.host_group = host_group

    def validate(self):
        if self.host_group:
            for k in self.host_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HostGroup'] = []
        if self.host_group is not None:
            for k in self.host_group:
                result['HostGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.host_group = []
        if m.get('HostGroup') is not None:
            for k in m.get('HostGroup'):
                temp_model = ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoHostGroupListHostGroup()
                self.host_group.append(temp_model.from_map(k))
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoConfigListConfig(TeaModel):
    def __init__(
        self,
        config_value: str = None,
        replace: str = None,
        file_name: str = None,
        service_name: str = None,
        config_key: str = None,
        encrypt: str = None,
    ):
        self.config_value = config_value
        self.replace = replace
        self.file_name = file_name
        self.service_name = service_name
        self.config_key = config_key
        self.encrypt = encrypt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        if self.replace is not None:
            result['Replace'] = self.replace
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_key is not None:
            result['ConfigKey'] = self.config_key
        if self.encrypt is not None:
            result['Encrypt'] = self.encrypt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        if m.get('Replace') is not None:
            self.replace = m.get('Replace')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigKey') is not None:
            self.config_key = m.get('ConfigKey')
        if m.get('Encrypt') is not None:
            self.encrypt = m.get('Encrypt')
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoConfigList(TeaModel):
    def __init__(
        self,
        config: List[ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoConfigListConfig] = None,
    ):
        self.config = config

    def validate(self):
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoConfigListConfig()
                self.config.append(temp_model.from_map(k))
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoSoftwareInfoList(TeaModel):
    def __init__(
        self,
        software_info: List[str] = None,
    ):
        self.software_info = software_info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.software_info is not None:
            result['SoftwareInfo'] = self.software_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SoftwareInfo') is not None:
            self.software_info = m.get('SoftwareInfo')
        return self


class ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfo(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
        key_pair_name: str = None,
        log_enable: bool = None,
        ssh_enable: bool = None,
        high_availability_enable: bool = None,
        security_group_id: str = None,
        user_id: str = None,
        is_open_public_ip: bool = None,
        allow_notebook: bool = None,
        gmt_modified: int = None,
        template_name: str = None,
        deposit_type: str = None,
        security_group_name: str = None,
        create_source: str = None,
        instance_generation: str = None,
        use_custom_hive_meta_db: bool = None,
        eas_enable: bool = None,
        user_defined_emr_ecs_role: str = None,
        meta_store_type: str = None,
        machine_type: str = None,
        use_local_meta_db: bool = None,
        master_node_total: int = None,
        init_custom_hive_meta_db: bool = None,
        io_optimized: bool = None,
        meta_store_conf: str = None,
        v_switch_id: str = None,
        configurations: str = None,
        log_path: str = None,
        cluster_type: str = None,
        net_type: str = None,
        zone_id: str = None,
        gmt_create: int = None,
        id: str = None,
        bootstrap_action_list: ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoBootstrapActionList = None,
        host_group_list: ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoHostGroupList = None,
        config_list: ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoConfigList = None,
        software_info_list: ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoSoftwareInfoList = None,
    ):
        self.vpc_id = vpc_id
        self.key_pair_name = key_pair_name
        self.log_enable = log_enable
        self.ssh_enable = ssh_enable
        self.high_availability_enable = high_availability_enable
        self.security_group_id = security_group_id
        self.user_id = user_id
        self.is_open_public_ip = is_open_public_ip
        self.allow_notebook = allow_notebook
        self.gmt_modified = gmt_modified
        self.template_name = template_name
        self.deposit_type = deposit_type
        self.security_group_name = security_group_name
        self.create_source = create_source
        self.instance_generation = instance_generation
        self.use_custom_hive_meta_db = use_custom_hive_meta_db
        self.eas_enable = eas_enable
        self.user_defined_emr_ecs_role = user_defined_emr_ecs_role
        self.meta_store_type = meta_store_type
        self.machine_type = machine_type
        self.use_local_meta_db = use_local_meta_db
        self.master_node_total = master_node_total
        self.init_custom_hive_meta_db = init_custom_hive_meta_db
        self.io_optimized = io_optimized
        self.meta_store_conf = meta_store_conf
        self.v_switch_id = v_switch_id
        self.configurations = configurations
        self.log_path = log_path
        self.cluster_type = cluster_type
        self.net_type = net_type
        self.zone_id = zone_id
        self.gmt_create = gmt_create
        self.id = id
        self.bootstrap_action_list = bootstrap_action_list
        self.host_group_list = host_group_list
        self.config_list = config_list
        self.software_info_list = software_info_list

    def validate(self):
        if self.bootstrap_action_list:
            self.bootstrap_action_list.validate()
        if self.host_group_list:
            self.host_group_list.validate()
        if self.config_list:
            self.config_list.validate()
        if self.software_info_list:
            self.software_info_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.log_enable is not None:
            result['LogEnable'] = self.log_enable
        if self.ssh_enable is not None:
            result['SshEnable'] = self.ssh_enable
        if self.high_availability_enable is not None:
            result['HighAvailabilityEnable'] = self.high_availability_enable
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.is_open_public_ip is not None:
            result['IsOpenPublicIp'] = self.is_open_public_ip
        if self.allow_notebook is not None:
            result['AllowNotebook'] = self.allow_notebook
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.instance_generation is not None:
            result['InstanceGeneration'] = self.instance_generation
        if self.use_custom_hive_meta_db is not None:
            result['UseCustomHiveMetaDb'] = self.use_custom_hive_meta_db
        if self.eas_enable is not None:
            result['EasEnable'] = self.eas_enable
        if self.user_defined_emr_ecs_role is not None:
            result['UserDefinedEmrEcsRole'] = self.user_defined_emr_ecs_role
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.use_local_meta_db is not None:
            result['UseLocalMetaDb'] = self.use_local_meta_db
        if self.master_node_total is not None:
            result['MasterNodeTotal'] = self.master_node_total
        if self.init_custom_hive_meta_db is not None:
            result['InitCustomHiveMetaDb'] = self.init_custom_hive_meta_db
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.meta_store_conf is not None:
            result['MetaStoreConf'] = self.meta_store_conf
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.configurations is not None:
            result['Configurations'] = self.configurations
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.id is not None:
            result['Id'] = self.id
        if self.bootstrap_action_list is not None:
            result['BootstrapActionList'] = self.bootstrap_action_list.to_map()
        if self.host_group_list is not None:
            result['HostGroupList'] = self.host_group_list.to_map()
        if self.config_list is not None:
            result['ConfigList'] = self.config_list.to_map()
        if self.software_info_list is not None:
            result['SoftwareInfoList'] = self.software_info_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('LogEnable') is not None:
            self.log_enable = m.get('LogEnable')
        if m.get('SshEnable') is not None:
            self.ssh_enable = m.get('SshEnable')
        if m.get('HighAvailabilityEnable') is not None:
            self.high_availability_enable = m.get('HighAvailabilityEnable')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('IsOpenPublicIp') is not None:
            self.is_open_public_ip = m.get('IsOpenPublicIp')
        if m.get('AllowNotebook') is not None:
            self.allow_notebook = m.get('AllowNotebook')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('InstanceGeneration') is not None:
            self.instance_generation = m.get('InstanceGeneration')
        if m.get('UseCustomHiveMetaDb') is not None:
            self.use_custom_hive_meta_db = m.get('UseCustomHiveMetaDb')
        if m.get('EasEnable') is not None:
            self.eas_enable = m.get('EasEnable')
        if m.get('UserDefinedEmrEcsRole') is not None:
            self.user_defined_emr_ecs_role = m.get('UserDefinedEmrEcsRole')
        if m.get('MetaStoreType') is not None:
            self.meta_store_type = m.get('MetaStoreType')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('UseLocalMetaDb') is not None:
            self.use_local_meta_db = m.get('UseLocalMetaDb')
        if m.get('MasterNodeTotal') is not None:
            self.master_node_total = m.get('MasterNodeTotal')
        if m.get('InitCustomHiveMetaDb') is not None:
            self.init_custom_hive_meta_db = m.get('InitCustomHiveMetaDb')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('MetaStoreConf') is not None:
            self.meta_store_conf = m.get('MetaStoreConf')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('Configurations') is not None:
            self.configurations = m.get('Configurations')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('BootstrapActionList') is not None:
            temp_model = ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoBootstrapActionList()
            self.bootstrap_action_list = temp_model.from_map(m['BootstrapActionList'])
        if m.get('HostGroupList') is not None:
            temp_model = ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoHostGroupList()
            self.host_group_list = temp_model.from_map(m['HostGroupList'])
        if m.get('ConfigList') is not None:
            temp_model = ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoConfigList()
            self.config_list = temp_model.from_map(m['ConfigList'])
        if m.get('SoftwareInfoList') is not None:
            temp_model = ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfoSoftwareInfoList()
            self.software_info_list = temp_model.from_map(m['SoftwareInfoList'])
        return self


class ListClusterTemplatesResponseBodyTemplateInfoList(TeaModel):
    def __init__(
        self,
        template_info: List[ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfo] = None,
    ):
        self.template_info = template_info

    def validate(self):
        if self.template_info:
            for k in self.template_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TemplateInfo'] = []
        if self.template_info is not None:
            for k in self.template_info:
                result['TemplateInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.template_info = []
        if m.get('TemplateInfo') is not None:
            for k in m.get('TemplateInfo'):
                temp_model = ListClusterTemplatesResponseBodyTemplateInfoListTemplateInfo()
                self.template_info.append(temp_model.from_map(k))
        return self


class ListClusterTemplatesResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        total_count: int = None,
        template_info_list: ListClusterTemplatesResponseBodyTemplateInfoList = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.total_count = total_count
        self.template_info_list = template_info_list

    def validate(self):
        if self.template_info_list:
            self.template_info_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.template_info_list is not None:
            result['TemplateInfoList'] = self.template_info_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TemplateInfoList') is not None:
            temp_model = ListClusterTemplatesResponseBodyTemplateInfoList()
            self.template_info_list = temp_model.from_map(m['TemplateInfoList'])
        return self


class ListClusterTemplatesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterTemplatesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterTemplatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClustersRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListClustersRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        create_type: str = None,
        machine_type: str = None,
        is_desc: bool = None,
        deposit_type: str = None,
        page_number: int = None,
        page_size: int = None,
        default_status: bool = None,
        name: str = None,
        resource_group_id: str = None,
        cluster_type_list: List[str] = None,
        status_list: List[str] = None,
        tag: List[ListClustersRequestTag] = None,
        expired_tag_list: List[str] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.create_type = create_type
        self.machine_type = machine_type
        self.is_desc = is_desc
        self.deposit_type = deposit_type
        self.page_number = page_number
        self.page_size = page_size
        self.default_status = default_status
        self.name = name
        self.resource_group_id = resource_group_id
        self.cluster_type_list = cluster_type_list
        self.status_list = status_list
        self.tag = tag
        self.expired_tag_list = expired_tag_list

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.create_type is not None:
            result['CreateType'] = self.create_type
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.is_desc is not None:
            result['IsDesc'] = self.is_desc
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.default_status is not None:
            result['DefaultStatus'] = self.default_status
        if self.name is not None:
            result['Name'] = self.name
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.cluster_type_list is not None:
            result['ClusterTypeList'] = self.cluster_type_list
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.expired_tag_list is not None:
            result['ExpiredTagList'] = self.expired_tag_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('CreateType') is not None:
            self.create_type = m.get('CreateType')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('IsDesc') is not None:
            self.is_desc = m.get('IsDesc')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('DefaultStatus') is not None:
            self.default_status = m.get('DefaultStatus')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ClusterTypeList') is not None:
            self.cluster_type_list = m.get('ClusterTypeList')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = ListClustersRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ExpiredTagList') is not None:
            self.expired_tag_list = m.get('ExpiredTagList')
        return self


class ListClustersResponseBodyClustersClusterInfoTagsTag(TeaModel):
    def __init__(
        self,
        tag_value: str = None,
        tag_key: str = None,
    ):
        self.tag_value = tag_value
        self.tag_key = tag_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class ListClustersResponseBodyClustersClusterInfoTags(TeaModel):
    def __init__(
        self,
        tag: List[ListClustersResponseBodyClustersClusterInfoTagsTag] = None,
    ):
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = ListClustersResponseBodyClustersClusterInfoTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class ListClustersResponseBodyClustersClusterInfoOrderTaskInfo(TeaModel):
    def __init__(
        self,
        target_count: int = None,
        current_count: int = None,
        order_id_list: str = None,
    ):
        self.target_count = target_count
        self.current_count = current_count
        self.order_id_list = order_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_count is not None:
            result['TargetCount'] = self.target_count
        if self.current_count is not None:
            result['CurrentCount'] = self.current_count
        if self.order_id_list is not None:
            result['OrderIdList'] = self.order_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TargetCount') is not None:
            self.target_count = m.get('TargetCount')
        if m.get('CurrentCount') is not None:
            self.current_count = m.get('CurrentCount')
        if m.get('OrderIdList') is not None:
            self.order_id_list = m.get('OrderIdList')
        return self


class ListClustersResponseBodyClustersClusterInfoFailReason(TeaModel):
    def __init__(
        self,
        error_msg: str = None,
        request_id: str = None,
        error_code: str = None,
    ):
        self.error_msg = error_msg
        self.request_id = request_id
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_msg is not None:
            result['ErrorMsg'] = self.error_msg
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMsg') is not None:
            self.error_msg = m.get('ErrorMsg')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class ListClustersResponseBodyClustersClusterInfo(TeaModel):
    def __init__(
        self,
        type: str = None,
        status: str = None,
        running_time: int = None,
        meta_store_type: str = None,
        machine_type: str = None,
        order_list: str = None,
        create_time: int = None,
        charge_type: str = None,
        deposit_type: str = None,
        period: int = None,
        k_8s_cluster_id: str = None,
        expired_time: int = None,
        has_uncompleted_order: bool = None,
        name: str = None,
        create_resource: str = None,
        id: str = None,
        tags: ListClustersResponseBodyClustersClusterInfoTags = None,
        order_task_info: ListClustersResponseBodyClustersClusterInfoOrderTaskInfo = None,
        fail_reason: ListClustersResponseBodyClustersClusterInfoFailReason = None,
    ):
        self.type = type
        self.status = status
        self.running_time = running_time
        self.meta_store_type = meta_store_type
        self.machine_type = machine_type
        self.order_list = order_list
        self.create_time = create_time
        self.charge_type = charge_type
        self.deposit_type = deposit_type
        self.period = period
        self.k_8s_cluster_id = k_8s_cluster_id
        self.expired_time = expired_time
        self.has_uncompleted_order = has_uncompleted_order
        self.name = name
        self.create_resource = create_resource
        self.id = id
        self.tags = tags
        self.order_task_info = order_task_info
        self.fail_reason = fail_reason

    def validate(self):
        if self.tags:
            self.tags.validate()
        if self.order_task_info:
            self.order_task_info.validate()
        if self.fail_reason:
            self.fail_reason.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.status is not None:
            result['Status'] = self.status
        if self.running_time is not None:
            result['RunningTime'] = self.running_time
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.order_list is not None:
            result['OrderList'] = self.order_list
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.period is not None:
            result['Period'] = self.period
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.has_uncompleted_order is not None:
            result['HasUncompletedOrder'] = self.has_uncompleted_order
        if self.name is not None:
            result['Name'] = self.name
        if self.create_resource is not None:
            result['CreateResource'] = self.create_resource
        if self.id is not None:
            result['Id'] = self.id
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.order_task_info is not None:
            result['OrderTaskInfo'] = self.order_task_info.to_map()
        if self.fail_reason is not None:
            result['FailReason'] = self.fail_reason.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('RunningTime') is not None:
            self.running_time = m.get('RunningTime')
        if m.get('MetaStoreType') is not None:
            self.meta_store_type = m.get('MetaStoreType')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('OrderList') is not None:
            self.order_list = m.get('OrderList')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('HasUncompletedOrder') is not None:
            self.has_uncompleted_order = m.get('HasUncompletedOrder')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('CreateResource') is not None:
            self.create_resource = m.get('CreateResource')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Tags') is not None:
            temp_model = ListClustersResponseBodyClustersClusterInfoTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('OrderTaskInfo') is not None:
            temp_model = ListClustersResponseBodyClustersClusterInfoOrderTaskInfo()
            self.order_task_info = temp_model.from_map(m['OrderTaskInfo'])
        if m.get('FailReason') is not None:
            temp_model = ListClustersResponseBodyClustersClusterInfoFailReason()
            self.fail_reason = temp_model.from_map(m['FailReason'])
        return self


class ListClustersResponseBodyClusters(TeaModel):
    def __init__(
        self,
        cluster_info: List[ListClustersResponseBodyClustersClusterInfo] = None,
    ):
        self.cluster_info = cluster_info

    def validate(self):
        if self.cluster_info:
            for k in self.cluster_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterInfo'] = []
        if self.cluster_info is not None:
            for k in self.cluster_info:
                result['ClusterInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_info = []
        if m.get('ClusterInfo') is not None:
            for k in m.get('ClusterInfo'):
                temp_model = ListClustersResponseBodyClustersClusterInfo()
                self.cluster_info.append(temp_model.from_map(k))
        return self


class ListClustersResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        total_count: int = None,
        clusters: ListClustersResponseBodyClusters = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.total_count = total_count
        self.clusters = clusters

    def validate(self):
        if self.clusters:
            self.clusters.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.clusters is not None:
            result['Clusters'] = self.clusters.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Clusters') is not None:
            temp_model = ListClustersResponseBodyClusters()
            self.clusters = temp_model.from_map(m['Clusters'])
        return self


class ListClustersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClustersResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClustersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class TagResourcesSystemTagsRequestTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class TagResourcesSystemTagsRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_type: str = None,
        tag_owner_uid: int = None,
        scope: str = None,
        tags: List[TagResourcesSystemTagsRequestTags] = None,
        resource_ids: List[str] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        # 资源类型：cluster
        self.resource_type = resource_type
        # 主账号UID
        self.tag_owner_uid = tag_owner_uid
        self.scope = scope
        # 资源标签
        self.tags = tags
        # 资源ID
        self.resource_ids = resource_ids

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.tag_owner_uid is not None:
            result['TagOwnerUid'] = self.tag_owner_uid
        if self.scope is not None:
            result['Scope'] = self.scope
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.resource_ids is not None:
            result['ResourceIds'] = self.resource_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('TagOwnerUid') is not None:
            self.tag_owner_uid = m.get('TagOwnerUid')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = TagResourcesSystemTagsRequestTags()
                self.tags.append(temp_model.from_map(k))
        if m.get('ResourceIds') is not None:
            self.resource_ids = m.get('ResourceIds')
        return self


class TagResourcesSystemTagsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_code: str = None,
        message: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 请求是否成功被处理
        self.success = success
        # 响应码
        self.code = code
        # 错误码
        self.error_code = error_code
        # 响应消息
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class TagResourcesSystemTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: TagResourcesSystemTagsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = TagResourcesSystemTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyFlowJobRequestResourceList(TeaModel):
    def __init__(
        self,
        path: str = None,
        alias: str = None,
    ):
        self.path = path
        self.alias = alias

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.alias is not None:
            result['Alias'] = self.alias
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        return self


class ModifyFlowJobRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        id: str = None,
        name: str = None,
        description: str = None,
        fail_act: str = None,
        retry_policy: str = None,
        params: str = None,
        param_conf: str = None,
        custom_variables: str = None,
        env_conf: str = None,
        run_conf: str = None,
        monitor_conf: str = None,
        mode: str = None,
        cluster_id: str = None,
        alert_conf: str = None,
        resource_list: List[ModifyFlowJobRequestResourceList] = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.id = id
        self.name = name
        self.description = description
        self.fail_act = fail_act
        self.retry_policy = retry_policy
        self.params = params
        self.param_conf = param_conf
        self.custom_variables = custom_variables
        self.env_conf = env_conf
        self.run_conf = run_conf
        self.monitor_conf = monitor_conf
        self.mode = mode
        self.cluster_id = cluster_id
        self.alert_conf = alert_conf
        self.resource_list = resource_list

    def validate(self):
        if self.resource_list:
            for k in self.resource_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.fail_act is not None:
            result['FailAct'] = self.fail_act
        if self.retry_policy is not None:
            result['RetryPolicy'] = self.retry_policy
        if self.params is not None:
            result['Params'] = self.params
        if self.param_conf is not None:
            result['ParamConf'] = self.param_conf
        if self.custom_variables is not None:
            result['CustomVariables'] = self.custom_variables
        if self.env_conf is not None:
            result['EnvConf'] = self.env_conf
        if self.run_conf is not None:
            result['RunConf'] = self.run_conf
        if self.monitor_conf is not None:
            result['MonitorConf'] = self.monitor_conf
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        result['ResourceList'] = []
        if self.resource_list is not None:
            for k in self.resource_list:
                result['ResourceList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FailAct') is not None:
            self.fail_act = m.get('FailAct')
        if m.get('RetryPolicy') is not None:
            self.retry_policy = m.get('RetryPolicy')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('ParamConf') is not None:
            self.param_conf = m.get('ParamConf')
        if m.get('CustomVariables') is not None:
            self.custom_variables = m.get('CustomVariables')
        if m.get('EnvConf') is not None:
            self.env_conf = m.get('EnvConf')
        if m.get('RunConf') is not None:
            self.run_conf = m.get('RunConf')
        if m.get('MonitorConf') is not None:
            self.monitor_conf = m.get('MonitorConf')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        self.resource_list = []
        if m.get('ResourceList') is not None:
            for k in m.get('ResourceList'):
                temp_model = ModifyFlowJobRequestResourceList()
                self.resource_list.append(temp_model.from_map(k))
        return self


class ModifyFlowJobResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyFlowJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyFlowJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyFlowJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        project_id: str = None,
        region_id: str = None,
    ):
        self.id = id
        self.project_id = project_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteFlowResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteFlowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteFlowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowEditLockRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        entity_id: str = None,
        force: bool = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.entity_id = entity_id
        self.force = force

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.force is not None:
            result['Force'] = self.force
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('Force') is not None:
            self.force = m.get('Force')
        return self


class CreateFlowEditLockResponseBody(TeaModel):
    def __init__(
        self,
        status: str = None,
        request_id: str = None,
        entity_id: str = None,
        user_id: str = None,
        biz_id: str = None,
        owner_id: str = None,
    ):
        self.status = status
        self.request_id = request_id
        self.entity_id = entity_id
        self.user_id = user_id
        self.biz_id = biz_id
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class CreateFlowEditLockResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFlowEditLockResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowEditLockResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowNodeInstanceRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        id: str = None,
        region_id: str = None,
    ):
        self.project_id = project_id
        self.id = id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowNodeInstanceResponseBody(TeaModel):
    def __init__(
        self,
        status: str = None,
        type: str = None,
        env_conf: str = None,
        project_id: str = None,
        retry_interval: str = None,
        job_type: str = None,
        mode: str = None,
        external_info: str = None,
        gmt_modified: int = None,
        external_child_ids: str = None,
        monitor_conf: str = None,
        external_status: str = None,
        request_id: str = None,
        job_name: str = None,
        retry_policy: str = None,
        adhoc: bool = None,
        external_id: str = None,
        pending: bool = None,
        cluster_id: str = None,
        max_retry: str = None,
        fail_act: str = None,
        job_params: str = None,
        flow_instance_id: str = None,
        param_conf: str = None,
        host_name: str = None,
        flow_id: str = None,
        retries: int = None,
        end_time: int = None,
        start_time: int = None,
        run_conf: str = None,
        external_sub_id: str = None,
        node_name: str = None,
        job_id: str = None,
        cluster_name: str = None,
        gmt_create: int = None,
        duration: int = None,
        id: str = None,
    ):
        self.status = status
        self.type = type
        self.env_conf = env_conf
        self.project_id = project_id
        self.retry_interval = retry_interval
        self.job_type = job_type
        self.mode = mode
        self.external_info = external_info
        self.gmt_modified = gmt_modified
        self.external_child_ids = external_child_ids
        self.monitor_conf = monitor_conf
        self.external_status = external_status
        self.request_id = request_id
        self.job_name = job_name
        self.retry_policy = retry_policy
        self.adhoc = adhoc
        self.external_id = external_id
        self.pending = pending
        self.cluster_id = cluster_id
        self.max_retry = max_retry
        self.fail_act = fail_act
        self.job_params = job_params
        self.flow_instance_id = flow_instance_id
        self.param_conf = param_conf
        self.host_name = host_name
        self.flow_id = flow_id
        self.retries = retries
        self.end_time = end_time
        self.start_time = start_time
        self.run_conf = run_conf
        self.external_sub_id = external_sub_id
        self.node_name = node_name
        self.job_id = job_id
        self.cluster_name = cluster_name
        self.gmt_create = gmt_create
        self.duration = duration
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.env_conf is not None:
            result['EnvConf'] = self.env_conf
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.external_info is not None:
            result['ExternalInfo'] = self.external_info
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.external_child_ids is not None:
            result['ExternalChildIds'] = self.external_child_ids
        if self.monitor_conf is not None:
            result['MonitorConf'] = self.monitor_conf
        if self.external_status is not None:
            result['ExternalStatus'] = self.external_status
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.retry_policy is not None:
            result['RetryPolicy'] = self.retry_policy
        if self.adhoc is not None:
            result['Adhoc'] = self.adhoc
        if self.external_id is not None:
            result['ExternalId'] = self.external_id
        if self.pending is not None:
            result['Pending'] = self.pending
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.max_retry is not None:
            result['MaxRetry'] = self.max_retry
        if self.fail_act is not None:
            result['FailAct'] = self.fail_act
        if self.job_params is not None:
            result['JobParams'] = self.job_params
        if self.flow_instance_id is not None:
            result['FlowInstanceId'] = self.flow_instance_id
        if self.param_conf is not None:
            result['ParamConf'] = self.param_conf
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.retries is not None:
            result['Retries'] = self.retries
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.run_conf is not None:
            result['RunConf'] = self.run_conf
        if self.external_sub_id is not None:
            result['ExternalSubId'] = self.external_sub_id
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('EnvConf') is not None:
            self.env_conf = m.get('EnvConf')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('ExternalInfo') is not None:
            self.external_info = m.get('ExternalInfo')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ExternalChildIds') is not None:
            self.external_child_ids = m.get('ExternalChildIds')
        if m.get('MonitorConf') is not None:
            self.monitor_conf = m.get('MonitorConf')
        if m.get('ExternalStatus') is not None:
            self.external_status = m.get('ExternalStatus')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('RetryPolicy') is not None:
            self.retry_policy = m.get('RetryPolicy')
        if m.get('Adhoc') is not None:
            self.adhoc = m.get('Adhoc')
        if m.get('ExternalId') is not None:
            self.external_id = m.get('ExternalId')
        if m.get('Pending') is not None:
            self.pending = m.get('Pending')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('MaxRetry') is not None:
            self.max_retry = m.get('MaxRetry')
        if m.get('FailAct') is not None:
            self.fail_act = m.get('FailAct')
        if m.get('JobParams') is not None:
            self.job_params = m.get('JobParams')
        if m.get('FlowInstanceId') is not None:
            self.flow_instance_id = m.get('FlowInstanceId')
        if m.get('ParamConf') is not None:
            self.param_conf = m.get('ParamConf')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('Retries') is not None:
            self.retries = m.get('Retries')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('RunConf') is not None:
            self.run_conf = m.get('RunConf')
        if m.get('ExternalSubId') is not None:
            self.external_sub_id = m.get('ExternalSubId')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeFlowNodeInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowNodeInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowNodeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DetachAndReleaseClusterEniRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        target_cluster_id: str = None,
        vswitch_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.target_cluster_id = target_cluster_id
        self.vswitch_id = vswitch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.target_cluster_id is not None:
            result['TargetClusterId'] = self.target_cluster_id
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TargetClusterId') is not None:
            self.target_cluster_id = m.get('TargetClusterId')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        return self


class DetachAndReleaseClusterEniResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DetachAndReleaseClusterEniResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DetachAndReleaseClusterEniResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DetachAndReleaseClusterEniResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScalingGroupInstanceRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        scaling_group_biz_id: str = None,
        host_group_biz_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.scaling_group_biz_id = scaling_group_biz_id
        self.host_group_biz_id = host_group_biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.host_group_biz_id is not None:
            result['HostGroupBizId'] = self.host_group_biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('HostGroupBizId') is not None:
            self.host_group_biz_id = m.get('HostGroupBizId')
        return self


class DescribeScalingGroupInstanceResponseBodyScalingConfigInstanceTypeList(TeaModel):
    def __init__(
        self,
        instance_type_list: List[str] = None,
    ):
        self.instance_type_list = instance_type_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type_list is not None:
            result['instanceTypeList'] = self.instance_type_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('instanceTypeList') is not None:
            self.instance_type_list = m.get('instanceTypeList')
        return self


class DescribeScalingGroupInstanceResponseBodyScalingConfigSpotPriceLimitsSpotPriceLimits(TeaModel):
    def __init__(
        self,
        instance_type: str = None,
        price_limit: float = None,
    ):
        self.instance_type = instance_type
        self.price_limit = price_limit

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.price_limit is not None:
            result['PriceLimit'] = self.price_limit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('PriceLimit') is not None:
            self.price_limit = m.get('PriceLimit')
        return self


class DescribeScalingGroupInstanceResponseBodyScalingConfigSpotPriceLimits(TeaModel):
    def __init__(
        self,
        spot_price_limits: List[DescribeScalingGroupInstanceResponseBodyScalingConfigSpotPriceLimitsSpotPriceLimits] = None,
    ):
        self.spot_price_limits = spot_price_limits

    def validate(self):
        if self.spot_price_limits:
            for k in self.spot_price_limits:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['spotPriceLimits'] = []
        if self.spot_price_limits is not None:
            for k in self.spot_price_limits:
                result['spotPriceLimits'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.spot_price_limits = []
        if m.get('spotPriceLimits') is not None:
            for k in m.get('spotPriceLimits'):
                temp_model = DescribeScalingGroupInstanceResponseBodyScalingConfigSpotPriceLimitsSpotPriceLimits()
                self.spot_price_limits.append(temp_model.from_map(k))
        return self


class DescribeScalingGroupInstanceResponseBodyScalingConfig(TeaModel):
    def __init__(
        self,
        spot_strategy: str = None,
        pay_type: str = None,
        data_disk_category: str = None,
        data_disk_size: int = None,
        data_disk_count: int = None,
        sys_disk_category: str = None,
        sys_disk_size: int = None,
        instance_type_list: DescribeScalingGroupInstanceResponseBodyScalingConfigInstanceTypeList = None,
        spot_price_limits: DescribeScalingGroupInstanceResponseBodyScalingConfigSpotPriceLimits = None,
    ):
        self.spot_strategy = spot_strategy
        self.pay_type = pay_type
        self.data_disk_category = data_disk_category
        self.data_disk_size = data_disk_size
        self.data_disk_count = data_disk_count
        self.sys_disk_category = sys_disk_category
        self.sys_disk_size = sys_disk_size
        self.instance_type_list = instance_type_list
        self.spot_price_limits = spot_price_limits

    def validate(self):
        if self.instance_type_list:
            self.instance_type_list.validate()
        if self.spot_price_limits:
            self.spot_price_limits.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.data_disk_category is not None:
            result['DataDiskCategory'] = self.data_disk_category
        if self.data_disk_size is not None:
            result['DataDiskSize'] = self.data_disk_size
        if self.data_disk_count is not None:
            result['DataDiskCount'] = self.data_disk_count
        if self.sys_disk_category is not None:
            result['SysDiskCategory'] = self.sys_disk_category
        if self.sys_disk_size is not None:
            result['SysDiskSize'] = self.sys_disk_size
        if self.instance_type_list is not None:
            result['InstanceTypeList'] = self.instance_type_list.to_map()
        if self.spot_price_limits is not None:
            result['SpotPriceLimits'] = self.spot_price_limits.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('DataDiskCategory') is not None:
            self.data_disk_category = m.get('DataDiskCategory')
        if m.get('DataDiskSize') is not None:
            self.data_disk_size = m.get('DataDiskSize')
        if m.get('DataDiskCount') is not None:
            self.data_disk_count = m.get('DataDiskCount')
        if m.get('SysDiskCategory') is not None:
            self.sys_disk_category = m.get('SysDiskCategory')
        if m.get('SysDiskSize') is not None:
            self.sys_disk_size = m.get('SysDiskSize')
        if m.get('InstanceTypeList') is not None:
            temp_model = DescribeScalingGroupInstanceResponseBodyScalingConfigInstanceTypeList()
            self.instance_type_list = temp_model.from_map(m['InstanceTypeList'])
        if m.get('SpotPriceLimits') is not None:
            temp_model = DescribeScalingGroupInstanceResponseBodyScalingConfigSpotPriceLimits()
            self.spot_price_limits = temp_model.from_map(m['SpotPriceLimits'])
        return self


class DescribeScalingGroupInstanceResponseBodyScalingRuleListScalingRuleSchedulerTrigger(TeaModel):
    def __init__(
        self,
        launch_time: int = None,
        launch_expiration_time: int = None,
        recurrence_type: str = None,
        recurrence_value: str = None,
        recurrence_end_time: int = None,
    ):
        self.launch_time = launch_time
        self.launch_expiration_time = launch_expiration_time
        self.recurrence_type = recurrence_type
        self.recurrence_value = recurrence_value
        self.recurrence_end_time = recurrence_end_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.launch_time is not None:
            result['LaunchTime'] = self.launch_time
        if self.launch_expiration_time is not None:
            result['LaunchExpirationTime'] = self.launch_expiration_time
        if self.recurrence_type is not None:
            result['RecurrenceType'] = self.recurrence_type
        if self.recurrence_value is not None:
            result['RecurrenceValue'] = self.recurrence_value
        if self.recurrence_end_time is not None:
            result['RecurrenceEndTime'] = self.recurrence_end_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LaunchTime') is not None:
            self.launch_time = m.get('LaunchTime')
        if m.get('LaunchExpirationTime') is not None:
            self.launch_expiration_time = m.get('LaunchExpirationTime')
        if m.get('RecurrenceType') is not None:
            self.recurrence_type = m.get('RecurrenceType')
        if m.get('RecurrenceValue') is not None:
            self.recurrence_value = m.get('RecurrenceValue')
        if m.get('RecurrenceEndTime') is not None:
            self.recurrence_end_time = m.get('RecurrenceEndTime')
        return self


class DescribeScalingGroupInstanceResponseBodyScalingRuleListScalingRuleCloudWatchTrigger(TeaModel):
    def __init__(
        self,
        metric_name: str = None,
        period: int = None,
        statistics: str = None,
        comparison_operator: str = None,
        threshold: str = None,
        evaluation_count: str = None,
        unit: str = None,
        metric_display_name: str = None,
    ):
        self.metric_name = metric_name
        self.period = period
        self.statistics = statistics
        self.comparison_operator = comparison_operator
        self.threshold = threshold
        self.evaluation_count = evaluation_count
        self.unit = unit
        self.metric_display_name = metric_display_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_name is not None:
            result['MetricName'] = self.metric_name
        if self.period is not None:
            result['Period'] = self.period
        if self.statistics is not None:
            result['Statistics'] = self.statistics
        if self.comparison_operator is not None:
            result['ComparisonOperator'] = self.comparison_operator
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.metric_display_name is not None:
            result['MetricDisplayName'] = self.metric_display_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MetricName') is not None:
            self.metric_name = m.get('MetricName')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Statistics') is not None:
            self.statistics = m.get('Statistics')
        if m.get('ComparisonOperator') is not None:
            self.comparison_operator = m.get('ComparisonOperator')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('MetricDisplayName') is not None:
            self.metric_display_name = m.get('MetricDisplayName')
        return self


class DescribeScalingGroupInstanceResponseBodyScalingRuleListScalingRule(TeaModel):
    def __init__(
        self,
        rule_category: str = None,
        ess_scaling_rule_id: str = None,
        scaling_group_id: int = None,
        rule_name: str = None,
        adjustment_type: str = None,
        adjustment_value: int = None,
        cooldown: int = None,
        status: str = None,
        launch_time: str = None,
        launch_expiration_time: int = None,
        recurrence_type: str = None,
        recurrence_value: str = None,
        recurrence_end_time: str = None,
        with_grace: bool = None,
        timeout_with_grace: int = None,
        scheduler_trigger: DescribeScalingGroupInstanceResponseBodyScalingRuleListScalingRuleSchedulerTrigger = None,
        cloud_watch_trigger: DescribeScalingGroupInstanceResponseBodyScalingRuleListScalingRuleCloudWatchTrigger = None,
    ):
        self.rule_category = rule_category
        self.ess_scaling_rule_id = ess_scaling_rule_id
        self.scaling_group_id = scaling_group_id
        self.rule_name = rule_name
        self.adjustment_type = adjustment_type
        self.adjustment_value = adjustment_value
        self.cooldown = cooldown
        self.status = status
        self.launch_time = launch_time
        self.launch_expiration_time = launch_expiration_time
        self.recurrence_type = recurrence_type
        self.recurrence_value = recurrence_value
        self.recurrence_end_time = recurrence_end_time
        self.with_grace = with_grace
        self.timeout_with_grace = timeout_with_grace
        self.scheduler_trigger = scheduler_trigger
        self.cloud_watch_trigger = cloud_watch_trigger

    def validate(self):
        if self.scheduler_trigger:
            self.scheduler_trigger.validate()
        if self.cloud_watch_trigger:
            self.cloud_watch_trigger.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_category is not None:
            result['RuleCategory'] = self.rule_category
        if self.ess_scaling_rule_id is not None:
            result['EssScalingRuleId'] = self.ess_scaling_rule_id
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.adjustment_type is not None:
            result['AdjustmentType'] = self.adjustment_type
        if self.adjustment_value is not None:
            result['AdjustmentValue'] = self.adjustment_value
        if self.cooldown is not None:
            result['Cooldown'] = self.cooldown
        if self.status is not None:
            result['Status'] = self.status
        if self.launch_time is not None:
            result['LaunchTime'] = self.launch_time
        if self.launch_expiration_time is not None:
            result['LaunchExpirationTime'] = self.launch_expiration_time
        if self.recurrence_type is not None:
            result['RecurrenceType'] = self.recurrence_type
        if self.recurrence_value is not None:
            result['RecurrenceValue'] = self.recurrence_value
        if self.recurrence_end_time is not None:
            result['RecurrenceEndTime'] = self.recurrence_end_time
        if self.with_grace is not None:
            result['WithGrace'] = self.with_grace
        if self.timeout_with_grace is not None:
            result['TimeoutWithGrace'] = self.timeout_with_grace
        if self.scheduler_trigger is not None:
            result['SchedulerTrigger'] = self.scheduler_trigger.to_map()
        if self.cloud_watch_trigger is not None:
            result['CloudWatchTrigger'] = self.cloud_watch_trigger.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleCategory') is not None:
            self.rule_category = m.get('RuleCategory')
        if m.get('EssScalingRuleId') is not None:
            self.ess_scaling_rule_id = m.get('EssScalingRuleId')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('AdjustmentType') is not None:
            self.adjustment_type = m.get('AdjustmentType')
        if m.get('AdjustmentValue') is not None:
            self.adjustment_value = m.get('AdjustmentValue')
        if m.get('Cooldown') is not None:
            self.cooldown = m.get('Cooldown')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('LaunchTime') is not None:
            self.launch_time = m.get('LaunchTime')
        if m.get('LaunchExpirationTime') is not None:
            self.launch_expiration_time = m.get('LaunchExpirationTime')
        if m.get('RecurrenceType') is not None:
            self.recurrence_type = m.get('RecurrenceType')
        if m.get('RecurrenceValue') is not None:
            self.recurrence_value = m.get('RecurrenceValue')
        if m.get('RecurrenceEndTime') is not None:
            self.recurrence_end_time = m.get('RecurrenceEndTime')
        if m.get('WithGrace') is not None:
            self.with_grace = m.get('WithGrace')
        if m.get('TimeoutWithGrace') is not None:
            self.timeout_with_grace = m.get('TimeoutWithGrace')
        if m.get('SchedulerTrigger') is not None:
            temp_model = DescribeScalingGroupInstanceResponseBodyScalingRuleListScalingRuleSchedulerTrigger()
            self.scheduler_trigger = temp_model.from_map(m['SchedulerTrigger'])
        if m.get('CloudWatchTrigger') is not None:
            temp_model = DescribeScalingGroupInstanceResponseBodyScalingRuleListScalingRuleCloudWatchTrigger()
            self.cloud_watch_trigger = temp_model.from_map(m['CloudWatchTrigger'])
        return self


class DescribeScalingGroupInstanceResponseBodyScalingRuleList(TeaModel):
    def __init__(
        self,
        scaling_rule: List[DescribeScalingGroupInstanceResponseBodyScalingRuleListScalingRule] = None,
    ):
        self.scaling_rule = scaling_rule

    def validate(self):
        if self.scaling_rule:
            for k in self.scaling_rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ScalingRule'] = []
        if self.scaling_rule is not None:
            for k in self.scaling_rule:
                result['ScalingRule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.scaling_rule = []
        if m.get('ScalingRule') is not None:
            for k in m.get('ScalingRule'):
                temp_model = DescribeScalingGroupInstanceResponseBodyScalingRuleListScalingRule()
                self.scaling_rule.append(temp_model.from_map(k))
        return self


class DescribeScalingGroupInstanceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        host_group_id: str = None,
        scaling_group_id: str = None,
        min_size: int = None,
        max_size: int = None,
        default_cooldown: int = None,
        active_rule_category: str = None,
        with_grace: bool = None,
        timeout_with_grace: int = None,
        multi_available_policy: str = None,
        multi_available_policy_param: str = None,
        scaling_config: DescribeScalingGroupInstanceResponseBodyScalingConfig = None,
        scaling_rule_list: DescribeScalingGroupInstanceResponseBodyScalingRuleList = None,
    ):
        # Id of the request
        self.request_id = request_id
        self.host_group_id = host_group_id
        self.scaling_group_id = scaling_group_id
        self.min_size = min_size
        self.max_size = max_size
        self.default_cooldown = default_cooldown
        self.active_rule_category = active_rule_category
        self.with_grace = with_grace
        self.timeout_with_grace = timeout_with_grace
        self.multi_available_policy = multi_available_policy
        self.multi_available_policy_param = multi_available_policy_param
        self.scaling_config = scaling_config
        self.scaling_rule_list = scaling_rule_list

    def validate(self):
        if self.scaling_config:
            self.scaling_config.validate()
        if self.scaling_rule_list:
            self.scaling_rule_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.scaling_group_id is not None:
            result['ScalingGroupId'] = self.scaling_group_id
        if self.min_size is not None:
            result['MinSize'] = self.min_size
        if self.max_size is not None:
            result['MaxSize'] = self.max_size
        if self.default_cooldown is not None:
            result['DefaultCooldown'] = self.default_cooldown
        if self.active_rule_category is not None:
            result['ActiveRuleCategory'] = self.active_rule_category
        if self.with_grace is not None:
            result['WithGrace'] = self.with_grace
        if self.timeout_with_grace is not None:
            result['TimeoutWithGrace'] = self.timeout_with_grace
        if self.multi_available_policy is not None:
            result['MultiAvailablePolicy'] = self.multi_available_policy
        if self.multi_available_policy_param is not None:
            result['MultiAvailablePolicyParam'] = self.multi_available_policy_param
        if self.scaling_config is not None:
            result['ScalingConfig'] = self.scaling_config.to_map()
        if self.scaling_rule_list is not None:
            result['ScalingRuleList'] = self.scaling_rule_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('ScalingGroupId') is not None:
            self.scaling_group_id = m.get('ScalingGroupId')
        if m.get('MinSize') is not None:
            self.min_size = m.get('MinSize')
        if m.get('MaxSize') is not None:
            self.max_size = m.get('MaxSize')
        if m.get('DefaultCooldown') is not None:
            self.default_cooldown = m.get('DefaultCooldown')
        if m.get('ActiveRuleCategory') is not None:
            self.active_rule_category = m.get('ActiveRuleCategory')
        if m.get('WithGrace') is not None:
            self.with_grace = m.get('WithGrace')
        if m.get('TimeoutWithGrace') is not None:
            self.timeout_with_grace = m.get('TimeoutWithGrace')
        if m.get('MultiAvailablePolicy') is not None:
            self.multi_available_policy = m.get('MultiAvailablePolicy')
        if m.get('MultiAvailablePolicyParam') is not None:
            self.multi_available_policy_param = m.get('MultiAvailablePolicyParam')
        if m.get('ScalingConfig') is not None:
            temp_model = DescribeScalingGroupInstanceResponseBodyScalingConfig()
            self.scaling_config = temp_model.from_map(m['ScalingConfig'])
        if m.get('ScalingRuleList') is not None:
            temp_model = DescribeScalingGroupInstanceResponseBodyScalingRuleList()
            self.scaling_rule_list = temp_model.from_map(m['ScalingRuleList'])
        return self


class DescribeScalingGroupInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeScalingGroupInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeScalingGroupInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateClusterHostGroupRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        host_group_name: str = None,
        host_group_type: str = None,
        comment: str = None,
        pay_type: str = None,
        vswitch_id: str = None,
        security_group_id: str = None,
        host_group_params: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.host_group_name = host_group_name
        self.host_group_type = host_group_type
        self.comment = comment
        self.pay_type = pay_type
        self.vswitch_id = vswitch_id
        self.security_group_id = security_group_id
        self.host_group_params = host_group_params

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.pay_type is not None:
            result['PayType'] = self.pay_type
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.host_group_params is not None:
            result['HostGroupParams'] = self.host_group_params
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('PayType') is not None:
            self.pay_type = m.get('PayType')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('HostGroupParams') is not None:
            self.host_group_params = m.get('HostGroupParams')
        return self


class CreateClusterHostGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        cluster_id: str = None,
        host_group_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        self.cluster_id = cluster_id
        self.host_group_id = host_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        return self


class CreateClusterHostGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateClusterHostGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateClusterHostGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterTemplateRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        biz_id: str = None,
        resource_group_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.biz_id = biz_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoBootstrapActionListBootstrapAction(TeaModel):
    def __init__(
        self,
        path: str = None,
        name: str = None,
        arg: str = None,
    ):
        self.path = path
        self.name = name
        self.arg = arg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.name is not None:
            result['Name'] = self.name
        if self.arg is not None:
            result['Arg'] = self.arg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Arg') is not None:
            self.arg = m.get('Arg')
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoBootstrapActionList(TeaModel):
    def __init__(
        self,
        bootstrap_action: List[DescribeClusterTemplateResponseBodyTemplateInfoBootstrapActionListBootstrapAction] = None,
    ):
        self.bootstrap_action = bootstrap_action

    def validate(self):
        if self.bootstrap_action:
            for k in self.bootstrap_action:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BootstrapAction'] = []
        if self.bootstrap_action is not None:
            for k in self.bootstrap_action:
                result['BootstrapAction'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bootstrap_action = []
        if m.get('BootstrapAction') is not None:
            for k in m.get('BootstrapAction'):
                temp_model = DescribeClusterTemplateResponseBodyTemplateInfoBootstrapActionListBootstrapAction()
                self.bootstrap_action.append(temp_model.from_map(k))
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoHostGroupListHostGroup(TeaModel):
    def __init__(
        self,
        sys_disk_capacity: int = None,
        host_group_type: str = None,
        multi_instance_types: str = None,
        sys_disk_type: str = None,
        charge_type: str = None,
        disk_type: str = None,
        host_group_id: str = None,
        instance_type: str = None,
        disk_count: int = None,
        period: str = None,
        disk_capacity: int = None,
        node_count: int = None,
        host_group_name: str = None,
    ):
        self.sys_disk_capacity = sys_disk_capacity
        self.host_group_type = host_group_type
        self.multi_instance_types = multi_instance_types
        self.sys_disk_type = sys_disk_type
        self.charge_type = charge_type
        self.disk_type = disk_type
        self.host_group_id = host_group_id
        self.instance_type = instance_type
        self.disk_count = disk_count
        self.period = period
        self.disk_capacity = disk_capacity
        self.node_count = node_count
        self.host_group_name = host_group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sys_disk_capacity is not None:
            result['SysDiskCapacity'] = self.sys_disk_capacity
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.multi_instance_types is not None:
            result['MultiInstanceTypes'] = self.multi_instance_types
        if self.sys_disk_type is not None:
            result['SysDiskType'] = self.sys_disk_type
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        if self.period is not None:
            result['Period'] = self.period
        if self.disk_capacity is not None:
            result['DiskCapacity'] = self.disk_capacity
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SysDiskCapacity') is not None:
            self.sys_disk_capacity = m.get('SysDiskCapacity')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('MultiInstanceTypes') is not None:
            self.multi_instance_types = m.get('MultiInstanceTypes')
        if m.get('SysDiskType') is not None:
            self.sys_disk_type = m.get('SysDiskType')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('DiskCapacity') is not None:
            self.disk_capacity = m.get('DiskCapacity')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoHostGroupList(TeaModel):
    def __init__(
        self,
        host_group: List[DescribeClusterTemplateResponseBodyTemplateInfoHostGroupListHostGroup] = None,
    ):
        self.host_group = host_group

    def validate(self):
        if self.host_group:
            for k in self.host_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HostGroup'] = []
        if self.host_group is not None:
            for k in self.host_group:
                result['HostGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.host_group = []
        if m.get('HostGroup') is not None:
            for k in m.get('HostGroup'):
                temp_model = DescribeClusterTemplateResponseBodyTemplateInfoHostGroupListHostGroup()
                self.host_group.append(temp_model.from_map(k))
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoConfigListConfig(TeaModel):
    def __init__(
        self,
        config_value: str = None,
        replace: str = None,
        file_name: str = None,
        service_name: str = None,
        config_key: str = None,
        encrypt: str = None,
    ):
        self.config_value = config_value
        self.replace = replace
        self.file_name = file_name
        self.service_name = service_name
        self.config_key = config_key
        self.encrypt = encrypt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        if self.replace is not None:
            result['Replace'] = self.replace
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_key is not None:
            result['ConfigKey'] = self.config_key
        if self.encrypt is not None:
            result['Encrypt'] = self.encrypt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        if m.get('Replace') is not None:
            self.replace = m.get('Replace')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigKey') is not None:
            self.config_key = m.get('ConfigKey')
        if m.get('Encrypt') is not None:
            self.encrypt = m.get('Encrypt')
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoConfigList(TeaModel):
    def __init__(
        self,
        config: List[DescribeClusterTemplateResponseBodyTemplateInfoConfigListConfig] = None,
    ):
        self.config = config

    def validate(self):
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = DescribeClusterTemplateResponseBodyTemplateInfoConfigListConfig()
                self.config.append(temp_model.from_map(k))
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoTagsTag(TeaModel):
    def __init__(
        self,
        tag_value: str = None,
        tag_key: str = None,
    ):
        self.tag_value = tag_value
        self.tag_key = tag_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoTags(TeaModel):
    def __init__(
        self,
        tag: List[DescribeClusterTemplateResponseBodyTemplateInfoTagsTag] = None,
    ):
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeClusterTemplateResponseBodyTemplateInfoTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeClusterTemplateResponseBodyTemplateInfoSoftwareInfoList(TeaModel):
    def __init__(
        self,
        software_info: List[str] = None,
    ):
        self.software_info = software_info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.software_info is not None:
            result['SoftwareInfo'] = self.software_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SoftwareInfo') is not None:
            self.software_info = m.get('SoftwareInfo')
        return self


class DescribeClusterTemplateResponseBodyTemplateInfo(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
        key_pair_name: str = None,
        log_enable: bool = None,
        ssh_enable: bool = None,
        high_availability_enable: bool = None,
        security_group_id: str = None,
        master_pwd: str = None,
        user_id: str = None,
        is_open_public_ip: bool = None,
        allow_notebook: bool = None,
        gmt_modified: int = None,
        template_name: str = None,
        deposit_type: str = None,
        security_group_name: str = None,
        create_source: str = None,
        instance_generation: str = None,
        use_custom_hive_meta_db: bool = None,
        eas_enable: bool = None,
        user_defined_emr_ecs_role: str = None,
        meta_store_type: str = None,
        machine_type: str = None,
        use_local_meta_db: bool = None,
        master_node_total: int = None,
        init_custom_hive_meta_db: bool = None,
        io_optimized: bool = None,
        meta_store_conf: str = None,
        v_switch_id: str = None,
        configurations: str = None,
        emr_ver: str = None,
        log_path: str = None,
        cluster_type: str = None,
        net_type: str = None,
        zone_id: str = None,
        gmt_create: int = None,
        id: str = None,
        bootstrap_action_list: DescribeClusterTemplateResponseBodyTemplateInfoBootstrapActionList = None,
        host_group_list: DescribeClusterTemplateResponseBodyTemplateInfoHostGroupList = None,
        config_list: DescribeClusterTemplateResponseBodyTemplateInfoConfigList = None,
        tags: DescribeClusterTemplateResponseBodyTemplateInfoTags = None,
        software_info_list: DescribeClusterTemplateResponseBodyTemplateInfoSoftwareInfoList = None,
    ):
        self.vpc_id = vpc_id
        self.key_pair_name = key_pair_name
        self.log_enable = log_enable
        self.ssh_enable = ssh_enable
        self.high_availability_enable = high_availability_enable
        self.security_group_id = security_group_id
        self.master_pwd = master_pwd
        self.user_id = user_id
        self.is_open_public_ip = is_open_public_ip
        self.allow_notebook = allow_notebook
        self.gmt_modified = gmt_modified
        self.template_name = template_name
        self.deposit_type = deposit_type
        self.security_group_name = security_group_name
        self.create_source = create_source
        self.instance_generation = instance_generation
        self.use_custom_hive_meta_db = use_custom_hive_meta_db
        self.eas_enable = eas_enable
        self.user_defined_emr_ecs_role = user_defined_emr_ecs_role
        self.meta_store_type = meta_store_type
        self.machine_type = machine_type
        self.use_local_meta_db = use_local_meta_db
        self.master_node_total = master_node_total
        self.init_custom_hive_meta_db = init_custom_hive_meta_db
        self.io_optimized = io_optimized
        self.meta_store_conf = meta_store_conf
        self.v_switch_id = v_switch_id
        self.configurations = configurations
        self.emr_ver = emr_ver
        self.log_path = log_path
        self.cluster_type = cluster_type
        self.net_type = net_type
        self.zone_id = zone_id
        self.gmt_create = gmt_create
        self.id = id
        self.bootstrap_action_list = bootstrap_action_list
        self.host_group_list = host_group_list
        self.config_list = config_list
        self.tags = tags
        self.software_info_list = software_info_list

    def validate(self):
        if self.bootstrap_action_list:
            self.bootstrap_action_list.validate()
        if self.host_group_list:
            self.host_group_list.validate()
        if self.config_list:
            self.config_list.validate()
        if self.tags:
            self.tags.validate()
        if self.software_info_list:
            self.software_info_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.log_enable is not None:
            result['LogEnable'] = self.log_enable
        if self.ssh_enable is not None:
            result['SshEnable'] = self.ssh_enable
        if self.high_availability_enable is not None:
            result['HighAvailabilityEnable'] = self.high_availability_enable
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.master_pwd is not None:
            result['MasterPwd'] = self.master_pwd
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.is_open_public_ip is not None:
            result['IsOpenPublicIp'] = self.is_open_public_ip
        if self.allow_notebook is not None:
            result['AllowNotebook'] = self.allow_notebook
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.template_name is not None:
            result['TemplateName'] = self.template_name
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        if self.create_source is not None:
            result['CreateSource'] = self.create_source
        if self.instance_generation is not None:
            result['InstanceGeneration'] = self.instance_generation
        if self.use_custom_hive_meta_db is not None:
            result['UseCustomHiveMetaDb'] = self.use_custom_hive_meta_db
        if self.eas_enable is not None:
            result['EasEnable'] = self.eas_enable
        if self.user_defined_emr_ecs_role is not None:
            result['UserDefinedEmrEcsRole'] = self.user_defined_emr_ecs_role
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.use_local_meta_db is not None:
            result['UseLocalMetaDb'] = self.use_local_meta_db
        if self.master_node_total is not None:
            result['MasterNodeTotal'] = self.master_node_total
        if self.init_custom_hive_meta_db is not None:
            result['InitCustomHiveMetaDb'] = self.init_custom_hive_meta_db
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.meta_store_conf is not None:
            result['MetaStoreConf'] = self.meta_store_conf
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.configurations is not None:
            result['Configurations'] = self.configurations
        if self.emr_ver is not None:
            result['EmrVer'] = self.emr_ver
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.id is not None:
            result['Id'] = self.id
        if self.bootstrap_action_list is not None:
            result['BootstrapActionList'] = self.bootstrap_action_list.to_map()
        if self.host_group_list is not None:
            result['HostGroupList'] = self.host_group_list.to_map()
        if self.config_list is not None:
            result['ConfigList'] = self.config_list.to_map()
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.software_info_list is not None:
            result['SoftwareInfoList'] = self.software_info_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('LogEnable') is not None:
            self.log_enable = m.get('LogEnable')
        if m.get('SshEnable') is not None:
            self.ssh_enable = m.get('SshEnable')
        if m.get('HighAvailabilityEnable') is not None:
            self.high_availability_enable = m.get('HighAvailabilityEnable')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('MasterPwd') is not None:
            self.master_pwd = m.get('MasterPwd')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('IsOpenPublicIp') is not None:
            self.is_open_public_ip = m.get('IsOpenPublicIp')
        if m.get('AllowNotebook') is not None:
            self.allow_notebook = m.get('AllowNotebook')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('TemplateName') is not None:
            self.template_name = m.get('TemplateName')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        if m.get('CreateSource') is not None:
            self.create_source = m.get('CreateSource')
        if m.get('InstanceGeneration') is not None:
            self.instance_generation = m.get('InstanceGeneration')
        if m.get('UseCustomHiveMetaDb') is not None:
            self.use_custom_hive_meta_db = m.get('UseCustomHiveMetaDb')
        if m.get('EasEnable') is not None:
            self.eas_enable = m.get('EasEnable')
        if m.get('UserDefinedEmrEcsRole') is not None:
            self.user_defined_emr_ecs_role = m.get('UserDefinedEmrEcsRole')
        if m.get('MetaStoreType') is not None:
            self.meta_store_type = m.get('MetaStoreType')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('UseLocalMetaDb') is not None:
            self.use_local_meta_db = m.get('UseLocalMetaDb')
        if m.get('MasterNodeTotal') is not None:
            self.master_node_total = m.get('MasterNodeTotal')
        if m.get('InitCustomHiveMetaDb') is not None:
            self.init_custom_hive_meta_db = m.get('InitCustomHiveMetaDb')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('MetaStoreConf') is not None:
            self.meta_store_conf = m.get('MetaStoreConf')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('Configurations') is not None:
            self.configurations = m.get('Configurations')
        if m.get('EmrVer') is not None:
            self.emr_ver = m.get('EmrVer')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('BootstrapActionList') is not None:
            temp_model = DescribeClusterTemplateResponseBodyTemplateInfoBootstrapActionList()
            self.bootstrap_action_list = temp_model.from_map(m['BootstrapActionList'])
        if m.get('HostGroupList') is not None:
            temp_model = DescribeClusterTemplateResponseBodyTemplateInfoHostGroupList()
            self.host_group_list = temp_model.from_map(m['HostGroupList'])
        if m.get('ConfigList') is not None:
            temp_model = DescribeClusterTemplateResponseBodyTemplateInfoConfigList()
            self.config_list = temp_model.from_map(m['ConfigList'])
        if m.get('Tags') is not None:
            temp_model = DescribeClusterTemplateResponseBodyTemplateInfoTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('SoftwareInfoList') is not None:
            temp_model = DescribeClusterTemplateResponseBodyTemplateInfoSoftwareInfoList()
            self.software_info_list = temp_model.from_map(m['SoftwareInfoList'])
        return self


class DescribeClusterTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        template_info: DescribeClusterTemplateResponseBodyTemplateInfo = None,
    ):
        self.request_id = request_id
        self.template_info = template_info

    def validate(self):
        if self.template_info:
            self.template_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.template_info is not None:
            result['TemplateInfo'] = self.template_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TemplateInfo') is not None:
            temp_model = DescribeClusterTemplateResponseBodyTemplateInfo()
            self.template_info = temp_model.from_map(m['TemplateInfo'])
        return self


class DescribeClusterTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeClusterTemplateResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClusterTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class TagResourcesRequestTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class TagResourcesRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        resource_type: str = None,
        resource_ids: List[str] = None,
        tags: List[TagResourcesRequestTags] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        # 资源类型
        self.resource_type = resource_type
        # 资源ID
        self.resource_ids = resource_ids
        # 标签列表
        self.tags = tags

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_ids is not None:
            result['ResourceIds'] = self.resource_ids
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceIds') is not None:
            self.resource_ids = m.get('ResourceIds')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = TagResourcesRequestTags()
                self.tags.append(temp_model.from_map(k))
        return self


class TagResourcesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_code: str = None,
        message: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 请求是否成功被处理
        self.success = success
        # 响应码
        self.code = code
        # 错误码
        self.error_code = error_code
        # 响应消息
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class TagResourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: TagResourcesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = TagResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CommitFlowEntitySnapshotRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        entity_type: str = None,
        entity_id: str = None,
        message: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.entity_type = entity_type
        self.entity_id = entity_id
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.entity_type is not None:
            result['EntityType'] = self.entity_type
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('EntityType') is not None:
            self.entity_type = m.get('EntityType')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class CommitFlowEntitySnapshotResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CommitFlowEntitySnapshotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CommitFlowEntitySnapshotResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CommitFlowEntitySnapshotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitFlowJobRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        job_id: str = None,
        cluster_id: str = None,
        host_name: str = None,
        conf: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.job_id = job_id
        self.cluster_id = cluster_id
        self.host_name = host_name
        self.conf = conf

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.conf is not None:
            result['Conf'] = self.conf
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Conf') is not None:
            self.conf = m.get('Conf')
        return self


class SubmitFlowJobResponseBody(TeaModel):
    def __init__(
        self,
        id: str = None,
        request_id: str = None,
    ):
        self.id = id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SubmitFlowJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SubmitFlowJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitFlowJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowJobHistoryRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        id: str = None,
        job_type: str = None,
        instance_id: str = None,
        time_range: str = None,
        page_number: int = None,
        page_size: int = None,
        status_list: List[str] = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.id = id
        self.job_type = job_type
        self.instance_id = instance_id
        self.time_range = time_range
        self.page_number = page_number
        self.page_size = page_size
        self.status_list = status_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.time_range is not None:
            result['TimeRange'] = self.time_range
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TimeRange') is not None:
            self.time_range = m.get('TimeRange')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        return self


class ListFlowJobHistoryResponseBodyNodeInstancesNodeInstance(TeaModel):
    def __init__(
        self,
        type: str = None,
        status: str = None,
        pending: bool = None,
        env_conf: str = None,
        retry_interval: int = None,
        project_id: str = None,
        job_type: str = None,
        gmt_modified: int = None,
        external_info: str = None,
        external_status: str = None,
        job_name: str = None,
        external_id: str = None,
        max_retry: int = None,
        cluster_id: str = None,
        fail_act: str = None,
        job_params: str = None,
        param_conf: str = None,
        host_name: str = None,
        retries: int = None,
        end_time: int = None,
        start_time: int = None,
        run_conf: str = None,
        node_name: str = None,
        job_id: str = None,
        gmt_create: int = None,
        id: str = None,
    ):
        self.type = type
        self.status = status
        self.pending = pending
        self.env_conf = env_conf
        self.retry_interval = retry_interval
        self.project_id = project_id
        self.job_type = job_type
        self.gmt_modified = gmt_modified
        self.external_info = external_info
        self.external_status = external_status
        self.job_name = job_name
        self.external_id = external_id
        self.max_retry = max_retry
        self.cluster_id = cluster_id
        self.fail_act = fail_act
        self.job_params = job_params
        self.param_conf = param_conf
        self.host_name = host_name
        self.retries = retries
        self.end_time = end_time
        self.start_time = start_time
        self.run_conf = run_conf
        self.node_name = node_name
        self.job_id = job_id
        self.gmt_create = gmt_create
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.status is not None:
            result['Status'] = self.status
        if self.pending is not None:
            result['pending'] = self.pending
        if self.env_conf is not None:
            result['EnvConf'] = self.env_conf
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.external_info is not None:
            result['ExternalInfo'] = self.external_info
        if self.external_status is not None:
            result['ExternalStatus'] = self.external_status
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.external_id is not None:
            result['ExternalId'] = self.external_id
        if self.max_retry is not None:
            result['MaxRetry'] = self.max_retry
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.fail_act is not None:
            result['FailAct'] = self.fail_act
        if self.job_params is not None:
            result['JobParams'] = self.job_params
        if self.param_conf is not None:
            result['ParamConf'] = self.param_conf
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.retries is not None:
            result['Retries'] = self.retries
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.run_conf is not None:
            result['RunConf'] = self.run_conf
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('pending') is not None:
            self.pending = m.get('pending')
        if m.get('EnvConf') is not None:
            self.env_conf = m.get('EnvConf')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ExternalInfo') is not None:
            self.external_info = m.get('ExternalInfo')
        if m.get('ExternalStatus') is not None:
            self.external_status = m.get('ExternalStatus')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('ExternalId') is not None:
            self.external_id = m.get('ExternalId')
        if m.get('MaxRetry') is not None:
            self.max_retry = m.get('MaxRetry')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('FailAct') is not None:
            self.fail_act = m.get('FailAct')
        if m.get('JobParams') is not None:
            self.job_params = m.get('JobParams')
        if m.get('ParamConf') is not None:
            self.param_conf = m.get('ParamConf')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Retries') is not None:
            self.retries = m.get('Retries')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('RunConf') is not None:
            self.run_conf = m.get('RunConf')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class ListFlowJobHistoryResponseBodyNodeInstances(TeaModel):
    def __init__(
        self,
        node_instance: List[ListFlowJobHistoryResponseBodyNodeInstancesNodeInstance] = None,
    ):
        self.node_instance = node_instance

    def validate(self):
        if self.node_instance:
            for k in self.node_instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NodeInstance'] = []
        if self.node_instance is not None:
            for k in self.node_instance:
                result['NodeInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.node_instance = []
        if m.get('NodeInstance') is not None:
            for k in m.get('NodeInstance'):
                temp_model = ListFlowJobHistoryResponseBodyNodeInstancesNodeInstance()
                self.node_instance.append(temp_model.from_map(k))
        return self


class ListFlowJobHistoryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_number: int = None,
        page_size: int = None,
        total: int = None,
        node_instances: ListFlowJobHistoryResponseBodyNodeInstances = None,
    ):
        self.request_id = request_id
        self.page_number = page_number
        self.page_size = page_size
        self.total = total
        self.node_instances = node_instances

    def validate(self):
        if self.node_instances:
            self.node_instances.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        if self.node_instances is not None:
            result['NodeInstances'] = self.node_instances.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('NodeInstances') is not None:
            temp_model = ListFlowJobHistoryResponseBodyNodeInstances()
            self.node_instances = temp_model.from_map(m['NodeInstances'])
        return self


class ListFlowJobHistoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListFlowJobHistoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowJobHistoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTagResourcesRequestTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # 标签键
        self.key = key
        # 标签值
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListTagResourcesRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        resource_type: str = None,
        resource_ids: List[str] = None,
        tags: List[ListTagResourcesRequestTags] = None,
        next_token: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.resource_type = resource_type
        # 资源组ID
        self.resource_ids = resource_ids
        # 标签
        self.tags = tags
        self.next_token = next_token

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_ids is not None:
            result['ResourceIds'] = self.resource_ids
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceIds') is not None:
            self.resource_ids = m.get('ResourceIds')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = ListTagResourcesRequestTags()
                self.tags.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class ListTagResourcesResponseBodyData(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
        resource_type: str = None,
        resource_id: str = None,
    ):
        # 标签键
        self.tag_key = tag_key
        # 标签值
        self.tag_value = tag_value
        # 资源类型
        self.resource_type = resource_type
        # 资源ID
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class ListTagResourcesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        code: str = None,
        error_code: str = None,
        message: str = None,
        data: List[ListTagResourcesResponseBodyData] = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 请求是否成功被处理
        self.success = success
        # 响应码
        self.code = code
        # 错误码
        self.error_code = error_code
        # 响应消息
        self.message = message
        self.data = data

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListTagResourcesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class ListTagResourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListTagResourcesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListTagResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterHostComponentRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        host_instance_id: str = None,
        host_name: str = None,
        service_name: str = None,
        component_name: str = None,
        component_status: str = None,
        host_role: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.host_instance_id = host_instance_id
        self.host_name = host_name
        self.service_name = service_name
        self.component_name = component_name
        self.component_status = component_status
        self.host_role = host_role
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.component_status is not None:
            result['ComponentStatus'] = self.component_status
        if self.host_role is not None:
            result['HostRole'] = self.host_role
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('ComponentStatus') is not None:
            self.component_status = m.get('ComponentStatus')
        if m.get('HostRole') is not None:
            self.host_role = m.get('HostRole')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListClusterHostComponentResponseBodyComponentListComponent(TeaModel):
    def __init__(
        self,
        serial_number: str = None,
        status: str = None,
        service_display_name: str = None,
        private_ip: str = None,
        server_status: str = None,
        component_name: str = None,
        commission_status: str = None,
        host_name: str = None,
        instance_type: str = None,
        need_restart: bool = None,
        host_id: str = None,
        host_instance_id: str = None,
        cpu: int = None,
        component_display_name: str = None,
        public_ip: str = None,
        memory: int = None,
        role: str = None,
        service_name: str = None,
    ):
        self.serial_number = serial_number
        self.status = status
        self.service_display_name = service_display_name
        self.private_ip = private_ip
        self.server_status = server_status
        self.component_name = component_name
        self.commission_status = commission_status
        self.host_name = host_name
        self.instance_type = instance_type
        self.need_restart = need_restart
        self.host_id = host_id
        self.host_instance_id = host_instance_id
        self.cpu = cpu
        self.component_display_name = component_display_name
        self.public_ip = public_ip
        self.memory = memory
        self.role = role
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.status is not None:
            result['Status'] = self.status
        if self.service_display_name is not None:
            result['ServiceDisplayName'] = self.service_display_name
        if self.private_ip is not None:
            result['PrivateIp'] = self.private_ip
        if self.server_status is not None:
            result['ServerStatus'] = self.server_status
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.commission_status is not None:
            result['CommissionStatus'] = self.commission_status
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.need_restart is not None:
            result['NeedRestart'] = self.need_restart
        if self.host_id is not None:
            result['HostId'] = self.host_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.component_display_name is not None:
            result['ComponentDisplayName'] = self.component_display_name
        if self.public_ip is not None:
            result['PublicIp'] = self.public_ip
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.role is not None:
            result['Role'] = self.role
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ServiceDisplayName') is not None:
            self.service_display_name = m.get('ServiceDisplayName')
        if m.get('PrivateIp') is not None:
            self.private_ip = m.get('PrivateIp')
        if m.get('ServerStatus') is not None:
            self.server_status = m.get('ServerStatus')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('CommissionStatus') is not None:
            self.commission_status = m.get('CommissionStatus')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('NeedRestart') is not None:
            self.need_restart = m.get('NeedRestart')
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('ComponentDisplayName') is not None:
            self.component_display_name = m.get('ComponentDisplayName')
        if m.get('PublicIp') is not None:
            self.public_ip = m.get('PublicIp')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class ListClusterHostComponentResponseBodyComponentList(TeaModel):
    def __init__(
        self,
        component: List[ListClusterHostComponentResponseBodyComponentListComponent] = None,
    ):
        self.component = component

    def validate(self):
        if self.component:
            for k in self.component:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Component'] = []
        if self.component is not None:
            for k in self.component:
                result['Component'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.component = []
        if m.get('Component') is not None:
            for k in m.get('Component'):
                temp_model = ListClusterHostComponentResponseBodyComponentListComponent()
                self.component.append(temp_model.from_map(k))
        return self


class ListClusterHostComponentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_number: int = None,
        page_size: int = None,
        total: int = None,
        component_list: ListClusterHostComponentResponseBodyComponentList = None,
    ):
        self.request_id = request_id
        self.page_number = page_number
        self.page_size = page_size
        self.total = total
        self.component_list = component_list

    def validate(self):
        if self.component_list:
            self.component_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        if self.component_list is not None:
            result['ComponentList'] = self.component_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('ComponentList') is not None:
            temp_model = ListClusterHostComponentResponseBodyComponentList()
            self.component_list = temp_model.from_map(m['ComponentList'])
        return self


class ListClusterHostComponentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterHostComponentResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterHostComponentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyScalingGroupRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        name: str = None,
        description: str = None,
        scaling_group_biz_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.name = name
        self.description = description
        self.scaling_group_biz_id = scaling_group_biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        return self


class ModifyScalingGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: bool = None,
    ):
        # requestId
        self.request_id = request_id
        # data
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class ModifyScalingGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyScalingGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyScalingGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowProjectClusterSettingRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        region_id: str = None,
        cluster_id: str = None,
    ):
        self.project_id = project_id
        self.region_id = region_id
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeFlowProjectClusterSettingResponseBodyQueueList(TeaModel):
    def __init__(
        self,
        queue: List[str] = None,
    ):
        self.queue = queue

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue is not None:
            result['Queue'] = self.queue
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        return self


class DescribeFlowProjectClusterSettingResponseBodyUserList(TeaModel):
    def __init__(
        self,
        user: List[str] = None,
    ):
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribeFlowProjectClusterSettingResponseBodyHostList(TeaModel):
    def __init__(
        self,
        host: List[str] = None,
    ):
        self.host = host

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host is not None:
            result['Host'] = self.host
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Host') is not None:
            self.host = m.get('Host')
        return self


class DescribeFlowProjectClusterSettingResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        k_8s_cluster_id: str = None,
        default_queue: str = None,
        project_id: str = None,
        gmt_create: int = None,
        default_user: str = None,
        gmt_modified: int = None,
        cluster_id: str = None,
        queue_list: DescribeFlowProjectClusterSettingResponseBodyQueueList = None,
        user_list: DescribeFlowProjectClusterSettingResponseBodyUserList = None,
        host_list: DescribeFlowProjectClusterSettingResponseBodyHostList = None,
    ):
        self.request_id = request_id
        self.k_8s_cluster_id = k_8s_cluster_id
        self.default_queue = default_queue
        self.project_id = project_id
        self.gmt_create = gmt_create
        self.default_user = default_user
        self.gmt_modified = gmt_modified
        self.cluster_id = cluster_id
        self.queue_list = queue_list
        self.user_list = user_list
        self.host_list = host_list

    def validate(self):
        if self.queue_list:
            self.queue_list.validate()
        if self.user_list:
            self.user_list.validate()
        if self.host_list:
            self.host_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.default_queue is not None:
            result['DefaultQueue'] = self.default_queue
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.default_user is not None:
            result['DefaultUser'] = self.default_user
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.queue_list is not None:
            result['QueueList'] = self.queue_list.to_map()
        if self.user_list is not None:
            result['UserList'] = self.user_list.to_map()
        if self.host_list is not None:
            result['HostList'] = self.host_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('DefaultQueue') is not None:
            self.default_queue = m.get('DefaultQueue')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('DefaultUser') is not None:
            self.default_user = m.get('DefaultUser')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('QueueList') is not None:
            temp_model = DescribeFlowProjectClusterSettingResponseBodyQueueList()
            self.queue_list = temp_model.from_map(m['QueueList'])
        if m.get('UserList') is not None:
            temp_model = DescribeFlowProjectClusterSettingResponseBodyUserList()
            self.user_list = temp_model.from_map(m['UserList'])
        if m.get('HostList') is not None:
            temp_model = DescribeFlowProjectClusterSettingResponseBodyHostList()
            self.host_list = temp_model.from_map(m['HostList'])
        return self


class DescribeFlowProjectClusterSettingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowProjectClusterSettingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowProjectClusterSettingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowProjectClusterSettingRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSettingQueueList(TeaModel):
    def __init__(
        self,
        queue: List[str] = None,
    ):
        self.queue = queue

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.queue is not None:
            result['Queue'] = self.queue
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Queue') is not None:
            self.queue = m.get('Queue')
        return self


class ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSettingUserList(TeaModel):
    def __init__(
        self,
        user: List[str] = None,
    ):
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSettingHostList(TeaModel):
    def __init__(
        self,
        host: List[str] = None,
    ):
        self.host = host

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host is not None:
            result['Host'] = self.host
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Host') is not None:
            self.host = m.get('Host')
        return self


class ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSetting(TeaModel):
    def __init__(
        self,
        k_8s_cluster_id: str = None,
        default_queue: str = None,
        project_id: str = None,
        gmt_create: int = None,
        cluster_name: str = None,
        default_user: str = None,
        gmt_modified: int = None,
        cluster_id: str = None,
        queue_list: ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSettingQueueList = None,
        user_list: ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSettingUserList = None,
        host_list: ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSettingHostList = None,
    ):
        self.k_8s_cluster_id = k_8s_cluster_id
        self.default_queue = default_queue
        self.project_id = project_id
        self.gmt_create = gmt_create
        self.cluster_name = cluster_name
        self.default_user = default_user
        self.gmt_modified = gmt_modified
        self.cluster_id = cluster_id
        self.queue_list = queue_list
        self.user_list = user_list
        self.host_list = host_list

    def validate(self):
        if self.queue_list:
            self.queue_list.validate()
        if self.user_list:
            self.user_list.validate()
        if self.host_list:
            self.host_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.default_queue is not None:
            result['DefaultQueue'] = self.default_queue
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.default_user is not None:
            result['DefaultUser'] = self.default_user
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.queue_list is not None:
            result['QueueList'] = self.queue_list.to_map()
        if self.user_list is not None:
            result['UserList'] = self.user_list.to_map()
        if self.host_list is not None:
            result['HostList'] = self.host_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('DefaultQueue') is not None:
            self.default_queue = m.get('DefaultQueue')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('DefaultUser') is not None:
            self.default_user = m.get('DefaultUser')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('QueueList') is not None:
            temp_model = ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSettingQueueList()
            self.queue_list = temp_model.from_map(m['QueueList'])
        if m.get('UserList') is not None:
            temp_model = ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSettingUserList()
            self.user_list = temp_model.from_map(m['UserList'])
        if m.get('HostList') is not None:
            temp_model = ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSettingHostList()
            self.host_list = temp_model.from_map(m['HostList'])
        return self


class ListFlowProjectClusterSettingResponseBodyClusterSettings(TeaModel):
    def __init__(
        self,
        cluster_setting: List[ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSetting] = None,
    ):
        self.cluster_setting = cluster_setting

    def validate(self):
        if self.cluster_setting:
            for k in self.cluster_setting:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterSetting'] = []
        if self.cluster_setting is not None:
            for k in self.cluster_setting:
                result['ClusterSetting'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_setting = []
        if m.get('ClusterSetting') is not None:
            for k in m.get('ClusterSetting'):
                temp_model = ListFlowProjectClusterSettingResponseBodyClusterSettingsClusterSetting()
                self.cluster_setting.append(temp_model.from_map(k))
        return self


class ListFlowProjectClusterSettingResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_number: int = None,
        page_size: int = None,
        total: int = None,
        cluster_settings: ListFlowProjectClusterSettingResponseBodyClusterSettings = None,
    ):
        self.request_id = request_id
        self.page_number = page_number
        self.page_size = page_size
        self.total = total
        self.cluster_settings = cluster_settings

    def validate(self):
        if self.cluster_settings:
            self.cluster_settings.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        if self.cluster_settings is not None:
            result['ClusterSettings'] = self.cluster_settings.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('ClusterSettings') is not None:
            temp_model = ListFlowProjectClusterSettingResponseBodyClusterSettings()
            self.cluster_settings = temp_model.from_map(m['ClusterSettings'])
        return self


class ListFlowProjectClusterSettingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListFlowProjectClusterSettingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowProjectClusterSettingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SubmitFlowRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        flow_id: str = None,
        conf: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.flow_id = flow_id
        self.conf = conf

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.conf is not None:
            result['Conf'] = self.conf
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('Conf') is not None:
            self.conf = m.get('Conf')
        return self


class SubmitFlowResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        request_id: str = None,
        instance_id: str = None,
        id: str = None,
    ):
        self.data = data
        self.request_id = request_id
        self.instance_id = instance_id
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class SubmitFlowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: SubmitFlowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = SubmitFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScalingCommonConfigRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
    ):
        # ResourceOwnerId
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DescribeScalingCommonConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        auto_scaling_hook_heartbeat_default_time: int = None,
        auto_scaling_cool_down_time: int = None,
        auto_scaling_mnsscaling_thread_sleep_time: int = None,
        auto_scaling_group_min_size_limit: int = None,
        auto_scaling_group_max_size_limit: int = None,
        auto_scaling_rule_min_delay_limit: int = None,
        auto_scaling_rule_alarm_delay_limit: int = None,
        auto_scaling_rule_alarm_silent_time: int = None,
        auto_scaling_config_system_disk_size: int = None,
        auto_scaling_config_decommission_query_interval: int = None,
    ):
        # requestId
        self.request_id = request_id
        # autoScalingHookHeartbeatDefaultTime
        self.auto_scaling_hook_heartbeat_default_time = auto_scaling_hook_heartbeat_default_time
        self.auto_scaling_cool_down_time = auto_scaling_cool_down_time
        self.auto_scaling_mnsscaling_thread_sleep_time = auto_scaling_mnsscaling_thread_sleep_time
        self.auto_scaling_group_min_size_limit = auto_scaling_group_min_size_limit
        self.auto_scaling_group_max_size_limit = auto_scaling_group_max_size_limit
        self.auto_scaling_rule_min_delay_limit = auto_scaling_rule_min_delay_limit
        self.auto_scaling_rule_alarm_delay_limit = auto_scaling_rule_alarm_delay_limit
        self.auto_scaling_rule_alarm_silent_time = auto_scaling_rule_alarm_silent_time
        self.auto_scaling_config_system_disk_size = auto_scaling_config_system_disk_size
        self.auto_scaling_config_decommission_query_interval = auto_scaling_config_decommission_query_interval

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.auto_scaling_hook_heartbeat_default_time is not None:
            result['AutoScalingHookHeartbeatDefaultTime'] = self.auto_scaling_hook_heartbeat_default_time
        if self.auto_scaling_cool_down_time is not None:
            result['AutoScalingCoolDownTime'] = self.auto_scaling_cool_down_time
        if self.auto_scaling_mnsscaling_thread_sleep_time is not None:
            result['AutoScalingMNSScalingThreadSleepTime'] = self.auto_scaling_mnsscaling_thread_sleep_time
        if self.auto_scaling_group_min_size_limit is not None:
            result['AutoScalingGroupMinSizeLimit'] = self.auto_scaling_group_min_size_limit
        if self.auto_scaling_group_max_size_limit is not None:
            result['AutoScalingGroupMaxSizeLimit'] = self.auto_scaling_group_max_size_limit
        if self.auto_scaling_rule_min_delay_limit is not None:
            result['AutoScalingRuleMinDelayLimit'] = self.auto_scaling_rule_min_delay_limit
        if self.auto_scaling_rule_alarm_delay_limit is not None:
            result['AutoScalingRuleAlarmDelayLimit'] = self.auto_scaling_rule_alarm_delay_limit
        if self.auto_scaling_rule_alarm_silent_time is not None:
            result['AutoScalingRuleAlarmSilentTime'] = self.auto_scaling_rule_alarm_silent_time
        if self.auto_scaling_config_system_disk_size is not None:
            result['AutoScalingConfigSystemDiskSize'] = self.auto_scaling_config_system_disk_size
        if self.auto_scaling_config_decommission_query_interval is not None:
            result['AutoScalingConfigDecommissionQueryInterval'] = self.auto_scaling_config_decommission_query_interval
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('AutoScalingHookHeartbeatDefaultTime') is not None:
            self.auto_scaling_hook_heartbeat_default_time = m.get('AutoScalingHookHeartbeatDefaultTime')
        if m.get('AutoScalingCoolDownTime') is not None:
            self.auto_scaling_cool_down_time = m.get('AutoScalingCoolDownTime')
        if m.get('AutoScalingMNSScalingThreadSleepTime') is not None:
            self.auto_scaling_mnsscaling_thread_sleep_time = m.get('AutoScalingMNSScalingThreadSleepTime')
        if m.get('AutoScalingGroupMinSizeLimit') is not None:
            self.auto_scaling_group_min_size_limit = m.get('AutoScalingGroupMinSizeLimit')
        if m.get('AutoScalingGroupMaxSizeLimit') is not None:
            self.auto_scaling_group_max_size_limit = m.get('AutoScalingGroupMaxSizeLimit')
        if m.get('AutoScalingRuleMinDelayLimit') is not None:
            self.auto_scaling_rule_min_delay_limit = m.get('AutoScalingRuleMinDelayLimit')
        if m.get('AutoScalingRuleAlarmDelayLimit') is not None:
            self.auto_scaling_rule_alarm_delay_limit = m.get('AutoScalingRuleAlarmDelayLimit')
        if m.get('AutoScalingRuleAlarmSilentTime') is not None:
            self.auto_scaling_rule_alarm_silent_time = m.get('AutoScalingRuleAlarmSilentTime')
        if m.get('AutoScalingConfigSystemDiskSize') is not None:
            self.auto_scaling_config_system_disk_size = m.get('AutoScalingConfigSystemDiskSize')
        if m.get('AutoScalingConfigDecommissionQueryInterval') is not None:
            self.auto_scaling_config_decommission_query_interval = m.get('AutoScalingConfigDecommissionQueryInterval')
        return self


class DescribeScalingCommonConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeScalingCommonConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeScalingCommonConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ResumeFlowRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        flow_instance_id: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.flow_instance_id = flow_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.flow_instance_id is not None:
            result['FlowInstanceId'] = self.flow_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FlowInstanceId') is not None:
            self.flow_instance_id = m.get('FlowInstanceId')
        return self


class ResumeFlowResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ResumeFlowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ResumeFlowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ResumeFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RestoreFlowEntitySnapshotRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        operator_id: str = None,
        entity_type: str = None,
        entity_id: str = None,
        revision: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.operator_id = operator_id
        self.entity_type = entity_type
        self.entity_id = entity_id
        self.revision = revision

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.operator_id is not None:
            result['OperatorId'] = self.operator_id
        if self.entity_type is not None:
            result['EntityType'] = self.entity_type
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.revision is not None:
            result['Revision'] = self.revision
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('OperatorId') is not None:
            self.operator_id = m.get('OperatorId')
        if m.get('EntityType') is not None:
            self.entity_type = m.get('EntityType')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('Revision') is not None:
            self.revision = m.get('Revision')
        return self


class RestoreFlowEntitySnapshotResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RestoreFlowEntitySnapshotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: RestoreFlowEntitySnapshotResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RestoreFlowEntitySnapshotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLibraryRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        client_token: str = None,
        type: str = None,
        name: str = None,
        library_version: str = None,
        source_type: str = None,
        source_location: str = None,
        scope: str = None,
        properties: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.client_token = client_token
        self.type = type
        self.name = name
        self.library_version = library_version
        self.source_type = source_type
        self.source_location = source_location
        self.scope = scope
        self.properties = properties

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.type is not None:
            result['Type'] = self.type
        if self.name is not None:
            result['Name'] = self.name
        if self.library_version is not None:
            result['LibraryVersion'] = self.library_version
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.source_location is not None:
            result['SourceLocation'] = self.source_location
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.properties is not None:
            result['Properties'] = self.properties
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('LibraryVersion') is not None:
            self.library_version = m.get('LibraryVersion')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('SourceLocation') is not None:
            self.source_location = m.get('SourceLocation')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('Properties') is not None:
            self.properties = m.get('Properties')
        return self


class CreateLibraryResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLibraryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateLibraryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateLibraryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListVswitchRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        vpc_id: str = None,
        zone_id: str = None,
        deposit_type: str = None,
        product_type: str = None,
    ):
        self.region_id = region_id
        self.vpc_id = vpc_id
        self.zone_id = zone_id
        self.deposit_type = deposit_type
        self.product_type = product_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        return self


class ListVswitchResponseBodyVswitchListVswitch(TeaModel):
    def __init__(
        self,
        creation_time: str = None,
        status: str = None,
        vpc_id: str = None,
        is_default: bool = None,
        v_switch_id: str = None,
        cidr_block: str = None,
        description: str = None,
        available_ip_address_count: str = None,
        resource_group_id: str = None,
        zone_id: str = None,
        v_switch_name: str = None,
    ):
        self.creation_time = creation_time
        self.status = status
        self.vpc_id = vpc_id
        self.is_default = is_default
        self.v_switch_id = v_switch_id
        self.cidr_block = cidr_block
        self.description = description
        self.available_ip_address_count = available_ip_address_count
        self.resource_group_id = resource_group_id
        self.zone_id = zone_id
        self.v_switch_name = v_switch_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.status is not None:
            result['Status'] = self.status
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.description is not None:
            result['Description'] = self.description
        if self.available_ip_address_count is not None:
            result['AvailableIpAddressCount'] = self.available_ip_address_count
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.v_switch_name is not None:
            result['VSwitchName'] = self.v_switch_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('AvailableIpAddressCount') is not None:
            self.available_ip_address_count = m.get('AvailableIpAddressCount')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('VSwitchName') is not None:
            self.v_switch_name = m.get('VSwitchName')
        return self


class ListVswitchResponseBodyVswitchList(TeaModel):
    def __init__(
        self,
        vswitch: List[ListVswitchResponseBodyVswitchListVswitch] = None,
    ):
        self.vswitch = vswitch

    def validate(self):
        if self.vswitch:
            for k in self.vswitch:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Vswitch'] = []
        if self.vswitch is not None:
            for k in self.vswitch:
                result['Vswitch'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.vswitch = []
        if m.get('Vswitch') is not None:
            for k in m.get('Vswitch'):
                temp_model = ListVswitchResponseBodyVswitchListVswitch()
                self.vswitch.append(temp_model.from_map(k))
        return self


class ListVswitchResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        vswitch_list: ListVswitchResponseBodyVswitchList = None,
    ):
        self.request_id = request_id
        self.vswitch_list = vswitch_list

    def validate(self):
        if self.vswitch_list:
            self.vswitch_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.vswitch_list is not None:
            result['VswitchList'] = self.vswitch_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VswitchList') is not None:
            temp_model = ListVswitchResponseBodyVswitchList()
            self.vswitch_list = temp_model.from_map(m['VswitchList'])
        return self


class ListVswitchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListVswitchResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListVswitchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowProjectRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteFlowProjectResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteFlowProjectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteFlowProjectResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFlowProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ReleaseClusterRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        id: str = None,
        force_release: bool = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.id = id
        self.force_release = force_release

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.id is not None:
            result['Id'] = self.id
        if self.force_release is not None:
            result['ForceRelease'] = self.force_release
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ForceRelease') is not None:
            self.force_release = m.get('ForceRelease')
        return self


class ReleaseClusterResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ReleaseClusterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ReleaseClusterResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ReleaseClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddScalingConfigItemRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        scaling_group_biz_id: str = None,
        config_item_type: str = None,
        config_item_information: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.scaling_group_biz_id = scaling_group_biz_id
        self.config_item_type = config_item_type
        self.config_item_information = config_item_information

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.config_item_type is not None:
            result['ConfigItemType'] = self.config_item_type
        if self.config_item_information is not None:
            result['ConfigItemInformation'] = self.config_item_information
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('ConfigItemType') is not None:
            self.config_item_type = m.get('ConfigItemType')
        if m.get('ConfigItemInformation') is not None:
            self.config_item_information = m.get('ConfigItemInformation')
        return self


class AddScalingConfigItemResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: str = None,
    ):
        # requestId
        self.request_id = request_id
        # data
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class AddScalingConfigItemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddScalingConfigItemResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddScalingConfigItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ResetUserPasswordRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        type: str = None,
        old_password: str = None,
        password: str = None,
        user_name: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.type = type
        self.old_password = old_password
        self.password = password
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.type is not None:
            result['Type'] = self.type
        if self.old_password is not None:
            result['OldPassword'] = self.old_password
        if self.password is not None:
            result['Password'] = self.password
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('OldPassword') is not None:
            self.old_password = m.get('OldPassword')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class ResetUserPasswordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ResetUserPasswordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ResetUserPasswordResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ResetUserPasswordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowClusterAllHostsRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        cluster_id: str = None,
        resource_group_id: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.cluster_id = cluster_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class ListFlowClusterAllHostsResponseBodyHostListHost(TeaModel):
    def __init__(
        self,
        status: str = None,
        type: str = None,
        serial_number: str = None,
        private_ip: str = None,
        host_name: str = None,
        instance_type: str = None,
        host_id: str = None,
        host_instance_id: str = None,
        cpu: int = None,
        public_ip: str = None,
        memory: int = None,
        role: str = None,
    ):
        self.status = status
        self.type = type
        self.serial_number = serial_number
        self.private_ip = private_ip
        self.host_name = host_name
        self.instance_type = instance_type
        self.host_id = host_id
        self.host_instance_id = host_instance_id
        self.cpu = cpu
        self.public_ip = public_ip
        self.memory = memory
        self.role = role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.private_ip is not None:
            result['PrivateIp'] = self.private_ip
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.host_id is not None:
            result['HostId'] = self.host_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.public_ip is not None:
            result['PublicIp'] = self.public_ip
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.role is not None:
            result['Role'] = self.role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('PrivateIp') is not None:
            self.private_ip = m.get('PrivateIp')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('PublicIp') is not None:
            self.public_ip = m.get('PublicIp')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        return self


class ListFlowClusterAllHostsResponseBodyHostList(TeaModel):
    def __init__(
        self,
        host: List[ListFlowClusterAllHostsResponseBodyHostListHost] = None,
    ):
        self.host = host

    def validate(self):
        if self.host:
            for k in self.host:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Host'] = []
        if self.host is not None:
            for k in self.host:
                result['Host'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.host = []
        if m.get('Host') is not None:
            for k in m.get('Host'):
                temp_model = ListFlowClusterAllHostsResponseBodyHostListHost()
                self.host.append(temp_model.from_map(k))
        return self


class ListFlowClusterAllHostsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        host_list: ListFlowClusterAllHostsResponseBodyHostList = None,
    ):
        self.request_id = request_id
        self.host_list = host_list

    def validate(self):
        if self.host_list:
            self.host_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.host_list is not None:
            result['HostList'] = self.host_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HostList') is not None:
            temp_model = ListFlowClusterAllHostsResponseBodyHostList()
            self.host_list = temp_model.from_map(m['HostList'])
        return self


class ListFlowClusterAllHostsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListFlowClusterAllHostsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowClusterAllHostsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLibrariesRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        library_biz_id_list: List[str] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.library_biz_id_list = library_biz_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.library_biz_id_list is not None:
            result['LibraryBizIdList'] = self.library_biz_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('LibraryBizIdList') is not None:
            self.library_biz_id_list = m.get('LibraryBizIdList')
        return self


class DeleteLibrariesResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLibrariesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLibrariesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLibrariesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowCategoryTreeRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        region_id: str = None,
        type: str = None,
        mode: str = None,
        keyword: str = None,
        category_id: str = None,
    ):
        self.project_id = project_id
        self.region_id = region_id
        self.type = type
        self.mode = mode
        self.keyword = keyword
        self.category_id = category_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.type is not None:
            result['Type'] = self.type
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        return self


class DescribeFlowCategoryTreeResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeFlowCategoryTreeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowCategoryTreeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowCategoryTreeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDatasourceInstancesRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        target_cluster_id: str = None,
        datasource_type: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.target_cluster_id = target_cluster_id
        self.datasource_type = datasource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.target_cluster_id is not None:
            result['TargetClusterId'] = self.target_cluster_id
        if self.datasource_type is not None:
            result['DatasourceType'] = self.datasource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TargetClusterId') is not None:
            self.target_cluster_id = m.get('TargetClusterId')
        if m.get('DatasourceType') is not None:
            self.datasource_type = m.get('DatasourceType')
        return self


class ListDatasourceInstancesResponseBodyDdiDatasourceInfoListDdiDatasourceInfoPrivateAddressList(TeaModel):
    def __init__(
        self,
        private_address_list: List[str] = None,
    ):
        self.private_address_list = private_address_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.private_address_list is not None:
            result['privateAddressList'] = self.private_address_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('privateAddressList') is not None:
            self.private_address_list = m.get('privateAddressList')
        return self


class ListDatasourceInstancesResponseBodyDdiDatasourceInfoListDdiDatasourceInfo(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        create_time: int = None,
        datasource_id: str = None,
        descreption: str = None,
        modify_time: int = None,
        name: str = None,
        status: str = None,
        type: str = None,
        vswitch_id: str = None,
        private_address_list: ListDatasourceInstancesResponseBodyDdiDatasourceInfoListDdiDatasourceInfoPrivateAddressList = None,
        security_group_id: str = None,
    ):
        self.cluster_id = cluster_id
        self.create_time = create_time
        self.datasource_id = datasource_id
        self.descreption = descreption
        self.modify_time = modify_time
        self.name = name
        self.status = status
        self.type = type
        self.vswitch_id = vswitch_id
        self.private_address_list = private_address_list
        self.security_group_id = security_group_id

    def validate(self):
        if self.private_address_list:
            self.private_address_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.datasource_id is not None:
            result['DatasourceId'] = self.datasource_id
        if self.descreption is not None:
            result['Descreption'] = self.descreption
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.name is not None:
            result['Name'] = self.name
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        if self.private_address_list is not None:
            result['PrivateAddressList'] = self.private_address_list.to_map()
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DatasourceId') is not None:
            self.datasource_id = m.get('DatasourceId')
        if m.get('Descreption') is not None:
            self.descreption = m.get('Descreption')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        if m.get('PrivateAddressList') is not None:
            temp_model = ListDatasourceInstancesResponseBodyDdiDatasourceInfoListDdiDatasourceInfoPrivateAddressList()
            self.private_address_list = temp_model.from_map(m['PrivateAddressList'])
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        return self


class ListDatasourceInstancesResponseBodyDdiDatasourceInfoList(TeaModel):
    def __init__(
        self,
        ddi_datasource_info: List[ListDatasourceInstancesResponseBodyDdiDatasourceInfoListDdiDatasourceInfo] = None,
    ):
        self.ddi_datasource_info = ddi_datasource_info

    def validate(self):
        if self.ddi_datasource_info:
            for k in self.ddi_datasource_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DdiDatasourceInfo'] = []
        if self.ddi_datasource_info is not None:
            for k in self.ddi_datasource_info:
                result['DdiDatasourceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ddi_datasource_info = []
        if m.get('DdiDatasourceInfo') is not None:
            for k in m.get('DdiDatasourceInfo'):
                temp_model = ListDatasourceInstancesResponseBodyDdiDatasourceInfoListDdiDatasourceInfo()
                self.ddi_datasource_info.append(temp_model.from_map(k))
        return self


class ListDatasourceInstancesResponseBody(TeaModel):
    def __init__(
        self,
        ddi_datasource_info_list: ListDatasourceInstancesResponseBodyDdiDatasourceInfoList = None,
        request_id: str = None,
    ):
        self.ddi_datasource_info_list = ddi_datasource_info_list
        self.request_id = request_id

    def validate(self):
        if self.ddi_datasource_info_list:
            self.ddi_datasource_info_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ddi_datasource_info_list is not None:
            result['DdiDatasourceInfoList'] = self.ddi_datasource_info_list.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DdiDatasourceInfoList') is not None:
            temp_model = ListDatasourceInstancesResponseBodyDdiDatasourceInfoList()
            self.ddi_datasource_info_list = temp_model.from_map(m['DdiDatasourceInfoList'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListDatasourceInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDatasourceInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDatasourceInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowNodeSqlResultRequest(TeaModel):
    def __init__(
        self,
        node_instance_id: str = None,
        sql_index: int = None,
        offset: int = None,
        length: int = None,
        project_id: str = None,
        region_id: str = None,
    ):
        self.node_instance_id = node_instance_id
        self.sql_index = sql_index
        self.offset = offset
        self.length = length
        self.project_id = project_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_instance_id is not None:
            result['NodeInstanceId'] = self.node_instance_id
        if self.sql_index is not None:
            result['SqlIndex'] = self.sql_index
        if self.offset is not None:
            result['Offset'] = self.offset
        if self.length is not None:
            result['Length'] = self.length
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeInstanceId') is not None:
            self.node_instance_id = m.get('NodeInstanceId')
        if m.get('SqlIndex') is not None:
            self.sql_index = m.get('SqlIndex')
        if m.get('Offset') is not None:
            self.offset = m.get('Offset')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ListFlowNodeSqlResultResponseBodyHeaderList(TeaModel):
    def __init__(
        self,
        header: List[str] = None,
    ):
        self.header = header

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.header is not None:
            result['Header'] = self.header
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Header') is not None:
            self.header = m.get('Header')
        return self


class ListFlowNodeSqlResultResponseBodyRowListRowRowItemList(TeaModel):
    def __init__(
        self,
        row_item: List[str] = None,
    ):
        self.row_item = row_item

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.row_item is not None:
            result['RowItem'] = self.row_item
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RowItem') is not None:
            self.row_item = m.get('RowItem')
        return self


class ListFlowNodeSqlResultResponseBodyRowListRow(TeaModel):
    def __init__(
        self,
        row_index: int = None,
        row_item_list: ListFlowNodeSqlResultResponseBodyRowListRowRowItemList = None,
    ):
        self.row_index = row_index
        self.row_item_list = row_item_list

    def validate(self):
        if self.row_item_list:
            self.row_item_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.row_index is not None:
            result['RowIndex'] = self.row_index
        if self.row_item_list is not None:
            result['RowItemList'] = self.row_item_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RowIndex') is not None:
            self.row_index = m.get('RowIndex')
        if m.get('RowItemList') is not None:
            temp_model = ListFlowNodeSqlResultResponseBodyRowListRowRowItemList()
            self.row_item_list = temp_model.from_map(m['RowItemList'])
        return self


class ListFlowNodeSqlResultResponseBodyRowList(TeaModel):
    def __init__(
        self,
        row: List[ListFlowNodeSqlResultResponseBodyRowListRow] = None,
    ):
        self.row = row

    def validate(self):
        if self.row:
            for k in self.row:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Row'] = []
        if self.row is not None:
            for k in self.row:
                result['Row'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.row = []
        if m.get('Row') is not None:
            for k in m.get('Row'):
                temp_model = ListFlowNodeSqlResultResponseBodyRowListRow()
                self.row.append(temp_model.from_map(k))
        return self


class ListFlowNodeSqlResultResponseBody(TeaModel):
    def __init__(
        self,
        end: bool = None,
        request_id: str = None,
        header_list: ListFlowNodeSqlResultResponseBodyHeaderList = None,
        row_list: ListFlowNodeSqlResultResponseBodyRowList = None,
    ):
        self.end = end
        self.request_id = request_id
        self.header_list = header_list
        self.row_list = row_list

    def validate(self):
        if self.header_list:
            self.header_list.validate()
        if self.row_list:
            self.row_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['End'] = self.end
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.header_list is not None:
            result['HeaderList'] = self.header_list.to_map()
        if self.row_list is not None:
            result['RowList'] = self.row_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('HeaderList') is not None:
            temp_model = ListFlowNodeSqlResultResponseBodyHeaderList()
            self.header_list = temp_model.from_map(m['HeaderList'])
        if m.get('RowList') is not None:
            temp_model = ListFlowNodeSqlResultResponseBodyRowList()
            self.row_list = temp_model.from_map(m['RowList'])
        return self


class ListFlowNodeSqlResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListFlowNodeSqlResultResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowNodeSqlResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowJobRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        id: str = None,
        region_id: str = None,
    ):
        self.project_id = project_id
        self.id = id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowJobResponseBodyResourceListResource(TeaModel):
    def __init__(
        self,
        path: str = None,
        alias: str = None,
    ):
        self.path = path
        self.alias = alias

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.alias is not None:
            result['Alias'] = self.alias
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        return self


class DescribeFlowJobResponseBodyResourceList(TeaModel):
    def __init__(
        self,
        resource: List[DescribeFlowJobResponseBodyResourceListResource] = None,
    ):
        self.resource = resource

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = DescribeFlowJobResponseBodyResourceListResource()
                self.resource.append(temp_model.from_map(k))
        return self


class DescribeFlowJobResponseBody(TeaModel):
    def __init__(
        self,
        type: str = None,
        last_instance_id: str = None,
        env_conf: str = None,
        retry_interval: int = None,
        mode: str = None,
        gmt_modified: int = None,
        monitor_conf: str = None,
        params: str = None,
        request_id: str = None,
        description: str = None,
        retry_policy: str = None,
        adhoc: str = None,
        name: str = None,
        max_retry: int = None,
        max_running_time_sec: int = None,
        fail_act: str = None,
        custom_variables: str = None,
        edit_lock_detail: str = None,
        param_conf: str = None,
        run_conf: str = None,
        gmt_create: int = None,
        category_id: str = None,
        id: str = None,
        alert_conf: str = None,
        resource_list: DescribeFlowJobResponseBodyResourceList = None,
    ):
        self.type = type
        self.last_instance_id = last_instance_id
        self.env_conf = env_conf
        self.retry_interval = retry_interval
        self.mode = mode
        self.gmt_modified = gmt_modified
        self.monitor_conf = monitor_conf
        self.params = params
        self.request_id = request_id
        self.description = description
        self.retry_policy = retry_policy
        self.adhoc = adhoc
        self.name = name
        self.max_retry = max_retry
        self.max_running_time_sec = max_running_time_sec
        self.fail_act = fail_act
        self.custom_variables = custom_variables
        self.edit_lock_detail = edit_lock_detail
        self.param_conf = param_conf
        self.run_conf = run_conf
        self.gmt_create = gmt_create
        self.category_id = category_id
        self.id = id
        self.alert_conf = alert_conf
        self.resource_list = resource_list

    def validate(self):
        if self.resource_list:
            self.resource_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.last_instance_id is not None:
            result['LastInstanceId'] = self.last_instance_id
        if self.env_conf is not None:
            result['EnvConf'] = self.env_conf
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.monitor_conf is not None:
            result['MonitorConf'] = self.monitor_conf
        if self.params is not None:
            result['Params'] = self.params
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.description is not None:
            result['Description'] = self.description
        if self.retry_policy is not None:
            result['RetryPolicy'] = self.retry_policy
        if self.adhoc is not None:
            result['Adhoc'] = self.adhoc
        if self.name is not None:
            result['Name'] = self.name
        if self.max_retry is not None:
            result['MaxRetry'] = self.max_retry
        if self.max_running_time_sec is not None:
            result['MaxRunningTimeSec'] = self.max_running_time_sec
        if self.fail_act is not None:
            result['FailAct'] = self.fail_act
        if self.custom_variables is not None:
            result['CustomVariables'] = self.custom_variables
        if self.edit_lock_detail is not None:
            result['EditLockDetail'] = self.edit_lock_detail
        if self.param_conf is not None:
            result['ParamConf'] = self.param_conf
        if self.run_conf is not None:
            result['RunConf'] = self.run_conf
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.id is not None:
            result['Id'] = self.id
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        if self.resource_list is not None:
            result['ResourceList'] = self.resource_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('LastInstanceId') is not None:
            self.last_instance_id = m.get('LastInstanceId')
        if m.get('EnvConf') is not None:
            self.env_conf = m.get('EnvConf')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('MonitorConf') is not None:
            self.monitor_conf = m.get('MonitorConf')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RetryPolicy') is not None:
            self.retry_policy = m.get('RetryPolicy')
        if m.get('Adhoc') is not None:
            self.adhoc = m.get('Adhoc')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('MaxRetry') is not None:
            self.max_retry = m.get('MaxRetry')
        if m.get('MaxRunningTimeSec') is not None:
            self.max_running_time_sec = m.get('MaxRunningTimeSec')
        if m.get('FailAct') is not None:
            self.fail_act = m.get('FailAct')
        if m.get('CustomVariables') is not None:
            self.custom_variables = m.get('CustomVariables')
        if m.get('EditLockDetail') is not None:
            self.edit_lock_detail = m.get('EditLockDetail')
        if m.get('ParamConf') is not None:
            self.param_conf = m.get('ParamConf')
        if m.get('RunConf') is not None:
            self.run_conf = m.get('RunConf')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        if m.get('ResourceList') is not None:
            temp_model = DescribeFlowJobResponseBodyResourceList()
            self.resource_list = temp_model.from_map(m['ResourceList'])
        return self


class DescribeFlowJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLibraryInstallTaskDetailRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        task_biz_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.task_biz_id = task_biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.task_biz_id is not None:
            result['TaskBizId'] = self.task_biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TaskBizId') is not None:
            self.task_biz_id = m.get('TaskBizId')
        return self


class DescribeLibraryInstallTaskDetailResponseBody(TeaModel):
    def __init__(
        self,
        library_biz_id: str = None,
        hostname: str = None,
        end_time: int = None,
        start_time: int = None,
        task_type: str = None,
        request_id: str = None,
        task_group_id: str = None,
        task_status: str = None,
        task_process: int = None,
        execute_time: int = None,
        cluster_biz_id: str = None,
        task_id: str = None,
        detail: str = None,
    ):
        self.library_biz_id = library_biz_id
        self.hostname = hostname
        self.end_time = end_time
        self.start_time = start_time
        self.task_type = task_type
        self.request_id = request_id
        self.task_group_id = task_group_id
        self.task_status = task_status
        self.task_process = task_process
        self.execute_time = execute_time
        self.cluster_biz_id = cluster_biz_id
        self.task_id = task_id
        self.detail = detail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.library_biz_id is not None:
            result['LibraryBizId'] = self.library_biz_id
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_group_id is not None:
            result['TaskGroupId'] = self.task_group_id
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.task_process is not None:
            result['TaskProcess'] = self.task_process
        if self.execute_time is not None:
            result['ExecuteTime'] = self.execute_time
        if self.cluster_biz_id is not None:
            result['ClusterBizId'] = self.cluster_biz_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.detail is not None:
            result['Detail'] = self.detail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LibraryBizId') is not None:
            self.library_biz_id = m.get('LibraryBizId')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskGroupId') is not None:
            self.task_group_id = m.get('TaskGroupId')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TaskProcess') is not None:
            self.task_process = m.get('TaskProcess')
        if m.get('ExecuteTime') is not None:
            self.execute_time = m.get('ExecuteTime')
        if m.get('ClusterBizId') is not None:
            self.cluster_biz_id = m.get('ClusterBizId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        return self


class DescribeLibraryInstallTaskDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLibraryInstallTaskDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLibraryInstallTaskDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyFlowForWebRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        id: str = None,
        name: str = None,
        status: str = None,
        description: str = None,
        periodic: bool = None,
        start_schedule: int = None,
        end_schedule: int = None,
        cron_expr: str = None,
        create_cluster: bool = None,
        cluster_id: str = None,
        host_name: str = None,
        namespace: str = None,
        graph: str = None,
        alert_conf: str = None,
        alert_user_group_biz_id: str = None,
        alert_ding_ding_group_biz_id: str = None,
        parent_flow_list: str = None,
        parent_category: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.id = id
        self.name = name
        self.status = status
        self.description = description
        self.periodic = periodic
        self.start_schedule = start_schedule
        self.end_schedule = end_schedule
        self.cron_expr = cron_expr
        self.create_cluster = create_cluster
        self.cluster_id = cluster_id
        self.host_name = host_name
        self.namespace = namespace
        self.graph = graph
        self.alert_conf = alert_conf
        self.alert_user_group_biz_id = alert_user_group_biz_id
        self.alert_ding_ding_group_biz_id = alert_ding_ding_group_biz_id
        self.parent_flow_list = parent_flow_list
        self.parent_category = parent_category

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.status is not None:
            result['Status'] = self.status
        if self.description is not None:
            result['Description'] = self.description
        if self.periodic is not None:
            result['Periodic'] = self.periodic
        if self.start_schedule is not None:
            result['StartSchedule'] = self.start_schedule
        if self.end_schedule is not None:
            result['EndSchedule'] = self.end_schedule
        if self.cron_expr is not None:
            result['CronExpr'] = self.cron_expr
        if self.create_cluster is not None:
            result['CreateCluster'] = self.create_cluster
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.graph is not None:
            result['Graph'] = self.graph
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        if self.alert_user_group_biz_id is not None:
            result['AlertUserGroupBizId'] = self.alert_user_group_biz_id
        if self.alert_ding_ding_group_biz_id is not None:
            result['AlertDingDingGroupBizId'] = self.alert_ding_ding_group_biz_id
        if self.parent_flow_list is not None:
            result['ParentFlowList'] = self.parent_flow_list
        if self.parent_category is not None:
            result['ParentCategory'] = self.parent_category
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Periodic') is not None:
            self.periodic = m.get('Periodic')
        if m.get('StartSchedule') is not None:
            self.start_schedule = m.get('StartSchedule')
        if m.get('EndSchedule') is not None:
            self.end_schedule = m.get('EndSchedule')
        if m.get('CronExpr') is not None:
            self.cron_expr = m.get('CronExpr')
        if m.get('CreateCluster') is not None:
            self.create_cluster = m.get('CreateCluster')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Graph') is not None:
            self.graph = m.get('Graph')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        if m.get('AlertUserGroupBizId') is not None:
            self.alert_user_group_biz_id = m.get('AlertUserGroupBizId')
        if m.get('AlertDingDingGroupBizId') is not None:
            self.alert_ding_ding_group_biz_id = m.get('AlertDingDingGroupBizId')
        if m.get('ParentFlowList') is not None:
            self.parent_flow_list = m.get('ParentFlowList')
        if m.get('ParentCategory') is not None:
            self.parent_category = m.get('ParentCategory')
        return self


class ModifyFlowForWebResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyFlowForWebResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyFlowForWebResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyFlowForWebResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemoveScalingConfigItemRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        scaling_group_biz_id: str = None,
        config_item_type: str = None,
        config_item_biz_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.scaling_group_biz_id = scaling_group_biz_id
        self.config_item_type = config_item_type
        self.config_item_biz_id = config_item_biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.config_item_type is not None:
            result['ConfigItemType'] = self.config_item_type
        if self.config_item_biz_id is not None:
            result['ConfigItemBizId'] = self.config_item_biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('ConfigItemType') is not None:
            self.config_item_type = m.get('ConfigItemType')
        if m.get('ConfigItemBizId') is not None:
            self.config_item_biz_id = m.get('ConfigItemBizId')
        return self


class RemoveScalingConfigItemResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: bool = None,
    ):
        # requestId
        self.request_id = request_id
        # data
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class RemoveScalingConfigItemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: RemoveScalingConfigItemResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RemoveScalingConfigItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecurityWhiteListRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
    ):
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeSecurityWhiteListResponseBodyDescribeSecurityWhiteList(TeaModel):
    def __init__(
        self,
        port_range: str = None,
        white_ip: str = None,
        description: str = None,
        create_time: str = None,
    ):
        self.port_range = port_range
        self.white_ip = white_ip
        self.description = description
        self.create_time = create_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.white_ip is not None:
            result['WhiteIp'] = self.white_ip
        if self.description is not None:
            result['Description'] = self.description
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('WhiteIp') is not None:
            self.white_ip = m.get('WhiteIp')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        return self


class DescribeSecurityWhiteListResponseBody(TeaModel):
    def __init__(
        self,
        describe_security_white_list: List[DescribeSecurityWhiteListResponseBodyDescribeSecurityWhiteList] = None,
        request_id: str = None,
    ):
        self.describe_security_white_list = describe_security_white_list
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.describe_security_white_list:
            for k in self.describe_security_white_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DescribeSecurityWhiteList'] = []
        if self.describe_security_white_list is not None:
            for k in self.describe_security_white_list:
                result['DescribeSecurityWhiteList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.describe_security_white_list = []
        if m.get('DescribeSecurityWhiteList') is not None:
            for k in m.get('DescribeSecurityWhiteList'):
                temp_model = DescribeSecurityWhiteListResponseBodyDescribeSecurityWhiteList()
                self.describe_security_white_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeSecurityWhiteListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSecurityWhiteListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSecurityWhiteListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowNodeInstanceContainerLogRequest(TeaModel):
    def __init__(
        self,
        offset: int = None,
        length: int = None,
        node_instance_id: str = None,
        app_id: str = None,
        container_id: str = None,
        log_name: str = None,
        project_id: str = None,
        region_id: str = None,
    ):
        self.offset = offset
        self.length = length
        self.node_instance_id = node_instance_id
        self.app_id = app_id
        self.container_id = container_id
        self.log_name = log_name
        self.project_id = project_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.offset is not None:
            result['Offset'] = self.offset
        if self.length is not None:
            result['Length'] = self.length
        if self.node_instance_id is not None:
            result['NodeInstanceId'] = self.node_instance_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.log_name is not None:
            result['LogName'] = self.log_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Offset') is not None:
            self.offset = m.get('Offset')
        if m.get('Length') is not None:
            self.length = m.get('Length')
        if m.get('NodeInstanceId') is not None:
            self.node_instance_id = m.get('NodeInstanceId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('LogName') is not None:
            self.log_name = m.get('LogName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowNodeInstanceContainerLogResponseBodyLogEntrysLogEntry(TeaModel):
    def __init__(
        self,
        content: str = None,
    ):
        self.content = content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class DescribeFlowNodeInstanceContainerLogResponseBodyLogEntrys(TeaModel):
    def __init__(
        self,
        log_entry: List[DescribeFlowNodeInstanceContainerLogResponseBodyLogEntrysLogEntry] = None,
    ):
        self.log_entry = log_entry

    def validate(self):
        if self.log_entry:
            for k in self.log_entry:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LogEntry'] = []
        if self.log_entry is not None:
            for k in self.log_entry:
                result['LogEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.log_entry = []
        if m.get('LogEntry') is not None:
            for k in m.get('LogEntry'):
                temp_model = DescribeFlowNodeInstanceContainerLogResponseBodyLogEntrysLogEntry()
                self.log_entry.append(temp_model.from_map(k))
        return self


class DescribeFlowNodeInstanceContainerLogResponseBody(TeaModel):
    def __init__(
        self,
        log_end: bool = None,
        request_id: str = None,
        log_entrys: DescribeFlowNodeInstanceContainerLogResponseBodyLogEntrys = None,
    ):
        self.log_end = log_end
        self.request_id = request_id
        self.log_entrys = log_entrys

    def validate(self):
        if self.log_entrys:
            self.log_entrys.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_end is not None:
            result['LogEnd'] = self.log_end
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.log_entrys is not None:
            result['LogEntrys'] = self.log_entrys.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LogEnd') is not None:
            self.log_end = m.get('LogEnd')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('LogEntrys') is not None:
            temp_model = DescribeFlowNodeInstanceContainerLogResponseBodyLogEntrys()
            self.log_entrys = temp_model.from_map(m['LogEntrys'])
        return self


class DescribeFlowNodeInstanceContainerLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowNodeInstanceContainerLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowNodeInstanceContainerLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RerunFlowRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        flow_instance_id: str = None,
        re_run_fail: bool = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.flow_instance_id = flow_instance_id
        self.re_run_fail = re_run_fail

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.flow_instance_id is not None:
            result['FlowInstanceId'] = self.flow_instance_id
        if self.re_run_fail is not None:
            result['ReRunFail'] = self.re_run_fail
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FlowInstanceId') is not None:
            self.flow_instance_id = m.get('FlowInstanceId')
        if m.get('ReRunFail') is not None:
            self.re_run_fail = m.get('ReRunFail')
        return self


class RerunFlowResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RerunFlowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: RerunFlowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RerunFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTagKeysRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        resource_type: str = None,
        category: str = None,
        scope: str = None,
        next_token: str = None,
        page_size: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        # 资源类型
        self.resource_type = resource_type
        self.category = category
        self.scope = scope
        self.next_token = next_token
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.category is not None:
            result['Category'] = self.category
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListTagKeysResponseBodyData(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
        next_token: str = None,
        items: List[str] = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count
        self.next_token = next_token
        # 标签键集合
        self.items = items

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.items is not None:
            result['Items'] = self.items
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Items') is not None:
            self.items = m.get('Items')
        return self


class ListTagKeysResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        success: bool = None,
        paging: bool = None,
        data: List[ListTagKeysResponseBodyData] = None,
        code: str = None,
        error_code: str = None,
        message: str = None,
    ):
        # Id of the request
        self.request_id = request_id
        # 是否成功响应
        self.success = success
        # 是否分页
        self.paging = paging
        # 标签键集合
        self.data = data
        self.code = code
        self.error_code = error_code
        self.message = message

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.paging is not None:
            result['Paging'] = self.paging
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Paging') is not None:
            self.paging = m.get('Paging')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListTagKeysResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class ListTagKeysResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListTagKeysResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListTagKeysResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterOperationHostTaskLogRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        operation_id: str = None,
        host_id: str = None,
        task_id: str = None,
        status: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.operation_id = operation_id
        self.host_id = host_id
        self.task_id = task_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.operation_id is not None:
            result['OperationId'] = self.operation_id
        if self.host_id is not None:
            result['HostId'] = self.host_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('OperationId') is not None:
            self.operation_id = m.get('OperationId')
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeClusterOperationHostTaskLogResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        stdout: str = None,
        stderr: str = None,
    ):
        self.request_id = request_id
        self.stdout = stdout
        self.stderr = stderr

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.stdout is not None:
            result['Stdout'] = self.stdout
        if self.stderr is not None:
            result['Stderr'] = self.stderr
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Stdout') is not None:
            self.stdout = m.get('Stdout')
        if m.get('Stderr') is not None:
            self.stderr = m.get('Stderr')
        return self


class DescribeClusterOperationHostTaskLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeClusterOperationHostTaskLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClusterOperationHostTaskLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class KillFlowJobRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        job_instance_id: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.job_instance_id = job_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.job_instance_id is not None:
            result['JobInstanceId'] = self.job_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('JobInstanceId') is not None:
            self.job_instance_id = m.get('JobInstanceId')
        return self


class KillFlowJobResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class KillFlowJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: KillFlowJobResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = KillFlowJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UninstallLibrariesRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_biz_id_list: List[str] = None,
        library_biz_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_biz_id_list = cluster_biz_id_list
        self.library_biz_id = library_biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_biz_id_list is not None:
            result['ClusterBizIdList'] = self.cluster_biz_id_list
        if self.library_biz_id is not None:
            result['LibraryBizId'] = self.library_biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterBizIdList') is not None:
            self.cluster_biz_id_list = m.get('ClusterBizIdList')
        if m.get('LibraryBizId') is not None:
            self.library_biz_id = m.get('LibraryBizId')
        return self


class UninstallLibrariesResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class UninstallLibrariesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: UninstallLibrariesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = UninstallLibrariesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterV2Request(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeClusterV2ResponseBodyClusterInfoGatewayClusterInfoListGatewayClusterInfo(TeaModel):
    def __init__(
        self,
        cluster_name: str = None,
        status: str = None,
        cluster_id: str = None,
    ):
        self.cluster_name = cluster_name
        self.status = status
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.status is not None:
            result['Status'] = self.status
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeClusterV2ResponseBodyClusterInfoGatewayClusterInfoList(TeaModel):
    def __init__(
        self,
        gateway_cluster_info: List[DescribeClusterV2ResponseBodyClusterInfoGatewayClusterInfoListGatewayClusterInfo] = None,
    ):
        self.gateway_cluster_info = gateway_cluster_info

    def validate(self):
        if self.gateway_cluster_info:
            for k in self.gateway_cluster_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['GatewayClusterInfo'] = []
        if self.gateway_cluster_info is not None:
            for k in self.gateway_cluster_info:
                result['GatewayClusterInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.gateway_cluster_info = []
        if m.get('GatewayClusterInfo') is not None:
            for k in m.get('GatewayClusterInfo'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoGatewayClusterInfoListGatewayClusterInfo()
                self.gateway_cluster_info.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDaemonInfosDaemonInfo(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDaemonInfos(TeaModel):
    def __init__(
        self,
        daemon_info: List[DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDaemonInfosDaemonInfo] = None,
    ):
        self.daemon_info = daemon_info

    def validate(self):
        if self.daemon_info:
            for k in self.daemon_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DaemonInfo'] = []
        if self.daemon_info is not None:
            for k in self.daemon_info:
                result['DaemonInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.daemon_info = []
        if m.get('DaemonInfo') is not None:
            for k in m.get('DaemonInfo'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDaemonInfosDaemonInfo()
                self.daemon_info.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDiskInfosDiskInfo(TeaModel):
    def __init__(
        self,
        type: str = None,
        disk_id: str = None,
        size: int = None,
        device: str = None,
        disk_name: str = None,
    ):
        self.type = type
        self.disk_id = disk_id
        self.size = size
        self.device = device
        self.disk_name = disk_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.size is not None:
            result['Size'] = self.size
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDiskInfos(TeaModel):
    def __init__(
        self,
        disk_info: List[DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDiskInfosDiskInfo] = None,
    ):
        self.disk_info = disk_info

    def validate(self):
        if self.disk_info:
            for k in self.disk_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DiskInfo'] = []
        if self.disk_info is not None:
            for k in self.disk_info:
                result['DiskInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.disk_info = []
        if m.get('DiskInfo') is not None:
            for k in m.get('DiskInfo'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDiskInfosDiskInfo()
                self.disk_info.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNode(TeaModel):
    def __init__(
        self,
        status: str = None,
        support_ip_v6: bool = None,
        inner_ip: str = None,
        expired_time: str = None,
        create_time: str = None,
        zone_id: str = None,
        instance_id: str = None,
        emr_expired_time: str = None,
        pub_ip: str = None,
        daemon_infos: DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDaemonInfos = None,
        disk_infos: DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDiskInfos = None,
    ):
        self.status = status
        self.support_ip_v6 = support_ip_v6
        self.inner_ip = inner_ip
        self.expired_time = expired_time
        self.create_time = create_time
        self.zone_id = zone_id
        self.instance_id = instance_id
        self.emr_expired_time = emr_expired_time
        self.pub_ip = pub_ip
        self.daemon_infos = daemon_infos
        self.disk_infos = disk_infos

    def validate(self):
        if self.daemon_infos:
            self.daemon_infos.validate()
        if self.disk_infos:
            self.disk_infos.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.support_ip_v6 is not None:
            result['SupportIpV6'] = self.support_ip_v6
        if self.inner_ip is not None:
            result['InnerIp'] = self.inner_ip
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.emr_expired_time is not None:
            result['EmrExpiredTime'] = self.emr_expired_time
        if self.pub_ip is not None:
            result['PubIp'] = self.pub_ip
        if self.daemon_infos is not None:
            result['DaemonInfos'] = self.daemon_infos.to_map()
        if self.disk_infos is not None:
            result['DiskInfos'] = self.disk_infos.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SupportIpV6') is not None:
            self.support_ip_v6 = m.get('SupportIpV6')
        if m.get('InnerIp') is not None:
            self.inner_ip = m.get('InnerIp')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('EmrExpiredTime') is not None:
            self.emr_expired_time = m.get('EmrExpiredTime')
        if m.get('PubIp') is not None:
            self.pub_ip = m.get('PubIp')
        if m.get('DaemonInfos') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDaemonInfos()
            self.daemon_infos = temp_model.from_map(m['DaemonInfos'])
        if m.get('DiskInfos') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNodeDiskInfos()
            self.disk_infos = temp_model.from_map(m['DiskInfos'])
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodes(TeaModel):
    def __init__(
        self,
        node: List[DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNode] = None,
    ):
        self.node = node

    def validate(self):
        if self.node:
            for k in self.node:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Node'] = []
        if self.node is not None:
            for k in self.node:
                result['Node'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.node = []
        if m.get('Node') is not None:
            for k in m.get('Node'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodesNode()
                self.node.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroup(TeaModel):
    def __init__(
        self,
        lock_type: str = None,
        host_group_sub_type: str = None,
        host_group_type: str = None,
        host_group_change_status: str = None,
        charge_type: str = None,
        lock_reason: str = None,
        disk_type: str = None,
        host_group_id: str = None,
        band_width: str = None,
        instance_type: str = None,
        disk_count: int = None,
        period: str = None,
        disk_capacity: int = None,
        cpu_core: int = None,
        memory_capacity: int = None,
        node_count: int = None,
        host_group_change_type: str = None,
        host_group_name: str = None,
        nodes: DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodes = None,
    ):
        self.lock_type = lock_type
        self.host_group_sub_type = host_group_sub_type
        self.host_group_type = host_group_type
        self.host_group_change_status = host_group_change_status
        self.charge_type = charge_type
        self.lock_reason = lock_reason
        self.disk_type = disk_type
        self.host_group_id = host_group_id
        self.band_width = band_width
        self.instance_type = instance_type
        self.disk_count = disk_count
        self.period = period
        self.disk_capacity = disk_capacity
        self.cpu_core = cpu_core
        self.memory_capacity = memory_capacity
        self.node_count = node_count
        self.host_group_change_type = host_group_change_type
        self.host_group_name = host_group_name
        self.nodes = nodes

    def validate(self):
        if self.nodes:
            self.nodes.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lock_type is not None:
            result['LockType'] = self.lock_type
        if self.host_group_sub_type is not None:
            result['HostGroupSubType'] = self.host_group_sub_type
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.host_group_change_status is not None:
            result['HostGroupChangeStatus'] = self.host_group_change_status
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.band_width is not None:
            result['BandWidth'] = self.band_width
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        if self.period is not None:
            result['Period'] = self.period
        if self.disk_capacity is not None:
            result['DiskCapacity'] = self.disk_capacity
        if self.cpu_core is not None:
            result['CpuCore'] = self.cpu_core
        if self.memory_capacity is not None:
            result['MemoryCapacity'] = self.memory_capacity
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.host_group_change_type is not None:
            result['HostGroupChangeType'] = self.host_group_change_type
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        if self.nodes is not None:
            result['Nodes'] = self.nodes.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LockType') is not None:
            self.lock_type = m.get('LockType')
        if m.get('HostGroupSubType') is not None:
            self.host_group_sub_type = m.get('HostGroupSubType')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('HostGroupChangeStatus') is not None:
            self.host_group_change_status = m.get('HostGroupChangeStatus')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('BandWidth') is not None:
            self.band_width = m.get('BandWidth')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('DiskCapacity') is not None:
            self.disk_capacity = m.get('DiskCapacity')
        if m.get('CpuCore') is not None:
            self.cpu_core = m.get('CpuCore')
        if m.get('MemoryCapacity') is not None:
            self.memory_capacity = m.get('MemoryCapacity')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('HostGroupChangeType') is not None:
            self.host_group_change_type = m.get('HostGroupChangeType')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        if m.get('Nodes') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroupNodes()
            self.nodes = temp_model.from_map(m['Nodes'])
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostGroupList(TeaModel):
    def __init__(
        self,
        host_group: List[DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroup] = None,
    ):
        self.host_group = host_group

    def validate(self):
        if self.host_group:
            for k in self.host_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HostGroup'] = []
        if self.host_group is not None:
            for k in self.host_group:
                result['HostGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.host_group = []
        if m.get('HostGroup') is not None:
            for k in m.get('HostGroup'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupListHostGroup()
                self.host_group.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoBootstrapActionListBootstrapAction(TeaModel):
    def __init__(
        self,
        path: str = None,
        name: str = None,
        arg: str = None,
    ):
        self.path = path
        self.name = name
        self.arg = arg

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.name is not None:
            result['Name'] = self.name
        if self.arg is not None:
            result['Arg'] = self.arg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Arg') is not None:
            self.arg = m.get('Arg')
        return self


class DescribeClusterV2ResponseBodyClusterInfoBootstrapActionList(TeaModel):
    def __init__(
        self,
        bootstrap_action: List[DescribeClusterV2ResponseBodyClusterInfoBootstrapActionListBootstrapAction] = None,
    ):
        self.bootstrap_action = bootstrap_action

    def validate(self):
        if self.bootstrap_action:
            for k in self.bootstrap_action:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BootstrapAction'] = []
        if self.bootstrap_action is not None:
            for k in self.bootstrap_action:
                result['BootstrapAction'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bootstrap_action = []
        if m.get('BootstrapAction') is not None:
            for k in m.get('BootstrapAction'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoBootstrapActionListBootstrapAction()
                self.bootstrap_action.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoRelateClusterInfo(TeaModel):
    def __init__(
        self,
        cluster_name: str = None,
        status: str = None,
        cluster_id: str = None,
    ):
        self.cluster_name = cluster_name
        self.status = status
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.status is not None:
            result['Status'] = self.status
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeClusterV2ResponseBodyClusterInfoHostPoolInfo(TeaModel):
    def __init__(
        self,
        hp_name: str = None,
        hp_biz_id: str = None,
    ):
        self.hp_name = hp_name
        self.hp_biz_id = hp_biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hp_name is not None:
            result['HpName'] = self.hp_name
        if self.hp_biz_id is not None:
            result['HpBizId'] = self.hp_biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HpName') is not None:
            self.hp_name = m.get('HpName')
        if m.get('HpBizId') is not None:
            self.hp_biz_id = m.get('HpBizId')
        return self


class DescribeClusterV2ResponseBodyClusterInfoFailReason(TeaModel):
    def __init__(
        self,
        error_msg: str = None,
        request_id: str = None,
        error_code: str = None,
    ):
        self.error_msg = error_msg
        self.request_id = request_id
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_msg is not None:
            result['ErrorMsg'] = self.error_msg
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMsg') is not None:
            self.error_msg = m.get('ErrorMsg')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class DescribeClusterV2ResponseBodyClusterInfoSoftwareInfoSoftwaresSoftware(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        only_display: bool = None,
        start_tpe: int = None,
        name: str = None,
        version: str = None,
    ):
        self.display_name = display_name
        self.only_display = only_display
        self.start_tpe = start_tpe
        self.name = name
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.only_display is not None:
            result['OnlyDisplay'] = self.only_display
        if self.start_tpe is not None:
            result['StartTpe'] = self.start_tpe
        if self.name is not None:
            result['Name'] = self.name
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('OnlyDisplay') is not None:
            self.only_display = m.get('OnlyDisplay')
        if m.get('StartTpe') is not None:
            self.start_tpe = m.get('StartTpe')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class DescribeClusterV2ResponseBodyClusterInfoSoftwareInfoSoftwares(TeaModel):
    def __init__(
        self,
        software: List[DescribeClusterV2ResponseBodyClusterInfoSoftwareInfoSoftwaresSoftware] = None,
    ):
        self.software = software

    def validate(self):
        if self.software:
            for k in self.software:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Software'] = []
        if self.software is not None:
            for k in self.software:
                result['Software'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.software = []
        if m.get('Software') is not None:
            for k in m.get('Software'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoSoftwareInfoSoftwaresSoftware()
                self.software.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoSoftwareInfo(TeaModel):
    def __init__(
        self,
        cluster_type: str = None,
        emr_ver: str = None,
        softwares: DescribeClusterV2ResponseBodyClusterInfoSoftwareInfoSoftwares = None,
    ):
        self.cluster_type = cluster_type
        self.emr_ver = emr_ver
        self.softwares = softwares

    def validate(self):
        if self.softwares:
            self.softwares.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.emr_ver is not None:
            result['EmrVer'] = self.emr_ver
        if self.softwares is not None:
            result['Softwares'] = self.softwares.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('EmrVer') is not None:
            self.emr_ver = m.get('EmrVer')
        if m.get('Softwares') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoSoftwareInfoSoftwares()
            self.softwares = temp_model.from_map(m['Softwares'])
        return self


class DescribeClusterV2ResponseBodyClusterInfoAccessInfoZKLinksZKLink(TeaModel):
    def __init__(
        self,
        port: str = None,
        link: str = None,
    ):
        self.port = port
        self.link = link

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port is not None:
            result['Port'] = self.port
        if self.link is not None:
            result['Link'] = self.link
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Link') is not None:
            self.link = m.get('Link')
        return self


class DescribeClusterV2ResponseBodyClusterInfoAccessInfoZKLinks(TeaModel):
    def __init__(
        self,
        zklink: List[DescribeClusterV2ResponseBodyClusterInfoAccessInfoZKLinksZKLink] = None,
    ):
        self.zklink = zklink

    def validate(self):
        if self.zklink:
            for k in self.zklink:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ZKLink'] = []
        if self.zklink is not None:
            for k in self.zklink:
                result['ZKLink'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.zklink = []
        if m.get('ZKLink') is not None:
            for k in m.get('ZKLink'):
                temp_model = DescribeClusterV2ResponseBodyClusterInfoAccessInfoZKLinksZKLink()
                self.zklink.append(temp_model.from_map(k))
        return self


class DescribeClusterV2ResponseBodyClusterInfoAccessInfo(TeaModel):
    def __init__(
        self,
        zklinks: DescribeClusterV2ResponseBodyClusterInfoAccessInfoZKLinks = None,
    ):
        self.zklinks = zklinks

    def validate(self):
        if self.zklinks:
            self.zklinks.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.zklinks is not None:
            result['ZKLinks'] = self.zklinks.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ZKLinks') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoAccessInfoZKLinks()
            self.zklinks = temp_model.from_map(m['ZKLinks'])
        return self


class DescribeClusterV2ResponseBodyClusterInfo(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
        log_enable: bool = None,
        task_node_in_service: int = None,
        auto_scaling_spot_with_limit_allowed: bool = None,
        user_id: str = None,
        charge_type: str = None,
        stop_time: int = None,
        deposit_type: str = None,
        create_type: str = None,
        relate_cluster_id: str = None,
        security_group_name: str = None,
        resize_disk_enable: bool = None,
        image_id: str = None,
        user_defined_emr_ecs_role: str = None,
        meta_store_type: str = None,
        start_time: int = None,
        configurations: str = None,
        log_path: str = None,
        auto_scaling_version: str = None,
        net_type: str = None,
        zone_id: str = None,
        create_resource: str = None,
        status: str = None,
        running_time: int = None,
        high_availability_enable: bool = None,
        security_group_id: str = None,
        auto_scaling_allowed: bool = None,
        master_node_in_service: int = None,
        auto_scaling_enable: bool = None,
        auto_scaling_with_grace_allowed: bool = None,
        core_node_in_service: int = None,
        show_software_interface: bool = None,
        k_8s_cluster_id: str = None,
        auto_scaling_by_load_allowed: bool = None,
        local_meta_db: bool = None,
        instance_generation: str = None,
        name: str = None,
        eas_enable: bool = None,
        machine_type: str = None,
        master_node_total: int = None,
        region_id: str = None,
        period: int = None,
        extra_info: str = None,
        io_optimized: bool = None,
        v_switch_id: str = None,
        expired_time: int = None,
        core_node_total: int = None,
        gateway_cluster_ids: str = None,
        bootstrap_failed: bool = None,
        id: str = None,
        task_node_total: int = None,
        gateway_cluster_info_list: DescribeClusterV2ResponseBodyClusterInfoGatewayClusterInfoList = None,
        host_group_list: DescribeClusterV2ResponseBodyClusterInfoHostGroupList = None,
        bootstrap_action_list: DescribeClusterV2ResponseBodyClusterInfoBootstrapActionList = None,
        relate_cluster_info: DescribeClusterV2ResponseBodyClusterInfoRelateClusterInfo = None,
        host_pool_info: DescribeClusterV2ResponseBodyClusterInfoHostPoolInfo = None,
        fail_reason: DescribeClusterV2ResponseBodyClusterInfoFailReason = None,
        software_info: DescribeClusterV2ResponseBodyClusterInfoSoftwareInfo = None,
        access_info: DescribeClusterV2ResponseBodyClusterInfoAccessInfo = None,
    ):
        self.vpc_id = vpc_id
        self.log_enable = log_enable
        self.task_node_in_service = task_node_in_service
        self.auto_scaling_spot_with_limit_allowed = auto_scaling_spot_with_limit_allowed
        self.user_id = user_id
        self.charge_type = charge_type
        self.stop_time = stop_time
        self.deposit_type = deposit_type
        self.create_type = create_type
        self.relate_cluster_id = relate_cluster_id
        self.security_group_name = security_group_name
        self.resize_disk_enable = resize_disk_enable
        self.image_id = image_id
        self.user_defined_emr_ecs_role = user_defined_emr_ecs_role
        self.meta_store_type = meta_store_type
        self.start_time = start_time
        self.configurations = configurations
        self.log_path = log_path
        self.auto_scaling_version = auto_scaling_version
        self.net_type = net_type
        self.zone_id = zone_id
        self.create_resource = create_resource
        self.status = status
        self.running_time = running_time
        self.high_availability_enable = high_availability_enable
        self.security_group_id = security_group_id
        self.auto_scaling_allowed = auto_scaling_allowed
        self.master_node_in_service = master_node_in_service
        self.auto_scaling_enable = auto_scaling_enable
        self.auto_scaling_with_grace_allowed = auto_scaling_with_grace_allowed
        self.core_node_in_service = core_node_in_service
        self.show_software_interface = show_software_interface
        self.k_8s_cluster_id = k_8s_cluster_id
        self.auto_scaling_by_load_allowed = auto_scaling_by_load_allowed
        self.local_meta_db = local_meta_db
        self.instance_generation = instance_generation
        self.name = name
        self.eas_enable = eas_enable
        self.machine_type = machine_type
        self.master_node_total = master_node_total
        self.region_id = region_id
        self.period = period
        self.extra_info = extra_info
        self.io_optimized = io_optimized
        self.v_switch_id = v_switch_id
        self.expired_time = expired_time
        self.core_node_total = core_node_total
        self.gateway_cluster_ids = gateway_cluster_ids
        self.bootstrap_failed = bootstrap_failed
        self.id = id
        self.task_node_total = task_node_total
        self.gateway_cluster_info_list = gateway_cluster_info_list
        self.host_group_list = host_group_list
        self.bootstrap_action_list = bootstrap_action_list
        self.relate_cluster_info = relate_cluster_info
        self.host_pool_info = host_pool_info
        self.fail_reason = fail_reason
        self.software_info = software_info
        self.access_info = access_info

    def validate(self):
        if self.gateway_cluster_info_list:
            self.gateway_cluster_info_list.validate()
        if self.host_group_list:
            self.host_group_list.validate()
        if self.bootstrap_action_list:
            self.bootstrap_action_list.validate()
        if self.relate_cluster_info:
            self.relate_cluster_info.validate()
        if self.host_pool_info:
            self.host_pool_info.validate()
        if self.fail_reason:
            self.fail_reason.validate()
        if self.software_info:
            self.software_info.validate()
        if self.access_info:
            self.access_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.log_enable is not None:
            result['LogEnable'] = self.log_enable
        if self.task_node_in_service is not None:
            result['TaskNodeInService'] = self.task_node_in_service
        if self.auto_scaling_spot_with_limit_allowed is not None:
            result['AutoScalingSpotWithLimitAllowed'] = self.auto_scaling_spot_with_limit_allowed
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.create_type is not None:
            result['CreateType'] = self.create_type
        if self.relate_cluster_id is not None:
            result['RelateClusterId'] = self.relate_cluster_id
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        if self.resize_disk_enable is not None:
            result['ResizeDiskEnable'] = self.resize_disk_enable
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.user_defined_emr_ecs_role is not None:
            result['UserDefinedEmrEcsRole'] = self.user_defined_emr_ecs_role
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.configurations is not None:
            result['Configurations'] = self.configurations
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.auto_scaling_version is not None:
            result['AutoScalingVersion'] = self.auto_scaling_version
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.create_resource is not None:
            result['CreateResource'] = self.create_resource
        if self.status is not None:
            result['Status'] = self.status
        if self.running_time is not None:
            result['RunningTime'] = self.running_time
        if self.high_availability_enable is not None:
            result['HighAvailabilityEnable'] = self.high_availability_enable
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.auto_scaling_allowed is not None:
            result['AutoScalingAllowed'] = self.auto_scaling_allowed
        if self.master_node_in_service is not None:
            result['MasterNodeInService'] = self.master_node_in_service
        if self.auto_scaling_enable is not None:
            result['AutoScalingEnable'] = self.auto_scaling_enable
        if self.auto_scaling_with_grace_allowed is not None:
            result['AutoScalingWithGraceAllowed'] = self.auto_scaling_with_grace_allowed
        if self.core_node_in_service is not None:
            result['CoreNodeInService'] = self.core_node_in_service
        if self.show_software_interface is not None:
            result['ShowSoftwareInterface'] = self.show_software_interface
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.auto_scaling_by_load_allowed is not None:
            result['AutoScalingByLoadAllowed'] = self.auto_scaling_by_load_allowed
        if self.local_meta_db is not None:
            result['LocalMetaDb'] = self.local_meta_db
        if self.instance_generation is not None:
            result['InstanceGeneration'] = self.instance_generation
        if self.name is not None:
            result['Name'] = self.name
        if self.eas_enable is not None:
            result['EasEnable'] = self.eas_enable
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.master_node_total is not None:
            result['MasterNodeTotal'] = self.master_node_total
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.period is not None:
            result['Period'] = self.period
        if self.extra_info is not None:
            result['ExtraInfo'] = self.extra_info
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.core_node_total is not None:
            result['CoreNodeTotal'] = self.core_node_total
        if self.gateway_cluster_ids is not None:
            result['GatewayClusterIds'] = self.gateway_cluster_ids
        if self.bootstrap_failed is not None:
            result['BootstrapFailed'] = self.bootstrap_failed
        if self.id is not None:
            result['Id'] = self.id
        if self.task_node_total is not None:
            result['TaskNodeTotal'] = self.task_node_total
        if self.gateway_cluster_info_list is not None:
            result['GatewayClusterInfoList'] = self.gateway_cluster_info_list.to_map()
        if self.host_group_list is not None:
            result['HostGroupList'] = self.host_group_list.to_map()
        if self.bootstrap_action_list is not None:
            result['BootstrapActionList'] = self.bootstrap_action_list.to_map()
        if self.relate_cluster_info is not None:
            result['RelateClusterInfo'] = self.relate_cluster_info.to_map()
        if self.host_pool_info is not None:
            result['HostPoolInfo'] = self.host_pool_info.to_map()
        if self.fail_reason is not None:
            result['FailReason'] = self.fail_reason.to_map()
        if self.software_info is not None:
            result['SoftwareInfo'] = self.software_info.to_map()
        if self.access_info is not None:
            result['AccessInfo'] = self.access_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('LogEnable') is not None:
            self.log_enable = m.get('LogEnable')
        if m.get('TaskNodeInService') is not None:
            self.task_node_in_service = m.get('TaskNodeInService')
        if m.get('AutoScalingSpotWithLimitAllowed') is not None:
            self.auto_scaling_spot_with_limit_allowed = m.get('AutoScalingSpotWithLimitAllowed')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('StopTime') is not None:
            self.stop_time = m.get('StopTime')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('CreateType') is not None:
            self.create_type = m.get('CreateType')
        if m.get('RelateClusterId') is not None:
            self.relate_cluster_id = m.get('RelateClusterId')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        if m.get('ResizeDiskEnable') is not None:
            self.resize_disk_enable = m.get('ResizeDiskEnable')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('UserDefinedEmrEcsRole') is not None:
            self.user_defined_emr_ecs_role = m.get('UserDefinedEmrEcsRole')
        if m.get('MetaStoreType') is not None:
            self.meta_store_type = m.get('MetaStoreType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Configurations') is not None:
            self.configurations = m.get('Configurations')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('AutoScalingVersion') is not None:
            self.auto_scaling_version = m.get('AutoScalingVersion')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('CreateResource') is not None:
            self.create_resource = m.get('CreateResource')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('RunningTime') is not None:
            self.running_time = m.get('RunningTime')
        if m.get('HighAvailabilityEnable') is not None:
            self.high_availability_enable = m.get('HighAvailabilityEnable')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('AutoScalingAllowed') is not None:
            self.auto_scaling_allowed = m.get('AutoScalingAllowed')
        if m.get('MasterNodeInService') is not None:
            self.master_node_in_service = m.get('MasterNodeInService')
        if m.get('AutoScalingEnable') is not None:
            self.auto_scaling_enable = m.get('AutoScalingEnable')
        if m.get('AutoScalingWithGraceAllowed') is not None:
            self.auto_scaling_with_grace_allowed = m.get('AutoScalingWithGraceAllowed')
        if m.get('CoreNodeInService') is not None:
            self.core_node_in_service = m.get('CoreNodeInService')
        if m.get('ShowSoftwareInterface') is not None:
            self.show_software_interface = m.get('ShowSoftwareInterface')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('AutoScalingByLoadAllowed') is not None:
            self.auto_scaling_by_load_allowed = m.get('AutoScalingByLoadAllowed')
        if m.get('LocalMetaDb') is not None:
            self.local_meta_db = m.get('LocalMetaDb')
        if m.get('InstanceGeneration') is not None:
            self.instance_generation = m.get('InstanceGeneration')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('EasEnable') is not None:
            self.eas_enable = m.get('EasEnable')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('MasterNodeTotal') is not None:
            self.master_node_total = m.get('MasterNodeTotal')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('ExtraInfo') is not None:
            self.extra_info = m.get('ExtraInfo')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('CoreNodeTotal') is not None:
            self.core_node_total = m.get('CoreNodeTotal')
        if m.get('GatewayClusterIds') is not None:
            self.gateway_cluster_ids = m.get('GatewayClusterIds')
        if m.get('BootstrapFailed') is not None:
            self.bootstrap_failed = m.get('BootstrapFailed')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('TaskNodeTotal') is not None:
            self.task_node_total = m.get('TaskNodeTotal')
        if m.get('GatewayClusterInfoList') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoGatewayClusterInfoList()
            self.gateway_cluster_info_list = temp_model.from_map(m['GatewayClusterInfoList'])
        if m.get('HostGroupList') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoHostGroupList()
            self.host_group_list = temp_model.from_map(m['HostGroupList'])
        if m.get('BootstrapActionList') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoBootstrapActionList()
            self.bootstrap_action_list = temp_model.from_map(m['BootstrapActionList'])
        if m.get('RelateClusterInfo') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoRelateClusterInfo()
            self.relate_cluster_info = temp_model.from_map(m['RelateClusterInfo'])
        if m.get('HostPoolInfo') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoHostPoolInfo()
            self.host_pool_info = temp_model.from_map(m['HostPoolInfo'])
        if m.get('FailReason') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoFailReason()
            self.fail_reason = temp_model.from_map(m['FailReason'])
        if m.get('SoftwareInfo') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoSoftwareInfo()
            self.software_info = temp_model.from_map(m['SoftwareInfo'])
        if m.get('AccessInfo') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfoAccessInfo()
            self.access_info = temp_model.from_map(m['AccessInfo'])
        return self


class DescribeClusterV2ResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        cluster_info: DescribeClusterV2ResponseBodyClusterInfo = None,
    ):
        self.request_id = request_id
        self.cluster_info = cluster_info

    def validate(self):
        if self.cluster_info:
            self.cluster_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.cluster_info is not None:
            result['ClusterInfo'] = self.cluster_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ClusterInfo') is not None:
            temp_model = DescribeClusterV2ResponseBodyClusterInfo()
            self.cluster_info = temp_model.from_map(m['ClusterInfo'])
        return self


class DescribeClusterV2Response(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeClusterV2ResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClusterV2ResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        id: str = None,
        region_id: str = None,
    ):
        self.project_id = project_id
        self.id = id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowResponseBodyParentFlowListParentFlow(TeaModel):
    def __init__(
        self,
        parent_flow_name: str = None,
        parent_flow_id: str = None,
        project_name: str = None,
        project_id: str = None,
    ):
        self.parent_flow_name = parent_flow_name
        self.parent_flow_id = parent_flow_id
        self.project_name = project_name
        self.project_id = project_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parent_flow_name is not None:
            result['ParentFlowName'] = self.parent_flow_name
        if self.parent_flow_id is not None:
            result['ParentFlowId'] = self.parent_flow_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ParentFlowName') is not None:
            self.parent_flow_name = m.get('ParentFlowName')
        if m.get('ParentFlowId') is not None:
            self.parent_flow_id = m.get('ParentFlowId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DescribeFlowResponseBodyParentFlowList(TeaModel):
    def __init__(
        self,
        parent_flow: List[DescribeFlowResponseBodyParentFlowListParentFlow] = None,
    ):
        self.parent_flow = parent_flow

    def validate(self):
        if self.parent_flow:
            for k in self.parent_flow:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ParentFlow'] = []
        if self.parent_flow is not None:
            for k in self.parent_flow:
                result['ParentFlow'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.parent_flow = []
        if m.get('ParentFlow') is not None:
            for k in m.get('ParentFlow'):
                temp_model = DescribeFlowResponseBodyParentFlowListParentFlow()
                self.parent_flow.append(temp_model.from_map(k))
        return self


class DescribeFlowResponseBody(TeaModel):
    def __init__(
        self,
        status: str = None,
        type: str = None,
        alert_user_group_biz_id: str = None,
        periodic: bool = None,
        edit_lock_detail: str = None,
        namespace: str = None,
        host_name: str = None,
        application: str = None,
        gmt_modified: int = None,
        request_id: str = None,
        description: str = None,
        create_cluster: bool = None,
        start_schedule: int = None,
        end_schedule: int = None,
        graph: str = None,
        alert_ding_ding_group_biz_id: str = None,
        gmt_create: int = None,
        category_id: str = None,
        cron_expr: str = None,
        name: str = None,
        id: str = None,
        alert_conf: str = None,
        cluster_id: str = None,
        parent_flow_list: DescribeFlowResponseBodyParentFlowList = None,
    ):
        self.status = status
        self.type = type
        self.alert_user_group_biz_id = alert_user_group_biz_id
        self.periodic = periodic
        self.edit_lock_detail = edit_lock_detail
        self.namespace = namespace
        self.host_name = host_name
        self.application = application
        self.gmt_modified = gmt_modified
        self.request_id = request_id
        self.description = description
        self.create_cluster = create_cluster
        self.start_schedule = start_schedule
        self.end_schedule = end_schedule
        self.graph = graph
        self.alert_ding_ding_group_biz_id = alert_ding_ding_group_biz_id
        self.gmt_create = gmt_create
        self.category_id = category_id
        self.cron_expr = cron_expr
        self.name = name
        self.id = id
        self.alert_conf = alert_conf
        self.cluster_id = cluster_id
        self.parent_flow_list = parent_flow_list

    def validate(self):
        if self.parent_flow_list:
            self.parent_flow_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.alert_user_group_biz_id is not None:
            result['AlertUserGroupBizId'] = self.alert_user_group_biz_id
        if self.periodic is not None:
            result['Periodic'] = self.periodic
        if self.edit_lock_detail is not None:
            result['EditLockDetail'] = self.edit_lock_detail
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.application is not None:
            result['Application'] = self.application
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.description is not None:
            result['Description'] = self.description
        if self.create_cluster is not None:
            result['CreateCluster'] = self.create_cluster
        if self.start_schedule is not None:
            result['StartSchedule'] = self.start_schedule
        if self.end_schedule is not None:
            result['EndSchedule'] = self.end_schedule
        if self.graph is not None:
            result['Graph'] = self.graph
        if self.alert_ding_ding_group_biz_id is not None:
            result['AlertDingDingGroupBizId'] = self.alert_ding_ding_group_biz_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.cron_expr is not None:
            result['CronExpr'] = self.cron_expr
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.parent_flow_list is not None:
            result['ParentFlowList'] = self.parent_flow_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('AlertUserGroupBizId') is not None:
            self.alert_user_group_biz_id = m.get('AlertUserGroupBizId')
        if m.get('Periodic') is not None:
            self.periodic = m.get('Periodic')
        if m.get('EditLockDetail') is not None:
            self.edit_lock_detail = m.get('EditLockDetail')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Application') is not None:
            self.application = m.get('Application')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('CreateCluster') is not None:
            self.create_cluster = m.get('CreateCluster')
        if m.get('StartSchedule') is not None:
            self.start_schedule = m.get('StartSchedule')
        if m.get('EndSchedule') is not None:
            self.end_schedule = m.get('EndSchedule')
        if m.get('Graph') is not None:
            self.graph = m.get('Graph')
        if m.get('AlertDingDingGroupBizId') is not None:
            self.alert_ding_ding_group_biz_id = m.get('AlertDingDingGroupBizId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('CronExpr') is not None:
            self.cron_expr = m.get('CronExpr')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ParentFlowList') is not None:
            temp_model = DescribeFlowResponseBodyParentFlowList()
            self.parent_flow_list = temp_model.from_map(m['ParentFlowList'])
        return self


class DescribeFlowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowClusterRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        page_number: int = None,
        page_size: int = None,
        resource_group_id: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.page_number = page_number
        self.page_size = page_size
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class ListFlowClusterResponseBodyClustersClusterInfoOrderTaskInfo(TeaModel):
    def __init__(
        self,
        target_count: int = None,
        current_count: int = None,
        order_id_list: str = None,
    ):
        self.target_count = target_count
        self.current_count = current_count
        self.order_id_list = order_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_count is not None:
            result['TargetCount'] = self.target_count
        if self.current_count is not None:
            result['CurrentCount'] = self.current_count
        if self.order_id_list is not None:
            result['OrderIdList'] = self.order_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TargetCount') is not None:
            self.target_count = m.get('TargetCount')
        if m.get('CurrentCount') is not None:
            self.current_count = m.get('CurrentCount')
        if m.get('OrderIdList') is not None:
            self.order_id_list = m.get('OrderIdList')
        return self


class ListFlowClusterResponseBodyClustersClusterInfoFailReason(TeaModel):
    def __init__(
        self,
        error_msg: str = None,
        request_id: str = None,
        error_code: str = None,
    ):
        self.error_msg = error_msg
        self.request_id = request_id
        self.error_code = error_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_msg is not None:
            result['ErrorMsg'] = self.error_msg
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMsg') is not None:
            self.error_msg = m.get('ErrorMsg')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        return self


class ListFlowClusterResponseBodyClustersClusterInfo(TeaModel):
    def __init__(
        self,
        type: str = None,
        status: str = None,
        running_time: int = None,
        order_list: str = None,
        create_time: int = None,
        charge_type: str = None,
        period: int = None,
        k_8s_cluster_id: str = None,
        expired_time: int = None,
        has_uncompleted_order: bool = None,
        name: str = None,
        id: str = None,
        create_resource: str = None,
        order_task_info: ListFlowClusterResponseBodyClustersClusterInfoOrderTaskInfo = None,
        fail_reason: ListFlowClusterResponseBodyClustersClusterInfoFailReason = None,
    ):
        self.type = type
        self.status = status
        self.running_time = running_time
        self.order_list = order_list
        self.create_time = create_time
        self.charge_type = charge_type
        self.period = period
        self.k_8s_cluster_id = k_8s_cluster_id
        self.expired_time = expired_time
        self.has_uncompleted_order = has_uncompleted_order
        self.name = name
        self.id = id
        self.create_resource = create_resource
        self.order_task_info = order_task_info
        self.fail_reason = fail_reason

    def validate(self):
        if self.order_task_info:
            self.order_task_info.validate()
        if self.fail_reason:
            self.fail_reason.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.status is not None:
            result['Status'] = self.status
        if self.running_time is not None:
            result['RunningTime'] = self.running_time
        if self.order_list is not None:
            result['OrderList'] = self.order_list
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.period is not None:
            result['Period'] = self.period
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.has_uncompleted_order is not None:
            result['HasUncompletedOrder'] = self.has_uncompleted_order
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        if self.create_resource is not None:
            result['CreateResource'] = self.create_resource
        if self.order_task_info is not None:
            result['OrderTaskInfo'] = self.order_task_info.to_map()
        if self.fail_reason is not None:
            result['FailReason'] = self.fail_reason.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('RunningTime') is not None:
            self.running_time = m.get('RunningTime')
        if m.get('OrderList') is not None:
            self.order_list = m.get('OrderList')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('HasUncompletedOrder') is not None:
            self.has_uncompleted_order = m.get('HasUncompletedOrder')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('CreateResource') is not None:
            self.create_resource = m.get('CreateResource')
        if m.get('OrderTaskInfo') is not None:
            temp_model = ListFlowClusterResponseBodyClustersClusterInfoOrderTaskInfo()
            self.order_task_info = temp_model.from_map(m['OrderTaskInfo'])
        if m.get('FailReason') is not None:
            temp_model = ListFlowClusterResponseBodyClustersClusterInfoFailReason()
            self.fail_reason = temp_model.from_map(m['FailReason'])
        return self


class ListFlowClusterResponseBodyClusters(TeaModel):
    def __init__(
        self,
        cluster_info: List[ListFlowClusterResponseBodyClustersClusterInfo] = None,
    ):
        self.cluster_info = cluster_info

    def validate(self):
        if self.cluster_info:
            for k in self.cluster_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterInfo'] = []
        if self.cluster_info is not None:
            for k in self.cluster_info:
                result['ClusterInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_info = []
        if m.get('ClusterInfo') is not None:
            for k in m.get('ClusterInfo'):
                temp_model = ListFlowClusterResponseBodyClustersClusterInfo()
                self.cluster_info.append(temp_model.from_map(k))
        return self


class ListFlowClusterResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        total_count: int = None,
        clusters: ListFlowClusterResponseBodyClusters = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.total_count = total_count
        self.clusters = clusters

    def validate(self):
        if self.clusters:
            self.clusters.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.clusters is not None:
            result['Clusters'] = self.clusters.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Clusters') is not None:
            temp_model = ListFlowClusterResponseBodyClusters()
            self.clusters = temp_model.from_map(m['Clusters'])
        return self


class ListFlowClusterResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListFlowClusterResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLdapUsersRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        user_name_search: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.user_name_search = user_name_search

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.user_name_search is not None:
            result['UserNameSearch'] = self.user_name_search
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('UserNameSearch') is not None:
            self.user_name_search = m.get('UserNameSearch')
        return self


class ListLdapUsersResponseBodyUserListUser(TeaModel):
    def __init__(
        self,
        user_create_time: int = None,
        group_name: str = None,
        user_id: str = None,
        note: str = None,
        keytab_hex: str = None,
        user_name: str = None,
    ):
        self.user_create_time = user_create_time
        self.group_name = group_name
        self.user_id = user_id
        self.note = note
        self.keytab_hex = keytab_hex
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_create_time is not None:
            result['UserCreateTime'] = self.user_create_time
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.note is not None:
            result['Note'] = self.note
        if self.keytab_hex is not None:
            result['KeytabHex'] = self.keytab_hex
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UserCreateTime') is not None:
            self.user_create_time = m.get('UserCreateTime')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Note') is not None:
            self.note = m.get('Note')
        if m.get('KeytabHex') is not None:
            self.keytab_hex = m.get('KeytabHex')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class ListLdapUsersResponseBodyUserList(TeaModel):
    def __init__(
        self,
        user: List[ListLdapUsersResponseBodyUserListUser] = None,
    ):
        self.user = user

    def validate(self):
        if self.user:
            for k in self.user:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['User'] = []
        if self.user is not None:
            for k in self.user:
                result['User'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.user = []
        if m.get('User') is not None:
            for k in m.get('User'):
                temp_model = ListLdapUsersResponseBodyUserListUser()
                self.user.append(temp_model.from_map(k))
        return self


class ListLdapUsersResponseBody(TeaModel):
    def __init__(
        self,
        is_admin: bool = None,
        request_id: str = None,
        user_list: ListLdapUsersResponseBodyUserList = None,
    ):
        self.is_admin = is_admin
        self.request_id = request_id
        self.user_list = user_list

    def validate(self):
        if self.user_list:
            self.user_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_admin is not None:
            result['IsAdmin'] = self.is_admin
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_list is not None:
            result['UserList'] = self.user_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsAdmin') is not None:
            self.is_admin = m.get('IsAdmin')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserList') is not None:
            temp_model = ListLdapUsersResponseBodyUserList()
            self.user_list = temp_model.from_map(m['UserList'])
        return self


class ListLdapUsersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListLdapUsersResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListLdapUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteUserRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        user_id: str = None,
        type: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.user_id = user_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteUserResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowProjectClusterSettingRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        cluster_id: str = None,
        default_user: str = None,
        default_queue: str = None,
        client_token: str = None,
        user_list: List[str] = None,
        queue_list: List[str] = None,
        host_list: List[str] = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.cluster_id = cluster_id
        self.default_user = default_user
        self.default_queue = default_queue
        self.client_token = client_token
        self.user_list = user_list
        self.queue_list = queue_list
        self.host_list = host_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.default_user is not None:
            result['DefaultUser'] = self.default_user
        if self.default_queue is not None:
            result['DefaultQueue'] = self.default_queue
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.user_list is not None:
            result['UserList'] = self.user_list
        if self.queue_list is not None:
            result['QueueList'] = self.queue_list
        if self.host_list is not None:
            result['HostList'] = self.host_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DefaultUser') is not None:
            self.default_user = m.get('DefaultUser')
        if m.get('DefaultQueue') is not None:
            self.default_queue = m.get('DefaultQueue')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('UserList') is not None:
            self.user_list = m.get('UserList')
        if m.get('QueueList') is not None:
            self.queue_list = m.get('QueueList')
        if m.get('HostList') is not None:
            self.host_list = m.get('HostList')
        return self


class CreateFlowProjectClusterSettingResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateFlowProjectClusterSettingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFlowProjectClusterSettingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowProjectClusterSettingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowInstanceRequest(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        id: str = None,
        region_id: str = None,
    ):
        self.project_id = project_id
        self.id = id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFlowInstanceResponseBodyDependencyFlowListParentFlow(TeaModel):
    def __init__(
        self,
        schedule_key: str = None,
        biz_date: int = None,
        dependency_instance_id: str = None,
        dependency_flow_id: str = None,
        meet: bool = None,
        flow_instance_id: str = None,
        project_id: str = None,
        flow_id: str = None,
    ):
        self.schedule_key = schedule_key
        self.biz_date = biz_date
        self.dependency_instance_id = dependency_instance_id
        self.dependency_flow_id = dependency_flow_id
        self.meet = meet
        self.flow_instance_id = flow_instance_id
        self.project_id = project_id
        self.flow_id = flow_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.schedule_key is not None:
            result['ScheduleKey'] = self.schedule_key
        if self.biz_date is not None:
            result['BizDate'] = self.biz_date
        if self.dependency_instance_id is not None:
            result['DependencyInstanceId'] = self.dependency_instance_id
        if self.dependency_flow_id is not None:
            result['DependencyFlowId'] = self.dependency_flow_id
        if self.meet is not None:
            result['Meet'] = self.meet
        if self.flow_instance_id is not None:
            result['FlowInstanceId'] = self.flow_instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScheduleKey') is not None:
            self.schedule_key = m.get('ScheduleKey')
        if m.get('BizDate') is not None:
            self.biz_date = m.get('BizDate')
        if m.get('DependencyInstanceId') is not None:
            self.dependency_instance_id = m.get('DependencyInstanceId')
        if m.get('DependencyFlowId') is not None:
            self.dependency_flow_id = m.get('DependencyFlowId')
        if m.get('Meet') is not None:
            self.meet = m.get('Meet')
        if m.get('FlowInstanceId') is not None:
            self.flow_instance_id = m.get('FlowInstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        return self


class DescribeFlowInstanceResponseBodyDependencyFlowList(TeaModel):
    def __init__(
        self,
        parent_flow: List[DescribeFlowInstanceResponseBodyDependencyFlowListParentFlow] = None,
    ):
        self.parent_flow = parent_flow

    def validate(self):
        if self.parent_flow:
            for k in self.parent_flow:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ParentFlow'] = []
        if self.parent_flow is not None:
            for k in self.parent_flow:
                result['ParentFlow'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.parent_flow = []
        if m.get('ParentFlow') is not None:
            for k in m.get('ParentFlow'):
                temp_model = DescribeFlowInstanceResponseBodyDependencyFlowListParentFlow()
                self.parent_flow.append(temp_model.from_map(k))
        return self


class DescribeFlowInstanceResponseBodyNodeInstanceNodeInstance(TeaModel):
    def __init__(
        self,
        status: str = None,
        type: str = None,
        fail_act: str = None,
        project_id: str = None,
        retry_interval: str = None,
        job_type: str = None,
        host_name: str = None,
        external_info: str = None,
        gmt_modified: int = None,
        retries: int = None,
        end_time: int = None,
        start_time: int = None,
        external_status: str = None,
        job_name: str = None,
        node_name: str = None,
        job_id: str = None,
        gmt_create: int = None,
        external_id: str = None,
        duration: int = None,
        id: str = None,
        pending: bool = None,
        cluster_id: str = None,
        max_retry: str = None,
    ):
        self.status = status
        self.type = type
        self.fail_act = fail_act
        self.project_id = project_id
        self.retry_interval = retry_interval
        self.job_type = job_type
        self.host_name = host_name
        self.external_info = external_info
        self.gmt_modified = gmt_modified
        self.retries = retries
        self.end_time = end_time
        self.start_time = start_time
        self.external_status = external_status
        self.job_name = job_name
        self.node_name = node_name
        self.job_id = job_id
        self.gmt_create = gmt_create
        self.external_id = external_id
        self.duration = duration
        self.id = id
        self.pending = pending
        self.cluster_id = cluster_id
        self.max_retry = max_retry

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.fail_act is not None:
            result['FailAct'] = self.fail_act
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.external_info is not None:
            result['ExternalInfo'] = self.external_info
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.retries is not None:
            result['Retries'] = self.retries
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.external_status is not None:
            result['ExternalStatus'] = self.external_status
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.external_id is not None:
            result['ExternalId'] = self.external_id
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.id is not None:
            result['Id'] = self.id
        if self.pending is not None:
            result['Pending'] = self.pending
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.max_retry is not None:
            result['MaxRetry'] = self.max_retry
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('FailAct') is not None:
            self.fail_act = m.get('FailAct')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ExternalInfo') is not None:
            self.external_info = m.get('ExternalInfo')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Retries') is not None:
            self.retries = m.get('Retries')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('ExternalStatus') is not None:
            self.external_status = m.get('ExternalStatus')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('ExternalId') is not None:
            self.external_id = m.get('ExternalId')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Pending') is not None:
            self.pending = m.get('Pending')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('MaxRetry') is not None:
            self.max_retry = m.get('MaxRetry')
        return self


class DescribeFlowInstanceResponseBodyNodeInstance(TeaModel):
    def __init__(
        self,
        node_instance: List[DescribeFlowInstanceResponseBodyNodeInstanceNodeInstance] = None,
    ):
        self.node_instance = node_instance

    def validate(self):
        if self.node_instance:
            for k in self.node_instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NodeInstance'] = []
        if self.node_instance is not None:
            for k in self.node_instance:
                result['NodeInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.node_instance = []
        if m.get('NodeInstance') is not None:
            for k in m.get('NodeInstance'):
                temp_model = DescribeFlowInstanceResponseBodyNodeInstanceNodeInstance()
                self.node_instance.append(temp_model.from_map(k))
        return self


class DescribeFlowInstanceResponseBody(TeaModel):
    def __init__(
        self,
        status: str = None,
        project_id: str = None,
        namespace: str = None,
        flow_name: str = None,
        gmt_modified: int = None,
        flow_id: str = None,
        cron_expression: str = None,
        end_time: int = None,
        start_time: int = None,
        has_node_failed: bool = None,
        request_id: str = None,
        graph: str = None,
        gmt_create: int = None,
        schedule_time: int = None,
        duration: int = None,
        id: str = None,
        cluster_id: str = None,
        dependency_flow_list: DescribeFlowInstanceResponseBodyDependencyFlowList = None,
        node_instance: DescribeFlowInstanceResponseBodyNodeInstance = None,
    ):
        self.status = status
        self.project_id = project_id
        self.namespace = namespace
        self.flow_name = flow_name
        self.gmt_modified = gmt_modified
        self.flow_id = flow_id
        self.cron_expression = cron_expression
        self.end_time = end_time
        self.start_time = start_time
        self.has_node_failed = has_node_failed
        self.request_id = request_id
        self.graph = graph
        self.gmt_create = gmt_create
        self.schedule_time = schedule_time
        self.duration = duration
        self.id = id
        self.cluster_id = cluster_id
        self.dependency_flow_list = dependency_flow_list
        self.node_instance = node_instance

    def validate(self):
        if self.dependency_flow_list:
            self.dependency_flow_list.validate()
        if self.node_instance:
            self.node_instance.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.flow_name is not None:
            result['FlowName'] = self.flow_name
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.cron_expression is not None:
            result['CronExpression'] = self.cron_expression
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.has_node_failed is not None:
            result['HasNodeFailed'] = self.has_node_failed
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.graph is not None:
            result['Graph'] = self.graph
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.schedule_time is not None:
            result['ScheduleTime'] = self.schedule_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.id is not None:
            result['Id'] = self.id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.dependency_flow_list is not None:
            result['DependencyFlowList'] = self.dependency_flow_list.to_map()
        if self.node_instance is not None:
            result['NodeInstance'] = self.node_instance.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('FlowName') is not None:
            self.flow_name = m.get('FlowName')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('CronExpression') is not None:
            self.cron_expression = m.get('CronExpression')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('HasNodeFailed') is not None:
            self.has_node_failed = m.get('HasNodeFailed')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Graph') is not None:
            self.graph = m.get('Graph')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('ScheduleTime') is not None:
            self.schedule_time = m.get('ScheduleTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DependencyFlowList') is not None:
            temp_model = DescribeFlowInstanceResponseBodyDependencyFlowList()
            self.dependency_flow_list = temp_model.from_map(m['DependencyFlowList'])
        if m.get('NodeInstance') is not None:
            temp_model = DescribeFlowInstanceResponseBodyNodeInstance()
            self.node_instance = temp_model.from_map(m['NodeInstance'])
        return self


class DescribeFlowInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowInstanceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowProjectUserRequestUser(TeaModel):
    def __init__(
        self,
        user_id: str = None,
        user_name: str = None,
    ):
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class CreateFlowProjectUserRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        client_token: str = None,
        user: List[CreateFlowProjectUserRequestUser] = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.client_token = client_token
        self.user = user

    def validate(self):
        if self.user:
            for k in self.user:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        result['User'] = []
        if self.user is not None:
            for k in self.user:
                result['User'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        self.user = []
        if m.get('User') is not None:
            for k in m.get('User'):
                temp_model = CreateFlowProjectUserRequestUser()
                self.user.append(temp_model.from_map(k))
        return self


class CreateFlowProjectUserResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateFlowProjectUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFlowProjectUserResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowProjectUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowCategoryRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        name: str = None,
        type: str = None,
        parent_id: str = None,
        client_token: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.name = name
        self.type = type
        self.parent_id = parent_id
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.parent_id is not None:
            result['ParentId'] = self.parent_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ParentId') is not None:
            self.parent_id = m.get('ParentId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateFlowCategoryResponseBody(TeaModel):
    def __init__(
        self,
        id: str = None,
        request_id: str = None,
    ):
        self.id = id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateFlowCategoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFlowCategoryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowCategoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowProjectClusterSettingRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        cluster_id: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DeleteFlowProjectClusterSettingResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteFlowProjectClusterSettingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteFlowProjectClusterSettingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFlowProjectClusterSettingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLibrariesRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        limit: int = None,
        page_number: int = None,
        page_size: int = None,
        current_size: int = None,
        page_count: int = None,
        order_field: str = None,
        order_mode: str = None,
        cluster_biz_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.limit = limit
        self.page_number = page_number
        self.page_size = page_size
        self.current_size = current_size
        self.page_count = page_count
        self.order_field = order_field
        self.order_mode = order_mode
        self.cluster_biz_id = cluster_biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_size is not None:
            result['CurrentSize'] = self.current_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.order_field is not None:
            result['OrderField'] = self.order_field
        if self.order_mode is not None:
            result['OrderMode'] = self.order_mode
        if self.cluster_biz_id is not None:
            result['ClusterBizId'] = self.cluster_biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentSize') is not None:
            self.current_size = m.get('CurrentSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('OrderField') is not None:
            self.order_field = m.get('OrderField')
        if m.get('OrderMode') is not None:
            self.order_mode = m.get('OrderMode')
        if m.get('ClusterBizId') is not None:
            self.cluster_biz_id = m.get('ClusterBizId')
        return self


class ListLibrariesResponseBodyItemsItem(TeaModel):
    def __init__(
        self,
        type: str = None,
        create_time: int = None,
        user_id: str = None,
        source_type: str = None,
        biz_id: str = None,
        scope: str = None,
        library_version: str = None,
        name: str = None,
        properties: str = None,
        source_location: str = None,
    ):
        self.type = type
        self.create_time = create_time
        self.user_id = user_id
        self.source_type = source_type
        self.biz_id = biz_id
        self.scope = scope
        self.library_version = library_version
        self.name = name
        self.properties = properties
        self.source_location = source_location

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.biz_id is not None:
            result['BizId'] = self.biz_id
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.library_version is not None:
            result['LibraryVersion'] = self.library_version
        if self.name is not None:
            result['Name'] = self.name
        if self.properties is not None:
            result['Properties'] = self.properties
        if self.source_location is not None:
            result['SourceLocation'] = self.source_location
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('BizId') is not None:
            self.biz_id = m.get('BizId')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('LibraryVersion') is not None:
            self.library_version = m.get('LibraryVersion')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Properties') is not None:
            self.properties = m.get('Properties')
        if m.get('SourceLocation') is not None:
            self.source_location = m.get('SourceLocation')
        return self


class ListLibrariesResponseBodyItems(TeaModel):
    def __init__(
        self,
        item: List[ListLibrariesResponseBodyItemsItem] = None,
    ):
        self.item = item

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = ListLibrariesResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class ListLibrariesResponseBody(TeaModel):
    def __init__(
        self,
        next_token: str = None,
        page_size: int = None,
        page_number: int = None,
        request_id: str = None,
        total_count: int = None,
        items: ListLibrariesResponseBodyItems = None,
    ):
        self.next_token = next_token
        self.page_size = page_size
        self.page_number = page_number
        self.request_id = request_id
        self.total_count = total_count
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Items') is not None:
            temp_model = ListLibrariesResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class ListLibrariesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListLibrariesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListLibrariesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RunScalingActionRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        scaling_action_type: str = None,
        scaling_group_biz_id: str = None,
        action_param: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.scaling_action_type = scaling_action_type
        self.scaling_group_biz_id = scaling_group_biz_id
        self.action_param = action_param

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scaling_action_type is not None:
            result['ScalingActionType'] = self.scaling_action_type
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.action_param is not None:
            result['ActionParam'] = self.action_param
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ScalingActionType') is not None:
            self.scaling_action_type = m.get('ScalingActionType')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('ActionParam') is not None:
            self.action_param = m.get('ActionParam')
        return self


class RunScalingActionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: str = None,
    ):
        # requestId
        self.request_id = request_id
        # data
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class RunScalingActionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: RunScalingActionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = RunScalingActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InstallLibrariesRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_biz_id_list: List[str] = None,
        library_biz_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_biz_id_list = cluster_biz_id_list
        self.library_biz_id = library_biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_biz_id_list is not None:
            result['ClusterBizIdList'] = self.cluster_biz_id_list
        if self.library_biz_id is not None:
            result['LibraryBizId'] = self.library_biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterBizIdList') is not None:
            self.cluster_biz_id_list = m.get('ClusterBizIdList')
        if m.get('LibraryBizId') is not None:
            self.library_biz_id = m.get('LibraryBizId')
        return self


class InstallLibrariesResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class InstallLibrariesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: InstallLibrariesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InstallLibrariesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowJobsRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        id: str = None,
        name: str = None,
        type: str = None,
        adhoc: bool = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.id = id
        self.name = name
        self.type = type
        self.adhoc = adhoc
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.adhoc is not None:
            result['Adhoc'] = self.adhoc
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Adhoc') is not None:
            self.adhoc = m.get('Adhoc')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListFlowJobsResponseBodyJobListJobResourceListResource(TeaModel):
    def __init__(
        self,
        path: str = None,
        alias: str = None,
    ):
        self.path = path
        self.alias = alias

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['Path'] = self.path
        if self.alias is not None:
            result['Alias'] = self.alias
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        return self


class ListFlowJobsResponseBodyJobListJobResourceList(TeaModel):
    def __init__(
        self,
        resource: List[ListFlowJobsResponseBodyJobListJobResourceListResource] = None,
    ):
        self.resource = resource

    def validate(self):
        if self.resource:
            for k in self.resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Resource'] = []
        if self.resource is not None:
            for k in self.resource:
                result['Resource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource = []
        if m.get('Resource') is not None:
            for k in m.get('Resource'):
                temp_model = ListFlowJobsResponseBodyJobListJobResourceListResource()
                self.resource.append(temp_model.from_map(k))
        return self


class ListFlowJobsResponseBodyJobListJob(TeaModel):
    def __init__(
        self,
        type: str = None,
        fail_act: str = None,
        custom_variables: str = None,
        retry_interval: int = None,
        env_conf: str = None,
        param_conf: str = None,
        mode: str = None,
        gmt_modified: int = None,
        monitor_conf: str = None,
        last_instance_detail: str = None,
        run_conf: str = None,
        params: str = None,
        description: str = None,
        gmt_create: int = None,
        category_id: str = None,
        adhoc: str = None,
        name: str = None,
        id: str = None,
        max_retry: int = None,
        alert_conf: str = None,
        resource_list: ListFlowJobsResponseBodyJobListJobResourceList = None,
    ):
        self.type = type
        self.fail_act = fail_act
        self.custom_variables = custom_variables
        self.retry_interval = retry_interval
        self.env_conf = env_conf
        self.param_conf = param_conf
        self.mode = mode
        self.gmt_modified = gmt_modified
        self.monitor_conf = monitor_conf
        self.last_instance_detail = last_instance_detail
        self.run_conf = run_conf
        self.params = params
        self.description = description
        self.gmt_create = gmt_create
        self.category_id = category_id
        self.adhoc = adhoc
        self.name = name
        self.id = id
        self.max_retry = max_retry
        self.alert_conf = alert_conf
        self.resource_list = resource_list

    def validate(self):
        if self.resource_list:
            self.resource_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.fail_act is not None:
            result['FailAct'] = self.fail_act
        if self.custom_variables is not None:
            result['CustomVariables'] = self.custom_variables
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.env_conf is not None:
            result['EnvConf'] = self.env_conf
        if self.param_conf is not None:
            result['ParamConf'] = self.param_conf
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.monitor_conf is not None:
            result['MonitorConf'] = self.monitor_conf
        if self.last_instance_detail is not None:
            result['LastInstanceDetail'] = self.last_instance_detail
        if self.run_conf is not None:
            result['RunConf'] = self.run_conf
        if self.params is not None:
            result['Params'] = self.params
        if self.description is not None:
            result['Description'] = self.description
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.adhoc is not None:
            result['Adhoc'] = self.adhoc
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        if self.max_retry is not None:
            result['MaxRetry'] = self.max_retry
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        if self.resource_list is not None:
            result['ResourceList'] = self.resource_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('FailAct') is not None:
            self.fail_act = m.get('FailAct')
        if m.get('CustomVariables') is not None:
            self.custom_variables = m.get('CustomVariables')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('EnvConf') is not None:
            self.env_conf = m.get('EnvConf')
        if m.get('ParamConf') is not None:
            self.param_conf = m.get('ParamConf')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('MonitorConf') is not None:
            self.monitor_conf = m.get('MonitorConf')
        if m.get('LastInstanceDetail') is not None:
            self.last_instance_detail = m.get('LastInstanceDetail')
        if m.get('RunConf') is not None:
            self.run_conf = m.get('RunConf')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('Adhoc') is not None:
            self.adhoc = m.get('Adhoc')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MaxRetry') is not None:
            self.max_retry = m.get('MaxRetry')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        if m.get('ResourceList') is not None:
            temp_model = ListFlowJobsResponseBodyJobListJobResourceList()
            self.resource_list = temp_model.from_map(m['ResourceList'])
        return self


class ListFlowJobsResponseBodyJobList(TeaModel):
    def __init__(
        self,
        job: List[ListFlowJobsResponseBodyJobListJob] = None,
    ):
        self.job = job

    def validate(self):
        if self.job:
            for k in self.job:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Job'] = []
        if self.job is not None:
            for k in self.job:
                result['Job'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.job = []
        if m.get('Job') is not None:
            for k in m.get('Job'):
                temp_model = ListFlowJobsResponseBodyJobListJob()
                self.job.append(temp_model.from_map(k))
        return self


class ListFlowJobsResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total: int = None,
        job_list: ListFlowJobsResponseBodyJobList = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.total = total
        self.job_list = job_list

    def validate(self):
        if self.job_list:
            self.job_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        if self.job_list is not None:
            result['JobList'] = self.job_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('JobList') is not None:
            temp_model = ListFlowJobsResponseBodyJobList()
            self.job_list = temp_model.from_map(m['JobList'])
        return self


class ListFlowJobsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListFlowJobsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyFlowRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        id: str = None,
        name: str = None,
        status: str = None,
        description: str = None,
        periodic: bool = None,
        start_schedule: int = None,
        end_schedule: int = None,
        cron_expr: str = None,
        create_cluster: bool = None,
        cluster_id: str = None,
        host_name: str = None,
        application: str = None,
        alert_conf: str = None,
        alert_user_group_biz_id: str = None,
        alert_ding_ding_group_biz_id: str = None,
        parent_flow_list: str = None,
        parent_category: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.id = id
        self.name = name
        self.status = status
        self.description = description
        self.periodic = periodic
        self.start_schedule = start_schedule
        self.end_schedule = end_schedule
        self.cron_expr = cron_expr
        self.create_cluster = create_cluster
        self.cluster_id = cluster_id
        self.host_name = host_name
        self.application = application
        self.alert_conf = alert_conf
        self.alert_user_group_biz_id = alert_user_group_biz_id
        self.alert_ding_ding_group_biz_id = alert_ding_ding_group_biz_id
        self.parent_flow_list = parent_flow_list
        self.parent_category = parent_category

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.status is not None:
            result['Status'] = self.status
        if self.description is not None:
            result['Description'] = self.description
        if self.periodic is not None:
            result['Periodic'] = self.periodic
        if self.start_schedule is not None:
            result['StartSchedule'] = self.start_schedule
        if self.end_schedule is not None:
            result['EndSchedule'] = self.end_schedule
        if self.cron_expr is not None:
            result['CronExpr'] = self.cron_expr
        if self.create_cluster is not None:
            result['CreateCluster'] = self.create_cluster
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.application is not None:
            result['Application'] = self.application
        if self.alert_conf is not None:
            result['AlertConf'] = self.alert_conf
        if self.alert_user_group_biz_id is not None:
            result['AlertUserGroupBizId'] = self.alert_user_group_biz_id
        if self.alert_ding_ding_group_biz_id is not None:
            result['AlertDingDingGroupBizId'] = self.alert_ding_ding_group_biz_id
        if self.parent_flow_list is not None:
            result['ParentFlowList'] = self.parent_flow_list
        if self.parent_category is not None:
            result['ParentCategory'] = self.parent_category
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Periodic') is not None:
            self.periodic = m.get('Periodic')
        if m.get('StartSchedule') is not None:
            self.start_schedule = m.get('StartSchedule')
        if m.get('EndSchedule') is not None:
            self.end_schedule = m.get('EndSchedule')
        if m.get('CronExpr') is not None:
            self.cron_expr = m.get('CronExpr')
        if m.get('CreateCluster') is not None:
            self.create_cluster = m.get('CreateCluster')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('Application') is not None:
            self.application = m.get('Application')
        if m.get('AlertConf') is not None:
            self.alert_conf = m.get('AlertConf')
        if m.get('AlertUserGroupBizId') is not None:
            self.alert_user_group_biz_id = m.get('AlertUserGroupBizId')
        if m.get('AlertDingDingGroupBizId') is not None:
            self.alert_ding_ding_group_biz_id = m.get('AlertDingDingGroupBizId')
        if m.get('ParentFlowList') is not None:
            self.parent_flow_list = m.get('ParentFlowList')
        if m.get('ParentCategory') is not None:
            self.parent_category = m.get('ParentCategory')
        return self


class ModifyFlowResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyFlowResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyFlowResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyFlowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRegionsRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
    ):
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeRegionsResponseBodyBusinessLocationsDistrict(TeaModel):
    def __init__(
        self,
        ordering: str = None,
        cn_name: str = None,
        show_name: str = None,
        district_id: str = None,
        en_name: str = None,
    ):
        self.ordering = ordering
        self.cn_name = cn_name
        self.show_name = show_name
        self.district_id = district_id
        self.en_name = en_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ordering is not None:
            result['Ordering'] = self.ordering
        if self.cn_name is not None:
            result['CnName'] = self.cn_name
        if self.show_name is not None:
            result['ShowName'] = self.show_name
        if self.district_id is not None:
            result['DistrictId'] = self.district_id
        if self.en_name is not None:
            result['EnName'] = self.en_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ordering') is not None:
            self.ordering = m.get('Ordering')
        if m.get('CnName') is not None:
            self.cn_name = m.get('CnName')
        if m.get('ShowName') is not None:
            self.show_name = m.get('ShowName')
        if m.get('DistrictId') is not None:
            self.district_id = m.get('DistrictId')
        if m.get('EnName') is not None:
            self.en_name = m.get('EnName')
        return self


class DescribeRegionsResponseBodyBusinessLocations(TeaModel):
    def __init__(
        self,
        ordering: str = None,
        type: str = None,
        show_name: str = None,
        description: str = None,
        en_description: str = None,
        en_name: str = None,
        cn_name: str = None,
        name: str = None,
        district: DescribeRegionsResponseBodyBusinessLocationsDistrict = None,
    ):
        self.ordering = ordering
        self.type = type
        self.show_name = show_name
        self.description = description
        self.en_description = en_description
        self.en_name = en_name
        self.cn_name = cn_name
        self.name = name
        self.district = district

    def validate(self):
        if self.district:
            self.district.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ordering is not None:
            result['Ordering'] = self.ordering
        if self.type is not None:
            result['Type'] = self.type
        if self.show_name is not None:
            result['ShowName'] = self.show_name
        if self.description is not None:
            result['Description'] = self.description
        if self.en_description is not None:
            result['EnDescription'] = self.en_description
        if self.en_name is not None:
            result['EnName'] = self.en_name
        if self.cn_name is not None:
            result['CnName'] = self.cn_name
        if self.name is not None:
            result['Name'] = self.name
        if self.district is not None:
            result['District'] = self.district.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ordering') is not None:
            self.ordering = m.get('Ordering')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ShowName') is not None:
            self.show_name = m.get('ShowName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnDescription') is not None:
            self.en_description = m.get('EnDescription')
        if m.get('EnName') is not None:
            self.en_name = m.get('EnName')
        if m.get('CnName') is not None:
            self.cn_name = m.get('CnName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('District') is not None:
            temp_model = DescribeRegionsResponseBodyBusinessLocationsDistrict()
            self.district = temp_model.from_map(m['District'])
        return self


class DescribeRegionsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        business_locations: List[DescribeRegionsResponseBodyBusinessLocations] = None,
    ):
        self.request_id = request_id
        self.business_locations = business_locations

    def validate(self):
        if self.business_locations:
            for k in self.business_locations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['BusinessLocations'] = []
        if self.business_locations is not None:
            for k in self.business_locations:
                result['BusinessLocations'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.business_locations = []
        if m.get('BusinessLocations') is not None:
            for k in m.get('BusinessLocations'):
                temp_model = DescribeRegionsResponseBodyBusinessLocations()
                self.business_locations.append(temp_model.from_map(k))
        return self


class DescribeRegionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRegionsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRegionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListLibraryStatusRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        limit: int = None,
        page_number: int = None,
        page_size: int = None,
        current_size: int = None,
        page_count: int = None,
        order_field: str = None,
        order_mode: str = None,
        library_biz_id: str = None,
        cluster_biz_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.limit = limit
        self.page_number = page_number
        self.page_size = page_size
        self.current_size = current_size
        self.page_count = page_count
        self.order_field = order_field
        self.order_mode = order_mode
        self.library_biz_id = library_biz_id
        self.cluster_biz_id = cluster_biz_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_size is not None:
            result['CurrentSize'] = self.current_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.order_field is not None:
            result['OrderField'] = self.order_field
        if self.order_mode is not None:
            result['OrderMode'] = self.order_mode
        if self.library_biz_id is not None:
            result['LibraryBizId'] = self.library_biz_id
        if self.cluster_biz_id is not None:
            result['ClusterBizId'] = self.cluster_biz_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentSize') is not None:
            self.current_size = m.get('CurrentSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('OrderField') is not None:
            self.order_field = m.get('OrderField')
        if m.get('OrderMode') is not None:
            self.order_mode = m.get('OrderMode')
        if m.get('LibraryBizId') is not None:
            self.library_biz_id = m.get('LibraryBizId')
        if m.get('ClusterBizId') is not None:
            self.cluster_biz_id = m.get('ClusterBizId')
        return self


class ListLibraryStatusResponseBodyItemsItem(TeaModel):
    def __init__(
        self,
        status: str = None,
        cluster_name: str = None,
        cluster_biz_id: str = None,
        library_biz_id: str = None,
        library_name: str = None,
    ):
        self.status = status
        self.cluster_name = cluster_name
        self.cluster_biz_id = cluster_biz_id
        self.library_biz_id = library_biz_id
        self.library_name = library_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_biz_id is not None:
            result['ClusterBizId'] = self.cluster_biz_id
        if self.library_biz_id is not None:
            result['LibraryBizId'] = self.library_biz_id
        if self.library_name is not None:
            result['LibraryName'] = self.library_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterBizId') is not None:
            self.cluster_biz_id = m.get('ClusterBizId')
        if m.get('LibraryBizId') is not None:
            self.library_biz_id = m.get('LibraryBizId')
        if m.get('LibraryName') is not None:
            self.library_name = m.get('LibraryName')
        return self


class ListLibraryStatusResponseBodyItems(TeaModel):
    def __init__(
        self,
        item: List[ListLibraryStatusResponseBodyItemsItem] = None,
    ):
        self.item = item

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = ListLibraryStatusResponseBodyItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class ListLibraryStatusResponseBody(TeaModel):
    def __init__(
        self,
        next_token: str = None,
        page_size: int = None,
        page_number: int = None,
        request_id: str = None,
        total_count: int = None,
        items: ListLibraryStatusResponseBodyItems = None,
    ):
        self.next_token = next_token
        self.page_size = page_size
        self.page_number = page_number
        self.request_id = request_id
        self.total_count = total_count
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Items') is not None:
            temp_model = ListLibraryStatusResponseBodyItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class ListLibraryStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListLibraryStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListLibraryStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterServiceConfigRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        service_name: str = None,
        config_version: str = None,
        group_id: str = None,
        host_instance_id: str = None,
        tag_value: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.service_name = service_name
        self.config_version = config_version
        self.group_id = group_id
        self.host_instance_id = host_instance_id
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_version is not None:
            result['ConfigVersion'] = self.config_version
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigVersion') is not None:
            self.config_version = m.get('ConfigVersion')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValueConfigItemValueListConfigItemValue(TeaModel):
    def __init__(
        self,
        value: str = None,
        description: str = None,
        item_name: str = None,
        is_custom: bool = None,
    ):
        self.value = value
        self.description = description
        self.item_name = item_name
        self.is_custom = is_custom

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        if self.description is not None:
            result['Description'] = self.description
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.is_custom is not None:
            result['IsCustom'] = self.is_custom
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('IsCustom') is not None:
            self.is_custom = m.get('IsCustom')
        return self


class DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValueConfigItemValueList(TeaModel):
    def __init__(
        self,
        config_item_value: List[DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValueConfigItemValueListConfigItemValue] = None,
    ):
        self.config_item_value = config_item_value

    def validate(self):
        if self.config_item_value:
            for k in self.config_item_value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigItemValue'] = []
        if self.config_item_value is not None:
            for k in self.config_item_value:
                result['ConfigItemValue'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config_item_value = []
        if m.get('ConfigItemValue') is not None:
            for k in m.get('ConfigItemValue'):
                temp_model = DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValueConfigItemValueListConfigItemValue()
                self.config_item_value.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValue(TeaModel):
    def __init__(
        self,
        config_name: str = None,
        scope_id: int = None,
        scope: str = None,
        allow_custom: bool = None,
        config_item_value_list: DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValueConfigItemValueList = None,
    ):
        self.config_name = config_name
        self.scope_id = scope_id
        self.scope = scope
        self.allow_custom = allow_custom
        self.config_item_value_list = config_item_value_list

    def validate(self):
        if self.config_item_value_list:
            self.config_item_value_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_name is not None:
            result['ConfigName'] = self.config_name
        if self.scope_id is not None:
            result['ScopeId'] = self.scope_id
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.allow_custom is not None:
            result['AllowCustom'] = self.allow_custom
        if self.config_item_value_list is not None:
            result['ConfigItemValueList'] = self.config_item_value_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigName') is not None:
            self.config_name = m.get('ConfigName')
        if m.get('ScopeId') is not None:
            self.scope_id = m.get('ScopeId')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('AllowCustom') is not None:
            self.allow_custom = m.get('AllowCustom')
        if m.get('ConfigItemValueList') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValueConfigItemValueList()
            self.config_item_value_list = temp_model.from_map(m['ConfigItemValueList'])
        return self


class DescribeClusterServiceConfigResponseBodyConfigConfigValueList(TeaModel):
    def __init__(
        self,
        config_value: List[DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValue] = None,
    ):
        self.config_value = config_value

    def validate(self):
        if self.config_value:
            for k in self.config_value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigValue'] = []
        if self.config_value is not None:
            for k in self.config_value:
                result['ConfigValue'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config_value = []
        if m.get('ConfigValue') is not None:
            for k in m.get('ConfigValue'):
                temp_model = DescribeClusterServiceConfigResponseBodyConfigConfigValueListConfigValue()
                self.config_value.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyTypes(TeaModel):
    def __init__(
        self,
        property_type: List[str] = None,
    ):
        self.property_type = property_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.property_type is not None:
            result['PropertyType'] = self.property_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PropertyType') is not None:
            self.property_type = m.get('PropertyType')
        return self


class DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributesEntriesValueEntryInfo(TeaModel):
    def __init__(
        self,
        value: str = None,
        label: str = None,
        description: str = None,
    ):
        self.value = value
        self.label = label
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        if self.label is not None:
            result['Label'] = self.label
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Label') is not None:
            self.label = m.get('Label')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributesEntries(TeaModel):
    def __init__(
        self,
        value_entry_info: List[DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributesEntriesValueEntryInfo] = None,
    ):
        self.value_entry_info = value_entry_info

    def validate(self):
        if self.value_entry_info:
            for k in self.value_entry_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ValueEntryInfo'] = []
        if self.value_entry_info is not None:
            for k in self.value_entry_info:
                result['ValueEntryInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.value_entry_info = []
        if m.get('ValueEntryInfo') is not None:
            for k in m.get('ValueEntryInfo'):
                temp_model = DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributesEntriesValueEntryInfo()
                self.value_entry_info.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributes(TeaModel):
    def __init__(
        self,
        type: str = None,
        maximum: str = None,
        unit: str = None,
        hidden: bool = None,
        incrememt_step: str = None,
        read_only: bool = None,
        mimimum: str = None,
        entries: DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributesEntries = None,
    ):
        self.type = type
        self.maximum = maximum
        self.unit = unit
        self.hidden = hidden
        self.incrememt_step = incrememt_step
        self.read_only = read_only
        self.mimimum = mimimum
        self.entries = entries

    def validate(self):
        if self.entries:
            self.entries.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.maximum is not None:
            result['Maximum'] = self.maximum
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.hidden is not None:
            result['Hidden'] = self.hidden
        if self.incrememt_step is not None:
            result['IncrememtStep'] = self.incrememt_step
        if self.read_only is not None:
            result['ReadOnly'] = self.read_only
        if self.mimimum is not None:
            result['Mimimum'] = self.mimimum
        if self.entries is not None:
            result['Entries'] = self.entries.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Maximum') is not None:
            self.maximum = m.get('Maximum')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('Hidden') is not None:
            self.hidden = m.get('Hidden')
        if m.get('IncrememtStep') is not None:
            self.incrememt_step = m.get('IncrememtStep')
        if m.get('ReadOnly') is not None:
            self.read_only = m.get('ReadOnly')
        if m.get('Mimimum') is not None:
            self.mimimum = m.get('Mimimum')
        if m.get('Entries') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributesEntries()
            self.entries = temp_model.from_map(m['Entries'])
        return self


class DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoEffectWay(TeaModel):
    def __init__(
        self,
        effect_type: str = None,
        invoke_service_name: str = None,
    ):
        self.effect_type = effect_type
        self.invoke_service_name = invoke_service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effect_type is not None:
            result['EffectType'] = self.effect_type
        if self.invoke_service_name is not None:
            result['InvokeServiceName'] = self.invoke_service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EffectType') is not None:
            self.effect_type = m.get('EffectType')
        if m.get('InvokeServiceName') is not None:
            self.invoke_service_name = m.get('InvokeServiceName')
        return self


class DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfo(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        value: str = None,
        description: str = None,
        component: str = None,
        file_name: str = None,
        name: str = None,
        service_name: str = None,
        property_types: DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyTypes = None,
        property_value_attributes: DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributes = None,
        effect_way: DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoEffectWay = None,
    ):
        self.display_name = display_name
        self.value = value
        self.description = description
        self.component = component
        self.file_name = file_name
        self.name = name
        self.service_name = service_name
        self.property_types = property_types
        self.property_value_attributes = property_value_attributes
        self.effect_way = effect_way

    def validate(self):
        if self.property_types:
            self.property_types.validate()
        if self.property_value_attributes:
            self.property_value_attributes.validate()
        if self.effect_way:
            self.effect_way.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.value is not None:
            result['Value'] = self.value
        if self.description is not None:
            result['Description'] = self.description
        if self.component is not None:
            result['Component'] = self.component
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.name is not None:
            result['Name'] = self.name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.property_types is not None:
            result['PropertyTypes'] = self.property_types.to_map()
        if self.property_value_attributes is not None:
            result['PropertyValueAttributes'] = self.property_value_attributes.to_map()
        if self.effect_way is not None:
            result['EffectWay'] = self.effect_way.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Component') is not None:
            self.component = m.get('Component')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('PropertyTypes') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyTypes()
            self.property_types = temp_model.from_map(m['PropertyTypes'])
        if m.get('PropertyValueAttributes') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoPropertyValueAttributes()
            self.property_value_attributes = temp_model.from_map(m['PropertyValueAttributes'])
        if m.get('EffectWay') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfoEffectWay()
            self.effect_way = temp_model.from_map(m['EffectWay'])
        return self


class DescribeClusterServiceConfigResponseBodyConfigPropertyInfoList(TeaModel):
    def __init__(
        self,
        property_info: List[DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfo] = None,
    ):
        self.property_info = property_info

    def validate(self):
        if self.property_info:
            for k in self.property_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PropertyInfo'] = []
        if self.property_info is not None:
            for k in self.property_info:
                result['PropertyInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.property_info = []
        if m.get('PropertyInfo') is not None:
            for k in m.get('PropertyInfo'):
                temp_model = DescribeClusterServiceConfigResponseBodyConfigPropertyInfoListPropertyInfo()
                self.property_info.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceConfigResponseBodyConfig(TeaModel):
    def __init__(
        self,
        applied: str = None,
        comment: str = None,
        create_time: str = None,
        config_version: str = None,
        author: str = None,
        service_name: str = None,
        config_value_list: DescribeClusterServiceConfigResponseBodyConfigConfigValueList = None,
        property_info_list: DescribeClusterServiceConfigResponseBodyConfigPropertyInfoList = None,
    ):
        self.applied = applied
        self.comment = comment
        self.create_time = create_time
        self.config_version = config_version
        self.author = author
        self.service_name = service_name
        self.config_value_list = config_value_list
        self.property_info_list = property_info_list

    def validate(self):
        if self.config_value_list:
            self.config_value_list.validate()
        if self.property_info_list:
            self.property_info_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.applied is not None:
            result['Applied'] = self.applied
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.config_version is not None:
            result['ConfigVersion'] = self.config_version
        if self.author is not None:
            result['Author'] = self.author
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.config_value_list is not None:
            result['ConfigValueList'] = self.config_value_list.to_map()
        if self.property_info_list is not None:
            result['PropertyInfoList'] = self.property_info_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Applied') is not None:
            self.applied = m.get('Applied')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ConfigVersion') is not None:
            self.config_version = m.get('ConfigVersion')
        if m.get('Author') is not None:
            self.author = m.get('Author')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ConfigValueList') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfigConfigValueList()
            self.config_value_list = temp_model.from_map(m['ConfigValueList'])
        if m.get('PropertyInfoList') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfigPropertyInfoList()
            self.property_info_list = temp_model.from_map(m['PropertyInfoList'])
        return self


class DescribeClusterServiceConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        config: DescribeClusterServiceConfigResponseBodyConfig = None,
    ):
        self.request_id = request_id
        self.config = config

    def validate(self):
        if self.config:
            self.config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.config is not None:
            result['Config'] = self.config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Config') is not None:
            temp_model = DescribeClusterServiceConfigResponseBodyConfig()
            self.config = temp_model.from_map(m['Config'])
        return self


class DescribeClusterServiceConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeClusterServiceConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClusterServiceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyFlowProjectClusterSettingRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        cluster_id: str = None,
        default_user: str = None,
        default_queue: str = None,
        user_list: List[str] = None,
        queue_list: List[str] = None,
        host_list: List[str] = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.cluster_id = cluster_id
        self.default_user = default_user
        self.default_queue = default_queue
        self.user_list = user_list
        self.queue_list = queue_list
        self.host_list = host_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.default_user is not None:
            result['DefaultUser'] = self.default_user
        if self.default_queue is not None:
            result['DefaultQueue'] = self.default_queue
        if self.user_list is not None:
            result['UserList'] = self.user_list
        if self.queue_list is not None:
            result['QueueList'] = self.queue_list
        if self.host_list is not None:
            result['HostList'] = self.host_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DefaultUser') is not None:
            self.default_user = m.get('DefaultUser')
        if m.get('DefaultQueue') is not None:
            self.default_queue = m.get('DefaultQueue')
        if m.get('UserList') is not None:
            self.user_list = m.get('UserList')
        if m.get('QueueList') is not None:
            self.queue_list = m.get('QueueList')
        if m.get('HostList') is not None:
            self.host_list = m.get('HostList')
        return self


class ModifyFlowProjectClusterSettingResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyFlowProjectClusterSettingResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyFlowProjectClusterSettingResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyFlowProjectClusterSettingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowProjectUserRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        user_name: str = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DeleteFlowProjectUserResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteFlowProjectUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteFlowProjectUserResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFlowProjectUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateClusterV2RequestUserInfo(TeaModel):
    def __init__(
        self,
        password: str = None,
        user_id: str = None,
        user_name: str = None,
    ):
        self.password = password
        self.user_id = user_id
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.password is not None:
            result['Password'] = self.password
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class CreateClusterV2RequestHostComponentInfo(TeaModel):
    def __init__(
        self,
        component_name_list: List[str] = None,
        host_name: str = None,
        service_name: str = None,
    ):
        self.component_name_list = component_name_list
        self.host_name = host_name
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_name_list is not None:
            result['ComponentNameList'] = self.component_name_list
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComponentNameList') is not None:
            self.component_name_list = m.get('ComponentNameList')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class CreateClusterV2RequestServiceInfo(TeaModel):
    def __init__(
        self,
        service_name: str = None,
        service_version: str = None,
    ):
        self.service_name = service_name
        self.service_version = service_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.service_version is not None:
            result['ServiceVersion'] = self.service_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ServiceVersion') is not None:
            self.service_version = m.get('ServiceVersion')
        return self


class CreateClusterV2RequestPromotionInfo(TeaModel):
    def __init__(
        self,
        product_code: str = None,
        promotion_option_code: str = None,
        promotion_option_no: str = None,
    ):
        self.product_code = product_code
        self.promotion_option_code = promotion_option_code
        self.promotion_option_no = promotion_option_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.promotion_option_code is not None:
            result['PromotionOptionCode'] = self.promotion_option_code
        if self.promotion_option_no is not None:
            result['PromotionOptionNo'] = self.promotion_option_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('PromotionOptionCode') is not None:
            self.promotion_option_code = m.get('PromotionOptionCode')
        if m.get('PromotionOptionNo') is not None:
            self.promotion_option_no = m.get('PromotionOptionNo')
        return self


class CreateClusterV2RequestHostGroup(TeaModel):
    def __init__(
        self,
        auto_renew: bool = None,
        charge_type: str = None,
        cluster_id: str = None,
        comment: str = None,
        create_type: str = None,
        disk_capacity: int = None,
        disk_count: int = None,
        disk_type: str = None,
        gpu_driver: str = None,
        host_group_id: str = None,
        host_group_name: str = None,
        host_group_type: str = None,
        instance_type: str = None,
        node_count: int = None,
        period: int = None,
        sys_disk_capacity: int = None,
        sys_disk_type: str = None,
        v_switch_id: str = None,
    ):
        self.auto_renew = auto_renew
        self.charge_type = charge_type
        self.cluster_id = cluster_id
        self.comment = comment
        self.create_type = create_type
        self.disk_capacity = disk_capacity
        self.disk_count = disk_count
        self.disk_type = disk_type
        self.gpu_driver = gpu_driver
        self.host_group_id = host_group_id
        self.host_group_name = host_group_name
        self.host_group_type = host_group_type
        self.instance_type = instance_type
        self.node_count = node_count
        self.period = period
        self.sys_disk_capacity = sys_disk_capacity
        self.sys_disk_type = sys_disk_type
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.comment is not None:
            result['Comment'] = self.comment
        if self.create_type is not None:
            result['CreateType'] = self.create_type
        if self.disk_capacity is not None:
            result['DiskCapacity'] = self.disk_capacity
        if self.disk_count is not None:
            result['DiskCount'] = self.disk_count
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.gpu_driver is not None:
            result['GpuDriver'] = self.gpu_driver
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.host_group_name is not None:
            result['HostGroupName'] = self.host_group_name
        if self.host_group_type is not None:
            result['HostGroupType'] = self.host_group_type
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.node_count is not None:
            result['NodeCount'] = self.node_count
        if self.period is not None:
            result['Period'] = self.period
        if self.sys_disk_capacity is not None:
            result['SysDiskCapacity'] = self.sys_disk_capacity
        if self.sys_disk_type is not None:
            result['SysDiskType'] = self.sys_disk_type
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Comment') is not None:
            self.comment = m.get('Comment')
        if m.get('CreateType') is not None:
            self.create_type = m.get('CreateType')
        if m.get('DiskCapacity') is not None:
            self.disk_capacity = m.get('DiskCapacity')
        if m.get('DiskCount') is not None:
            self.disk_count = m.get('DiskCount')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('GpuDriver') is not None:
            self.gpu_driver = m.get('GpuDriver')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('HostGroupName') is not None:
            self.host_group_name = m.get('HostGroupName')
        if m.get('HostGroupType') is not None:
            self.host_group_type = m.get('HostGroupType')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('NodeCount') is not None:
            self.node_count = m.get('NodeCount')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('SysDiskCapacity') is not None:
            self.sys_disk_capacity = m.get('SysDiskCapacity')
        if m.get('SysDiskType') is not None:
            self.sys_disk_type = m.get('SysDiskType')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateClusterV2RequestBootstrapAction(TeaModel):
    def __init__(
        self,
        arg: str = None,
        name: str = None,
        path: str = None,
    ):
        self.arg = arg
        self.name = name
        self.path = path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arg is not None:
            result['Arg'] = self.arg
        if self.name is not None:
            result['Name'] = self.name
        if self.path is not None:
            result['Path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arg') is not None:
            self.arg = m.get('Arg')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        return self


class CreateClusterV2RequestConfig(TeaModel):
    def __init__(
        self,
        config_key: str = None,
        config_value: str = None,
        encrypt: str = None,
        file_name: str = None,
        replace: str = None,
        service_name: str = None,
    ):
        self.config_key = config_key
        self.config_value = config_value
        self.encrypt = encrypt
        self.file_name = file_name
        self.replace = replace
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_key is not None:
            result['ConfigKey'] = self.config_key
        if self.config_value is not None:
            result['ConfigValue'] = self.config_value
        if self.encrypt is not None:
            result['Encrypt'] = self.encrypt
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.replace is not None:
            result['Replace'] = self.replace
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigKey') is not None:
            self.config_key = m.get('ConfigKey')
        if m.get('ConfigValue') is not None:
            self.config_value = m.get('ConfigValue')
        if m.get('Encrypt') is not None:
            self.encrypt = m.get('Encrypt')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Replace') is not None:
            self.replace = m.get('Replace')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class CreateClusterV2RequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateClusterV2Request(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        name: str = None,
        region_id: str = None,
        zone_id: str = None,
        log_path: str = None,
        security_group_id: str = None,
        is_open_public_ip: bool = None,
        security_group_name: str = None,
        charge_type: str = None,
        period: int = None,
        auto: bool = None,
        auto_pay_order: bool = None,
        vpc_id: str = None,
        v_switch_id: str = None,
        net_type: str = None,
        user_defined_emr_ecs_role: str = None,
        emr_ver: str = None,
        cluster_type: str = None,
        enable_high_availability: bool = None,
        use_local_meta_db: bool = None,
        enable_ssh: bool = None,
        instance_generation: str = None,
        master_pwd: str = None,
        key_pair_name: str = None,
        meta_store_type: str = None,
        meta_store_conf: str = None,
        click_house_conf: str = None,
        extra_attributes: str = None,
        deposit_type: str = None,
        machine_type: str = None,
        use_custom_hive_meta_db: bool = None,
        init_custom_hive_meta_db: bool = None,
        configurations: str = None,
        enable_eas: bool = None,
        related_cluster_id: str = None,
        white_list_type: str = None,
        authorize_content: str = None,
        resource_group_id: str = None,
        client_token: str = None,
        user_info: List[CreateClusterV2RequestUserInfo] = None,
        host_component_info: List[CreateClusterV2RequestHostComponentInfo] = None,
        service_info: List[CreateClusterV2RequestServiceInfo] = None,
        promotion_info: List[CreateClusterV2RequestPromotionInfo] = None,
        host_group: List[CreateClusterV2RequestHostGroup] = None,
        bootstrap_action: List[CreateClusterV2RequestBootstrapAction] = None,
        config: List[CreateClusterV2RequestConfig] = None,
        tag: List[CreateClusterV2RequestTag] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.name = name
        self.region_id = region_id
        self.zone_id = zone_id
        self.log_path = log_path
        self.security_group_id = security_group_id
        self.is_open_public_ip = is_open_public_ip
        self.security_group_name = security_group_name
        self.charge_type = charge_type
        self.period = period
        self.auto = auto
        self.auto_pay_order = auto_pay_order
        self.vpc_id = vpc_id
        self.v_switch_id = v_switch_id
        self.net_type = net_type
        self.user_defined_emr_ecs_role = user_defined_emr_ecs_role
        self.emr_ver = emr_ver
        self.cluster_type = cluster_type
        self.enable_high_availability = enable_high_availability
        self.use_local_meta_db = use_local_meta_db
        self.enable_ssh = enable_ssh
        self.instance_generation = instance_generation
        self.master_pwd = master_pwd
        self.key_pair_name = key_pair_name
        self.meta_store_type = meta_store_type
        self.meta_store_conf = meta_store_conf
        self.click_house_conf = click_house_conf
        self.extra_attributes = extra_attributes
        self.deposit_type = deposit_type
        self.machine_type = machine_type
        self.use_custom_hive_meta_db = use_custom_hive_meta_db
        self.init_custom_hive_meta_db = init_custom_hive_meta_db
        self.configurations = configurations
        self.enable_eas = enable_eas
        self.related_cluster_id = related_cluster_id
        self.white_list_type = white_list_type
        self.authorize_content = authorize_content
        self.resource_group_id = resource_group_id
        self.client_token = client_token
        self.user_info = user_info
        self.host_component_info = host_component_info
        self.service_info = service_info
        self.promotion_info = promotion_info
        self.host_group = host_group
        self.bootstrap_action = bootstrap_action
        self.config = config
        self.tag = tag

    def validate(self):
        if self.user_info:
            for k in self.user_info:
                if k:
                    k.validate()
        if self.host_component_info:
            for k in self.host_component_info:
                if k:
                    k.validate()
        if self.service_info:
            for k in self.service_info:
                if k:
                    k.validate()
        if self.promotion_info:
            for k in self.promotion_info:
                if k:
                    k.validate()
        if self.host_group:
            for k in self.host_group:
                if k:
                    k.validate()
        if self.bootstrap_action:
            for k in self.bootstrap_action:
                if k:
                    k.validate()
        if self.config:
            for k in self.config:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.is_open_public_ip is not None:
            result['IsOpenPublicIp'] = self.is_open_public_ip
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.period is not None:
            result['Period'] = self.period
        if self.auto is not None:
            result['Auto'] = self.auto
        if self.auto_pay_order is not None:
            result['AutoPayOrder'] = self.auto_pay_order
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.user_defined_emr_ecs_role is not None:
            result['UserDefinedEmrEcsRole'] = self.user_defined_emr_ecs_role
        if self.emr_ver is not None:
            result['EmrVer'] = self.emr_ver
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.enable_high_availability is not None:
            result['EnableHighAvailability'] = self.enable_high_availability
        if self.use_local_meta_db is not None:
            result['UseLocalMetaDb'] = self.use_local_meta_db
        if self.enable_ssh is not None:
            result['EnableSsh'] = self.enable_ssh
        if self.instance_generation is not None:
            result['InstanceGeneration'] = self.instance_generation
        if self.master_pwd is not None:
            result['MasterPwd'] = self.master_pwd
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.meta_store_type is not None:
            result['MetaStoreType'] = self.meta_store_type
        if self.meta_store_conf is not None:
            result['MetaStoreConf'] = self.meta_store_conf
        if self.click_house_conf is not None:
            result['ClickHouseConf'] = self.click_house_conf
        if self.extra_attributes is not None:
            result['ExtraAttributes'] = self.extra_attributes
        if self.deposit_type is not None:
            result['DepositType'] = self.deposit_type
        if self.machine_type is not None:
            result['MachineType'] = self.machine_type
        if self.use_custom_hive_meta_db is not None:
            result['UseCustomHiveMetaDB'] = self.use_custom_hive_meta_db
        if self.init_custom_hive_meta_db is not None:
            result['InitCustomHiveMetaDB'] = self.init_custom_hive_meta_db
        if self.configurations is not None:
            result['Configurations'] = self.configurations
        if self.enable_eas is not None:
            result['EnableEas'] = self.enable_eas
        if self.related_cluster_id is not None:
            result['RelatedClusterId'] = self.related_cluster_id
        if self.white_list_type is not None:
            result['WhiteListType'] = self.white_list_type
        if self.authorize_content is not None:
            result['AuthorizeContent'] = self.authorize_content
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        result['UserInfo'] = []
        if self.user_info is not None:
            for k in self.user_info:
                result['UserInfo'].append(k.to_map() if k else None)
        result['HostComponentInfo'] = []
        if self.host_component_info is not None:
            for k in self.host_component_info:
                result['HostComponentInfo'].append(k.to_map() if k else None)
        result['ServiceInfo'] = []
        if self.service_info is not None:
            for k in self.service_info:
                result['ServiceInfo'].append(k.to_map() if k else None)
        result['PromotionInfo'] = []
        if self.promotion_info is not None:
            for k in self.promotion_info:
                result['PromotionInfo'].append(k.to_map() if k else None)
        result['HostGroup'] = []
        if self.host_group is not None:
            for k in self.host_group:
                result['HostGroup'].append(k.to_map() if k else None)
        result['BootstrapAction'] = []
        if self.bootstrap_action is not None:
            for k in self.bootstrap_action:
                result['BootstrapAction'].append(k.to_map() if k else None)
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('IsOpenPublicIp') is not None:
            self.is_open_public_ip = m.get('IsOpenPublicIp')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Auto') is not None:
            self.auto = m.get('Auto')
        if m.get('AutoPayOrder') is not None:
            self.auto_pay_order = m.get('AutoPayOrder')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('UserDefinedEmrEcsRole') is not None:
            self.user_defined_emr_ecs_role = m.get('UserDefinedEmrEcsRole')
        if m.get('EmrVer') is not None:
            self.emr_ver = m.get('EmrVer')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('EnableHighAvailability') is not None:
            self.enable_high_availability = m.get('EnableHighAvailability')
        if m.get('UseLocalMetaDb') is not None:
            self.use_local_meta_db = m.get('UseLocalMetaDb')
        if m.get('EnableSsh') is not None:
            self.enable_ssh = m.get('EnableSsh')
        if m.get('InstanceGeneration') is not None:
            self.instance_generation = m.get('InstanceGeneration')
        if m.get('MasterPwd') is not None:
            self.master_pwd = m.get('MasterPwd')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('MetaStoreType') is not None:
            self.meta_store_type = m.get('MetaStoreType')
        if m.get('MetaStoreConf') is not None:
            self.meta_store_conf = m.get('MetaStoreConf')
        if m.get('ClickHouseConf') is not None:
            self.click_house_conf = m.get('ClickHouseConf')
        if m.get('ExtraAttributes') is not None:
            self.extra_attributes = m.get('ExtraAttributes')
        if m.get('DepositType') is not None:
            self.deposit_type = m.get('DepositType')
        if m.get('MachineType') is not None:
            self.machine_type = m.get('MachineType')
        if m.get('UseCustomHiveMetaDB') is not None:
            self.use_custom_hive_meta_db = m.get('UseCustomHiveMetaDB')
        if m.get('InitCustomHiveMetaDB') is not None:
            self.init_custom_hive_meta_db = m.get('InitCustomHiveMetaDB')
        if m.get('Configurations') is not None:
            self.configurations = m.get('Configurations')
        if m.get('EnableEas') is not None:
            self.enable_eas = m.get('EnableEas')
        if m.get('RelatedClusterId') is not None:
            self.related_cluster_id = m.get('RelatedClusterId')
        if m.get('WhiteListType') is not None:
            self.white_list_type = m.get('WhiteListType')
        if m.get('AuthorizeContent') is not None:
            self.authorize_content = m.get('AuthorizeContent')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        self.user_info = []
        if m.get('UserInfo') is not None:
            for k in m.get('UserInfo'):
                temp_model = CreateClusterV2RequestUserInfo()
                self.user_info.append(temp_model.from_map(k))
        self.host_component_info = []
        if m.get('HostComponentInfo') is not None:
            for k in m.get('HostComponentInfo'):
                temp_model = CreateClusterV2RequestHostComponentInfo()
                self.host_component_info.append(temp_model.from_map(k))
        self.service_info = []
        if m.get('ServiceInfo') is not None:
            for k in m.get('ServiceInfo'):
                temp_model = CreateClusterV2RequestServiceInfo()
                self.service_info.append(temp_model.from_map(k))
        self.promotion_info = []
        if m.get('PromotionInfo') is not None:
            for k in m.get('PromotionInfo'):
                temp_model = CreateClusterV2RequestPromotionInfo()
                self.promotion_info.append(temp_model.from_map(k))
        self.host_group = []
        if m.get('HostGroup') is not None:
            for k in m.get('HostGroup'):
                temp_model = CreateClusterV2RequestHostGroup()
                self.host_group.append(temp_model.from_map(k))
        self.bootstrap_action = []
        if m.get('BootstrapAction') is not None:
            for k in m.get('BootstrapAction'):
                temp_model = CreateClusterV2RequestBootstrapAction()
                self.bootstrap_action.append(temp_model.from_map(k))
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = CreateClusterV2RequestConfig()
                self.config.append(temp_model.from_map(k))
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateClusterV2RequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateClusterV2ResponseBody(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        core_order_id: str = None,
        emr_order_id: str = None,
        master_order_id: str = None,
        request_id: str = None,
    ):
        self.cluster_id = cluster_id
        self.core_order_id = core_order_id
        self.emr_order_id = emr_order_id
        self.master_order_id = master_order_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.core_order_id is not None:
            result['CoreOrderId'] = self.core_order_id
        if self.emr_order_id is not None:
            result['EmrOrderId'] = self.emr_order_id
        if self.master_order_id is not None:
            result['MasterOrderId'] = self.master_order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('CoreOrderId') is not None:
            self.core_order_id = m.get('CoreOrderId')
        if m.get('EmrOrderId') is not None:
            self.emr_order_id = m.get('EmrOrderId')
        if m.get('MasterOrderId') is not None:
            self.master_order_id = m.get('MasterOrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateClusterV2Response(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateClusterV2ResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateClusterV2ResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyClusterNameRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        id: str = None,
        name: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.id = id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class ModifyClusterNameResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyClusterNameResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyClusterNameResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyClusterNameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterOperationHostTaskRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        operation_id: str = None,
        host_id: str = None,
        status: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.operation_id = operation_id
        self.host_id = host_id
        self.status = status
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.operation_id is not None:
            result['OperationId'] = self.operation_id
        if self.host_id is not None:
            result['HostId'] = self.host_id
        if self.status is not None:
            result['Status'] = self.status
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('OperationId') is not None:
            self.operation_id = m.get('OperationId')
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListClusterOperationHostTaskResponseBodyClusterOperationHostTaskListClusterOperationHostTask(TeaModel):
    def __init__(
        self,
        status: str = None,
        percentage: str = None,
        task_id: str = None,
        task_name: str = None,
    ):
        self.status = status
        self.percentage = percentage
        self.task_id = task_id
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.percentage is not None:
            result['Percentage'] = self.percentage
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Percentage') is not None:
            self.percentage = m.get('Percentage')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class ListClusterOperationHostTaskResponseBodyClusterOperationHostTaskList(TeaModel):
    def __init__(
        self,
        cluster_operation_host_task: List[ListClusterOperationHostTaskResponseBodyClusterOperationHostTaskListClusterOperationHostTask] = None,
    ):
        self.cluster_operation_host_task = cluster_operation_host_task

    def validate(self):
        if self.cluster_operation_host_task:
            for k in self.cluster_operation_host_task:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterOperationHostTask'] = []
        if self.cluster_operation_host_task is not None:
            for k in self.cluster_operation_host_task:
                result['ClusterOperationHostTask'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_operation_host_task = []
        if m.get('ClusterOperationHostTask') is not None:
            for k in m.get('ClusterOperationHostTask'):
                temp_model = ListClusterOperationHostTaskResponseBodyClusterOperationHostTaskListClusterOperationHostTask()
                self.cluster_operation_host_task.append(temp_model.from_map(k))
        return self


class ListClusterOperationHostTaskResponseBody(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        request_id: str = None,
        page_number: int = None,
        total_count: int = None,
        cluster_operation_host_task_list: ListClusterOperationHostTaskResponseBodyClusterOperationHostTaskList = None,
    ):
        self.page_size = page_size
        self.request_id = request_id
        self.page_number = page_number
        self.total_count = total_count
        self.cluster_operation_host_task_list = cluster_operation_host_task_list

    def validate(self):
        if self.cluster_operation_host_task_list:
            self.cluster_operation_host_task_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.cluster_operation_host_task_list is not None:
            result['ClusterOperationHostTaskList'] = self.cluster_operation_host_task_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('ClusterOperationHostTaskList') is not None:
            temp_model = ListClusterOperationHostTaskResponseBodyClusterOperationHostTaskList()
            self.cluster_operation_host_task_list = temp_model.from_map(m['ClusterOperationHostTaskList'])
        return self


class ListClusterOperationHostTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterOperationHostTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterOperationHostTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScalingConfigItemRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        scaling_config_item_id: str = None,
        scaling_group_biz_id: str = None,
        config_item_type: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.scaling_config_item_id = scaling_config_item_id
        self.scaling_group_biz_id = scaling_group_biz_id
        self.config_item_type = config_item_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.scaling_config_item_id is not None:
            result['ScalingConfigItemId'] = self.scaling_config_item_id
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.config_item_type is not None:
            result['ConfigItemType'] = self.config_item_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ScalingConfigItemId') is not None:
            self.scaling_config_item_id = m.get('ScalingConfigItemId')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('ConfigItemType') is not None:
            self.config_item_type = m.get('ConfigItemType')
        return self


class DescribeScalingConfigItemResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        config_item_type: str = None,
        scaling_group_biz_id: str = None,
        scaling_config_item_biz_id: str = None,
        config_item_information: str = None,
    ):
        # requestId
        self.request_id = request_id
        # data
        self.config_item_type = config_item_type
        self.scaling_group_biz_id = scaling_group_biz_id
        self.scaling_config_item_biz_id = scaling_config_item_biz_id
        self.config_item_information = config_item_information

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.config_item_type is not None:
            result['ConfigItemType'] = self.config_item_type
        if self.scaling_group_biz_id is not None:
            result['ScalingGroupBizId'] = self.scaling_group_biz_id
        if self.scaling_config_item_biz_id is not None:
            result['ScalingConfigItemBizId'] = self.scaling_config_item_biz_id
        if self.config_item_information is not None:
            result['ConfigItemInformation'] = self.config_item_information
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ConfigItemType') is not None:
            self.config_item_type = m.get('ConfigItemType')
        if m.get('ScalingGroupBizId') is not None:
            self.scaling_group_biz_id = m.get('ScalingGroupBizId')
        if m.get('ScalingConfigItemBizId') is not None:
            self.scaling_config_item_biz_id = m.get('ScalingConfigItemBizId')
        if m.get('ConfigItemInformation') is not None:
            self.config_item_information = m.get('ConfigItemInformation')
        return self


class DescribeScalingConfigItemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeScalingConfigItemResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeScalingConfigItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListClusterHostRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        host_instance_id: str = None,
        host_group_id: str = None,
        host_name: str = None,
        private_ip: str = None,
        public_ip: str = None,
        group_type: str = None,
        component_name: str = None,
        page_number: int = None,
        page_size: int = None,
        status_list: List[str] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.host_instance_id = host_instance_id
        self.host_group_id = host_group_id
        self.host_name = host_name
        self.private_ip = private_ip
        self.public_ip = public_ip
        self.group_type = group_type
        self.component_name = component_name
        self.page_number = page_number
        self.page_size = page_size
        self.status_list = status_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.private_ip is not None:
            result['PrivateIp'] = self.private_ip
        if self.public_ip is not None:
            result['PublicIp'] = self.public_ip
        if self.group_type is not None:
            result['GroupType'] = self.group_type
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('PrivateIp') is not None:
            self.private_ip = m.get('PrivateIp')
        if m.get('PublicIp') is not None:
            self.public_ip = m.get('PublicIp')
        if m.get('GroupType') is not None:
            self.group_type = m.get('GroupType')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        return self


class ListClusterHostResponseBodyHostListHostDiskListDisk(TeaModel):
    def __init__(
        self,
        type: str = None,
        disk_type: str = None,
        disk_id: str = None,
        device: str = None,
        disk_size: int = None,
    ):
        self.type = type
        self.disk_type = disk_type
        self.disk_id = disk_id
        self.device = device
        self.disk_size = disk_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_size is not None:
            result['DiskSize'] = self.disk_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskSize') is not None:
            self.disk_size = m.get('DiskSize')
        return self


class ListClusterHostResponseBodyHostListHostDiskList(TeaModel):
    def __init__(
        self,
        disk: List[ListClusterHostResponseBodyHostListHostDiskListDisk] = None,
    ):
        self.disk = disk

    def validate(self):
        if self.disk:
            for k in self.disk:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Disk'] = []
        if self.disk is not None:
            for k in self.disk:
                result['Disk'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.disk = []
        if m.get('Disk') is not None:
            for k in m.get('Disk'):
                temp_model = ListClusterHostResponseBodyHostListHostDiskListDisk()
                self.disk.append(temp_model.from_map(k))
        return self


class ListClusterHostResponseBodyHostListHost(TeaModel):
    def __init__(
        self,
        serial_number: str = None,
        type: str = None,
        status: str = None,
        private_ip: str = None,
        create_time: str = None,
        charge_type: str = None,
        host_name: str = None,
        host_group_id: str = None,
        instance_type: str = None,
        host_instance_id: str = None,
        support_ip_v6: bool = None,
        cpu: int = None,
        expired_time: int = None,
        zone_id: str = None,
        public_ip: str = None,
        instance_status: str = None,
        memory: int = None,
        emr_expired_time: str = None,
        role: str = None,
        disk_list: ListClusterHostResponseBodyHostListHostDiskList = None,
    ):
        self.serial_number = serial_number
        self.type = type
        self.status = status
        self.private_ip = private_ip
        self.create_time = create_time
        self.charge_type = charge_type
        self.host_name = host_name
        self.host_group_id = host_group_id
        self.instance_type = instance_type
        self.host_instance_id = host_instance_id
        self.support_ip_v6 = support_ip_v6
        self.cpu = cpu
        self.expired_time = expired_time
        self.zone_id = zone_id
        self.public_ip = public_ip
        self.instance_status = instance_status
        self.memory = memory
        self.emr_expired_time = emr_expired_time
        self.role = role
        self.disk_list = disk_list

    def validate(self):
        if self.disk_list:
            self.disk_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.type is not None:
            result['Type'] = self.type
        if self.status is not None:
            result['Status'] = self.status
        if self.private_ip is not None:
            result['PrivateIp'] = self.private_ip
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.host_instance_id is not None:
            result['HostInstanceId'] = self.host_instance_id
        if self.support_ip_v6 is not None:
            result['SupportIpV6'] = self.support_ip_v6
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        if self.public_ip is not None:
            result['PublicIp'] = self.public_ip
        if self.instance_status is not None:
            result['InstanceStatus'] = self.instance_status
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.emr_expired_time is not None:
            result['EmrExpiredTime'] = self.emr_expired_time
        if self.role is not None:
            result['Role'] = self.role
        if self.disk_list is not None:
            result['DiskList'] = self.disk_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PrivateIp') is not None:
            self.private_ip = m.get('PrivateIp')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('HostInstanceId') is not None:
            self.host_instance_id = m.get('HostInstanceId')
        if m.get('SupportIpV6') is not None:
            self.support_ip_v6 = m.get('SupportIpV6')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        if m.get('PublicIp') is not None:
            self.public_ip = m.get('PublicIp')
        if m.get('InstanceStatus') is not None:
            self.instance_status = m.get('InstanceStatus')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('EmrExpiredTime') is not None:
            self.emr_expired_time = m.get('EmrExpiredTime')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('DiskList') is not None:
            temp_model = ListClusterHostResponseBodyHostListHostDiskList()
            self.disk_list = temp_model.from_map(m['DiskList'])
        return self


class ListClusterHostResponseBodyHostList(TeaModel):
    def __init__(
        self,
        host: List[ListClusterHostResponseBodyHostListHost] = None,
    ):
        self.host = host

    def validate(self):
        if self.host:
            for k in self.host:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Host'] = []
        if self.host is not None:
            for k in self.host:
                result['Host'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.host = []
        if m.get('Host') is not None:
            for k in m.get('Host'):
                temp_model = ListClusterHostResponseBodyHostListHost()
                self.host.append(temp_model.from_map(k))
        return self


class ListClusterHostResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_number: int = None,
        page_size: int = None,
        total: int = None,
        host_list: ListClusterHostResponseBodyHostList = None,
    ):
        self.request_id = request_id
        self.page_number = page_number
        self.page_size = page_size
        self.total = total
        self.host_list = host_list

    def validate(self):
        if self.host_list:
            self.host_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        if self.host_list is not None:
            result['HostList'] = self.host_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('HostList') is not None:
            temp_model = ListClusterHostResponseBodyHostList()
            self.host_list = temp_model.from_map(m['HostList'])
        return self


class ListClusterHostResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListClusterHostResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListClusterHostResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateScalingGroupRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        name: str = None,
        description: str = None,
        host_group_id: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.name = name
        self.description = description
        self.host_group_id = host_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.name is not None:
            result['Name'] = self.name
        if self.description is not None:
            result['Description'] = self.description
        if self.host_group_id is not None:
            result['HostGroupId'] = self.host_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('HostGroupId') is not None:
            self.host_group_id = m.get('HostGroupId')
        return self


class CreateScalingGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        data: str = None,
    ):
        # requestId
        self.request_id = request_id
        # data
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class CreateScalingGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateScalingGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateScalingGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterServiceRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        service_name: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class DescribeClusterServiceResponseBodyServiceInfoServiceActionListServiceAction(TeaModel):
    def __init__(
        self,
        display_name: str = None,
        action_name: str = None,
        component_name: str = None,
        service_name: str = None,
        command: str = None,
    ):
        self.display_name = display_name
        self.action_name = action_name
        self.component_name = component_name
        self.service_name = service_name
        self.command = command

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.action_name is not None:
            result['ActionName'] = self.action_name
        if self.component_name is not None:
            result['ComponentName'] = self.component_name
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.command is not None:
            result['Command'] = self.command
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('ActionName') is not None:
            self.action_name = m.get('ActionName')
        if m.get('ComponentName') is not None:
            self.component_name = m.get('ComponentName')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        return self


class DescribeClusterServiceResponseBodyServiceInfoServiceActionList(TeaModel):
    def __init__(
        self,
        service_action: List[DescribeClusterServiceResponseBodyServiceInfoServiceActionListServiceAction] = None,
    ):
        self.service_action = service_action

    def validate(self):
        if self.service_action:
            for k in self.service_action:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ServiceAction'] = []
        if self.service_action is not None:
            for k in self.service_action:
                result['ServiceAction'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.service_action = []
        if m.get('ServiceAction') is not None:
            for k in m.get('ServiceAction'):
                temp_model = DescribeClusterServiceResponseBodyServiceInfoServiceActionListServiceAction()
                self.service_action.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceResponseBodyServiceInfoClusterServiceSummaryListClusterServiceSummary(TeaModel):
    def __init__(
        self,
        key: str = None,
        display_name: str = None,
        status: str = None,
        type: str = None,
        value: str = None,
        desired_stopped_value: int = None,
        alert_info: str = None,
        category: str = None,
    ):
        self.key = key
        self.display_name = display_name
        self.status = status
        self.type = type
        self.value = value
        self.desired_stopped_value = desired_stopped_value
        self.alert_info = alert_info
        self.category = category

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        if self.desired_stopped_value is not None:
            result['DesiredStoppedValue'] = self.desired_stopped_value
        if self.alert_info is not None:
            result['AlertInfo'] = self.alert_info
        if self.category is not None:
            result['Category'] = self.category
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('DesiredStoppedValue') is not None:
            self.desired_stopped_value = m.get('DesiredStoppedValue')
        if m.get('AlertInfo') is not None:
            self.alert_info = m.get('AlertInfo')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        return self


class DescribeClusterServiceResponseBodyServiceInfoClusterServiceSummaryList(TeaModel):
    def __init__(
        self,
        cluster_service_summary: List[DescribeClusterServiceResponseBodyServiceInfoClusterServiceSummaryListClusterServiceSummary] = None,
    ):
        self.cluster_service_summary = cluster_service_summary

    def validate(self):
        if self.cluster_service_summary:
            for k in self.cluster_service_summary:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterServiceSummary'] = []
        if self.cluster_service_summary is not None:
            for k in self.cluster_service_summary:
                result['ClusterServiceSummary'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_service_summary = []
        if m.get('ClusterServiceSummary') is not None:
            for k in m.get('ClusterServiceSummary'):
                temp_model = DescribeClusterServiceResponseBodyServiceInfoClusterServiceSummaryListClusterServiceSummary()
                self.cluster_service_summary.append(temp_model.from_map(k))
        return self


class DescribeClusterServiceResponseBodyServiceInfoNeedRestartHostIdList(TeaModel):
    def __init__(
        self,
        service: List[str] = None,
    ):
        self.service = service

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service is not None:
            result['Service'] = self.service
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Service') is not None:
            self.service = m.get('Service')
        return self


class DescribeClusterServiceResponseBodyServiceInfoNeedRestartComponentNameList(TeaModel):
    def __init__(
        self,
        service: List[str] = None,
    ):
        self.service = service

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service is not None:
            result['Service'] = self.service
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Service') is not None:
            self.service = m.get('Service')
        return self


class DescribeClusterServiceResponseBodyServiceInfo(TeaModel):
    def __init__(
        self,
        need_restart_info: str = None,
        service_version: str = None,
        service_status: str = None,
        service_name: str = None,
        need_restart_num: int = None,
        service_action_list: DescribeClusterServiceResponseBodyServiceInfoServiceActionList = None,
        cluster_service_summary_list: DescribeClusterServiceResponseBodyServiceInfoClusterServiceSummaryList = None,
        need_restart_host_id_list: DescribeClusterServiceResponseBodyServiceInfoNeedRestartHostIdList = None,
        need_restart_component_name_list: DescribeClusterServiceResponseBodyServiceInfoNeedRestartComponentNameList = None,
    ):
        self.need_restart_info = need_restart_info
        self.service_version = service_version
        self.service_status = service_status
        self.service_name = service_name
        self.need_restart_num = need_restart_num
        self.service_action_list = service_action_list
        self.cluster_service_summary_list = cluster_service_summary_list
        self.need_restart_host_id_list = need_restart_host_id_list
        self.need_restart_component_name_list = need_restart_component_name_list

    def validate(self):
        if self.service_action_list:
            self.service_action_list.validate()
        if self.cluster_service_summary_list:
            self.cluster_service_summary_list.validate()
        if self.need_restart_host_id_list:
            self.need_restart_host_id_list.validate()
        if self.need_restart_component_name_list:
            self.need_restart_component_name_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.need_restart_info is not None:
            result['NeedRestartInfo'] = self.need_restart_info
        if self.service_version is not None:
            result['ServiceVersion'] = self.service_version
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.need_restart_num is not None:
            result['NeedRestartNum'] = self.need_restart_num
        if self.service_action_list is not None:
            result['ServiceActionList'] = self.service_action_list.to_map()
        if self.cluster_service_summary_list is not None:
            result['ClusterServiceSummaryList'] = self.cluster_service_summary_list.to_map()
        if self.need_restart_host_id_list is not None:
            result['NeedRestartHostIdList'] = self.need_restart_host_id_list.to_map()
        if self.need_restart_component_name_list is not None:
            result['NeedRestartComponentNameList'] = self.need_restart_component_name_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NeedRestartInfo') is not None:
            self.need_restart_info = m.get('NeedRestartInfo')
        if m.get('ServiceVersion') is not None:
            self.service_version = m.get('ServiceVersion')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('NeedRestartNum') is not None:
            self.need_restart_num = m.get('NeedRestartNum')
        if m.get('ServiceActionList') is not None:
            temp_model = DescribeClusterServiceResponseBodyServiceInfoServiceActionList()
            self.service_action_list = temp_model.from_map(m['ServiceActionList'])
        if m.get('ClusterServiceSummaryList') is not None:
            temp_model = DescribeClusterServiceResponseBodyServiceInfoClusterServiceSummaryList()
            self.cluster_service_summary_list = temp_model.from_map(m['ClusterServiceSummaryList'])
        if m.get('NeedRestartHostIdList') is not None:
            temp_model = DescribeClusterServiceResponseBodyServiceInfoNeedRestartHostIdList()
            self.need_restart_host_id_list = temp_model.from_map(m['NeedRestartHostIdList'])
        if m.get('NeedRestartComponentNameList') is not None:
            temp_model = DescribeClusterServiceResponseBodyServiceInfoNeedRestartComponentNameList()
            self.need_restart_component_name_list = temp_model.from_map(m['NeedRestartComponentNameList'])
        return self


class DescribeClusterServiceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        service_info: DescribeClusterServiceResponseBodyServiceInfo = None,
    ):
        self.request_id = request_id
        self.service_info = service_info

    def validate(self):
        if self.service_info:
            self.service_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.service_info is not None:
            result['ServiceInfo'] = self.service_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ServiceInfo') is not None:
            temp_model = DescribeClusterServiceResponseBodyServiceInfo()
            self.service_info = temp_model.from_map(m['ServiceInfo'])
        return self


class DescribeClusterServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeClusterServiceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClusterServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowProjectsRequest(TeaModel):
    def __init__(
        self,
        product_type: str = None,
        region_id: str = None,
        project_id: str = None,
        name: str = None,
        page_number: int = None,
        page_size: int = None,
        resource_group_id: str = None,
    ):
        self.product_type = product_type
        self.region_id = region_id
        self.project_id = project_id
        self.name = name
        self.page_number = page_number
        self.page_size = page_size
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class ListFlowProjectsResponseBodyProjectsProject(TeaModel):
    def __init__(
        self,
        description: str = None,
        user_id: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        name: str = None,
        id: str = None,
    ):
        self.description = description
        self.user_id = user_id
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.name = name
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.name is not None:
            result['Name'] = self.name
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class ListFlowProjectsResponseBodyProjects(TeaModel):
    def __init__(
        self,
        project: List[ListFlowProjectsResponseBodyProjectsProject] = None,
    ):
        self.project = project

    def validate(self):
        if self.project:
            for k in self.project:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Project'] = []
        if self.project is not None:
            for k in self.project:
                result['Project'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.project = []
        if m.get('Project') is not None:
            for k in m.get('Project'):
                temp_model = ListFlowProjectsResponseBodyProjectsProject()
                self.project.append(temp_model.from_map(k))
        return self


class ListFlowProjectsResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total: int = None,
        projects: ListFlowProjectsResponseBodyProjects = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.total = total
        self.projects = projects

    def validate(self):
        if self.projects:
            self.projects.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        if self.projects is not None:
            result['Projects'] = self.projects.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Projects') is not None:
            temp_model = ListFlowProjectsResponseBodyProjects()
            self.projects = temp_model.from_map(m['Projects'])
        return self


class ListFlowProjectsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListFlowProjectsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListFlowProjectsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateMetaTablePreviewTaskRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        region_id: str = None,
        cluster_id: str = None,
        database_id: str = None,
        table_id: str = None,
        user: str = None,
        password: str = None,
        resource_group_id: str = None,
        client_token: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.region_id = region_id
        self.cluster_id = cluster_id
        self.database_id = database_id
        self.table_id = table_id
        self.user = user
        self.password = password
        self.resource_group_id = resource_group_id
        self.client_token = client_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.database_id is not None:
            result['DatabaseId'] = self.database_id
        if self.table_id is not None:
            result['TableId'] = self.table_id
        if self.user is not None:
            result['User'] = self.user
        if self.password is not None:
            result['Password'] = self.password
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('DatabaseId') is not None:
            self.database_id = m.get('DatabaseId')
        if m.get('TableId') is not None:
            self.table_id = m.get('TableId')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        return self


class CreateMetaTablePreviewTaskResponseBody(TeaModel):
    def __init__(
        self,
        task_id: str = None,
        request_id: str = None,
    ):
        self.task_id = task_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateMetaTablePreviewTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateMetaTablePreviewTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateMetaTablePreviewTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListFlowProjectUserRequest(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        project_id: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.region_id = region_id
        self.project_id = project_id
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListFlowProjectUserResponseBodyUsersUser(TeaModel):
    def __init__(
        self,
        project_id: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        user_name: str = None,
        account_user_id: str = None,
        owner_id: str = None,
    ):
        self.project_id = project_id
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.user_name = user_name
        self.account_user_id = account_user_id
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.account_user_id is not None:
            result['AccountUserId'] = self.account_user_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('AccountUserId') is not None:
            self.account_user_id = m.get('AccountUserId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class ListFlowProjectUserResponseBodyUsers(TeaModel):
    def __init__(
        self,
        user: List[ListFlowProjectUserResponseBodyUsersUser] = None,
    ):
        self.user = user

    def validate(self):
        if self.user:
            for k in self.user:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['User'] = []
        if self.user is not None:
            for k in self.user:
                result['User'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.user = []
        if m.get('User') is not None:
            for k in m.get('User'):
                temp_model = ListFlowProjectUserResponseBodyUsersUser()
                self.user.append(temp_model.from_map(k))
        return self


class ListFlowProjectUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        page_number: int = None,
        page_size: int = None,
        total: int = None,
        users: ListFlowProjectUserResponseBodyUsers = None,
    ):
        self.request_id = request_id
        self.page_number = page_number
        self.page_size = page_size
        self.total = total
        self.users = users

    def validate(self):
        if self.users:
            self.users.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.page_number