# Wind Linker

Wind 数据本地转发 API 客户端 - 简单易用,无需直接调用 HTTP 接口。

[![PyPI version](https://badge.fury.io/py/wind-linker.svg)](https://pypi.org/project/wind-linker/)
[![Python versions](https://img.shields.io/pypi/pyversions/wind-linker.svg)](https://pypi.org/project/wind-linker/)

## 快速开始

### 1. 安装

**方法一: 从 PyPI 安装 (推荐)**

```bash
pip install wind-linker
```

如果需要 pandas 支持:

```bash
pip install wind-linker[pandas]
```

**方法二: 从源码安装**

```bash
cd wind-linker/wind_linker
pip install -e .
```

### 2. 配置 API 地址

```bash
python -m wind_linker config http://192.168.10.10:10010
```

### 3. 使用

```python
from wind_linker import w

# 获取历史数据
data = w.wsd("000001.SZ", "close", "2025-01-01", "2025-01-10")
print(data.Data)

# 转换为 DataFrame
df = data.to_df()
print(df)
```

## 使用示例

### 历史数据

```python
from wind_linker import w

# 单字段
data = w.wsd("000001.SZ", "close", "2025-01-01", "2025-01-10")
df = data.to_df()

# 多字段
data = w.wsd("000001.SZ", "open,high,low,close,volume", "2025-01-01", "2025-01-10")
df = data.to_df()

# 多品种
data = w.wsd("000001.SZ,600000.SH", "close", "2025-01-01", "2025-01-10")
df = data.to_df()
```

### 分钟数据

```python
data = w.wsi("000001.SZ", "close,volume", "2025-01-10 09:30:00", "2025-01-10 15:00:00")
df = data.to_df()
```

### 实时行情

```python
data = w.wsq("000001.SZ,600000.SH", "rt_last,rt_vol")
df = data.to_df()
```

### 板块成分

```python
data = w.wset("sectorconstituent", "date=2025-01-10;sectorid=a001010100000000")
df = data.to_df()
```

### 经济数据

```python
# 获取经济指标数据
data = w.edb("M5567876", "2024-10-30", "2025-10-30", "Fill=Previous")
df = data.to_df()

# 多个指标
data = w.edb("M5567876,M0017126", "2024-01-01", "2025-01-01")
df = data.to_df()
```

### 批量查询

```python
results = w.batch([
    'w.wsd("000001.SZ", "close", "2025-01-01", "2025-01-10")',
    'w.wsd("600000.SH", "close", "2025-01-01", "2025-01-10")'
])

for result in results:
    print(result.to_df())
```

### 自定义代码

```python
data = w.execute('w.wsd("000001.SZ", "close", "2025-01-01", "2025-01-10")')
df = data.to_df()
```

## 配置方式

### 方法 1: 命令行配置 (推荐)

```bash
python -m wind_linker config http://192.168.10.10:10010
```

查看当前配置:

```bash
python -m wind_linker show
```

### 方法 2: 环境变量

```bash
# Windows
set WIND_API_URL=http://192.168.10.10:10010

# Linux/Mac
export WIND_API_URL=http://192.168.10.10:10010
```

### 方法 3: 代码中指定

```python
from wind_linker import WindAPI

w = WindAPI(base_url="http://192.168.10.10:10010")
```

配置优先级: 代码指定 > 环境变量 > 配置文件 > 默认值(localhost:10010)

## API 参考

### WindData 对象

返回的数据对象,包含以下属性:

- `ErrorCode`: 错误码 (0 表示成功)
- `Codes`: 股票代码列表
- `Fields`: 字段列表
- `Times`: 时间列表
- `Data`: 数据列表
- `to_df()`: 转换为 pandas DataFrame (需要安装 pandas)

### WindAPI 方法

- `wsd(codes, fields, begin_time, end_time, options="")`: 历史数据
- `wsi(codes, fields, begin_time, end_time, options="")`: 分钟数据
- `wsq(codes, fields="rt_last")`: 实时行情
- `wset(tablename, options="")`: 板块成分
- `execute(code)`: 执行自定义代码
- `batch(codes)`: 批量执行
- `health()`: 健康检查

## 安装要求

- Python >= 3.7
- requests >= 2.25.0
- pandas >= 1.0.0 (可选,用于 DataFrame 支持)

## 更新

查看当前版本:

```bash
pip show wind-linker
```

更新到最新版本:

```bash
pip install --upgrade wind-linker
```

## 常见问题

### 1. 如何查看当前配置的 API 地址?

```bash
python -m wind_linker show
```

### 2. 如何切换不同的 API 服务器?

```bash
python -m wind_linker config http://新地址:端口
```

### 3. 返回数据为空怎么办?

检查服务是否正常运行:

```python
from wind_linker import w
print(w.health())
```

### 4. 如何开启调试模式?

```python
from wind_linker import WindAPI

w = WindAPI(debug=True)
data = w.wsd("000001.SZ", "close", "2025-01-01", "2025-01-10")
```

## 许可证

MIT

