"""命令行工具"""

import sys
from .config import set_api_url, get_api_url


def main():
    if len(sys.argv) < 2:
        print("Wind Linker 配置工具")
        print()
        print("用法:")
        print("  python -m wind_linker config <API地址>    # 设置 API 地址")
        print("  python -m wind_linker show                # 查看当前配置")
        print()
        print("示例:")
        print("  python -m wind_linker config http://192.168.10.10:10010")
        return
    
    command = sys.argv[1]
    
    if command == "config":
        if len(sys.argv) < 3:
            print("❌ 请指定 API 地址")
            print("示例: python -m wind_linker config http://192.168.10.10:10010")
            return
        
        url = sys.argv[2]
        set_api_url(url)
    
    elif command == "show":
        url = get_api_url()
        print(f"当前 API 地址: {url}")
    
    else:
        print(f"❌ 未知命令: {command}")


if __name__ == "__main__":
    main()

