"""配置管理"""

import os
import json


CONFIG_FILE = os.path.expanduser("~/.wind_linker/config.json")


def set_api_url(url: str):
    """设置 API 地址"""
    os.makedirs(os.path.dirname(CONFIG_FILE), exist_ok=True)
    with open(CONFIG_FILE, "w", encoding="utf-8") as f:
        json.dump({"api_url": url}, f)
    print(f"✅ API 地址已设置: {url}")


def get_api_url() -> str:
    """获取 API 地址"""
    # 优先级: 环境变量 > 配置文件 > 默认值
    if os.getenv("WIND_API_URL"):
        return os.getenv("WIND_API_URL")
    
    if os.path.exists(CONFIG_FILE):
        try:
            with open(CONFIG_FILE, "r", encoding="utf-8") as f:
                config = json.load(f)
                return config.get("api_url", "http://localhost:10010")
        except:
            pass
    
    return "http://localhost:10010"

