# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from typing import Dict
from Tea.core import TeaCore

from alibabacloud_tea_openapi.client import Client as OpenApiClient
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_tea_util.client import Client as UtilClient
from alibabacloud_endpoint_util.client import Client as EndpointUtilClient
from alibabacloud_mse20190531 import models as mse_20190531_models
from alibabacloud_tea_util import models as util_models
from alibabacloud_openapi_util.client import Client as OpenApiUtilClient


class Client(OpenApiClient):
    """
    *\
    """
    def __init__(
        self, 
        config: open_api_models.Config,
    ):
        super().__init__(config)
        self._signature_algorithm = 'v2'
        self._endpoint_rule = 'regional'
        self.check_config(config)
        self._endpoint = self.get_endpoint('mse', self._region_id, self._endpoint_rule, self._network, self._suffix, self._endpoint_map, self._endpoint)

    def get_endpoint(
        self,
        product_id: str,
        region_id: str,
        endpoint_rule: str,
        network: str,
        suffix: str,
        endpoint_map: Dict[str, str],
        endpoint: str,
    ) -> str:
        if not UtilClient.empty(endpoint):
            return endpoint
        if not UtilClient.is_unset(endpoint_map) and not UtilClient.empty(endpoint_map.get(region_id)):
            return endpoint_map.get(region_id)
        return EndpointUtilClient.get_endpoint_rules(product_id, region_id, endpoint_rule, network, suffix)

    def add_auth_policy_with_options(
        self,
        request: mse_20190531_models.AddAuthPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddAuthPolicyResponse:
        """
        @summary 新增服务鉴权规则
        
        @param request: AddAuthPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddAuthPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.auth_rule):
            query['AuthRule'] = request.auth_rule
        if not UtilClient.is_unset(request.auth_type):
            query['AuthType'] = request.auth_type
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.k_8s_namespace):
            query['K8sNamespace'] = request.k_8s_namespace
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.protocol):
            query['Protocol'] = request.protocol
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddAuthPolicy',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddAuthPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_auth_policy_with_options_async(
        self,
        request: mse_20190531_models.AddAuthPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddAuthPolicyResponse:
        """
        @summary 新增服务鉴权规则
        
        @param request: AddAuthPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddAuthPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.auth_rule):
            query['AuthRule'] = request.auth_rule
        if not UtilClient.is_unset(request.auth_type):
            query['AuthType'] = request.auth_type
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.k_8s_namespace):
            query['K8sNamespace'] = request.k_8s_namespace
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.protocol):
            query['Protocol'] = request.protocol
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddAuthPolicy',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddAuthPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_auth_policy(
        self,
        request: mse_20190531_models.AddAuthPolicyRequest,
    ) -> mse_20190531_models.AddAuthPolicyResponse:
        """
        @summary 新增服务鉴权规则
        
        @param request: AddAuthPolicyRequest
        @return: AddAuthPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_auth_policy_with_options(request, runtime)

    async def add_auth_policy_async(
        self,
        request: mse_20190531_models.AddAuthPolicyRequest,
    ) -> mse_20190531_models.AddAuthPolicyResponse:
        """
        @summary 新增服务鉴权规则
        
        @param request: AddAuthPolicyRequest
        @return: AddAuthPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_auth_policy_with_options_async(request, runtime)

    def add_auth_resource_with_options(
        self,
        tmp_req: mse_20190531_models.AddAuthResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddAuthResourceResponse:
        """
        @summary Creates authorization information for a gateway.
        
        @param tmp_req: AddAuthResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddAuthResourceResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.AddAuthResourceShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.auth_resource_header_list):
            request.auth_resource_header_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.auth_resource_header_list, 'AuthResourceHeaderList', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.auth_id):
            query['AuthId'] = request.auth_id
        if not UtilClient.is_unset(request.auth_resource_header_list_shrink):
            query['AuthResourceHeaderList'] = request.auth_resource_header_list_shrink
        if not UtilClient.is_unset(request.domain_id):
            query['DomainId'] = request.domain_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.ignore_case):
            query['IgnoreCase'] = request.ignore_case
        if not UtilClient.is_unset(request.match_type):
            query['MatchType'] = request.match_type
        if not UtilClient.is_unset(request.path):
            query['Path'] = request.path
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddAuthResource',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddAuthResourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_auth_resource_with_options_async(
        self,
        tmp_req: mse_20190531_models.AddAuthResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddAuthResourceResponse:
        """
        @summary Creates authorization information for a gateway.
        
        @param tmp_req: AddAuthResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddAuthResourceResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.AddAuthResourceShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.auth_resource_header_list):
            request.auth_resource_header_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.auth_resource_header_list, 'AuthResourceHeaderList', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.auth_id):
            query['AuthId'] = request.auth_id
        if not UtilClient.is_unset(request.auth_resource_header_list_shrink):
            query['AuthResourceHeaderList'] = request.auth_resource_header_list_shrink
        if not UtilClient.is_unset(request.domain_id):
            query['DomainId'] = request.domain_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.ignore_case):
            query['IgnoreCase'] = request.ignore_case
        if not UtilClient.is_unset(request.match_type):
            query['MatchType'] = request.match_type
        if not UtilClient.is_unset(request.path):
            query['Path'] = request.path
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddAuthResource',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddAuthResourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_auth_resource(
        self,
        request: mse_20190531_models.AddAuthResourceRequest,
    ) -> mse_20190531_models.AddAuthResourceResponse:
        """
        @summary Creates authorization information for a gateway.
        
        @param request: AddAuthResourceRequest
        @return: AddAuthResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_auth_resource_with_options(request, runtime)

    async def add_auth_resource_async(
        self,
        request: mse_20190531_models.AddAuthResourceRequest,
    ) -> mse_20190531_models.AddAuthResourceResponse:
        """
        @summary Creates authorization information for a gateway.
        
        @param request: AddAuthResourceRequest
        @return: AddAuthResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_auth_resource_with_options_async(request, runtime)

    def add_black_white_list_with_options(
        self,
        request: mse_20190531_models.AddBlackWhiteListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddBlackWhiteListResponse:
        """
        @summary Creates a blacklist or a whitelist.
        
        @param request: AddBlackWhiteListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddBlackWhiteListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.content):
            query['Content'] = request.content
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.is_white):
            query['IsWhite'] = request.is_white
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.note):
            query['Note'] = request.note
        if not UtilClient.is_unset(request.resource_id_json_list):
            query['ResourceIdJsonList'] = request.resource_id_json_list
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddBlackWhiteList',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddBlackWhiteListResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_black_white_list_with_options_async(
        self,
        request: mse_20190531_models.AddBlackWhiteListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddBlackWhiteListResponse:
        """
        @summary Creates a blacklist or a whitelist.
        
        @param request: AddBlackWhiteListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddBlackWhiteListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.content):
            query['Content'] = request.content
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.is_white):
            query['IsWhite'] = request.is_white
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.note):
            query['Note'] = request.note
        if not UtilClient.is_unset(request.resource_id_json_list):
            query['ResourceIdJsonList'] = request.resource_id_json_list
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddBlackWhiteList',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddBlackWhiteListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_black_white_list(
        self,
        request: mse_20190531_models.AddBlackWhiteListRequest,
    ) -> mse_20190531_models.AddBlackWhiteListResponse:
        """
        @summary Creates a blacklist or a whitelist.
        
        @param request: AddBlackWhiteListRequest
        @return: AddBlackWhiteListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_black_white_list_with_options(request, runtime)

    async def add_black_white_list_async(
        self,
        request: mse_20190531_models.AddBlackWhiteListRequest,
    ) -> mse_20190531_models.AddBlackWhiteListResponse:
        """
        @summary Creates a blacklist or a whitelist.
        
        @param request: AddBlackWhiteListRequest
        @return: AddBlackWhiteListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_black_white_list_with_options_async(request, runtime)

    def add_gateway_with_options(
        self,
        tmp_req: mse_20190531_models.AddGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddGatewayResponse:
        """
        @summary Adds a gateway.
        
        @param tmp_req: AddGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddGatewayResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.AddGatewayShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.zone_info):
            request.zone_info_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.zone_info, 'ZoneInfo', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.clb_network_type):
            query['ClbNetworkType'] = request.clb_network_type
        if not UtilClient.is_unset(request.enable_hardware_acceleration):
            query['EnableHardwareAcceleration'] = request.enable_hardware_acceleration
        if not UtilClient.is_unset(request.enable_sls):
            query['EnableSls'] = request.enable_sls
        if not UtilClient.is_unset(request.enable_xtrace):
            query['EnableXtrace'] = request.enable_xtrace
        if not UtilClient.is_unset(request.enterprise_security_group):
            query['EnterpriseSecurityGroup'] = request.enterprise_security_group
        if not UtilClient.is_unset(request.internet_slb_spec):
            query['InternetSlbSpec'] = request.internet_slb_spec
        if not UtilClient.is_unset(request.managed_entry_network_type):
            query['ManagedEntryNetworkType'] = request.managed_entry_network_type
        if not UtilClient.is_unset(request.mser_version):
            query['MserVersion'] = request.mser_version
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.nlb_network_type):
            query['NlbNetworkType'] = request.nlb_network_type
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.replica):
            query['Replica'] = request.replica
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.slb_spec):
            query['SlbSpec'] = request.slb_spec
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.v_switch_id_2):
            query['VSwitchId2'] = request.v_switch_id_2
        if not UtilClient.is_unset(request.vpc):
            query['Vpc'] = request.vpc
        if not UtilClient.is_unset(request.xtrace_ratio):
            query['XtraceRatio'] = request.xtrace_ratio
        if not UtilClient.is_unset(request.zone_info_shrink):
            query['ZoneInfo'] = request.zone_info_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddGateway',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_gateway_with_options_async(
        self,
        tmp_req: mse_20190531_models.AddGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddGatewayResponse:
        """
        @summary Adds a gateway.
        
        @param tmp_req: AddGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddGatewayResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.AddGatewayShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.zone_info):
            request.zone_info_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.zone_info, 'ZoneInfo', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.clb_network_type):
            query['ClbNetworkType'] = request.clb_network_type
        if not UtilClient.is_unset(request.enable_hardware_acceleration):
            query['EnableHardwareAcceleration'] = request.enable_hardware_acceleration
        if not UtilClient.is_unset(request.enable_sls):
            query['EnableSls'] = request.enable_sls
        if not UtilClient.is_unset(request.enable_xtrace):
            query['EnableXtrace'] = request.enable_xtrace
        if not UtilClient.is_unset(request.enterprise_security_group):
            query['EnterpriseSecurityGroup'] = request.enterprise_security_group
        if not UtilClient.is_unset(request.internet_slb_spec):
            query['InternetSlbSpec'] = request.internet_slb_spec
        if not UtilClient.is_unset(request.managed_entry_network_type):
            query['ManagedEntryNetworkType'] = request.managed_entry_network_type
        if not UtilClient.is_unset(request.mser_version):
            query['MserVersion'] = request.mser_version
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.nlb_network_type):
            query['NlbNetworkType'] = request.nlb_network_type
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.replica):
            query['Replica'] = request.replica
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.slb_spec):
            query['SlbSpec'] = request.slb_spec
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.v_switch_id_2):
            query['VSwitchId2'] = request.v_switch_id_2
        if not UtilClient.is_unset(request.vpc):
            query['Vpc'] = request.vpc
        if not UtilClient.is_unset(request.xtrace_ratio):
            query['XtraceRatio'] = request.xtrace_ratio
        if not UtilClient.is_unset(request.zone_info_shrink):
            query['ZoneInfo'] = request.zone_info_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddGateway',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_gateway(
        self,
        request: mse_20190531_models.AddGatewayRequest,
    ) -> mse_20190531_models.AddGatewayResponse:
        """
        @summary Adds a gateway.
        
        @param request: AddGatewayRequest
        @return: AddGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_gateway_with_options(request, runtime)

    async def add_gateway_async(
        self,
        request: mse_20190531_models.AddGatewayRequest,
    ) -> mse_20190531_models.AddGatewayResponse:
        """
        @summary Adds a gateway.
        
        @param request: AddGatewayRequest
        @return: AddGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_gateway_with_options_async(request, runtime)

    def add_gateway_auth_with_options(
        self,
        tmp_req: mse_20190531_models.AddGatewayAuthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddGatewayAuthResponse:
        """
        @summary Adds an authentication configuration for a gateway.
        
        @param tmp_req: AddGatewayAuthRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddGatewayAuthResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.AddGatewayAuthShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.auth_resource_list):
            request.auth_resource_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.auth_resource_list, 'AuthResourceList', 'json')
        if not UtilClient.is_unset(tmp_req.external_auth_zjson):
            request.external_auth_zjsonshrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.external_auth_zjson, 'ExternalAuthZJSON', 'json')
        if not UtilClient.is_unset(tmp_req.scopes_list):
            request.scopes_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.scopes_list, 'ScopesList', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.auth_resource_config):
            query['AuthResourceConfig'] = request.auth_resource_config
        if not UtilClient.is_unset(request.auth_resource_list_shrink):
            query['AuthResourceList'] = request.auth_resource_list_shrink
        if not UtilClient.is_unset(request.auth_resource_mode):
            query['AuthResourceMode'] = request.auth_resource_mode
        if not UtilClient.is_unset(request.client_id):
            query['ClientId'] = request.client_id
        if not UtilClient.is_unset(request.client_secret):
            query['ClientSecret'] = request.client_secret
        if not UtilClient.is_unset(request.cookie_domain):
            query['CookieDomain'] = request.cookie_domain
        if not UtilClient.is_unset(request.external_auth_zjsonshrink):
            query['ExternalAuthZJSON'] = request.external_auth_zjsonshrink
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.is_white):
            query['IsWhite'] = request.is_white
        if not UtilClient.is_unset(request.issuer):
            query['Issuer'] = request.issuer
        if not UtilClient.is_unset(request.jwks):
            query['Jwks'] = request.jwks
        if not UtilClient.is_unset(request.login_url):
            query['LoginUrl'] = request.login_url
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.redirect_url):
            query['RedirectUrl'] = request.redirect_url
        if not UtilClient.is_unset(request.scopes_list_shrink):
            query['ScopesList'] = request.scopes_list_shrink
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.sub):
            query['Sub'] = request.sub
        if not UtilClient.is_unset(request.token_name):
            query['TokenName'] = request.token_name
        if not UtilClient.is_unset(request.token_name_prefix):
            query['TokenNamePrefix'] = request.token_name_prefix
        if not UtilClient.is_unset(request.token_pass):
            query['TokenPass'] = request.token_pass
        if not UtilClient.is_unset(request.token_position):
            query['TokenPosition'] = request.token_position
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddGatewayAuth',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddGatewayAuthResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_gateway_auth_with_options_async(
        self,
        tmp_req: mse_20190531_models.AddGatewayAuthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddGatewayAuthResponse:
        """
        @summary Adds an authentication configuration for a gateway.
        
        @param tmp_req: AddGatewayAuthRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddGatewayAuthResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.AddGatewayAuthShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.auth_resource_list):
            request.auth_resource_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.auth_resource_list, 'AuthResourceList', 'json')
        if not UtilClient.is_unset(tmp_req.external_auth_zjson):
            request.external_auth_zjsonshrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.external_auth_zjson, 'ExternalAuthZJSON', 'json')
        if not UtilClient.is_unset(tmp_req.scopes_list):
            request.scopes_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.scopes_list, 'ScopesList', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.auth_resource_config):
            query['AuthResourceConfig'] = request.auth_resource_config
        if not UtilClient.is_unset(request.auth_resource_list_shrink):
            query['AuthResourceList'] = request.auth_resource_list_shrink
        if not UtilClient.is_unset(request.auth_resource_mode):
            query['AuthResourceMode'] = request.auth_resource_mode
        if not UtilClient.is_unset(request.client_id):
            query['ClientId'] = request.client_id
        if not UtilClient.is_unset(request.client_secret):
            query['ClientSecret'] = request.client_secret
        if not UtilClient.is_unset(request.cookie_domain):
            query['CookieDomain'] = request.cookie_domain
        if not UtilClient.is_unset(request.external_auth_zjsonshrink):
            query['ExternalAuthZJSON'] = request.external_auth_zjsonshrink
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.is_white):
            query['IsWhite'] = request.is_white
        if not UtilClient.is_unset(request.issuer):
            query['Issuer'] = request.issuer
        if not UtilClient.is_unset(request.jwks):
            query['Jwks'] = request.jwks
        if not UtilClient.is_unset(request.login_url):
            query['LoginUrl'] = request.login_url
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.redirect_url):
            query['RedirectUrl'] = request.redirect_url
        if not UtilClient.is_unset(request.scopes_list_shrink):
            query['ScopesList'] = request.scopes_list_shrink
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.sub):
            query['Sub'] = request.sub
        if not UtilClient.is_unset(request.token_name):
            query['TokenName'] = request.token_name
        if not UtilClient.is_unset(request.token_name_prefix):
            query['TokenNamePrefix'] = request.token_name_prefix
        if not UtilClient.is_unset(request.token_pass):
            query['TokenPass'] = request.token_pass
        if not UtilClient.is_unset(request.token_position):
            query['TokenPosition'] = request.token_position
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddGatewayAuth',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddGatewayAuthResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_gateway_auth(
        self,
        request: mse_20190531_models.AddGatewayAuthRequest,
    ) -> mse_20190531_models.AddGatewayAuthResponse:
        """
        @summary Adds an authentication configuration for a gateway.
        
        @param request: AddGatewayAuthRequest
        @return: AddGatewayAuthResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_gateway_auth_with_options(request, runtime)

    async def add_gateway_auth_async(
        self,
        request: mse_20190531_models.AddGatewayAuthRequest,
    ) -> mse_20190531_models.AddGatewayAuthResponse:
        """
        @summary Adds an authentication configuration for a gateway.
        
        @param request: AddGatewayAuthRequest
        @return: AddGatewayAuthResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_gateway_auth_with_options_async(request, runtime)

    def add_gateway_auth_consumer_with_options(
        self,
        request: mse_20190531_models.AddGatewayAuthConsumerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddGatewayAuthConsumerResponse:
        """
        @summary Adds a consumer on which a gateway performs authentication operations.
        
        @param request: AddGatewayAuthConsumerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddGatewayAuthConsumerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.encode_type):
            query['EncodeType'] = request.encode_type
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.jwks):
            query['Jwks'] = request.jwks
        if not UtilClient.is_unset(request.key_name):
            query['KeyName'] = request.key_name
        if not UtilClient.is_unset(request.key_value):
            query['KeyValue'] = request.key_value
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.token_name):
            query['TokenName'] = request.token_name
        if not UtilClient.is_unset(request.token_pass):
            query['TokenPass'] = request.token_pass
        if not UtilClient.is_unset(request.token_position):
            query['TokenPosition'] = request.token_position
        if not UtilClient.is_unset(request.token_prefix):
            query['TokenPrefix'] = request.token_prefix
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddGatewayAuthConsumer',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddGatewayAuthConsumerResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_gateway_auth_consumer_with_options_async(
        self,
        request: mse_20190531_models.AddGatewayAuthConsumerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddGatewayAuthConsumerResponse:
        """
        @summary Adds a consumer on which a gateway performs authentication operations.
        
        @param request: AddGatewayAuthConsumerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddGatewayAuthConsumerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.encode_type):
            query['EncodeType'] = request.encode_type
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.jwks):
            query['Jwks'] = request.jwks
        if not UtilClient.is_unset(request.key_name):
            query['KeyName'] = request.key_name
        if not UtilClient.is_unset(request.key_value):
            query['KeyValue'] = request.key_value
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.token_name):
            query['TokenName'] = request.token_name
        if not UtilClient.is_unset(request.token_pass):
            query['TokenPass'] = request.token_pass
        if not UtilClient.is_unset(request.token_position):
            query['TokenPosition'] = request.token_position
        if not UtilClient.is_unset(request.token_prefix):
            query['TokenPrefix'] = request.token_prefix
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddGatewayAuthConsumer',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddGatewayAuthConsumerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_gateway_auth_consumer(
        self,
        request: mse_20190531_models.AddGatewayAuthConsumerRequest,
    ) -> mse_20190531_models.AddGatewayAuthConsumerResponse:
        """
        @summary Adds a consumer on which a gateway performs authentication operations.
        
        @param request: AddGatewayAuthConsumerRequest
        @return: AddGatewayAuthConsumerResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_gateway_auth_consumer_with_options(request, runtime)

    async def add_gateway_auth_consumer_async(
        self,
        request: mse_20190531_models.AddGatewayAuthConsumerRequest,
    ) -> mse_20190531_models.AddGatewayAuthConsumerResponse:
        """
        @summary Adds a consumer on which a gateway performs authentication operations.
        
        @param request: AddGatewayAuthConsumerRequest
        @return: AddGatewayAuthConsumerResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_gateway_auth_consumer_with_options_async(request, runtime)

    def add_gateway_domain_with_options(
        self,
        tmp_req: mse_20190531_models.AddGatewayDomainRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddGatewayDomainResponse:
        """
        @summary Associates a domain name with a gateway.
        
        @param tmp_req: AddGatewayDomainRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddGatewayDomainResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.AddGatewayDomainShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.tls_cipher_suites_config_json):
            request.tls_cipher_suites_config_jsonshrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.tls_cipher_suites_config_json, 'TlsCipherSuitesConfigJSON', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cert_identifier):
            query['CertIdentifier'] = request.cert_identifier
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.http_2):
            query['Http2'] = request.http_2
        if not UtilClient.is_unset(request.must_https):
            query['MustHttps'] = request.must_https
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.protocol):
            query['Protocol'] = request.protocol
        if not UtilClient.is_unset(request.tls_cipher_suites_config_jsonshrink):
            query['TlsCipherSuitesConfigJSON'] = request.tls_cipher_suites_config_jsonshrink
        if not UtilClient.is_unset(request.tls_max):
            query['TlsMax'] = request.tls_max
        if not UtilClient.is_unset(request.tls_min):
            query['TlsMin'] = request.tls_min
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddGatewayDomain',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddGatewayDomainResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_gateway_domain_with_options_async(
        self,
        tmp_req: mse_20190531_models.AddGatewayDomainRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddGatewayDomainResponse:
        """
        @summary Associates a domain name with a gateway.
        
        @param tmp_req: AddGatewayDomainRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddGatewayDomainResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.AddGatewayDomainShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.tls_cipher_suites_config_json):
            request.tls_cipher_suites_config_jsonshrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.tls_cipher_suites_config_json, 'TlsCipherSuitesConfigJSON', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cert_identifier):
            query['CertIdentifier'] = request.cert_identifier
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.http_2):
            query['Http2'] = request.http_2
        if not UtilClient.is_unset(request.must_https):
            query['MustHttps'] = request.must_https
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.protocol):
            query['Protocol'] = request.protocol
        if not UtilClient.is_unset(request.tls_cipher_suites_config_jsonshrink):
            query['TlsCipherSuitesConfigJSON'] = request.tls_cipher_suites_config_jsonshrink
        if not UtilClient.is_unset(request.tls_max):
            query['TlsMax'] = request.tls_max
        if not UtilClient.is_unset(request.tls_min):
            query['TlsMin'] = request.tls_min
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddGatewayDomain',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddGatewayDomainResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_gateway_domain(
        self,
        request: mse_20190531_models.AddGatewayDomainRequest,
    ) -> mse_20190531_models.AddGatewayDomainResponse:
        """
        @summary Associates a domain name with a gateway.
        
        @param request: AddGatewayDomainRequest
        @return: AddGatewayDomainResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_gateway_domain_with_options(request, runtime)

    async def add_gateway_domain_async(
        self,
        request: mse_20190531_models.AddGatewayDomainRequest,
    ) -> mse_20190531_models.AddGatewayDomainResponse:
        """
        @summary Associates a domain name with a gateway.
        
        @param request: AddGatewayDomainRequest
        @return: AddGatewayDomainResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_gateway_domain_with_options_async(request, runtime)

    def add_gateway_route_with_options(
        self,
        tmp_req: mse_20190531_models.AddGatewayRouteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddGatewayRouteResponse:
        """
        @summary Adds a gateway route.
        
        @param tmp_req: AddGatewayRouteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddGatewayRouteResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.AddGatewayRouteShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.direct_response_json):
            request.direct_response_jsonshrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.direct_response_json, 'DirectResponseJSON', 'json')
        if not UtilClient.is_unset(tmp_req.fallback_services):
            request.fallback_services_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.fallback_services, 'FallbackServices', 'json')
        if not UtilClient.is_unset(tmp_req.predicates):
            request.predicates_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.predicates, 'Predicates', 'json')
        if not UtilClient.is_unset(tmp_req.redirect_json):
            request.redirect_jsonshrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.redirect_json, 'RedirectJSON', 'json')
        if not UtilClient.is_unset(tmp_req.services):
            request.services_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.services, 'Services', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination_type):
            query['DestinationType'] = request.destination_type
        if not UtilClient.is_unset(request.direct_response_jsonshrink):
            query['DirectResponseJSON'] = request.direct_response_jsonshrink
        if not UtilClient.is_unset(request.domain_id):
            query['DomainId'] = request.domain_id
        if not UtilClient.is_unset(request.domain_id_list_json):
            query['DomainIdListJSON'] = request.domain_id_list_json
        if not UtilClient.is_unset(request.enable_waf):
            query['EnableWaf'] = request.enable_waf
        if not UtilClient.is_unset(request.fallback):
            query['Fallback'] = request.fallback
        if not UtilClient.is_unset(request.fallback_services_shrink):
            query['FallbackServices'] = request.fallback_services_shrink
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.policies):
            query['Policies'] = request.policies
        if not UtilClient.is_unset(request.predicates_shrink):
            query['Predicates'] = request.predicates_shrink
        if not UtilClient.is_unset(request.redirect_jsonshrink):
            query['RedirectJSON'] = request.redirect_jsonshrink
        if not UtilClient.is_unset(request.route_order):
            query['RouteOrder'] = request.route_order
        if not UtilClient.is_unset(request.route_type):
            query['RouteType'] = request.route_type
        if not UtilClient.is_unset(request.services_shrink):
            query['Services'] = request.services_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddGatewayRoute',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddGatewayRouteResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_gateway_route_with_options_async(
        self,
        tmp_req: mse_20190531_models.AddGatewayRouteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddGatewayRouteResponse:
        """
        @summary Adds a gateway route.
        
        @param tmp_req: AddGatewayRouteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddGatewayRouteResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.AddGatewayRouteShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.direct_response_json):
            request.direct_response_jsonshrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.direct_response_json, 'DirectResponseJSON', 'json')
        if not UtilClient.is_unset(tmp_req.fallback_services):
            request.fallback_services_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.fallback_services, 'FallbackServices', 'json')
        if not UtilClient.is_unset(tmp_req.predicates):
            request.predicates_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.predicates, 'Predicates', 'json')
        if not UtilClient.is_unset(tmp_req.redirect_json):
            request.redirect_jsonshrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.redirect_json, 'RedirectJSON', 'json')
        if not UtilClient.is_unset(tmp_req.services):
            request.services_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.services, 'Services', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination_type):
            query['DestinationType'] = request.destination_type
        if not UtilClient.is_unset(request.direct_response_jsonshrink):
            query['DirectResponseJSON'] = request.direct_response_jsonshrink
        if not UtilClient.is_unset(request.domain_id):
            query['DomainId'] = request.domain_id
        if not UtilClient.is_unset(request.domain_id_list_json):
            query['DomainIdListJSON'] = request.domain_id_list_json
        if not UtilClient.is_unset(request.enable_waf):
            query['EnableWaf'] = request.enable_waf
        if not UtilClient.is_unset(request.fallback):
            query['Fallback'] = request.fallback
        if not UtilClient.is_unset(request.fallback_services_shrink):
            query['FallbackServices'] = request.fallback_services_shrink
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.policies):
            query['Policies'] = request.policies
        if not UtilClient.is_unset(request.predicates_shrink):
            query['Predicates'] = request.predicates_shrink
        if not UtilClient.is_unset(request.redirect_jsonshrink):
            query['RedirectJSON'] = request.redirect_jsonshrink
        if not UtilClient.is_unset(request.route_order):
            query['RouteOrder'] = request.route_order
        if not UtilClient.is_unset(request.route_type):
            query['RouteType'] = request.route_type
        if not UtilClient.is_unset(request.services_shrink):
            query['Services'] = request.services_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddGatewayRoute',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddGatewayRouteResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_gateway_route(
        self,
        request: mse_20190531_models.AddGatewayRouteRequest,
    ) -> mse_20190531_models.AddGatewayRouteResponse:
        """
        @summary Adds a gateway route.
        
        @param request: AddGatewayRouteRequest
        @return: AddGatewayRouteResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_gateway_route_with_options(request, runtime)

    async def add_gateway_route_async(
        self,
        request: mse_20190531_models.AddGatewayRouteRequest,
    ) -> mse_20190531_models.AddGatewayRouteResponse:
        """
        @summary Adds a gateway route.
        
        @param request: AddGatewayRouteRequest
        @return: AddGatewayRouteResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_gateway_route_with_options_async(request, runtime)

    def add_gateway_service_version_with_options(
        self,
        request: mse_20190531_models.AddGatewayServiceVersionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddGatewayServiceVersionResponse:
        """
        @summary Adds a service version.
        
        @param request: AddGatewayServiceVersionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddGatewayServiceVersionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        if not UtilClient.is_unset(request.service_version):
            query['ServiceVersion'] = request.service_version
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddGatewayServiceVersion',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddGatewayServiceVersionResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_gateway_service_version_with_options_async(
        self,
        request: mse_20190531_models.AddGatewayServiceVersionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddGatewayServiceVersionResponse:
        """
        @summary Adds a service version.
        
        @param request: AddGatewayServiceVersionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddGatewayServiceVersionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        if not UtilClient.is_unset(request.service_version):
            query['ServiceVersion'] = request.service_version
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddGatewayServiceVersion',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddGatewayServiceVersionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_gateway_service_version(
        self,
        request: mse_20190531_models.AddGatewayServiceVersionRequest,
    ) -> mse_20190531_models.AddGatewayServiceVersionResponse:
        """
        @summary Adds a service version.
        
        @param request: AddGatewayServiceVersionRequest
        @return: AddGatewayServiceVersionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_gateway_service_version_with_options(request, runtime)

    async def add_gateway_service_version_async(
        self,
        request: mse_20190531_models.AddGatewayServiceVersionRequest,
    ) -> mse_20190531_models.AddGatewayServiceVersionResponse:
        """
        @summary Adds a service version.
        
        @param request: AddGatewayServiceVersionRequest
        @return: AddGatewayServiceVersionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_gateway_service_version_with_options_async(request, runtime)

    def add_gateway_slb_with_options(
        self,
        tmp_req: mse_20190531_models.AddGatewaySlbRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddGatewaySlbResponse:
        """
        @summary Associates a Server Load Balancer (SLB) instance with a gateway.
        
        @param tmp_req: AddGatewaySlbRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddGatewaySlbResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.AddGatewaySlbShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.vservice_list):
            request.vservice_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.vservice_list, 'VServiceList', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.http_port):
            query['HttpPort'] = request.http_port
        if not UtilClient.is_unset(request.https_port):
            query['HttpsPort'] = request.https_port
        if not UtilClient.is_unset(request.https_vserver_group_id):
            query['HttpsVServerGroupId'] = request.https_vserver_group_id
        if not UtilClient.is_unset(request.service_weight):
            query['ServiceWeight'] = request.service_weight
        if not UtilClient.is_unset(request.slb_id):
            query['SlbId'] = request.slb_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.vserver_group_id):
            query['VServerGroupId'] = request.vserver_group_id
        if not UtilClient.is_unset(request.vservice_list_shrink):
            query['VServiceList'] = request.vservice_list_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddGatewaySlb',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddGatewaySlbResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_gateway_slb_with_options_async(
        self,
        tmp_req: mse_20190531_models.AddGatewaySlbRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddGatewaySlbResponse:
        """
        @summary Associates a Server Load Balancer (SLB) instance with a gateway.
        
        @param tmp_req: AddGatewaySlbRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddGatewaySlbResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.AddGatewaySlbShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.vservice_list):
            request.vservice_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.vservice_list, 'VServiceList', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.http_port):
            query['HttpPort'] = request.http_port
        if not UtilClient.is_unset(request.https_port):
            query['HttpsPort'] = request.https_port
        if not UtilClient.is_unset(request.https_vserver_group_id):
            query['HttpsVServerGroupId'] = request.https_vserver_group_id
        if not UtilClient.is_unset(request.service_weight):
            query['ServiceWeight'] = request.service_weight
        if not UtilClient.is_unset(request.slb_id):
            query['SlbId'] = request.slb_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.vserver_group_id):
            query['VServerGroupId'] = request.vserver_group_id
        if not UtilClient.is_unset(request.vservice_list_shrink):
            query['VServiceList'] = request.vservice_list_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddGatewaySlb',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddGatewaySlbResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_gateway_slb(
        self,
        request: mse_20190531_models.AddGatewaySlbRequest,
    ) -> mse_20190531_models.AddGatewaySlbResponse:
        """
        @summary Associates a Server Load Balancer (SLB) instance with a gateway.
        
        @param request: AddGatewaySlbRequest
        @return: AddGatewaySlbResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_gateway_slb_with_options(request, runtime)

    async def add_gateway_slb_async(
        self,
        request: mse_20190531_models.AddGatewaySlbRequest,
    ) -> mse_20190531_models.AddGatewaySlbResponse:
        """
        @summary Associates a Server Load Balancer (SLB) instance with a gateway.
        
        @param request: AddGatewaySlbRequest
        @return: AddGatewaySlbResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_gateway_slb_with_options_async(request, runtime)

    def add_migration_task_with_options(
        self,
        request: mse_20190531_models.AddMigrationTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddMigrationTaskResponse:
        """
        @summary Create a new migration task
        
        @param request: AddMigrationTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddMigrationTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_type):
            query['ClusterType'] = request.cluster_type
        if not UtilClient.is_unset(request.origin_instance_address):
            query['OriginInstanceAddress'] = request.origin_instance_address
        if not UtilClient.is_unset(request.origin_instance_name):
            query['OriginInstanceName'] = request.origin_instance_name
        if not UtilClient.is_unset(request.origin_instance_namespace):
            query['OriginInstanceNamespace'] = request.origin_instance_namespace
        if not UtilClient.is_unset(request.project_desc):
            query['ProjectDesc'] = request.project_desc
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.sync_type):
            query['SyncType'] = request.sync_type
        if not UtilClient.is_unset(request.target_cluster_name):
            query['TargetClusterName'] = request.target_cluster_name
        if not UtilClient.is_unset(request.target_cluster_url):
            query['TargetClusterUrl'] = request.target_cluster_url
        if not UtilClient.is_unset(request.target_instance_id):
            query['TargetInstanceId'] = request.target_instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddMigrationTask',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddMigrationTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_migration_task_with_options_async(
        self,
        request: mse_20190531_models.AddMigrationTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddMigrationTaskResponse:
        """
        @summary Create a new migration task
        
        @param request: AddMigrationTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddMigrationTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_type):
            query['ClusterType'] = request.cluster_type
        if not UtilClient.is_unset(request.origin_instance_address):
            query['OriginInstanceAddress'] = request.origin_instance_address
        if not UtilClient.is_unset(request.origin_instance_name):
            query['OriginInstanceName'] = request.origin_instance_name
        if not UtilClient.is_unset(request.origin_instance_namespace):
            query['OriginInstanceNamespace'] = request.origin_instance_namespace
        if not UtilClient.is_unset(request.project_desc):
            query['ProjectDesc'] = request.project_desc
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.sync_type):
            query['SyncType'] = request.sync_type
        if not UtilClient.is_unset(request.target_cluster_name):
            query['TargetClusterName'] = request.target_cluster_name
        if not UtilClient.is_unset(request.target_cluster_url):
            query['TargetClusterUrl'] = request.target_cluster_url
        if not UtilClient.is_unset(request.target_instance_id):
            query['TargetInstanceId'] = request.target_instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddMigrationTask',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddMigrationTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_migration_task(
        self,
        request: mse_20190531_models.AddMigrationTaskRequest,
    ) -> mse_20190531_models.AddMigrationTaskResponse:
        """
        @summary Create a new migration task
        
        @param request: AddMigrationTaskRequest
        @return: AddMigrationTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_migration_task_with_options(request, runtime)

    async def add_migration_task_async(
        self,
        request: mse_20190531_models.AddMigrationTaskRequest,
    ) -> mse_20190531_models.AddMigrationTaskResponse:
        """
        @summary Create a new migration task
        
        @param request: AddMigrationTaskRequest
        @return: AddMigrationTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_migration_task_with_options_async(request, runtime)

    def add_mock_rule_with_options(
        self,
        request: mse_20190531_models.AddMockRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddMockRuleResponse:
        """
        @summary Creates a mock rule.
        
        @param request: AddMockRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddMockRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.consumer_app_ids):
            query['ConsumerAppIds'] = request.consumer_app_ids
        if not UtilClient.is_unset(request.dubbo_mock_items):
            query['DubboMockItems'] = request.dubbo_mock_items
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.extra_json):
            query['ExtraJson'] = request.extra_json
        if not UtilClient.is_unset(request.mock_type):
            query['MockType'] = request.mock_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.provider_app_id):
            query['ProviderAppId'] = request.provider_app_id
        if not UtilClient.is_unset(request.provider_app_name):
            query['ProviderAppName'] = request.provider_app_name
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.sc_mock_items):
            query['ScMockItems'] = request.sc_mock_items
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddMockRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddMockRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_mock_rule_with_options_async(
        self,
        request: mse_20190531_models.AddMockRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddMockRuleResponse:
        """
        @summary Creates a mock rule.
        
        @param request: AddMockRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddMockRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.consumer_app_ids):
            query['ConsumerAppIds'] = request.consumer_app_ids
        if not UtilClient.is_unset(request.dubbo_mock_items):
            query['DubboMockItems'] = request.dubbo_mock_items
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.extra_json):
            query['ExtraJson'] = request.extra_json
        if not UtilClient.is_unset(request.mock_type):
            query['MockType'] = request.mock_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.provider_app_id):
            query['ProviderAppId'] = request.provider_app_id
        if not UtilClient.is_unset(request.provider_app_name):
            query['ProviderAppName'] = request.provider_app_name
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.sc_mock_items):
            query['ScMockItems'] = request.sc_mock_items
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddMockRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddMockRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_mock_rule(
        self,
        request: mse_20190531_models.AddMockRuleRequest,
    ) -> mse_20190531_models.AddMockRuleResponse:
        """
        @summary Creates a mock rule.
        
        @param request: AddMockRuleRequest
        @return: AddMockRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_mock_rule_with_options(request, runtime)

    async def add_mock_rule_async(
        self,
        request: mse_20190531_models.AddMockRuleRequest,
    ) -> mse_20190531_models.AddMockRuleResponse:
        """
        @summary Creates a mock rule.
        
        @param request: AddMockRuleRequest
        @return: AddMockRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_mock_rule_with_options_async(request, runtime)

    def add_sslcert_with_options(
        self,
        request: mse_20190531_models.AddSSLCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddSSLCertResponse:
        """
        @summary Associates a certificate with a domain name of a gateway. You can specify a certificate that is hosted in Alibaba Cloud Security.
        
        @param request: AddSSLCertRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddSSLCertResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cert_identifier):
            query['CertIdentifier'] = request.cert_identifier
        if not UtilClient.is_unset(request.domain_id):
            query['DomainId'] = request.domain_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddSSLCert',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddSSLCertResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_sslcert_with_options_async(
        self,
        request: mse_20190531_models.AddSSLCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddSSLCertResponse:
        """
        @summary Associates a certificate with a domain name of a gateway. You can specify a certificate that is hosted in Alibaba Cloud Security.
        
        @param request: AddSSLCertRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddSSLCertResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cert_identifier):
            query['CertIdentifier'] = request.cert_identifier
        if not UtilClient.is_unset(request.domain_id):
            query['DomainId'] = request.domain_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddSSLCert',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddSSLCertResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_sslcert(
        self,
        request: mse_20190531_models.AddSSLCertRequest,
    ) -> mse_20190531_models.AddSSLCertResponse:
        """
        @summary Associates a certificate with a domain name of a gateway. You can specify a certificate that is hosted in Alibaba Cloud Security.
        
        @param request: AddSSLCertRequest
        @return: AddSSLCertResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_sslcert_with_options(request, runtime)

    async def add_sslcert_async(
        self,
        request: mse_20190531_models.AddSSLCertRequest,
    ) -> mse_20190531_models.AddSSLCertResponse:
        """
        @summary Associates a certificate with a domain name of a gateway. You can specify a certificate that is hosted in Alibaba Cloud Security.
        
        @param request: AddSSLCertRequest
        @return: AddSSLCertResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_sslcert_with_options_async(request, runtime)

    def add_security_group_rule_with_options(
        self,
        request: mse_20190531_models.AddSecurityGroupRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddSecurityGroupRuleResponse:
        """
        @summary Creates a security group rule for a gateway.
        
        @param request: AddSecurityGroupRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddSecurityGroupRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.port_range):
            query['PortRange'] = request.port_range
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddSecurityGroupRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddSecurityGroupRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_security_group_rule_with_options_async(
        self,
        request: mse_20190531_models.AddSecurityGroupRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddSecurityGroupRuleResponse:
        """
        @summary Creates a security group rule for a gateway.
        
        @param request: AddSecurityGroupRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddSecurityGroupRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.port_range):
            query['PortRange'] = request.port_range
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddSecurityGroupRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddSecurityGroupRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_security_group_rule(
        self,
        request: mse_20190531_models.AddSecurityGroupRuleRequest,
    ) -> mse_20190531_models.AddSecurityGroupRuleResponse:
        """
        @summary Creates a security group rule for a gateway.
        
        @param request: AddSecurityGroupRuleRequest
        @return: AddSecurityGroupRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_security_group_rule_with_options(request, runtime)

    async def add_security_group_rule_async(
        self,
        request: mse_20190531_models.AddSecurityGroupRuleRequest,
    ) -> mse_20190531_models.AddSecurityGroupRuleResponse:
        """
        @summary Creates a security group rule for a gateway.
        
        @param request: AddSecurityGroupRuleRequest
        @return: AddSecurityGroupRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_security_group_rule_with_options_async(request, runtime)

    def add_service_source_with_options(
        self,
        tmp_req: mse_20190531_models.AddServiceSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddServiceSourceResponse:
        """
        @summary Adds a Nacos service source.
        
        @param tmp_req: AddServiceSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddServiceSourceResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.AddServiceSourceShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.group_list):
            request.group_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.group_list, 'GroupList', 'json')
        if not UtilClient.is_unset(tmp_req.ingress_options_request):
            request.ingress_options_request_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.ingress_options_request, 'IngressOptionsRequest', 'json')
        if not UtilClient.is_unset(tmp_req.path_list):
            request.path_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.path_list, 'PathList', 'json')
        if not UtilClient.is_unset(tmp_req.to_authorize_security_groups):
            request.to_authorize_security_groups_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.to_authorize_security_groups, 'ToAuthorizeSecurityGroups', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.address):
            query['Address'] = request.address
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.group_list_shrink):
            query['GroupList'] = request.group_list_shrink
        if not UtilClient.is_unset(request.ingress_options_request_shrink):
            query['IngressOptionsRequest'] = request.ingress_options_request_shrink
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.path_list_shrink):
            query['PathList'] = request.path_list_shrink
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.to_authorize_security_groups_shrink):
            query['ToAuthorizeSecurityGroups'] = request.to_authorize_security_groups_shrink
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddServiceSource',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddServiceSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_service_source_with_options_async(
        self,
        tmp_req: mse_20190531_models.AddServiceSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.AddServiceSourceResponse:
        """
        @summary Adds a Nacos service source.
        
        @param tmp_req: AddServiceSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddServiceSourceResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.AddServiceSourceShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.group_list):
            request.group_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.group_list, 'GroupList', 'json')
        if not UtilClient.is_unset(tmp_req.ingress_options_request):
            request.ingress_options_request_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.ingress_options_request, 'IngressOptionsRequest', 'json')
        if not UtilClient.is_unset(tmp_req.path_list):
            request.path_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.path_list, 'PathList', 'json')
        if not UtilClient.is_unset(tmp_req.to_authorize_security_groups):
            request.to_authorize_security_groups_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.to_authorize_security_groups, 'ToAuthorizeSecurityGroups', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.address):
            query['Address'] = request.address
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.group_list_shrink):
            query['GroupList'] = request.group_list_shrink
        if not UtilClient.is_unset(request.ingress_options_request_shrink):
            query['IngressOptionsRequest'] = request.ingress_options_request_shrink
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.path_list_shrink):
            query['PathList'] = request.path_list_shrink
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.to_authorize_security_groups_shrink):
            query['ToAuthorizeSecurityGroups'] = request.to_authorize_security_groups_shrink
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddServiceSource',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.AddServiceSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_service_source(
        self,
        request: mse_20190531_models.AddServiceSourceRequest,
    ) -> mse_20190531_models.AddServiceSourceResponse:
        """
        @summary Adds a Nacos service source.
        
        @param request: AddServiceSourceRequest
        @return: AddServiceSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_service_source_with_options(request, runtime)

    async def add_service_source_async(
        self,
        request: mse_20190531_models.AddServiceSourceRequest,
    ) -> mse_20190531_models.AddServiceSourceResponse:
        """
        @summary Adds a Nacos service source.
        
        @param request: AddServiceSourceRequest
        @return: AddServiceSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_service_source_with_options_async(request, runtime)

    def apply_gateway_route_with_options(
        self,
        request: mse_20190531_models.ApplyGatewayRouteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ApplyGatewayRouteResponse:
        """
        @summary Publishes a route for a gateway.
        
        @param request: ApplyGatewayRouteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ApplyGatewayRouteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.route_id):
            query['RouteId'] = request.route_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ApplyGatewayRoute',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ApplyGatewayRouteResponse(),
            self.call_api(params, req, runtime)
        )

    async def apply_gateway_route_with_options_async(
        self,
        request: mse_20190531_models.ApplyGatewayRouteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ApplyGatewayRouteResponse:
        """
        @summary Publishes a route for a gateway.
        
        @param request: ApplyGatewayRouteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ApplyGatewayRouteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.route_id):
            query['RouteId'] = request.route_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ApplyGatewayRoute',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ApplyGatewayRouteResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def apply_gateway_route(
        self,
        request: mse_20190531_models.ApplyGatewayRouteRequest,
    ) -> mse_20190531_models.ApplyGatewayRouteResponse:
        """
        @summary Publishes a route for a gateway.
        
        @param request: ApplyGatewayRouteRequest
        @return: ApplyGatewayRouteResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.apply_gateway_route_with_options(request, runtime)

    async def apply_gateway_route_async(
        self,
        request: mse_20190531_models.ApplyGatewayRouteRequest,
    ) -> mse_20190531_models.ApplyGatewayRouteResponse:
        """
        @summary Publishes a route for a gateway.
        
        @param request: ApplyGatewayRouteRequest
        @return: ApplyGatewayRouteResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.apply_gateway_route_with_options_async(request, runtime)

    def apply_tag_policies_with_options(
        self,
        tmp_req: mse_20190531_models.ApplyTagPoliciesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ApplyTagPoliciesResponse:
        """
        @summary Modifies a tag-based routing rule.
        
        @param tmp_req: ApplyTagPoliciesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ApplyTagPoliciesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.ApplyTagPoliciesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.rules):
            request.rules_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.rules, 'Rules', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.rules_shrink):
            query['Rules'] = request.rules_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ApplyTagPolicies',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ApplyTagPoliciesResponse(),
            self.call_api(params, req, runtime)
        )

    async def apply_tag_policies_with_options_async(
        self,
        tmp_req: mse_20190531_models.ApplyTagPoliciesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ApplyTagPoliciesResponse:
        """
        @summary Modifies a tag-based routing rule.
        
        @param tmp_req: ApplyTagPoliciesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ApplyTagPoliciesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.ApplyTagPoliciesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.rules):
            request.rules_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.rules, 'Rules', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.rules_shrink):
            query['Rules'] = request.rules_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ApplyTagPolicies',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ApplyTagPoliciesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def apply_tag_policies(
        self,
        request: mse_20190531_models.ApplyTagPoliciesRequest,
    ) -> mse_20190531_models.ApplyTagPoliciesResponse:
        """
        @summary Modifies a tag-based routing rule.
        
        @param request: ApplyTagPoliciesRequest
        @return: ApplyTagPoliciesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.apply_tag_policies_with_options(request, runtime)

    async def apply_tag_policies_async(
        self,
        request: mse_20190531_models.ApplyTagPoliciesRequest,
    ) -> mse_20190531_models.ApplyTagPoliciesResponse:
        """
        @summary Modifies a tag-based routing rule.
        
        @param request: ApplyTagPoliciesRequest
        @return: ApplyTagPoliciesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.apply_tag_policies_with_options_async(request, runtime)

    def bind_sentinel_block_fallback_definition_with_options(
        self,
        request: mse_20190531_models.BindSentinelBlockFallbackDefinitionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.BindSentinelBlockFallbackDefinitionResponse:
        """
        @summary Binds traffic protection behavior.
        
        @param request: BindSentinelBlockFallbackDefinitionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BindSentinelBlockFallbackDefinitionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.fallback_id):
            query['FallbackId'] = request.fallback_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BindSentinelBlockFallbackDefinition',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.BindSentinelBlockFallbackDefinitionResponse(),
            self.call_api(params, req, runtime)
        )

    async def bind_sentinel_block_fallback_definition_with_options_async(
        self,
        request: mse_20190531_models.BindSentinelBlockFallbackDefinitionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.BindSentinelBlockFallbackDefinitionResponse:
        """
        @summary Binds traffic protection behavior.
        
        @param request: BindSentinelBlockFallbackDefinitionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BindSentinelBlockFallbackDefinitionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.fallback_id):
            query['FallbackId'] = request.fallback_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BindSentinelBlockFallbackDefinition',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.BindSentinelBlockFallbackDefinitionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def bind_sentinel_block_fallback_definition(
        self,
        request: mse_20190531_models.BindSentinelBlockFallbackDefinitionRequest,
    ) -> mse_20190531_models.BindSentinelBlockFallbackDefinitionResponse:
        """
        @summary Binds traffic protection behavior.
        
        @param request: BindSentinelBlockFallbackDefinitionRequest
        @return: BindSentinelBlockFallbackDefinitionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.bind_sentinel_block_fallback_definition_with_options(request, runtime)

    async def bind_sentinel_block_fallback_definition_async(
        self,
        request: mse_20190531_models.BindSentinelBlockFallbackDefinitionRequest,
    ) -> mse_20190531_models.BindSentinelBlockFallbackDefinitionResponse:
        """
        @summary Binds traffic protection behavior.
        
        @param request: BindSentinelBlockFallbackDefinitionRequest
        @return: BindSentinelBlockFallbackDefinitionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.bind_sentinel_block_fallback_definition_with_options_async(request, runtime)

    def change_resource_group_with_options(
        self,
        request: mse_20190531_models.ChangeResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ChangeResourceGroupResponse:
        """
        @summary Resource Transfer
        
        @param request: ChangeResourceGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ChangeResourceGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_region_id):
            query['ResourceRegionId'] = request.resource_region_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ChangeResourceGroup',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ChangeResourceGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def change_resource_group_with_options_async(
        self,
        request: mse_20190531_models.ChangeResourceGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ChangeResourceGroupResponse:
        """
        @summary Resource Transfer
        
        @param request: ChangeResourceGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ChangeResourceGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_region_id):
            query['ResourceRegionId'] = request.resource_region_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ChangeResourceGroup',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ChangeResourceGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def change_resource_group(
        self,
        request: mse_20190531_models.ChangeResourceGroupRequest,
    ) -> mse_20190531_models.ChangeResourceGroupResponse:
        """
        @summary Resource Transfer
        
        @param request: ChangeResourceGroupRequest
        @return: ChangeResourceGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.change_resource_group_with_options(request, runtime)

    async def change_resource_group_async(
        self,
        request: mse_20190531_models.ChangeResourceGroupRequest,
    ) -> mse_20190531_models.ChangeResourceGroupResponse:
        """
        @summary Resource Transfer
        
        @param request: ChangeResourceGroupRequest
        @return: ChangeResourceGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.change_resource_group_with_options_async(request, runtime)

    def clone_nacos_config_with_options(
        self,
        request: mse_20190531_models.CloneNacosConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CloneNacosConfigResponse:
        """
        @summary Copy Nacos Configuration
        
        @description > This OpenAPI is not the Nacos-SDK API. For information related to the Nacos-SDK API, please refer to the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: CloneNacosConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CloneNacosConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.data_ids):
            query['DataIds'] = request.data_ids
        if not UtilClient.is_unset(request.ids):
            query['Ids'] = request.ids
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.origin_namespace_id):
            query['OriginNamespaceId'] = request.origin_namespace_id
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.target_namespace_id):
            query['TargetNamespaceId'] = request.target_namespace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CloneNacosConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CloneNacosConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def clone_nacos_config_with_options_async(
        self,
        request: mse_20190531_models.CloneNacosConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CloneNacosConfigResponse:
        """
        @summary Copy Nacos Configuration
        
        @description > This OpenAPI is not the Nacos-SDK API. For information related to the Nacos-SDK API, please refer to the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: CloneNacosConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CloneNacosConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.data_ids):
            query['DataIds'] = request.data_ids
        if not UtilClient.is_unset(request.ids):
            query['Ids'] = request.ids
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.origin_namespace_id):
            query['OriginNamespaceId'] = request.origin_namespace_id
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.target_namespace_id):
            query['TargetNamespaceId'] = request.target_namespace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CloneNacosConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CloneNacosConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def clone_nacos_config(
        self,
        request: mse_20190531_models.CloneNacosConfigRequest,
    ) -> mse_20190531_models.CloneNacosConfigResponse:
        """
        @summary Copy Nacos Configuration
        
        @description > This OpenAPI is not the Nacos-SDK API. For information related to the Nacos-SDK API, please refer to the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: CloneNacosConfigRequest
        @return: CloneNacosConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.clone_nacos_config_with_options(request, runtime)

    async def clone_nacos_config_async(
        self,
        request: mse_20190531_models.CloneNacosConfigRequest,
    ) -> mse_20190531_models.CloneNacosConfigResponse:
        """
        @summary Copy Nacos Configuration
        
        @description > This OpenAPI is not the Nacos-SDK API. For information related to the Nacos-SDK API, please refer to the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: CloneNacosConfigRequest
        @return: CloneNacosConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.clone_nacos_config_with_options_async(request, runtime)

    def clone_sentinel_rule_from_ahas_with_options(
        self,
        request: mse_20190531_models.CloneSentinelRuleFromAhasRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CloneSentinelRuleFromAhasResponse:
        """
        @summary Clones rules from Application High Availability Service.
        
        @param request: CloneSentinelRuleFromAhasRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CloneSentinelRuleFromAhasResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.ahas_namespace):
            query['AhasNamespace'] = request.ahas_namespace
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.is_ahaspublic_region):
            query['IsAHASPublicRegion'] = request.is_ahaspublic_region
        if not UtilClient.is_unset(request.mse_app_name):
            query['MseAppName'] = request.mse_app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CloneSentinelRuleFromAhas',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CloneSentinelRuleFromAhasResponse(),
            self.call_api(params, req, runtime)
        )

    async def clone_sentinel_rule_from_ahas_with_options_async(
        self,
        request: mse_20190531_models.CloneSentinelRuleFromAhasRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CloneSentinelRuleFromAhasResponse:
        """
        @summary Clones rules from Application High Availability Service.
        
        @param request: CloneSentinelRuleFromAhasRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CloneSentinelRuleFromAhasResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.ahas_namespace):
            query['AhasNamespace'] = request.ahas_namespace
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.is_ahaspublic_region):
            query['IsAHASPublicRegion'] = request.is_ahaspublic_region
        if not UtilClient.is_unset(request.mse_app_name):
            query['MseAppName'] = request.mse_app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CloneSentinelRuleFromAhas',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CloneSentinelRuleFromAhasResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def clone_sentinel_rule_from_ahas(
        self,
        request: mse_20190531_models.CloneSentinelRuleFromAhasRequest,
    ) -> mse_20190531_models.CloneSentinelRuleFromAhasResponse:
        """
        @summary Clones rules from Application High Availability Service.
        
        @param request: CloneSentinelRuleFromAhasRequest
        @return: CloneSentinelRuleFromAhasResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.clone_sentinel_rule_from_ahas_with_options(request, runtime)

    async def clone_sentinel_rule_from_ahas_async(
        self,
        request: mse_20190531_models.CloneSentinelRuleFromAhasRequest,
    ) -> mse_20190531_models.CloneSentinelRuleFromAhasResponse:
        """
        @summary Clones rules from Application High Availability Service.
        
        @param request: CloneSentinelRuleFromAhasRequest
        @return: CloneSentinelRuleFromAhasResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.clone_sentinel_rule_from_ahas_with_options_async(request, runtime)

    def create_application_with_options(
        self,
        tmp_req: mse_20190531_models.CreateApplicationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateApplicationResponse:
        """
        @summary Creates an application.
        
        @param tmp_req: CreateApplicationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateApplicationResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.CreateApplicationShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.tags):
            request.tags_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.tags, 'Tags', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.language):
            query['Language'] = request.language
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.sentinel_enable):
            query['SentinelEnable'] = request.sentinel_enable
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.switch_enable):
            query['SwitchEnable'] = request.switch_enable
        if not UtilClient.is_unset(request.tags_shrink):
            query['Tags'] = request.tags_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateApplication',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateApplicationResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_application_with_options_async(
        self,
        tmp_req: mse_20190531_models.CreateApplicationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateApplicationResponse:
        """
        @summary Creates an application.
        
        @param tmp_req: CreateApplicationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateApplicationResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.CreateApplicationShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.tags):
            request.tags_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.tags, 'Tags', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.language):
            query['Language'] = request.language
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.sentinel_enable):
            query['SentinelEnable'] = request.sentinel_enable
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.switch_enable):
            query['SwitchEnable'] = request.switch_enable
        if not UtilClient.is_unset(request.tags_shrink):
            query['Tags'] = request.tags_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateApplication',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateApplicationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_application(
        self,
        request: mse_20190531_models.CreateApplicationRequest,
    ) -> mse_20190531_models.CreateApplicationResponse:
        """
        @summary Creates an application.
        
        @param request: CreateApplicationRequest
        @return: CreateApplicationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_application_with_options(request, runtime)

    async def create_application_async(
        self,
        request: mse_20190531_models.CreateApplicationRequest,
    ) -> mse_20190531_models.CreateApplicationResponse:
        """
        @summary Creates an application.
        
        @param request: CreateApplicationRequest
        @return: CreateApplicationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_application_with_options_async(request, runtime)

    def create_circuit_breaker_rule_with_options(
        self,
        request: mse_20190531_models.CreateCircuitBreakerRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateCircuitBreakerRuleResponse:
        """
        @summary Creates a circuit breaking rule.
        
        @param request: CreateCircuitBreakerRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCircuitBreakerRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.half_open_base_amount_per_step):
            query['HalfOpenBaseAmountPerStep'] = request.half_open_base_amount_per_step
        if not UtilClient.is_unset(request.half_open_recovery_step_num):
            query['HalfOpenRecoveryStepNum'] = request.half_open_recovery_step_num
        if not UtilClient.is_unset(request.max_allowed_rt_ms):
            query['MaxAllowedRtMs'] = request.max_allowed_rt_ms
        if not UtilClient.is_unset(request.min_request_amount):
            query['MinRequestAmount'] = request.min_request_amount
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.retry_timeout_ms):
            query['RetryTimeoutMs'] = request.retry_timeout_ms
        if not UtilClient.is_unset(request.stat_interval_ms):
            query['StatIntervalMs'] = request.stat_interval_ms
        if not UtilClient.is_unset(request.strategy):
            query['Strategy'] = request.strategy
        if not UtilClient.is_unset(request.threshold):
            query['Threshold'] = request.threshold
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCircuitBreakerRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateCircuitBreakerRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_circuit_breaker_rule_with_options_async(
        self,
        request: mse_20190531_models.CreateCircuitBreakerRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateCircuitBreakerRuleResponse:
        """
        @summary Creates a circuit breaking rule.
        
        @param request: CreateCircuitBreakerRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCircuitBreakerRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.half_open_base_amount_per_step):
            query['HalfOpenBaseAmountPerStep'] = request.half_open_base_amount_per_step
        if not UtilClient.is_unset(request.half_open_recovery_step_num):
            query['HalfOpenRecoveryStepNum'] = request.half_open_recovery_step_num
        if not UtilClient.is_unset(request.max_allowed_rt_ms):
            query['MaxAllowedRtMs'] = request.max_allowed_rt_ms
        if not UtilClient.is_unset(request.min_request_amount):
            query['MinRequestAmount'] = request.min_request_amount
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.retry_timeout_ms):
            query['RetryTimeoutMs'] = request.retry_timeout_ms
        if not UtilClient.is_unset(request.stat_interval_ms):
            query['StatIntervalMs'] = request.stat_interval_ms
        if not UtilClient.is_unset(request.strategy):
            query['Strategy'] = request.strategy
        if not UtilClient.is_unset(request.threshold):
            query['Threshold'] = request.threshold
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCircuitBreakerRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateCircuitBreakerRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_circuit_breaker_rule(
        self,
        request: mse_20190531_models.CreateCircuitBreakerRuleRequest,
    ) -> mse_20190531_models.CreateCircuitBreakerRuleResponse:
        """
        @summary Creates a circuit breaking rule.
        
        @param request: CreateCircuitBreakerRuleRequest
        @return: CreateCircuitBreakerRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_circuit_breaker_rule_with_options(request, runtime)

    async def create_circuit_breaker_rule_async(
        self,
        request: mse_20190531_models.CreateCircuitBreakerRuleRequest,
    ) -> mse_20190531_models.CreateCircuitBreakerRuleResponse:
        """
        @summary Creates a circuit breaking rule.
        
        @param request: CreateCircuitBreakerRuleRequest
        @return: CreateCircuitBreakerRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_circuit_breaker_rule_with_options_async(request, runtime)

    def create_cluster_with_options(
        self,
        request: mse_20190531_models.CreateClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateClusterResponse:
        """
        @summary Create an MSE registration and configuration center instance
        
        @description Please ensure that you fully understand the billing method and pricing of the MSE (Microservice Engine) product before using this interface.
        
        @param request: CreateClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.cluster_specification):
            query['ClusterSpecification'] = request.cluster_specification
        if not UtilClient.is_unset(request.cluster_type):
            query['ClusterType'] = request.cluster_type
        if not UtilClient.is_unset(request.cluster_version):
            query['ClusterVersion'] = request.cluster_version
        if not UtilClient.is_unset(request.connection_type):
            query['ConnectionType'] = request.connection_type
        if not UtilClient.is_unset(request.disk_type):
            query['DiskType'] = request.disk_type
        if not UtilClient.is_unset(request.eip_enabled):
            query['EipEnabled'] = request.eip_enabled
        if not UtilClient.is_unset(request.instance_count):
            query['InstanceCount'] = request.instance_count
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.mse_version):
            query['MseVersion'] = request.mse_version
        if not UtilClient.is_unset(request.net_type):
            query['NetType'] = request.net_type
        if not UtilClient.is_unset(request.private_slb_specification):
            query['PrivateSlbSpecification'] = request.private_slb_specification
        if not UtilClient.is_unset(request.pub_network_flow):
            query['PubNetworkFlow'] = request.pub_network_flow
        if not UtilClient.is_unset(request.pub_slb_specification):
            query['PubSlbSpecification'] = request.pub_slb_specification
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.security_group_type):
            query['SecurityGroupType'] = request.security_group_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCluster',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_cluster_with_options_async(
        self,
        request: mse_20190531_models.CreateClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateClusterResponse:
        """
        @summary Create an MSE registration and configuration center instance
        
        @description Please ensure that you fully understand the billing method and pricing of the MSE (Microservice Engine) product before using this interface.
        
        @param request: CreateClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.cluster_specification):
            query['ClusterSpecification'] = request.cluster_specification
        if not UtilClient.is_unset(request.cluster_type):
            query['ClusterType'] = request.cluster_type
        if not UtilClient.is_unset(request.cluster_version):
            query['ClusterVersion'] = request.cluster_version
        if not UtilClient.is_unset(request.connection_type):
            query['ConnectionType'] = request.connection_type
        if not UtilClient.is_unset(request.disk_type):
            query['DiskType'] = request.disk_type
        if not UtilClient.is_unset(request.eip_enabled):
            query['EipEnabled'] = request.eip_enabled
        if not UtilClient.is_unset(request.instance_count):
            query['InstanceCount'] = request.instance_count
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.mse_version):
            query['MseVersion'] = request.mse_version
        if not UtilClient.is_unset(request.net_type):
            query['NetType'] = request.net_type
        if not UtilClient.is_unset(request.private_slb_specification):
            query['PrivateSlbSpecification'] = request.private_slb_specification
        if not UtilClient.is_unset(request.pub_network_flow):
            query['PubNetworkFlow'] = request.pub_network_flow
        if not UtilClient.is_unset(request.pub_slb_specification):
            query['PubSlbSpecification'] = request.pub_slb_specification
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.security_group_type):
            query['SecurityGroupType'] = request.security_group_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCluster',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_cluster(
        self,
        request: mse_20190531_models.CreateClusterRequest,
    ) -> mse_20190531_models.CreateClusterResponse:
        """
        @summary Create an MSE registration and configuration center instance
        
        @description Please ensure that you fully understand the billing method and pricing of the MSE (Microservice Engine) product before using this interface.
        
        @param request: CreateClusterRequest
        @return: CreateClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_cluster_with_options(request, runtime)

    async def create_cluster_async(
        self,
        request: mse_20190531_models.CreateClusterRequest,
    ) -> mse_20190531_models.CreateClusterResponse:
        """
        @summary Create an MSE registration and configuration center instance
        
        @description Please ensure that you fully understand the billing method and pricing of the MSE (Microservice Engine) product before using this interface.
        
        @param request: CreateClusterRequest
        @return: CreateClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_cluster_with_options_async(request, runtime)

    def create_engine_namespace_with_options(
        self,
        request: mse_20190531_models.CreateEngineNamespaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateEngineNamespaceResponse:
        """
        @summary Creates a namespace in a Nacos instance.
        
        @param request: CreateEngineNamespaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateEngineNamespaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.desc):
            query['Desc'] = request.desc
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.service_count):
            query['ServiceCount'] = request.service_count
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateEngineNamespace',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateEngineNamespaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_engine_namespace_with_options_async(
        self,
        request: mse_20190531_models.CreateEngineNamespaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateEngineNamespaceResponse:
        """
        @summary Creates a namespace in a Nacos instance.
        
        @param request: CreateEngineNamespaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateEngineNamespaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.desc):
            query['Desc'] = request.desc
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.service_count):
            query['ServiceCount'] = request.service_count
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateEngineNamespace',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateEngineNamespaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_engine_namespace(
        self,
        request: mse_20190531_models.CreateEngineNamespaceRequest,
    ) -> mse_20190531_models.CreateEngineNamespaceResponse:
        """
        @summary Creates a namespace in a Nacos instance.
        
        @param request: CreateEngineNamespaceRequest
        @return: CreateEngineNamespaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_engine_namespace_with_options(request, runtime)

    async def create_engine_namespace_async(
        self,
        request: mse_20190531_models.CreateEngineNamespaceRequest,
    ) -> mse_20190531_models.CreateEngineNamespaceResponse:
        """
        @summary Creates a namespace in a Nacos instance.
        
        @param request: CreateEngineNamespaceRequest
        @return: CreateEngineNamespaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_engine_namespace_with_options_async(request, runtime)

    def create_flow_rule_with_options(
        self,
        request: mse_20190531_models.CreateFlowRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateFlowRuleResponse:
        """
        @summary Creates a throttling rule.
        
        @param request: CreateFlowRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFlowRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.control_behavior):
            query['ControlBehavior'] = request.control_behavior
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.limit_app):
            query['LimitApp'] = request.limit_app
        if not UtilClient.is_unset(request.max_queueing_time_ms):
            query['MaxQueueingTimeMs'] = request.max_queueing_time_ms
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.threshold):
            query['Threshold'] = request.threshold
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFlowRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateFlowRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_flow_rule_with_options_async(
        self,
        request: mse_20190531_models.CreateFlowRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateFlowRuleResponse:
        """
        @summary Creates a throttling rule.
        
        @param request: CreateFlowRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFlowRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.control_behavior):
            query['ControlBehavior'] = request.control_behavior
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.limit_app):
            query['LimitApp'] = request.limit_app
        if not UtilClient.is_unset(request.max_queueing_time_ms):
            query['MaxQueueingTimeMs'] = request.max_queueing_time_ms
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.threshold):
            query['Threshold'] = request.threshold
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFlowRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateFlowRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_flow_rule(
        self,
        request: mse_20190531_models.CreateFlowRuleRequest,
    ) -> mse_20190531_models.CreateFlowRuleResponse:
        """
        @summary Creates a throttling rule.
        
        @param request: CreateFlowRuleRequest
        @return: CreateFlowRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_flow_rule_with_options(request, runtime)

    async def create_flow_rule_async(
        self,
        request: mse_20190531_models.CreateFlowRuleRequest,
    ) -> mse_20190531_models.CreateFlowRuleResponse:
        """
        @summary Creates a throttling rule.
        
        @param request: CreateFlowRuleRequest
        @return: CreateFlowRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_flow_rule_with_options_async(request, runtime)

    def create_gateway_circuit_breaker_rule_with_options(
        self,
        request: mse_20190531_models.CreateGatewayCircuitBreakerRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateGatewayCircuitBreakerRuleResponse:
        """
        @summary 创建网关路由熔断规则
        
        @param request: CreateGatewayCircuitBreakerRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateGatewayCircuitBreakerRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.behavior_type):
            query['BehaviorType'] = request.behavior_type
        if not UtilClient.is_unset(request.body_encoding):
            query['BodyEncoding'] = request.body_encoding
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.max_allowed_ms):
            query['MaxAllowedMs'] = request.max_allowed_ms
        if not UtilClient.is_unset(request.min_request_amount):
            query['MinRequestAmount'] = request.min_request_amount
        if not UtilClient.is_unset(request.recovery_timeout_sec):
            query['RecoveryTimeoutSec'] = request.recovery_timeout_sec
        if not UtilClient.is_unset(request.response_content_body):
            query['ResponseContentBody'] = request.response_content_body
        if not UtilClient.is_unset(request.response_redirect_url):
            query['ResponseRedirectUrl'] = request.response_redirect_url
        if not UtilClient.is_unset(request.response_status_code):
            query['ResponseStatusCode'] = request.response_status_code
        if not UtilClient.is_unset(request.route_id):
            query['RouteId'] = request.route_id
        if not UtilClient.is_unset(request.route_name):
            query['RouteName'] = request.route_name
        if not UtilClient.is_unset(request.stat_duration_sec):
            query['StatDurationSec'] = request.stat_duration_sec
        if not UtilClient.is_unset(request.strategy):
            query['Strategy'] = request.strategy
        if not UtilClient.is_unset(request.trigger_ratio):
            query['TriggerRatio'] = request.trigger_ratio
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateGatewayCircuitBreakerRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateGatewayCircuitBreakerRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_gateway_circuit_breaker_rule_with_options_async(
        self,
        request: mse_20190531_models.CreateGatewayCircuitBreakerRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateGatewayCircuitBreakerRuleResponse:
        """
        @summary 创建网关路由熔断规则
        
        @param request: CreateGatewayCircuitBreakerRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateGatewayCircuitBreakerRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.behavior_type):
            query['BehaviorType'] = request.behavior_type
        if not UtilClient.is_unset(request.body_encoding):
            query['BodyEncoding'] = request.body_encoding
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.max_allowed_ms):
            query['MaxAllowedMs'] = request.max_allowed_ms
        if not UtilClient.is_unset(request.min_request_amount):
            query['MinRequestAmount'] = request.min_request_amount
        if not UtilClient.is_unset(request.recovery_timeout_sec):
            query['RecoveryTimeoutSec'] = request.recovery_timeout_sec
        if not UtilClient.is_unset(request.response_content_body):
            query['ResponseContentBody'] = request.response_content_body
        if not UtilClient.is_unset(request.response_redirect_url):
            query['ResponseRedirectUrl'] = request.response_redirect_url
        if not UtilClient.is_unset(request.response_status_code):
            query['ResponseStatusCode'] = request.response_status_code
        if not UtilClient.is_unset(request.route_id):
            query['RouteId'] = request.route_id
        if not UtilClient.is_unset(request.route_name):
            query['RouteName'] = request.route_name
        if not UtilClient.is_unset(request.stat_duration_sec):
            query['StatDurationSec'] = request.stat_duration_sec
        if not UtilClient.is_unset(request.strategy):
            query['Strategy'] = request.strategy
        if not UtilClient.is_unset(request.trigger_ratio):
            query['TriggerRatio'] = request.trigger_ratio
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateGatewayCircuitBreakerRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateGatewayCircuitBreakerRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_gateway_circuit_breaker_rule(
        self,
        request: mse_20190531_models.CreateGatewayCircuitBreakerRuleRequest,
    ) -> mse_20190531_models.CreateGatewayCircuitBreakerRuleResponse:
        """
        @summary 创建网关路由熔断规则
        
        @param request: CreateGatewayCircuitBreakerRuleRequest
        @return: CreateGatewayCircuitBreakerRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_gateway_circuit_breaker_rule_with_options(request, runtime)

    async def create_gateway_circuit_breaker_rule_async(
        self,
        request: mse_20190531_models.CreateGatewayCircuitBreakerRuleRequest,
    ) -> mse_20190531_models.CreateGatewayCircuitBreakerRuleResponse:
        """
        @summary 创建网关路由熔断规则
        
        @param request: CreateGatewayCircuitBreakerRuleRequest
        @return: CreateGatewayCircuitBreakerRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_gateway_circuit_breaker_rule_with_options_async(request, runtime)

    def create_gateway_flow_rule_with_options(
        self,
        request: mse_20190531_models.CreateGatewayFlowRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateGatewayFlowRuleResponse:
        """
        @summary Creates a throttling rule for a gateway.
        
        @param request: CreateGatewayFlowRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateGatewayFlowRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.behavior_type):
            query['BehaviorType'] = request.behavior_type
        if not UtilClient.is_unset(request.body_encoding):
            query['BodyEncoding'] = request.body_encoding
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.response_content_body):
            query['ResponseContentBody'] = request.response_content_body
        if not UtilClient.is_unset(request.response_redirect_url):
            query['ResponseRedirectUrl'] = request.response_redirect_url
        if not UtilClient.is_unset(request.response_status_code):
            query['ResponseStatusCode'] = request.response_status_code
        if not UtilClient.is_unset(request.route_id):
            query['RouteId'] = request.route_id
        if not UtilClient.is_unset(request.route_name):
            query['RouteName'] = request.route_name
        if not UtilClient.is_unset(request.threshold):
            query['Threshold'] = request.threshold
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateGatewayFlowRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateGatewayFlowRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_gateway_flow_rule_with_options_async(
        self,
        request: mse_20190531_models.CreateGatewayFlowRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateGatewayFlowRuleResponse:
        """
        @summary Creates a throttling rule for a gateway.
        
        @param request: CreateGatewayFlowRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateGatewayFlowRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.behavior_type):
            query['BehaviorType'] = request.behavior_type
        if not UtilClient.is_unset(request.body_encoding):
            query['BodyEncoding'] = request.body_encoding
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.response_content_body):
            query['ResponseContentBody'] = request.response_content_body
        if not UtilClient.is_unset(request.response_redirect_url):
            query['ResponseRedirectUrl'] = request.response_redirect_url
        if not UtilClient.is_unset(request.response_status_code):
            query['ResponseStatusCode'] = request.response_status_code
        if not UtilClient.is_unset(request.route_id):
            query['RouteId'] = request.route_id
        if not UtilClient.is_unset(request.route_name):
            query['RouteName'] = request.route_name
        if not UtilClient.is_unset(request.threshold):
            query['Threshold'] = request.threshold
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateGatewayFlowRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateGatewayFlowRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_gateway_flow_rule(
        self,
        request: mse_20190531_models.CreateGatewayFlowRuleRequest,
    ) -> mse_20190531_models.CreateGatewayFlowRuleResponse:
        """
        @summary Creates a throttling rule for a gateway.
        
        @param request: CreateGatewayFlowRuleRequest
        @return: CreateGatewayFlowRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_gateway_flow_rule_with_options(request, runtime)

    async def create_gateway_flow_rule_async(
        self,
        request: mse_20190531_models.CreateGatewayFlowRuleRequest,
    ) -> mse_20190531_models.CreateGatewayFlowRuleResponse:
        """
        @summary Creates a throttling rule for a gateway.
        
        @param request: CreateGatewayFlowRuleRequest
        @return: CreateGatewayFlowRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_gateway_flow_rule_with_options_async(request, runtime)

    def create_gateway_isolation_rule_with_options(
        self,
        request: mse_20190531_models.CreateGatewayIsolationRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateGatewayIsolationRuleResponse:
        """
        @summary 创建网关路由隔离规则
        
        @param request: CreateGatewayIsolationRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateGatewayIsolationRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.behavior_type):
            query['BehaviorType'] = request.behavior_type
        if not UtilClient.is_unset(request.body_encoding):
            query['BodyEncoding'] = request.body_encoding
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.max_concurrency):
            query['MaxConcurrency'] = request.max_concurrency
        if not UtilClient.is_unset(request.response_content_body):
            query['ResponseContentBody'] = request.response_content_body
        if not UtilClient.is_unset(request.response_redirect_url):
            query['ResponseRedirectUrl'] = request.response_redirect_url
        if not UtilClient.is_unset(request.response_status_code):
            query['ResponseStatusCode'] = request.response_status_code
        if not UtilClient.is_unset(request.route_id):
            query['RouteId'] = request.route_id
        if not UtilClient.is_unset(request.route_name):
            query['RouteName'] = request.route_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateGatewayIsolationRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateGatewayIsolationRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_gateway_isolation_rule_with_options_async(
        self,
        request: mse_20190531_models.CreateGatewayIsolationRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateGatewayIsolationRuleResponse:
        """
        @summary 创建网关路由隔离规则
        
        @param request: CreateGatewayIsolationRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateGatewayIsolationRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.behavior_type):
            query['BehaviorType'] = request.behavior_type
        if not UtilClient.is_unset(request.body_encoding):
            query['BodyEncoding'] = request.body_encoding
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.max_concurrency):
            query['MaxConcurrency'] = request.max_concurrency
        if not UtilClient.is_unset(request.response_content_body):
            query['ResponseContentBody'] = request.response_content_body
        if not UtilClient.is_unset(request.response_redirect_url):
            query['ResponseRedirectUrl'] = request.response_redirect_url
        if not UtilClient.is_unset(request.response_status_code):
            query['ResponseStatusCode'] = request.response_status_code
        if not UtilClient.is_unset(request.route_id):
            query['RouteId'] = request.route_id
        if not UtilClient.is_unset(request.route_name):
            query['RouteName'] = request.route_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateGatewayIsolationRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateGatewayIsolationRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_gateway_isolation_rule(
        self,
        request: mse_20190531_models.CreateGatewayIsolationRuleRequest,
    ) -> mse_20190531_models.CreateGatewayIsolationRuleResponse:
        """
        @summary 创建网关路由隔离规则
        
        @param request: CreateGatewayIsolationRuleRequest
        @return: CreateGatewayIsolationRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_gateway_isolation_rule_with_options(request, runtime)

    async def create_gateway_isolation_rule_async(
        self,
        request: mse_20190531_models.CreateGatewayIsolationRuleRequest,
    ) -> mse_20190531_models.CreateGatewayIsolationRuleResponse:
        """
        @summary 创建网关路由隔离规则
        
        @param request: CreateGatewayIsolationRuleRequest
        @return: CreateGatewayIsolationRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_gateway_isolation_rule_with_options_async(request, runtime)

    def create_isolation_rule_with_options(
        self,
        request: mse_20190531_models.CreateIsolationRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateIsolationRuleResponse:
        """
        @summary 创建隔离规则
        
        @param request: CreateIsolationRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateIsolationRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.limit_app):
            query['LimitApp'] = request.limit_app
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.threshold):
            query['Threshold'] = request.threshold
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIsolationRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateIsolationRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_isolation_rule_with_options_async(
        self,
        request: mse_20190531_models.CreateIsolationRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateIsolationRuleResponse:
        """
        @summary 创建隔离规则
        
        @param request: CreateIsolationRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateIsolationRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.limit_app):
            query['LimitApp'] = request.limit_app
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.threshold):
            query['Threshold'] = request.threshold
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIsolationRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateIsolationRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_isolation_rule(
        self,
        request: mse_20190531_models.CreateIsolationRuleRequest,
    ) -> mse_20190531_models.CreateIsolationRuleResponse:
        """
        @summary 创建隔离规则
        
        @param request: CreateIsolationRuleRequest
        @return: CreateIsolationRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_isolation_rule_with_options(request, runtime)

    async def create_isolation_rule_async(
        self,
        request: mse_20190531_models.CreateIsolationRuleRequest,
    ) -> mse_20190531_models.CreateIsolationRuleResponse:
        """
        @summary 创建隔离规则
        
        @param request: CreateIsolationRuleRequest
        @return: CreateIsolationRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_isolation_rule_with_options_async(request, runtime)

    def create_mse_service_application_with_options(
        self,
        request: mse_20190531_models.CreateMseServiceApplicationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateMseServiceApplicationResponse:
        """
        @deprecated OpenAPI CreateMseServiceApplication is deprecated, please use mse::2019-05-31::CreateApplication instead.
        
        @summary Creates an application.
        
        @param request: CreateMseServiceApplicationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMseServiceApplicationResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.extra_info):
            query['ExtraInfo'] = request.extra_info
        if not UtilClient.is_unset(request.language):
            query['Language'] = request.language
        if not UtilClient.is_unset(request.mse_version):
            query['MseVersion'] = request.mse_version
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.sentinel_enable):
            query['SentinelEnable'] = request.sentinel_enable
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.switch_enable):
            query['SwitchEnable'] = request.switch_enable
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateMseServiceApplication',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateMseServiceApplicationResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_mse_service_application_with_options_async(
        self,
        request: mse_20190531_models.CreateMseServiceApplicationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateMseServiceApplicationResponse:
        """
        @deprecated OpenAPI CreateMseServiceApplication is deprecated, please use mse::2019-05-31::CreateApplication instead.
        
        @summary Creates an application.
        
        @param request: CreateMseServiceApplicationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMseServiceApplicationResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.extra_info):
            query['ExtraInfo'] = request.extra_info
        if not UtilClient.is_unset(request.language):
            query['Language'] = request.language
        if not UtilClient.is_unset(request.mse_version):
            query['MseVersion'] = request.mse_version
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.sentinel_enable):
            query['SentinelEnable'] = request.sentinel_enable
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.switch_enable):
            query['SwitchEnable'] = request.switch_enable
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateMseServiceApplication',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateMseServiceApplicationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_mse_service_application(
        self,
        request: mse_20190531_models.CreateMseServiceApplicationRequest,
    ) -> mse_20190531_models.CreateMseServiceApplicationResponse:
        """
        @deprecated OpenAPI CreateMseServiceApplication is deprecated, please use mse::2019-05-31::CreateApplication instead.
        
        @summary Creates an application.
        
        @param request: CreateMseServiceApplicationRequest
        @return: CreateMseServiceApplicationResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.create_mse_service_application_with_options(request, runtime)

    async def create_mse_service_application_async(
        self,
        request: mse_20190531_models.CreateMseServiceApplicationRequest,
    ) -> mse_20190531_models.CreateMseServiceApplicationResponse:
        """
        @deprecated OpenAPI CreateMseServiceApplication is deprecated, please use mse::2019-05-31::CreateApplication instead.
        
        @summary Creates an application.
        
        @param request: CreateMseServiceApplicationRequest
        @return: CreateMseServiceApplicationResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_mse_service_application_with_options_async(request, runtime)

    def create_nacos_config_with_options(
        self,
        request: mse_20190531_models.CreateNacosConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateNacosConfigResponse:
        """
        @summary Creates a Nacos configuration.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: CreateNacosConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNacosConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.beta_ips):
            query['BetaIps'] = request.beta_ips
        if not UtilClient.is_unset(request.data_id):
            query['DataId'] = request.data_id
        if not UtilClient.is_unset(request.desc):
            query['Desc'] = request.desc
        if not UtilClient.is_unset(request.group):
            query['Group'] = request.group
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.tags):
            query['Tags'] = request.tags
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        body = {}
        if not UtilClient.is_unset(request.content):
            body['Content'] = request.content
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateNacosConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateNacosConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_nacos_config_with_options_async(
        self,
        request: mse_20190531_models.CreateNacosConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateNacosConfigResponse:
        """
        @summary Creates a Nacos configuration.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: CreateNacosConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNacosConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.beta_ips):
            query['BetaIps'] = request.beta_ips
        if not UtilClient.is_unset(request.data_id):
            query['DataId'] = request.data_id
        if not UtilClient.is_unset(request.desc):
            query['Desc'] = request.desc
        if not UtilClient.is_unset(request.group):
            query['Group'] = request.group
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.tags):
            query['Tags'] = request.tags
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        body = {}
        if not UtilClient.is_unset(request.content):
            body['Content'] = request.content
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateNacosConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateNacosConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_nacos_config(
        self,
        request: mse_20190531_models.CreateNacosConfigRequest,
    ) -> mse_20190531_models.CreateNacosConfigResponse:
        """
        @summary Creates a Nacos configuration.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: CreateNacosConfigRequest
        @return: CreateNacosConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_nacos_config_with_options(request, runtime)

    async def create_nacos_config_async(
        self,
        request: mse_20190531_models.CreateNacosConfigRequest,
    ) -> mse_20190531_models.CreateNacosConfigResponse:
        """
        @summary Creates a Nacos configuration.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: CreateNacosConfigRequest
        @return: CreateNacosConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_nacos_config_with_options_async(request, runtime)

    def create_nacos_instance_with_options(
        self,
        request: mse_20190531_models.CreateNacosInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateNacosInstanceResponse:
        """
        @summary Creates a Nacos instance.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: CreateNacosInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNacosInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.enabled):
            query['Enabled'] = request.enabled
        if not UtilClient.is_unset(request.ephemeral):
            query['Ephemeral'] = request.ephemeral
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.ip):
            query['Ip'] = request.ip
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        body = {}
        if not UtilClient.is_unset(request.metadata):
            body['Metadata'] = request.metadata
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateNacosInstance',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateNacosInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_nacos_instance_with_options_async(
        self,
        request: mse_20190531_models.CreateNacosInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateNacosInstanceResponse:
        """
        @summary Creates a Nacos instance.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: CreateNacosInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNacosInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.enabled):
            query['Enabled'] = request.enabled
        if not UtilClient.is_unset(request.ephemeral):
            query['Ephemeral'] = request.ephemeral
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.ip):
            query['Ip'] = request.ip
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        body = {}
        if not UtilClient.is_unset(request.metadata):
            body['Metadata'] = request.metadata
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateNacosInstance',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateNacosInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_nacos_instance(
        self,
        request: mse_20190531_models.CreateNacosInstanceRequest,
    ) -> mse_20190531_models.CreateNacosInstanceResponse:
        """
        @summary Creates a Nacos instance.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: CreateNacosInstanceRequest
        @return: CreateNacosInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_nacos_instance_with_options(request, runtime)

    async def create_nacos_instance_async(
        self,
        request: mse_20190531_models.CreateNacosInstanceRequest,
    ) -> mse_20190531_models.CreateNacosInstanceResponse:
        """
        @summary Creates a Nacos instance.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: CreateNacosInstanceRequest
        @return: CreateNacosInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_nacos_instance_with_options_async(request, runtime)

    def create_nacos_service_with_options(
        self,
        request: mse_20190531_models.CreateNacosServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateNacosServiceResponse:
        """
        @summary Creates a Nacos service.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: CreateNacosServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNacosServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.ephemeral):
            query['Ephemeral'] = request.ephemeral
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.protect_threshold):
            query['ProtectThreshold'] = request.protect_threshold
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNacosService',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateNacosServiceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_nacos_service_with_options_async(
        self,
        request: mse_20190531_models.CreateNacosServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateNacosServiceResponse:
        """
        @summary Creates a Nacos service.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: CreateNacosServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNacosServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.ephemeral):
            query['Ephemeral'] = request.ephemeral
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.protect_threshold):
            query['ProtectThreshold'] = request.protect_threshold
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNacosService',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateNacosServiceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_nacos_service(
        self,
        request: mse_20190531_models.CreateNacosServiceRequest,
    ) -> mse_20190531_models.CreateNacosServiceResponse:
        """
        @summary Creates a Nacos service.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: CreateNacosServiceRequest
        @return: CreateNacosServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_nacos_service_with_options(request, runtime)

    async def create_nacos_service_async(
        self,
        request: mse_20190531_models.CreateNacosServiceRequest,
    ) -> mse_20190531_models.CreateNacosServiceResponse:
        """
        @summary Creates a Nacos service.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: CreateNacosServiceRequest
        @return: CreateNacosServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_nacos_service_with_options_async(request, runtime)

    def create_namespace_with_options(
        self,
        tmp_req: mse_20190531_models.CreateNamespaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateNamespaceResponse:
        """
        @summary CreateNamespace
        
        @param tmp_req: CreateNamespaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNamespaceResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.CreateNamespaceShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.tag):
            request.tag_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.tag, 'Tag', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.describe):
            query['Describe'] = request.describe
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.tag_shrink):
            query['Tag'] = request.tag_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNamespace',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateNamespaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_namespace_with_options_async(
        self,
        tmp_req: mse_20190531_models.CreateNamespaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateNamespaceResponse:
        """
        @summary CreateNamespace
        
        @param tmp_req: CreateNamespaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNamespaceResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.CreateNamespaceShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.tag):
            request.tag_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.tag, 'Tag', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.describe):
            query['Describe'] = request.describe
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.tag_shrink):
            query['Tag'] = request.tag_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNamespace',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateNamespaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_namespace(
        self,
        request: mse_20190531_models.CreateNamespaceRequest,
    ) -> mse_20190531_models.CreateNamespaceResponse:
        """
        @summary CreateNamespace
        
        @param request: CreateNamespaceRequest
        @return: CreateNamespaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_namespace_with_options(request, runtime)

    async def create_namespace_async(
        self,
        request: mse_20190531_models.CreateNamespaceRequest,
    ) -> mse_20190531_models.CreateNamespaceResponse:
        """
        @summary CreateNamespace
        
        @param request: CreateNamespaceRequest
        @return: CreateNamespaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_namespace_with_options_async(request, runtime)

    def create_or_update_swimming_lane_with_options(
        self,
        tmp_req: mse_20190531_models.CreateOrUpdateSwimmingLaneRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateOrUpdateSwimmingLaneResponse:
        """
        @summary Creates or updates a lane for end-to-end canary release.
        
        @param tmp_req: CreateOrUpdateSwimmingLaneRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOrUpdateSwimmingLaneResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.CreateOrUpdateSwimmingLaneShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.gateway_swimming_lane_route_json):
            request.gateway_swimming_lane_route_json_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.gateway_swimming_lane_route_json, 'GatewaySwimmingLaneRouteJson', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.enable_rules):
            query['EnableRules'] = request.enable_rules
        if not UtilClient.is_unset(request.entry_rule):
            query['EntryRule'] = request.entry_rule
        if not UtilClient.is_unset(request.gateway_swimming_lane_route_json_shrink):
            query['GatewaySwimmingLaneRouteJson'] = request.gateway_swimming_lane_route_json_shrink
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.path_independent_percentage_enable):
            query['PathIndependentPercentageEnable'] = request.path_independent_percentage_enable
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        body = {}
        if not UtilClient.is_unset(request.entry_rules):
            body['EntryRules'] = request.entry_rules
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateOrUpdateSwimmingLane',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateOrUpdateSwimmingLaneResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_or_update_swimming_lane_with_options_async(
        self,
        tmp_req: mse_20190531_models.CreateOrUpdateSwimmingLaneRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateOrUpdateSwimmingLaneResponse:
        """
        @summary Creates or updates a lane for end-to-end canary release.
        
        @param tmp_req: CreateOrUpdateSwimmingLaneRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOrUpdateSwimmingLaneResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.CreateOrUpdateSwimmingLaneShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.gateway_swimming_lane_route_json):
            request.gateway_swimming_lane_route_json_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.gateway_swimming_lane_route_json, 'GatewaySwimmingLaneRouteJson', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.enable_rules):
            query['EnableRules'] = request.enable_rules
        if not UtilClient.is_unset(request.entry_rule):
            query['EntryRule'] = request.entry_rule
        if not UtilClient.is_unset(request.gateway_swimming_lane_route_json_shrink):
            query['GatewaySwimmingLaneRouteJson'] = request.gateway_swimming_lane_route_json_shrink
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.path_independent_percentage_enable):
            query['PathIndependentPercentageEnable'] = request.path_independent_percentage_enable
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        body = {}
        if not UtilClient.is_unset(request.entry_rules):
            body['EntryRules'] = request.entry_rules
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateOrUpdateSwimmingLane',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateOrUpdateSwimmingLaneResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_or_update_swimming_lane(
        self,
        request: mse_20190531_models.CreateOrUpdateSwimmingLaneRequest,
    ) -> mse_20190531_models.CreateOrUpdateSwimmingLaneResponse:
        """
        @summary Creates or updates a lane for end-to-end canary release.
        
        @param request: CreateOrUpdateSwimmingLaneRequest
        @return: CreateOrUpdateSwimmingLaneResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_or_update_swimming_lane_with_options(request, runtime)

    async def create_or_update_swimming_lane_async(
        self,
        request: mse_20190531_models.CreateOrUpdateSwimmingLaneRequest,
    ) -> mse_20190531_models.CreateOrUpdateSwimmingLaneResponse:
        """
        @summary Creates or updates a lane for end-to-end canary release.
        
        @param request: CreateOrUpdateSwimmingLaneRequest
        @return: CreateOrUpdateSwimmingLaneResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_or_update_swimming_lane_with_options_async(request, runtime)

    def create_or_update_swimming_lane_group_with_options(
        self,
        tmp_req: mse_20190531_models.CreateOrUpdateSwimmingLaneGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateOrUpdateSwimmingLaneGroupResponse:
        """
        @summary Creates or updates a lane group for end-to-end canary release.
        
        @param tmp_req: CreateOrUpdateSwimmingLaneGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOrUpdateSwimmingLaneGroupResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.CreateOrUpdateSwimmingLaneGroupShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.paths):
            request.paths_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.paths, 'Paths', 'json')
        if not UtilClient.is_unset(tmp_req.route_ids):
            request.route_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.route_ids, 'RouteIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_ids):
            query['AppIds'] = request.app_ids
        if not UtilClient.is_unset(request.canary_model):
            query['CanaryModel'] = request.canary_model
        if not UtilClient.is_unset(request.db_gray_enable):
            query['DbGrayEnable'] = request.db_gray_enable
        if not UtilClient.is_unset(request.entry_app):
            query['EntryApp'] = request.entry_app
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.message_queue_filter_side):
            query['MessageQueueFilterSide'] = request.message_queue_filter_side
        if not UtilClient.is_unset(request.message_queue_gray_enable):
            query['MessageQueueGrayEnable'] = request.message_queue_gray_enable
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.paths_shrink):
            query['Paths'] = request.paths_shrink
        if not UtilClient.is_unset(request.record_canary_detail):
            query['RecordCanaryDetail'] = request.record_canary_detail
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.route_ids_shrink):
            query['RouteIds'] = request.route_ids_shrink
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.swim_version):
            query['SwimVersion'] = request.swim_version
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateOrUpdateSwimmingLaneGroup',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateOrUpdateSwimmingLaneGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_or_update_swimming_lane_group_with_options_async(
        self,
        tmp_req: mse_20190531_models.CreateOrUpdateSwimmingLaneGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateOrUpdateSwimmingLaneGroupResponse:
        """
        @summary Creates or updates a lane group for end-to-end canary release.
        
        @param tmp_req: CreateOrUpdateSwimmingLaneGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOrUpdateSwimmingLaneGroupResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.CreateOrUpdateSwimmingLaneGroupShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.paths):
            request.paths_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.paths, 'Paths', 'json')
        if not UtilClient.is_unset(tmp_req.route_ids):
            request.route_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.route_ids, 'RouteIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_ids):
            query['AppIds'] = request.app_ids
        if not UtilClient.is_unset(request.canary_model):
            query['CanaryModel'] = request.canary_model
        if not UtilClient.is_unset(request.db_gray_enable):
            query['DbGrayEnable'] = request.db_gray_enable
        if not UtilClient.is_unset(request.entry_app):
            query['EntryApp'] = request.entry_app
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.message_queue_filter_side):
            query['MessageQueueFilterSide'] = request.message_queue_filter_side
        if not UtilClient.is_unset(request.message_queue_gray_enable):
            query['MessageQueueGrayEnable'] = request.message_queue_gray_enable
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.paths_shrink):
            query['Paths'] = request.paths_shrink
        if not UtilClient.is_unset(request.record_canary_detail):
            query['RecordCanaryDetail'] = request.record_canary_detail
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.route_ids_shrink):
            query['RouteIds'] = request.route_ids_shrink
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.swim_version):
            query['SwimVersion'] = request.swim_version
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateOrUpdateSwimmingLaneGroup',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateOrUpdateSwimmingLaneGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_or_update_swimming_lane_group(
        self,
        request: mse_20190531_models.CreateOrUpdateSwimmingLaneGroupRequest,
    ) -> mse_20190531_models.CreateOrUpdateSwimmingLaneGroupResponse:
        """
        @summary Creates or updates a lane group for end-to-end canary release.
        
        @param request: CreateOrUpdateSwimmingLaneGroupRequest
        @return: CreateOrUpdateSwimmingLaneGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_or_update_swimming_lane_group_with_options(request, runtime)

    async def create_or_update_swimming_lane_group_async(
        self,
        request: mse_20190531_models.CreateOrUpdateSwimmingLaneGroupRequest,
    ) -> mse_20190531_models.CreateOrUpdateSwimmingLaneGroupResponse:
        """
        @summary Creates or updates a lane group for end-to-end canary release.
        
        @param request: CreateOrUpdateSwimmingLaneGroupRequest
        @return: CreateOrUpdateSwimmingLaneGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_or_update_swimming_lane_group_with_options_async(request, runtime)

    def create_plugin_config_with_options(
        self,
        tmp_req: mse_20190531_models.CreatePluginConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreatePluginConfigResponse:
        """
        @summary Creates a plug-in configuration.
        
        @param tmp_req: CreatePluginConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePluginConfigResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.CreatePluginConfigShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.resource_id_list):
            request.resource_id_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.resource_id_list, 'ResourceIdList', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.config_level):
            query['ConfigLevel'] = request.config_level
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.plugin_id):
            query['PluginId'] = request.plugin_id
        if not UtilClient.is_unset(request.resource_id_list_shrink):
            query['ResourceIdList'] = request.resource_id_list_shrink
        body = {}
        if not UtilClient.is_unset(request.config):
            body['Config'] = request.config
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreatePluginConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreatePluginConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_plugin_config_with_options_async(
        self,
        tmp_req: mse_20190531_models.CreatePluginConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreatePluginConfigResponse:
        """
        @summary Creates a plug-in configuration.
        
        @param tmp_req: CreatePluginConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePluginConfigResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.CreatePluginConfigShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.resource_id_list):
            request.resource_id_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.resource_id_list, 'ResourceIdList', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.config_level):
            query['ConfigLevel'] = request.config_level
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.plugin_id):
            query['PluginId'] = request.plugin_id
        if not UtilClient.is_unset(request.resource_id_list_shrink):
            query['ResourceIdList'] = request.resource_id_list_shrink
        body = {}
        if not UtilClient.is_unset(request.config):
            body['Config'] = request.config
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreatePluginConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreatePluginConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_plugin_config(
        self,
        request: mse_20190531_models.CreatePluginConfigRequest,
    ) -> mse_20190531_models.CreatePluginConfigResponse:
        """
        @summary Creates a plug-in configuration.
        
        @param request: CreatePluginConfigRequest
        @return: CreatePluginConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_plugin_config_with_options(request, runtime)

    async def create_plugin_config_async(
        self,
        request: mse_20190531_models.CreatePluginConfigRequest,
    ) -> mse_20190531_models.CreatePluginConfigResponse:
        """
        @summary Creates a plug-in configuration.
        
        @param request: CreatePluginConfigRequest
        @return: CreatePluginConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_plugin_config_with_options_async(request, runtime)

    def create_sentinel_block_fallback_definition_with_options(
        self,
        request: mse_20190531_models.CreateSentinelBlockFallbackDefinitionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateSentinelBlockFallbackDefinitionResponse:
        """
        @summary 创建行为管理
        
        @param request: CreateSentinelBlockFallbackDefinitionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSentinelBlockFallbackDefinitionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.fallback_behavior):
            query['FallbackBehavior'] = request.fallback_behavior
        if not UtilClient.is_unset(request.language):
            query['Language'] = request.language
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_classification):
            query['ResourceClassification'] = request.resource_classification
        if not UtilClient.is_unset(request.scenario):
            query['Scenario'] = request.scenario
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSentinelBlockFallbackDefinition',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateSentinelBlockFallbackDefinitionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_sentinel_block_fallback_definition_with_options_async(
        self,
        request: mse_20190531_models.CreateSentinelBlockFallbackDefinitionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateSentinelBlockFallbackDefinitionResponse:
        """
        @summary 创建行为管理
        
        @param request: CreateSentinelBlockFallbackDefinitionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSentinelBlockFallbackDefinitionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.fallback_behavior):
            query['FallbackBehavior'] = request.fallback_behavior
        if not UtilClient.is_unset(request.language):
            query['Language'] = request.language
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_classification):
            query['ResourceClassification'] = request.resource_classification
        if not UtilClient.is_unset(request.scenario):
            query['Scenario'] = request.scenario
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSentinelBlockFallbackDefinition',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateSentinelBlockFallbackDefinitionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_sentinel_block_fallback_definition(
        self,
        request: mse_20190531_models.CreateSentinelBlockFallbackDefinitionRequest,
    ) -> mse_20190531_models.CreateSentinelBlockFallbackDefinitionResponse:
        """
        @summary 创建行为管理
        
        @param request: CreateSentinelBlockFallbackDefinitionRequest
        @return: CreateSentinelBlockFallbackDefinitionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_sentinel_block_fallback_definition_with_options(request, runtime)

    async def create_sentinel_block_fallback_definition_async(
        self,
        request: mse_20190531_models.CreateSentinelBlockFallbackDefinitionRequest,
    ) -> mse_20190531_models.CreateSentinelBlockFallbackDefinitionResponse:
        """
        @summary 创建行为管理
        
        @param request: CreateSentinelBlockFallbackDefinitionRequest
        @return: CreateSentinelBlockFallbackDefinitionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_sentinel_block_fallback_definition_with_options_async(request, runtime)

    def create_web_flow_rule_with_options(
        self,
        request: mse_20190531_models.CreateWebFlowRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateWebFlowRuleResponse:
        """
        @summary 创建热点参数防护规则（HTTP 请求）
        
        @param request: CreateWebFlowRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateWebFlowRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.burst):
            query['Burst'] = request.burst
        if not UtilClient.is_unset(request.control_behavior):
            query['ControlBehavior'] = request.control_behavior
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.max_queueing_time_ms):
            query['MaxQueueingTimeMs'] = request.max_queueing_time_ms
        if not UtilClient.is_unset(request.metric_type):
            query['MetricType'] = request.metric_type
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.param_item):
            query['ParamItem'] = request.param_item
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.resource_mode):
            query['ResourceMode'] = request.resource_mode
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.stat_interval_ms):
            query['StatIntervalMs'] = request.stat_interval_ms
        if not UtilClient.is_unset(request.threshold):
            query['Threshold'] = request.threshold
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateWebFlowRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateWebFlowRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_web_flow_rule_with_options_async(
        self,
        request: mse_20190531_models.CreateWebFlowRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateWebFlowRuleResponse:
        """
        @summary 创建热点参数防护规则（HTTP 请求）
        
        @param request: CreateWebFlowRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateWebFlowRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.burst):
            query['Burst'] = request.burst
        if not UtilClient.is_unset(request.control_behavior):
            query['ControlBehavior'] = request.control_behavior
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.max_queueing_time_ms):
            query['MaxQueueingTimeMs'] = request.max_queueing_time_ms
        if not UtilClient.is_unset(request.metric_type):
            query['MetricType'] = request.metric_type
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.param_item):
            query['ParamItem'] = request.param_item
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.resource_mode):
            query['ResourceMode'] = request.resource_mode
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.stat_interval_ms):
            query['StatIntervalMs'] = request.stat_interval_ms
        if not UtilClient.is_unset(request.threshold):
            query['Threshold'] = request.threshold
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateWebFlowRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateWebFlowRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_web_flow_rule(
        self,
        request: mse_20190531_models.CreateWebFlowRuleRequest,
    ) -> mse_20190531_models.CreateWebFlowRuleResponse:
        """
        @summary 创建热点参数防护规则（HTTP 请求）
        
        @param request: CreateWebFlowRuleRequest
        @return: CreateWebFlowRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_web_flow_rule_with_options(request, runtime)

    async def create_web_flow_rule_async(
        self,
        request: mse_20190531_models.CreateWebFlowRuleRequest,
    ) -> mse_20190531_models.CreateWebFlowRuleResponse:
        """
        @summary 创建热点参数防护规则（HTTP 请求）
        
        @param request: CreateWebFlowRuleRequest
        @return: CreateWebFlowRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_web_flow_rule_with_options_async(request, runtime)

    def create_znode_with_options(
        self,
        request: mse_20190531_models.CreateZnodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateZnodeResponse:
        """
        @summary Creates a znode.
        
        @param request: CreateZnodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateZnodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.data):
            query['Data'] = request.data
        if not UtilClient.is_unset(request.path):
            query['Path'] = request.path
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateZnode',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateZnodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_znode_with_options_async(
        self,
        request: mse_20190531_models.CreateZnodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.CreateZnodeResponse:
        """
        @summary Creates a znode.
        
        @param request: CreateZnodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateZnodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.data):
            query['Data'] = request.data
        if not UtilClient.is_unset(request.path):
            query['Path'] = request.path
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateZnode',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.CreateZnodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_znode(
        self,
        request: mse_20190531_models.CreateZnodeRequest,
    ) -> mse_20190531_models.CreateZnodeResponse:
        """
        @summary Creates a znode.
        
        @param request: CreateZnodeRequest
        @return: CreateZnodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_znode_with_options(request, runtime)

    async def create_znode_async(
        self,
        request: mse_20190531_models.CreateZnodeRequest,
    ) -> mse_20190531_models.CreateZnodeResponse:
        """
        @summary Creates a znode.
        
        @param request: CreateZnodeRequest
        @return: CreateZnodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_znode_with_options_async(request, runtime)

    def delete_auth_resource_with_options(
        self,
        request: mse_20190531_models.DeleteAuthResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteAuthResourceResponse:
        """
        @summary Deletes an authorized resource.
        
        @param request: DeleteAuthResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAuthResourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAuthResource',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteAuthResourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_auth_resource_with_options_async(
        self,
        request: mse_20190531_models.DeleteAuthResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteAuthResourceResponse:
        """
        @summary Deletes an authorized resource.
        
        @param request: DeleteAuthResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAuthResourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAuthResource',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteAuthResourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_auth_resource(
        self,
        request: mse_20190531_models.DeleteAuthResourceRequest,
    ) -> mse_20190531_models.DeleteAuthResourceResponse:
        """
        @summary Deletes an authorized resource.
        
        @param request: DeleteAuthResourceRequest
        @return: DeleteAuthResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_auth_resource_with_options(request, runtime)

    async def delete_auth_resource_async(
        self,
        request: mse_20190531_models.DeleteAuthResourceRequest,
    ) -> mse_20190531_models.DeleteAuthResourceResponse:
        """
        @summary Deletes an authorized resource.
        
        @param request: DeleteAuthResourceRequest
        @return: DeleteAuthResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_auth_resource_with_options_async(request, runtime)

    def delete_circuit_breaker_rules_with_options(
        self,
        tmp_req: mse_20190531_models.DeleteCircuitBreakerRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteCircuitBreakerRulesResponse:
        """
        @summary Deletes circuit breaking rules.
        
        @param tmp_req: DeleteCircuitBreakerRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCircuitBreakerRulesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.DeleteCircuitBreakerRulesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.ids):
            request.ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.ids, 'Ids', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.ids_shrink):
            query['Ids'] = request.ids_shrink
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCircuitBreakerRules',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteCircuitBreakerRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_circuit_breaker_rules_with_options_async(
        self,
        tmp_req: mse_20190531_models.DeleteCircuitBreakerRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteCircuitBreakerRulesResponse:
        """
        @summary Deletes circuit breaking rules.
        
        @param tmp_req: DeleteCircuitBreakerRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCircuitBreakerRulesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.DeleteCircuitBreakerRulesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.ids):
            request.ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.ids, 'Ids', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.ids_shrink):
            query['Ids'] = request.ids_shrink
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCircuitBreakerRules',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteCircuitBreakerRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_circuit_breaker_rules(
        self,
        request: mse_20190531_models.DeleteCircuitBreakerRulesRequest,
    ) -> mse_20190531_models.DeleteCircuitBreakerRulesResponse:
        """
        @summary Deletes circuit breaking rules.
        
        @param request: DeleteCircuitBreakerRulesRequest
        @return: DeleteCircuitBreakerRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_circuit_breaker_rules_with_options(request, runtime)

    async def delete_circuit_breaker_rules_async(
        self,
        request: mse_20190531_models.DeleteCircuitBreakerRulesRequest,
    ) -> mse_20190531_models.DeleteCircuitBreakerRulesResponse:
        """
        @summary Deletes circuit breaking rules.
        
        @param request: DeleteCircuitBreakerRulesRequest
        @return: DeleteCircuitBreakerRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_circuit_breaker_rules_with_options_async(request, runtime)

    def delete_cluster_with_options(
        self,
        request: mse_20190531_models.DeleteClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteClusterResponse:
        """
        @summary Deletes a Microservices Engine (MSE) instance.
        
        @param request: DeleteClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCluster',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_cluster_with_options_async(
        self,
        request: mse_20190531_models.DeleteClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteClusterResponse:
        """
        @summary Deletes a Microservices Engine (MSE) instance.
        
        @param request: DeleteClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCluster',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_cluster(
        self,
        request: mse_20190531_models.DeleteClusterRequest,
    ) -> mse_20190531_models.DeleteClusterResponse:
        """
        @summary Deletes a Microservices Engine (MSE) instance.
        
        @param request: DeleteClusterRequest
        @return: DeleteClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_cluster_with_options(request, runtime)

    async def delete_cluster_async(
        self,
        request: mse_20190531_models.DeleteClusterRequest,
    ) -> mse_20190531_models.DeleteClusterResponse:
        """
        @summary Deletes a Microservices Engine (MSE) instance.
        
        @param request: DeleteClusterRequest
        @return: DeleteClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_cluster_with_options_async(request, runtime)

    def delete_engine_namespace_with_options(
        self,
        request: mse_20190531_models.DeleteEngineNamespaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteEngineNamespaceResponse:
        """
        @summary Deletes a namespace from a Nacos instance.
        
        @param request: DeleteEngineNamespaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEngineNamespaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEngineNamespace',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteEngineNamespaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_engine_namespace_with_options_async(
        self,
        request: mse_20190531_models.DeleteEngineNamespaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteEngineNamespaceResponse:
        """
        @summary Deletes a namespace from a Nacos instance.
        
        @param request: DeleteEngineNamespaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEngineNamespaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEngineNamespace',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteEngineNamespaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_engine_namespace(
        self,
        request: mse_20190531_models.DeleteEngineNamespaceRequest,
    ) -> mse_20190531_models.DeleteEngineNamespaceResponse:
        """
        @summary Deletes a namespace from a Nacos instance.
        
        @param request: DeleteEngineNamespaceRequest
        @return: DeleteEngineNamespaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_engine_namespace_with_options(request, runtime)

    async def delete_engine_namespace_async(
        self,
        request: mse_20190531_models.DeleteEngineNamespaceRequest,
    ) -> mse_20190531_models.DeleteEngineNamespaceResponse:
        """
        @summary Deletes a namespace from a Nacos instance.
        
        @param request: DeleteEngineNamespaceRequest
        @return: DeleteEngineNamespaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_engine_namespace_with_options_async(request, runtime)

    def delete_flow_rules_with_options(
        self,
        tmp_req: mse_20190531_models.DeleteFlowRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteFlowRulesResponse:
        """
        @summary Deletes throttling rules.
        
        @param tmp_req: DeleteFlowRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteFlowRulesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.DeleteFlowRulesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.ids):
            request.ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.ids, 'Ids', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.ids_shrink):
            query['Ids'] = request.ids_shrink
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteFlowRules',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteFlowRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_flow_rules_with_options_async(
        self,
        tmp_req: mse_20190531_models.DeleteFlowRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteFlowRulesResponse:
        """
        @summary Deletes throttling rules.
        
        @param tmp_req: DeleteFlowRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteFlowRulesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.DeleteFlowRulesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.ids):
            request.ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.ids, 'Ids', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.ids_shrink):
            query['Ids'] = request.ids_shrink
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteFlowRules',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteFlowRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_flow_rules(
        self,
        request: mse_20190531_models.DeleteFlowRulesRequest,
    ) -> mse_20190531_models.DeleteFlowRulesResponse:
        """
        @summary Deletes throttling rules.
        
        @param request: DeleteFlowRulesRequest
        @return: DeleteFlowRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_flow_rules_with_options(request, runtime)

    async def delete_flow_rules_async(
        self,
        request: mse_20190531_models.DeleteFlowRulesRequest,
    ) -> mse_20190531_models.DeleteFlowRulesResponse:
        """
        @summary Deletes throttling rules.
        
        @param request: DeleteFlowRulesRequest
        @return: DeleteFlowRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_flow_rules_with_options_async(request, runtime)

    def delete_gateway_with_options(
        self,
        request: mse_20190531_models.DeleteGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewayResponse:
        """
        @summary Deletes a gateway.
        
        @param request: DeleteGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.delete_slb):
            query['DeleteSlb'] = request.delete_slb
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGateway',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_gateway_with_options_async(
        self,
        request: mse_20190531_models.DeleteGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewayResponse:
        """
        @summary Deletes a gateway.
        
        @param request: DeleteGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.delete_slb):
            query['DeleteSlb'] = request.delete_slb
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGateway',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_gateway(
        self,
        request: mse_20190531_models.DeleteGatewayRequest,
    ) -> mse_20190531_models.DeleteGatewayResponse:
        """
        @summary Deletes a gateway.
        
        @param request: DeleteGatewayRequest
        @return: DeleteGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_gateway_with_options(request, runtime)

    async def delete_gateway_async(
        self,
        request: mse_20190531_models.DeleteGatewayRequest,
    ) -> mse_20190531_models.DeleteGatewayResponse:
        """
        @summary Deletes a gateway.
        
        @param request: DeleteGatewayRequest
        @return: DeleteGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_gateway_with_options_async(request, runtime)

    def delete_gateway_auth_consumer_with_options(
        self,
        request: mse_20190531_models.DeleteGatewayAuthConsumerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewayAuthConsumerResponse:
        """
        @summary Deletes a consumer on which a gateway performs authentication operations.
        
        @param request: DeleteGatewayAuthConsumerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewayAuthConsumerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGatewayAuthConsumer',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewayAuthConsumerResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_gateway_auth_consumer_with_options_async(
        self,
        request: mse_20190531_models.DeleteGatewayAuthConsumerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewayAuthConsumerResponse:
        """
        @summary Deletes a consumer on which a gateway performs authentication operations.
        
        @param request: DeleteGatewayAuthConsumerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewayAuthConsumerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGatewayAuthConsumer',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewayAuthConsumerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_gateway_auth_consumer(
        self,
        request: mse_20190531_models.DeleteGatewayAuthConsumerRequest,
    ) -> mse_20190531_models.DeleteGatewayAuthConsumerResponse:
        """
        @summary Deletes a consumer on which a gateway performs authentication operations.
        
        @param request: DeleteGatewayAuthConsumerRequest
        @return: DeleteGatewayAuthConsumerResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_gateway_auth_consumer_with_options(request, runtime)

    async def delete_gateway_auth_consumer_async(
        self,
        request: mse_20190531_models.DeleteGatewayAuthConsumerRequest,
    ) -> mse_20190531_models.DeleteGatewayAuthConsumerResponse:
        """
        @summary Deletes a consumer on which a gateway performs authentication operations.
        
        @param request: DeleteGatewayAuthConsumerRequest
        @return: DeleteGatewayAuthConsumerResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_gateway_auth_consumer_with_options_async(request, runtime)

    def delete_gateway_auth_consumer_resource_with_options(
        self,
        request: mse_20190531_models.DeleteGatewayAuthConsumerResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewayAuthConsumerResourceResponse:
        """
        @summary Deletes resource permissions from the consumer on which a gateway performs authentication operations.
        
        @param request: DeleteGatewayAuthConsumerResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewayAuthConsumerResourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.consumer_id):
            query['ConsumerId'] = request.consumer_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id_list):
            query['IdList'] = request.id_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGatewayAuthConsumerResource',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewayAuthConsumerResourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_gateway_auth_consumer_resource_with_options_async(
        self,
        request: mse_20190531_models.DeleteGatewayAuthConsumerResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewayAuthConsumerResourceResponse:
        """
        @summary Deletes resource permissions from the consumer on which a gateway performs authentication operations.
        
        @param request: DeleteGatewayAuthConsumerResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewayAuthConsumerResourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.consumer_id):
            query['ConsumerId'] = request.consumer_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id_list):
            query['IdList'] = request.id_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGatewayAuthConsumerResource',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewayAuthConsumerResourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_gateway_auth_consumer_resource(
        self,
        request: mse_20190531_models.DeleteGatewayAuthConsumerResourceRequest,
    ) -> mse_20190531_models.DeleteGatewayAuthConsumerResourceResponse:
        """
        @summary Deletes resource permissions from the consumer on which a gateway performs authentication operations.
        
        @param request: DeleteGatewayAuthConsumerResourceRequest
        @return: DeleteGatewayAuthConsumerResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_gateway_auth_consumer_resource_with_options(request, runtime)

    async def delete_gateway_auth_consumer_resource_async(
        self,
        request: mse_20190531_models.DeleteGatewayAuthConsumerResourceRequest,
    ) -> mse_20190531_models.DeleteGatewayAuthConsumerResourceResponse:
        """
        @summary Deletes resource permissions from the consumer on which a gateway performs authentication operations.
        
        @param request: DeleteGatewayAuthConsumerResourceRequest
        @return: DeleteGatewayAuthConsumerResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_gateway_auth_consumer_resource_with_options_async(request, runtime)

    def delete_gateway_circuit_breaker_rule_with_options(
        self,
        request: mse_20190531_models.DeleteGatewayCircuitBreakerRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewayCircuitBreakerRuleResponse:
        """
        @summary 删除网关路由熔断规则
        
        @param request: DeleteGatewayCircuitBreakerRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewayCircuitBreakerRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.route_id):
            query['RouteId'] = request.route_id
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGatewayCircuitBreakerRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewayCircuitBreakerRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_gateway_circuit_breaker_rule_with_options_async(
        self,
        request: mse_20190531_models.DeleteGatewayCircuitBreakerRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewayCircuitBreakerRuleResponse:
        """
        @summary 删除网关路由熔断规则
        
        @param request: DeleteGatewayCircuitBreakerRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewayCircuitBreakerRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.route_id):
            query['RouteId'] = request.route_id
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGatewayCircuitBreakerRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewayCircuitBreakerRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_gateway_circuit_breaker_rule(
        self,
        request: mse_20190531_models.DeleteGatewayCircuitBreakerRuleRequest,
    ) -> mse_20190531_models.DeleteGatewayCircuitBreakerRuleResponse:
        """
        @summary 删除网关路由熔断规则
        
        @param request: DeleteGatewayCircuitBreakerRuleRequest
        @return: DeleteGatewayCircuitBreakerRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_gateway_circuit_breaker_rule_with_options(request, runtime)

    async def delete_gateway_circuit_breaker_rule_async(
        self,
        request: mse_20190531_models.DeleteGatewayCircuitBreakerRuleRequest,
    ) -> mse_20190531_models.DeleteGatewayCircuitBreakerRuleResponse:
        """
        @summary 删除网关路由熔断规则
        
        @param request: DeleteGatewayCircuitBreakerRuleRequest
        @return: DeleteGatewayCircuitBreakerRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_gateway_circuit_breaker_rule_with_options_async(request, runtime)

    def delete_gateway_domain_with_options(
        self,
        request: mse_20190531_models.DeleteGatewayDomainRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewayDomainResponse:
        """
        @summary Disassociates a domain name from a gateway.
        
        @param request: DeleteGatewayDomainRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewayDomainResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGatewayDomain',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewayDomainResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_gateway_domain_with_options_async(
        self,
        request: mse_20190531_models.DeleteGatewayDomainRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewayDomainResponse:
        """
        @summary Disassociates a domain name from a gateway.
        
        @param request: DeleteGatewayDomainRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewayDomainResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGatewayDomain',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewayDomainResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_gateway_domain(
        self,
        request: mse_20190531_models.DeleteGatewayDomainRequest,
    ) -> mse_20190531_models.DeleteGatewayDomainResponse:
        """
        @summary Disassociates a domain name from a gateway.
        
        @param request: DeleteGatewayDomainRequest
        @return: DeleteGatewayDomainResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_gateway_domain_with_options(request, runtime)

    async def delete_gateway_domain_async(
        self,
        request: mse_20190531_models.DeleteGatewayDomainRequest,
    ) -> mse_20190531_models.DeleteGatewayDomainResponse:
        """
        @summary Disassociates a domain name from a gateway.
        
        @param request: DeleteGatewayDomainRequest
        @return: DeleteGatewayDomainResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_gateway_domain_with_options_async(request, runtime)

    def delete_gateway_flow_rule_with_options(
        self,
        request: mse_20190531_models.DeleteGatewayFlowRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewayFlowRuleResponse:
        """
        @summary 删除网关路由流控规则
        
        @param request: DeleteGatewayFlowRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewayFlowRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.route_id):
            query['RouteId'] = request.route_id
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGatewayFlowRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewayFlowRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_gateway_flow_rule_with_options_async(
        self,
        request: mse_20190531_models.DeleteGatewayFlowRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewayFlowRuleResponse:
        """
        @summary 删除网关路由流控规则
        
        @param request: DeleteGatewayFlowRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewayFlowRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.route_id):
            query['RouteId'] = request.route_id
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGatewayFlowRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewayFlowRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_gateway_flow_rule(
        self,
        request: mse_20190531_models.DeleteGatewayFlowRuleRequest,
    ) -> mse_20190531_models.DeleteGatewayFlowRuleResponse:
        """
        @summary 删除网关路由流控规则
        
        @param request: DeleteGatewayFlowRuleRequest
        @return: DeleteGatewayFlowRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_gateway_flow_rule_with_options(request, runtime)

    async def delete_gateway_flow_rule_async(
        self,
        request: mse_20190531_models.DeleteGatewayFlowRuleRequest,
    ) -> mse_20190531_models.DeleteGatewayFlowRuleResponse:
        """
        @summary 删除网关路由流控规则
        
        @param request: DeleteGatewayFlowRuleRequest
        @return: DeleteGatewayFlowRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_gateway_flow_rule_with_options_async(request, runtime)

    def delete_gateway_isolation_rule_with_options(
        self,
        request: mse_20190531_models.DeleteGatewayIsolationRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewayIsolationRuleResponse:
        """
        @summary 删除网关路由隔离规则
        
        @param request: DeleteGatewayIsolationRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewayIsolationRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.route_id):
            query['RouteId'] = request.route_id
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGatewayIsolationRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewayIsolationRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_gateway_isolation_rule_with_options_async(
        self,
        request: mse_20190531_models.DeleteGatewayIsolationRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewayIsolationRuleResponse:
        """
        @summary 删除网关路由隔离规则
        
        @param request: DeleteGatewayIsolationRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewayIsolationRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.route_id):
            query['RouteId'] = request.route_id
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGatewayIsolationRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewayIsolationRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_gateway_isolation_rule(
        self,
        request: mse_20190531_models.DeleteGatewayIsolationRuleRequest,
    ) -> mse_20190531_models.DeleteGatewayIsolationRuleResponse:
        """
        @summary 删除网关路由隔离规则
        
        @param request: DeleteGatewayIsolationRuleRequest
        @return: DeleteGatewayIsolationRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_gateway_isolation_rule_with_options(request, runtime)

    async def delete_gateway_isolation_rule_async(
        self,
        request: mse_20190531_models.DeleteGatewayIsolationRuleRequest,
    ) -> mse_20190531_models.DeleteGatewayIsolationRuleResponse:
        """
        @summary 删除网关路由隔离规则
        
        @param request: DeleteGatewayIsolationRuleRequest
        @return: DeleteGatewayIsolationRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_gateway_isolation_rule_with_options_async(request, runtime)

    def delete_gateway_route_with_options(
        self,
        request: mse_20190531_models.DeleteGatewayRouteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewayRouteResponse:
        """
        @summary Deletes a route from a gateway.
        
        @param request: DeleteGatewayRouteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewayRouteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.route_id):
            query['RouteId'] = request.route_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGatewayRoute',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewayRouteResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_gateway_route_with_options_async(
        self,
        request: mse_20190531_models.DeleteGatewayRouteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewayRouteResponse:
        """
        @summary Deletes a route from a gateway.
        
        @param request: DeleteGatewayRouteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewayRouteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.route_id):
            query['RouteId'] = request.route_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGatewayRoute',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewayRouteResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_gateway_route(
        self,
        request: mse_20190531_models.DeleteGatewayRouteRequest,
    ) -> mse_20190531_models.DeleteGatewayRouteResponse:
        """
        @summary Deletes a route from a gateway.
        
        @param request: DeleteGatewayRouteRequest
        @return: DeleteGatewayRouteResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_gateway_route_with_options(request, runtime)

    async def delete_gateway_route_async(
        self,
        request: mse_20190531_models.DeleteGatewayRouteRequest,
    ) -> mse_20190531_models.DeleteGatewayRouteResponse:
        """
        @summary Deletes a route from a gateway.
        
        @param request: DeleteGatewayRouteRequest
        @return: DeleteGatewayRouteResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_gateway_route_with_options_async(request, runtime)

    def delete_gateway_service_with_options(
        self,
        request: mse_20190531_models.DeleteGatewayServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewayServiceResponse:
        """
        @summary Deletes a service from a gateway.
        
        @param request: DeleteGatewayServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewayServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGatewayService',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewayServiceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_gateway_service_with_options_async(
        self,
        request: mse_20190531_models.DeleteGatewayServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewayServiceResponse:
        """
        @summary Deletes a service from a gateway.
        
        @param request: DeleteGatewayServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewayServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGatewayService',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewayServiceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_gateway_service(
        self,
        request: mse_20190531_models.DeleteGatewayServiceRequest,
    ) -> mse_20190531_models.DeleteGatewayServiceResponse:
        """
        @summary Deletes a service from a gateway.
        
        @param request: DeleteGatewayServiceRequest
        @return: DeleteGatewayServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_gateway_service_with_options(request, runtime)

    async def delete_gateway_service_async(
        self,
        request: mse_20190531_models.DeleteGatewayServiceRequest,
    ) -> mse_20190531_models.DeleteGatewayServiceResponse:
        """
        @summary Deletes a service from a gateway.
        
        @param request: DeleteGatewayServiceRequest
        @return: DeleteGatewayServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_gateway_service_with_options_async(request, runtime)

    def delete_gateway_service_version_with_options(
        self,
        request: mse_20190531_models.DeleteGatewayServiceVersionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewayServiceVersionResponse:
        """
        @summary Deletes a service version from a gateway.
        
        @param request: DeleteGatewayServiceVersionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewayServiceVersionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        if not UtilClient.is_unset(request.service_version):
            query['ServiceVersion'] = request.service_version
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGatewayServiceVersion',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewayServiceVersionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_gateway_service_version_with_options_async(
        self,
        request: mse_20190531_models.DeleteGatewayServiceVersionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewayServiceVersionResponse:
        """
        @summary Deletes a service version from a gateway.
        
        @param request: DeleteGatewayServiceVersionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewayServiceVersionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        if not UtilClient.is_unset(request.service_version):
            query['ServiceVersion'] = request.service_version
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGatewayServiceVersion',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewayServiceVersionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_gateway_service_version(
        self,
        request: mse_20190531_models.DeleteGatewayServiceVersionRequest,
    ) -> mse_20190531_models.DeleteGatewayServiceVersionResponse:
        """
        @summary Deletes a service version from a gateway.
        
        @param request: DeleteGatewayServiceVersionRequest
        @return: DeleteGatewayServiceVersionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_gateway_service_version_with_options(request, runtime)

    async def delete_gateway_service_version_async(
        self,
        request: mse_20190531_models.DeleteGatewayServiceVersionRequest,
    ) -> mse_20190531_models.DeleteGatewayServiceVersionResponse:
        """
        @summary Deletes a service version from a gateway.
        
        @param request: DeleteGatewayServiceVersionRequest
        @return: DeleteGatewayServiceVersionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_gateway_service_version_with_options_async(request, runtime)

    def delete_gateway_slb_with_options(
        self,
        request: mse_20190531_models.DeleteGatewaySlbRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewaySlbResponse:
        """
        @summary Deletes the Server Load Balancer (SLB) instance that is associated with a gateway.
        
        @param request: DeleteGatewaySlbRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewaySlbResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.delete_slb):
            query['DeleteSlb'] = request.delete_slb
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.slb_id):
            query['SlbId'] = request.slb_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGatewaySlb',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewaySlbResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_gateway_slb_with_options_async(
        self,
        request: mse_20190531_models.DeleteGatewaySlbRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteGatewaySlbResponse:
        """
        @summary Deletes the Server Load Balancer (SLB) instance that is associated with a gateway.
        
        @param request: DeleteGatewaySlbRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGatewaySlbResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.delete_slb):
            query['DeleteSlb'] = request.delete_slb
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.slb_id):
            query['SlbId'] = request.slb_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGatewaySlb',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteGatewaySlbResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_gateway_slb(
        self,
        request: mse_20190531_models.DeleteGatewaySlbRequest,
    ) -> mse_20190531_models.DeleteGatewaySlbResponse:
        """
        @summary Deletes the Server Load Balancer (SLB) instance that is associated with a gateway.
        
        @param request: DeleteGatewaySlbRequest
        @return: DeleteGatewaySlbResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_gateway_slb_with_options(request, runtime)

    async def delete_gateway_slb_async(
        self,
        request: mse_20190531_models.DeleteGatewaySlbRequest,
    ) -> mse_20190531_models.DeleteGatewaySlbResponse:
        """
        @summary Deletes the Server Load Balancer (SLB) instance that is associated with a gateway.
        
        @param request: DeleteGatewaySlbRequest
        @return: DeleteGatewaySlbResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_gateway_slb_with_options_async(request, runtime)

    def delete_isolation_rules_with_options(
        self,
        tmp_req: mse_20190531_models.DeleteIsolationRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteIsolationRulesResponse:
        """
        @summary 删除隔离规则
        
        @param tmp_req: DeleteIsolationRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteIsolationRulesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.DeleteIsolationRulesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.ids):
            request.ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.ids, 'Ids', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.ids_shrink):
            query['Ids'] = request.ids_shrink
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIsolationRules',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteIsolationRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_isolation_rules_with_options_async(
        self,
        tmp_req: mse_20190531_models.DeleteIsolationRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteIsolationRulesResponse:
        """
        @summary 删除隔离规则
        
        @param tmp_req: DeleteIsolationRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteIsolationRulesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.DeleteIsolationRulesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.ids):
            request.ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.ids, 'Ids', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.ids_shrink):
            query['Ids'] = request.ids_shrink
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIsolationRules',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteIsolationRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_isolation_rules(
        self,
        request: mse_20190531_models.DeleteIsolationRulesRequest,
    ) -> mse_20190531_models.DeleteIsolationRulesResponse:
        """
        @summary 删除隔离规则
        
        @param request: DeleteIsolationRulesRequest
        @return: DeleteIsolationRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_isolation_rules_with_options(request, runtime)

    async def delete_isolation_rules_async(
        self,
        request: mse_20190531_models.DeleteIsolationRulesRequest,
    ) -> mse_20190531_models.DeleteIsolationRulesResponse:
        """
        @summary 删除隔离规则
        
        @param request: DeleteIsolationRulesRequest
        @return: DeleteIsolationRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_isolation_rules_with_options_async(request, runtime)

    def delete_migration_task_with_options(
        self,
        request: mse_20190531_models.DeleteMigrationTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteMigrationTaskResponse:
        """
        @summary Deletes a migration task.
        
        @param request: DeleteMigrationTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMigrationTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMigrationTask',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteMigrationTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_migration_task_with_options_async(
        self,
        request: mse_20190531_models.DeleteMigrationTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteMigrationTaskResponse:
        """
        @summary Deletes a migration task.
        
        @param request: DeleteMigrationTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMigrationTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMigrationTask',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteMigrationTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_migration_task(
        self,
        request: mse_20190531_models.DeleteMigrationTaskRequest,
    ) -> mse_20190531_models.DeleteMigrationTaskResponse:
        """
        @summary Deletes a migration task.
        
        @param request: DeleteMigrationTaskRequest
        @return: DeleteMigrationTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_migration_task_with_options(request, runtime)

    async def delete_migration_task_async(
        self,
        request: mse_20190531_models.DeleteMigrationTaskRequest,
    ) -> mse_20190531_models.DeleteMigrationTaskResponse:
        """
        @summary Deletes a migration task.
        
        @param request: DeleteMigrationTaskRequest
        @return: DeleteMigrationTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_migration_task_with_options_async(request, runtime)

    def delete_nacos_config_with_options(
        self,
        request: mse_20190531_models.DeleteNacosConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteNacosConfigResponse:
        """
        @summary Delete specified Nacos configuration
        
        @description > The current OpenAPI is not the Nacos-SDK API. For information related to the Nacos-SDK API, please refer to the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: DeleteNacosConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNacosConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.beta):
            query['Beta'] = request.beta
        if not UtilClient.is_unset(request.data_id):
            query['DataId'] = request.data_id
        if not UtilClient.is_unset(request.group):
            query['Group'] = request.group
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNacosConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteNacosConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_nacos_config_with_options_async(
        self,
        request: mse_20190531_models.DeleteNacosConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteNacosConfigResponse:
        """
        @summary Delete specified Nacos configuration
        
        @description > The current OpenAPI is not the Nacos-SDK API. For information related to the Nacos-SDK API, please refer to the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: DeleteNacosConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNacosConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.beta):
            query['Beta'] = request.beta
        if not UtilClient.is_unset(request.data_id):
            query['DataId'] = request.data_id
        if not UtilClient.is_unset(request.group):
            query['Group'] = request.group
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNacosConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteNacosConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_nacos_config(
        self,
        request: mse_20190531_models.DeleteNacosConfigRequest,
    ) -> mse_20190531_models.DeleteNacosConfigResponse:
        """
        @summary Delete specified Nacos configuration
        
        @description > The current OpenAPI is not the Nacos-SDK API. For information related to the Nacos-SDK API, please refer to the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: DeleteNacosConfigRequest
        @return: DeleteNacosConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_nacos_config_with_options(request, runtime)

    async def delete_nacos_config_async(
        self,
        request: mse_20190531_models.DeleteNacosConfigRequest,
    ) -> mse_20190531_models.DeleteNacosConfigResponse:
        """
        @summary Delete specified Nacos configuration
        
        @description > The current OpenAPI is not the Nacos-SDK API. For information related to the Nacos-SDK API, please refer to the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: DeleteNacosConfigRequest
        @return: DeleteNacosConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_nacos_config_with_options_async(request, runtime)

    def delete_nacos_configs_with_options(
        self,
        request: mse_20190531_models.DeleteNacosConfigsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteNacosConfigsResponse:
        """
        @summary Deletes multiple Nacos configurations at a time.
        
        @description >  The current API operation is not provided in Nacos SDK. For more information about the Nacos-SDK API, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: DeleteNacosConfigsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNacosConfigsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.ids):
            query['Ids'] = request.ids
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNacosConfigs',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteNacosConfigsResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_nacos_configs_with_options_async(
        self,
        request: mse_20190531_models.DeleteNacosConfigsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteNacosConfigsResponse:
        """
        @summary Deletes multiple Nacos configurations at a time.
        
        @description >  The current API operation is not provided in Nacos SDK. For more information about the Nacos-SDK API, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: DeleteNacosConfigsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNacosConfigsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.ids):
            query['Ids'] = request.ids
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNacosConfigs',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteNacosConfigsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_nacos_configs(
        self,
        request: mse_20190531_models.DeleteNacosConfigsRequest,
    ) -> mse_20190531_models.DeleteNacosConfigsResponse:
        """
        @summary Deletes multiple Nacos configurations at a time.
        
        @description >  The current API operation is not provided in Nacos SDK. For more information about the Nacos-SDK API, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: DeleteNacosConfigsRequest
        @return: DeleteNacosConfigsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_nacos_configs_with_options(request, runtime)

    async def delete_nacos_configs_async(
        self,
        request: mse_20190531_models.DeleteNacosConfigsRequest,
    ) -> mse_20190531_models.DeleteNacosConfigsResponse:
        """
        @summary Deletes multiple Nacos configurations at a time.
        
        @description >  The current API operation is not provided in Nacos SDK. For more information about the Nacos-SDK API, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: DeleteNacosConfigsRequest
        @return: DeleteNacosConfigsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_nacos_configs_with_options_async(request, runtime)

    def delete_nacos_instance_with_options(
        self,
        request: mse_20190531_models.DeleteNacosInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteNacosInstanceResponse:
        """
        @summary Deletes a persistent application instance from a Microservices Engine (MSE) Nacos instance.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: DeleteNacosInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNacosInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.ephemeral):
            query['Ephemeral'] = request.ephemeral
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.ip):
            query['Ip'] = request.ip
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNacosInstance',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteNacosInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_nacos_instance_with_options_async(
        self,
        request: mse_20190531_models.DeleteNacosInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteNacosInstanceResponse:
        """
        @summary Deletes a persistent application instance from a Microservices Engine (MSE) Nacos instance.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: DeleteNacosInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNacosInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.ephemeral):
            query['Ephemeral'] = request.ephemeral
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.ip):
            query['Ip'] = request.ip
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNacosInstance',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteNacosInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_nacos_instance(
        self,
        request: mse_20190531_models.DeleteNacosInstanceRequest,
    ) -> mse_20190531_models.DeleteNacosInstanceResponse:
        """
        @summary Deletes a persistent application instance from a Microservices Engine (MSE) Nacos instance.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: DeleteNacosInstanceRequest
        @return: DeleteNacosInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_nacos_instance_with_options(request, runtime)

    async def delete_nacos_instance_async(
        self,
        request: mse_20190531_models.DeleteNacosInstanceRequest,
    ) -> mse_20190531_models.DeleteNacosInstanceResponse:
        """
        @summary Deletes a persistent application instance from a Microservices Engine (MSE) Nacos instance.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: DeleteNacosInstanceRequest
        @return: DeleteNacosInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_nacos_instance_with_options_async(request, runtime)

    def delete_nacos_service_with_options(
        self,
        request: mse_20190531_models.DeleteNacosServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteNacosServiceResponse:
        """
        @summary Deletes a Nacos service.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: DeleteNacosServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNacosServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNacosService',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteNacosServiceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_nacos_service_with_options_async(
        self,
        request: mse_20190531_models.DeleteNacosServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteNacosServiceResponse:
        """
        @summary Deletes a Nacos service.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: DeleteNacosServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNacosServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNacosService',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteNacosServiceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_nacos_service(
        self,
        request: mse_20190531_models.DeleteNacosServiceRequest,
    ) -> mse_20190531_models.DeleteNacosServiceResponse:
        """
        @summary Deletes a Nacos service.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: DeleteNacosServiceRequest
        @return: DeleteNacosServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_nacos_service_with_options(request, runtime)

    async def delete_nacos_service_async(
        self,
        request: mse_20190531_models.DeleteNacosServiceRequest,
    ) -> mse_20190531_models.DeleteNacosServiceResponse:
        """
        @summary Deletes a Nacos service.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: DeleteNacosServiceRequest
        @return: DeleteNacosServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_nacos_service_with_options_async(request, runtime)

    def delete_namespace_with_options(
        self,
        request: mse_20190531_models.DeleteNamespaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteNamespaceResponse:
        """
        @summary 删除MSE命名空间
        
        @param request: DeleteNamespaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNamespaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNamespace',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteNamespaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_namespace_with_options_async(
        self,
        request: mse_20190531_models.DeleteNamespaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteNamespaceResponse:
        """
        @summary 删除MSE命名空间
        
        @param request: DeleteNamespaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNamespaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNamespace',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteNamespaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_namespace(
        self,
        request: mse_20190531_models.DeleteNamespaceRequest,
    ) -> mse_20190531_models.DeleteNamespaceResponse:
        """
        @summary 删除MSE命名空间
        
        @param request: DeleteNamespaceRequest
        @return: DeleteNamespaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_namespace_with_options(request, runtime)

    async def delete_namespace_async(
        self,
        request: mse_20190531_models.DeleteNamespaceRequest,
    ) -> mse_20190531_models.DeleteNamespaceResponse:
        """
        @summary 删除MSE命名空间
        
        @param request: DeleteNamespaceRequest
        @return: DeleteNamespaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_namespace_with_options_async(request, runtime)

    def delete_plugin_config_with_options(
        self,
        request: mse_20190531_models.DeletePluginConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeletePluginConfigResponse:
        """
        @summary Deletes a plug-in configuration.
        
        @param request: DeletePluginConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePluginConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.plugin_config_id):
            query['PluginConfigId'] = request.plugin_config_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePluginConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeletePluginConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_plugin_config_with_options_async(
        self,
        request: mse_20190531_models.DeletePluginConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeletePluginConfigResponse:
        """
        @summary Deletes a plug-in configuration.
        
        @param request: DeletePluginConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePluginConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.plugin_config_id):
            query['PluginConfigId'] = request.plugin_config_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePluginConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeletePluginConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_plugin_config(
        self,
        request: mse_20190531_models.DeletePluginConfigRequest,
    ) -> mse_20190531_models.DeletePluginConfigResponse:
        """
        @summary Deletes a plug-in configuration.
        
        @param request: DeletePluginConfigRequest
        @return: DeletePluginConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_plugin_config_with_options(request, runtime)

    async def delete_plugin_config_async(
        self,
        request: mse_20190531_models.DeletePluginConfigRequest,
    ) -> mse_20190531_models.DeletePluginConfigResponse:
        """
        @summary Deletes a plug-in configuration.
        
        @param request: DeletePluginConfigRequest
        @return: DeletePluginConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_plugin_config_with_options_async(request, runtime)

    def delete_security_group_rule_with_options(
        self,
        request: mse_20190531_models.DeleteSecurityGroupRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteSecurityGroupRuleResponse:
        """
        @summary Deletes a security group rule from a gateway.
        
        @param request: DeleteSecurityGroupRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSecurityGroupRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cascading_delete):
            query['CascadingDelete'] = request.cascading_delete
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSecurityGroupRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteSecurityGroupRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_security_group_rule_with_options_async(
        self,
        request: mse_20190531_models.DeleteSecurityGroupRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteSecurityGroupRuleResponse:
        """
        @summary Deletes a security group rule from a gateway.
        
        @param request: DeleteSecurityGroupRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSecurityGroupRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cascading_delete):
            query['CascadingDelete'] = request.cascading_delete
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSecurityGroupRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteSecurityGroupRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_security_group_rule(
        self,
        request: mse_20190531_models.DeleteSecurityGroupRuleRequest,
    ) -> mse_20190531_models.DeleteSecurityGroupRuleResponse:
        """
        @summary Deletes a security group rule from a gateway.
        
        @param request: DeleteSecurityGroupRuleRequest
        @return: DeleteSecurityGroupRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_security_group_rule_with_options(request, runtime)

    async def delete_security_group_rule_async(
        self,
        request: mse_20190531_models.DeleteSecurityGroupRuleRequest,
    ) -> mse_20190531_models.DeleteSecurityGroupRuleResponse:
        """
        @summary Deletes a security group rule from a gateway.
        
        @param request: DeleteSecurityGroupRuleRequest
        @return: DeleteSecurityGroupRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_security_group_rule_with_options_async(request, runtime)

    def delete_service_source_with_options(
        self,
        request: mse_20190531_models.DeleteServiceSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteServiceSourceResponse:
        """
        @summary Deletes a gateway service source.
        
        @param request: DeleteServiceSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteServiceSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.source_id):
            query['SourceId'] = request.source_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteServiceSource',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteServiceSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_service_source_with_options_async(
        self,
        request: mse_20190531_models.DeleteServiceSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteServiceSourceResponse:
        """
        @summary Deletes a gateway service source.
        
        @param request: DeleteServiceSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteServiceSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.source_id):
            query['SourceId'] = request.source_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteServiceSource',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteServiceSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_service_source(
        self,
        request: mse_20190531_models.DeleteServiceSourceRequest,
    ) -> mse_20190531_models.DeleteServiceSourceResponse:
        """
        @summary Deletes a gateway service source.
        
        @param request: DeleteServiceSourceRequest
        @return: DeleteServiceSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_service_source_with_options(request, runtime)

    async def delete_service_source_async(
        self,
        request: mse_20190531_models.DeleteServiceSourceRequest,
    ) -> mse_20190531_models.DeleteServiceSourceResponse:
        """
        @summary Deletes a gateway service source.
        
        @param request: DeleteServiceSourceRequest
        @return: DeleteServiceSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_service_source_with_options_async(request, runtime)

    def delete_swimming_lane_with_options(
        self,
        request: mse_20190531_models.DeleteSwimmingLaneRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteSwimmingLaneResponse:
        """
        @summary Deletes a lane.
        
        @param request: DeleteSwimmingLaneRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSwimmingLaneResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.lane_id):
            query['LaneId'] = request.lane_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSwimmingLane',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteSwimmingLaneResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_swimming_lane_with_options_async(
        self,
        request: mse_20190531_models.DeleteSwimmingLaneRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteSwimmingLaneResponse:
        """
        @summary Deletes a lane.
        
        @param request: DeleteSwimmingLaneRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSwimmingLaneResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.lane_id):
            query['LaneId'] = request.lane_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSwimmingLane',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteSwimmingLaneResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_swimming_lane(
        self,
        request: mse_20190531_models.DeleteSwimmingLaneRequest,
    ) -> mse_20190531_models.DeleteSwimmingLaneResponse:
        """
        @summary Deletes a lane.
        
        @param request: DeleteSwimmingLaneRequest
        @return: DeleteSwimmingLaneResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_swimming_lane_with_options(request, runtime)

    async def delete_swimming_lane_async(
        self,
        request: mse_20190531_models.DeleteSwimmingLaneRequest,
    ) -> mse_20190531_models.DeleteSwimmingLaneResponse:
        """
        @summary Deletes a lane.
        
        @param request: DeleteSwimmingLaneRequest
        @return: DeleteSwimmingLaneResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_swimming_lane_with_options_async(request, runtime)

    def delete_swimming_lane_group_with_options(
        self,
        request: mse_20190531_models.DeleteSwimmingLaneGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteSwimmingLaneGroupResponse:
        """
        @summary Deletes a lane group.
        
        @param request: DeleteSwimmingLaneGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSwimmingLaneGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSwimmingLaneGroup',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteSwimmingLaneGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_swimming_lane_group_with_options_async(
        self,
        request: mse_20190531_models.DeleteSwimmingLaneGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteSwimmingLaneGroupResponse:
        """
        @summary Deletes a lane group.
        
        @param request: DeleteSwimmingLaneGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSwimmingLaneGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSwimmingLaneGroup',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteSwimmingLaneGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_swimming_lane_group(
        self,
        request: mse_20190531_models.DeleteSwimmingLaneGroupRequest,
    ) -> mse_20190531_models.DeleteSwimmingLaneGroupResponse:
        """
        @summary Deletes a lane group.
        
        @param request: DeleteSwimmingLaneGroupRequest
        @return: DeleteSwimmingLaneGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_swimming_lane_group_with_options(request, runtime)

    async def delete_swimming_lane_group_async(
        self,
        request: mse_20190531_models.DeleteSwimmingLaneGroupRequest,
    ) -> mse_20190531_models.DeleteSwimmingLaneGroupResponse:
        """
        @summary Deletes a lane group.
        
        @param request: DeleteSwimmingLaneGroupRequest
        @return: DeleteSwimmingLaneGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_swimming_lane_group_with_options_async(request, runtime)

    def delete_web_flow_rules_with_options(
        self,
        request: mse_20190531_models.DeleteWebFlowRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteWebFlowRulesResponse:
        """
        @summary 删除热点参数防护规则（HTTP 请求）
        
        @param request: DeleteWebFlowRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteWebFlowRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.ids):
            query['Ids'] = request.ids
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteWebFlowRules',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteWebFlowRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_web_flow_rules_with_options_async(
        self,
        request: mse_20190531_models.DeleteWebFlowRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteWebFlowRulesResponse:
        """
        @summary 删除热点参数防护规则（HTTP 请求）
        
        @param request: DeleteWebFlowRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteWebFlowRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.ids):
            query['Ids'] = request.ids
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteWebFlowRules',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteWebFlowRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_web_flow_rules(
        self,
        request: mse_20190531_models.DeleteWebFlowRulesRequest,
    ) -> mse_20190531_models.DeleteWebFlowRulesResponse:
        """
        @summary 删除热点参数防护规则（HTTP 请求）
        
        @param request: DeleteWebFlowRulesRequest
        @return: DeleteWebFlowRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_web_flow_rules_with_options(request, runtime)

    async def delete_web_flow_rules_async(
        self,
        request: mse_20190531_models.DeleteWebFlowRulesRequest,
    ) -> mse_20190531_models.DeleteWebFlowRulesResponse:
        """
        @summary 删除热点参数防护规则（HTTP 请求）
        
        @param request: DeleteWebFlowRulesRequest
        @return: DeleteWebFlowRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_web_flow_rules_with_options_async(request, runtime)

    def delete_znode_with_options(
        self,
        request: mse_20190531_models.DeleteZnodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteZnodeResponse:
        """
        @summary Deletes a ZooKeeper node.
        
        @param request: DeleteZnodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteZnodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.path):
            query['Path'] = request.path
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteZnode',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteZnodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_znode_with_options_async(
        self,
        request: mse_20190531_models.DeleteZnodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.DeleteZnodeResponse:
        """
        @summary Deletes a ZooKeeper node.
        
        @param request: DeleteZnodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteZnodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.path):
            query['Path'] = request.path
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteZnode',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.DeleteZnodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_znode(
        self,
        request: mse_20190531_models.DeleteZnodeRequest,
    ) -> mse_20190531_models.DeleteZnodeResponse:
        """
        @summary Deletes a ZooKeeper node.
        
        @param request: DeleteZnodeRequest
        @return: DeleteZnodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_znode_with_options(request, runtime)

    async def delete_znode_async(
        self,
        request: mse_20190531_models.DeleteZnodeRequest,
    ) -> mse_20190531_models.DeleteZnodeResponse:
        """
        @summary Deletes a ZooKeeper node.
        
        @param request: DeleteZnodeRequest
        @return: DeleteZnodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_znode_with_options_async(request, runtime)

    def enable_http_2with_options(
        self,
        request: mse_20190531_models.EnableHttp2Request,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.EnableHttp2Response:
        """
        @summary Enables HTTP/2 for negotiation between the server and client. The modification takes effect in one to two minutes.
        
        @param request: EnableHttp2Request
        @param runtime: runtime options for this request RuntimeOptions
        @return: EnableHttp2Response
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.enable_http_2):
            query['EnableHttp2'] = request.enable_http_2
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableHttp2',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.EnableHttp2Response(),
            self.call_api(params, req, runtime)
        )

    async def enable_http_2with_options_async(
        self,
        request: mse_20190531_models.EnableHttp2Request,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.EnableHttp2Response:
        """
        @summary Enables HTTP/2 for negotiation between the server and client. The modification takes effect in one to two minutes.
        
        @param request: EnableHttp2Request
        @param runtime: runtime options for this request RuntimeOptions
        @return: EnableHttp2Response
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.enable_http_2):
            query['EnableHttp2'] = request.enable_http_2
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableHttp2',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.EnableHttp2Response(),
            await self.call_api_async(params, req, runtime)
        )

    def enable_http_2(
        self,
        request: mse_20190531_models.EnableHttp2Request,
    ) -> mse_20190531_models.EnableHttp2Response:
        """
        @summary Enables HTTP/2 for negotiation between the server and client. The modification takes effect in one to two minutes.
        
        @param request: EnableHttp2Request
        @return: EnableHttp2Response
        """
        runtime = util_models.RuntimeOptions()
        return self.enable_http_2with_options(request, runtime)

    async def enable_http_2_async(
        self,
        request: mse_20190531_models.EnableHttp2Request,
    ) -> mse_20190531_models.EnableHttp2Response:
        """
        @summary Enables HTTP/2 for negotiation between the server and client. The modification takes effect in one to two minutes.
        
        @param request: EnableHttp2Request
        @return: EnableHttp2Response
        """
        runtime = util_models.RuntimeOptions()
        return await self.enable_http_2with_options_async(request, runtime)

    def enable_proxy_protocol_with_options(
        self,
        request: mse_20190531_models.EnableProxyProtocolRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.EnableProxyProtocolResponse:
        """
        @summary Enables the proxy protocol. When an NLB instance is used as an ingress, you cannot obtain the real IP address of the client if you do not enable the proxy protocol. After you enable the proxy protocol, non-proxy requests are not adversely affected.
        
        @param request: EnableProxyProtocolRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: EnableProxyProtocolResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.enable_proxy_protocol):
            query['EnableProxyProtocol'] = request.enable_proxy_protocol
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableProxyProtocol',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.EnableProxyProtocolResponse(),
            self.call_api(params, req, runtime)
        )

    async def enable_proxy_protocol_with_options_async(
        self,
        request: mse_20190531_models.EnableProxyProtocolRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.EnableProxyProtocolResponse:
        """
        @summary Enables the proxy protocol. When an NLB instance is used as an ingress, you cannot obtain the real IP address of the client if you do not enable the proxy protocol. After you enable the proxy protocol, non-proxy requests are not adversely affected.
        
        @param request: EnableProxyProtocolRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: EnableProxyProtocolResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.enable_proxy_protocol):
            query['EnableProxyProtocol'] = request.enable_proxy_protocol
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableProxyProtocol',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.EnableProxyProtocolResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def enable_proxy_protocol(
        self,
        request: mse_20190531_models.EnableProxyProtocolRequest,
    ) -> mse_20190531_models.EnableProxyProtocolResponse:
        """
        @summary Enables the proxy protocol. When an NLB instance is used as an ingress, you cannot obtain the real IP address of the client if you do not enable the proxy protocol. After you enable the proxy protocol, non-proxy requests are not adversely affected.
        
        @param request: EnableProxyProtocolRequest
        @return: EnableProxyProtocolResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.enable_proxy_protocol_with_options(request, runtime)

    async def enable_proxy_protocol_async(
        self,
        request: mse_20190531_models.EnableProxyProtocolRequest,
    ) -> mse_20190531_models.EnableProxyProtocolResponse:
        """
        @summary Enables the proxy protocol. When an NLB instance is used as an ingress, you cannot obtain the real IP address of the client if you do not enable the proxy protocol. After you enable the proxy protocol, non-proxy requests are not adversely affected.
        
        @param request: EnableProxyProtocolRequest
        @return: EnableProxyProtocolResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.enable_proxy_protocol_with_options_async(request, runtime)

    def export_nacos_config_with_options(
        self,
        request: mse_20190531_models.ExportNacosConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ExportNacosConfigResponse:
        """
        @summary Exports specified Nacos configurations.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ExportNacosConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportNacosConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.data_id):
            query['DataId'] = request.data_id
        if not UtilClient.is_unset(request.data_ids):
            query['DataIds'] = request.data_ids
        if not UtilClient.is_unset(request.group):
            query['Group'] = request.group
        if not UtilClient.is_unset(request.ids):
            query['Ids'] = request.ids
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportNacosConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ExportNacosConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def export_nacos_config_with_options_async(
        self,
        request: mse_20190531_models.ExportNacosConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ExportNacosConfigResponse:
        """
        @summary Exports specified Nacos configurations.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ExportNacosConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportNacosConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.data_id):
            query['DataId'] = request.data_id
        if not UtilClient.is_unset(request.data_ids):
            query['DataIds'] = request.data_ids
        if not UtilClient.is_unset(request.group):
            query['Group'] = request.group
        if not UtilClient.is_unset(request.ids):
            query['Ids'] = request.ids
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportNacosConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ExportNacosConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def export_nacos_config(
        self,
        request: mse_20190531_models.ExportNacosConfigRequest,
    ) -> mse_20190531_models.ExportNacosConfigResponse:
        """
        @summary Exports specified Nacos configurations.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ExportNacosConfigRequest
        @return: ExportNacosConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.export_nacos_config_with_options(request, runtime)

    async def export_nacos_config_async(
        self,
        request: mse_20190531_models.ExportNacosConfigRequest,
    ) -> mse_20190531_models.ExportNacosConfigResponse:
        """
        @summary Exports specified Nacos configurations.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ExportNacosConfigRequest
        @return: ExportNacosConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.export_nacos_config_with_options_async(request, runtime)

    def export_zookeeper_data_with_options(
        self,
        request: mse_20190531_models.ExportZookeeperDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ExportZookeeperDataResponse:
        """
        @summary Initiates a task to export ZooKeeper data.
        
        @description Only one task can run at a time.
        
        @param request: ExportZookeeperDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportZookeeperDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.export_type):
            query['ExportType'] = request.export_type
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportZookeeperData',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ExportZookeeperDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def export_zookeeper_data_with_options_async(
        self,
        request: mse_20190531_models.ExportZookeeperDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ExportZookeeperDataResponse:
        """
        @summary Initiates a task to export ZooKeeper data.
        
        @description Only one task can run at a time.
        
        @param request: ExportZookeeperDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportZookeeperDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.export_type):
            query['ExportType'] = request.export_type
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportZookeeperData',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ExportZookeeperDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def export_zookeeper_data(
        self,
        request: mse_20190531_models.ExportZookeeperDataRequest,
    ) -> mse_20190531_models.ExportZookeeperDataResponse:
        """
        @summary Initiates a task to export ZooKeeper data.
        
        @description Only one task can run at a time.
        
        @param request: ExportZookeeperDataRequest
        @return: ExportZookeeperDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.export_zookeeper_data_with_options(request, runtime)

    async def export_zookeeper_data_async(
        self,
        request: mse_20190531_models.ExportZookeeperDataRequest,
    ) -> mse_20190531_models.ExportZookeeperDataResponse:
        """
        @summary Initiates a task to export ZooKeeper data.
        
        @description Only one task can run at a time.
        
        @param request: ExportZookeeperDataRequest
        @return: ExportZookeeperDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.export_zookeeper_data_with_options_async(request, runtime)

    def fetch_lossless_rule_list_with_options(
        self,
        request: mse_20190531_models.FetchLosslessRuleListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.FetchLosslessRuleListResponse:
        """
        @summary Obtains the rules for graceful start and shutdown.
        
        @description You can call this operation to query the rules for graceful start and shutdown.
        
        @param request: FetchLosslessRuleListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: FetchLosslessRuleListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='FetchLosslessRuleList',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.FetchLosslessRuleListResponse(),
            self.call_api(params, req, runtime)
        )

    async def fetch_lossless_rule_list_with_options_async(
        self,
        request: mse_20190531_models.FetchLosslessRuleListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.FetchLosslessRuleListResponse:
        """
        @summary Obtains the rules for graceful start and shutdown.
        
        @description You can call this operation to query the rules for graceful start and shutdown.
        
        @param request: FetchLosslessRuleListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: FetchLosslessRuleListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='FetchLosslessRuleList',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.FetchLosslessRuleListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def fetch_lossless_rule_list(
        self,
        request: mse_20190531_models.FetchLosslessRuleListRequest,
    ) -> mse_20190531_models.FetchLosslessRuleListResponse:
        """
        @summary Obtains the rules for graceful start and shutdown.
        
        @description You can call this operation to query the rules for graceful start and shutdown.
        
        @param request: FetchLosslessRuleListRequest
        @return: FetchLosslessRuleListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.fetch_lossless_rule_list_with_options(request, runtime)

    async def fetch_lossless_rule_list_async(
        self,
        request: mse_20190531_models.FetchLosslessRuleListRequest,
    ) -> mse_20190531_models.FetchLosslessRuleListResponse:
        """
        @summary Obtains the rules for graceful start and shutdown.
        
        @description You can call this operation to query the rules for graceful start and shutdown.
        
        @param request: FetchLosslessRuleListRequest
        @return: FetchLosslessRuleListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.fetch_lossless_rule_list_with_options_async(request, runtime)

    def gateway_black_white_list_with_options(
        self,
        tmp_req: mse_20190531_models.GatewayBlackWhiteListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GatewayBlackWhiteListResponse:
        """
        @summary Queries a list of blacklists and whitelists of a gateway.
        
        @param tmp_req: GatewayBlackWhiteListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GatewayBlackWhiteListResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.GatewayBlackWhiteListShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.filter_params):
            request.filter_params_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.filter_params, 'FilterParams', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.desc_sort):
            query['DescSort'] = request.desc_sort
        if not UtilClient.is_unset(request.filter_params_shrink):
            query['FilterParams'] = request.filter_params_shrink
        if not UtilClient.is_unset(request.order_item):
            query['OrderItem'] = request.order_item
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GatewayBlackWhiteList',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GatewayBlackWhiteListResponse(),
            self.call_api(params, req, runtime)
        )

    async def gateway_black_white_list_with_options_async(
        self,
        tmp_req: mse_20190531_models.GatewayBlackWhiteListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GatewayBlackWhiteListResponse:
        """
        @summary Queries a list of blacklists and whitelists of a gateway.
        
        @param tmp_req: GatewayBlackWhiteListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GatewayBlackWhiteListResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.GatewayBlackWhiteListShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.filter_params):
            request.filter_params_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.filter_params, 'FilterParams', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.desc_sort):
            query['DescSort'] = request.desc_sort
        if not UtilClient.is_unset(request.filter_params_shrink):
            query['FilterParams'] = request.filter_params_shrink
        if not UtilClient.is_unset(request.order_item):
            query['OrderItem'] = request.order_item
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GatewayBlackWhiteList',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GatewayBlackWhiteListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def gateway_black_white_list(
        self,
        request: mse_20190531_models.GatewayBlackWhiteListRequest,
    ) -> mse_20190531_models.GatewayBlackWhiteListResponse:
        """
        @summary Queries a list of blacklists and whitelists of a gateway.
        
        @param request: GatewayBlackWhiteListRequest
        @return: GatewayBlackWhiteListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.gateway_black_white_list_with_options(request, runtime)

    async def gateway_black_white_list_async(
        self,
        request: mse_20190531_models.GatewayBlackWhiteListRequest,
    ) -> mse_20190531_models.GatewayBlackWhiteListResponse:
        """
        @summary Queries a list of blacklists and whitelists of a gateway.
        
        @param request: GatewayBlackWhiteListRequest
        @return: GatewayBlackWhiteListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.gateway_black_white_list_with_options_async(request, runtime)

    def get_app_message_queue_route_with_options(
        self,
        request: mse_20190531_models.GetAppMessageQueueRouteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetAppMessageQueueRouteResponse:
        """
        @summary Queries information about canary release for messaging of an application.
        
        @param request: GetAppMessageQueueRouteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetAppMessageQueueRouteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetAppMessageQueueRoute',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetAppMessageQueueRouteResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_app_message_queue_route_with_options_async(
        self,
        request: mse_20190531_models.GetAppMessageQueueRouteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetAppMessageQueueRouteResponse:
        """
        @summary Queries information about canary release for messaging of an application.
        
        @param request: GetAppMessageQueueRouteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetAppMessageQueueRouteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetAppMessageQueueRoute',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetAppMessageQueueRouteResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_app_message_queue_route(
        self,
        request: mse_20190531_models.GetAppMessageQueueRouteRequest,
    ) -> mse_20190531_models.GetAppMessageQueueRouteResponse:
        """
        @summary Queries information about canary release for messaging of an application.
        
        @param request: GetAppMessageQueueRouteRequest
        @return: GetAppMessageQueueRouteResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_app_message_queue_route_with_options(request, runtime)

    async def get_app_message_queue_route_async(
        self,
        request: mse_20190531_models.GetAppMessageQueueRouteRequest,
    ) -> mse_20190531_models.GetAppMessageQueueRouteResponse:
        """
        @summary Queries information about canary release for messaging of an application.
        
        @param request: GetAppMessageQueueRouteRequest
        @return: GetAppMessageQueueRouteResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_app_message_queue_route_with_options_async(request, runtime)

    def get_application_instance_list_with_options(
        self,
        request: mse_20190531_models.GetApplicationInstanceListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetApplicationInstanceListResponse:
        """
        @summary Queries the list of microservice application instances.
        
        @param request: GetApplicationInstanceListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetApplicationInstanceListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetApplicationInstanceList',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetApplicationInstanceListResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_application_instance_list_with_options_async(
        self,
        request: mse_20190531_models.GetApplicationInstanceListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetApplicationInstanceListResponse:
        """
        @summary Queries the list of microservice application instances.
        
        @param request: GetApplicationInstanceListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetApplicationInstanceListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetApplicationInstanceList',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetApplicationInstanceListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_application_instance_list(
        self,
        request: mse_20190531_models.GetApplicationInstanceListRequest,
    ) -> mse_20190531_models.GetApplicationInstanceListResponse:
        """
        @summary Queries the list of microservice application instances.
        
        @param request: GetApplicationInstanceListRequest
        @return: GetApplicationInstanceListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_application_instance_list_with_options(request, runtime)

    async def get_application_instance_list_async(
        self,
        request: mse_20190531_models.GetApplicationInstanceListRequest,
    ) -> mse_20190531_models.GetApplicationInstanceListResponse:
        """
        @summary Queries the list of microservice application instances.
        
        @param request: GetApplicationInstanceListRequest
        @return: GetApplicationInstanceListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_application_instance_list_with_options_async(request, runtime)

    def get_application_list_with_options(
        self,
        tmp_req: mse_20190531_models.GetApplicationListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetApplicationListResponse:
        """
        @summary Obtains the list of applications.
        
        @param tmp_req: GetApplicationListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetApplicationListResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.GetApplicationListShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.tags):
            request.tags_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.tags, 'Tags', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.language):
            query['Language'] = request.language
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.sentinel_enable):
            query['SentinelEnable'] = request.sentinel_enable
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.switch_enable):
            query['SwitchEnable'] = request.switch_enable
        if not UtilClient.is_unset(request.tags_shrink):
            query['Tags'] = request.tags_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetApplicationList',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetApplicationListResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_application_list_with_options_async(
        self,
        tmp_req: mse_20190531_models.GetApplicationListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetApplicationListResponse:
        """
        @summary Obtains the list of applications.
        
        @param tmp_req: GetApplicationListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetApplicationListResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.GetApplicationListShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.tags):
            request.tags_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.tags, 'Tags', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.language):
            query['Language'] = request.language
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.sentinel_enable):
            query['SentinelEnable'] = request.sentinel_enable
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.switch_enable):
            query['SwitchEnable'] = request.switch_enable
        if not UtilClient.is_unset(request.tags_shrink):
            query['Tags'] = request.tags_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetApplicationList',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetApplicationListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_application_list(
        self,
        request: mse_20190531_models.GetApplicationListRequest,
    ) -> mse_20190531_models.GetApplicationListResponse:
        """
        @summary Obtains the list of applications.
        
        @param request: GetApplicationListRequest
        @return: GetApplicationListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_application_list_with_options(request, runtime)

    async def get_application_list_async(
        self,
        request: mse_20190531_models.GetApplicationListRequest,
    ) -> mse_20190531_models.GetApplicationListResponse:
        """
        @summary Obtains the list of applications.
        
        @param request: GetApplicationListRequest
        @return: GetApplicationListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_application_list_with_options_async(request, runtime)

    def get_black_white_list_with_options(
        self,
        request: mse_20190531_models.GetBlackWhiteListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetBlackWhiteListResponse:
        """
        @deprecated OpenAPI GetBlackWhiteList is deprecated, please use mse::2019-05-31::GatewayBlackWhiteList instead.
        
        @summary Queries the blacklist or whitelist of a gateway.
        
        @param request: GetBlackWhiteListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetBlackWhiteListResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.is_white):
            query['IsWhite'] = request.is_white
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetBlackWhiteList',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetBlackWhiteListResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_black_white_list_with_options_async(
        self,
        request: mse_20190531_models.GetBlackWhiteListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetBlackWhiteListResponse:
        """
        @deprecated OpenAPI GetBlackWhiteList is deprecated, please use mse::2019-05-31::GatewayBlackWhiteList instead.
        
        @summary Queries the blacklist or whitelist of a gateway.
        
        @param request: GetBlackWhiteListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetBlackWhiteListResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.is_white):
            query['IsWhite'] = request.is_white
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetBlackWhiteList',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetBlackWhiteListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_black_white_list(
        self,
        request: mse_20190531_models.GetBlackWhiteListRequest,
    ) -> mse_20190531_models.GetBlackWhiteListResponse:
        """
        @deprecated OpenAPI GetBlackWhiteList is deprecated, please use mse::2019-05-31::GatewayBlackWhiteList instead.
        
        @summary Queries the blacklist or whitelist of a gateway.
        
        @param request: GetBlackWhiteListRequest
        @return: GetBlackWhiteListResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.get_black_white_list_with_options(request, runtime)

    async def get_black_white_list_async(
        self,
        request: mse_20190531_models.GetBlackWhiteListRequest,
    ) -> mse_20190531_models.GetBlackWhiteListResponse:
        """
        @deprecated OpenAPI GetBlackWhiteList is deprecated, please use mse::2019-05-31::GatewayBlackWhiteList instead.
        
        @summary Queries the blacklist or whitelist of a gateway.
        
        @param request: GetBlackWhiteListRequest
        @return: GetBlackWhiteListResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_black_white_list_with_options_async(request, runtime)

    def get_engine_namepace_with_options(
        self,
        request: mse_20190531_models.GetEngineNamepaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetEngineNamepaceResponse:
        """
        @summary Queries the namespaces of a Nacos instance.
        
        @param request: GetEngineNamepaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetEngineNamepaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetEngineNamepace',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetEngineNamepaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_engine_namepace_with_options_async(
        self,
        request: mse_20190531_models.GetEngineNamepaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetEngineNamepaceResponse:
        """
        @summary Queries the namespaces of a Nacos instance.
        
        @param request: GetEngineNamepaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetEngineNamepaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetEngineNamepace',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetEngineNamepaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_engine_namepace(
        self,
        request: mse_20190531_models.GetEngineNamepaceRequest,
    ) -> mse_20190531_models.GetEngineNamepaceResponse:
        """
        @summary Queries the namespaces of a Nacos instance.
        
        @param request: GetEngineNamepaceRequest
        @return: GetEngineNamepaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_engine_namepace_with_options(request, runtime)

    async def get_engine_namepace_async(
        self,
        request: mse_20190531_models.GetEngineNamepaceRequest,
    ) -> mse_20190531_models.GetEngineNamepaceResponse:
        """
        @summary Queries the namespaces of a Nacos instance.
        
        @param request: GetEngineNamepaceRequest
        @return: GetEngineNamepaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_engine_namepace_with_options_async(request, runtime)

    def get_gateway_with_options(
        self,
        request: mse_20190531_models.GetGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetGatewayResponse:
        """
        @summary Obtains the basic information about a gateway, such as the virtual private cloud (VPC) and vSwitch to which the gateway belongs.
        
        @param request: GetGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGateway',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_gateway_with_options_async(
        self,
        request: mse_20190531_models.GetGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetGatewayResponse:
        """
        @summary Obtains the basic information about a gateway, such as the virtual private cloud (VPC) and vSwitch to which the gateway belongs.
        
        @param request: GetGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGateway',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_gateway(
        self,
        request: mse_20190531_models.GetGatewayRequest,
    ) -> mse_20190531_models.GetGatewayResponse:
        """
        @summary Obtains the basic information about a gateway, such as the virtual private cloud (VPC) and vSwitch to which the gateway belongs.
        
        @param request: GetGatewayRequest
        @return: GetGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_gateway_with_options(request, runtime)

    async def get_gateway_async(
        self,
        request: mse_20190531_models.GetGatewayRequest,
    ) -> mse_20190531_models.GetGatewayResponse:
        """
        @summary Obtains the basic information about a gateway, such as the virtual private cloud (VPC) and vSwitch to which the gateway belongs.
        
        @param request: GetGatewayRequest
        @return: GetGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_gateway_with_options_async(request, runtime)

    def get_gateway_auth_consumer_detail_with_options(
        self,
        request: mse_20190531_models.GetGatewayAuthConsumerDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetGatewayAuthConsumerDetailResponse:
        """
        @summary Queries the details of the consumer on which a gateway performs authentication operations.
        
        @param request: GetGatewayAuthConsumerDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGatewayAuthConsumerDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGatewayAuthConsumerDetail',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetGatewayAuthConsumerDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_gateway_auth_consumer_detail_with_options_async(
        self,
        request: mse_20190531_models.GetGatewayAuthConsumerDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetGatewayAuthConsumerDetailResponse:
        """
        @summary Queries the details of the consumer on which a gateway performs authentication operations.
        
        @param request: GetGatewayAuthConsumerDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGatewayAuthConsumerDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGatewayAuthConsumerDetail',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetGatewayAuthConsumerDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_gateway_auth_consumer_detail(
        self,
        request: mse_20190531_models.GetGatewayAuthConsumerDetailRequest,
    ) -> mse_20190531_models.GetGatewayAuthConsumerDetailResponse:
        """
        @summary Queries the details of the consumer on which a gateway performs authentication operations.
        
        @param request: GetGatewayAuthConsumerDetailRequest
        @return: GetGatewayAuthConsumerDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_gateway_auth_consumer_detail_with_options(request, runtime)

    async def get_gateway_auth_consumer_detail_async(
        self,
        request: mse_20190531_models.GetGatewayAuthConsumerDetailRequest,
    ) -> mse_20190531_models.GetGatewayAuthConsumerDetailResponse:
        """
        @summary Queries the details of the consumer on which a gateway performs authentication operations.
        
        @param request: GetGatewayAuthConsumerDetailRequest
        @return: GetGatewayAuthConsumerDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_gateway_auth_consumer_detail_with_options_async(request, runtime)

    def get_gateway_auth_detail_with_options(
        self,
        request: mse_20190531_models.GetGatewayAuthDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetGatewayAuthDetailResponse:
        """
        @summary 查询网关认证详情
        
        @param request: GetGatewayAuthDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGatewayAuthDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGatewayAuthDetail',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetGatewayAuthDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_gateway_auth_detail_with_options_async(
        self,
        request: mse_20190531_models.GetGatewayAuthDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetGatewayAuthDetailResponse:
        """
        @summary 查询网关认证详情
        
        @param request: GetGatewayAuthDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGatewayAuthDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGatewayAuthDetail',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetGatewayAuthDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_gateway_auth_detail(
        self,
        request: mse_20190531_models.GetGatewayAuthDetailRequest,
    ) -> mse_20190531_models.GetGatewayAuthDetailResponse:
        """
        @summary 查询网关认证详情
        
        @param request: GetGatewayAuthDetailRequest
        @return: GetGatewayAuthDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_gateway_auth_detail_with_options(request, runtime)

    async def get_gateway_auth_detail_async(
        self,
        request: mse_20190531_models.GetGatewayAuthDetailRequest,
    ) -> mse_20190531_models.GetGatewayAuthDetailResponse:
        """
        @summary 查询网关认证详情
        
        @param request: GetGatewayAuthDetailRequest
        @return: GetGatewayAuthDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_gateway_auth_detail_with_options_async(request, runtime)

    def get_gateway_config_with_options(
        self,
        request: mse_20190531_models.GetGatewayConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetGatewayConfigResponse:
        """
        @summary 获取网关全局配置
        
        @param request: GetGatewayConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGatewayConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGatewayConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetGatewayConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_gateway_config_with_options_async(
        self,
        request: mse_20190531_models.GetGatewayConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetGatewayConfigResponse:
        """
        @summary 获取网关全局配置
        
        @param request: GetGatewayConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGatewayConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGatewayConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetGatewayConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_gateway_config(
        self,
        request: mse_20190531_models.GetGatewayConfigRequest,
    ) -> mse_20190531_models.GetGatewayConfigResponse:
        """
        @summary 获取网关全局配置
        
        @param request: GetGatewayConfigRequest
        @return: GetGatewayConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_gateway_config_with_options(request, runtime)

    async def get_gateway_config_async(
        self,
        request: mse_20190531_models.GetGatewayConfigRequest,
    ) -> mse_20190531_models.GetGatewayConfigResponse:
        """
        @summary 获取网关全局配置
        
        @param request: GetGatewayConfigRequest
        @return: GetGatewayConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_gateway_config_with_options_async(request, runtime)

    def get_gateway_domain_detail_with_options(
        self,
        request: mse_20190531_models.GetGatewayDomainDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetGatewayDomainDetailResponse:
        """
        @summary Queries the details of a domain name associated with a gateway.
        
        @param request: GetGatewayDomainDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGatewayDomainDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGatewayDomainDetail',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetGatewayDomainDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_gateway_domain_detail_with_options_async(
        self,
        request: mse_20190531_models.GetGatewayDomainDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetGatewayDomainDetailResponse:
        """
        @summary Queries the details of a domain name associated with a gateway.
        
        @param request: GetGatewayDomainDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGatewayDomainDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGatewayDomainDetail',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetGatewayDomainDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_gateway_domain_detail(
        self,
        request: mse_20190531_models.GetGatewayDomainDetailRequest,
    ) -> mse_20190531_models.GetGatewayDomainDetailResponse:
        """
        @summary Queries the details of a domain name associated with a gateway.
        
        @param request: GetGatewayDomainDetailRequest
        @return: GetGatewayDomainDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_gateway_domain_detail_with_options(request, runtime)

    async def get_gateway_domain_detail_async(
        self,
        request: mse_20190531_models.GetGatewayDomainDetailRequest,
    ) -> mse_20190531_models.GetGatewayDomainDetailResponse:
        """
        @summary Queries the details of a domain name associated with a gateway.
        
        @param request: GetGatewayDomainDetailRequest
        @return: GetGatewayDomainDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_gateway_domain_detail_with_options_async(request, runtime)

    def get_gateway_option_with_options(
        self,
        request: mse_20190531_models.GetGatewayOptionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetGatewayOptionResponse:
        """
        @summary Obtains the global parameters of a gateway.
        
        @param request: GetGatewayOptionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGatewayOptionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGatewayOption',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetGatewayOptionResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_gateway_option_with_options_async(
        self,
        request: mse_20190531_models.GetGatewayOptionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetGatewayOptionResponse:
        """
        @summary Obtains the global parameters of a gateway.
        
        @param request: GetGatewayOptionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGatewayOptionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGatewayOption',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetGatewayOptionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_gateway_option(
        self,
        request: mse_20190531_models.GetGatewayOptionRequest,
    ) -> mse_20190531_models.GetGatewayOptionResponse:
        """
        @summary Obtains the global parameters of a gateway.
        
        @param request: GetGatewayOptionRequest
        @return: GetGatewayOptionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_gateway_option_with_options(request, runtime)

    async def get_gateway_option_async(
        self,
        request: mse_20190531_models.GetGatewayOptionRequest,
    ) -> mse_20190531_models.GetGatewayOptionResponse:
        """
        @summary Obtains the global parameters of a gateway.
        
        @param request: GetGatewayOptionRequest
        @return: GetGatewayOptionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_gateway_option_with_options_async(request, runtime)

    def get_gateway_route_detail_with_options(
        self,
        request: mse_20190531_models.GetGatewayRouteDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetGatewayRouteDetailResponse:
        """
        @summary Queries the details of a route for a gateway.
        
        @param request: GetGatewayRouteDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGatewayRouteDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.route_id):
            query['RouteId'] = request.route_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGatewayRouteDetail',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetGatewayRouteDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_gateway_route_detail_with_options_async(
        self,
        request: mse_20190531_models.GetGatewayRouteDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetGatewayRouteDetailResponse:
        """
        @summary Queries the details of a route for a gateway.
        
        @param request: GetGatewayRouteDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGatewayRouteDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.route_id):
            query['RouteId'] = request.route_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGatewayRouteDetail',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetGatewayRouteDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_gateway_route_detail(
        self,
        request: mse_20190531_models.GetGatewayRouteDetailRequest,
    ) -> mse_20190531_models.GetGatewayRouteDetailResponse:
        """
        @summary Queries the details of a route for a gateway.
        
        @param request: GetGatewayRouteDetailRequest
        @return: GetGatewayRouteDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_gateway_route_detail_with_options(request, runtime)

    async def get_gateway_route_detail_async(
        self,
        request: mse_20190531_models.GetGatewayRouteDetailRequest,
    ) -> mse_20190531_models.GetGatewayRouteDetailResponse:
        """
        @summary Queries the details of a route for a gateway.
        
        @param request: GetGatewayRouteDetailRequest
        @return: GetGatewayRouteDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_gateway_route_detail_with_options_async(request, runtime)

    def get_gateway_service_detail_with_options(
        self,
        request: mse_20190531_models.GetGatewayServiceDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetGatewayServiceDetailResponse:
        """
        @summary Queries the details of a service.
        
        @param request: GetGatewayServiceDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGatewayServiceDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGatewayServiceDetail',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetGatewayServiceDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_gateway_service_detail_with_options_async(
        self,
        request: mse_20190531_models.GetGatewayServiceDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetGatewayServiceDetailResponse:
        """
        @summary Queries the details of a service.
        
        @param request: GetGatewayServiceDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGatewayServiceDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.service_id):
            query['ServiceId'] = request.service_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGatewayServiceDetail',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetGatewayServiceDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_gateway_service_detail(
        self,
        request: mse_20190531_models.GetGatewayServiceDetailRequest,
    ) -> mse_20190531_models.GetGatewayServiceDetailResponse:
        """
        @summary Queries the details of a service.
        
        @param request: GetGatewayServiceDetailRequest
        @return: GetGatewayServiceDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_gateway_service_detail_with_options(request, runtime)

    async def get_gateway_service_detail_async(
        self,
        request: mse_20190531_models.GetGatewayServiceDetailRequest,
    ) -> mse_20190531_models.GetGatewayServiceDetailResponse:
        """
        @summary Queries the details of a service.
        
        @param request: GetGatewayServiceDetailRequest
        @return: GetGatewayServiceDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_gateway_service_detail_with_options_async(request, runtime)

    def get_governance_kubernetes_cluster_with_options(
        self,
        request: mse_20190531_models.GetGovernanceKubernetesClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetGovernanceKubernetesClusterResponse:
        """
        @summary Queries the information about a Container Service for Kubernetes (ACK) cluster for which Microservices Governance is enabled.
        
        @param request: GetGovernanceKubernetesClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGovernanceKubernetesClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGovernanceKubernetesCluster',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetGovernanceKubernetesClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_governance_kubernetes_cluster_with_options_async(
        self,
        request: mse_20190531_models.GetGovernanceKubernetesClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetGovernanceKubernetesClusterResponse:
        """
        @summary Queries the information about a Container Service for Kubernetes (ACK) cluster for which Microservices Governance is enabled.
        
        @param request: GetGovernanceKubernetesClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetGovernanceKubernetesClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetGovernanceKubernetesCluster',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetGovernanceKubernetesClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_governance_kubernetes_cluster(
        self,
        request: mse_20190531_models.GetGovernanceKubernetesClusterRequest,
    ) -> mse_20190531_models.GetGovernanceKubernetesClusterResponse:
        """
        @summary Queries the information about a Container Service for Kubernetes (ACK) cluster for which Microservices Governance is enabled.
        
        @param request: GetGovernanceKubernetesClusterRequest
        @return: GetGovernanceKubernetesClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_governance_kubernetes_cluster_with_options(request, runtime)

    async def get_governance_kubernetes_cluster_async(
        self,
        request: mse_20190531_models.GetGovernanceKubernetesClusterRequest,
    ) -> mse_20190531_models.GetGovernanceKubernetesClusterResponse:
        """
        @summary Queries the information about a Container Service for Kubernetes (ACK) cluster for which Microservices Governance is enabled.
        
        @param request: GetGovernanceKubernetesClusterRequest
        @return: GetGovernanceKubernetesClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_governance_kubernetes_cluster_with_options_async(request, runtime)

    def get_image_with_options(
        self,
        request: mse_20190531_models.GetImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetImageResponse:
        """
        @summary Queries the maximum version number to which the current version can be upgraded.
        
        @param request: GetImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.version_code):
            query['VersionCode'] = request.version_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetImage',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetImageResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_image_with_options_async(
        self,
        request: mse_20190531_models.GetImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetImageResponse:
        """
        @summary Queries the maximum version number to which the current version can be upgraded.
        
        @param request: GetImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.version_code):
            query['VersionCode'] = request.version_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetImage',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetImageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_image(
        self,
        request: mse_20190531_models.GetImageRequest,
    ) -> mse_20190531_models.GetImageResponse:
        """
        @summary Queries the maximum version number to which the current version can be upgraded.
        
        @param request: GetImageRequest
        @return: GetImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_image_with_options(request, runtime)

    async def get_image_async(
        self,
        request: mse_20190531_models.GetImageRequest,
    ) -> mse_20190531_models.GetImageResponse:
        """
        @summary Queries the maximum version number to which the current version can be upgraded.
        
        @param request: GetImageRequest
        @return: GetImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_image_with_options_async(request, runtime)

    def get_import_file_url_with_options(
        self,
        request: mse_20190531_models.GetImportFileUrlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetImportFileUrlResponse:
        """
        @summary Obtains the URL that is used to upload a configuration file when you import the configuration file into a Microservices Engine (MSE) Nacos instance.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).\\n
        
        @param request: GetImportFileUrlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetImportFileUrlResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.content_type):
            query['ContentType'] = request.content_type
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetImportFileUrl',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetImportFileUrlResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_import_file_url_with_options_async(
        self,
        request: mse_20190531_models.GetImportFileUrlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetImportFileUrlResponse:
        """
        @summary Obtains the URL that is used to upload a configuration file when you import the configuration file into a Microservices Engine (MSE) Nacos instance.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).\\n
        
        @param request: GetImportFileUrlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetImportFileUrlResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.content_type):
            query['ContentType'] = request.content_type
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetImportFileUrl',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetImportFileUrlResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_import_file_url(
        self,
        request: mse_20190531_models.GetImportFileUrlRequest,
    ) -> mse_20190531_models.GetImportFileUrlResponse:
        """
        @summary Obtains the URL that is used to upload a configuration file when you import the configuration file into a Microservices Engine (MSE) Nacos instance.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).\\n
        
        @param request: GetImportFileUrlRequest
        @return: GetImportFileUrlResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_import_file_url_with_options(request, runtime)

    async def get_import_file_url_async(
        self,
        request: mse_20190531_models.GetImportFileUrlRequest,
    ) -> mse_20190531_models.GetImportFileUrlResponse:
        """
        @summary Obtains the URL that is used to upload a configuration file when you import the configuration file into a Microservices Engine (MSE) Nacos instance.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).\\n
        
        @param request: GetImportFileUrlRequest
        @return: GetImportFileUrlResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_import_file_url_with_options_async(request, runtime)

    def get_kubernetes_source_with_options(
        self,
        request: mse_20190531_models.GetKubernetesSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetKubernetesSourceResponse:
        """
        @summary Obtains sources of all Container Service for Kubernetes (ACK) services in a gateway.
        
        @param request: GetKubernetesSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetKubernetesSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.is_all):
            query['IsAll'] = request.is_all
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetKubernetesSource',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetKubernetesSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_kubernetes_source_with_options_async(
        self,
        request: mse_20190531_models.GetKubernetesSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetKubernetesSourceResponse:
        """
        @summary Obtains sources of all Container Service for Kubernetes (ACK) services in a gateway.
        
        @param request: GetKubernetesSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetKubernetesSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.is_all):
            query['IsAll'] = request.is_all
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetKubernetesSource',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetKubernetesSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_kubernetes_source(
        self,
        request: mse_20190531_models.GetKubernetesSourceRequest,
    ) -> mse_20190531_models.GetKubernetesSourceResponse:
        """
        @summary Obtains sources of all Container Service for Kubernetes (ACK) services in a gateway.
        
        @param request: GetKubernetesSourceRequest
        @return: GetKubernetesSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_kubernetes_source_with_options(request, runtime)

    async def get_kubernetes_source_async(
        self,
        request: mse_20190531_models.GetKubernetesSourceRequest,
    ) -> mse_20190531_models.GetKubernetesSourceResponse:
        """
        @summary Obtains sources of all Container Service for Kubernetes (ACK) services in a gateway.
        
        @param request: GetKubernetesSourceRequest
        @return: GetKubernetesSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_kubernetes_source_with_options_async(request, runtime)

    def get_locality_rule_with_options(
        self,
        request: mse_20190531_models.GetLocalityRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetLocalityRuleResponse:
        """
        @summary 获取同AZ路由规则
        
        @param request: GetLocalityRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLocalityRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLocalityRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetLocalityRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_locality_rule_with_options_async(
        self,
        request: mse_20190531_models.GetLocalityRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetLocalityRuleResponse:
        """
        @summary 获取同AZ路由规则
        
        @param request: GetLocalityRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLocalityRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLocalityRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetLocalityRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_locality_rule(
        self,
        request: mse_20190531_models.GetLocalityRuleRequest,
    ) -> mse_20190531_models.GetLocalityRuleResponse:
        """
        @summary 获取同AZ路由规则
        
        @param request: GetLocalityRuleRequest
        @return: GetLocalityRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_locality_rule_with_options(request, runtime)

    async def get_locality_rule_async(
        self,
        request: mse_20190531_models.GetLocalityRuleRequest,
    ) -> mse_20190531_models.GetLocalityRuleResponse:
        """
        @summary 获取同AZ路由规则
        
        @param request: GetLocalityRuleRequest
        @return: GetLocalityRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_locality_rule_with_options_async(request, runtime)

    def get_lossless_rule_by_app_with_options(
        self,
        request: mse_20190531_models.GetLosslessRuleByAppRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetLosslessRuleByAppResponse:
        """
        @summary Queries the rules for graceful start and shutdown of an application.
        
        @description You can call this operation to query the rules for graceful start and shutdown of an application.
        You can query the rules for graceful start and shutdown of an application preferentially by using the AppId parameter.
        If the AppId parameter is left empty, you can use the RegionId, Namespace, and AppName parameters to query the rules for graceful start and shutdown of an application.
        
        @param request: GetLosslessRuleByAppRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLosslessRuleByAppResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLosslessRuleByApp',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetLosslessRuleByAppResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_lossless_rule_by_app_with_options_async(
        self,
        request: mse_20190531_models.GetLosslessRuleByAppRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetLosslessRuleByAppResponse:
        """
        @summary Queries the rules for graceful start and shutdown of an application.
        
        @description You can call this operation to query the rules for graceful start and shutdown of an application.
        You can query the rules for graceful start and shutdown of an application preferentially by using the AppId parameter.
        If the AppId parameter is left empty, you can use the RegionId, Namespace, and AppName parameters to query the rules for graceful start and shutdown of an application.
        
        @param request: GetLosslessRuleByAppRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetLosslessRuleByAppResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetLosslessRuleByApp',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetLosslessRuleByAppResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_lossless_rule_by_app(
        self,
        request: mse_20190531_models.GetLosslessRuleByAppRequest,
    ) -> mse_20190531_models.GetLosslessRuleByAppResponse:
        """
        @summary Queries the rules for graceful start and shutdown of an application.
        
        @description You can call this operation to query the rules for graceful start and shutdown of an application.
        You can query the rules for graceful start and shutdown of an application preferentially by using the AppId parameter.
        If the AppId parameter is left empty, you can use the RegionId, Namespace, and AppName parameters to query the rules for graceful start and shutdown of an application.
        
        @param request: GetLosslessRuleByAppRequest
        @return: GetLosslessRuleByAppResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_lossless_rule_by_app_with_options(request, runtime)

    async def get_lossless_rule_by_app_async(
        self,
        request: mse_20190531_models.GetLosslessRuleByAppRequest,
    ) -> mse_20190531_models.GetLosslessRuleByAppResponse:
        """
        @summary Queries the rules for graceful start and shutdown of an application.
        
        @description You can call this operation to query the rules for graceful start and shutdown of an application.
        You can query the rules for graceful start and shutdown of an application preferentially by using the AppId parameter.
        If the AppId parameter is left empty, you can use the RegionId, Namespace, and AppName parameters to query the rules for graceful start and shutdown of an application.
        
        @param request: GetLosslessRuleByAppRequest
        @return: GetLosslessRuleByAppResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_lossless_rule_by_app_with_options_async(request, runtime)

    def get_mse_feature_switch_with_options(
        self,
        request: mse_20190531_models.GetMseFeatureSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetMseFeatureSwitchResponse:
        """
        @summary Queries the information about the MSE feature switch.
        
        @param request: GetMseFeatureSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMseFeatureSwitchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMseFeatureSwitch',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetMseFeatureSwitchResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_mse_feature_switch_with_options_async(
        self,
        request: mse_20190531_models.GetMseFeatureSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetMseFeatureSwitchResponse:
        """
        @summary Queries the information about the MSE feature switch.
        
        @param request: GetMseFeatureSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMseFeatureSwitchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMseFeatureSwitch',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetMseFeatureSwitchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_mse_feature_switch(
        self,
        request: mse_20190531_models.GetMseFeatureSwitchRequest,
    ) -> mse_20190531_models.GetMseFeatureSwitchResponse:
        """
        @summary Queries the information about the MSE feature switch.
        
        @param request: GetMseFeatureSwitchRequest
        @return: GetMseFeatureSwitchResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_mse_feature_switch_with_options(request, runtime)

    async def get_mse_feature_switch_async(
        self,
        request: mse_20190531_models.GetMseFeatureSwitchRequest,
    ) -> mse_20190531_models.GetMseFeatureSwitchResponse:
        """
        @summary Queries the information about the MSE feature switch.
        
        @param request: GetMseFeatureSwitchRequest
        @return: GetMseFeatureSwitchResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_mse_feature_switch_with_options_async(request, runtime)

    def get_mse_source_with_options(
        self,
        request: mse_20190531_models.GetMseSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetMseSourceResponse:
        """
        @summary Queries the existing Microservices Engine (MSE) Nacos instances that are service sources of a gateway.
        
        @param request: GetMseSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMseSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMseSource',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetMseSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_mse_source_with_options_async(
        self,
        request: mse_20190531_models.GetMseSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetMseSourceResponse:
        """
        @summary Queries the existing Microservices Engine (MSE) Nacos instances that are service sources of a gateway.
        
        @param request: GetMseSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetMseSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetMseSource',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetMseSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_mse_source(
        self,
        request: mse_20190531_models.GetMseSourceRequest,
    ) -> mse_20190531_models.GetMseSourceResponse:
        """
        @summary Queries the existing Microservices Engine (MSE) Nacos instances that are service sources of a gateway.
        
        @param request: GetMseSourceRequest
        @return: GetMseSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_mse_source_with_options(request, runtime)

    async def get_mse_source_async(
        self,
        request: mse_20190531_models.GetMseSourceRequest,
    ) -> mse_20190531_models.GetMseSourceResponse:
        """
        @summary Queries the existing Microservices Engine (MSE) Nacos instances that are service sources of a gateway.
        
        @param request: GetMseSourceRequest
        @return: GetMseSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_mse_source_with_options_async(request, runtime)

    def get_nacos_config_with_options(
        self,
        request: mse_20190531_models.GetNacosConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetNacosConfigResponse:
        """
        @summary Get Nacos Configuration
        
        @description > This OpenAPI is not the Nacos-SDK API. For information related to the Nacos-SDK API, please refer to the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: GetNacosConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetNacosConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.beta):
            query['Beta'] = request.beta
        if not UtilClient.is_unset(request.data_id):
            query['DataId'] = request.data_id
        if not UtilClient.is_unset(request.group):
            query['Group'] = request.group
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetNacosConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetNacosConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_nacos_config_with_options_async(
        self,
        request: mse_20190531_models.GetNacosConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetNacosConfigResponse:
        """
        @summary Get Nacos Configuration
        
        @description > This OpenAPI is not the Nacos-SDK API. For information related to the Nacos-SDK API, please refer to the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: GetNacosConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetNacosConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.beta):
            query['Beta'] = request.beta
        if not UtilClient.is_unset(request.data_id):
            query['DataId'] = request.data_id
        if not UtilClient.is_unset(request.group):
            query['Group'] = request.group
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetNacosConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetNacosConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_nacos_config(
        self,
        request: mse_20190531_models.GetNacosConfigRequest,
    ) -> mse_20190531_models.GetNacosConfigResponse:
        """
        @summary Get Nacos Configuration
        
        @description > This OpenAPI is not the Nacos-SDK API. For information related to the Nacos-SDK API, please refer to the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: GetNacosConfigRequest
        @return: GetNacosConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_nacos_config_with_options(request, runtime)

    async def get_nacos_config_async(
        self,
        request: mse_20190531_models.GetNacosConfigRequest,
    ) -> mse_20190531_models.GetNacosConfigResponse:
        """
        @summary Get Nacos Configuration
        
        @description > This OpenAPI is not the Nacos-SDK API. For information related to the Nacos-SDK API, please refer to the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: GetNacosConfigRequest
        @return: GetNacosConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_nacos_config_with_options_async(request, runtime)

    def get_nacos_history_config_with_options(
        self,
        request: mse_20190531_models.GetNacosHistoryConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetNacosHistoryConfigResponse:
        """
        @summary Queries the historical details of Nacos configuration changes.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: GetNacosHistoryConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetNacosHistoryConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.data_id):
            query['DataId'] = request.data_id
        if not UtilClient.is_unset(request.group):
            query['Group'] = request.group
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.nid):
            query['Nid'] = request.nid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetNacosHistoryConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetNacosHistoryConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_nacos_history_config_with_options_async(
        self,
        request: mse_20190531_models.GetNacosHistoryConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetNacosHistoryConfigResponse:
        """
        @summary Queries the historical details of Nacos configuration changes.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: GetNacosHistoryConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetNacosHistoryConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.data_id):
            query['DataId'] = request.data_id
        if not UtilClient.is_unset(request.group):
            query['Group'] = request.group
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.nid):
            query['Nid'] = request.nid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetNacosHistoryConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetNacosHistoryConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_nacos_history_config(
        self,
        request: mse_20190531_models.GetNacosHistoryConfigRequest,
    ) -> mse_20190531_models.GetNacosHistoryConfigResponse:
        """
        @summary Queries the historical details of Nacos configuration changes.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: GetNacosHistoryConfigRequest
        @return: GetNacosHistoryConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_nacos_history_config_with_options(request, runtime)

    async def get_nacos_history_config_async(
        self,
        request: mse_20190531_models.GetNacosHistoryConfigRequest,
    ) -> mse_20190531_models.GetNacosHistoryConfigResponse:
        """
        @summary Queries the historical details of Nacos configuration changes.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: GetNacosHistoryConfigRequest
        @return: GetNacosHistoryConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_nacos_history_config_with_options_async(request, runtime)

    def get_overview_with_options(
        self,
        request: mse_20190531_models.GetOverviewRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetOverviewResponse:
        """
        @summary Queries information about service governance.
        
        @description You can call this operation to query overview information about service governance.
        
        @param request: GetOverviewRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetOverviewResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetOverview',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetOverviewResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_overview_with_options_async(
        self,
        request: mse_20190531_models.GetOverviewRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetOverviewResponse:
        """
        @summary Queries information about service governance.
        
        @description You can call this operation to query overview information about service governance.
        
        @param request: GetOverviewRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetOverviewResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetOverview',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetOverviewResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_overview(
        self,
        request: mse_20190531_models.GetOverviewRequest,
    ) -> mse_20190531_models.GetOverviewResponse:
        """
        @summary Queries information about service governance.
        
        @description You can call this operation to query overview information about service governance.
        
        @param request: GetOverviewRequest
        @return: GetOverviewResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_overview_with_options(request, runtime)

    async def get_overview_async(
        self,
        request: mse_20190531_models.GetOverviewRequest,
    ) -> mse_20190531_models.GetOverviewResponse:
        """
        @summary Queries information about service governance.
        
        @description You can call this operation to query overview information about service governance.
        
        @param request: GetOverviewRequest
        @return: GetOverviewResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_overview_with_options_async(request, runtime)

    def get_plugin_config_with_options(
        self,
        request: mse_20190531_models.GetPluginConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetPluginConfigResponse:
        """
        @summary Obtains plug-in configurations.
        
        @param request: GetPluginConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPluginConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.plugin_id):
            query['PluginId'] = request.plugin_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetPluginConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetPluginConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_plugin_config_with_options_async(
        self,
        request: mse_20190531_models.GetPluginConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetPluginConfigResponse:
        """
        @summary Obtains plug-in configurations.
        
        @param request: GetPluginConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPluginConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.plugin_id):
            query['PluginId'] = request.plugin_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetPluginConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetPluginConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_plugin_config(
        self,
        request: mse_20190531_models.GetPluginConfigRequest,
    ) -> mse_20190531_models.GetPluginConfigResponse:
        """
        @summary Obtains plug-in configurations.
        
        @param request: GetPluginConfigRequest
        @return: GetPluginConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_plugin_config_with_options(request, runtime)

    async def get_plugin_config_async(
        self,
        request: mse_20190531_models.GetPluginConfigRequest,
    ) -> mse_20190531_models.GetPluginConfigResponse:
        """
        @summary Obtains plug-in configurations.
        
        @param request: GetPluginConfigRequest
        @return: GetPluginConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_plugin_config_with_options_async(request, runtime)

    def get_plugins_with_options(
        self,
        request: mse_20190531_models.GetPluginsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetPluginsResponse:
        """
        @summary Obtains plug-ins.
        
        @param request: GetPluginsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPluginsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.category):
            query['Category'] = request.category
        if not UtilClient.is_unset(request.enable_only):
            query['EnableOnly'] = request.enable_only
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetPlugins',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetPluginsResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_plugins_with_options_async(
        self,
        request: mse_20190531_models.GetPluginsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetPluginsResponse:
        """
        @summary Obtains plug-ins.
        
        @param request: GetPluginsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetPluginsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.category):
            query['Category'] = request.category
        if not UtilClient.is_unset(request.enable_only):
            query['EnableOnly'] = request.enable_only
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetPlugins',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetPluginsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_plugins(
        self,
        request: mse_20190531_models.GetPluginsRequest,
    ) -> mse_20190531_models.GetPluginsResponse:
        """
        @summary Obtains plug-ins.
        
        @param request: GetPluginsRequest
        @return: GetPluginsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_plugins_with_options(request, runtime)

    async def get_plugins_async(
        self,
        request: mse_20190531_models.GetPluginsRequest,
    ) -> mse_20190531_models.GetPluginsResponse:
        """
        @summary Obtains plug-ins.
        
        @param request: GetPluginsRequest
        @return: GetPluginsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_plugins_with_options_async(request, runtime)

    def get_service_list_with_options(
        self,
        request: mse_20190531_models.GetServiceListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetServiceListResponse:
        """
        @summary Queries the services of an application.
        
        @param request: GetServiceListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetServiceListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.ip):
            query['Ip'] = request.ip
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.service_type):
            query['ServiceType'] = request.service_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetServiceList',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetServiceListResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_service_list_with_options_async(
        self,
        request: mse_20190531_models.GetServiceListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetServiceListResponse:
        """
        @summary Queries the services of an application.
        
        @param request: GetServiceListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetServiceListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.ip):
            query['Ip'] = request.ip
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.service_type):
            query['ServiceType'] = request.service_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetServiceList',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetServiceListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_service_list(
        self,
        request: mse_20190531_models.GetServiceListRequest,
    ) -> mse_20190531_models.GetServiceListResponse:
        """
        @summary Queries the services of an application.
        
        @param request: GetServiceListRequest
        @return: GetServiceListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_service_list_with_options(request, runtime)

    async def get_service_list_async(
        self,
        request: mse_20190531_models.GetServiceListRequest,
    ) -> mse_20190531_models.GetServiceListResponse:
        """
        @summary Queries the services of an application.
        
        @param request: GetServiceListRequest
        @return: GetServiceListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_service_list_with_options_async(request, runtime)

    def get_service_list_page_with_options(
        self,
        request: mse_20190531_models.GetServiceListPageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetServiceListPageResponse:
        """
        @summary Queries the version of a microservices application.
        
        @param request: GetServiceListPageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetServiceListPageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.ip):
            query['Ip'] = request.ip
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.service_type):
            query['ServiceType'] = request.service_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetServiceListPage',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetServiceListPageResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_service_list_page_with_options_async(
        self,
        request: mse_20190531_models.GetServiceListPageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetServiceListPageResponse:
        """
        @summary Queries the version of a microservices application.
        
        @param request: GetServiceListPageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetServiceListPageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.ip):
            query['Ip'] = request.ip
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.service_type):
            query['ServiceType'] = request.service_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetServiceListPage',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetServiceListPageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_service_list_page(
        self,
        request: mse_20190531_models.GetServiceListPageRequest,
    ) -> mse_20190531_models.GetServiceListPageResponse:
        """
        @summary Queries the version of a microservices application.
        
        @param request: GetServiceListPageRequest
        @return: GetServiceListPageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_service_list_page_with_options(request, runtime)

    async def get_service_list_page_async(
        self,
        request: mse_20190531_models.GetServiceListPageRequest,
    ) -> mse_20190531_models.GetServiceListPageResponse:
        """
        @summary Queries the version of a microservices application.
        
        @param request: GetServiceListPageRequest
        @return: GetServiceListPageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_service_list_page_with_options_async(request, runtime)

    def get_service_listeners_with_options(
        self,
        request: mse_20190531_models.GetServiceListenersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetServiceListenersResponse:
        """
        @summary Queries the list of listeners for the destination service.
        
        @param request: GetServiceListenersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetServiceListenersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.has_ip_count):
            query['HasIpCount'] = request.has_ip_count
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetServiceListeners',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetServiceListenersResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_service_listeners_with_options_async(
        self,
        request: mse_20190531_models.GetServiceListenersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetServiceListenersResponse:
        """
        @summary Queries the list of listeners for the destination service.
        
        @param request: GetServiceListenersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetServiceListenersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.has_ip_count):
            query['HasIpCount'] = request.has_ip_count
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetServiceListeners',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetServiceListenersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_service_listeners(
        self,
        request: mse_20190531_models.GetServiceListenersRequest,
    ) -> mse_20190531_models.GetServiceListenersResponse:
        """
        @summary Queries the list of listeners for the destination service.
        
        @param request: GetServiceListenersRequest
        @return: GetServiceListenersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_service_listeners_with_options(request, runtime)

    async def get_service_listeners_async(
        self,
        request: mse_20190531_models.GetServiceListenersRequest,
    ) -> mse_20190531_models.GetServiceListenersResponse:
        """
        @summary Queries the list of listeners for the destination service.
        
        @param request: GetServiceListenersRequest
        @return: GetServiceListenersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_service_listeners_with_options_async(request, runtime)

    def get_service_method_page_with_options(
        self,
        request: mse_20190531_models.GetServiceMethodPageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetServiceMethodPageResponse:
        """
        @summary 获取服务接口列表
        
        @param request: GetServiceMethodPageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetServiceMethodPageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.ip):
            query['Ip'] = request.ip
        if not UtilClient.is_unset(request.method_controller):
            query['MethodController'] = request.method_controller
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.path):
            query['Path'] = request.path
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.service_group):
            query['ServiceGroup'] = request.service_group
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.service_type):
            query['ServiceType'] = request.service_type
        if not UtilClient.is_unset(request.service_version):
            query['ServiceVersion'] = request.service_version
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetServiceMethodPage',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetServiceMethodPageResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_service_method_page_with_options_async(
        self,
        request: mse_20190531_models.GetServiceMethodPageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetServiceMethodPageResponse:
        """
        @summary 获取服务接口列表
        
        @param request: GetServiceMethodPageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetServiceMethodPageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.ip):
            query['Ip'] = request.ip
        if not UtilClient.is_unset(request.method_controller):
            query['MethodController'] = request.method_controller
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.path):
            query['Path'] = request.path
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.service_group):
            query['ServiceGroup'] = request.service_group
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.service_type):
            query['ServiceType'] = request.service_type
        if not UtilClient.is_unset(request.service_version):
            query['ServiceVersion'] = request.service_version
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetServiceMethodPage',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetServiceMethodPageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_service_method_page(
        self,
        request: mse_20190531_models.GetServiceMethodPageRequest,
    ) -> mse_20190531_models.GetServiceMethodPageResponse:
        """
        @summary 获取服务接口列表
        
        @param request: GetServiceMethodPageRequest
        @return: GetServiceMethodPageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_service_method_page_with_options(request, runtime)

    async def get_service_method_page_async(
        self,
        request: mse_20190531_models.GetServiceMethodPageRequest,
    ) -> mse_20190531_models.GetServiceMethodPageResponse:
        """
        @summary 获取服务接口列表
        
        @param request: GetServiceMethodPageRequest
        @return: GetServiceMethodPageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_service_method_page_with_options_async(request, runtime)

    def get_tags_by_swimming_lane_group_id_with_options(
        self,
        request: mse_20190531_models.GetTagsBySwimmingLaneGroupIdRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetTagsBySwimmingLaneGroupIdResponse:
        """
        @summary Obtains all tags in the current lane group.
        
        @param request: GetTagsBySwimmingLaneGroupIdRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetTagsBySwimmingLaneGroupIdResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetTagsBySwimmingLaneGroupId',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetTagsBySwimmingLaneGroupIdResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_tags_by_swimming_lane_group_id_with_options_async(
        self,
        request: mse_20190531_models.GetTagsBySwimmingLaneGroupIdRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetTagsBySwimmingLaneGroupIdResponse:
        """
        @summary Obtains all tags in the current lane group.
        
        @param request: GetTagsBySwimmingLaneGroupIdRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetTagsBySwimmingLaneGroupIdResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetTagsBySwimmingLaneGroupId',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetTagsBySwimmingLaneGroupIdResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_tags_by_swimming_lane_group_id(
        self,
        request: mse_20190531_models.GetTagsBySwimmingLaneGroupIdRequest,
    ) -> mse_20190531_models.GetTagsBySwimmingLaneGroupIdResponse:
        """
        @summary Obtains all tags in the current lane group.
        
        @param request: GetTagsBySwimmingLaneGroupIdRequest
        @return: GetTagsBySwimmingLaneGroupIdResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_tags_by_swimming_lane_group_id_with_options(request, runtime)

    async def get_tags_by_swimming_lane_group_id_async(
        self,
        request: mse_20190531_models.GetTagsBySwimmingLaneGroupIdRequest,
    ) -> mse_20190531_models.GetTagsBySwimmingLaneGroupIdResponse:
        """
        @summary Obtains all tags in the current lane group.
        
        @param request: GetTagsBySwimmingLaneGroupIdRequest
        @return: GetTagsBySwimmingLaneGroupIdResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_tags_by_swimming_lane_group_id_with_options_async(request, runtime)

    def get_zookeeper_data_import_url_with_options(
        self,
        request: mse_20190531_models.GetZookeeperDataImportUrlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetZookeeperDataImportUrlResponse:
        """
        @summary mse-200-105
        
        @param request: GetZookeeperDataImportUrlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetZookeeperDataImportUrlResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.content_type):
            query['ContentType'] = request.content_type
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetZookeeperDataImportUrl',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetZookeeperDataImportUrlResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_zookeeper_data_import_url_with_options_async(
        self,
        request: mse_20190531_models.GetZookeeperDataImportUrlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.GetZookeeperDataImportUrlResponse:
        """
        @summary mse-200-105
        
        @param request: GetZookeeperDataImportUrlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetZookeeperDataImportUrlResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.content_type):
            query['ContentType'] = request.content_type
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetZookeeperDataImportUrl',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.GetZookeeperDataImportUrlResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_zookeeper_data_import_url(
        self,
        request: mse_20190531_models.GetZookeeperDataImportUrlRequest,
    ) -> mse_20190531_models.GetZookeeperDataImportUrlResponse:
        """
        @summary mse-200-105
        
        @param request: GetZookeeperDataImportUrlRequest
        @return: GetZookeeperDataImportUrlResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_zookeeper_data_import_url_with_options(request, runtime)

    async def get_zookeeper_data_import_url_async(
        self,
        request: mse_20190531_models.GetZookeeperDataImportUrlRequest,
    ) -> mse_20190531_models.GetZookeeperDataImportUrlResponse:
        """
        @summary mse-200-105
        
        @param request: GetZookeeperDataImportUrlRequest
        @return: GetZookeeperDataImportUrlResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_zookeeper_data_import_url_with_options_async(request, runtime)

    def import_nacos_config_with_options(
        self,
        request: mse_20190531_models.ImportNacosConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ImportNacosConfigResponse:
        """
        @summary Imports Nacos configurations as a file.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ImportNacosConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ImportNacosConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.file_url):
            query['FileUrl'] = request.file_url
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ImportNacosConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ImportNacosConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def import_nacos_config_with_options_async(
        self,
        request: mse_20190531_models.ImportNacosConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ImportNacosConfigResponse:
        """
        @summary Imports Nacos configurations as a file.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ImportNacosConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ImportNacosConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.file_url):
            query['FileUrl'] = request.file_url
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ImportNacosConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ImportNacosConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def import_nacos_config(
        self,
        request: mse_20190531_models.ImportNacosConfigRequest,
    ) -> mse_20190531_models.ImportNacosConfigResponse:
        """
        @summary Imports Nacos configurations as a file.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ImportNacosConfigRequest
        @return: ImportNacosConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.import_nacos_config_with_options(request, runtime)

    async def import_nacos_config_async(
        self,
        request: mse_20190531_models.ImportNacosConfigRequest,
    ) -> mse_20190531_models.ImportNacosConfigResponse:
        """
        @summary Imports Nacos configurations as a file.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ImportNacosConfigRequest
        @return: ImportNacosConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.import_nacos_config_with_options_async(request, runtime)

    def import_services_with_options(
        self,
        tmp_req: mse_20190531_models.ImportServicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ImportServicesResponse:
        """
        @summary Imports services to a gateway.
        
        @param tmp_req: ImportServicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ImportServicesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.ImportServicesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.service_list):
            request.service_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.service_list, 'ServiceList', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.fc_alias):
            query['FcAlias'] = request.fc_alias
        if not UtilClient.is_unset(request.fc_service_name):
            query['FcServiceName'] = request.fc_service_name
        if not UtilClient.is_unset(request.fc_version):
            query['FcVersion'] = request.fc_version
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.service_list_shrink):
            query['ServiceList'] = request.service_list_shrink
        if not UtilClient.is_unset(request.source_id):
            query['SourceId'] = request.source_id
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        if not UtilClient.is_unset(request.tls_setting):
            query['TlsSetting'] = request.tls_setting
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ImportServices',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ImportServicesResponse(),
            self.call_api(params, req, runtime)
        )

    async def import_services_with_options_async(
        self,
        tmp_req: mse_20190531_models.ImportServicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ImportServicesResponse:
        """
        @summary Imports services to a gateway.
        
        @param tmp_req: ImportServicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ImportServicesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.ImportServicesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.service_list):
            request.service_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.service_list, 'ServiceList', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.fc_alias):
            query['FcAlias'] = request.fc_alias
        if not UtilClient.is_unset(request.fc_service_name):
            query['FcServiceName'] = request.fc_service_name
        if not UtilClient.is_unset(request.fc_version):
            query['FcVersion'] = request.fc_version
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.service_list_shrink):
            query['ServiceList'] = request.service_list_shrink
        if not UtilClient.is_unset(request.source_id):
            query['SourceId'] = request.source_id
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        if not UtilClient.is_unset(request.tls_setting):
            query['TlsSetting'] = request.tls_setting
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ImportServices',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ImportServicesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def import_services(
        self,
        request: mse_20190531_models.ImportServicesRequest,
    ) -> mse_20190531_models.ImportServicesResponse:
        """
        @summary Imports services to a gateway.
        
        @param request: ImportServicesRequest
        @return: ImportServicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.import_services_with_options(request, runtime)

    async def import_services_async(
        self,
        request: mse_20190531_models.ImportServicesRequest,
    ) -> mse_20190531_models.ImportServicesResponse:
        """
        @summary Imports services to a gateway.
        
        @param request: ImportServicesRequest
        @return: ImportServicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.import_services_with_options_async(request, runtime)

    def import_zookeeper_data_with_options(
        self,
        request: mse_20190531_models.ImportZookeeperDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ImportZookeeperDataResponse:
        """
        @summary Initiates a task to import data from a destination URL to a Microservices Engine (MSE) ZooKeeper instance.
        
        @description *Danger** This operation clears existing data. Exercise caution when you call this API operation.
        
        @param request: ImportZookeeperDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ImportZookeeperDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.file_name):
            query['FileName'] = request.file_name
        if not UtilClient.is_unset(request.file_url):
            query['FileUrl'] = request.file_url
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ImportZookeeperData',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ImportZookeeperDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def import_zookeeper_data_with_options_async(
        self,
        request: mse_20190531_models.ImportZookeeperDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ImportZookeeperDataResponse:
        """
        @summary Initiates a task to import data from a destination URL to a Microservices Engine (MSE) ZooKeeper instance.
        
        @description *Danger** This operation clears existing data. Exercise caution when you call this API operation.
        
        @param request: ImportZookeeperDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ImportZookeeperDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.file_name):
            query['FileName'] = request.file_name
        if not UtilClient.is_unset(request.file_url):
            query['FileUrl'] = request.file_url
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ImportZookeeperData',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ImportZookeeperDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def import_zookeeper_data(
        self,
        request: mse_20190531_models.ImportZookeeperDataRequest,
    ) -> mse_20190531_models.ImportZookeeperDataResponse:
        """
        @summary Initiates a task to import data from a destination URL to a Microservices Engine (MSE) ZooKeeper instance.
        
        @description *Danger** This operation clears existing data. Exercise caution when you call this API operation.
        
        @param request: ImportZookeeperDataRequest
        @return: ImportZookeeperDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.import_zookeeper_data_with_options(request, runtime)

    async def import_zookeeper_data_async(
        self,
        request: mse_20190531_models.ImportZookeeperDataRequest,
    ) -> mse_20190531_models.ImportZookeeperDataResponse:
        """
        @summary Initiates a task to import data from a destination URL to a Microservices Engine (MSE) ZooKeeper instance.
        
        @description *Danger** This operation clears existing data. Exercise caution when you call this API operation.
        
        @param request: ImportZookeeperDataRequest
        @return: ImportZookeeperDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.import_zookeeper_data_with_options_async(request, runtime)

    def initialize_service_link_role_with_options(
        self,
        request: mse_20190531_models.InitializeServiceLinkRoleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.InitializeServiceLinkRoleResponse:
        """
        @summary 用户授权mseSLR
        
        @param request: InitializeServiceLinkRoleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: InitializeServiceLinkRoleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.role_name):
            query['RoleName'] = request.role_name
        if not UtilClient.is_unset(request.token):
            query['Token'] = request.token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='InitializeServiceLinkRole',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.InitializeServiceLinkRoleResponse(),
            self.call_api(params, req, runtime)
        )

    async def initialize_service_link_role_with_options_async(
        self,
        request: mse_20190531_models.InitializeServiceLinkRoleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.InitializeServiceLinkRoleResponse:
        """
        @summary 用户授权mseSLR
        
        @param request: InitializeServiceLinkRoleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: InitializeServiceLinkRoleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.role_name):
            query['RoleName'] = request.role_name
        if not UtilClient.is_unset(request.token):
            query['Token'] = request.token
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='InitializeServiceLinkRole',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.InitializeServiceLinkRoleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def initialize_service_link_role(
        self,
        request: mse_20190531_models.InitializeServiceLinkRoleRequest,
    ) -> mse_20190531_models.InitializeServiceLinkRoleResponse:
        """
        @summary 用户授权mseSLR
        
        @param request: InitializeServiceLinkRoleRequest
        @return: InitializeServiceLinkRoleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.initialize_service_link_role_with_options(request, runtime)

    async def initialize_service_link_role_async(
        self,
        request: mse_20190531_models.InitializeServiceLinkRoleRequest,
    ) -> mse_20190531_models.InitializeServiceLinkRoleResponse:
        """
        @summary 用户授权mseSLR
        
        @param request: InitializeServiceLinkRoleRequest
        @return: InitializeServiceLinkRoleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.initialize_service_link_role_with_options_async(request, runtime)

    def list_ans_instances_with_options(
        self,
        request: mse_20190531_models.ListAnsInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListAnsInstancesResponse:
        """
        @summary Queries application instances that are registered with a Microservices Engine (MSE) Nacos instance.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListAnsInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAnsInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAnsInstances',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListAnsInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_ans_instances_with_options_async(
        self,
        request: mse_20190531_models.ListAnsInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListAnsInstancesResponse:
        """
        @summary Queries application instances that are registered with a Microservices Engine (MSE) Nacos instance.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListAnsInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAnsInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAnsInstances',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListAnsInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_ans_instances(
        self,
        request: mse_20190531_models.ListAnsInstancesRequest,
    ) -> mse_20190531_models.ListAnsInstancesResponse:
        """
        @summary Queries application instances that are registered with a Microservices Engine (MSE) Nacos instance.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListAnsInstancesRequest
        @return: ListAnsInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_ans_instances_with_options(request, runtime)

    async def list_ans_instances_async(
        self,
        request: mse_20190531_models.ListAnsInstancesRequest,
    ) -> mse_20190531_models.ListAnsInstancesResponse:
        """
        @summary Queries application instances that are registered with a Microservices Engine (MSE) Nacos instance.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListAnsInstancesRequest
        @return: ListAnsInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_ans_instances_with_options_async(request, runtime)

    def list_ans_service_clusters_with_options(
        self,
        request: mse_20190531_models.ListAnsServiceClustersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListAnsServiceClustersResponse:
        """
        @summary Queries the clusters of a Nacos service.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListAnsServiceClustersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAnsServiceClustersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAnsServiceClusters',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListAnsServiceClustersResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_ans_service_clusters_with_options_async(
        self,
        request: mse_20190531_models.ListAnsServiceClustersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListAnsServiceClustersResponse:
        """
        @summary Queries the clusters of a Nacos service.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListAnsServiceClustersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAnsServiceClustersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAnsServiceClusters',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListAnsServiceClustersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_ans_service_clusters(
        self,
        request: mse_20190531_models.ListAnsServiceClustersRequest,
    ) -> mse_20190531_models.ListAnsServiceClustersResponse:
        """
        @summary Queries the clusters of a Nacos service.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListAnsServiceClustersRequest
        @return: ListAnsServiceClustersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_ans_service_clusters_with_options(request, runtime)

    async def list_ans_service_clusters_async(
        self,
        request: mse_20190531_models.ListAnsServiceClustersRequest,
    ) -> mse_20190531_models.ListAnsServiceClustersResponse:
        """
        @summary Queries the clusters of a Nacos service.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListAnsServiceClustersRequest
        @return: ListAnsServiceClustersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_ans_service_clusters_with_options_async(request, runtime)

    def list_ans_services_with_options(
        self,
        request: mse_20190531_models.ListAnsServicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListAnsServicesResponse:
        """
        @summary Queries Nacos services.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListAnsServicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAnsServicesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.has_ip_count):
            query['HasIpCount'] = request.has_ip_count
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAnsServices',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListAnsServicesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_ans_services_with_options_async(
        self,
        request: mse_20190531_models.ListAnsServicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListAnsServicesResponse:
        """
        @summary Queries Nacos services.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListAnsServicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAnsServicesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.has_ip_count):
            query['HasIpCount'] = request.has_ip_count
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAnsServices',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListAnsServicesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_ans_services(
        self,
        request: mse_20190531_models.ListAnsServicesRequest,
    ) -> mse_20190531_models.ListAnsServicesResponse:
        """
        @summary Queries Nacos services.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListAnsServicesRequest
        @return: ListAnsServicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_ans_services_with_options(request, runtime)

    async def list_ans_services_async(
        self,
        request: mse_20190531_models.ListAnsServicesRequest,
    ) -> mse_20190531_models.ListAnsServicesResponse:
        """
        @summary Queries Nacos services.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListAnsServicesRequest
        @return: ListAnsServicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_ans_services_with_options_async(request, runtime)

    def list_app_by_swimming_lane_group_tag_with_options(
        self,
        request: mse_20190531_models.ListAppBySwimmingLaneGroupTagRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListAppBySwimmingLaneGroupTagResponse:
        """
        @deprecated OpenAPI ListAppBySwimmingLaneGroupTag is deprecated, please use mse::2019-05-31::ListAppBySwimmingLaneGroupTags instead.
        
        @summary Queries the applications in a lane group by tag.
        
        @param request: ListAppBySwimmingLaneGroupTagRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAppBySwimmingLaneGroupTagResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAppBySwimmingLaneGroupTag',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListAppBySwimmingLaneGroupTagResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_app_by_swimming_lane_group_tag_with_options_async(
        self,
        request: mse_20190531_models.ListAppBySwimmingLaneGroupTagRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListAppBySwimmingLaneGroupTagResponse:
        """
        @deprecated OpenAPI ListAppBySwimmingLaneGroupTag is deprecated, please use mse::2019-05-31::ListAppBySwimmingLaneGroupTags instead.
        
        @summary Queries the applications in a lane group by tag.
        
        @param request: ListAppBySwimmingLaneGroupTagRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAppBySwimmingLaneGroupTagResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAppBySwimmingLaneGroupTag',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListAppBySwimmingLaneGroupTagResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_app_by_swimming_lane_group_tag(
        self,
        request: mse_20190531_models.ListAppBySwimmingLaneGroupTagRequest,
    ) -> mse_20190531_models.ListAppBySwimmingLaneGroupTagResponse:
        """
        @deprecated OpenAPI ListAppBySwimmingLaneGroupTag is deprecated, please use mse::2019-05-31::ListAppBySwimmingLaneGroupTags instead.
        
        @summary Queries the applications in a lane group by tag.
        
        @param request: ListAppBySwimmingLaneGroupTagRequest
        @return: ListAppBySwimmingLaneGroupTagResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.list_app_by_swimming_lane_group_tag_with_options(request, runtime)

    async def list_app_by_swimming_lane_group_tag_async(
        self,
        request: mse_20190531_models.ListAppBySwimmingLaneGroupTagRequest,
    ) -> mse_20190531_models.ListAppBySwimmingLaneGroupTagResponse:
        """
        @deprecated OpenAPI ListAppBySwimmingLaneGroupTag is deprecated, please use mse::2019-05-31::ListAppBySwimmingLaneGroupTags instead.
        
        @summary Queries the applications in a lane group by tag.
        
        @param request: ListAppBySwimmingLaneGroupTagRequest
        @return: ListAppBySwimmingLaneGroupTagResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_app_by_swimming_lane_group_tag_with_options_async(request, runtime)

    def list_app_by_swimming_lane_group_tags_with_options(
        self,
        tmp_req: mse_20190531_models.ListAppBySwimmingLaneGroupTagsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListAppBySwimmingLaneGroupTagsResponse:
        """
        @summary Lists applications by tag in a specified lane group.
        
        @param tmp_req: ListAppBySwimmingLaneGroupTagsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAppBySwimmingLaneGroupTagsResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.ListAppBySwimmingLaneGroupTagsShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.tags):
            request.tags_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.tags, 'Tags', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.tags_shrink):
            query['Tags'] = request.tags_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAppBySwimmingLaneGroupTags',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListAppBySwimmingLaneGroupTagsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_app_by_swimming_lane_group_tags_with_options_async(
        self,
        tmp_req: mse_20190531_models.ListAppBySwimmingLaneGroupTagsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListAppBySwimmingLaneGroupTagsResponse:
        """
        @summary Lists applications by tag in a specified lane group.
        
        @param tmp_req: ListAppBySwimmingLaneGroupTagsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAppBySwimmingLaneGroupTagsResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.ListAppBySwimmingLaneGroupTagsShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.tags):
            request.tags_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.tags, 'Tags', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.tags_shrink):
            query['Tags'] = request.tags_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAppBySwimmingLaneGroupTags',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListAppBySwimmingLaneGroupTagsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_app_by_swimming_lane_group_tags(
        self,
        request: mse_20190531_models.ListAppBySwimmingLaneGroupTagsRequest,
    ) -> mse_20190531_models.ListAppBySwimmingLaneGroupTagsResponse:
        """
        @summary Lists applications by tag in a specified lane group.
        
        @param request: ListAppBySwimmingLaneGroupTagsRequest
        @return: ListAppBySwimmingLaneGroupTagsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_app_by_swimming_lane_group_tags_with_options(request, runtime)

    async def list_app_by_swimming_lane_group_tags_async(
        self,
        request: mse_20190531_models.ListAppBySwimmingLaneGroupTagsRequest,
    ) -> mse_20190531_models.ListAppBySwimmingLaneGroupTagsResponse:
        """
        @summary Lists applications by tag in a specified lane group.
        
        @param request: ListAppBySwimmingLaneGroupTagsRequest
        @return: ListAppBySwimmingLaneGroupTagsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_app_by_swimming_lane_group_tags_with_options_async(request, runtime)

    def list_applications_with_tag_rules_with_options(
        self,
        request: mse_20190531_models.ListApplicationsWithTagRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListApplicationsWithTagRulesResponse:
        """
        @summary Queries the routing rules of an application.
        
        @param request: ListApplicationsWithTagRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListApplicationsWithTagRulesResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListApplicationsWithTagRules',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListApplicationsWithTagRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_applications_with_tag_rules_with_options_async(
        self,
        request: mse_20190531_models.ListApplicationsWithTagRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListApplicationsWithTagRulesResponse:
        """
        @summary Queries the routing rules of an application.
        
        @param request: ListApplicationsWithTagRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListApplicationsWithTagRulesResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListApplicationsWithTagRules',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListApplicationsWithTagRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_applications_with_tag_rules(
        self,
        request: mse_20190531_models.ListApplicationsWithTagRulesRequest,
    ) -> mse_20190531_models.ListApplicationsWithTagRulesResponse:
        """
        @summary Queries the routing rules of an application.
        
        @param request: ListApplicationsWithTagRulesRequest
        @return: ListApplicationsWithTagRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_applications_with_tag_rules_with_options(request, runtime)

    async def list_applications_with_tag_rules_async(
        self,
        request: mse_20190531_models.ListApplicationsWithTagRulesRequest,
    ) -> mse_20190531_models.ListApplicationsWithTagRulesResponse:
        """
        @summary Queries the routing rules of an application.
        
        @param request: ListApplicationsWithTagRulesRequest
        @return: ListApplicationsWithTagRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_applications_with_tag_rules_with_options_async(request, runtime)

    def list_auth_policy_with_options(
        self,
        request: mse_20190531_models.ListAuthPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListAuthPolicyResponse:
        """
        @summary Queries a list of service authentication rules.
        
        @param request: ListAuthPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAuthPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.protocol):
            query['Protocol'] = request.protocol
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAuthPolicy',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListAuthPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_auth_policy_with_options_async(
        self,
        request: mse_20190531_models.ListAuthPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListAuthPolicyResponse:
        """
        @summary Queries a list of service authentication rules.
        
        @param request: ListAuthPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListAuthPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.protocol):
            query['Protocol'] = request.protocol
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListAuthPolicy',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListAuthPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_auth_policy(
        self,
        request: mse_20190531_models.ListAuthPolicyRequest,
    ) -> mse_20190531_models.ListAuthPolicyResponse:
        """
        @summary Queries a list of service authentication rules.
        
        @param request: ListAuthPolicyRequest
        @return: ListAuthPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_auth_policy_with_options(request, runtime)

    async def list_auth_policy_async(
        self,
        request: mse_20190531_models.ListAuthPolicyRequest,
    ) -> mse_20190531_models.ListAuthPolicyResponse:
        """
        @summary Queries a list of service authentication rules.
        
        @param request: ListAuthPolicyRequest
        @return: ListAuthPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_auth_policy_with_options_async(request, runtime)

    def list_circuit_breaker_rules_with_options(
        self,
        request: mse_20190531_models.ListCircuitBreakerRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListCircuitBreakerRulesResponse:
        """
        @summary Queries a list of circuit breaking rules.
        
        @param request: ListCircuitBreakerRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListCircuitBreakerRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_index):
            query['PageIndex'] = request.page_index
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.resource_search_key):
            query['ResourceSearchKey'] = request.resource_search_key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListCircuitBreakerRules',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListCircuitBreakerRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_circuit_breaker_rules_with_options_async(
        self,
        request: mse_20190531_models.ListCircuitBreakerRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListCircuitBreakerRulesResponse:
        """
        @summary Queries a list of circuit breaking rules.
        
        @param request: ListCircuitBreakerRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListCircuitBreakerRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_index):
            query['PageIndex'] = request.page_index
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.resource_search_key):
            query['ResourceSearchKey'] = request.resource_search_key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListCircuitBreakerRules',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListCircuitBreakerRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_circuit_breaker_rules(
        self,
        request: mse_20190531_models.ListCircuitBreakerRulesRequest,
    ) -> mse_20190531_models.ListCircuitBreakerRulesResponse:
        """
        @summary Queries a list of circuit breaking rules.
        
        @param request: ListCircuitBreakerRulesRequest
        @return: ListCircuitBreakerRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_circuit_breaker_rules_with_options(request, runtime)

    async def list_circuit_breaker_rules_async(
        self,
        request: mse_20190531_models.ListCircuitBreakerRulesRequest,
    ) -> mse_20190531_models.ListCircuitBreakerRulesResponse:
        """
        @summary Queries a list of circuit breaking rules.
        
        @param request: ListCircuitBreakerRulesRequest
        @return: ListCircuitBreakerRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_circuit_breaker_rules_with_options_async(request, runtime)

    def list_cluster_connection_types_with_options(
        self,
        request: mse_20190531_models.ListClusterConnectionTypesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListClusterConnectionTypesResponse:
        """
        @summary Queries available cluster connection types.
        
        @param request: ListClusterConnectionTypesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListClusterConnectionTypesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListClusterConnectionTypes',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListClusterConnectionTypesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_cluster_connection_types_with_options_async(
        self,
        request: mse_20190531_models.ListClusterConnectionTypesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListClusterConnectionTypesResponse:
        """
        @summary Queries available cluster connection types.
        
        @param request: ListClusterConnectionTypesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListClusterConnectionTypesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListClusterConnectionTypes',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListClusterConnectionTypesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_cluster_connection_types(
        self,
        request: mse_20190531_models.ListClusterConnectionTypesRequest,
    ) -> mse_20190531_models.ListClusterConnectionTypesResponse:
        """
        @summary Queries available cluster connection types.
        
        @param request: ListClusterConnectionTypesRequest
        @return: ListClusterConnectionTypesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_cluster_connection_types_with_options(request, runtime)

    async def list_cluster_connection_types_async(
        self,
        request: mse_20190531_models.ListClusterConnectionTypesRequest,
    ) -> mse_20190531_models.ListClusterConnectionTypesResponse:
        """
        @summary Queries available cluster connection types.
        
        @param request: ListClusterConnectionTypesRequest
        @return: ListClusterConnectionTypesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_cluster_connection_types_with_options_async(request, runtime)

    def list_cluster_health_check_task_with_options(
        self,
        request: mse_20190531_models.ListClusterHealthCheckTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListClusterHealthCheckTaskResponse:
        """
        @summary Obtains information about historical health check tasks.
        
        @param request: ListClusterHealthCheckTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListClusterHealthCheckTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListClusterHealthCheckTask',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListClusterHealthCheckTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_cluster_health_check_task_with_options_async(
        self,
        request: mse_20190531_models.ListClusterHealthCheckTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListClusterHealthCheckTaskResponse:
        """
        @summary Obtains information about historical health check tasks.
        
        @param request: ListClusterHealthCheckTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListClusterHealthCheckTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListClusterHealthCheckTask',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListClusterHealthCheckTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_cluster_health_check_task(
        self,
        request: mse_20190531_models.ListClusterHealthCheckTaskRequest,
    ) -> mse_20190531_models.ListClusterHealthCheckTaskResponse:
        """
        @summary Obtains information about historical health check tasks.
        
        @param request: ListClusterHealthCheckTaskRequest
        @return: ListClusterHealthCheckTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_cluster_health_check_task_with_options(request, runtime)

    async def list_cluster_health_check_task_async(
        self,
        request: mse_20190531_models.ListClusterHealthCheckTaskRequest,
    ) -> mse_20190531_models.ListClusterHealthCheckTaskResponse:
        """
        @summary Obtains information about historical health check tasks.
        
        @param request: ListClusterHealthCheckTaskRequest
        @return: ListClusterHealthCheckTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_cluster_health_check_task_with_options_async(request, runtime)

    def list_cluster_types_with_options(
        self,
        request: mse_20190531_models.ListClusterTypesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListClusterTypesResponse:
        """
        @summary Queries the engine types that can be activated.
        
        @param request: ListClusterTypesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListClusterTypesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.connect_type):
            query['ConnectType'] = request.connect_type
        if not UtilClient.is_unset(request.mse_version):
            query['MseVersion'] = request.mse_version
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListClusterTypes',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListClusterTypesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_cluster_types_with_options_async(
        self,
        request: mse_20190531_models.ListClusterTypesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListClusterTypesResponse:
        """
        @summary Queries the engine types that can be activated.
        
        @param request: ListClusterTypesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListClusterTypesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.connect_type):
            query['ConnectType'] = request.connect_type
        if not UtilClient.is_unset(request.mse_version):
            query['MseVersion'] = request.mse_version
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListClusterTypes',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListClusterTypesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_cluster_types(
        self,
        request: mse_20190531_models.ListClusterTypesRequest,
    ) -> mse_20190531_models.ListClusterTypesResponse:
        """
        @summary Queries the engine types that can be activated.
        
        @param request: ListClusterTypesRequest
        @return: ListClusterTypesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_cluster_types_with_options(request, runtime)

    async def list_cluster_types_async(
        self,
        request: mse_20190531_models.ListClusterTypesRequest,
    ) -> mse_20190531_models.ListClusterTypesResponse:
        """
        @summary Queries the engine types that can be activated.
        
        @param request: ListClusterTypesRequest
        @return: ListClusterTypesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_cluster_types_with_options_async(request, runtime)

    def list_cluster_versions_with_options(
        self,
        request: mse_20190531_models.ListClusterVersionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListClusterVersionsResponse:
        """
        @summary Queries the information about supported instance versions.
        
        @param request: ListClusterVersionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListClusterVersionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_type):
            query['ClusterType'] = request.cluster_type
        if not UtilClient.is_unset(request.mse_version):
            query['MseVersion'] = request.mse_version
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListClusterVersions',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListClusterVersionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_cluster_versions_with_options_async(
        self,
        request: mse_20190531_models.ListClusterVersionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListClusterVersionsResponse:
        """
        @summary Queries the information about supported instance versions.
        
        @param request: ListClusterVersionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListClusterVersionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_type):
            query['ClusterType'] = request.cluster_type
        if not UtilClient.is_unset(request.mse_version):
            query['MseVersion'] = request.mse_version
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListClusterVersions',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListClusterVersionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_cluster_versions(
        self,
        request: mse_20190531_models.ListClusterVersionsRequest,
    ) -> mse_20190531_models.ListClusterVersionsResponse:
        """
        @summary Queries the information about supported instance versions.
        
        @param request: ListClusterVersionsRequest
        @return: ListClusterVersionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_cluster_versions_with_options(request, runtime)

    async def list_cluster_versions_async(
        self,
        request: mse_20190531_models.ListClusterVersionsRequest,
    ) -> mse_20190531_models.ListClusterVersionsResponse:
        """
        @summary Queries the information about supported instance versions.
        
        @param request: ListClusterVersionsRequest
        @return: ListClusterVersionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_cluster_versions_with_options_async(request, runtime)

    def list_clusters_with_options(
        self,
        request: mse_20190531_models.ListClustersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListClustersResponse:
        """
        @summary Queries Microservices Engine (MSE) instances.
        
        @param request: ListClustersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListClustersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_alias_name):
            query['ClusterAliasName'] = request.cluster_alias_name
        if not UtilClient.is_unset(request.key_id):
            query['KeyId'] = request.key_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListClusters',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListClustersResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_clusters_with_options_async(
        self,
        request: mse_20190531_models.ListClustersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListClustersResponse:
        """
        @summary Queries Microservices Engine (MSE) instances.
        
        @param request: ListClustersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListClustersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_alias_name):
            query['ClusterAliasName'] = request.cluster_alias_name
        if not UtilClient.is_unset(request.key_id):
            query['KeyId'] = request.key_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListClusters',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListClustersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_clusters(
        self,
        request: mse_20190531_models.ListClustersRequest,
    ) -> mse_20190531_models.ListClustersResponse:
        """
        @summary Queries Microservices Engine (MSE) instances.
        
        @param request: ListClustersRequest
        @return: ListClustersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_clusters_with_options(request, runtime)

    async def list_clusters_async(
        self,
        request: mse_20190531_models.ListClustersRequest,
    ) -> mse_20190531_models.ListClustersResponse:
        """
        @summary Queries Microservices Engine (MSE) instances.
        
        @param request: ListClustersRequest
        @return: ListClustersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_clusters_with_options_async(request, runtime)

    def list_config_track_with_options(
        self,
        request: mse_20190531_models.ListConfigTrackRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListConfigTrackResponse:
        """
        @summary Obtains the track data of a Nacos configuration center.
        
        @param request: ListConfigTrackRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListConfigTrackResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.data_id):
            query['DataId'] = request.data_id
        if not UtilClient.is_unset(request.end_ts):
            query['EndTs'] = request.end_ts
        if not UtilClient.is_unset(request.group):
            query['Group'] = request.group
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.ip):
            query['Ip'] = request.ip
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.reverse):
            query['Reverse'] = request.reverse
        if not UtilClient.is_unset(request.start_ts):
            query['StartTs'] = request.start_ts
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListConfigTrack',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListConfigTrackResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_config_track_with_options_async(
        self,
        request: mse_20190531_models.ListConfigTrackRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListConfigTrackResponse:
        """
        @summary Obtains the track data of a Nacos configuration center.
        
        @param request: ListConfigTrackRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListConfigTrackResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.data_id):
            query['DataId'] = request.data_id
        if not UtilClient.is_unset(request.end_ts):
            query['EndTs'] = request.end_ts
        if not UtilClient.is_unset(request.group):
            query['Group'] = request.group
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.ip):
            query['Ip'] = request.ip
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.reverse):
            query['Reverse'] = request.reverse
        if not UtilClient.is_unset(request.start_ts):
            query['StartTs'] = request.start_ts
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListConfigTrack',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListConfigTrackResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_config_track(
        self,
        request: mse_20190531_models.ListConfigTrackRequest,
    ) -> mse_20190531_models.ListConfigTrackResponse:
        """
        @summary Obtains the track data of a Nacos configuration center.
        
        @param request: ListConfigTrackRequest
        @return: ListConfigTrackResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_config_track_with_options(request, runtime)

    async def list_config_track_async(
        self,
        request: mse_20190531_models.ListConfigTrackRequest,
    ) -> mse_20190531_models.ListConfigTrackResponse:
        """
        @summary Obtains the track data of a Nacos configuration center.
        
        @param request: ListConfigTrackRequest
        @return: ListConfigTrackResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_config_track_with_options_async(request, runtime)

    def list_engine_namespaces_with_options(
        self,
        request: mse_20190531_models.ListEngineNamespacesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListEngineNamespacesResponse:
        """
        @summary Queries the namespaces of a Nacos instance.
        
        @param request: ListEngineNamespacesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListEngineNamespacesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListEngineNamespaces',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListEngineNamespacesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_engine_namespaces_with_options_async(
        self,
        request: mse_20190531_models.ListEngineNamespacesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListEngineNamespacesResponse:
        """
        @summary Queries the namespaces of a Nacos instance.
        
        @param request: ListEngineNamespacesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListEngineNamespacesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListEngineNamespaces',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListEngineNamespacesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_engine_namespaces(
        self,
        request: mse_20190531_models.ListEngineNamespacesRequest,
    ) -> mse_20190531_models.ListEngineNamespacesResponse:
        """
        @summary Queries the namespaces of a Nacos instance.
        
        @param request: ListEngineNamespacesRequest
        @return: ListEngineNamespacesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_engine_namespaces_with_options(request, runtime)

    async def list_engine_namespaces_async(
        self,
        request: mse_20190531_models.ListEngineNamespacesRequest,
    ) -> mse_20190531_models.ListEngineNamespacesResponse:
        """
        @summary Queries the namespaces of a Nacos instance.
        
        @param request: ListEngineNamespacesRequest
        @return: ListEngineNamespacesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_engine_namespaces_with_options_async(request, runtime)

    def list_eureka_instances_with_options(
        self,
        request: mse_20190531_models.ListEurekaInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListEurekaInstancesResponse:
        """
        @summary Queries Eureka instances.
        
        @param request: ListEurekaInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListEurekaInstancesResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListEurekaInstances',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListEurekaInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_eureka_instances_with_options_async(
        self,
        request: mse_20190531_models.ListEurekaInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListEurekaInstancesResponse:
        """
        @summary Queries Eureka instances.
        
        @param request: ListEurekaInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListEurekaInstancesResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListEurekaInstances',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListEurekaInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_eureka_instances(
        self,
        request: mse_20190531_models.ListEurekaInstancesRequest,
    ) -> mse_20190531_models.ListEurekaInstancesResponse:
        """
        @summary Queries Eureka instances.
        
        @param request: ListEurekaInstancesRequest
        @return: ListEurekaInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_eureka_instances_with_options(request, runtime)

    async def list_eureka_instances_async(
        self,
        request: mse_20190531_models.ListEurekaInstancesRequest,
    ) -> mse_20190531_models.ListEurekaInstancesResponse:
        """
        @summary Queries Eureka instances.
        
        @param request: ListEurekaInstancesRequest
        @return: ListEurekaInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_eureka_instances_with_options_async(request, runtime)

    def list_eureka_services_with_options(
        self,
        request: mse_20190531_models.ListEurekaServicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListEurekaServicesResponse:
        """
        @summary Queries Eureka services.
        
        @param request: ListEurekaServicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListEurekaServicesResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListEurekaServices',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListEurekaServicesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_eureka_services_with_options_async(
        self,
        request: mse_20190531_models.ListEurekaServicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListEurekaServicesResponse:
        """
        @summary Queries Eureka services.
        
        @param request: ListEurekaServicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListEurekaServicesResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListEurekaServices',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListEurekaServicesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_eureka_services(
        self,
        request: mse_20190531_models.ListEurekaServicesRequest,
    ) -> mse_20190531_models.ListEurekaServicesResponse:
        """
        @summary Queries Eureka services.
        
        @param request: ListEurekaServicesRequest
        @return: ListEurekaServicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_eureka_services_with_options(request, runtime)

    async def list_eureka_services_async(
        self,
        request: mse_20190531_models.ListEurekaServicesRequest,
    ) -> mse_20190531_models.ListEurekaServicesResponse:
        """
        @summary Queries Eureka services.
        
        @param request: ListEurekaServicesRequest
        @return: ListEurekaServicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_eureka_services_with_options_async(request, runtime)

    def list_export_zookeeper_data_with_options(
        self,
        request: mse_20190531_models.ListExportZookeeperDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListExportZookeeperDataResponse:
        """
        @summary Lists historical data export tasks of a Microservices Engine (MSE) Zookeeper instance.
        
        @param request: ListExportZookeeperDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListExportZookeeperDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListExportZookeeperData',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListExportZookeeperDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_export_zookeeper_data_with_options_async(
        self,
        request: mse_20190531_models.ListExportZookeeperDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListExportZookeeperDataResponse:
        """
        @summary Lists historical data export tasks of a Microservices Engine (MSE) Zookeeper instance.
        
        @param request: ListExportZookeeperDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListExportZookeeperDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListExportZookeeperData',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListExportZookeeperDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_export_zookeeper_data(
        self,
        request: mse_20190531_models.ListExportZookeeperDataRequest,
    ) -> mse_20190531_models.ListExportZookeeperDataResponse:
        """
        @summary Lists historical data export tasks of a Microservices Engine (MSE) Zookeeper instance.
        
        @param request: ListExportZookeeperDataRequest
        @return: ListExportZookeeperDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_export_zookeeper_data_with_options(request, runtime)

    async def list_export_zookeeper_data_async(
        self,
        request: mse_20190531_models.ListExportZookeeperDataRequest,
    ) -> mse_20190531_models.ListExportZookeeperDataResponse:
        """
        @summary Lists historical data export tasks of a Microservices Engine (MSE) Zookeeper instance.
        
        @param request: ListExportZookeeperDataRequest
        @return: ListExportZookeeperDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_export_zookeeper_data_with_options_async(request, runtime)

    def list_flow_rules_with_options(
        self,
        request: mse_20190531_models.ListFlowRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListFlowRulesResponse:
        """
        @summary Obtains a list of throttling rules.
        
        @param request: ListFlowRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListFlowRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_index):
            query['PageIndex'] = request.page_index
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.resource_search_key):
            query['ResourceSearchKey'] = request.resource_search_key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListFlowRules',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListFlowRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_flow_rules_with_options_async(
        self,
        request: mse_20190531_models.ListFlowRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListFlowRulesResponse:
        """
        @summary Obtains a list of throttling rules.
        
        @param request: ListFlowRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListFlowRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_index):
            query['PageIndex'] = request.page_index
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.resource_search_key):
            query['ResourceSearchKey'] = request.resource_search_key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListFlowRules',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListFlowRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_flow_rules(
        self,
        request: mse_20190531_models.ListFlowRulesRequest,
    ) -> mse_20190531_models.ListFlowRulesResponse:
        """
        @summary Obtains a list of throttling rules.
        
        @param request: ListFlowRulesRequest
        @return: ListFlowRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_flow_rules_with_options(request, runtime)

    async def list_flow_rules_async(
        self,
        request: mse_20190531_models.ListFlowRulesRequest,
    ) -> mse_20190531_models.ListFlowRulesResponse:
        """
        @summary Obtains a list of throttling rules.
        
        @param request: ListFlowRulesRequest
        @return: ListFlowRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_flow_rules_with_options_async(request, runtime)

    def list_gateway_with_options(
        self,
        tmp_req: mse_20190531_models.ListGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayResponse:
        """
        @summary Queries a list of gateways.
        
        @param tmp_req: ListGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.ListGatewayShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.filter_params):
            request.filter_params_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.filter_params, 'FilterParams', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.desc_sort):
            query['DescSort'] = request.desc_sort
        if not UtilClient.is_unset(request.filter_params_shrink):
            query['FilterParams'] = request.filter_params_shrink
        if not UtilClient.is_unset(request.order_item):
            query['OrderItem'] = request.order_item
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGateway',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_gateway_with_options_async(
        self,
        tmp_req: mse_20190531_models.ListGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayResponse:
        """
        @summary Queries a list of gateways.
        
        @param tmp_req: ListGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.ListGatewayShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.filter_params):
            request.filter_params_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.filter_params, 'FilterParams', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.desc_sort):
            query['DescSort'] = request.desc_sort
        if not UtilClient.is_unset(request.filter_params_shrink):
            query['FilterParams'] = request.filter_params_shrink
        if not UtilClient.is_unset(request.order_item):
            query['OrderItem'] = request.order_item
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGateway',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_gateway(
        self,
        request: mse_20190531_models.ListGatewayRequest,
    ) -> mse_20190531_models.ListGatewayResponse:
        """
        @summary Queries a list of gateways.
        
        @param request: ListGatewayRequest
        @return: ListGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_gateway_with_options(request, runtime)

    async def list_gateway_async(
        self,
        request: mse_20190531_models.ListGatewayRequest,
    ) -> mse_20190531_models.ListGatewayResponse:
        """
        @summary Queries a list of gateways.
        
        @param request: ListGatewayRequest
        @return: ListGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_gateway_with_options_async(request, runtime)

    def list_gateway_auth_consumer_with_options(
        self,
        request: mse_20190531_models.ListGatewayAuthConsumerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayAuthConsumerResponse:
        """
        @summary Queries the list of consumers on which a gateway performs authentication operations.
        
        @param request: ListGatewayAuthConsumerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayAuthConsumerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.consumer_status):
            query['ConsumerStatus'] = request.consumer_status
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewayAuthConsumer',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayAuthConsumerResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_gateway_auth_consumer_with_options_async(
        self,
        request: mse_20190531_models.ListGatewayAuthConsumerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayAuthConsumerResponse:
        """
        @summary Queries the list of consumers on which a gateway performs authentication operations.
        
        @param request: ListGatewayAuthConsumerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayAuthConsumerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.consumer_status):
            query['ConsumerStatus'] = request.consumer_status
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewayAuthConsumer',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayAuthConsumerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_gateway_auth_consumer(
        self,
        request: mse_20190531_models.ListGatewayAuthConsumerRequest,
    ) -> mse_20190531_models.ListGatewayAuthConsumerResponse:
        """
        @summary Queries the list of consumers on which a gateway performs authentication operations.
        
        @param request: ListGatewayAuthConsumerRequest
        @return: ListGatewayAuthConsumerResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_gateway_auth_consumer_with_options(request, runtime)

    async def list_gateway_auth_consumer_async(
        self,
        request: mse_20190531_models.ListGatewayAuthConsumerRequest,
    ) -> mse_20190531_models.ListGatewayAuthConsumerResponse:
        """
        @summary Queries the list of consumers on which a gateway performs authentication operations.
        
        @param request: ListGatewayAuthConsumerRequest
        @return: ListGatewayAuthConsumerResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_gateway_auth_consumer_with_options_async(request, runtime)

    def list_gateway_auth_consumer_resource_with_options(
        self,
        request: mse_20190531_models.ListGatewayAuthConsumerResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayAuthConsumerResourceResponse:
        """
        @summary Queries the list of authorized resources for the consumer on which a gateway performs authentication operations.
        
        @param request: ListGatewayAuthConsumerResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayAuthConsumerResourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.consumer_id):
            query['ConsumerId'] = request.consumer_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_status):
            query['ResourceStatus'] = request.resource_status
        if not UtilClient.is_unset(request.route_name):
            query['RouteName'] = request.route_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewayAuthConsumerResource',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayAuthConsumerResourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_gateway_auth_consumer_resource_with_options_async(
        self,
        request: mse_20190531_models.ListGatewayAuthConsumerResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayAuthConsumerResourceResponse:
        """
        @summary Queries the list of authorized resources for the consumer on which a gateway performs authentication operations.
        
        @param request: ListGatewayAuthConsumerResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayAuthConsumerResourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.consumer_id):
            query['ConsumerId'] = request.consumer_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_status):
            query['ResourceStatus'] = request.resource_status
        if not UtilClient.is_unset(request.route_name):
            query['RouteName'] = request.route_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewayAuthConsumerResource',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayAuthConsumerResourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_gateway_auth_consumer_resource(
        self,
        request: mse_20190531_models.ListGatewayAuthConsumerResourceRequest,
    ) -> mse_20190531_models.ListGatewayAuthConsumerResourceResponse:
        """
        @summary Queries the list of authorized resources for the consumer on which a gateway performs authentication operations.
        
        @param request: ListGatewayAuthConsumerResourceRequest
        @return: ListGatewayAuthConsumerResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_gateway_auth_consumer_resource_with_options(request, runtime)

    async def list_gateway_auth_consumer_resource_async(
        self,
        request: mse_20190531_models.ListGatewayAuthConsumerResourceRequest,
    ) -> mse_20190531_models.ListGatewayAuthConsumerResourceResponse:
        """
        @summary Queries the list of authorized resources for the consumer on which a gateway performs authentication operations.
        
        @param request: ListGatewayAuthConsumerResourceRequest
        @return: ListGatewayAuthConsumerResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_gateway_auth_consumer_resource_with_options_async(request, runtime)

    def list_gateway_circuit_breaker_rule_with_options(
        self,
        request: mse_20190531_models.ListGatewayCircuitBreakerRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayCircuitBreakerRuleResponse:
        """
        @summary 查看网关路由熔断规则
        
        @param request: ListGatewayCircuitBreakerRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayCircuitBreakerRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.filter_params):
            query['FilterParams'] = request.filter_params
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewayCircuitBreakerRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayCircuitBreakerRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_gateway_circuit_breaker_rule_with_options_async(
        self,
        request: mse_20190531_models.ListGatewayCircuitBreakerRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayCircuitBreakerRuleResponse:
        """
        @summary 查看网关路由熔断规则
        
        @param request: ListGatewayCircuitBreakerRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayCircuitBreakerRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.filter_params):
            query['FilterParams'] = request.filter_params
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewayCircuitBreakerRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayCircuitBreakerRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_gateway_circuit_breaker_rule(
        self,
        request: mse_20190531_models.ListGatewayCircuitBreakerRuleRequest,
    ) -> mse_20190531_models.ListGatewayCircuitBreakerRuleResponse:
        """
        @summary 查看网关路由熔断规则
        
        @param request: ListGatewayCircuitBreakerRuleRequest
        @return: ListGatewayCircuitBreakerRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_gateway_circuit_breaker_rule_with_options(request, runtime)

    async def list_gateway_circuit_breaker_rule_async(
        self,
        request: mse_20190531_models.ListGatewayCircuitBreakerRuleRequest,
    ) -> mse_20190531_models.ListGatewayCircuitBreakerRuleResponse:
        """
        @summary 查看网关路由熔断规则
        
        @param request: ListGatewayCircuitBreakerRuleRequest
        @return: ListGatewayCircuitBreakerRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_gateway_circuit_breaker_rule_with_options_async(request, runtime)

    def list_gateway_domain_with_options(
        self,
        request: mse_20190531_models.ListGatewayDomainRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayDomainResponse:
        """
        @summary Queries the domain names that are associated with a gateway.
        
        @param request: ListGatewayDomainRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayDomainResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewayDomain',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayDomainResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_gateway_domain_with_options_async(
        self,
        request: mse_20190531_models.ListGatewayDomainRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayDomainResponse:
        """
        @summary Queries the domain names that are associated with a gateway.
        
        @param request: ListGatewayDomainRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayDomainResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewayDomain',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayDomainResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_gateway_domain(
        self,
        request: mse_20190531_models.ListGatewayDomainRequest,
    ) -> mse_20190531_models.ListGatewayDomainResponse:
        """
        @summary Queries the domain names that are associated with a gateway.
        
        @param request: ListGatewayDomainRequest
        @return: ListGatewayDomainResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_gateway_domain_with_options(request, runtime)

    async def list_gateway_domain_async(
        self,
        request: mse_20190531_models.ListGatewayDomainRequest,
    ) -> mse_20190531_models.ListGatewayDomainResponse:
        """
        @summary Queries the domain names that are associated with a gateway.
        
        @param request: ListGatewayDomainRequest
        @return: ListGatewayDomainResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_gateway_domain_with_options_async(request, runtime)

    def list_gateway_flow_rule_with_options(
        self,
        request: mse_20190531_models.ListGatewayFlowRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayFlowRuleResponse:
        """
        @summary 查看网关路由流控规则
        
        @param request: ListGatewayFlowRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayFlowRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.filter_params):
            query['FilterParams'] = request.filter_params
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewayFlowRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayFlowRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_gateway_flow_rule_with_options_async(
        self,
        request: mse_20190531_models.ListGatewayFlowRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayFlowRuleResponse:
        """
        @summary 查看网关路由流控规则
        
        @param request: ListGatewayFlowRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayFlowRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.filter_params):
            query['FilterParams'] = request.filter_params
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewayFlowRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayFlowRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_gateway_flow_rule(
        self,
        request: mse_20190531_models.ListGatewayFlowRuleRequest,
    ) -> mse_20190531_models.ListGatewayFlowRuleResponse:
        """
        @summary 查看网关路由流控规则
        
        @param request: ListGatewayFlowRuleRequest
        @return: ListGatewayFlowRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_gateway_flow_rule_with_options(request, runtime)

    async def list_gateway_flow_rule_async(
        self,
        request: mse_20190531_models.ListGatewayFlowRuleRequest,
    ) -> mse_20190531_models.ListGatewayFlowRuleResponse:
        """
        @summary 查看网关路由流控规则
        
        @param request: ListGatewayFlowRuleRequest
        @return: ListGatewayFlowRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_gateway_flow_rule_with_options_async(request, runtime)

    def list_gateway_isolation_rule_with_options(
        self,
        request: mse_20190531_models.ListGatewayIsolationRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayIsolationRuleResponse:
        """
        @summary 查看网关路由隔离规则
        
        @param request: ListGatewayIsolationRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayIsolationRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.filter_params):
            query['FilterParams'] = request.filter_params
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewayIsolationRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayIsolationRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_gateway_isolation_rule_with_options_async(
        self,
        request: mse_20190531_models.ListGatewayIsolationRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayIsolationRuleResponse:
        """
        @summary 查看网关路由隔离规则
        
        @param request: ListGatewayIsolationRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayIsolationRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.filter_params):
            query['FilterParams'] = request.filter_params
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewayIsolationRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayIsolationRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_gateway_isolation_rule(
        self,
        request: mse_20190531_models.ListGatewayIsolationRuleRequest,
    ) -> mse_20190531_models.ListGatewayIsolationRuleResponse:
        """
        @summary 查看网关路由隔离规则
        
        @param request: ListGatewayIsolationRuleRequest
        @return: ListGatewayIsolationRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_gateway_isolation_rule_with_options(request, runtime)

    async def list_gateway_isolation_rule_async(
        self,
        request: mse_20190531_models.ListGatewayIsolationRuleRequest,
    ) -> mse_20190531_models.ListGatewayIsolationRuleResponse:
        """
        @summary 查看网关路由隔离规则
        
        @param request: ListGatewayIsolationRuleRequest
        @return: ListGatewayIsolationRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_gateway_isolation_rule_with_options_async(request, runtime)

    def list_gateway_route_with_options(
        self,
        tmp_req: mse_20190531_models.ListGatewayRouteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayRouteResponse:
        """
        @summary Queries the routes of a gateway.
        
        @param tmp_req: ListGatewayRouteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayRouteResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.ListGatewayRouteShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.filter_params):
            request.filter_params_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.filter_params, 'FilterParams', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.desc_sort):
            query['DescSort'] = request.desc_sort
        if not UtilClient.is_unset(request.filter_params_shrink):
            query['FilterParams'] = request.filter_params_shrink
        if not UtilClient.is_unset(request.order_item):
            query['OrderItem'] = request.order_item
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewayRoute',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayRouteResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_gateway_route_with_options_async(
        self,
        tmp_req: mse_20190531_models.ListGatewayRouteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayRouteResponse:
        """
        @summary Queries the routes of a gateway.
        
        @param tmp_req: ListGatewayRouteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayRouteResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.ListGatewayRouteShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.filter_params):
            request.filter_params_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.filter_params, 'FilterParams', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.desc_sort):
            query['DescSort'] = request.desc_sort
        if not UtilClient.is_unset(request.filter_params_shrink):
            query['FilterParams'] = request.filter_params_shrink
        if not UtilClient.is_unset(request.order_item):
            query['OrderItem'] = request.order_item
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewayRoute',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayRouteResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_gateway_route(
        self,
        request: mse_20190531_models.ListGatewayRouteRequest,
    ) -> mse_20190531_models.ListGatewayRouteResponse:
        """
        @summary Queries the routes of a gateway.
        
        @param request: ListGatewayRouteRequest
        @return: ListGatewayRouteResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_gateway_route_with_options(request, runtime)

    async def list_gateway_route_async(
        self,
        request: mse_20190531_models.ListGatewayRouteRequest,
    ) -> mse_20190531_models.ListGatewayRouteResponse:
        """
        @summary Queries the routes of a gateway.
        
        @param request: ListGatewayRouteRequest
        @return: ListGatewayRouteResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_gateway_route_with_options_async(request, runtime)

    def list_gateway_route_on_auth_with_options(
        self,
        request: mse_20190531_models.ListGatewayRouteOnAuthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayRouteOnAuthResponse:
        """
        @summary Queries a list of routes for which authentication is enabled.
        
        @param request: ListGatewayRouteOnAuthRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayRouteOnAuthResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewayRouteOnAuth',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayRouteOnAuthResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_gateway_route_on_auth_with_options_async(
        self,
        request: mse_20190531_models.ListGatewayRouteOnAuthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayRouteOnAuthResponse:
        """
        @summary Queries a list of routes for which authentication is enabled.
        
        @param request: ListGatewayRouteOnAuthRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayRouteOnAuthResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewayRouteOnAuth',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayRouteOnAuthResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_gateway_route_on_auth(
        self,
        request: mse_20190531_models.ListGatewayRouteOnAuthRequest,
    ) -> mse_20190531_models.ListGatewayRouteOnAuthResponse:
        """
        @summary Queries a list of routes for which authentication is enabled.
        
        @param request: ListGatewayRouteOnAuthRequest
        @return: ListGatewayRouteOnAuthResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_gateway_route_on_auth_with_options(request, runtime)

    async def list_gateway_route_on_auth_async(
        self,
        request: mse_20190531_models.ListGatewayRouteOnAuthRequest,
    ) -> mse_20190531_models.ListGatewayRouteOnAuthResponse:
        """
        @summary Queries a list of routes for which authentication is enabled.
        
        @param request: ListGatewayRouteOnAuthRequest
        @return: ListGatewayRouteOnAuthResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_gateway_route_on_auth_with_options_async(request, runtime)

    def list_gateway_service_with_options(
        self,
        tmp_req: mse_20190531_models.ListGatewayServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayServiceResponse:
        """
        @summary Queries a list of services that are subscribed with a gateway.
        
        @param tmp_req: ListGatewayServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayServiceResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.ListGatewayServiceShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.filter_params):
            request.filter_params_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.filter_params, 'FilterParams', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.desc_sort):
            query['DescSort'] = request.desc_sort
        if not UtilClient.is_unset(request.filter_params_shrink):
            query['FilterParams'] = request.filter_params_shrink
        if not UtilClient.is_unset(request.order_item):
            query['OrderItem'] = request.order_item
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewayService',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayServiceResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_gateway_service_with_options_async(
        self,
        tmp_req: mse_20190531_models.ListGatewayServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayServiceResponse:
        """
        @summary Queries a list of services that are subscribed with a gateway.
        
        @param tmp_req: ListGatewayServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayServiceResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.ListGatewayServiceShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.filter_params):
            request.filter_params_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.filter_params, 'FilterParams', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.desc_sort):
            query['DescSort'] = request.desc_sort
        if not UtilClient.is_unset(request.filter_params_shrink):
            query['FilterParams'] = request.filter_params_shrink
        if not UtilClient.is_unset(request.order_item):
            query['OrderItem'] = request.order_item
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewayService',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayServiceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_gateway_service(
        self,
        request: mse_20190531_models.ListGatewayServiceRequest,
    ) -> mse_20190531_models.ListGatewayServiceResponse:
        """
        @summary Queries a list of services that are subscribed with a gateway.
        
        @param request: ListGatewayServiceRequest
        @return: ListGatewayServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_gateway_service_with_options(request, runtime)

    async def list_gateway_service_async(
        self,
        request: mse_20190531_models.ListGatewayServiceRequest,
    ) -> mse_20190531_models.ListGatewayServiceResponse:
        """
        @summary Queries a list of services that are subscribed with a gateway.
        
        @param request: ListGatewayServiceRequest
        @return: ListGatewayServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_gateway_service_with_options_async(request, runtime)

    def list_gateway_slb_with_options(
        self,
        request: mse_20190531_models.ListGatewaySlbRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewaySlbResponse:
        """
        @summary Queries the Server Load Balancer (SLB) instances that are associated with a gateway.
        
        @param request: ListGatewaySlbRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewaySlbResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewaySlb',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewaySlbResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_gateway_slb_with_options_async(
        self,
        request: mse_20190531_models.ListGatewaySlbRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewaySlbResponse:
        """
        @summary Queries the Server Load Balancer (SLB) instances that are associated with a gateway.
        
        @param request: ListGatewaySlbRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewaySlbResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewaySlb',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewaySlbResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_gateway_slb(
        self,
        request: mse_20190531_models.ListGatewaySlbRequest,
    ) -> mse_20190531_models.ListGatewaySlbResponse:
        """
        @summary Queries the Server Load Balancer (SLB) instances that are associated with a gateway.
        
        @param request: ListGatewaySlbRequest
        @return: ListGatewaySlbResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_gateway_slb_with_options(request, runtime)

    async def list_gateway_slb_async(
        self,
        request: mse_20190531_models.ListGatewaySlbRequest,
    ) -> mse_20190531_models.ListGatewaySlbResponse:
        """
        @summary Queries the Server Load Balancer (SLB) instances that are associated with a gateway.
        
        @param request: ListGatewaySlbRequest
        @return: ListGatewaySlbResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_gateway_slb_with_options_async(request, runtime)

    def list_gateway_zone_with_options(
        self,
        request: mse_20190531_models.ListGatewayZoneRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayZoneResponse:
        """
        @summary Obtains a list of zones where a gateway is available.
        
        @param request: ListGatewayZoneRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayZoneResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewayZone',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayZoneResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_gateway_zone_with_options_async(
        self,
        request: mse_20190531_models.ListGatewayZoneRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListGatewayZoneResponse:
        """
        @summary Obtains a list of zones where a gateway is available.
        
        @param request: ListGatewayZoneRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListGatewayZoneResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListGatewayZone',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListGatewayZoneResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_gateway_zone(
        self,
        request: mse_20190531_models.ListGatewayZoneRequest,
    ) -> mse_20190531_models.ListGatewayZoneResponse:
        """
        @summary Obtains a list of zones where a gateway is available.
        
        @param request: ListGatewayZoneRequest
        @return: ListGatewayZoneResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_gateway_zone_with_options(request, runtime)

    async def list_gateway_zone_async(
        self,
        request: mse_20190531_models.ListGatewayZoneRequest,
    ) -> mse_20190531_models.ListGatewayZoneResponse:
        """
        @summary Obtains a list of zones where a gateway is available.
        
        @param request: ListGatewayZoneRequest
        @return: ListGatewayZoneResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_gateway_zone_with_options_async(request, runtime)

    def list_instance_count_with_options(
        self,
        request: mse_20190531_models.ListInstanceCountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListInstanceCountResponse:
        """
        @summary Displays the number of nodes that can be deployed for an instance.
        
        @param request: ListInstanceCountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListInstanceCountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_type):
            query['ClusterType'] = request.cluster_type
        if not UtilClient.is_unset(request.mse_version):
            query['MseVersion'] = request.mse_version
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListInstanceCount',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListInstanceCountResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_instance_count_with_options_async(
        self,
        request: mse_20190531_models.ListInstanceCountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListInstanceCountResponse:
        """
        @summary Displays the number of nodes that can be deployed for an instance.
        
        @param request: ListInstanceCountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListInstanceCountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_type):
            query['ClusterType'] = request.cluster_type
        if not UtilClient.is_unset(request.mse_version):
            query['MseVersion'] = request.mse_version
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListInstanceCount',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListInstanceCountResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_instance_count(
        self,
        request: mse_20190531_models.ListInstanceCountRequest,
    ) -> mse_20190531_models.ListInstanceCountResponse:
        """
        @summary Displays the number of nodes that can be deployed for an instance.
        
        @param request: ListInstanceCountRequest
        @return: ListInstanceCountResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_instance_count_with_options(request, runtime)

    async def list_instance_count_async(
        self,
        request: mse_20190531_models.ListInstanceCountRequest,
    ) -> mse_20190531_models.ListInstanceCountResponse:
        """
        @summary Displays the number of nodes that can be deployed for an instance.
        
        @param request: ListInstanceCountRequest
        @return: ListInstanceCountResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_instance_count_with_options_async(request, runtime)

    def list_isolation_rules_with_options(
        self,
        request: mse_20190531_models.ListIsolationRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListIsolationRulesResponse:
        """
        @summary 查询隔离规则
        
        @param request: ListIsolationRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListIsolationRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_index):
            query['PageIndex'] = request.page_index
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.resource_search_key):
            query['ResourceSearchKey'] = request.resource_search_key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListIsolationRules',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListIsolationRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_isolation_rules_with_options_async(
        self,
        request: mse_20190531_models.ListIsolationRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListIsolationRulesResponse:
        """
        @summary 查询隔离规则
        
        @param request: ListIsolationRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListIsolationRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_index):
            query['PageIndex'] = request.page_index
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.resource_search_key):
            query['ResourceSearchKey'] = request.resource_search_key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListIsolationRules',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListIsolationRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_isolation_rules(
        self,
        request: mse_20190531_models.ListIsolationRulesRequest,
    ) -> mse_20190531_models.ListIsolationRulesResponse:
        """
        @summary 查询隔离规则
        
        @param request: ListIsolationRulesRequest
        @return: ListIsolationRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_isolation_rules_with_options(request, runtime)

    async def list_isolation_rules_async(
        self,
        request: mse_20190531_models.ListIsolationRulesRequest,
    ) -> mse_20190531_models.ListIsolationRulesResponse:
        """
        @summary 查询隔离规则
        
        @param request: ListIsolationRulesRequest
        @return: ListIsolationRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_isolation_rules_with_options_async(request, runtime)

    def list_listeners_by_config_with_options(
        self,
        tmp_req: mse_20190531_models.ListListenersByConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListListenersByConfigResponse:
        """
        @summary Queries listeners based on configuration information.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param tmp_req: ListListenersByConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListListenersByConfigResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.ListListenersByConfigShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.ext_gray_rules):
            request.ext_gray_rules_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.ext_gray_rules, 'ExtGrayRules', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.data_id):
            query['DataId'] = request.data_id
        if not UtilClient.is_unset(request.ext_gray_rules_shrink):
            query['ExtGrayRules'] = request.ext_gray_rules_shrink
        if not UtilClient.is_unset(request.group):
            query['Group'] = request.group
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListListenersByConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListListenersByConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_listeners_by_config_with_options_async(
        self,
        tmp_req: mse_20190531_models.ListListenersByConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListListenersByConfigResponse:
        """
        @summary Queries listeners based on configuration information.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param tmp_req: ListListenersByConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListListenersByConfigResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.ListListenersByConfigShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.ext_gray_rules):
            request.ext_gray_rules_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.ext_gray_rules, 'ExtGrayRules', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.data_id):
            query['DataId'] = request.data_id
        if not UtilClient.is_unset(request.ext_gray_rules_shrink):
            query['ExtGrayRules'] = request.ext_gray_rules_shrink
        if not UtilClient.is_unset(request.group):
            query['Group'] = request.group
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListListenersByConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListListenersByConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_listeners_by_config(
        self,
        request: mse_20190531_models.ListListenersByConfigRequest,
    ) -> mse_20190531_models.ListListenersByConfigResponse:
        """
        @summary Queries listeners based on configuration information.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListListenersByConfigRequest
        @return: ListListenersByConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_listeners_by_config_with_options(request, runtime)

    async def list_listeners_by_config_async(
        self,
        request: mse_20190531_models.ListListenersByConfigRequest,
    ) -> mse_20190531_models.ListListenersByConfigResponse:
        """
        @summary Queries listeners based on configuration information.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListListenersByConfigRequest
        @return: ListListenersByConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_listeners_by_config_with_options_async(request, runtime)

    def list_listeners_by_ip_with_options(
        self,
        request: mse_20190531_models.ListListenersByIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListListenersByIpResponse:
        """
        @summary Queries the information about listeners based on IP addresses.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListListenersByIpRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListListenersByIpResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.ip):
            query['Ip'] = request.ip
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListListenersByIp',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListListenersByIpResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_listeners_by_ip_with_options_async(
        self,
        request: mse_20190531_models.ListListenersByIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListListenersByIpResponse:
        """
        @summary Queries the information about listeners based on IP addresses.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListListenersByIpRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListListenersByIpResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.ip):
            query['Ip'] = request.ip
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListListenersByIp',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListListenersByIpResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_listeners_by_ip(
        self,
        request: mse_20190531_models.ListListenersByIpRequest,
    ) -> mse_20190531_models.ListListenersByIpResponse:
        """
        @summary Queries the information about listeners based on IP addresses.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListListenersByIpRequest
        @return: ListListenersByIpResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_listeners_by_ip_with_options(request, runtime)

    async def list_listeners_by_ip_async(
        self,
        request: mse_20190531_models.ListListenersByIpRequest,
    ) -> mse_20190531_models.ListListenersByIpResponse:
        """
        @summary Queries the information about listeners based on IP addresses.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListListenersByIpRequest
        @return: ListListenersByIpResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_listeners_by_ip_with_options_async(request, runtime)

    def list_migration_task_with_options(
        self,
        request: mse_20190531_models.ListMigrationTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListMigrationTaskResponse:
        """
        @summary Queries information about a migration task.
        
        @param request: ListMigrationTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMigrationTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.origin_instance_name):
            query['OriginInstanceName'] = request.origin_instance_name
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListMigrationTask',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListMigrationTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_migration_task_with_options_async(
        self,
        request: mse_20190531_models.ListMigrationTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListMigrationTaskResponse:
        """
        @summary Queries information about a migration task.
        
        @param request: ListMigrationTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListMigrationTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.origin_instance_name):
            query['OriginInstanceName'] = request.origin_instance_name
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListMigrationTask',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListMigrationTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_migration_task(
        self,
        request: mse_20190531_models.ListMigrationTaskRequest,
    ) -> mse_20190531_models.ListMigrationTaskResponse:
        """
        @summary Queries information about a migration task.
        
        @param request: ListMigrationTaskRequest
        @return: ListMigrationTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_migration_task_with_options(request, runtime)

    async def list_migration_task_async(
        self,
        request: mse_20190531_models.ListMigrationTaskRequest,
    ) -> mse_20190531_models.ListMigrationTaskResponse:
        """
        @summary Queries information about a migration task.
        
        @param request: ListMigrationTaskRequest
        @return: ListMigrationTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_migration_task_with_options_async(request, runtime)

    def list_nacos_configs_with_options(
        self,
        request: mse_20190531_models.ListNacosConfigsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListNacosConfigsResponse:
        """
        @summary Queries Nacos configurations.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListNacosConfigsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListNacosConfigsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.data_id):
            query['DataId'] = request.data_id
        if not UtilClient.is_unset(request.group):
            query['Group'] = request.group
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.tags):
            query['Tags'] = request.tags
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListNacosConfigs',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListNacosConfigsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_nacos_configs_with_options_async(
        self,
        request: mse_20190531_models.ListNacosConfigsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListNacosConfigsResponse:
        """
        @summary Queries Nacos configurations.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListNacosConfigsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListNacosConfigsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.data_id):
            query['DataId'] = request.data_id
        if not UtilClient.is_unset(request.group):
            query['Group'] = request.group
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.tags):
            query['Tags'] = request.tags
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListNacosConfigs',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListNacosConfigsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_nacos_configs(
        self,
        request: mse_20190531_models.ListNacosConfigsRequest,
    ) -> mse_20190531_models.ListNacosConfigsResponse:
        """
        @summary Queries Nacos configurations.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListNacosConfigsRequest
        @return: ListNacosConfigsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_nacos_configs_with_options(request, runtime)

    async def list_nacos_configs_async(
        self,
        request: mse_20190531_models.ListNacosConfigsRequest,
    ) -> mse_20190531_models.ListNacosConfigsResponse:
        """
        @summary Queries Nacos configurations.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListNacosConfigsRequest
        @return: ListNacosConfigsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_nacos_configs_with_options_async(request, runtime)

    def list_nacos_history_configs_with_options(
        self,
        request: mse_20190531_models.ListNacosHistoryConfigsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListNacosHistoryConfigsResponse:
        """
        @summary Queries the configuration history of a Microservices Engine (MSE) Nacos instance.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListNacosHistoryConfigsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListNacosHistoryConfigsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.data_id):
            query['DataId'] = request.data_id
        if not UtilClient.is_unset(request.group):
            query['Group'] = request.group
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListNacosHistoryConfigs',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListNacosHistoryConfigsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_nacos_history_configs_with_options_async(
        self,
        request: mse_20190531_models.ListNacosHistoryConfigsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListNacosHistoryConfigsResponse:
        """
        @summary Queries the configuration history of a Microservices Engine (MSE) Nacos instance.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListNacosHistoryConfigsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListNacosHistoryConfigsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.data_id):
            query['DataId'] = request.data_id
        if not UtilClient.is_unset(request.group):
            query['Group'] = request.group
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.namespace_id):
            query['NamespaceId'] = request.namespace_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListNacosHistoryConfigs',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListNacosHistoryConfigsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_nacos_history_configs(
        self,
        request: mse_20190531_models.ListNacosHistoryConfigsRequest,
    ) -> mse_20190531_models.ListNacosHistoryConfigsResponse:
        """
        @summary Queries the configuration history of a Microservices Engine (MSE) Nacos instance.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListNacosHistoryConfigsRequest
        @return: ListNacosHistoryConfigsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_nacos_history_configs_with_options(request, runtime)

    async def list_nacos_history_configs_async(
        self,
        request: mse_20190531_models.ListNacosHistoryConfigsRequest,
    ) -> mse_20190531_models.ListNacosHistoryConfigsResponse:
        """
        @summary Queries the configuration history of a Microservices Engine (MSE) Nacos instance.
        
        @description > The operation is not provided in Nacos SDKs. For information about Nacos SDKs, see the [official documentation](https://nacos.io/zh-cn/docs/sdk.html).
        
        @param request: ListNacosHistoryConfigsRequest
        @return: ListNacosHistoryConfigsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_nacos_history_configs_with_options_async(request, runtime)

    def list_namespaces_with_options(
        self,
        tmp_req: mse_20190531_models.ListNamespacesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListNamespacesResponse:
        """
        @summary 展示命名空间列表
        
        @param tmp_req: ListNamespacesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListNamespacesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.ListNamespacesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.tag):
            request.tag_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.tag, 'Tag', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.tag_shrink):
            query['Tag'] = request.tag_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListNamespaces',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListNamespacesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_namespaces_with_options_async(
        self,
        tmp_req: mse_20190531_models.ListNamespacesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListNamespacesResponse:
        """
        @summary 展示命名空间列表
        
        @param tmp_req: ListNamespacesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListNamespacesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.ListNamespacesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.tag):
            request.tag_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.tag, 'Tag', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.tag_shrink):
            query['Tag'] = request.tag_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListNamespaces',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListNamespacesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_namespaces(
        self,
        request: mse_20190531_models.ListNamespacesRequest,
    ) -> mse_20190531_models.ListNamespacesResponse:
        """
        @summary 展示命名空间列表
        
        @param request: ListNamespacesRequest
        @return: ListNamespacesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_namespaces_with_options(request, runtime)

    async def list_namespaces_async(
        self,
        request: mse_20190531_models.ListNamespacesRequest,
    ) -> mse_20190531_models.ListNamespacesResponse:
        """
        @summary 展示命名空间列表
        
        @param request: ListNamespacesRequest
        @return: ListNamespacesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_namespaces_with_options_async(request, runtime)

    def list_naming_track_with_options(
        self,
        request: mse_20190531_models.ListNamingTrackRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListNamingTrackResponse:
        """
        @summary Obtains the trajectory data of a Nacos registry.
        
        @param request: ListNamingTrackRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListNamingTrackResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListNamingTrack',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListNamingTrackResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_naming_track_with_options_async(
        self,
        request: mse_20190531_models.ListNamingTrackRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListNamingTrackResponse:
        """
        @summary Obtains the trajectory data of a Nacos registry.
        
        @param request: ListNamingTrackRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListNamingTrackResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListNamingTrack',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListNamingTrackResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_naming_track(
        self,
        request: mse_20190531_models.ListNamingTrackRequest,
    ) -> mse_20190531_models.ListNamingTrackResponse:
        """
        @summary Obtains the trajectory data of a Nacos registry.
        
        @param request: ListNamingTrackRequest
        @return: ListNamingTrackResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_naming_track_with_options(request, runtime)

    async def list_naming_track_async(
        self,
        request: mse_20190531_models.ListNamingTrackRequest,
    ) -> mse_20190531_models.ListNamingTrackResponse:
        """
        @summary Obtains the trajectory data of a Nacos registry.
        
        @param request: ListNamingTrackRequest
        @return: ListNamingTrackResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_naming_track_with_options_async(request, runtime)

    def list_sslcert_with_options(
        self,
        request: mse_20190531_models.ListSSLCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListSSLCertResponse:
        """
        @summary Obtains a list of gateway certificates.
        
        @param request: ListSSLCertRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSSLCertResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cert_name):
            query['CertName'] = request.cert_name
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListSSLCert',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListSSLCertResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_sslcert_with_options_async(
        self,
        request: mse_20190531_models.ListSSLCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListSSLCertResponse:
        """
        @summary Obtains a list of gateway certificates.
        
        @param request: ListSSLCertRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSSLCertResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cert_name):
            query['CertName'] = request.cert_name
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListSSLCert',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListSSLCertResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_sslcert(
        self,
        request: mse_20190531_models.ListSSLCertRequest,
    ) -> mse_20190531_models.ListSSLCertResponse:
        """
        @summary Obtains a list of gateway certificates.
        
        @param request: ListSSLCertRequest
        @return: ListSSLCertResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_sslcert_with_options(request, runtime)

    async def list_sslcert_async(
        self,
        request: mse_20190531_models.ListSSLCertRequest,
    ) -> mse_20190531_models.ListSSLCertResponse:
        """
        @summary Obtains a list of gateway certificates.
        
        @param request: ListSSLCertRequest
        @return: ListSSLCertResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_sslcert_with_options_async(request, runtime)

    def list_security_group_with_options(
        self,
        request: mse_20190531_models.ListSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListSecurityGroupResponse:
        """
        @summary Obtains the information about security groups.
        
        @param request: ListSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListSecurityGroup',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListSecurityGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_security_group_with_options_async(
        self,
        request: mse_20190531_models.ListSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListSecurityGroupResponse:
        """
        @summary Obtains the information about security groups.
        
        @param request: ListSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListSecurityGroup',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListSecurityGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_security_group(
        self,
        request: mse_20190531_models.ListSecurityGroupRequest,
    ) -> mse_20190531_models.ListSecurityGroupResponse:
        """
        @summary Obtains the information about security groups.
        
        @param request: ListSecurityGroupRequest
        @return: ListSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_security_group_with_options(request, runtime)

    async def list_security_group_async(
        self,
        request: mse_20190531_models.ListSecurityGroupRequest,
    ) -> mse_20190531_models.ListSecurityGroupResponse:
        """
        @summary Obtains the information about security groups.
        
        @param request: ListSecurityGroupRequest
        @return: ListSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_security_group_with_options_async(request, runtime)

    def list_security_group_rule_with_options(
        self,
        request: mse_20190531_models.ListSecurityGroupRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListSecurityGroupRuleResponse:
        """
        @summary Queries the security group rules of a gateway.
        
        @param request: ListSecurityGroupRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSecurityGroupRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListSecurityGroupRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListSecurityGroupRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_security_group_rule_with_options_async(
        self,
        request: mse_20190531_models.ListSecurityGroupRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListSecurityGroupRuleResponse:
        """
        @summary Queries the security group rules of a gateway.
        
        @param request: ListSecurityGroupRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSecurityGroupRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListSecurityGroupRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListSecurityGroupRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_security_group_rule(
        self,
        request: mse_20190531_models.ListSecurityGroupRuleRequest,
    ) -> mse_20190531_models.ListSecurityGroupRuleResponse:
        """
        @summary Queries the security group rules of a gateway.
        
        @param request: ListSecurityGroupRuleRequest
        @return: ListSecurityGroupRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_security_group_rule_with_options(request, runtime)

    async def list_security_group_rule_async(
        self,
        request: mse_20190531_models.ListSecurityGroupRuleRequest,
    ) -> mse_20190531_models.ListSecurityGroupRuleResponse:
        """
        @summary Queries the security group rules of a gateway.
        
        @param request: ListSecurityGroupRuleRequest
        @return: ListSecurityGroupRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_security_group_rule_with_options_async(request, runtime)

    def list_sentinel_block_fallback_definitions_with_options(
        self,
        tmp_req: mse_20190531_models.ListSentinelBlockFallbackDefinitionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListSentinelBlockFallbackDefinitionsResponse:
        """
        @summary Obtains the custom behavior of traffic protection.
        
        @param tmp_req: ListSentinelBlockFallbackDefinitionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSentinelBlockFallbackDefinitionsResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.ListSentinelBlockFallbackDefinitionsShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.classification_set):
            request.classification_set_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.classification_set, 'ClassificationSet', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.classification_set_shrink):
            query['ClassificationSet'] = request.classification_set_shrink
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListSentinelBlockFallbackDefinitions',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListSentinelBlockFallbackDefinitionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_sentinel_block_fallback_definitions_with_options_async(
        self,
        tmp_req: mse_20190531_models.ListSentinelBlockFallbackDefinitionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListSentinelBlockFallbackDefinitionsResponse:
        """
        @summary Obtains the custom behavior of traffic protection.
        
        @param tmp_req: ListSentinelBlockFallbackDefinitionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListSentinelBlockFallbackDefinitionsResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.ListSentinelBlockFallbackDefinitionsShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.classification_set):
            request.classification_set_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.classification_set, 'ClassificationSet', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.classification_set_shrink):
            query['ClassificationSet'] = request.classification_set_shrink
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListSentinelBlockFallbackDefinitions',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListSentinelBlockFallbackDefinitionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_sentinel_block_fallback_definitions(
        self,
        request: mse_20190531_models.ListSentinelBlockFallbackDefinitionsRequest,
    ) -> mse_20190531_models.ListSentinelBlockFallbackDefinitionsResponse:
        """
        @summary Obtains the custom behavior of traffic protection.
        
        @param request: ListSentinelBlockFallbackDefinitionsRequest
        @return: ListSentinelBlockFallbackDefinitionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_sentinel_block_fallback_definitions_with_options(request, runtime)

    async def list_sentinel_block_fallback_definitions_async(
        self,
        request: mse_20190531_models.ListSentinelBlockFallbackDefinitionsRequest,
    ) -> mse_20190531_models.ListSentinelBlockFallbackDefinitionsResponse:
        """
        @summary Obtains the custom behavior of traffic protection.
        
        @param request: ListSentinelBlockFallbackDefinitionsRequest
        @return: ListSentinelBlockFallbackDefinitionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_sentinel_block_fallback_definitions_with_options_async(request, runtime)

    def list_service_source_with_options(
        self,
        request: mse_20190531_models.ListServiceSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListServiceSourceResponse:
        """
        @summary Queries a list of associated sources.
        
        @param request: ListServiceSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListServiceSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListServiceSource',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListServiceSourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_service_source_with_options_async(
        self,
        request: mse_20190531_models.ListServiceSourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListServiceSourceResponse:
        """
        @summary Queries a list of associated sources.
        
        @param request: ListServiceSourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListServiceSourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListServiceSource',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListServiceSourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_service_source(
        self,
        request: mse_20190531_models.ListServiceSourceRequest,
    ) -> mse_20190531_models.ListServiceSourceResponse:
        """
        @summary Queries a list of associated sources.
        
        @param request: ListServiceSourceRequest
        @return: ListServiceSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_service_source_with_options(request, runtime)

    async def list_service_source_async(
        self,
        request: mse_20190531_models.ListServiceSourceRequest,
    ) -> mse_20190531_models.ListServiceSourceResponse:
        """
        @summary Queries a list of associated sources.
        
        @param request: ListServiceSourceRequest
        @return: ListServiceSourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_service_source_with_options_async(request, runtime)

    def list_tag_resources_with_options(
        self,
        request: mse_20190531_models.ListTagResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListTagResourcesResponse:
        """
        @summary Queries tagged resources.
        
        @param request: ListTagResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListTagResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListTagResources',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListTagResourcesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_tag_resources_with_options_async(
        self,
        request: mse_20190531_models.ListTagResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListTagResourcesResponse:
        """
        @summary Queries tagged resources.
        
        @param request: ListTagResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListTagResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListTagResources',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListTagResourcesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_tag_resources(
        self,
        request: mse_20190531_models.ListTagResourcesRequest,
    ) -> mse_20190531_models.ListTagResourcesResponse:
        """
        @summary Queries tagged resources.
        
        @param request: ListTagResourcesRequest
        @return: ListTagResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_tag_resources_with_options(request, runtime)

    async def list_tag_resources_async(
        self,
        request: mse_20190531_models.ListTagResourcesRequest,
    ) -> mse_20190531_models.ListTagResourcesResponse:
        """
        @summary Queries tagged resources.
        
        @param request: ListTagResourcesRequest
        @return: ListTagResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_tag_resources_with_options_async(request, runtime)

    def list_web_flow_rules_with_options(
        self,
        request: mse_20190531_models.ListWebFlowRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListWebFlowRulesResponse:
        """
        @summary 查询热点参数防护规则（HTTP 请求）
        
        @param request: ListWebFlowRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListWebFlowRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_index):
            query['PageIndex'] = request.page_index
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.resource_search_key):
            query['ResourceSearchKey'] = request.resource_search_key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListWebFlowRules',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListWebFlowRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_web_flow_rules_with_options_async(
        self,
        request: mse_20190531_models.ListWebFlowRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListWebFlowRulesResponse:
        """
        @summary 查询热点参数防护规则（HTTP 请求）
        
        @param request: ListWebFlowRulesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListWebFlowRulesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_index):
            query['PageIndex'] = request.page_index
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.resource_search_key):
            query['ResourceSearchKey'] = request.resource_search_key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListWebFlowRules',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListWebFlowRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_web_flow_rules(
        self,
        request: mse_20190531_models.ListWebFlowRulesRequest,
    ) -> mse_20190531_models.ListWebFlowRulesResponse:
        """
        @summary 查询热点参数防护规则（HTTP 请求）
        
        @param request: ListWebFlowRulesRequest
        @return: ListWebFlowRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_web_flow_rules_with_options(request, runtime)

    async def list_web_flow_rules_async(
        self,
        request: mse_20190531_models.ListWebFlowRulesRequest,
    ) -> mse_20190531_models.ListWebFlowRulesResponse:
        """
        @summary 查询热点参数防护规则（HTTP 请求）
        
        @param request: ListWebFlowRulesRequest
        @return: ListWebFlowRulesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_web_flow_rules_with_options_async(request, runtime)

    def list_zk_track_with_options(
        self,
        request: mse_20190531_models.ListZkTrackRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListZkTrackResponse:
        """
        @summary Obtains the track data of a ZooKeeper instance.
        
        @param request: ListZkTrackRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListZkTrackResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.end_ts):
            query['EndTs'] = request.end_ts
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.path):
            query['Path'] = request.path
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.reverse):
            query['Reverse'] = request.reverse
        if not UtilClient.is_unset(request.session_id):
            query['SessionId'] = request.session_id
        if not UtilClient.is_unset(request.start_ts):
            query['StartTs'] = request.start_ts
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListZkTrack',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListZkTrackResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_zk_track_with_options_async(
        self,
        request: mse_20190531_models.ListZkTrackRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListZkTrackResponse:
        """
        @summary Obtains the track data of a ZooKeeper instance.
        
        @param request: ListZkTrackRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListZkTrackResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.end_ts):
            query['EndTs'] = request.end_ts
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.page_num):
            query['PageNum'] = request.page_num
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.path):
            query['Path'] = request.path
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.reverse):
            query['Reverse'] = request.reverse
        if not UtilClient.is_unset(request.session_id):
            query['SessionId'] = request.session_id
        if not UtilClient.is_unset(request.start_ts):
            query['StartTs'] = request.start_ts
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListZkTrack',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListZkTrackResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_zk_track(
        self,
        request: mse_20190531_models.ListZkTrackRequest,
    ) -> mse_20190531_models.ListZkTrackResponse:
        """
        @summary Obtains the track data of a ZooKeeper instance.
        
        @param request: ListZkTrackRequest
        @return: ListZkTrackResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_zk_track_with_options(request, runtime)

    async def list_zk_track_async(
        self,
        request: mse_20190531_models.ListZkTrackRequest,
    ) -> mse_20190531_models.ListZkTrackResponse:
        """
        @summary Obtains the track data of a ZooKeeper instance.
        
        @param request: ListZkTrackRequest
        @return: ListZkTrackResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_zk_track_with_options_async(request, runtime)

    def list_znode_children_with_options(
        self,
        request: mse_20190531_models.ListZnodeChildrenRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListZnodeChildrenResponse:
        """
        @summary Queries the child nodes of a ZooKeeper node.
        
        @param request: ListZnodeChildrenRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListZnodeChildrenResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.path):
            query['Path'] = request.path
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListZnodeChildren',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListZnodeChildrenResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_znode_children_with_options_async(
        self,
        request: mse_20190531_models.ListZnodeChildrenRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ListZnodeChildrenResponse:
        """
        @summary Queries the child nodes of a ZooKeeper node.
        
        @param request: ListZnodeChildrenRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListZnodeChildrenResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.path):
            query['Path'] = request.path
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListZnodeChildren',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ListZnodeChildrenResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_znode_children(
        self,
        request: mse_20190531_models.ListZnodeChildrenRequest,
    ) -> mse_20190531_models.ListZnodeChildrenResponse:
        """
        @summary Queries the child nodes of a ZooKeeper node.
        
        @param request: ListZnodeChildrenRequest
        @return: ListZnodeChildrenResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_znode_children_with_options(request, runtime)

    async def list_znode_children_async(
        self,
        request: mse_20190531_models.ListZnodeChildrenRequest,
    ) -> mse_20190531_models.ListZnodeChildrenResponse:
        """
        @summary Queries the child nodes of a ZooKeeper node.
        
        @param request: ListZnodeChildrenRequest
        @return: ListZnodeChildrenResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_znode_children_with_options_async(request, runtime)

    def modify_governance_kubernetes_cluster_with_options(
        self,
        tmp_req: mse_20190531_models.ModifyGovernanceKubernetesClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ModifyGovernanceKubernetesClusterResponse:
        """
        @summary Modifies the information about a cluster for which Microservice Governance is enabled.
        
        @param tmp_req: ModifyGovernanceKubernetesClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyGovernanceKubernetesClusterResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.ModifyGovernanceKubernetesClusterShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.namespace_infos):
            request.namespace_infos_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.namespace_infos, 'NamespaceInfos', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        body = {}
        if not UtilClient.is_unset(request.namespace_infos_shrink):
            body['NamespaceInfos'] = request.namespace_infos_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ModifyGovernanceKubernetesCluster',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ModifyGovernanceKubernetesClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_governance_kubernetes_cluster_with_options_async(
        self,
        tmp_req: mse_20190531_models.ModifyGovernanceKubernetesClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ModifyGovernanceKubernetesClusterResponse:
        """
        @summary Modifies the information about a cluster for which Microservice Governance is enabled.
        
        @param tmp_req: ModifyGovernanceKubernetesClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyGovernanceKubernetesClusterResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.ModifyGovernanceKubernetesClusterShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.namespace_infos):
            request.namespace_infos_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.namespace_infos, 'NamespaceInfos', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        body = {}
        if not UtilClient.is_unset(request.namespace_infos_shrink):
            body['NamespaceInfos'] = request.namespace_infos_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='ModifyGovernanceKubernetesCluster',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ModifyGovernanceKubernetesClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_governance_kubernetes_cluster(
        self,
        request: mse_20190531_models.ModifyGovernanceKubernetesClusterRequest,
    ) -> mse_20190531_models.ModifyGovernanceKubernetesClusterResponse:
        """
        @summary Modifies the information about a cluster for which Microservice Governance is enabled.
        
        @param request: ModifyGovernanceKubernetesClusterRequest
        @return: ModifyGovernanceKubernetesClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_governance_kubernetes_cluster_with_options(request, runtime)

    async def modify_governance_kubernetes_cluster_async(
        self,
        request: mse_20190531_models.ModifyGovernanceKubernetesClusterRequest,
    ) -> mse_20190531_models.ModifyGovernanceKubernetesClusterResponse:
        """
        @summary Modifies the information about a cluster for which Microservice Governance is enabled.
        
        @param request: ModifyGovernanceKubernetesClusterRequest
        @return: ModifyGovernanceKubernetesClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_governance_kubernetes_cluster_with_options_async(request, runtime)

    def modify_lossless_rule_with_options(
        self,
        request: mse_20190531_models.ModifyLosslessRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ModifyLosslessRuleResponse:
        """
        @summary Modifies configurations of the lossless online and offline feature.
        
        @param request: ModifyLosslessRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyLosslessRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.aligned):
            query['Aligned'] = request.aligned
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.delay_time):
            query['DelayTime'] = request.delay_time
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.func_type):
            query['FuncType'] = request.func_type
        if not UtilClient.is_unset(request.loss_less_detail):
            query['LossLessDetail'] = request.loss_less_detail
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.notice):
            query['Notice'] = request.notice
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.related):
            query['Related'] = request.related
        if not UtilClient.is_unset(request.warmup_time):
            query['WarmupTime'] = request.warmup_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyLosslessRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ModifyLosslessRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_lossless_rule_with_options_async(
        self,
        request: mse_20190531_models.ModifyLosslessRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.ModifyLosslessRuleResponse:
        """
        @summary Modifies configurations of the lossless online and offline feature.
        
        @param request: ModifyLosslessRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyLosslessRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.aligned):
            query['Aligned'] = request.aligned
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.delay_time):
            query['DelayTime'] = request.delay_time
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.func_type):
            query['FuncType'] = request.func_type
        if not UtilClient.is_unset(request.loss_less_detail):
            query['LossLessDetail'] = request.loss_less_detail
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.notice):
            query['Notice'] = request.notice
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.related):
            query['Related'] = request.related
        if not UtilClient.is_unset(request.warmup_time):
            query['WarmupTime'] = request.warmup_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyLosslessRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.ModifyLosslessRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_lossless_rule(
        self,
        request: mse_20190531_models.ModifyLosslessRuleRequest,
    ) -> mse_20190531_models.ModifyLosslessRuleResponse:
        """
        @summary Modifies configurations of the lossless online and offline feature.
        
        @param request: ModifyLosslessRuleRequest
        @return: ModifyLosslessRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_lossless_rule_with_options(request, runtime)

    async def modify_lossless_rule_async(
        self,
        request: mse_20190531_models.ModifyLosslessRuleRequest,
    ) -> mse_20190531_models.ModifyLosslessRuleResponse:
        """
        @summary Modifies configurations of the lossless online and offline feature.
        
        @param request: ModifyLosslessRuleRequest
        @return: ModifyLosslessRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_lossless_rule_with_options_async(request, runtime)

    def offline_gateway_route_with_options(
        self,
        request: mse_20190531_models.OfflineGatewayRouteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.OfflineGatewayRouteResponse:
        """
        @summary Unpublishes a route for a gateway.
        
        @param request: OfflineGatewayRouteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: OfflineGatewayRouteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.route_id):
            query['RouteId'] = request.route_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='OfflineGatewayRoute',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.OfflineGatewayRouteResponse(),
            self.call_api(params, req, runtime)
        )

    async def offline_gateway_route_with_options_async(
        self,
        request: mse_20190531_models.OfflineGatewayRouteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.OfflineGatewayRouteResponse:
        """
        @summary Unpublishes a route for a gateway.
        
        @param request: OfflineGatewayRouteRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: OfflineGatewayRouteResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.route_id):
            query['RouteId'] = request.route_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='OfflineGatewayRoute',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.OfflineGatewayRouteResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def offline_gateway_route(
        self,
        request: mse_20190531_models.OfflineGatewayRouteRequest,
    ) -> mse_20190531_models.OfflineGatewayRouteResponse:
        """
        @summary Unpublishes a route for a gateway.
        
        @param request: OfflineGatewayRouteRequest
        @return: OfflineGatewayRouteResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.offline_gateway_route_with_options(request, runtime)

    async def offline_gateway_route_async(
        self,
        request: mse_20190531_models.OfflineGatewayRouteRequest,
    ) -> mse_20190531_models.OfflineGatewayRouteResponse:
        """
        @summary Unpublishes a route for a gateway.
        
        @param request: OfflineGatewayRouteRequest
        @return: OfflineGatewayRouteResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.offline_gateway_route_with_options_async(request, runtime)

    def order_cluster_health_check_risk_notice_with_options(
        self,
        request: mse_20190531_models.OrderClusterHealthCheckRiskNoticeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.OrderClusterHealthCheckRiskNoticeResponse:
        """
        @summary Subscribes to the notification feature if a risk is detected during a health check.
        
        @param request: OrderClusterHealthCheckRiskNoticeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: OrderClusterHealthCheckRiskNoticeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.mute):
            query['Mute'] = request.mute
        if not UtilClient.is_unset(request.notice_type):
            query['NoticeType'] = request.notice_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.risk_code):
            query['RiskCode'] = request.risk_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='OrderClusterHealthCheckRiskNotice',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.OrderClusterHealthCheckRiskNoticeResponse(),
            self.call_api(params, req, runtime)
        )

    async def order_cluster_health_check_risk_notice_with_options_async(
        self,
        request: mse_20190531_models.OrderClusterHealthCheckRiskNoticeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.OrderClusterHealthCheckRiskNoticeResponse:
        """
        @summary Subscribes to the notification feature if a risk is detected during a health check.
        
        @param request: OrderClusterHealthCheckRiskNoticeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: OrderClusterHealthCheckRiskNoticeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.mute):
            query['Mute'] = request.mute
        if not UtilClient.is_unset(request.notice_type):
            query['NoticeType'] = request.notice_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.risk_code):
            query['RiskCode'] = request.risk_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='OrderClusterHealthCheckRiskNotice',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.OrderClusterHealthCheckRiskNoticeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def order_cluster_health_check_risk_notice(
        self,
        request: mse_20190531_models.OrderClusterHealthCheckRiskNoticeRequest,
    ) -> mse_20190531_models.OrderClusterHealthCheckRiskNoticeResponse:
        """
        @summary Subscribes to the notification feature if a risk is detected during a health check.
        
        @param request: OrderClusterHealthCheckRiskNoticeRequest
        @return: OrderClusterHealthCheckRiskNoticeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.order_cluster_health_check_risk_notice_with_options(request, runtime)

    async def order_cluster_health_check_risk_notice_async(
        self,
        request: mse_20190531_models.OrderClusterHealthCheckRiskNoticeRequest,
    ) -> mse_20190531_models.OrderClusterHealthCheckRiskNoticeResponse:
        """
        @summary Subscribes to the notification feature if a risk is detected during a health check.
        
        @param request: OrderClusterHealthCheckRiskNoticeRequest
        @return: OrderClusterHealthCheckRiskNoticeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.order_cluster_health_check_risk_notice_with_options_async(request, runtime)

    def preserve_header_format_with_options(
        self,
        request: mse_20190531_models.PreserveHeaderFormatRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.PreserveHeaderFormatResponse:
        """
        @summary Specifies whether to convert all letters of a header into lowercase letters. For requests and responses, HTTP/1.1 headers are not case-sensitive. By default, all letters of headers are converted into lowercase letters.
        
        @param request: PreserveHeaderFormatRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: PreserveHeaderFormatResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.preserve_header_format):
            query['PreserveHeaderFormat'] = request.preserve_header_format
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='PreserveHeaderFormat',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.PreserveHeaderFormatResponse(),
            self.call_api(params, req, runtime)
        )

    async def preserve_header_format_with_options_async(
        self,
        request: mse_20190531_models.PreserveHeaderFormatRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.PreserveHeaderFormatResponse:
        """
        @summary Specifies whether to convert all letters of a header into lowercase letters. For requests and responses, HTTP/1.1 headers are not case-sensitive. By default, all letters of headers are converted into lowercase letters.
        
        @param request: PreserveHeaderFormatRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: PreserveHeaderFormatResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.preserve_header_format):
            query['PreserveHeaderFormat'] = request.preserve_header_format
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='PreserveHeaderFormat',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.PreserveHeaderFormatResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def preserve_header_format(
        self,
        request: mse_20190531_models.PreserveHeaderFormatRequest,
    ) -> mse_20190531_models.PreserveHeaderFormatResponse:
        """
        @summary Specifies whether to convert all letters of a header into lowercase letters. For requests and responses, HTTP/1.1 headers are not case-sensitive. By default, all letters of headers are converted into lowercase letters.
        
        @param request: PreserveHeaderFormatRequest
        @return: PreserveHeaderFormatResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.preserve_header_format_with_options(request, runtime)

    async def preserve_header_format_async(
        self,
        request: mse_20190531_models.PreserveHeaderFormatRequest,
    ) -> mse_20190531_models.PreserveHeaderFormatResponse:
        """
        @summary Specifies whether to convert all letters of a header into lowercase letters. For requests and responses, HTTP/1.1 headers are not case-sensitive. By default, all letters of headers are converted into lowercase letters.
        
        @param request: PreserveHeaderFormatRequest
        @return: PreserveHeaderFormatResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.preserve_header_format_with_options_async(request, runtime)

    def pull_services_with_options(
        self,
        request: mse_20190531_models.PullServicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.PullServicesResponse:
        """
        @summary Queries all the microservices of a service source.
        
        @param request: PullServicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: PullServicesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.source_id):
            query['SourceId'] = request.source_id
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='PullServices',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.PullServicesResponse(),
            self.call_api(params, req, runtime)
        )

    async def pull_services_with_options_async(
        self,
        request: mse_20190531_models.PullServicesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.PullServicesResponse:
        """
        @summary Queries all the microservices of a service source.
        
        @param request: PullServicesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: PullServicesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.source_id):
            query['SourceId'] = request.source_id
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='PullServices',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.PullServicesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def pull_services(
        self,
        request: mse_20190531_models.PullServicesRequest,
    ) -> mse_20190531_models.PullServicesResponse:
        """
        @summary Queries all the microservices of a service source.
        
        @param request: PullServicesRequest
        @return: PullServicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.pull_services_with_options(request, runtime)

    async def pull_services_async(
        self,
        request: mse_20190531_models.PullServicesRequest,
    ) -> mse_20190531_models.PullServicesResponse:
        """
        @summary Queries all the microservices of a service source.
        
        @param request: PullServicesRequest
        @return: PullServicesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.pull_services_with_options_async(request, runtime)

    def put_cluster_health_check_task_with_options(
        self,
        request: mse_20190531_models.PutClusterHealthCheckTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.PutClusterHealthCheckTaskResponse:
        """
        @summary Initiates a task to check risk evaluation for an instance.
        
        @param request: PutClusterHealthCheckTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: PutClusterHealthCheckTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='PutClusterHealthCheckTask',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.PutClusterHealthCheckTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def put_cluster_health_check_task_with_options_async(
        self,
        request: mse_20190531_models.PutClusterHealthCheckTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.PutClusterHealthCheckTaskResponse:
        """
        @summary Initiates a task to check risk evaluation for an instance.
        
        @param request: PutClusterHealthCheckTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: PutClusterHealthCheckTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='PutClusterHealthCheckTask',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.PutClusterHealthCheckTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def put_cluster_health_check_task(
        self,
        request: mse_20190531_models.PutClusterHealthCheckTaskRequest,
    ) -> mse_20190531_models.PutClusterHealthCheckTaskResponse:
        """
        @summary Initiates a task to check risk evaluation for an instance.
        
        @param request: PutClusterHealthCheckTaskRequest
        @return: PutClusterHealthCheckTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.put_cluster_health_check_task_with_options(request, runtime)

    async def put_cluster_health_check_task_async(
        self,
        request: mse_20190531_models.PutClusterHealthCheckTaskRequest,
    ) -> mse_20190531_models.PutClusterHealthCheckTaskResponse:
        """
        @summary Initiates a task to check risk evaluation for an instance.
        
        @param request: PutClusterHealthCheckTaskRequest
        @return: PutClusterHealthCheckTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.put_cluster_health_check_task_with_options_async(request, runtime)

    def query_all_swimming_lane_with_options(
        self,
        request: mse_20190531_models.QueryAllSwimmingLaneRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryAllSwimmingLaneResponse:
        """
        @summary Queries all the lanes in a lane group.
        
        @param request: QueryAllSwimmingLaneRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryAllSwimmingLaneResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryAllSwimmingLane',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryAllSwimmingLaneResponse(),
            self.call_api(params, req, runtime)
        )

    async def query_all_swimming_lane_with_options_async(
        self,
        request: mse_20190531_models.QueryAllSwimmingLaneRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryAllSwimmingLaneResponse:
        """
        @summary Queries all the lanes in a lane group.
        
        @param request: QueryAllSwimmingLaneRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryAllSwimmingLaneResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryAllSwimmingLane',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryAllSwimmingLaneResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def query_all_swimming_lane(
        self,
        request: mse_20190531_models.QueryAllSwimmingLaneRequest,
    ) -> mse_20190531_models.QueryAllSwimmingLaneResponse:
        """
        @summary Queries all the lanes in a lane group.
        
        @param request: QueryAllSwimmingLaneRequest
        @return: QueryAllSwimmingLaneResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.query_all_swimming_lane_with_options(request, runtime)

    async def query_all_swimming_lane_async(
        self,
        request: mse_20190531_models.QueryAllSwimmingLaneRequest,
    ) -> mse_20190531_models.QueryAllSwimmingLaneResponse:
        """
        @summary Queries all the lanes in a lane group.
        
        @param request: QueryAllSwimmingLaneRequest
        @return: QueryAllSwimmingLaneResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.query_all_swimming_lane_with_options_async(request, runtime)

    def query_all_swimming_lane_group_with_options(
        self,
        request: mse_20190531_models.QueryAllSwimmingLaneGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryAllSwimmingLaneGroupResponse:
        """
        @summary Queries all lane groups.
        
        @param request: QueryAllSwimmingLaneGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryAllSwimmingLaneGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryAllSwimmingLaneGroup',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryAllSwimmingLaneGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def query_all_swimming_lane_group_with_options_async(
        self,
        request: mse_20190531_models.QueryAllSwimmingLaneGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryAllSwimmingLaneGroupResponse:
        """
        @summary Queries all lane groups.
        
        @param request: QueryAllSwimmingLaneGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryAllSwimmingLaneGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryAllSwimmingLaneGroup',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryAllSwimmingLaneGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def query_all_swimming_lane_group(
        self,
        request: mse_20190531_models.QueryAllSwimmingLaneGroupRequest,
    ) -> mse_20190531_models.QueryAllSwimmingLaneGroupResponse:
        """
        @summary Queries all lane groups.
        
        @param request: QueryAllSwimmingLaneGroupRequest
        @return: QueryAllSwimmingLaneGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.query_all_swimming_lane_group_with_options(request, runtime)

    async def query_all_swimming_lane_group_async(
        self,
        request: mse_20190531_models.QueryAllSwimmingLaneGroupRequest,
    ) -> mse_20190531_models.QueryAllSwimmingLaneGroupResponse:
        """
        @summary Queries all lane groups.
        
        @param request: QueryAllSwimmingLaneGroupRequest
        @return: QueryAllSwimmingLaneGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.query_all_swimming_lane_group_with_options_async(request, runtime)

    def query_business_locations_with_options(
        self,
        request: mse_20190531_models.QueryBusinessLocationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryBusinessLocationsResponse:
        """
        @summary Queries information about regions.
        
        @param request: QueryBusinessLocationsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryBusinessLocationsResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryBusinessLocations',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryBusinessLocationsResponse(),
            self.call_api(params, req, runtime)
        )

    async def query_business_locations_with_options_async(
        self,
        request: mse_20190531_models.QueryBusinessLocationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryBusinessLocationsResponse:
        """
        @summary Queries information about regions.
        
        @param request: QueryBusinessLocationsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryBusinessLocationsResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryBusinessLocations',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryBusinessLocationsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def query_business_locations(
        self,
        request: mse_20190531_models.QueryBusinessLocationsRequest,
    ) -> mse_20190531_models.QueryBusinessLocationsResponse:
        """
        @summary Queries information about regions.
        
        @param request: QueryBusinessLocationsRequest
        @return: QueryBusinessLocationsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.query_business_locations_with_options(request, runtime)

    async def query_business_locations_async(
        self,
        request: mse_20190531_models.QueryBusinessLocationsRequest,
    ) -> mse_20190531_models.QueryBusinessLocationsResponse:
        """
        @summary Queries information about regions.
        
        @param request: QueryBusinessLocationsRequest
        @return: QueryBusinessLocationsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.query_business_locations_with_options_async(request, runtime)

    def query_cluster_detail_with_options(
        self,
        request: mse_20190531_models.QueryClusterDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryClusterDetailResponse:
        """
        @summary Queries the details of an instance.
        
        @param request: QueryClusterDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryClusterDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.acl_switch):
            query['AclSwitch'] = request.acl_switch
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.order_id):
            query['OrderId'] = request.order_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryClusterDetail',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryClusterDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def query_cluster_detail_with_options_async(
        self,
        request: mse_20190531_models.QueryClusterDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryClusterDetailResponse:
        """
        @summary Queries the details of an instance.
        
        @param request: QueryClusterDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryClusterDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.acl_switch):
            query['AclSwitch'] = request.acl_switch
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.order_id):
            query['OrderId'] = request.order_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryClusterDetail',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryClusterDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def query_cluster_detail(
        self,
        request: mse_20190531_models.QueryClusterDetailRequest,
    ) -> mse_20190531_models.QueryClusterDetailResponse:
        """
        @summary Queries the details of an instance.
        
        @param request: QueryClusterDetailRequest
        @return: QueryClusterDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.query_cluster_detail_with_options(request, runtime)

    async def query_cluster_detail_async(
        self,
        request: mse_20190531_models.QueryClusterDetailRequest,
    ) -> mse_20190531_models.QueryClusterDetailResponse:
        """
        @summary Queries the details of an instance.
        
        @param request: QueryClusterDetailRequest
        @return: QueryClusterDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.query_cluster_detail_with_options_async(request, runtime)

    def query_cluster_disk_specification_with_options(
        self,
        request: mse_20190531_models.QueryClusterDiskSpecificationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryClusterDiskSpecificationResponse:
        """
        @summary Queries disk specifications that are supported by an instance.
        
        @param request: QueryClusterDiskSpecificationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryClusterDiskSpecificationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_type):
            query['ClusterType'] = request.cluster_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryClusterDiskSpecification',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryClusterDiskSpecificationResponse(),
            self.call_api(params, req, runtime)
        )

    async def query_cluster_disk_specification_with_options_async(
        self,
        request: mse_20190531_models.QueryClusterDiskSpecificationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryClusterDiskSpecificationResponse:
        """
        @summary Queries disk specifications that are supported by an instance.
        
        @param request: QueryClusterDiskSpecificationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryClusterDiskSpecificationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_type):
            query['ClusterType'] = request.cluster_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryClusterDiskSpecification',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryClusterDiskSpecificationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def query_cluster_disk_specification(
        self,
        request: mse_20190531_models.QueryClusterDiskSpecificationRequest,
    ) -> mse_20190531_models.QueryClusterDiskSpecificationResponse:
        """
        @summary Queries disk specifications that are supported by an instance.
        
        @param request: QueryClusterDiskSpecificationRequest
        @return: QueryClusterDiskSpecificationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.query_cluster_disk_specification_with_options(request, runtime)

    async def query_cluster_disk_specification_async(
        self,
        request: mse_20190531_models.QueryClusterDiskSpecificationRequest,
    ) -> mse_20190531_models.QueryClusterDiskSpecificationResponse:
        """
        @summary Queries disk specifications that are supported by an instance.
        
        @param request: QueryClusterDiskSpecificationRequest
        @return: QueryClusterDiskSpecificationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.query_cluster_disk_specification_with_options_async(request, runtime)

    def query_cluster_info_with_options(
        self,
        request: mse_20190531_models.QueryClusterInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryClusterInfoResponse:
        """
        @summary Queries the static information of an instance.
        
        @param request: QueryClusterInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryClusterInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.acl_switch):
            query['AclSwitch'] = request.acl_switch
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.order_id):
            query['OrderId'] = request.order_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryClusterInfo',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryClusterInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def query_cluster_info_with_options_async(
        self,
        request: mse_20190531_models.QueryClusterInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryClusterInfoResponse:
        """
        @summary Queries the static information of an instance.
        
        @param request: QueryClusterInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryClusterInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.acl_switch):
            query['AclSwitch'] = request.acl_switch
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.order_id):
            query['OrderId'] = request.order_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryClusterInfo',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryClusterInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def query_cluster_info(
        self,
        request: mse_20190531_models.QueryClusterInfoRequest,
    ) -> mse_20190531_models.QueryClusterInfoResponse:
        """
        @summary Queries the static information of an instance.
        
        @param request: QueryClusterInfoRequest
        @return: QueryClusterInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.query_cluster_info_with_options(request, runtime)

    async def query_cluster_info_async(
        self,
        request: mse_20190531_models.QueryClusterInfoRequest,
    ) -> mse_20190531_models.QueryClusterInfoResponse:
        """
        @summary Queries the static information of an instance.
        
        @param request: QueryClusterInfoRequest
        @return: QueryClusterInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.query_cluster_info_with_options_async(request, runtime)

    def query_cluster_specification_with_options(
        self,
        request: mse_20190531_models.QueryClusterSpecificationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryClusterSpecificationResponse:
        """
        @summary Queries the information of supported instance specifications.
        
        @param request: QueryClusterSpecificationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryClusterSpecificationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.connect_type):
            query['ConnectType'] = request.connect_type
        if not UtilClient.is_unset(request.mse_version):
            query['MseVersion'] = request.mse_version
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryClusterSpecification',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryClusterSpecificationResponse(),
            self.call_api(params, req, runtime)
        )

    async def query_cluster_specification_with_options_async(
        self,
        request: mse_20190531_models.QueryClusterSpecificationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryClusterSpecificationResponse:
        """
        @summary Queries the information of supported instance specifications.
        
        @param request: QueryClusterSpecificationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryClusterSpecificationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.connect_type):
            query['ConnectType'] = request.connect_type
        if not UtilClient.is_unset(request.mse_version):
            query['MseVersion'] = request.mse_version
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryClusterSpecification',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryClusterSpecificationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def query_cluster_specification(
        self,
        request: mse_20190531_models.QueryClusterSpecificationRequest,
    ) -> mse_20190531_models.QueryClusterSpecificationResponse:
        """
        @summary Queries the information of supported instance specifications.
        
        @param request: QueryClusterSpecificationRequest
        @return: QueryClusterSpecificationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.query_cluster_specification_with_options(request, runtime)

    async def query_cluster_specification_async(
        self,
        request: mse_20190531_models.QueryClusterSpecificationRequest,
    ) -> mse_20190531_models.QueryClusterSpecificationResponse:
        """
        @summary Queries the information of supported instance specifications.
        
        @param request: QueryClusterSpecificationRequest
        @return: QueryClusterSpecificationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.query_cluster_specification_with_options_async(request, runtime)

    def query_config_with_options(
        self,
        request: mse_20190531_models.QueryConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryConfigResponse:
        """
        @summary Queries configuration information of an instance.
        
        @param request: QueryConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.config_type):
            query['ConfigType'] = request.config_type
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.need_running_conf):
            query['NeedRunningConf'] = request.need_running_conf
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def query_config_with_options_async(
        self,
        request: mse_20190531_models.QueryConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryConfigResponse:
        """
        @summary Queries configuration information of an instance.
        
        @param request: QueryConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.config_type):
            query['ConfigType'] = request.config_type
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.need_running_conf):
            query['NeedRunningConf'] = request.need_running_conf
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def query_config(
        self,
        request: mse_20190531_models.QueryConfigRequest,
    ) -> mse_20190531_models.QueryConfigResponse:
        """
        @summary Queries configuration information of an instance.
        
        @param request: QueryConfigRequest
        @return: QueryConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.query_config_with_options(request, runtime)

    async def query_config_async(
        self,
        request: mse_20190531_models.QueryConfigRequest,
    ) -> mse_20190531_models.QueryConfigResponse:
        """
        @summary Queries configuration information of an instance.
        
        @param request: QueryConfigRequest
        @return: QueryConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.query_config_with_options_async(request, runtime)

    def query_gateway_region_with_options(
        self,
        request: mse_20190531_models.QueryGatewayRegionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryGatewayRegionResponse:
        """
        @summary Queries the regions supported by a gateway.
        
        @param request: QueryGatewayRegionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryGatewayRegionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryGatewayRegion',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryGatewayRegionResponse(),
            self.call_api(params, req, runtime)
        )

    async def query_gateway_region_with_options_async(
        self,
        request: mse_20190531_models.QueryGatewayRegionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryGatewayRegionResponse:
        """
        @summary Queries the regions supported by a gateway.
        
        @param request: QueryGatewayRegionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryGatewayRegionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryGatewayRegion',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryGatewayRegionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def query_gateway_region(
        self,
        request: mse_20190531_models.QueryGatewayRegionRequest,
    ) -> mse_20190531_models.QueryGatewayRegionResponse:
        """
        @summary Queries the regions supported by a gateway.
        
        @param request: QueryGatewayRegionRequest
        @return: QueryGatewayRegionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.query_gateway_region_with_options(request, runtime)

    async def query_gateway_region_async(
        self,
        request: mse_20190531_models.QueryGatewayRegionRequest,
    ) -> mse_20190531_models.QueryGatewayRegionResponse:
        """
        @summary Queries the regions supported by a gateway.
        
        @param request: QueryGatewayRegionRequest
        @return: QueryGatewayRegionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.query_gateway_region_with_options_async(request, runtime)

    def query_gateway_type_with_options(
        self,
        request: mse_20190531_models.QueryGatewayTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryGatewayTypeResponse:
        """
        @summary Queries available gateway types.
        
        @param request: QueryGatewayTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryGatewayTypeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryGatewayType',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryGatewayTypeResponse(),
            self.call_api(params, req, runtime)
        )

    async def query_gateway_type_with_options_async(
        self,
        request: mse_20190531_models.QueryGatewayTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryGatewayTypeResponse:
        """
        @summary Queries available gateway types.
        
        @param request: QueryGatewayTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryGatewayTypeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryGatewayType',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryGatewayTypeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def query_gateway_type(
        self,
        request: mse_20190531_models.QueryGatewayTypeRequest,
    ) -> mse_20190531_models.QueryGatewayTypeResponse:
        """
        @summary Queries available gateway types.
        
        @param request: QueryGatewayTypeRequest
        @return: QueryGatewayTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.query_gateway_type_with_options(request, runtime)

    async def query_gateway_type_async(
        self,
        request: mse_20190531_models.QueryGatewayTypeRequest,
    ) -> mse_20190531_models.QueryGatewayTypeResponse:
        """
        @summary Queries available gateway types.
        
        @param request: QueryGatewayTypeRequest
        @return: QueryGatewayTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.query_gateway_type_with_options_async(request, runtime)

    def query_governance_kubernetes_cluster_with_options(
        self,
        request: mse_20190531_models.QueryGovernanceKubernetesClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryGovernanceKubernetesClusterResponse:
        """
        @summary Queries the Kubernetes clusters for which Microservices Governance is activated.
        
        @param request: QueryGovernanceKubernetesClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryGovernanceKubernetesClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryGovernanceKubernetesCluster',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryGovernanceKubernetesClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def query_governance_kubernetes_cluster_with_options_async(
        self,
        request: mse_20190531_models.QueryGovernanceKubernetesClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryGovernanceKubernetesClusterResponse:
        """
        @summary Queries the Kubernetes clusters for which Microservices Governance is activated.
        
        @param request: QueryGovernanceKubernetesClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryGovernanceKubernetesClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryGovernanceKubernetesCluster',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryGovernanceKubernetesClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def query_governance_kubernetes_cluster(
        self,
        request: mse_20190531_models.QueryGovernanceKubernetesClusterRequest,
    ) -> mse_20190531_models.QueryGovernanceKubernetesClusterResponse:
        """
        @summary Queries the Kubernetes clusters for which Microservices Governance is activated.
        
        @param request: QueryGovernanceKubernetesClusterRequest
        @return: QueryGovernanceKubernetesClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.query_governance_kubernetes_cluster_with_options(request, runtime)

    async def query_governance_kubernetes_cluster_async(
        self,
        request: mse_20190531_models.QueryGovernanceKubernetesClusterRequest,
    ) -> mse_20190531_models.QueryGovernanceKubernetesClusterResponse:
        """
        @summary Queries the Kubernetes clusters for which Microservices Governance is activated.
        
        @param request: QueryGovernanceKubernetesClusterRequest
        @return: QueryGovernanceKubernetesClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.query_governance_kubernetes_cluster_with_options_async(request, runtime)

    def query_instances_info_with_options(
        self,
        request: mse_20190531_models.QueryInstancesInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryInstancesInfoResponse:
        """
        @summary Queries the runtime data of a specified cluster.
        
        @param request: QueryInstancesInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryInstancesInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.order_id):
            query['OrderId'] = request.order_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryInstancesInfo',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryInstancesInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def query_instances_info_with_options_async(
        self,
        request: mse_20190531_models.QueryInstancesInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryInstancesInfoResponse:
        """
        @summary Queries the runtime data of a specified cluster.
        
        @param request: QueryInstancesInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryInstancesInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.order_id):
            query['OrderId'] = request.order_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryInstancesInfo',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryInstancesInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def query_instances_info(
        self,
        request: mse_20190531_models.QueryInstancesInfoRequest,
    ) -> mse_20190531_models.QueryInstancesInfoResponse:
        """
        @summary Queries the runtime data of a specified cluster.
        
        @param request: QueryInstancesInfoRequest
        @return: QueryInstancesInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.query_instances_info_with_options(request, runtime)

    async def query_instances_info_async(
        self,
        request: mse_20190531_models.QueryInstancesInfoRequest,
    ) -> mse_20190531_models.QueryInstancesInfoResponse:
        """
        @summary Queries the runtime data of a specified cluster.
        
        @param request: QueryInstancesInfoRequest
        @return: QueryInstancesInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.query_instances_info_with_options_async(request, runtime)

    def query_monitor_with_options(
        self,
        request: mse_20190531_models.QueryMonitorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryMonitorResponse:
        """
        @summary Queries monitoring information.
        
        @param request: QueryMonitorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryMonitorResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.monitor_type):
            query['MonitorType'] = request.monitor_type
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.step):
            query['Step'] = request.step
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryMonitor',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryMonitorResponse(),
            self.call_api(params, req, runtime)
        )

    async def query_monitor_with_options_async(
        self,
        request: mse_20190531_models.QueryMonitorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryMonitorResponse:
        """
        @summary Queries monitoring information.
        
        @param request: QueryMonitorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryMonitorResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.monitor_type):
            query['MonitorType'] = request.monitor_type
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.step):
            query['Step'] = request.step
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryMonitor',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryMonitorResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def query_monitor(
        self,
        request: mse_20190531_models.QueryMonitorRequest,
    ) -> mse_20190531_models.QueryMonitorResponse:
        """
        @summary Queries monitoring information.
        
        @param request: QueryMonitorRequest
        @return: QueryMonitorResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.query_monitor_with_options(request, runtime)

    async def query_monitor_async(
        self,
        request: mse_20190531_models.QueryMonitorRequest,
    ) -> mse_20190531_models.QueryMonitorResponse:
        """
        @summary Queries monitoring information.
        
        @param request: QueryMonitorRequest
        @return: QueryMonitorResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.query_monitor_with_options_async(request, runtime)

    def query_namespace_with_options(
        self,
        request: mse_20190531_models.QueryNamespaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryNamespaceResponse:
        """
        @summary 查询MSE命名空间
        
        @param request: QueryNamespaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryNamespaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryNamespace',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryNamespaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def query_namespace_with_options_async(
        self,
        request: mse_20190531_models.QueryNamespaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryNamespaceResponse:
        """
        @summary 查询MSE命名空间
        
        @param request: QueryNamespaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryNamespaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryNamespace',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryNamespaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def query_namespace(
        self,
        request: mse_20190531_models.QueryNamespaceRequest,
    ) -> mse_20190531_models.QueryNamespaceResponse:
        """
        @summary 查询MSE命名空间
        
        @param request: QueryNamespaceRequest
        @return: QueryNamespaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.query_namespace_with_options(request, runtime)

    async def query_namespace_async(
        self,
        request: mse_20190531_models.QueryNamespaceRequest,
    ) -> mse_20190531_models.QueryNamespaceResponse:
        """
        @summary 查询MSE命名空间
        
        @param request: QueryNamespaceRequest
        @return: QueryNamespaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.query_namespace_with_options_async(request, runtime)

    def query_slb_spec_with_options(
        self,
        request: mse_20190531_models.QuerySlbSpecRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QuerySlbSpecResponse:
        """
        @summary Queries the type of a Server Load Balancer (SLB) instance.
        
        @param request: QuerySlbSpecRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QuerySlbSpecResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QuerySlbSpec',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QuerySlbSpecResponse(),
            self.call_api(params, req, runtime)
        )

    async def query_slb_spec_with_options_async(
        self,
        request: mse_20190531_models.QuerySlbSpecRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QuerySlbSpecResponse:
        """
        @summary Queries the type of a Server Load Balancer (SLB) instance.
        
        @param request: QuerySlbSpecRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QuerySlbSpecResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QuerySlbSpec',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QuerySlbSpecResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def query_slb_spec(
        self,
        request: mse_20190531_models.QuerySlbSpecRequest,
    ) -> mse_20190531_models.QuerySlbSpecResponse:
        """
        @summary Queries the type of a Server Load Balancer (SLB) instance.
        
        @param request: QuerySlbSpecRequest
        @return: QuerySlbSpecResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.query_slb_spec_with_options(request, runtime)

    async def query_slb_spec_async(
        self,
        request: mse_20190531_models.QuerySlbSpecRequest,
    ) -> mse_20190531_models.QuerySlbSpecResponse:
        """
        @summary Queries the type of a Server Load Balancer (SLB) instance.
        
        @param request: QuerySlbSpecRequest
        @return: QuerySlbSpecResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.query_slb_spec_with_options_async(request, runtime)

    def query_swimming_lane_by_id_with_options(
        self,
        request: mse_20190531_models.QuerySwimmingLaneByIdRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QuerySwimmingLaneByIdResponse:
        """
        @summary Queries the information about a lane based on the lane ID.
        
        @param request: QuerySwimmingLaneByIdRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QuerySwimmingLaneByIdResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.lane_id):
            query['LaneId'] = request.lane_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QuerySwimmingLaneById',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QuerySwimmingLaneByIdResponse(),
            self.call_api(params, req, runtime)
        )

    async def query_swimming_lane_by_id_with_options_async(
        self,
        request: mse_20190531_models.QuerySwimmingLaneByIdRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QuerySwimmingLaneByIdResponse:
        """
        @summary Queries the information about a lane based on the lane ID.
        
        @param request: QuerySwimmingLaneByIdRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QuerySwimmingLaneByIdResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.lane_id):
            query['LaneId'] = request.lane_id
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QuerySwimmingLaneById',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QuerySwimmingLaneByIdResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def query_swimming_lane_by_id(
        self,
        request: mse_20190531_models.QuerySwimmingLaneByIdRequest,
    ) -> mse_20190531_models.QuerySwimmingLaneByIdResponse:
        """
        @summary Queries the information about a lane based on the lane ID.
        
        @param request: QuerySwimmingLaneByIdRequest
        @return: QuerySwimmingLaneByIdResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.query_swimming_lane_by_id_with_options(request, runtime)

    async def query_swimming_lane_by_id_async(
        self,
        request: mse_20190531_models.QuerySwimmingLaneByIdRequest,
    ) -> mse_20190531_models.QuerySwimmingLaneByIdResponse:
        """
        @summary Queries the information about a lane based on the lane ID.
        
        @param request: QuerySwimmingLaneByIdRequest
        @return: QuerySwimmingLaneByIdResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.query_swimming_lane_by_id_with_options_async(request, runtime)

    def query_znode_detail_with_options(
        self,
        request: mse_20190531_models.QueryZnodeDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryZnodeDetailResponse:
        """
        @summary Queries the information about a ZooKeeper node.
        
        @param request: QueryZnodeDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryZnodeDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.path):
            query['Path'] = request.path
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryZnodeDetail',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryZnodeDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def query_znode_detail_with_options_async(
        self,
        request: mse_20190531_models.QueryZnodeDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.QueryZnodeDetailResponse:
        """
        @summary Queries the information about a ZooKeeper node.
        
        @param request: QueryZnodeDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: QueryZnodeDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.path):
            query['Path'] = request.path
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='QueryZnodeDetail',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.QueryZnodeDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def query_znode_detail(
        self,
        request: mse_20190531_models.QueryZnodeDetailRequest,
    ) -> mse_20190531_models.QueryZnodeDetailResponse:
        """
        @summary Queries the information about a ZooKeeper node.
        
        @param request: QueryZnodeDetailRequest
        @return: QueryZnodeDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.query_znode_detail_with_options(request, runtime)

    async def query_znode_detail_async(
        self,
        request: mse_20190531_models.QueryZnodeDetailRequest,
    ) -> mse_20190531_models.QueryZnodeDetailResponse:
        """
        @summary Queries the information about a ZooKeeper node.
        
        @param request: QueryZnodeDetailRequest
        @return: QueryZnodeDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.query_znode_detail_with_options_async(request, runtime)

    def remove_application_with_options(
        self,
        request: mse_20190531_models.RemoveApplicationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.RemoveApplicationResponse:
        """
        @summary 删除单个应用
        
        @param request: RemoveApplicationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: RemoveApplicationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='RemoveApplication',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.RemoveApplicationResponse(),
            self.call_api(params, req, runtime)
        )

    async def remove_application_with_options_async(
        self,
        request: mse_20190531_models.RemoveApplicationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.RemoveApplicationResponse:
        """
        @summary 删除单个应用
        
        @param request: RemoveApplicationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: RemoveApplicationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='RemoveApplication',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.RemoveApplicationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def remove_application(
        self,
        request: mse_20190531_models.RemoveApplicationRequest,
    ) -> mse_20190531_models.RemoveApplicationResponse:
        """
        @summary 删除单个应用
        
        @param request: RemoveApplicationRequest
        @return: RemoveApplicationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.remove_application_with_options(request, runtime)

    async def remove_application_async(
        self,
        request: mse_20190531_models.RemoveApplicationRequest,
    ) -> mse_20190531_models.RemoveApplicationResponse:
        """
        @summary 删除单个应用
        
        @param request: RemoveApplicationRequest
        @return: RemoveApplicationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.remove_application_with_options_async(request, runtime)

    def remove_auth_policy_with_options(
        self,
        request: mse_20190531_models.RemoveAuthPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.RemoveAuthPolicyResponse:
        """
        @param request: RemoveAuthPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: RemoveAuthPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='RemoveAuthPolicy',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.RemoveAuthPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def remove_auth_policy_with_options_async(
        self,
        request: mse_20190531_models.RemoveAuthPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.RemoveAuthPolicyResponse:
        """
        @param request: RemoveAuthPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: RemoveAuthPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='RemoveAuthPolicy',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.RemoveAuthPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def remove_auth_policy(
        self,
        request: mse_20190531_models.RemoveAuthPolicyRequest,
    ) -> mse_20190531_models.RemoveAuthPolicyResponse:
        """
        @param request: RemoveAuthPolicyRequest
        @return: RemoveAuthPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.remove_auth_policy_with_options(request, runtime)

    async def remove_auth_policy_async(
        self,
        request: mse_20190531_models.RemoveAuthPolicyRequest,
    ) -> mse_20190531_models.RemoveAuthPolicyResponse:
        """
        @param request: RemoveAuthPolicyRequest
        @return: RemoveAuthPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.remove_auth_policy_with_options_async(request, runtime)

    def restart_cluster_with_options(
        self,
        request: mse_20190531_models.RestartClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.RestartClusterResponse:
        """
        @summary Restarts a registry.
        
        @param request: RestartClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: RestartClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.pod_name_list):
            query['PodNameList'] = request.pod_name_list
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='RestartCluster',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.RestartClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def restart_cluster_with_options_async(
        self,
        request: mse_20190531_models.RestartClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.RestartClusterResponse:
        """
        @summary Restarts a registry.
        
        @param request: RestartClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: RestartClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.pod_name_list):
            query['PodNameList'] = request.pod_name_list
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='RestartCluster',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.RestartClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def restart_cluster(
        self,
        request: mse_20190531_models.RestartClusterRequest,
    ) -> mse_20190531_models.RestartClusterResponse:
        """
        @summary Restarts a registry.
        
        @param request: RestartClusterRequest
        @return: RestartClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.restart_cluster_with_options(request, runtime)

    async def restart_cluster_async(
        self,
        request: mse_20190531_models.RestartClusterRequest,
    ) -> mse_20190531_models.RestartClusterResponse:
        """
        @summary Restarts a registry.
        
        @param request: RestartClusterRequest
        @return: RestartClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.restart_cluster_with_options_async(request, runtime)

    def retry_cluster_with_options(
        self,
        request: mse_20190531_models.RetryClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.RetryClusterResponse:
        """
        @summary Retries a cluster.
        
        @param request: RetryClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: RetryClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='RetryCluster',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.RetryClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def retry_cluster_with_options_async(
        self,
        request: mse_20190531_models.RetryClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.RetryClusterResponse:
        """
        @summary Retries a cluster.
        
        @param request: RetryClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: RetryClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='RetryCluster',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.RetryClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def retry_cluster(
        self,
        request: mse_20190531_models.RetryClusterRequest,
    ) -> mse_20190531_models.RetryClusterResponse:
        """
        @summary Retries a cluster.
        
        @param request: RetryClusterRequest
        @return: RetryClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.retry_cluster_with_options(request, runtime)

    async def retry_cluster_async(
        self,
        request: mse_20190531_models.RetryClusterRequest,
    ) -> mse_20190531_models.RetryClusterResponse:
        """
        @summary Retries a cluster.
        
        @param request: RetryClusterRequest
        @return: RetryClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.retry_cluster_with_options_async(request, runtime)

    def select_gateway_slb_with_options(
        self,
        request: mse_20190531_models.SelectGatewaySlbRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.SelectGatewaySlbResponse:
        """
        @summary Queries an idle Server Load Balancer (SLB) instance that is associated with a gateway.
        
        @param request: SelectGatewaySlbRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: SelectGatewaySlbResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='SelectGatewaySlb',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.SelectGatewaySlbResponse(),
            self.call_api(params, req, runtime)
        )

    async def select_gateway_slb_with_options_async(
        self,
        request: mse_20190531_models.SelectGatewaySlbRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.SelectGatewaySlbResponse:
        """
        @summary Queries an idle Server Load Balancer (SLB) instance that is associated with a gateway.
        
        @param request: SelectGatewaySlbRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: SelectGatewaySlbResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='SelectGatewaySlb',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.SelectGatewaySlbResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def select_gateway_slb(
        self,
        request: mse_20190531_models.SelectGatewaySlbRequest,
    ) -> mse_20190531_models.SelectGatewaySlbResponse:
        """
        @summary Queries an idle Server Load Balancer (SLB) instance that is associated with a gateway.
        
        @param request: SelectGatewaySlbRequest
        @return: SelectGatewaySlbResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.select_gateway_slb_with_options(request, runtime)

    async def select_gateway_slb_async(
        self,
        request: mse_20190531_models.SelectGatewaySlbRequest,
    ) -> mse_20190531_models.SelectGatewaySlbResponse:
        """
        @summary Queries an idle Server Load Balancer (SLB) instance that is associated with a gateway.
        
        @param request: SelectGatewaySlbRequest
        @return: SelectGatewaySlbResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.select_gateway_slb_with_options_async(request, runtime)

    def tag_resources_with_options(
        self,
        request: mse_20190531_models.TagResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.TagResourcesResponse:
        """
        @summary Tags a specified resource.
        
        @param request: TagResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: TagResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='TagResources',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.TagResourcesResponse(),
            self.call_api(params, req, runtime)
        )

    async def tag_resources_with_options_async(
        self,
        request: mse_20190531_models.TagResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.TagResourcesResponse:
        """
        @summary Tags a specified resource.
        
        @param request: TagResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: TagResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='TagResources',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.TagResourcesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def tag_resources(
        self,
        request: mse_20190531_models.TagResourcesRequest,
    ) -> mse_20190531_models.TagResourcesResponse:
        """
        @summary Tags a specified resource.
        
        @param request: TagResourcesRequest
        @return: TagResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.tag_resources_with_options(request, runtime)

    async def tag_resources_async(
        self,
        request: mse_20190531_models.TagResourcesRequest,
    ) -> mse_20190531_models.TagResourcesResponse:
        """
        @summary Tags a specified resource.
        
        @param request: TagResourcesRequest
        @return: TagResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.tag_resources_with_options_async(request, runtime)

    def untag_resources_with_options(
        self,
        request: mse_20190531_models.UntagResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UntagResourcesResponse:
        """
        @summary Untags resources.
        
        @param request: UntagResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UntagResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.all):
            query['All'] = request.all
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.tag_key):
            query['TagKey'] = request.tag_key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UntagResources',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UntagResourcesResponse(),
            self.call_api(params, req, runtime)
        )

    async def untag_resources_with_options_async(
        self,
        request: mse_20190531_models.UntagResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UntagResourcesResponse:
        """
        @summary Untags resources.
        
        @param request: UntagResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UntagResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.all):
            query['All'] = request.all
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.tag_key):
            query['TagKey'] = request.tag_key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UntagResources',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UntagResourcesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def untag_resources(
        self,
        request: mse_20190531_models.UntagResourcesRequest,
    ) -> mse_20190531_models.UntagResourcesResponse:
        """
        @summary Untags resources.
        
        @param request: UntagResourcesRequest
        @return: UntagResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.untag_resources_with_options(request, runtime)

    async def untag_resources_async(
        self,
        request: mse_20190531_models.UntagResourcesRequest,
    ) -> mse_20190531_models.UntagResourcesResponse:
        """
        @summary Untags resources.
        
        @param request: UntagResourcesRequest
        @return: UntagResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.untag_resources_with_options_async(request, runtime)

    def update_acl_with_options(
        self,
        request: mse_20190531_models.UpdateAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateAclResponse:
        """
        @summary Modifies an IP address whitelist.
        
        @param request: UpdateAclRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateAclResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.acl_entry_list):
            query['AclEntryList'] = request.acl_entry_list
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateAcl',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UpdateAclResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_acl_with_options_async(
        self,
        request: mse_20190531_models.UpdateAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateAclResponse:
        """
        @summary Modifies an IP address whitelist.
        
        @param request: UpdateAclRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateAclResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.acl_entry_list):
            query['AclEntryList'] = request.acl_entry_list
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateAcl',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UpdateAclResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def update_acl(
        self,
        request: mse_20190531_models.UpdateAclRequest,
    ) -> mse_20190531_models.UpdateAclResponse:
        """
        @summary Modifies an IP address whitelist.
        
        @param request: UpdateAclRequest
        @return: UpdateAclResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.update_acl_with_options(request, runtime)

    async def update_acl_async(
        self,
        request: mse_20190531_models.UpdateAclRequest,
    ) -> mse_20190531_models.UpdateAclResponse:
        """
        @summary Modifies an IP address whitelist.
        
        @param request: UpdateAclRequest
        @return: UpdateAclResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.update_acl_with_options_async(request, runtime)

    def update_auth_policy_with_options(
        self,
        request: mse_20190531_models.UpdateAuthPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateAuthPolicyResponse:
        """
        @summary Updates a service authentication rule.
        
        @param request: UpdateAuthPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateAuthPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.auth_rule):
            query['AuthRule'] = request.auth_rule
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.k_8s_namespace):
            query['K8sNamespace'] = request.k_8s_namespace
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.protocol):
            query['Protocol'] = request.protocol
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateAuthPolicy',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UpdateAuthPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_auth_policy_with_options_async(
        self,
        request: mse_20190531_models.UpdateAuthPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateAuthPolicyResponse:
        """
        @summary Updates a service authentication rule.
        
        @param request: UpdateAuthPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateAuthPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.auth_rule):
            query['AuthRule'] = request.auth_rule
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.k_8s_namespace):
            query['K8sNamespace'] = request.k_8s_namespace
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.protocol):
            query['Protocol'] = request.protocol
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateAuthPolicy',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UpdateAuthPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def update_auth_policy(
        self,
        request: mse_20190531_models.UpdateAuthPolicyRequest,
    ) -> mse_20190531_models.UpdateAuthPolicyResponse:
        """
        @summary Updates a service authentication rule.
        
        @param request: UpdateAuthPolicyRequest
        @return: UpdateAuthPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.update_auth_policy_with_options(request, runtime)

    async def update_auth_policy_async(
        self,
        request: mse_20190531_models.UpdateAuthPolicyRequest,
    ) -> mse_20190531_models.UpdateAuthPolicyResponse:
        """
        @summary Updates a service authentication rule.
        
        @param request: UpdateAuthPolicyRequest
        @return: UpdateAuthPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.update_auth_policy_with_options_async(request, runtime)

    def update_black_white_list_with_options(
        self,
        request: mse_20190531_models.UpdateBlackWhiteListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateBlackWhiteListResponse:
        """
        @summary Modifies the blacklist or whitelist of a gateway.
        
        @param request: UpdateBlackWhiteListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateBlackWhiteListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.content):
            query['Content'] = request.content
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.is_white):
            query['IsWhite'] = request.is_white
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.note):
            query['Note'] = request.note
        if not UtilClient.is_unset(request.resource_id_json_list):
            query['ResourceIdJsonList'] = request.resource_id_json_list
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateBlackWhiteList',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UpdateBlackWhiteListResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_black_white_list_with_options_async(
        self,
        request: mse_20190531_models.UpdateBlackWhiteListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateBlackWhiteListResponse:
        """
        @summary Modifies the blacklist or whitelist of a gateway.
        
        @param request: UpdateBlackWhiteListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateBlackWhiteListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.content):
            query['Content'] = request.content
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.is_white):
            query['IsWhite'] = request.is_white
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.note):
            query['Note'] = request.note
        if not UtilClient.is_unset(request.resource_id_json_list):
            query['ResourceIdJsonList'] = request.resource_id_json_list
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateBlackWhiteList',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UpdateBlackWhiteListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def update_black_white_list(
        self,
        request: mse_20190531_models.UpdateBlackWhiteListRequest,
    ) -> mse_20190531_models.UpdateBlackWhiteListResponse:
        """
        @summary Modifies the blacklist or whitelist of a gateway.
        
        @param request: UpdateBlackWhiteListRequest
        @return: UpdateBlackWhiteListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.update_black_white_list_with_options(request, runtime)

    async def update_black_white_list_async(
        self,
        request: mse_20190531_models.UpdateBlackWhiteListRequest,
    ) -> mse_20190531_models.UpdateBlackWhiteListResponse:
        """
        @summary Modifies the blacklist or whitelist of a gateway.
        
        @param request: UpdateBlackWhiteListRequest
        @return: UpdateBlackWhiteListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.update_black_white_list_with_options_async(request, runtime)

    def update_circuit_breaker_rule_with_options(
        self,
        request: mse_20190531_models.UpdateCircuitBreakerRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateCircuitBreakerRuleResponse:
        """
        @summary Updates a circuit breaking rule.
        
        @param request: UpdateCircuitBreakerRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateCircuitBreakerRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.half_open_base_amount_per_step):
            query['HalfOpenBaseAmountPerStep'] = request.half_open_base_amount_per_step
        if not UtilClient.is_unset(request.half_open_recovery_step_num):
            query['HalfOpenRecoveryStepNum'] = request.half_open_recovery_step_num
        if not UtilClient.is_unset(request.max_allowed_rt_ms):
            query['MaxAllowedRtMs'] = request.max_allowed_rt_ms
        if not UtilClient.is_unset(request.min_request_amount):
            query['MinRequestAmount'] = request.min_request_amount
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.retry_timeout_ms):
            query['RetryTimeoutMs'] = request.retry_timeout_ms
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        if not UtilClient.is_unset(request.stat_interval_ms):
            query['StatIntervalMs'] = request.stat_interval_ms
        if not UtilClient.is_unset(request.strategy):
            query['Strategy'] = request.strategy
        if not UtilClient.is_unset(request.threshold):
            query['Threshold'] = request.threshold
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateCircuitBreakerRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UpdateCircuitBreakerRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_circuit_breaker_rule_with_options_async(
        self,
        request: mse_20190531_models.UpdateCircuitBreakerRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateCircuitBreakerRuleResponse:
        """
        @summary Updates a circuit breaking rule.
        
        @param request: UpdateCircuitBreakerRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateCircuitBreakerRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.half_open_base_amount_per_step):
            query['HalfOpenBaseAmountPerStep'] = request.half_open_base_amount_per_step
        if not UtilClient.is_unset(request.half_open_recovery_step_num):
            query['HalfOpenRecoveryStepNum'] = request.half_open_recovery_step_num
        if not UtilClient.is_unset(request.max_allowed_rt_ms):
            query['MaxAllowedRtMs'] = request.max_allowed_rt_ms
        if not UtilClient.is_unset(request.min_request_amount):
            query['MinRequestAmount'] = request.min_request_amount
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.retry_timeout_ms):
            query['RetryTimeoutMs'] = request.retry_timeout_ms
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        if not UtilClient.is_unset(request.stat_interval_ms):
            query['StatIntervalMs'] = request.stat_interval_ms
        if not UtilClient.is_unset(request.strategy):
            query['Strategy'] = request.strategy
        if not UtilClient.is_unset(request.threshold):
            query['Threshold'] = request.threshold
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateCircuitBreakerRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UpdateCircuitBreakerRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def update_circuit_breaker_rule(
        self,
        request: mse_20190531_models.UpdateCircuitBreakerRuleRequest,
    ) -> mse_20190531_models.UpdateCircuitBreakerRuleResponse:
        """
        @summary Updates a circuit breaking rule.
        
        @param request: UpdateCircuitBreakerRuleRequest
        @return: UpdateCircuitBreakerRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.update_circuit_breaker_rule_with_options(request, runtime)

    async def update_circuit_breaker_rule_async(
        self,
        request: mse_20190531_models.UpdateCircuitBreakerRuleRequest,
    ) -> mse_20190531_models.UpdateCircuitBreakerRuleResponse:
        """
        @summary Updates a circuit breaking rule.
        
        @param request: UpdateCircuitBreakerRuleRequest
        @return: UpdateCircuitBreakerRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.update_circuit_breaker_rule_with_options_async(request, runtime)

    def update_cluster_with_options(
        self,
        request: mse_20190531_models.UpdateClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateClusterResponse:
        """
        @summary Modifies the information about an instance.
        
        @param request: UpdateClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_alias_name):
            query['ClusterAliasName'] = request.cluster_alias_name
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.maintenance_end_time):
            query['MaintenanceEndTime'] = request.maintenance_end_time
        if not UtilClient.is_unset(request.maintenance_start_time):
            query['MaintenanceStartTime'] = request.maintenance_start_time
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateCluster',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UpdateClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_cluster_with_options_async(
        self,
        request: mse_20190531_models.UpdateClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateClusterResponse:
        """
        @summary Modifies the information about an instance.
        
        @param request: UpdateClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_alias_name):
            query['ClusterAliasName'] = request.cluster_alias_name
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.maintenance_end_time):
            query['MaintenanceEndTime'] = request.maintenance_end_time
        if not UtilClient.is_unset(request.maintenance_start_time):
            query['MaintenanceStartTime'] = request.maintenance_start_time
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateCluster',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UpdateClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def update_cluster(
        self,
        request: mse_20190531_models.UpdateClusterRequest,
    ) -> mse_20190531_models.UpdateClusterResponse:
        """
        @summary Modifies the information about an instance.
        
        @param request: UpdateClusterRequest
        @return: UpdateClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.update_cluster_with_options(request, runtime)

    async def update_cluster_async(
        self,
        request: mse_20190531_models.UpdateClusterRequest,
    ) -> mse_20190531_models.UpdateClusterResponse:
        """
        @summary Modifies the information about an instance.
        
        @param request: UpdateClusterRequest
        @return: UpdateClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.update_cluster_with_options_async(request, runtime)

    def update_cluster_spec_with_options(
        self,
        request: mse_20190531_models.UpdateClusterSpecRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateClusterSpecResponse:
        """
        @summary Updates the number or specifications of nodes in a pay-as-you-go Microservices Engine (MSE) instance.
        
        @description You can call this operation to update the number or specifications of nodes in a pay-as-you-go MSE instance. You are charged when you add nodes or upgrade node specifications. For more information, see [Pricing] (`~~1806469~~`).
        
        @param request: UpdateClusterSpecRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateClusterSpecResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_specification):
            query['ClusterSpecification'] = request.cluster_specification
        if not UtilClient.is_unset(request.instance_count):
            query['InstanceCount'] = request.instance_count
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.mse_version):
            query['MseVersion'] = request.mse_version
        if not UtilClient.is_unset(request.pub_network_flow):
            query['PubNetworkFlow'] = request.pub_network_flow
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateClusterSpec',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UpdateClusterSpecResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_cluster_spec_with_options_async(
        self,
        request: mse_20190531_models.UpdateClusterSpecRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateClusterSpecResponse:
        """
        @summary Updates the number or specifications of nodes in a pay-as-you-go Microservices Engine (MSE) instance.
        
        @description You can call this operation to update the number or specifications of nodes in a pay-as-you-go MSE instance. You are charged when you add nodes or upgrade node specifications. For more information, see [Pricing] (`~~1806469~~`).
        
        @param request: UpdateClusterSpecRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateClusterSpecResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_specification):
            query['ClusterSpecification'] = request.cluster_specification
        if not UtilClient.is_unset(request.instance_count):
            query['InstanceCount'] = request.instance_count
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.mse_version):
            query['MseVersion'] = request.mse_version
        if not UtilClient.is_unset(request.pub_network_flow):
            query['PubNetworkFlow'] = request.pub_network_flow
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateClusterSpec',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UpdateClusterSpecResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def update_cluster_spec(
        self,
        request: mse_20190531_models.UpdateClusterSpecRequest,
    ) -> mse_20190531_models.UpdateClusterSpecResponse:
        """
        @summary Updates the number or specifications of nodes in a pay-as-you-go Microservices Engine (MSE) instance.
        
        @description You can call this operation to update the number or specifications of nodes in a pay-as-you-go MSE instance. You are charged when you add nodes or upgrade node specifications. For more information, see [Pricing] (`~~1806469~~`).
        
        @param request: UpdateClusterSpecRequest
        @return: UpdateClusterSpecResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.update_cluster_spec_with_options(request, runtime)

    async def update_cluster_spec_async(
        self,
        request: mse_20190531_models.UpdateClusterSpecRequest,
    ) -> mse_20190531_models.UpdateClusterSpecResponse:
        """
        @summary Updates the number or specifications of nodes in a pay-as-you-go Microservices Engine (MSE) instance.
        
        @description You can call this operation to update the number or specifications of nodes in a pay-as-you-go MSE instance. You are charged when you add nodes or upgrade node specifications. For more information, see [Pricing] (`~~1806469~~`).
        
        @param request: UpdateClusterSpecRequest
        @return: UpdateClusterSpecResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.update_cluster_spec_with_options_async(request, runtime)

    def update_config_with_options(
        self,
        request: mse_20190531_models.UpdateConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateConfigResponse:
        """
        @summary Updates the configurations of an instance.
        
        @param request: UpdateConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.auth_enabled):
            query['AuthEnabled'] = request.auth_enabled
        if not UtilClient.is_unset(request.autopurge_purge_interval):
            query['AutopurgePurgeInterval'] = request.autopurge_purge_interval
        if not UtilClient.is_unset(request.autopurge_snap_retain_count):
            query['AutopurgeSnapRetainCount'] = request.autopurge_snap_retain_count
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.config_auth_enabled):
            query['ConfigAuthEnabled'] = request.config_auth_enabled
        if not UtilClient.is_unset(request.config_secret_enabled):
            query['ConfigSecretEnabled'] = request.config_secret_enabled
        if not UtilClient.is_unset(request.config_type):
            query['ConfigType'] = request.config_type
        if not UtilClient.is_unset(request.console_uienabled):
            query['ConsoleUIEnabled'] = request.console_uienabled
        if not UtilClient.is_unset(request.enable_4lw):
            query['Enable4lw'] = request.enable_4lw
        if not UtilClient.is_unset(request.eureka_supported):
            query['EurekaSupported'] = request.eureka_supported
        if not UtilClient.is_unset(request.extended_types_enable):
            query['ExtendedTypesEnable'] = request.extended_types_enable
        if not UtilClient.is_unset(request.init_limit):
            query['InitLimit'] = request.init_limit
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.jute_maxbuffer):
            query['JuteMaxbuffer'] = request.jute_maxbuffer
        if not UtilClient.is_unset(request.mcpenabled):
            query['MCPEnabled'] = request.mcpenabled
        if not UtilClient.is_unset(request.max_client_cnxns):
            query['MaxClientCnxns'] = request.max_client_cnxns
        if not UtilClient.is_unset(request.max_session_timeout):
            query['MaxSessionTimeout'] = request.max_session_timeout
        if not UtilClient.is_unset(request.min_session_timeout):
            query['MinSessionTimeout'] = request.min_session_timeout
        if not UtilClient.is_unset(request.naming_auth_enabled):
            query['NamingAuthEnabled'] = request.naming_auth_enabled
        if not UtilClient.is_unset(request.pass_word):
            query['PassWord'] = request.pass_word
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.snapshot_count):
            query['SnapshotCount'] = request.snapshot_count
        if not UtilClient.is_unset(request.sync_limit):
            query['SyncLimit'] = request.sync_limit
        if not UtilClient.is_unset(request.tlsenabled):
            query['TLSEnabled'] = request.tlsenabled
        if not UtilClient.is_unset(request.tick_time):
            query['TickTime'] = request.tick_time
        if not UtilClient.is_unset(request.user_name):
            query['UserName'] = request.user_name
        body = {}
        if not UtilClient.is_unset(request.open_super_acl):
            body['OpenSuperAcl'] = request.open_super_acl
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='UpdateConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UpdateConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_config_with_options_async(
        self,
        request: mse_20190531_models.UpdateConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateConfigResponse:
        """
        @summary Updates the configurations of an instance.
        
        @param request: UpdateConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.auth_enabled):
            query['AuthEnabled'] = request.auth_enabled
        if not UtilClient.is_unset(request.autopurge_purge_interval):
            query['AutopurgePurgeInterval'] = request.autopurge_purge_interval
        if not UtilClient.is_unset(request.autopurge_snap_retain_count):
            query['AutopurgeSnapRetainCount'] = request.autopurge_snap_retain_count
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.config_auth_enabled):
            query['ConfigAuthEnabled'] = request.config_auth_enabled
        if not UtilClient.is_unset(request.config_secret_enabled):
            query['ConfigSecretEnabled'] = request.config_secret_enabled
        if not UtilClient.is_unset(request.config_type):
            query['ConfigType'] = request.config_type
        if not UtilClient.is_unset(request.console_uienabled):
            query['ConsoleUIEnabled'] = request.console_uienabled
        if not UtilClient.is_unset(request.enable_4lw):
            query['Enable4lw'] = request.enable_4lw
        if not UtilClient.is_unset(request.eureka_supported):
            query['EurekaSupported'] = request.eureka_supported
        if not UtilClient.is_unset(request.extended_types_enable):
            query['ExtendedTypesEnable'] = request.extended_types_enable
        if not UtilClient.is_unset(request.init_limit):
            query['InitLimit'] = request.init_limit
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.jute_maxbuffer):
            query['JuteMaxbuffer'] = request.jute_maxbuffer
        if not UtilClient.is_unset(request.mcpenabled):
            query['MCPEnabled'] = request.mcpenabled
        if not UtilClient.is_unset(request.max_client_cnxns):
            query['MaxClientCnxns'] = request.max_client_cnxns
        if not UtilClient.is_unset(request.max_session_timeout):
            query['MaxSessionTimeout'] = request.max_session_timeout
        if not UtilClient.is_unset(request.min_session_timeout):
            query['MinSessionTimeout'] = request.min_session_timeout
        if not UtilClient.is_unset(request.naming_auth_enabled):
            query['NamingAuthEnabled'] = request.naming_auth_enabled
        if not UtilClient.is_unset(request.pass_word):
            query['PassWord'] = request.pass_word
        if not UtilClient.is_unset(request.request_pars):
            query['RequestPars'] = request.request_pars
        if not UtilClient.is_unset(request.snapshot_count):
            query['SnapshotCount'] = request.snapshot_count
        if not UtilClient.is_unset(request.sync_limit):
            query['SyncLimit'] = request.sync_limit
        if not UtilClient.is_unset(request.tlsenabled):
            query['TLSEnabled'] = request.tlsenabled
        if not UtilClient.is_unset(request.tick_time):
            query['TickTime'] = request.tick_time
        if not UtilClient.is_unset(request.user_name):
            query['UserName'] = request.user_name
        body = {}
        if not UtilClient.is_unset(request.open_super_acl):
            body['OpenSuperAcl'] = request.open_super_acl
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='UpdateConfig',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UpdateConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def update_config(
        self,
        request: mse_20190531_models.UpdateConfigRequest,
    ) -> mse_20190531_models.UpdateConfigResponse:
        """
        @summary Updates the configurations of an instance.
        
        @param request: UpdateConfigRequest
        @return: UpdateConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.update_config_with_options(request, runtime)

    async def update_config_async(
        self,
        request: mse_20190531_models.UpdateConfigRequest,
    ) -> mse_20190531_models.UpdateConfigResponse:
        """
        @summary Updates the configurations of an instance.
        
        @param request: UpdateConfigRequest
        @return: UpdateConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.update_config_with_options_async(request, runtime)

    def update_engine_namespace_with_options(
        self,
        request: mse_20190531_models.UpdateEngineNamespaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateEngineNamespaceResponse:
        """
        @summary Updates a namespace for the Nacos engine.
        
        @param request: UpdateEngineNamespaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateEngineNamespaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.desc):
            query['Desc'] = request.desc
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.service_count):
            query['ServiceCount'] = request.service_count
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateEngineNamespace',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UpdateEngineNamespaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_engine_namespace_with_options_async(
        self,
        request: mse_20190531_models.UpdateEngineNamespaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateEngineNamespaceResponse:
        """
        @summary Updates a namespace for the Nacos engine.
        
        @param request: UpdateEngineNamespaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateEngineNamespaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.desc):
            query['Desc'] = request.desc
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.service_count):
            query['ServiceCount'] = request.service_count
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateEngineNamespace',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UpdateEngineNamespaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def update_engine_namespace(
        self,
        request: mse_20190531_models.UpdateEngineNamespaceRequest,
    ) -> mse_20190531_models.UpdateEngineNamespaceResponse:
        """
        @summary Updates a namespace for the Nacos engine.
        
        @param request: UpdateEngineNamespaceRequest
        @return: UpdateEngineNamespaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.update_engine_namespace_with_options(request, runtime)

    async def update_engine_namespace_async(
        self,
        request: mse_20190531_models.UpdateEngineNamespaceRequest,
    ) -> mse_20190531_models.UpdateEngineNamespaceResponse:
        """
        @summary Updates a namespace for the Nacos engine.
        
        @param request: UpdateEngineNamespaceRequest
        @return: UpdateEngineNamespaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.update_engine_namespace_with_options_async(request, runtime)

    def update_flow_rule_with_options(
        self,
        request: mse_20190531_models.UpdateFlowRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateFlowRuleResponse:
        """
        @summary Updates a throttling rule.
        
        @param request: UpdateFlowRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateFlowRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.control_behavior):
            query['ControlBehavior'] = request.control_behavior
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.limit_app):
            query['LimitApp'] = request.limit_app
        if not UtilClient.is_unset(request.max_queueing_time_ms):
            query['MaxQueueingTimeMs'] = request.max_queueing_time_ms
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        if not UtilClient.is_unset(request.threshold):
            query['Threshold'] = request.threshold
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateFlowRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UpdateFlowRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_flow_rule_with_options_async(
        self,
        request: mse_20190531_models.UpdateFlowRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateFlowRuleResponse:
        """
        @summary Updates a throttling rule.
        
        @param request: UpdateFlowRuleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateFlowRuleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.control_behavior):
            query['ControlBehavior'] = request.control_behavior
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.limit_app):
            query['LimitApp'] = request.limit_app
        if not UtilClient.is_unset(request.max_queueing_time_ms):
            query['MaxQueueingTimeMs'] = request.max_queueing_time_ms
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        if not UtilClient.is_unset(request.threshold):
            query['Threshold'] = request.threshold
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateFlowRule',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UpdateFlowRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def update_flow_rule(
        self,
        request: mse_20190531_models.UpdateFlowRuleRequest,
    ) -> mse_20190531_models.UpdateFlowRuleResponse:
        """
        @summary Updates a throttling rule.
        
        @param request: UpdateFlowRuleRequest
        @return: UpdateFlowRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.update_flow_rule_with_options(request, runtime)

    async def update_flow_rule_async(
        self,
        request: mse_20190531_models.UpdateFlowRuleRequest,
    ) -> mse_20190531_models.UpdateFlowRuleResponse:
        """
        @summary Updates a throttling rule.
        
        @param request: UpdateFlowRuleRequest
        @return: UpdateFlowRuleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.update_flow_rule_with_options_async(request, runtime)

    def update_gateway_auth_consumer_with_options(
        self,
        request: mse_20190531_models.UpdateGatewayAuthConsumerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateGatewayAuthConsumerResponse:
        """
        @summary Updates the consumer on which a gateway performs authentication operations.
        
        @param request: UpdateGatewayAuthConsumerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateGatewayAuthConsumerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.encode_type):
            query['EncodeType'] = request.encode_type
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.jwks):
            query['Jwks'] = request.jwks
        if not UtilClient.is_unset(request.key_name):
            query['KeyName'] = request.key_name
        if not UtilClient.is_unset(request.key_value):
            query['KeyValue'] = request.key_value
        if not UtilClient.is_unset(request.token_name):
            query['TokenName'] = request.token_name
        if not UtilClient.is_unset(request.token_pass):
            query['TokenPass'] = request.token_pass
        if not UtilClient.is_unset(request.token_position):
            query['TokenPosition'] = request.token_position
        if not UtilClient.is_unset(request.token_prefix):
            query['TokenPrefix'] = request.token_prefix
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateGatewayAuthConsumer',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UpdateGatewayAuthConsumerResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_gateway_auth_consumer_with_options_async(
        self,
        request: mse_20190531_models.UpdateGatewayAuthConsumerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateGatewayAuthConsumerResponse:
        """
        @summary Updates the consumer on which a gateway performs authentication operations.
        
        @param request: UpdateGatewayAuthConsumerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateGatewayAuthConsumerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.encode_type):
            query['EncodeType'] = request.encode_type
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.jwks):
            query['Jwks'] = request.jwks
        if not UtilClient.is_unset(request.key_name):
            query['KeyName'] = request.key_name
        if not UtilClient.is_unset(request.key_value):
            query['KeyValue'] = request.key_value
        if not UtilClient.is_unset(request.token_name):
            query['TokenName'] = request.token_name
        if not UtilClient.is_unset(request.token_pass):
            query['TokenPass'] = request.token_pass
        if not UtilClient.is_unset(request.token_position):
            query['TokenPosition'] = request.token_position
        if not UtilClient.is_unset(request.token_prefix):
            query['TokenPrefix'] = request.token_prefix
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateGatewayAuthConsumer',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UpdateGatewayAuthConsumerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def update_gateway_auth_consumer(
        self,
        request: mse_20190531_models.UpdateGatewayAuthConsumerRequest,
    ) -> mse_20190531_models.UpdateGatewayAuthConsumerResponse:
        """
        @summary Updates the consumer on which a gateway performs authentication operations.
        
        @param request: UpdateGatewayAuthConsumerRequest
        @return: UpdateGatewayAuthConsumerResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.update_gateway_auth_consumer_with_options(request, runtime)

    async def update_gateway_auth_consumer_async(
        self,
        request: mse_20190531_models.UpdateGatewayAuthConsumerRequest,
    ) -> mse_20190531_models.UpdateGatewayAuthConsumerResponse:
        """
        @summary Updates the consumer on which a gateway performs authentication operations.
        
        @param request: UpdateGatewayAuthConsumerRequest
        @return: UpdateGatewayAuthConsumerResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.update_gateway_auth_consumer_with_options_async(request, runtime)

    def update_gateway_auth_consumer_resource_with_options(
        self,
        tmp_req: mse_20190531_models.UpdateGatewayAuthConsumerResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateGatewayAuthConsumerResourceResponse:
        """
        @summary Updates a list of resources on which permissions are granted to a gateway authentication consumer.
        
        @param tmp_req: UpdateGatewayAuthConsumerResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateGatewayAuthConsumerResourceResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.UpdateGatewayAuthConsumerResourceShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.resource_list):
            request.resource_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.resource_list, 'ResourceList', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.consumer_id):
            query['ConsumerId'] = request.consumer_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.resource_list_shrink):
            query['ResourceList'] = request.resource_list_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateGatewayAuthConsumerResource',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            mse_20190531_models.UpdateGatewayAuthConsumerResourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def update_gateway_auth_consumer_resource_with_options_async(
        self,
        tmp_req: mse_20190531_models.UpdateGatewayAuthConsumerResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> mse_20190531_models.UpdateGatewayAuthConsumerResourceResponse:
        """
        @summary Updates a list of resources on which permissions are granted to a gateway authentication consumer.
        
        @param tmp_req: UpdateGatewayAuthConsumerResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: UpdateGatewayAuthConsumerResourceResponse
        """
        UtilClient.validate_model(tmp_req)
        request = mse_20190531_models.UpdateGatewayAuthConsumerResourceShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.resource_list):
            request.resource_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.resource_list, 'ResourceList', 'json')
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.consumer_id):
            query['ConsumerId'] = request.consumer_id
        if not UtilClient.is_unset(request.gateway_unique_id):
            query['GatewayUniqueId'] = request.gateway_unique_id
        if not UtilClient.is_unset(request.resource_list_shrink):
            query['ResourceList'] = request.resource_list_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='UpdateGatewayAuthConsumerResource',
            version='2019-05-31',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='