# 🐛 nostr-tools v1.1.1 - Documentation & Build Fixes

**Release Date:** October 3, 2025  
**Tag:** v1.1.1  
**Commit:** 7324fc5ab2c1d07259f7cf36cd5b630810f5a3ae

---

## 🚀 Overview

This patch release focuses on fixing documentation build issues, improving the build system, and enhancing the overall development experience. It addresses Sphinx build compatibility issues, enhances autosummary generation, improves CI pipeline reliability, and adds comprehensive development documentation.

## ✨ What's Fixed in v1.1.1

### 📚 Documentation Fixes

**Sphinx Build Compatibility**
- **Enhanced Sphinx Configuration** - Improved autodoc settings with better member filtering
- **Custom Autosummary Templates** - Added custom templates for class and module documentation
- **Dataclass Documentation** - Fixed duplicate object description warnings by filtering dataclass fields
- **Better Member Filtering** - Improved exclusion of internal members and better inheritance display

**Documentation Generation**
- **Autodoc Improvements** - Better handling of undocumented members and private members
- **Enhanced Templates** - Custom autosummary templates for cleaner documentation
- **Better Inheritance Display** - Improved class inheritance documentation
- **Cleaner Output** - Reduced duplicate warnings and improved documentation structure

### 🏗️ Build & Distribution Fixes

**Setuptools Compatibility**
- **Version Constraint** - Constrained setuptools to `<75.0` to use Metadata-Version 2.1 for better twine compatibility
- **Package Metadata** - Fixed distribution check failures with older twine versions in CI environments
- **Build System** - Improved package building and distribution process
- **Dependency Cleanup** - Removed performance profiling tools from dev dependencies

**CI Pipeline Improvements**
- **Enhanced CI Workflow** - Improved GitHub Actions workflow with better organization
- **Better Error Handling** - Enhanced error reporting and build artifact handling
- **Dependency Management** - Better version constraints and dependency resolution
- **Workflow Optimization** - Streamlined CI pipeline with better caching and organization

### 🛠️ Development Experience

**New Development Documentation**
- **DEVELOPMENT.md** - Comprehensive development guide with 490+ lines of documentation
- **Enhanced Makefile** - Improved development commands with better organization
- **Better Project Structure** - Enhanced development workflow and quality assurance
- **Professional Standards** - Complete guide for developing with professional quality standards

**Enhanced Development Tools**
- **Improved Pre-commit Configuration** - Better pre-commit hooks and quality gates
- **Enhanced Testing** - Better test organization and integration test restructuring
- **Better Documentation** - Improved Sphinx configuration and documentation generation
- **Professional Workflow** - Complete development workflow with quality assurance

## 🔧 Technical Details

### Documentation Build Improvements

**Enhanced Sphinx Configuration**
```python
# Improved autodoc settings
autodoc_default_options = {
    "members": True,
    "member-order": "bysource",
    "undoc-members": False,  # Don't auto-document undocumented members
    "private-members": False,
    "special-members": "__init__, __call__",
    "exclude-members": "__weakref__, __dict__, __module__, __annotations__",
    "show-inheritance": True,
    "inherited-members": False,
}
```

**Custom Autosummary Templates**
```rst
# docs/_templates/autosummary/class.rst
{{ fullname | escape | underline}}

.. currentmodule:: {{ module }}

.. autoclass:: {{ fullname }}
   :members:
   :show-inheritance:
   :special-members: __init__, __call__, __aenter__, __aexit__
   :exclude-members: __weakref__, __dict__, __module__, __annotations__
```

### Build System Enhancements

**Setuptools Version Constraints**
```toml
[build-system]
# Constrain setuptools to avoid Metadata-Version 2.4 compatibility issues
requires = ["setuptools>=68.0,<75.0", "wheel", "setuptools-scm>=7.0"]
```

**Dependency Cleanup**
```toml
# Removed from dev dependencies
# "pytest-benchmark>=4.0.0,<6.0.0",       # Performance benchmarking
# "memory-profiler>=0.60.0,<1.0.0",       # Memory usage profiling
```

### Development Infrastructure

**New DEVELOPMENT.md**
- 490+ lines of comprehensive development documentation
- Complete development workflow guide
- Quality assurance standards
- Testing and security guidelines
- Release process documentation

**Enhanced CI Pipeline**
- Improved GitHub Actions workflow organization
- Better error handling and reporting
- Enhanced caching and dependency management
- Streamlined build process

## 🐛 Bug Fixes

### Documentation
- **Sphinx Build Warnings** - Fixed dataclass duplicate warnings with better member filtering
- **Autosummary Generation** - Clean generation with custom templates
- **Member Filtering** - Better exclusion of internal members and annotations
- **Inheritance Display** - Improved class inheritance documentation

### Build System
- **Setuptools Compatibility** - Fixed version constraints to avoid Metadata-Version 2.4 issues
- **Distribution Checks** - Improved twine compatibility with older versions
- **Dependency Cleanup** - Removed unnecessary performance profiling tools
- **CI Reliability** - Better dependency management and error handling

### Development Experience
- **Documentation Generation** - Cleaner autodoc output with better filtering
- **Build Process** - More reliable package building and distribution
- **CI Pipeline** - Better error handling, reporting, and workflow organization
- **Development Documentation** - Added comprehensive DEVELOPMENT.md guide
- **Test Organization** - Moved integration tests to unit tests for better organization

## 📦 Dependencies

**Updated Dependencies**
- Constrained setuptools to `<75.0` for better compatibility
- Improved twine compatibility
- Enhanced Sphinx configuration
- Better dependency version management

## 🚀 Development Experience

**Improved Documentation**
- Clean autosummary generation
- Better Sphinx configuration
- Enhanced documentation build process
- Improved developer experience

**Better CI Pipeline**
- More reliable builds
- Enhanced error reporting
- Better dependency management
- Improved build artifacts

## 📈 Performance

- **Faster Documentation Builds** - Optimized Sphinx configuration
- **Better CI Performance** - Improved pipeline reliability
- **Enhanced Build Process** - More efficient package building
- **Improved Error Handling** - Better CI error reporting

## 🔄 Migration Guide

### From v1.1.0

**No Breaking Changes**
- All existing APIs remain the same
- Documentation improvements are transparent
- Build system improvements are automatic
- No code changes required

**Documentation Updates**
- Enhanced autosummary generation with custom templates
- Better Sphinx configuration with improved member filtering
- Improved documentation build process
- Cleaner documentation output with better inheritance display

**Development Experience**
- New DEVELOPMENT.md guide for comprehensive development workflow
- Enhanced Makefile with better organization
- Improved CI pipeline with better error handling
- Better test organization (integration tests moved to unit tests)

**Build System**
- Setuptools version constraints for better compatibility
- Removed performance profiling tools from dev dependencies
- Enhanced CI workflow with better organization
- Improved dependency management and caching

## 🧪 Testing & Quality

**Enhanced Testing**
- Improved CI pipeline reliability
- Better error handling in tests
- Enhanced build verification
- Better test result reporting

**Code Quality**
- Better dependency management
- Improved build system
- Enhanced documentation generation
- Better CI pipeline

## 🤝 Contributing

This patch release improves the overall development experience with better documentation generation and build system reliability. We welcome contributions and feedback from the community.

**Getting Started**
1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Run `make check-all` to verify quality
5. Submit a pull request

## 📄 License

This project is licensed under the **MIT License** - see the [LICENSE](LICENSE) file for details.

## 🙏 Acknowledgments

- **Contributors** - All contributors to this project
- **Community** - Feedback and suggestions from the Nostr community
- **Dependencies** - The amazing Python ecosystem

---

**🐛 This patch release improves documentation generation and build system reliability, making nostr-tools even more robust and developer-friendly.**
