from sqlalchemy import (
    Column,
    Integer,
    String,
    DateTime,
    ForeignKey,
    Boolean,
    Text,
)
from datetime import datetime

from ...database import Base


class CompanyReviewModel(Base):
    __tablename__ = 'company_review'

    id = Column(Integer, primary_key=True)
    company_sec_id = Column(
        Integer,
        ForeignKey('companies_sec.id'),
        nullable=True,
    )
    company_ous_id = Column(
        Integer,
        ForeignKey('companies_ous.id'),
        nullable=True,
    )
    note_tag = Column(Text, nullable=True)
    news_id = Column(
        Integer,
        ForeignKey('newswires.id'),
        nullable=False,
    )
    reviewed = Column(Boolean, nullable=True)
    historical = Column(Boolean, nullable=True)
    approval = Column(Boolean, nullable=True)
    to_qc = Column(Boolean, nullable=True)
    updated_at = Column(
        DateTime,
        nullable=False,
        default=datetime.utcnow,
        onupdate=datetime.utcnow,
    )
