#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Project      : AI.  @by PyCharm
# @File         : ecraft
# @Time         : 2024/10/31 16:30
# @Author       : betterme
# @WeChat       : meutils
# @Software     : PyCharm
# @Description  :

from meutils.pipe import *
from meutils.caches import rcache
from meutils.io.files_utils import to_url, to_url_fal, to_base64
from meutils.schemas.image_types import ImageRequest, ImagesResponse, RecraftImageRequest
from meutils.notice.feishu import IMAGES, send_message as _send_message
from meutils.config_utils.lark_utils import get_next_token_for_polling, aget_spreadsheet_values
from meutils.decorators.retry import retrying

BASE_URL = "https://api.recraft.ai"
BASE_URL = "https://recraft.chatfire.cc/apis"

FEISHU_URL = "https://xchatllm.feishu.cn/sheets/GYCHsvI4qhnDPNtI4VPcdw2knEd?sheet=Lrhtf2"

DEFAULT_MODEL = "recraftv3"
MODELS = {}

send_message = partial(
    _send_message,
    title=__name__,
    url=IMAGES
)


@rcache(ttl=10 * 60)
@retrying()
async def get_access_token(token: str):
    headers = {"cookie": token}

    # https://www.recraft.ai
    async with httpx.AsyncClient(base_url="https://recraft.chatfire.cc", headers=headers, timeout=60) as client:
        response = await client.get("/api/auth/session")
        response.raise_for_status()
        logger.debug(response.json())
        return response.json()["accessToken"]


@retrying()
async def edit_image(image, task: Literal["vectorize", "super_resolution",] = "super_resolution",
                     response_format: Literal["url", "base64"] = "url"):
    token = await get_next_token_for_polling(
        feishu_url=FEISHU_URL,
        check_token=check_token,
        from_redis=True,
        min_points=1
    )
    token = await get_access_token(token)

    headers = {"Authorization": f"Bearer {token}"}

    data_url = await to_base64(image, content_type="image/png")
    payload = {"image": {"data_url": data_url}}
    async with httpx.AsyncClient(base_url=BASE_URL, headers=headers, timeout=60) as client:
        response = await client.post(f"/project/{uuid.uuid4()}/{task}", json=payload)
        response.raise_for_status()
        # {
        #     "credits": 1,
        #     "image_invariants": {},
        #     "request_id": "72ff57fd-7638-4355-80c5-c7280e9df1a7",
        #     "result": {
        #         "image_id": "0f6f73fd-2995-422d-be74-2bbf1408103f"
        #     }
        # }
        data = response.json()
        params = {"raster_image_content_type": "image/png"}
        response = await client.get(f"""/image/{data["result"]["image_id"]}""", params=params)
        response.raise_for_status()

        # if response_format == "url":

        url = await to_url(response.content, content_type="image/png")
        return {"image": {"url": url}}


# @retrying()
async def generate(request: RecraftImageRequest, token: Optional[str] = None):
    token = await get_next_token_for_polling(
        feishu_url=FEISHU_URL,
        check_token=check_token,
        from_redis=True,
        min_points=1
    )
    token = await get_access_token(token)

    headers = {"Authorization": f"Bearer {token}"}
    # params = {"project_id": "26016b99-3ad0-413b-821b-5f884bd9454e"}  # project_id 是否是必要的
    params = {}  # project_id 是否是必要的
    # params = {"project_id": "47ba6825-0fde-4cea-a17e-ed7398c0a298"}
    payload = request.model_dump(exclude_none=True)

    # 默认 prompt_to_image
    model_type = "prompt_to_image"

    async with httpx.AsyncClient(base_url=BASE_URL, headers=headers, timeout=60) as client:
        response = await client.post(f"/queue_recraft/{model_type}", params=params, json=payload)
        response.raise_for_status()
        params = {
            "operation_id": response.json()["operationId"]
        }
        logger.debug(params)

        response = await client.get("/poll_recraft", params=params)  # 重试
        logger.debug(response.text)
        logger.debug(response.status_code)

        response.raise_for_status()
        metadata = response.json()
        logger.debug(metadata)

        # {'credits': 1,
        #  'height': 1024,
        #  'images': [{'image_id': 'f9d8e7dd-c31f-4208-abe4-f44cdff050c2',
        #              'image_invariants': {'preset': 'any'},
        #              'transparent': False,
        #              'vector_image': False}],
        #  'random_seed': 1423697946,
        #  'request_id': '77bd917d-0960-4921-916f-038c773a41fd',
        #  'transform_model': 'recraftv3',
        #  'width': 1024}

        # params = {"raster_image_content_type": "image/webp"}  #####
        params = {"raster_image_content_type": "image/png"}

        images = []
        for image in response.json()["images"]:
            response = await client.get(f"""/image/{image["image_id"]}""", params=params)
            # url = await to_url(response.content)
            # url = await to_url_fal(response.content, content_type="image/png")
            url = await to_url(response.content, content_type="image/png")

            images.append(url)

        if not images:
            raise Exception(f"生成失败，请联系管理员：{metadata}")

        return ImagesResponse(image=images, metadata=metadata)


# eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJleHAiOjE3NDY5MjY2MjQsInVzZXIiOnsiaWQiOiIzNjIzNjMwNDU2OTAxNTkxMDciLCJuYW1lIjoibWtybiBhbmJ2IiwiYXZhdGFyIjoiIiwiZGV2aWNlSUQiOiIzMjg2MDA4MzYzNzEwMzQxMTgiLCJpc0Fub255bW91cyI6ZmFsc2V9fQ.JyCL0Be9YsEBlLVIeSpqDv3bTKAlU9Jsds3y5cJKXa4
async def check_token(token, threshold: float = 1):
    if isinstance(token, list):
        tokens = token
        r = []
        logger.debug(tokens)
        for batch in tqdm(tokens | xgroup(32)):
            bools = await asyncio.gather(*map(check_token, batch))
            r += list(itertools.compress(batch, bools))
        return r

    try:

        access_token = await get_access_token(token)
        headers = {"Authorization": f"Bearer {access_token}"}

        async with httpx.AsyncClient(base_url=BASE_URL, headers=headers, timeout=60) as client:
            response = await client.get("/users/me")
            response.raise_for_status()
            data = response.json()
            # logger.debug(data)
            _ = data["credits"] >= threshold
            _ or logger.debug(data["credits"])
            return _

    except Exception as e:
        logger.error(e)
        # logger.debug(token)
        return False


if __name__ == '__main__':
    token = None
    # token = "__Host-next-auth.csrf-token=6694c35f61afab7aadfeae158e6074458605550b9cd2e4ef2e63ab4ccaf951ac%7Cac9bf15973e5b6a168150a16a386b821f09559fdaa29a0bf1134b0fa4e327664; _gcl_au=1.1.1248447681.1736148414; AMP_MKTG_7268c9db0f=JTdCJTdE; _fbp=fb.1.1736148414688.910490316103599764; _ga=GA1.1.1798926416.1736148415; _pin_unauth=dWlkPVptRTNOekEzWWpFdE56SmpZUzAwWVdFMkxUZzJORGN0TkdFNU0yTTBaR0U0TlRCaA; x-recraft-referral-code=3h7wfOgFGn; _clck=11vqeuv%7C2%7Cfsc%7C0%7C1832; __Secure-next-auth.callback-url=https%3A%2F%2Fwww.recraft.ai%2Fprojects; _tt_enable_cookie=1; _ttp=TcbY_nwRLBZ2qsM-uRmC3WgcqHh.tt.1; _clsk=yoduqn%7C1736148450927%7C2%7C1%7Cu.clarity.ms%2Fcollect; __Secure-next-auth.session-token.0=eyJhbGciOiJkaXIiLCJlbmMiOiJBMjU2R0NNIn0..PdFk7mpcQ-BCcDE0.S4M-rsTMqzIPxiQYjH8HNgYixGpB4Ff_AgLnEEw9ro9h-L_gWycqYrVRvsFP2h_OtZI3afoq_MVXX2M28sY4sgBWVlVatS_q0CApRi0pj738g0hoGBEKMcTJ-kXGKwvHYfM8CC6ugtM5XCfCxFPC3ZwebCf_mjBWmGm_kHBOvc20Zyv2Dy82dg4yCriVdklf8pUSC2-W-XV4KSRVuYplHglrD0c5QpweQSyOUpVeQHJYwaZnUabTSk8NJ6szdq46JxveDgqkeCVpHKW-8KFtXnOJsdG4FHKWdaVs833emAGzFzh7ua9eoD58gJ2dAwVd9RtcTOHoeCIUF6WT0QsGOUZQ4lAakjkRuTqxOSY8jILMyp4L6EVvis-KXp8LL6oxR8kIiEEsjj28KKju8B6YgGQF6fKtHL7yHrf33I4JTGRDSWia_6ltlHBp5s9UggqI5YE6FA5-3SEk74tT-GyJqsQnoFcs0PK2iixTy18-sDmijvdfVZHrcP-J-r0hrV9yk9wPA8hd9k6A9XTPnH_pi9h0YntAGWzd_SVxEpZUNaKXdGrL9oO-9E05XG-GHehYnhO3_zn0oSSRduatnk4RRfDCBBZotz5gKasdsncvCEUX33ZP_cY6B4ju1ej0a6LzOTdmXhCZGbnSLAPu0dAgYj3qXAO_vjiL-kYpzV-J9sQTOecQJE-Rd6IU3mtRSKtV5SqRY-v91cyXhx8O4pQNy1wtNIYST3DFEu8iTxt_8-CKWMiCSVnOOWV0KSoipeK3IDrJt9n1qB8OWCfCQ6A3ZLftI469x7XUDa_wPfmiLj-0ZErhtAz0U50xpfrfjCaunwQ9LKDRjjf-8FdGlqC0HH8EBkAqb7e1a6zvpqWx95oJeic7H8M3HgbbeyF0JqO_W9Zf2AdyNZsYUE7T3N-JDApEESgEMPnBF_ayf2CKknoWiCFOzflpwzcxd_rGlhe3q_CrNW1-ZqKh1sG_t4lKf956fFrHz28c2mfBJjqx5tYcsYw-HQf6wyPFPnzK3FS16wMpVMNRDiAinf-i779tdC_pgPbJJlU73I1aNDpdLnRtowlkMviuVL6y-KcBeK7d3euRYGJdKqM4gjX5WxK1N71s07yDhiXKU35D-gGE1ruF8u6N2epD3jyfjdKsRmxKce4xl96OwZzF0je4lV_LUBl5oXON2TBbznp32o1okq3jUH-7Suzuiis6NERW2dO3wARdlfhNLJ3Ur6zOxhH86v12npd0ZkUbHgqTKn40_4XvmGIdzyMyddIh78k8OFMlLEFIhONFR2PFFhnjvnzfjQrtm4fCDjWZyiAZYB2HOsyHDI2uS66fXLSOglYA9Tco_UrSCQgM4Yom0m3Hq0JH6eC_hAckBNfJ89IFVECVt23njWc0Rj6wG8-OBKyw4nqgCke446n-7ZS_S9d2UA-fcVBoFG7kr9WTEQQYOOC_stkd7jlH2huUUxGCpi_Nye2KL0LGA-VlbCt7KUzKQ_G1Zrl4CiqGNImoGU9PsY9UtwWxUaPVag62iVicD-4_2Z0-lv6mQyS_TICV_CfxegxkBqGmTad14l71M_WjU9eIzSSs-dMguR2Gs3-0JX3SOfn7DQZGXfZps3_FvmvNTji-9YZpEycSWSUssb0XCd3ISqcqYo1TslVOk47Nz4xAOsrM5MKnrpCYAmiXVC7LZA_ezcnM_3zjIIzjRRi-5R4u5jQ-RAqnrjD6LUn0oCnqyKJPl75iMU2YrI4OlD3HrjPXKWKQFYx70gJH8LpugfNCwQuuIrE5teAO9PTVqO_tGt1WWbbfzD8_j3C9tMb2vqP_YL0Ho4YHBPudZ01L2vlyKOplRKeTw7yl4h61bbe2qdYREhYITxrTRmm8biayCWgmj-NQtoMP20N00LtuINpaRraQrRarB67wkCnO-gtP_OGbp7gXQPlm-eyskSX4OuqNJ6v0EKgD2-o6v0j9G2rFvE0rzzEUL5AQxj3KA6lc8RpFR2WCYHQ23CSTsLdrXdptm85Ij4QsD_nNmrMpu5z9BFhoeuGtuwgFqBIJNPJ6rGlRBMVnhWKzSw5-IYNlpFNMDR9kAZo3f_NbM0LzFSIcdeOq3VWVNiBhXOaDztnx7tIUWGiAEqtAKnEfo8W6T_D7-hO3h2sdQIccmj2-iWN7NKSDVzc3eHH4zi4PcAG-X_86MmOy06_xSiOpMWbs0sHxSe4TZGxPYuB2piAvj1TipZGGXnVuy3r31qMxZhG1LOuSPwyrGIKQL3jHr1vh_JRKdObkfEeg7jlrCObCOaLX6wTcEXdQ5g0pMYRPm0a393BqNQafK9MxyMBgmL59YTFW71awz3vyDj9pNswBzfSSK0mew6eS-u2fI4nMnV-1eYnrmKKY_vnqjnwoWDUc1VUoNHMLD3aDtn08hjziLdBuGfUICsygOcjtypYDp8ys-S3KedzBZyNRVyejQq_uEw1SlIFG4up83NjP3aiG2aPZz3JZNGK-RhmTMcuGNa7EpO28k57yZwNnBtXT0ajCPBcjTP2svs-Km0-vuJ0D33JwGpedykr6JAUksQXZ7zQabkKPcmkxnFRjsRF0n9JqH_Abf6eInl_jmTgDnSeMIvA4Tp6aGamu95TEWM_9DjV-fffo9Qd3VJ8Qde4CJSfIrGX5BtxMUAi8zUozrTwL4zTfO2W3NTVK708hLJ-i8N8dE65gAFxEDiqTPX06Y-kYwVp2DfHEsxYR8xojGeHk1rH56duzrmSF1qSgBH_x-LM_XDvKXOq6zsq5TH5q1XfPDepxDeFk2hodOiuHOY9vMe9CPc-arnvz3Dnx2KdiHaM3R3wWB_I7og_9IiRJGtHxwBRFZ6--WEhFi7EqN9n9CU9FfOhg0A5O5F8fxndSamw6pqTD_v_67ZOUue4eJRRnx_n9U-tFz_b1Yp6MAS72a5rmy0DUpz_B1ZWira9T21Nb7G3Q0Eb-rE5FOfaFAqz5ivdekRttlREfgNGfhJQyIM05J5cHessFs2aJTNSU9fXgPvxmrMzziDzvE-QYG3jlmbdrpzIUr3PUjiGbZu7KA0yv_8dZBVXNFUP-w54n3KQ3K7tcL9fBawyX2uTgFWXO955O10Qhp4HnNR9D55DhSe4rjtiLU5nhXC99Q1TeVHpn1skJH_KAgksMM--I_T5TqueiS_c7yjYZIETds1TO_347euTp0Gq2I4uDfMm6ZLOKE8XSN6tMt0cn04TsGn--mMWwCJCslrXomI0rg9vrteQWFsoW3vYgvpgEF9h8A-Uinz_qnzfrocnnQGVtFChOlJ7q4cC88b-JjZ7g9arATlEhlrLj67wbzYIfK_r_7sdvMLocicdunInOsYL_nJ7eM9pj3WZrAdQrFH2fhYIJa5H0MNBj-uybFJKq6nOSpYyfo4QpVtjiBpH4mFQlsYhg17s_xH8m8wPc8t_Q0V7pwCqKgMlj_ZvK45dNLqwU8MWF4P3xIcSoI2IuGl7kKLmTXsUcQz_EZuoz16aRFXTMPQJOYizH2IsuWixdb2q6q1_7f0205id_ILnzbCYjrcSCDqMK84ka5uiAuISSuW7crZZoyqSzEXU0c6Wc5I1ALaJYeszLzZMneRC3Cb0vfXa4bxmNsqNWogcIBVyver1rpfuJKjWRmYFw3lB6-aG55PJLjF-8ltupPkYKml1G51mQt2HBMpslLTHvwefa4bHoO9czfufl_cZ_uTRaza1jQ6HhFtBSiCiOkl-tekYF0yB1_Gc7ZlDL3QwntfqGWnbtwyWGt_OsOjEggLpVanZOMFwdsra_1YuOreAFSyrO_22Wec6YUTSlky_9B2uQi3TaDWK8b7jdXTq7pMVICNOEoTqwylETNCaSPiwwfGz_AMHr4mvlqpkDbR_ufoxHgDv; __Secure-next-auth.session-token.1=AUyEn2IB_h-Y2_scfWb-83b85MgRA7tKrvfAfo0wWgRY-nYvg8vqCrtT44nflyQlpqvhfwiTAwool46MbcQrcGYJOxX2D9b1Pjk-uSjYQAi-fkuIDDvsBmPsxfQngVJVBMcOIpTIlSLh9pus9s13c2b6a4Ek2QD1KK6WT_YRODbItv0ogbrTWH-TtNNmxWZqXd1kMuK59_Opg0GX20TCZ57AL5wDBF3V4pgpwOJBOEDcFKWsEPzZDqteYkhNkrP6RPNKmKuFjVyiRtLL-D-KPhLUzNsB89LdL48IKv56FmobIHeSBgm8NFXd_vprPZDuIuxzUDuZhuKj2y6CJM9TojqSK84UUPP7QYhazyy1F3XWztplGMFE90fgJqrqlcr3WB88Q_8mM9vv9SOO0Vms6fGEyh0JiCTzxqvF8XvEiMH4z.TXnDKodKFQMO_cj5xn_pSw; AMP_7268c9db0f=JTdCJTIyZGV2aWNlSWQlMjIlM0ElMjJlMzZmOTJkNi1kYTBhLTQ5MWYtYWM5NS0zZmJkYTczNGJhMzAlMjIlMkMlMjJ1c2VySWQlMjIlM0ElMjIwNzAwNzUyMi1hOWZkLTQ5NGEtYjkwNS0zYTcyOTMwNTgwNDIlMjIlMkMlMjJzZXNzaW9uSWQlMjIlM0ExNzM2MTQ4NDE0NDQ2JTJDJTIyb3B0T3V0JTIyJTNBZmFsc2UlMkMlMjJsYXN0RXZlbnRUaW1lJTIyJTNBMTczNjE0ODQ1NzUwNyUyQyUyMmxhc3RFdmVudElkJTIyJTNBOCUyQyUyMnBhZ2VDb3VudGVyJTIyJTNBNCU3RA==; _ga_ME15C3DGRL=GS1.1.1736148414.1.1.1736148457.0.0.0; _uetsid=9aca73b0cbff11efa68307613c52d182; _uetvid=9aca7820cbff11ef8ce01f1852339efe"

    # token = "__Host-next-auth.csrf-token=b6a0091ee0d152fe37d2eaa7322219d59021b4ac3c403763e11780c5013ae0fd%7C6de0d7e75853cd14212aa486e57e284e880e7233c1756519d5062f7e78d7adef; _gcl_au=1.1.1036319845.1736148196; AMP_MKTG_7268c9db0f=JTdCJTdE; _fbp=fb.1.1736148196408.381886146149209078; _ga=GA1.1.1233695181.1736148196; _tt_enable_cookie=1; _ttp=ScLXjpXS1bWskaW_gYVrdjGfKFi.tt.1; _pin_unauth=dWlkPU5EYzBPVGRtTVdVdE9XWmhZUzAwTkRabExXRmlaREF0TXpjNU5tTTNaVFV5TjJGag; x-recraft-referral-code=3h7wfOgFGn; _clck=exo3qo%7C2%7Cfsc%7C0%7C1832; __Secure-next-auth.callback-url=https%3A%2F%2Fwww.recraft.ai%2Fprojects; __Secure-next-auth.session-token.0=eyJhbGciOiJkaXIiLCJlbmMiOiJBMjU2R0NNIn0..rRuUZ-Yb_3WDAlhl.cwafj0Ba4NdYuP96D8vplfHL55zRggpHcZz4bVF2KQBdI9au-4p6lSybuRqVUjWumNEUGoi3wfLSey8OIGtpvbCP0MEsXz6HlXVlJnIOFQ1WiuRJot4VAFmJ8ybdTiR-ygS6coZDYojIr4qGS9ILITFNMhw6r0N5VINswoV38D4sL_MjNsppvhhHNGUSYUYgVjn7D21XvfzM5bhDpvstjuCVbE90i-i0xCqO77ti5y_U2SUSmA2WjnO39cK-AYchWbyRZd-ok2XgA12bG8bM3stHXm5CHOD5rSIf0Bnz7QtLz91PHxsFm3I7hIDZz-mLQQy5y2LmXgV34Ze3_HSc2L4IojH1S1wjemV4SPivbqdzaSqYK7JVd_ltMLSvYs7Bip5ZJzhN388C2TbFn8pqXsS-H8f3aTcKQ5LyJmgesIiH8kJt2sgXu-HGgeRJxOerD7MxQ5xDm__Q7Tt576bLxbT2mUwuV-EKRR--cB94CRhckia4BMNEtBTmKZD5UupwXZ-KKPHLGLMo3hhEitbTnL4sWeUBD_kIctMde3C3njzuB6pb6GCCX_MIrgVovLh4kRo1Q172XZlNjbVMJZOa2pIhALV9valGtWUuzgj7yWOj_u6ALEJjS_8El1f38OVVvNjDaBzktGM-2g0ad1EHXflAYePAAb9PzbSuVaINlnwxg6KmMifmDlHXIJW9cExcS6o7tI8xos9yxjjzQprpa4-KGcPG1VjphxVOa8UBNl9lkXXLPtK6_RYdI8UV6s7vyYIW6uNL7G5j-yffIY-je6HHuCRHYMBNy2rr--D_tRoTHUVzDbmZzTzHHOBcYkNSt-UH_3rwZJDvPdKPfAo_EgjOIerGTCh8xD7IZVF3gal3yAB-dflfeedihGNwPmMY2MkrogEMSnV91NJpYf5NEuTnNczv_XbUbrZQnPc4nStk3de_FU_HOriDUPaRuXIMtiCAnExF2rv0mGnxuYxHeji6ItMfD4Tn5iC-JNXyG5j_0MCnUC59YpqTeOZf3Ae7caKkeS7YSreRDnqSaTRPOHDJD3sxP6K7xSzOvN5i5BUvL3jA9oqR8jkBQvcxDuLzQHFMgZOBUL7nQKgi6OKJSArXIvX1MUHdq918PiOl2IhX-dpnK3gfSsNtSuhBVbMMfIYdG129uebVL1Np0-xPTmYYOunsEwGIbLvEaZFrbISza_aTmtT575MywCLtLef68wK2ll9FOMHmAcH4Zip4K6TIyZyikbevsE9UIB7m5QYm5Hbne22hZ0_rvAX0WAFfS3ZBckC2dqD4qeKyQYJawo3Q3fAQ6lZnhRBYca1e8j9Aj9Z7p_DiaFdXCG1KigtqPKbjOvxYhWNxNDPM1edvPDUnONyTZrmaYvODhg3VGCLtbJGhy4dujRXBbvhTI0ul2fUtqPe9E3avjlvxOZqVRjYeBxbbJ5OcnhIhi4APc_MB7lB1kN7qVpkNoS8UKCtMAHF9BxcBhxPt7R_wNJsD9DhBzWhviE5KTSziKrJVUOFR5aEa4rjOxfi_zk0oAK1dLiuRMGlpLFIj2ybC7ceFP4L9Bz4_rmIgxOOkqnguNbgN9d2siZfY4USmwLkI-sSEChVEgdIuW2OO3eYyqUiQbQKcoQg8YMgRld6MXAtXACRWAyaViar-LfNPasG9m1qvzz7LtEfVwrTafN_Wx-crG3xeHkc-2KSYmWzDOBAeBUfZoHXnFq-ES9GL8il2AKipGdqSZBy5XrKS4SPzSb9AKEiV-TnkcZHeWKLwfxghNxD05WUa63cPDhH8p3Ygabx-uPzrr5TXfDZqYbdsghihW9BAAzUD8vz4dessqm_5nGe7x865AIUjkmqLol81bj5rNU0wl-AFYMmscIx-GA5KhSp5CxZ9sKcezxf21njovLVGNVjMLFlma40x2nenKnadvq7kAvn6luvDOK1g27B_gcuxxpjjy4Y8OQick2PzbcssD0lJdjKZY4LBsEZd_O5h3dB4ioohnLEYpukw2r9S0FAkWko31Eho3NxBJhEnMqI9Xt7fg9fxiUsRvI9w8DjMUKeyM6odLohu7pRLYJA_ow72jKyOiOonaG5Ry_YE45xoDaTNdsmejaP4My5re0CyYroHlLSKmGZ5pq-wiEbNQ8Uque9PwAxcQoqE8O0uV_Uvl5-HBK8KfP2zU8QhSRz-dEEw_0azH7QbsioeDSy3vl6ff1WzYIZ83NBqhoOlVlB5iUEja_MC0m6khzAJuPnHrUmLGlHF3d35xjA08e0f2GGHdWImnLg9CWSb2ywyV8Nbne0uuokNCtUHoamGfrW8eivBIoYnNTVuM8xb-Tp7Vqgk1TkA0bUPY1ufdo4pf0AQ4VenV4jfm9zAGm2xt1Ev8cf_LDnI7WPo-Kptr9Smm34y3rKYKAVZBtacMJk8RX-PWJcmXJXu_JSodvZdnXRal0j55EdlkaPjHt8R7V8xwTgtd6SonkeZNftXRjYOFwfx8k7mG6cjvznmY2Mg5ft0I4j8q5z_UQ4K5hL4N1nfAlAb4qOO5BZJ2eRuFrGa3oTQe-DFJPBROjHbZc88Qj8bcyV8xvtbDryzj58eEYJdjv5HMkRqKmbSTTRuPpC-BT54zRVINB7SidSyIETv2rBBNqSZJ87CXg68Ps5FadF_1bFStfReZnLujbq562dEBJxPEb2f3NDsP_aafbQRB_LnIrL9Nv8sWAxk_L5kj3PqkR_RhjueSyT7ti63XCuOMYkXcii0psASTEXS9Z2HtbMyn9oSf8Ab7SCnpdAgqXo00qTuOVuRlwmBoNZunjyj4yUWaflfUzMDtPLEsV119pGfwxjQYrn_l8RTd4rn8vQTlv5iDro-MRH-9HL0ikGY_sINBjp0YNph1kFIMHblNb0T0tjfwCWfgjT00J_Z-OMR2HagidN4SxIhOdOXinNdDA0xPMB4iTdgiZ7fvAlmEcDqAefW70Z7vjnNeg7Y6pihBrckCkrewrFQtCbS093zR8W2cOx4tlwhDTkyrMlpLuatTiSpa9GfvkWGT69g7-bQ_0dHhHgFdhxeOLQNIZnYIdPpMMsWS-cQxywJBCklLyxxxHlObIyjY6rpFgXs7klmvb5YYUsV42uykKsg_pzQY4EZa9Z0TpMHugoa2CbRTnHF8dLj_RmI15MMigAEvZCs-2zBzuBUx3wxgwFGMJ2vXMdjM_wblwHuyIOSxpGmDno4HXUQz40d5-65qfxw1CjuvotJPWloZLVFe3kb1LxjiiK6n7U5ZwAEd585-3MREQS0Z3DxTPxJpmPGEcSgGywzDw0_ydfbibmEFpKw0yKbR1P56Y9AL1xqaOUC1r9lwv8prCCPsTS-Sm33o7JmDHireizL8GomAohpmRdNwXKkD7ty_g9q01R-V3H8xTEJ8vH8U6Q80PJPEpBpedrzddjaBmEoIA82kq8VGQw_JHRROsn8ZFroKMosyZhDPolt7bQjLfkB0yYHjR3IhoocfW_cOhIB5qVMUHjTuhxMqIwMHNf4cyzMpo5WeiIhhHexvAVxmvUiu3RQT7rcAJ_Sa7_1zbDAMMwZx55cqQEpQxACcmRChSQ3Uae0X6PnnMOSuybfBG7Tt-93vM_H0DxkLIlA3vZbtB9NRrxxjM9nND-eO_vuXVm8dPCI0oi_VaBVcvjE5_KHSG5lwkU21NsNerGT0F083Lc7A4kdxbggcWdEDZY7ADbJO6VDwzBrPCC5NWrmf6ZOS7XVQeeAmfHTx8bCP5kRB-RXUaXKq_Jd0rLfaBjrjjcQ8cvn1Oabf9SgRQYtCvBdhNkDRalfYKeZO2_4UQjN6-bMgZ_PiqBNq_i-SKWbxcWLxoPo4iytattI15ey7rN1UD4ZVxymzyo87vAbZyDSjO_MwJoYAPO; __Secure-next-auth.session-token.1=2t3R30JeLV4aIut5Zg61NXEwXSktmgQfWRkc728kk-djfvfqbVFzLmNwbXybOAFVL7vfVm54BY9dGXaXM3LLod05Gy8aTIHG8HdXdLcxzoVqpTJiZKbczh9W8z39J-wv8jfSpVYkh14fKhAD1x8cPwqt4CE8yPw2n31ObKivmvSRxISs2iMvPqzUziQAXRW7GjgCkfrXGpwsoxCx34yQReRyCcKoXxUeTY5KlhCOMk0e2z-rGBU3bM1fWVnsg-tS-NbFprJWfoJ1VsCZ3GOuf9PelcoptxSiozL-iY3nH7Qe4pLX1dUromUDFP64tGfMnrNDQk556zeqchqcN10bWe2LHnt6qh-PJXh1W-fQc6tcxorVocOimaSFlNbMAnQ-iZ3nxqsc9K6oJbwrU4psowM4rpIhSxwjBAkM4YYD0PJwU.NG2c6fTxCExNJjAot3PIzw; _ga_ME15C3DGRL=GS1.1.1736148196.1.1.1736148271.0.0.0; _uetsid=18aa7b50cbff11ef8cdc198444574434; _uetvid=18aa7a10cbff11ef96081d44284f3a9c; _clsk=16oagzu%7C1736148273747%7C3%7C1%7Cu.clarity.ms%2Fcollect; AMP_7268c9db0f=JTdCJTIyZGV2aWNlSWQlMjIlM0ElMjI4OTYwMjU3ZC1hNDBiLTQ3YmYtOWQzYi00OTE3NmI0ZmZjZWIlMjIlMkMlMjJ1c2VySWQlMjIlM0ElMjJkNTgwYWU5Yi1iOGMwLTRkOTYtYjkzMC04MWI1OGMzMTA0NDglMjIlMkMlMjJzZXNzaW9uSWQlMjIlM0ExNzM2MTQ4MTk2MDczJTJDJTIyb3B0T3V0JTIyJTNBZmFsc2UlMkMlMjJsYXN0RXZlbnRUaW1lJTIyJTNBMTczNjE0ODI3NTQwMSUyQyUyMmxhc3RFdmVudElkJTIyJTNBMjMlMkMlMjJwYWdlQ291bnRlciUyMiUzQTQlN0Q="

    # token = "_gcl_au=1.1.906962865.1730362257; _ga=GA1.1.435165527.1730362257; _fbp=fb.1.1730362257600.714008794112161913; AMP_MKTG_7268c9db0f=JTdCJTdE; _tt_enable_cookie=1; _pin_unauth=dWlkPU0yWmxPR1JsWkRJdE5qZGlZeTAwTWpNeUxXRmpNVEV0TlRrd1l6RTNZelEwTldZMw; __zlcmid=1OVn8OoYVNvKEWM; __stripe_mid=d21b2291-edb8-4cb1-8fac-05c6a9493ca8d85a3c; _ga_ME15C3DGRL=deleted; _ttp=412qSInHGw3jjdyNR6K4tBIYmNZ.tt.1; __Host-next-auth.csrf-token=5a254fcd5cf01dbe6f4d38ff6653073673eb96145321a4aa4e032c1361db4067%7Cfcc1ced5fcc03aca73a9b3374bfaf0f518079e6802a706311c2428b8b12a5639; _clck=uflztg%7C2%7Cfs5%7C0%7C1765; __Secure-next-auth.callback-url=https%3A%2F%2Fwww.recraft.ai%2F; _uetsid=c8d13160c64611efb4398769b61c9995; _uetvid=a8a766f0975f11ef9b7921e48a0cd258; _clsk=5j7win%7C1735524194170%7C4%7C1%7Cb.clarity.ms%2Fcollect; _ga_ME15C3DGRL=GS1.1.1735524172.75.1.1735524194.0.0.0; AMP_7268c9db0f=JTdCJTIyZGV2aWNlSWQlMjIlM0ElMjI2OTE1YzI1My1jMTJjLTQ5ODYtYjM3Ni0xMTI3Y2ZmMTFlMjglMjIlMkMlMjJ1c2VySWQlMjIlM0ElMjI0MDQ5YWRmMi0yNWQ0LTRkNmUtYTFkMy01YmY3NmI3NDMwZDElMjIlMkMlMjJzZXNzaW9uSWQlMjIlM0ExNzM1NTI0MTcyNzY2JTJDJTIyb3B0T3V0JTIyJTNBZmFsc2UlMkMlMjJsYXN0RXZlbnRUaW1lJTIyJTNBMTczNTUyNDIwNjMyMCUyQyUyMmxhc3RFdmVudElkJTIyJTNBMTM4NCUyQyUyMnBhZ2VDb3VudGVyJTIyJTNBNCU3RA==; __Secure-next-auth.session-token.0=eyJhbGciOiJkaXIiLCJlbmMiOiJBMjU2R0NNIn0..U1YidkTjsjiDSGx0.6m18tVwC2Obkzr8qZE7sYPvf2uYS4wk0tiljhQCEnKzJbgO6ZND-G_XSth2dSK023l-82oO7Ilac1uNxhpqOIt97xYbVY0jsvBtEx8GCQADQDjVkPia-pXz9zEhG-o_COvhjBwLTHUePLLvPXjl1pTHaCE_EmSmVRCga_efmG_v7ohs_0P9lGC1bVd6iVb1Z5bG6ep5K5koCUtBdZz4DEenzPAk0ZTYd3SC8XrEgveyN6CH1WH9ZPWO3Ixz1at1xTJeaHMZkQkIInWhdgCRANzXClZscu1NYF-cAT58r1PP9zbfMByJvxtKClFxJlDOc_5CXEMUC-87qSvJK6LWjUADNIPTqXFynp5hh-mY8tVMItv6S4IKhhXvQ6-UARrIGkjjUx2G-K-kXuHDibYiJEYyJZJzzqR0Ld36LjsOY08TFj1NNBZ4PqNcW1RnRvGXtrEvCH9xJrjz6YJeXloptmhHBPlHmNmS3r6qaA9xERD_17by4O2PZwTAKvAeu-gXxLkVDc5DQp_Xy_ID3P9mytkcllz40So5LVJ5SuVggFpjq2lzuuTJsMX7e3t9x0fB_3n5oGU6uFE5dKtf-1eg_o-mVmDBc38hS3xYMv9ZK4QFbxpR5-KQnSK9liTqV3K_V9tfLnsujgrG3zS-bRs9vvROV0XBN9hku407N7DQhfLFwrpOvaH9YmKfGQpuSP2siJutMEudd7VYa67GCeQQSm71irOBPQ1e78wAz06NtBM26890tQbcpuggeo816HtxIlIsS_4TMc5vrs3Palqhzg5_e54ogsP_dlIzAS686M1vFWVDdqNAzNYja96wvJXxTlFAdVaX9THQUNtRGABJxU_uugHpByFtxY3kEfMc0IdhbozenCIhG9F6YFBkM05c5BoaOx_JOhm6l6Cke3gzyrt4rADW68KlF2dcisS61y3pbHSbEKiZptNkq8AZB0QMaeTmb3nfheukVm4gZHq1bFn41vOYwN3GDehzAfivKtME9YgJvAWhXI-ZJI0oC5CKragg3g994KZBtquk_-8CxQpAzchfaExca6YMrOLBrmhtveDj73QIv4Ov-k4GePIqB2avEnRsCI6WVNFemLMNXzBgBqk4I8G1rR94wVDm2xLsEKr5WCrM1VXES2NljT6pIJbMkbW0XwguMxUkSadF0iNc9GIL1S4SCB4kkiX9XXN2n-qupoJ5hkW09z1f4-CvYeVmM7UJX5kqb5Qg0lPhIoLO_9zx7dtSvtgfMxmYptygyqTUKg5Fu4kczqpMtjbqQHZTU2DEziTFQIDSaqxKW98rudTPGiOY81LKWwZpxgrr0ymrzGzmMxHnHTlRPj6_TKdUuA7SOhjIDNdHP4DfBdrd23QhOZRky_p0eYq4QpP_PJ6A4AbMKhAv3cKa4LRG4_zM2mj0OhJmWbRPgLTqmuJ5GJJJtO9Mh7wUrDvxjO0zfJadm9g3Po6rkJj62EtJpc0iqLtUadyeRxsQ0fieFpxJT65oRFkfU92hzHkhrQ2dYt0aqEZ3DPQZp-tDLJWZNUUcXRPC3UDL6HswsX49sH5GeMesWfGo1OBSPrC8uNOFgldfRZfswX5k9GEf5JGEtRQq2bbHWussswRnJkaZZR7AmnFjgEe8K9Amjnv8vMLfP8wyzhdV0w8pKG5iJVmbzW2q0_HemL84XAd9CUUQaMm0B9p7MBzIzvSAj24DoMbXXVnlcLMrtAPxLlRab_cR55FDxRpPdYe36GDd1I80NJdVMMPUQ25xAf_g8H25O5g8uCrWlI7i30UQq20iPqRqJ1cRYe5tKKsfqf4zBDIt6qUGrGOcJdeiWMg8J-vfVaaqmpLKHr3uOPT-kKNt6TelaAVfitIxKPd5woiw_x0ZdF78xSQ0IsL18t3scZP3iYQW3hTSrxG_45e0dT-9aEit_5ClTN1_0NbFbWqarxFI6YZkE3aDbBVbQI9BHys4Q1Sk4xa7j9ApUZKi7XboqULrD8Kgne9UY12uMn_PEa35HTZ-9a19ACihy3VxATY-PVCIylzgLUHCXPISvyiAmPnTlDHhWZ9yHQKduNLhvobIQgq9RW7vaiwEGReav70KXbBeEe5AO0mS5UNFyxaG9_d4WcadQ5eIK5LxzrlPqePSTIHwhhWq5LunPl0cvQ62pJVPKxAqN2Hc1BuVWP3QimkBH6rCSurCZPxUhJukbsQRQAhG-HcMLEq5cNDO79OZ-Pg4goNZ5AsmkgoKGnIP_sPxGiRmTR2WhczJPk4OiuNPh03nvEG6D8WU7BLwfuyT_BBIz8lPjwrrQ5O0YtdMY_Q6lGj-JUPObkSz_UsFvVlus9DFgfKPDQDAXJ5Qza6LD1GB9eMymzsf0s-muYMZ_wcu7S0kTkjzeypFuzQF9IS03hzOBFOx8sX0Vu5_JP_8FWMOvnj7r7B9PApYBjr5vGLkXsO1HQO0egd6YARVXJrRCfuh1zebhWqPsvVy1B3GtGE681qymdBC5Ig0fuzkhmGkwAByD5KmXPwsiH0Z8fxLMF3RxLum6r3VkGD_yzExhxzwBDWEwRECQXVhvYYwv2uIltLFEtVAnQJoBHmFUGUFIaX__xYkDz4G2B8ePormDLydLGAXpCD1yexwacKpw-nZij4TUujJdXIzOdWw0oiAFDdpOowLui-3LurHP21i0nj5zkIncg4EegW6BWkpUBujmJh-RT1b8A9epBfQTVL7FMHZfzaYNOMFcghTZz7rk6SsJwYiMYXReoCNVkt8-NGxXsifIKjfQ9XliVhJhIpqa0zZGqjpXgEI7l7UwX0HZGQuPUCoyhg54P5zKOoUa5Qvo7hgByNTS5Iz59lECZwDyEvsDid1LEopuUfcVlAYidOEk1rrQHDq1ffw6QNCk089ntU7P3myL08cSE_GZL2CUWNQfHwM_6M3A-DFbfoVSYrnuorJGEn2MGIV8Rw8A8LpOoeKqtI3SIuTGrXvVTZo9BtV93BTWZ9sIDxoaxh4aixadJidTLxMpsDhok5Sd14g4-hRcjj-pXHzsqrZB33RBPIeOYJpbVmCGw0wYbL4P3j41agnRIAEjJqRP0XhN1wyw1oTvrZTksN2IeXuoz_-7UeBOu2qt1GBNtHB85GrZrErrWJRC9CF0JjQSHFV99p7LYuoIAp3LAUJtDRgrFSTkgYl7o-r1tyb_k9FaUdK0cwy3P3NvI15YzItRWIaDRvQvNNLyUOeeZVi_M8mF1DDedkY9QKLdpcf5ONFOBLDe5VXSTPQlPttW7BfnX6wQLxQcBrxSFCiFZwIkUJIvBA1B2i6hu-OGqoOfPDeLl4CFEPZVtqJbuh-nqEslw37LW43R4dQf8EVDOR4jMr2rkSp4tQxj0ooX_i3YMN6cBHtiKgBLY5YxuMsQ3wuhkj-H1AugaqwhG4DdpIPCflNNim6xJCNL_cnJnen9TKoH_z56SNVmD8B4XOGef1q_ZId32jJ5lNr_5dnA3OpLe2-HfnLF0CHMYFH3CP_C7ACMNZmcdUP91_3ZXlSNCXGoazkoI_vzkbfiqIIXWbCkX1xmU3COBOhRr9Itc-SPELgW-cSdw_WgicCHwEKNpOOx1s6uPVugDnb5zr8faIvLYpH9B9i6poTEv8pvlW8kNi0bwmTarfW3a913B5GhWHE-PEDhGQWwVbZA_Tw9MRqllnOOFysriiKp-VGUPnBXL1ZhVx9L7-9kE8lmZg7x976IXvIA1Fej9JsgV8fdoiUVN22qmBKo1Pf1uYNT9vcl6hCok_a70uwF6VWxW-Af1p0z_eVPDP6c6jiDi6P8sEArjkakYFYduiXJBJ554aewD981PrP6elc1JcYwbOf0wSacArvx7hDYij_F4jIbuJB9rPY11HNPDuEJ-sMM_RryFXX; __Secure-next-auth.session-token.1=z9OLL_N0mgHuxZVvHW1Lk3aZeTfY49SpHmak0fuOP9KRo2AD6Fr2vL6d2yzweQwZvstiYbquxtOmgMGmBcmZ9LjgHBiProhlENuw0gwGbzGOd45_Y-3adgkKiYvPaKLj8MNN2U29vy_Zkv-XGgImas2kYj2JNxq_uoioI6f5a8Urztq7zC8s4VXoNaAWSar30fS6HXATFWbm69SQ0f1pqYdSWM6Ph6dBxTWjjSdLqrjslRHKr-_oykG7C2oZATVnNXMwxp9rNm02T_Pc8DDVlVGrvSfxbayFC0Qah151V1MyxTj1zMbsJqplzZ6dJFsw-KgHO8S2DzPaQkgHPkR_yERr53BQ9Y2DBCRIJP8g0suObVKRS7QoH4YWSAlWmwBJ9A7IyAsP0Rj1_x-YjjSPecF_Ek7ZFB2PLwtbpBuIVWrXVmjBXp0hUsxdz0lMSW9O0yl84Y2j9ExBfph1dUL8IZ4OFuK6iMu8BBJP6nvrnVx0Mbgd7IXeeuo-k8hQjW-5q9D9awxTOf1AT6CJa6NzrK_N3IYEOFzvU9mrxqHjLy5V4tMV52WTXhvymiSQJVQqX1Z0iU8PTPrg4vZfrOTVTA6b5yxo.Oz5LynFSv1m3FPvz_CdnuQ"
    # token = "__Host-next-auth.csrf-token=6694c35f61afab7aadfeae158e6074458605550b9cd2e4ef2e63ab4ccaf951ac%7Cac9bf15973e5b6a168150a16a386b821f09559fdaa29a0bf1134b0fa4e327664; _gcl_au=1.1.1248447681.1736148414; AMP_MKTG_7268c9db0f=JTdCJTdE; _fbp=fb.1.1736148414688.910490316103599764; _ga=GA1.1.1798926416.1736148415; _pin_unauth=dWlkPVptRTNOekEzWWpFdE56SmpZUzAwWVdFMkxUZzJORGN0TkdFNU0yTTBaR0U0TlRCaA; x-recraft-referral-code=3h7wfOgFGn; _clck=11vqeuv%7C2%7Cfsc%7C0%7C1832; __Secure-next-auth.callback-url=https%3A%2F%2Fwww.recraft.ai%2Fprojects; _tt_enable_cookie=1; _ttp=TcbY_nwRLBZ2qsM-uRmC3WgcqHh.tt.1; _clsk=yoduqn%7C1736148450927%7C2%7C1%7Cu.clarity.ms%2Fcollect; __Secure-next-auth.session-token.0=eyJhbGciOiJkaXIiLCJlbmMiOiJBMjU2R0NNIn0..PdFk7mpcQ-BCcDE0.S4M-rsTMqzIPxiQYjH8HNgYixGpB4Ff_AgLnEEw9ro9h-L_gWycqYrVRvsFP2h_OtZI3afoq_MVXX2M28sY4sgBWVlVatS_q0CApRi0pj738g0hoGBEKMcTJ-kXGKwvHYfM8CC6ugtM5XCfCxFPC3ZwebCf_mjBWmGm_kHBOvc20Zyv2Dy82dg4yCriVdklf8pUSC2-W-XV4KSRVuYplHglrD0c5QpweQSyOUpVeQHJYwaZnUabTSk8NJ6szdq46JxveDgqkeCVpHKW-8KFtXnOJsdG4FHKWdaVs833emAGzFzh7ua9eoD58gJ2dAwVd9RtcTOHoeCIUF6WT0QsGOUZQ4lAakjkRuTqxOSY8jILMyp4L6EVvis-KXp8LL6oxR8kIiEEsjj28KKju8B6YgGQF6fKtHL7yHrf33I4JTGRDSWia_6ltlHBp5s9UggqI5YE6FA5-3SEk74tT-GyJqsQnoFcs0PK2iixTy18-sDmijvdfVZHrcP-J-r0hrV9yk9wPA8hd9k6A9XTPnH_pi9h0YntAGWzd_SVxEpZUNaKXdGrL9oO-9E05XG-GHehYnhO3_zn0oSSRduatnk4RRfDCBBZotz5gKasdsncvCEUX33ZP_cY6B4ju1ej0a6LzOTdmXhCZGbnSLAPu0dAgYj3qXAO_vjiL-kYpzV-J9sQTOecQJE-Rd6IU3mtRSKtV5SqRY-v91cyXhx8O4pQNy1wtNIYST3DFEu8iTxt_8-CKWMiCSVnOOWV0KSoipeK3IDrJt9n1qB8OWCfCQ6A3ZLftI469x7XUDa_wPfmiLj-0ZErhtAz0U50xpfrfjCaunwQ9LKDRjjf-8FdGlqC0HH8EBkAqb7e1a6zvpqWx95oJeic7H8M3HgbbeyF0JqO_W9Zf2AdyNZsYUE7T3N-JDApEESgEMPnBF_ayf2CKknoWiCFOzflpwzcxd_rGlhe3q_CrNW1-ZqKh1sG_t4lKf956fFrHz28c2mfBJjqx5tYcsYw-HQf6wyPFPnzK3FS16wMpVMNRDiAinf-i779tdC_pgPbJJlU73I1aNDpdLnRtowlkMviuVL6y-KcBeK7d3euRYGJdKqM4gjX5WxK1N71s07yDhiXKU35D-gGE1ruF8u6N2epD3jyfjdKsRmxKce4xl96OwZzF0je4lV_LUBl5oXON2TBbznp32o1okq3jUH-7Suzuiis6NERW2dO3wARdlfhNLJ3Ur6zOxhH86v12npd0ZkUbHgqTKn40_4XvmGIdzyMyddIh78k8OFMlLEFIhONFR2PFFhnjvnzfjQrtm4fCDjWZyiAZYB2HOsyHDI2uS66fXLSOglYA9Tco_UrSCQgM4Yom0m3Hq0JH6eC_hAckBNfJ89IFVECVt23njWc0Rj6wG8-OBKyw4nqgCke446n-7ZS_S9d2UA-fcVBoFG7kr9WTEQQYOOC_stkd7jlH2huUUxGCpi_Nye2KL0LGA-VlbCt7KUzKQ_G1Zrl4CiqGNImoGU9PsY9UtwWxUaPVag62iVicD-4_2Z0-lv6mQyS_TICV_CfxegxkBqGmTad14l71M_WjU9eIzSSs-dMguR2Gs3-0JX3SOfn7DQZGXfZps3_FvmvNTji-9YZpEycSWSUssb0XCd3ISqcqYo1TslVOk47Nz4xAOsrM5MKnrpCYAmiXVC7LZA_ezcnM_3zjIIzjRRi-5R4u5jQ-RAqnrjD6LUn0oCnqyKJPl75iMU2YrI4OlD3HrjPXKWKQFYx70gJH8LpugfNCwQuuIrE5teAO9PTVqO_tGt1WWbbfzD8_j3C9tMb2vqP_YL0Ho4YHBPudZ01L2vlyKOplRKeTw7yl4h61bbe2qdYREhYITxrTRmm8biayCWgmj-NQtoMP20N00LtuINpaRraQrRarB67wkCnO-gtP_OGbp7gXQPlm-eyskSX4OuqNJ6v0EKgD2-o6v0j9G2rFvE0rzzEUL5AQxj3KA6lc8RpFR2WCYHQ23CSTsLdrXdptm85Ij4QsD_nNmrMpu5z9BFhoeuGtuwgFqBIJNPJ6rGlRBMVnhWKzSw5-IYNlpFNMDR9kAZo3f_NbM0LzFSIcdeOq3VWVNiBhXOaDztnx7tIUWGiAEqtAKnEfo8W6T_D7-hO3h2sdQIccmj2-iWN7NKSDVzc3eHH4zi4PcAG-X_86MmOy06_xSiOpMWbs0sHxSe4TZGxPYuB2piAvj1TipZGGXnVuy3r31qMxZhG1LOuSPwyrGIKQL3jHr1vh_JRKdObkfEeg7jlrCObCOaLX6wTcEXdQ5g0pMYRPm0a393BqNQafK9MxyMBgmL59YTFW71awz3vyDj9pNswBzfSSK0mew6eS-u2fI4nMnV-1eYnrmKKY_vnqjnwoWDUc1VUoNHMLD3aDtn08hjziLdBuGfUICsygOcjtypYDp8ys-S3KedzBZyNRVyejQq_uEw1SlIFG4up83NjP3aiG2aPZz3JZNGK-RhmTMcuGNa7EpO28k57yZwNnBtXT0ajCPBcjTP2svs-Km0-vuJ0D33JwGpedykr6JAUksQXZ7zQabkKPcmkxnFRjsRF0n9JqH_Abf6eInl_jmTgDnSeMIvA4Tp6aGamu95TEWM_9DjV-fffo9Qd3VJ8Qde4CJSfIrGX5BtxMUAi8zUozrTwL4zTfO2W3NTVK708hLJ-i8N8dE65gAFxEDiqTPX06Y-kYwVp2DfHEsxYR8xojGeHk1rH56duzrmSF1qSgBH_x-LM_XDvKXOq6zsq5TH5q1XfPDepxDeFk2hodOiuHOY9vMe9CPc-arnvz3Dnx2KdiHaM3R3wWB_I7og_9IiRJGtHxwBRFZ6--WEhFi7EqN9n9CU9FfOhg0A5O5F8fxndSamw6pqTD_v_67ZOUue4eJRRnx_n9U-tFz_b1Yp6MAS72a5rmy0DUpz_B1ZWira9T21Nb7G3Q0Eb-rE5FOfaFAqz5ivdekRttlREfgNGfhJQyIM05J5cHessFs2aJTNSU9fXgPvxmrMzziDzvE-QYG3jlmbdrpzIUr3PUjiGbZu7KA0yv_8dZBVXNFUP-w54n3KQ3K7tcL9fBawyX2uTgFWXO955O10Qhp4HnNR9D55DhSe4rjtiLU5nhXC99Q1TeVHpn1skJH_KAgksMM--I_T5TqueiS_c7yjYZIETds1TO_347euTp0Gq2I4uDfMm6ZLOKE8XSN6tMt0cn04TsGn--mMWwCJCslrXomI0rg9vrteQWFsoW3vYgvpgEF9h8A-Uinz_qnzfrocnnQGVtFChOlJ7q4cC88b-JjZ7g9arATlEhlrLj67wbzYIfK_r_7sdvMLocicdunInOsYL_nJ7eM9pj3WZrAdQrFH2fhYIJa5H0MNBj-uybFJKq6nOSpYyfo4QpVtjiBpH4mFQlsYhg17s_xH8m8wPc8t_Q0V7pwCqKgMlj_ZvK45dNLqwU8MWF4P3xIcSoI2IuGl7kKLmTXsUcQz_EZuoz16aRFXTMPQJOYizH2IsuWixdb2q6q1_7f0205id_ILnzbCYjrcSCDqMK84ka5uiAuISSuW7crZZoyqSzEXU0c6Wc5I1ALaJYeszLzZMneRC3Cb0vfXa4bxmNsqNWogcIBVyver1rpfuJKjWRmYFw3lB6-aG55PJLjF-8ltupPkYKml1G51mQt2HBMpslLTHvwefa4bHoO9czfufl_cZ_uTRaza1jQ6HhFtBSiCiOkl-tekYF0yB1_Gc7ZlDL3QwntfqGWnbtwyWGt_OsOjEggLpVanZOMFwdsra_1YuOreAFSyrO_22Wec6YUTSlky_9B2uQi3TaDWK8b7jdXTq7pMVICNOEoTqwylETNCaSPiwwfGz_AMHr4mvlqpkDbR_ufoxHgDv; __Secure-next-auth.session-token.1=AUyEn2IB_h-Y2_scfWb-83b85MgRA7tKrvfAfo0wWgRY-nYvg8vqCrtT44nflyQlpqvhfwiTAwool46MbcQrcGYJOxX2D9b1Pjk-uSjYQAi-fkuIDDvsBmPsxfQngVJVBMcOIpTIlSLh9pus9s13c2b6a4Ek2QD1KK6WT_YRODbItv0ogbrTWH-TtNNmxWZqXd1kMuK59_Opg0GX20TCZ57AL5wDBF3V4pgpwOJBOEDcFKWsEPzZDqteYkhNkrP6RPNKmKuFjVyiRtLL-D-KPhLUzNsB89LdL48IKv56FmobIHeSBgm8NFXd_vprPZDuIuxzUDuZhuKj2y6CJM9TojqSK84UUPP7QYhazyy1F3XWztplGMFE90fgJqrqlcr3WB88Q_8mM9vv9SOO0Vms6fGEyh0JiCTzxqvF8XvEiMH4z.TXnDKodKFQMO_cj5xn_pSw; AMP_7268c9db0f=JTdCJTIyZGV2aWNlSWQlMjIlM0ElMjJlMzZmOTJkNi1kYTBhLTQ5MWYtYWM5NS0zZmJkYTczNGJhMzAlMjIlMkMlMjJ1c2VySWQlMjIlM0ElMjIwNzAwNzUyMi1hOWZkLTQ5NGEtYjkwNS0zYTcyOTMwNTgwNDIlMjIlMkMlMjJzZXNzaW9uSWQlMjIlM0ExNzM2MTQ4NDE0NDQ2JTJDJTIyb3B0T3V0JTIyJTNBZmFsc2UlMkMlMjJsYXN0RXZlbnRUaW1lJTIyJTNBMTczNjE0ODQ1NzUwNyUyQyUyMmxhc3RFdmVudElkJTIyJTNBOCUyQyUyMnBhZ2VDb3VudGVyJTIyJTNBNCU3RA==; _ga_ME15C3DGRL=GS1.1.1736148414.1.1.1736148457.0.0.0; _uetsid=9aca73b0cbff11efa68307613c52d182; _uetvid=9aca7820cbff11ef8ce01f1852339efe"
    token = "__Host-next-auth.csrf-token=3da153bbbceac89ee879a58271a68e04ef33ac04f50b88591340afc6ec19812e%7C5b3ad5eb06a8b5f02fb9f3fba48133a5dcd268f10668d4035b966461dea83822; AMP_MKTG_7268c9db0f=JTdCJTdE; _gcl_au=1.1.1896709423.1736302346; _ga=GA1.1.10593690.1736302348; _fbp=fb.1.1736302349336.414258450110248556; _pin_unauth=dWlkPVlqazJNVEZoTTJRdFpUVXlOaTAwWlRRNUxXRmxNelF0TnpOa1ltUXlOVEZsWXpsaw; _tt_enable_cookie=1; _ttp=kLi5NQ_CWb0_K4XUfVtA10jGvFn.tt.1; _clck=13e8jkl%7C2%7Cfse%7C0%7C1834; x-recraft-referral-code=3h7wfOgFGn; __Secure-next-auth.callback-url=https%3A%2F%2Fwww.recraft.ai%2Fprojects; _clsk=1wqxtem%7C1736302380447%7C2%7C1%7Cb.clarity.ms%2Fcollect; _uetsid=033a7bf0cd6611ef819c1f2b018047c4; _uetvid=033aacd0cd6611efa43ba93c5e6daeb0; __Secure-next-auth.session-token.0=eyJhbGciOiJkaXIiLCJlbmMiOiJBMjU2R0NNIn0..ZrGSeVcHFLbRXRt9.sLv2uELzOs2q92YoQ1NOcXCT8AN8mw1fuzDVj0ge7LDp5O7N37ZVTQqaoirb3kIFoIkgl1GXcK6_JG2zkaQHpr2ZkLD7EM2g0UuVGxngoh5YbU0dgsfDndvwqgwrh0MZodd4AzsOL-5DdAvm-68gxPxndJ9kYw5BJ9OM0Xs3aTI6PkFv-HHNWtTSXYNur7e27RnmVt-UFpzWaBEOAAMJ65w7jGZuPQ7ViAeajw_jsaf0sqZ8sVv4sCe7qa9V1H1Odz_IGVIWHD0jJcBXAoLGcHVquWa1OswdQ89fUfzMBKmWOH9m2qiuMa9HV7wuDjrLVIeVAaIteDFjdkS8xxNRnARDZ3J77VO2zwVgiYvl38Or4gbhlcLcDmravtWl_wX3F-xKkHFjkLIGIFmIkvt8EnzLVhbDaoRwdG4cyTrcHQ7UFzXtjIf_Ipgs-__YYOSUUE5U5QSNhgbRblOzZR2GKmlRryIp-K0JKtuxmsHWoNglKnzO_ts3D_5IU6gaRPBB0hhOfgaAYH8GhMpXB759SrBpxaVgLdSLeD1MFn3sg1GFFK7d1p7ks1KNGQGTSTIkR9ju7diyl48f7deD0QhsaVUftg637L8nCvQUOTtAM2L6vXaSG3Xaw6kb5eF97UjjYIBhCByrePeuzVRidcJO9f1h8d8RLoFn82oHCHVDf4S9jO8OqsLsCWvgWiOt4JdMyHccoiwotVh9zum-YX1_-ygaoU0SHzN2l7mJtAYDuheEN4Amg7guNE3uSBFloGFILRKIBcu9PyqlDWg31yKbIGiQyjTn0SiA0JT2itkIUgg5sx3Np_6_3pwR7JyjRJwcTdO4mf8mvawzM61ALCpv4hcB7VmvkE9Sd7XWG_XPH7Y686v3tZGSsJmOOfoBefT-PXLSLnFdj_enJ63UNeqgK4HpSidt5ncCudIu91H1kRgBgW3QVCQcFvjTnCamPSyAiyu7VHqlSwdg4vPUvI5Ngbg9AiLn-L84NkDZfJ0ejiKwB3PeIgwI2PMc_1c1gSU5fMXIezCWbEo0atAHdeABQjFzOSAv6Sng8XPdB-hB5BKtww7_6QwLqPdkRTLDGC5HMecvVMtuHTdfjr61FEdayDBhbIXmeKTCN1dn7DZovoHc28wPLOVfJ1VWwDvOHez3gsVYt8ZMTm0kamzpYcdyGeXrq8d6G4ZwkXSl34-SQ6jBeHw_hfE4oOfsWK8RRfFf6Lk3NIPZQzVtH6-tRSNW5OOQ6QiQS76s6-OEtM2feCGXnP4wUBZZmcbWmgjOoWw0VtMwf4KiTYQfLY741gAAsebc1wZPWT2iKmJQdI8oxdxQjr1mpvkW72xJqh2IXf5SiLsmTvzhbWDDzcKcVdv152-snKkTnF4483tSRzaTcetvj78pl29YVILRs08REsJeulP-oh7j8S8AHck947MBXvg9YLC37RyGPVzVsMFxAXSFymRX3HepqqAWNTPTJVhwNP7pT0da7SD2wP2I2YE1UHZwRTdVFcFTM6H-vLP1dSIdClPD9utvgNJ511v56ywOAnX9IeCBVeEyF_kKYW0vmfKrnwF5H4FszAa3kHMn8G2hJBFMwfXMu9DjT3B_7JoZHGGCilTe5vvCg9aBFrhgo0ydOFk15nQSD__tlMVTCxyl6qkj4gqV9l6aRjZGTtAVZ9hVk3UB3ZU_6sy4I-28_5vvfn5yD_KV0vTB-LO4CUqPqOZWsYoq7CT07NAFFlMtlXOytQwDkBsP9_2mu2ZtawpCTVGcql1gETBKaSWYr3_CmOp8aSbv_HqWOpqyVEKV775jCmjX-l44ZuChVZfZUJxC_EsZbFVnSXUEnR2dw5Qb3_WOWKhhLNgjFtwARsf5vU-d2XX6kPgJZMfOVGfl6CRy1KEJYray_n2fR9e8ZMF1ZHR0MWLYZZoeSoDYZHpAo0iaXy43g-KI16bVaer_wez0zg2UvMj26jkqOMS6J1bW-VpzucoKkRXYOjnO5L11_gNmMM8dA_mnlwWl18n-G3evNLJsKUNEFwMWZbpja1_YfsevxzYecIYXtyJCDpFESX430-K6ZYX3ryC0R_9EFxmwZczft6OXtR1DxvMd0HutiYg0lu4IeVJlWUTswbcAs3daXxir-6p9sCJGwk1rumvfiMVWu2EUTUqsm47NEmOAiZegOnftMwjcuJVV0y6gPDf5d3oCJi1r9DI9F7W5zX8SfCfm8psTfuamN-vk1Pl3w5y0_pRlGYxOCrcq822cmN-mOWpzTRCKBAtvPmfbHukv2SeQyzQssT0uadQb14IjL1aYeAy9bo7GSf9gAyaZ3wq1VRrC0yOoJ2_zZggC6MDpp0qUp-reF3G7PqQL3m3ij4V9ykyI-w4isvBhD3KRxtywE_n282dXjdZCQhKpvtYHleig5oc8DuHAiFEwmIS-1NAKKtdhshJe_oXkRh_wWbuKSX_YRBmNg7QbQXx7qcTXCrsdOWE_5pEDoh9CI3PfZeDlsAx6KvXDaBbCUdMdgMPjwir2NkOU3AkBUuvpoNn3MExiRznl9J7eG2GydCoBwMAEglRRb-U9wVmI0O9DIQYQUhCJvY0D1coNhRcPz2ewYY6uT8vuRmlfAMMt1oZqD3737ghXcji2ypFoaGOMZJe4vE114kajWCNHsiaGsMPIqroztxo7fctwDiTW8AMdwwowGMtqqniGLlcE2pc6iRMc-1ZjuUqjsettPnzCHnd3mA5vtxjkZk7IiAT_-ut5m4_22rVnyXMluLh48Qx6hDjiRTBmf3voZWVPd2mvhJFh7k6P9_a3a54bebXhyTuF6m11iV4yUmQ96S_t518hN13TiVaP3Y-hWZQssbi0ikAprlcQ_gofLJA-lONU3YRTvVlV3HzkRgqt9ZGS2NgXRppMrQ46D3KBqYA5gzJKTO4PE9WX7JxIx9q5bhfq8vnLgfh3Rex57IYPXasLDKGsI_kADJ4YlkoBSYkMh09TeneJVKGAFqN_8EHtDc_deXvysaLaDr6gGQJEz7yKPU5fYeD5ONQJhAf1BwEzYVW--s_iagpFLaH0LSqRbWzfk3FpbzSuqoIX-wWm_zyzFYIDpEq7xKq5uzluXMUpIMZKx-R20QHn3_IOo6OPCSiqu400dB6BaeCv_Yl08jIzqpaFMOlt1e3LTpE03fSRwI6d2P9AgxYF79tjiFcIz7VJMXi5in6VVA1QPsGhy9BRSaCUusuS0IB6fpDCFU0cgvyWEMYBiFFMQ5PUhxgiq3teedocY2dh1wOsBmhA5nIIV3fwmABBPhWLWv_ltBMj1pd_mn2Drd5g-0fTihSVo2lmGElTktCiS_3LliKPX6ZDIiKfBj1Johv9q1lomAsVr-rLRgFSi7oVA5zc2HlxFraTUdVmynZhVdxKTnR2L8BXuW0f6C9VTPXgtJbAP7GNiwKRGdwDpEealgDNlPQcS3v_k_2hDb5kgTrFfNFYyzW6pgupjPqaGCRhZAssPMCMzmlnoM52XzYOB008_XvGtyMyUL8Sk3tPYHzrHUvT-JfNSiBSfPB526frwom4HX-it-TPx7aTP5VMPx2bePyU8_JqfHvDYuVdBoK_Y_kkicPfe7zO9G98MHs12ovy8L_sYmQxVKnoPl8T_dbZG2cyxGFHWKgElHCCRYqntXUVpMwET75wJYRb_xvflHkuCdGSDeleKqxlsXJ1Oh3IF9TDj6QVi0Y4z1SDYsOBNMswzY29V7uMGz4UPRdq7TTeWrieKhqGmn6_G1iwgZMO8ow9szzQzT_FT38ibm8YY72_de493xom-F1cLjYk4ojrzAF1KSqnil5IoV_3iwJp0Du3duMuJZWk5g1uv2AuH2qiKetTBEjRl49jK7eYV6t9oPfFY3joKBcsPvI_ExwzCw8; __Secure-next-auth.session-token.1=IewRmnPuUisNykivhYJM8wUa4DZiA3B5W46rlWa6hv7U8ILy52x9Gmvxeq81q8YPWXo0ySlx1Fc0pwDWpOR-o_roVqnnj99uoDHysIKYYd8JZ-G9GhkEcaOWmD3nXvGa18S2L5Z_xO6JdGD1cRcim1VgoYs4m47OTPF2s4D8sVbF2Rlg9el0doGDb0UL_O864ZLG2cZfsXu9er12patwXI6AtZmczAU6ZuN1vPA1Pcha7kjEXkoz_VCAmp362777Il4KHt1aoxiW5moPGwu435SI6rc3-OQYLab-yxWvfOxR7ySuBr83zdQ-m7eUR-A2ecMeHfY2qOpGRaIlnfUGmJxC1TOe8tjCoZP-6Wqa_UdCIrfKRzwC0C94I_pShhJPakXM1TK-mAIrl6R-drd4cgXI3HmQovgnTOJWrRQ9YPYZY.Ao1Ei7uEfJSZkvUhmBKwSA; AMP_7268c9db0f=JTdCJTIyZGV2aWNlSWQlMjIlM0ElMjJmMjM3YWUzZi02YTQ4LTQzMzQtODk1Ny01MzVmOWNmZmJhYmQlMjIlMkMlMjJ1c2VySWQlMjIlM0ElMjJlNmY0N2Y1YS05ZjQ0LTQwNTYtODU5NC1kNTM0MjIxMWI5OTQlMjIlMkMlMjJzZXNzaW9uSWQlMjIlM0ExNzM2MzAyMzQ2MjEwJTJDJTIyb3B0T3V0JTIyJTNBZmFsc2UlMkMlMjJsYXN0RXZlbnRUaW1lJTIyJTNBMTczNjMwMjYzNDg0NyUyQyUyMmxhc3RFdmVudElkJTIyJTNBMjIlMkMlMjJwYWdlQ291bnRlciUyMiUzQTQlN0Q=; _ga_ME15C3DGRL=GS1.1.1736302347.1.1.1736302634.0.0.0"
    token = "__Secure-next-auth.session-token.0=eyJhbGciOiJkaXIiLCJlbmMiOiJBMjU2R0NNIn0..MthtOvg7eoQD9xqX.IuhVv53z9pmKkS538A4lPIE-mOcvNkWjS76H6Tctwt9MbkMO1vKZSnh7oexvweSn_a_CzQH6iDsAqD79fO6R7J6g6hmRjcPUBLHle6fmu7aNrEyuDsLgqJ5p53KKtGpQGqleY-cJr24mXl4caM1U_qJXcE8ZE4GTVdvWWfiMaJ6wyuOatB8X-sa4L578yvW3_QXh8PTauB1ih4IqKXkFTQOQgfPN4mFKJyCxsu4Tf2UdaJbRkimlpt-sFnneMDqTAbOnaz6H4ym0oZSXJuKnIdGaiPSZnAMLZQ82vpKQjzlZW3OJ1UbyCK1oJfH4PwML7Yab2_QOU-xOK8bN6PuHT1kIRGwLKkLwDXOuUGjY61ECQc9xxm6L5ULoFXFaLlcUPKDi4RIwNmYH_LVcmAgYL6zkQr4UWvu6ZN5zW8kXEKwW3MgunjUZp6Vt2OWuJqyKiDwx9IY-kgIfjmhluTSI0Z5SXvuiUmcLBW2YwpppcAv3tEshSh4WolsIn_QUh_LlTHNm9mJM0OA07r5Vteg2gBAYAtxvtHhD7V-8LEjNkv7fgTXqYdM5daYUQjIHpZVygOklgrdQaHahRZnVBR3HxvncIuLbSd9AucV8QfcM6bhdI7ZWmU1bmX0O-KJVdsCHtsK-2zKBgGQ7cj9hD7MlsSjRswDVxUZG9UIDe4XW6m5497jwgafliVAaYPgP78S0ICnNnk4cgyGjvVvml35G2TQYCxzsCwGBvMouDces8NwVmrt52GPoK71XDpHyRj1qilhKi1WC8pstfCuSQuOOmZDQElU4WUT_hFfFS-fe6b0nBZNE9XlhEYspdH000pImYHaUXSDxZStuaPqYaqZpOsE5abEhrVAa8T3u6EQzVavGHRyL_ZK8_7Bhi-AAv8mBm6SSjkDPlZypBu9J06F7NXHUG04B-Gjipq34hEy0ABaeptIM1VeowMr8WFQHV6kTPv9lZDR8pUNo7ZiDbU0e5rcVKUjCvEeod_5M900K4hwYXMt-wcI84acC6lg6k2LhSlCSNWl053gC04iXL_VaUUf3lqNE1HunENdKE60K9FIygU9VP9RzqFI_qeJAs07K6v0k3swNv3bI8GJaJqAyGd-36xDR-3ome2ysDZMWzL6KZ58MOoq4rV5TklOgOscUR8NSn-eFzhS9LaMCCV0ffSLINH6XwF5-v74HvsfGeXYFcIcTO4gh9gIWOMGBSChZrrH_aLrJB4roBNxTN6y_tTU8X6vylaRGIvNgoZRt43FIuNfTJvATQTMAQr5fnLitK3pdhM77WFEflVmCuFXVJTzi1IG0sxMt0n2-a94HzkPGbsWEEbFjeQxNTT_-m5mRWRzNoN64dfWWT9X6VT1_YB--iciHCV8XsL9QHx_NRTce34_tmc-ni3fDQ6AmV1hBleuR6qU7YiOK0x0xAn-YUaNK2bcRWtuXpivVukgcIVS61NdPKzRoeRKrkN60ZcQ87Wh-ssn6GLNzbx3t6NHey2quJZa5nRdrHbbAgSVFyIgN78I0voxK8yLS3edJ9A8FX3SRwmdFF6c9G9-_6CRjDC56OjCuiC5ZdTITfLDCNbXnTWVJIykGSzOQLrK395zuBUgRgzE1KOKJNJRZ58f2I-_mTLs_VHP_bJpqqR4LupAGqSVEhzc1TSKS4o5rsTbW0SrMNrUQ-r4oJ_gf3VoAYumuMhW-ymU4zgxvT9aquXSjUM1vrN8HWxg9YhtMIpxi3ZNmb1tkTP6xRT_jsFBY_wI5pfxMezwNGqYl18SWPbGMdkTtjbGpLk04YmnAK5XX2o93lxS7oHQBVHwS4r4-3vviW8l0FvZVCjHkhgQYoe2szKfWCCqD8QHlXn_jcln1m9kuVp65AAfY6xN-mxTiKUIkFOdM66gW6IWgZU7eBvZmxm8ROMwZNz7BRwHLH7mo5fUwyrABVkY6nzsYwg4mLFZznrWJlC3HVJmupT-OT2rytFOd7o_Q9kbqW4FVx5gmeEa35KhTSHwUNa-HC4mnZWjoEs4C6wwjAAdJt9O0HlAyNJF_qnPuQGrIHz13fJbQ4SURz5vCWyl7Q7x4qIwZGSm5P2ZXTn-kABIiXsRNWpzbOew0VFOcMQ4l4D9u8lgwwfNesyWZEmMkNUD-64fxNIrB52pejsjwCYyoNEQjYxdNc7fNGQsdBK4R20lZlglX3RwPJ5P4hMuu5ERNeKRCxpFTTiEG15SQ7QjmrTs5KNfasCCXfses9UXZXFpLBXHPgO3c9AgKYN-7lF2AGkAv07an7AH97YmVnG9TUPsVPj_kBxoLowtk9vGQSvhMYZtEztmQKS4fDMIbw0WnENYcijxX54ZzriMSAMzAeuNO3Jzl6WOp-n53tGnDziZR_sHZFyN6FG4Phfiz5Chwq550_PBah_nUdRxE_qoDBHg5Zm39hRLq5vgucmvTMo7Kz4-Vr-IM9caKj8OMzbgLXjXdArenNJo9sq3iNOvdDkv915mGYr8g3BszL1fBQ4u9CCvagE-nCmLxaxmoLpTpyBJhoDydMyoi5n__7evIci9CP7QSusqeIgFJ8tHrSpZ3KmTZ_xpOlLgU4PpQDFc_4yXm9ZzukZcBeWnfIn4PdvwtqM2ZsjSellC4o1BdiJ0iUcoSXl-ZA-P1uq_b8RPNVe13YqruGpSkKluUe4G5_mxOwvwHDfstNgYet1pcq9W0K1EDrU4bNkyZoTitYSOHEwsH1LDZ7K7UmjwmBgGpGFHIWcN7uVBKHyX8940IhBo5YvIZAGGNcFXNLdNUqVY57wkRBQon62yTfEPZwqYa_6jIEX7j43OlCreCK2Q2eu916aTYg3YinCz_hlBCOMklczupYqbqO84xsixjQ2NDrd7NuvxameWB-QsIsMdX5XYOihkf5R4u8bDFyhVXgxIsuRkTyF0JdIMhNTEFc0R5aCfWVhzoED13ldJR2fJqM2GhzjACMwY7uHZ8nIQjFXR84j-myXMgmOOxbuv-x1YnOmxZHtdzgPjDqfWM3s3kmrdffwH9YXizo81YAuF1X440KPCt_o9s3ArAl8hVYIw96jQDEWaQ2YuZId8mQbI3_tANygdt6WnDPMW5jvjWz9wK8WYRD8kg0zbF04gaMLZ_jZTEC5WAlNNBRq3W4zKwbBbYUrdm9Bxe71G8moIgo9-3S0158kwGeebHJL4Hrx76P0-iODFE9CXSxxhuD6XYTC4izf7jVmEbWppBQ7skRcXfv2PTr1_7I6BY6JZ3Zzmo-2uDpPwAJp1im4UnRJRovKOajXcLI29KcxvRYy5reDryUFK7teaim0DJMrO2eyYZOPu3SRlTLRWFavZF0yFVLw3g5EgcCEycte_9g8ye3lqGtbqpuIP6j92fgt3ITFRfSh26kerjEdgH5jo8A6jbQulMG0KhlZ6ijgc7NYflCOi1eE2U3jmxnuMW6rtWSzzgW1Hwt9cve6w_VY6iXMQ7GsPQlErquKQpJdxeYSig_t-aYdd1MAGlJ9SlT9rZyjPGdc2Z3k__od8o7ZSw-ctRP4wOl9YkZ2pdMFYLT-RqGZEIshipCl8hhEw6qX_h61RzBTyOHICGNEZQQ-TkbbIrnXKSQDYBs_uUHW3G3-JahyBuCyPkA3W-TC0glRB-ZWsgdzKrbB8GP1LeEIV_aE4dmD7A4l0-eZArS8gbMF9I9h7o1BwtwdUuPcjOqkv9uI4I1tGJsgG5WLllMf3UiKc953NF4hpBqoXbet9SiRZg3dH-3DQyuuerexgPsi0jXH3Kd_teIaJCDk_kvvwl41Q0XQThcn2dy7yolgGaDhMixapZseerVpb1cVw0yUe4SGlhkklgbRbf5eudNTr8sLamCf1lfWEWG2YEaZuROoJeyO0n2vAPbq1920hcru7Gy7d; Path=/; Expires=Sat, 08 Feb 2025 01:04:35 GMT; HttpOnly; Secure; SameSite=Lax"
    token = "__Host-next-auth.csrf-token=b6b37b10948a6156a1a39d09bd43ab6d0867fcd6001987531fe6f86f802bb0aa%7C3afdfd56119e801c5cb80dc96670031c85a2d9a02e8205f38fc5d6128e1a4075; _gcl_au=1.1.386131236.1736384852; _ga=GA1.1.282109674.1736384854; AMP_MKTG_7268c9db0f=JTdCJTdE; _fbp=fb.1.1736384856672.571916090953259055; _clck=2fa0yj%7C2%7Cfsf%7C0%7C1835; x-recraft-referral-code=1f1xoKVYB9; __Secure-next-auth.callback-url=https%3A%2F%2Fwww.recraft.ai%2Fprojects; _uetsid=1d264620ce2611efaf8a0f99cb3bbb99; _uetvid=1d2649e0ce2611efb597376fda548d79; AMP_7268c9db0f=JTdCJTIyZGV2aWNlSWQlMjIlM0ElMjJlMTcxNjRlMy0xMjU4LTQ3ZTYtYTJmYi1jN2JhM2FmNWRiZWUlMjIlMkMlMjJ1c2VySWQlMjIlM0ElMjJlYTNmNmY4NC0zNzNhLTQ0ODgtYTRjMi1mYjgxMzk1YzNiMzElMjIlMkMlMjJzZXNzaW9uSWQlMjIlM0ExNzM2Mzg0ODU2MzQxJTJDJTIyb3B0T3V0JTIyJTNBZmFsc2UlMkMlMjJsYXN0RXZlbnRUaW1lJTIyJTNBMTczNjM4NTAzMTczNyUyQyUyMmxhc3RFdmVudElkJTIyJTNBNjQlMkMlMjJwYWdlQ291bnRlciUyMiUzQTEzJTdE; _clsk=szrjt7%7C1736385032306%7C11%7C1%7Cq.clarity.ms%2Fcollect; _ga_ME15C3DGRL=GS1.1.1736384853.1.1.1736385032.0.0.0; __Secure-next-auth.session-token.0=eyJhbGciOiJkaXIiLCJlbmMiOiJBMjU2R0NNIn0..SyUWD5O3-8Fu7f9K.jbfQGmUTAstB_wL4cyqA7QcbWKp4AFMnouf-WtJnwaPC4gIfu7iuNkXmrvbfp2YsqFJzSIl-5MvZrXt-bhk-DJtwqAdPzTw6sSa33I3IHWSS3TVlVFc9Ze-HT_6dIeMpIiN-rCSNGdpmtkEJLp_3WrCSGPB0NbJLLL_MGg6cQdS5WYz4trehD8sPSQUgYlTw_VaMImqVZOxKujLLgmGfgYdV8nl9p-JmFHMbpfcgn-yXqLca8E50sQOWldPw0p4RqsYyByUANX1POJAW33rm9fsRDHEKtVxOtlW5Hy1jev__V9UqSrhcvH_OQREngiQGYbtD0qLogeUg-vbL0VUAL-9USzXIn2Una3lP04lp3m_NKldiSShXsHJT8RW8IAl7K28ILGilA1fgx0V09JFIHhM4fX-hrPzqoh-BuxaaiF5czEHTtTPLXmnV1UiQgZVmfgliI2e_r9J3WtF-SgSc1Il2cvwxAsp66p5cjixFbpj7AULPXndQniHhTiU9zgDDdv-fEf0arKzW2w0--zwSmYizXMMpNblgxZ9k51CdOBCAM9YGtzDaB-NSA8I9RuHzmgXMvT5GMZSiezuoLdRRcVpuJBz-XF0v9QoQz7SQt6aMaCCTa-fxee--nfYZELu1Uhh90StcuT84VOAlx-wg6FxPEDI6cjlVtKuzcN_RMVYbWKO2z5xLw4zlqyGBleRjt7hNNt-IeCbGuaDxgbUViwhNr_qdh-_ZjQlz_FL4rzlJwPrl6puOsydFF8NIy0MU9oBdelGTtG8LwzNnOW_hGdqEfhXfDP9mzv4Fs4kqGNQxvT0PU2NQ5hIOTb540yHqTGb3kihXPaZL4YregR2-UPRxOM1qmWwgRZ93d9m0BUplhO9s9U2hYoLhp01ID8kiNi2AWp0hRcalh6PwgqSdzgbif3IH8AcHRJpnV2pRSbD7k883O6ukkItWPE-ysv-ak_Hl8FR046xjDaX1ITtyrJmTzFqQ627PGuOt01RmsVMOb1IFCcx4Fr4AYwOMDY0RDk1YxIUUqU4kyMZMVlMrI_ITcrYshdJwdr4k3hNk51gS3QUrhIDnUq93mvUSidSUy_jX47H-ORf9Al5poN3vNJPye9ogASdqRr2psn1UpceMzrejXz_xDSBllWGlSyAmHDlXniKfzGSbRtqET9xRZfy7X0iOGd0WW2Sb9BkI2OE6h2abFkeSmTXJTMaZXhQ244XkhvDVnps1QX4mdSIa1Js0Pb73DcWLV5TR1sTVxm5h9c1l5r-YxWQ9hjF3A43_V0Jp9ATDlcPIjewTqAcPuuNhcQRR6i7pt2CadiFpfT-h7DA1PvPRo7ReySBzDK9VhnlvodflQugnxj5gsRljH6r43s4OrgpJwCtENl-_yw4jDJCCXkJwHfLpSKhLR6CFSM52vrMa9fWg7iW1C4HIVVqyqIwC98-CTe5jYDMKrX_g40oDZL3XEhFCTfzl5o_UfqXJEWlDKZ0D_Aig7iNLDOEq3cwK9QDiP4-bX6jtM1zkltpCY-HPpwTXbtV4iIP6usg9lSJgCDgJjaS39rpBVYSrj-Y_PtPlPW5rJMVkSnp_f_J7uAwQWnluuEpxrb0Ap-vF4Vk4q9gBESbnk3PBg8wfFPC1GesPI4HyG8Jy3oIss8pDXba6D70soJiozgBcPTSxdeDIP1CXsRN2wiItYHeyslQE-_egn8oezT9__8LyVrY8guv14Nu-WGPx3R9xzpHn4TPY3nJQ6bU9H0PlB0qmJLsSh6tWtJ0Yl8-NMlEKr9WkcjOJB-QpFiDEyw3V7r65U5b_BOaNpzRA5OUJ_ZmCfufmyfnHm8R6mE5wqrwUfmxYBRfP_w8_ix58zwTzFsLe7Fii5_J411vqxFHefcljnpgFgf1UIOoAPBUfygBTVdpdJcWzA2QXNI9lKxUIC6pLme9rpNlXE2bCE1cn74qA974x1gBjZ5B_FVsmkYhFRwSboi8ypRFA1F6EWwSNO-LUQH8uVbrDisjjjAX19xq_Sibwq5P-dZMY6aLCuInQjfWic5NGsjjwh4xtBv3FTyt1nvt9SonxdsJi_wvcjEoCVyP7PfYy5Eo-MkOpznzGYc9slQscUhKPihaB7wlAJZxe99tBUHLJI6XoI1o2Z3G4KGRK6PTO_THOTVFBylKTMbg_jvHw63TL4-LNlhJ2efmSjnEZqpGkgIUb8wYSoG3OR-v3H7WPvvAtJAs-NfvQXSGaFZ3O-LnStvyT869zXwP9U6_NZjml7gB9iA0cZVw4o5tAFI5DPVstJAqSrjIW59cpTxxDo2zeBdl8aq5FoKIZ63w8QebUeibLT8_lejsWQtg8RX4WrSTbuZN-gtCsMY4Q-TY4gJtVygtjz44QMzYDXq0G5mlqnPanLvR9tOfZODm8z87e355KdmD7pI305NimlYjMAFECfAaQN4G3oDZiDb85KkO92JXlVwWbo1xfbx4FTikedjY-BI1ErQB5gxTgPo252aw5r9fItydPBE_nuZU211tc41k8IF2F_cbSZ9tUjZz14yb4Ux4RWUdtHs3y7Jh9_5Pj0dnS3dEgJ-7jlhz-v2tmrcgzcEKqDPQGdhKfLl__AMM_11LqMuvj0boYiiaDx8DHN95J_d48um0YvB5IU3sQucEXiRK2j8FpAXc9ptQqPTGdSzz4VhIE0EIzZIV3QqqaRqH6ZEXcNuV_DXwl6HOjui78yu-rpqz50E9fxePaV5LHPbzXp_ZEOLrWonqo9ZAIHzWhCbVM_vMxK7CnrfmhW4ow8l71maoD0ToyTW7J0KbegCnEVyVhAF-IqYc98gq0vEbfgH42JKk07-8v1gVNQ6TZpAbtgajdrRe9XCuR58f_dt7_y8xWLXw_tINMB-x5MLNbdomfSMsit9Vfl29Yr8yD4KIkYhsfhl-nH-7ntrx4KkkLdLoNhKbhdI7o7NO1zdJ22ur7op4YlAWSNq5q-q2uhF3bKTkYhAIJ2FnPZpYmv7NoldLkAML79C7xtbZTJ0ZgXCjxzbEI50-9qvhEMSNm5AjZLrE3tTp6GVJWfIvjb3HmTvEAxR3rRefzzTaKW-MO9t3OurUPood1vkMR7oQzQY_n6DaZKUcxA6L8sK8s2MfEb78h_ZKeKDRAFsnspHdVTYf4xEu_SbXyDYbx2vBU2beXYdhzcdLWff32f3jioAf_q8hk2wKAcj2Spik7Ng-HPbme3XPD0w1b6d266bJ8GIWCUoGmJ9Wm0UalL-ZnoX16yN9El_wfOEoXBFWRe56Ur1ih6ZwZkcuCMZcnUAlXaL3JGgrxtwQjUtuSPSAo7kBZGIS7xXzFL7aJOi9ctqBAJVH0C3g8TJcW7ilF-qzEwrOoo1zWfLQpxMXhg8XKLDzOPAFBwyEOlDaRdoj20aE6NTeWST-X3QEufdM0PE0uB3FAhYWTPyILrAulrIsMJphGU-9sABotQs9apb8Vvekzou3oQ02Nr8n_CHVdDfE7m9I1lOxnB8Yz78oJhBs0WAbcZL9Vy-c-RVBauUMgceqSyQJ3uHR3iWsze4yeVOb4LE4nUxsfBMHQhW-Via3wFpInCCJxS3je2wtiyDTztuMNN8Mxn_GuTJ1i-KkDdvWiAL9c4zg_6HQfsMpLXQXpJ4Ovk-wUAV_NaW9NnVXHR-ygTcsf-BUHEV6dm0EPEk3tNVdlOTMDzXeYmpXn7xSSPuHglNcLnCzbmiANoqs1N5knV9_gVx49MLkYzE2rK_xdAFZUgiR4uujQ16mWNHtzrUUZOWmPu0HrAt2cJsz0snCfakahNceO3di-MQCDppMUnoSlq2ZnRcsMYu_n7mjOP6suimdawk9Ik1y_RpJ1O92UjKl63SqTtknADbwywiDiLr62V59YEUxKhGIaNrg; __Secure-next-auth.session-token.1=q9Nx6cKkfa0ZpdMRs7aQg5BCEByRK-upafTx1BRw9yA7R30AXoMtQfz6ExKBqsbpyVHqJFnLBQuZqJEi_Bmk34FeYJrUjD1ddsPmEex0ftUACPSugpdrgsTxc8CN0f4a8t_m8wTHxhQWbE5_GT-A4Hb4T68U9pDkzA1kWMVHkQ6h1x7HyW_Ykh1KXejgZFJBhdvv4dAKpv0ckYCNXwJVgVwCKGCNikx-ubtZ-5XDX5ZquUNzVEGpx1cr-F4e0-aw8CDQmdZ0Zh7VHV5DKL7SkQW20FHjpiK-J6gdkkjGFX7EybuEM1KCZ-KI_9hna9JzZc52f_yyoN05hqTzWmfh4aFeQL3j1nErMn23uiava2BfKIoQ59dKWOO5zos66El2TtIFerhUFJDyt8sUOcybCWsmmf05oSeLzHeaJYBA8j7SP.FYyhM198a9ZP-Ep6hZRQNQ"
    token = "__Host-next-auth.csrf-token=b6b37b10948a6156a1a39d09bd43ab6d0867fcd6001987531fe6f86f802bb0aa%7C3afdfd56119e801c5cb80dc96670031c85a2d9a02e8205f38fc5d6128e1a4075; _gcl_au=1.1.386131236.1736384852; _ga=GA1.1.282109674.1736384854; AMP_MKTG_7268c9db0f=JTdCJTdE; _fbp=fb.1.1736384856672.571916090953259055; _clck=2fa0yj%7C2%7Cfsf%7C0%7C1835; x-recraft-referral-code=1f1xoKVYB9; __Secure-next-auth.callback-url=https%3A%2F%2Fwww.recraft.ai%2Fprojects; _uetsid=1d264620ce2611efaf8a0f99cb3bbb99; _uetvid=1d2649e0ce2611efb597376fda548d79; __Secure-next-auth.session-token.0=eyJhbGciOiJkaXIiLCJlbmMiOiJBMjU2R0NNIn0..WqFwC8QbnjwUkMxi.RYqiKFIQTVwJF5azhoAlOscRiivJrpL5fRaArVfPstl4mOB0YTUtp3l7TMKbGEsM8nV2DW68eRarLqQeVjq0eKzD4MNuvuKy0y0phQTMs7vKlKCM5UgWMxz3Uz30f7GmH6s4D0aFDGbJ6upcsUqZ0BMwY2KkXId5uilh0jrDhinv5ZCIQA0o89Nf_lOcapGVsEi4OdYhe8fDDuhaI8x8TnkTQcDjwijc44WWUQg5vXJusYAVRbXR0-hO_fLl7verrBVKWPKXsP_tbRSk2TIqTavXoP-RcHI55R-vQD0G3lbl0hkjiDhWZ8SG2g3_KkbnF9XovoilxZpguNUSqLLHevldctBrMDG9vnoG6FRVwmPF8T5IxVYnkCb5IiyIJLMAOWlVlcNmKM2n2N-_iW21-skyqq0O0sUpukL0gFLp5UlpKtXUbTOMaD60Ja0D7n2THWO3yWrlTmXJ641igNxsAfb8iMuN9XpVSLTGmSVoojIQkbb41Br5ZmAdlH3D9X2u7cZD756HkOG4LhWp6rjaoUwDY1XBMjSxs9lOOGQGnr7xfmVC7fSWDuRhHxwF0C9PUbndo3zv12A437VASNXzuJ7W-nvBP0i7PUw09bKgYTsUyytFwBiRFW_Lj3l5Fcu0qrXQBosvdZvgS3QNEMqOWPWiyQBI5NatP8ZSQuquzvNDRt4typ5T6YP6NEqqMwSLRL6mwA1_ZquU78kygEUFYq5fUtUoWoW8CdbHsZe8DvN0fIhW2iAguey5hj7Dwg3xstOM-aDyRMbY-ML__zTi0w-TB0XzJ9NSXe8a1b3vvjzNqNWmeUwF4eT2KAloIvKRrlWZRC3OedxI8aRvoVGcnWqpRsvZNgUY3blfxG9lR1KrNgAcDhcRB3Si3APLlUT5Uv0MzfZKwWtZ16lLNmY6bRnlQO_IGRVvGWp0tXiwMAR6vXEhq3FqEOMy9W1JW2MVS9s_mpOrloRr4CIxtDbrE90Pjhm1wPzC43OMGsm2gxU8JTaRtWftnZ6EUlO2rski0Ep2Kl_iTwotDVPZY3RV9B8GWTfmJ8mU2EPTjlKcpeyPGiLdZkI4r5HGT6Bt9sv3JXQeU64ecmhbDEr9zrDVRDJlt3nGsQlDq21xkOsQw6nyFjg0cw_i5sGqkyLEQgkfVHGaNuUy_aP7us-DHeLCgusM0qFjsGh6TqY536AxlecGZr5Xh7FOEgVcNHfmT8gTRGPJuqMU_c8kyWqhihx_vm1dTTkHF0O4LJ3W9c-8sAQhsHvzsGGoEBkCi3TaTlBAcJ1_4ix1ITj21Ix1Udmc4cvNE5NRW_aBiwGQvrKlT7qvpxzzHZd-zpF2jAN78bGm6-jK2WSy59-y4FN9ZUrG1QwG5n-3rFiSl-pqRY3Bybx4ANnEU1cbf-0rnL-R3rcbCOEcMOf3CWc78PraUa7sqoV4tnmJdSwjmpVPmptOs2b9bbg6B7XqAsYX9PlkSAztLJQlVIUD4et0O1MOf5nSCmOG-x4cb1wtw8O2ZKea963732M9MUpiw9jBn2sAQbH5cufD0xlXGuVzn8gkDzOb007V018t--yJmbYcvDgMbp7VPESkQdtVMScn-jcpzNrdqDRIUjehEseVuULZhlv4HKopQjNrnyEenZb7kbeogISNKAa5zVKLKots1L9kTHkyziYdcv8bETD53c1CiIekupheQO32zXFc5KDeoTyQNi0O4KKpSCKSlp8GtmNt1q5--y8z1mmFru0xQeTcFG7rgm-q3u6lIQuxRM5n-hHdosYhRsJmX_AOlzw7UpagoV90hzxfGQwa5Oa9OHfoisF5-ueVsibMe-mqWct6OVV9Rke_7lPfjhVbQUS1-Y73MJJF1H5uW8b88GZqPIFxNTb8P-1ACFCWFpvCJRHjJ2rNP5AF1VtSKIgitmaNVwmqcwCwXOpGO7KqSqfKiIBGgik2t7T_joJjwZetvjpnZ-apNCJpmqtJc1rEfDGDBQvaXEuIJ3aB2nB1f4JNqxUatW9D_QMuLHvKmKPlRBQRtHMA7p-XFaJHQm4U-yhz75eGMCfcT7ik-3i8QNFJwwrZcWVbDNqdExmpV0hiE9fjgbmhU5OkoysPgrZfn0WSfo1Cdccb8WQuR8Kn_xj9cCqUjLm79mrsfUzLDsQOgIRBeiUoAH3oQKfI5Iqp2tquOHWb8SyZwENkpKPnipX_60G7BxcqpB5WI6-3MIilfH9itqdYYKImNncuVEzNZX-b2STHKxX1ESCgeb-Hq6SUuEwQtHK0lFnw_Jom8he6ShB-n4a2s6dBO4zT_awB4LZF42-ri7ewlONh2WzLTGW-lK7JNLPEfeXWR-jye7ALwGA2UEtXisMUhEMpuCt2La5EiCKBaw6deGygVbJ2t6dEbkSSEAoZONHctgqmZ9dNMaXC9Hyyo5sPKZPo8uXtJSslyHJlMvgY4W8Uj41IP3Umw1-j_FjYjWiOc5BFAvSbLczgWoXWqbcDa2plXnUmty9OTHw02dZb4opkhLi43ONSodwHqHGWyTgH3kdRhFYV-2uwkSVF8nZG0RHxEDGB3knN6HoHji2LJcn9TwZzOQDaG5sJzrVI12ZLPUx3KSxrygZ6d7KFJpXmi7jXe2kyExrO_HtpNebKq__h776GvuWsx887t2T-DoA1XFoNxbSWIDBaaRrrrMQnTubI7Dl6gs3ea7z2hmDFYcwrqb0r9bDBgx7yhSPjn3AgoRs43NYRe1gVoURcHduyFS6DM7wncDDMIyz3bgEtvJ4YPI2oPIH74MHDJOR1yUt6OmGMqIs_XbuekM9bi91iNAxwcIgdnYWTGUiR2Vk6O2VqqheOwAXn-_G16oGocsaLoOzu22ywuK6xNcleypBc_vyaPuoDmIlxxNvApurczDFHbTOvlq19G-CcP34gKlW_VLe_1KSA8W5cnH28yllZhzTUs14UpxLC6uV6VarxVqrUCLeWgvJ3Nc0pXiBE4ZwZuwWMzYWGSi2VtPeShJwhYpRlyt-AZLgXmNMpN4cGqxaFLhiD3m3M5r8ZzsBE_krksF4x-dfptxE18DRSZ5mQ9iF8BEl73VX5s88L4hDBZn9up6hAG-rTVVr3JOT85KYhvXfll92al7kgmYxNF3UVsHBTX8XxtiQx14wKm5gRwLtbBxeuD7HdU3cyqZgvrBrQlISH8p5ghqULI_BFIuXEN8uD52RE3vXrb9gUEMSAWeo7CS_xx-XwSVsfbnMBwzqFe7AcYDGfe38zpCi-oh9sCJjAAXN-KD40UZB7ld-kx3DrDjmRLnp1-gO0Sl4CKti9MFZboe_gxODqG070Cok0niSsoxJdLnfhcYw_JN5fWfhJOzTxRP7l4CXq74ji7ltw7N_EgYUzIONC3nAxZrU746soEvWcUNLmXyYEow3XWyTddMcenK7tLkveetyVXrQRnR7-n0y-WHKpA0dN8ZdnCM4j_z7wkoO4FN3GxGAL9Y0hi--9th4XbP8p_r6VLJ4SQNIuIKuyxRB6Y2NPFNnrOLlXuZiM9OUuFGO8Kz2qU0mPswV805wFCNh2bGNnSPOamizz4LernNK84t6_GM4NgoN7yTaBEX-Ng1EvnJhEfcZtwI3oSXBuLn7ufbWupHMJZfggEZ2FV5y3-w6SQymrpUSBnDZh1LpmibK1cGnJjAB7-1sWmTGUnV75j-qWMh97bPqJi8Uty5tYbgpulO-P4n1KTuCqGXbLDwINu_FNcmOEreQYJcEX1i0QOEoVblu5eJqC5kBPkBPEC1bVhNl3D2Ufdd3i2XCbxvfCoyc5eysl35Od1Hxst-KLZ4tmYI_pTNlI-JqwuKC2RUzJXVqiXpmaAk8jT592uFJs28jlLiB4TmWQ3L48kCnLaya0c_AFhGecdHEbbEy; __Secure-next-auth.session-token.1=twI76zjwWsf6cDBVpwTSlQGNTowWAosArlcPKymXnMkcNljStgeFkom9k95zpiXIDpFsiJB-PTLuGBj_3HmZUpEm5MuHUgbQKSFPio2l7wRW6a98uWicEzF4fcCjGz9OrDwBUnUxjcNnXue0alwa6AhF5T1B79ibZHjBtGq4IYsmt_l9mHR4wsRNXV0w_zCOhQfH1R8sczNff7eKcVnDo14FeadzZEqSNoKGU1C_6TZMOa7zzETGQPekh279ylKUaOZ9EshI_P3aRw71XNEdE2C-uOMZPuJIA3zPBvgYxdfppBXENTh8quyQAzHFmIMubPMg2zCNTD6ANvC5eTEH1B675sA9emI9DnC2UJVmNBJQPIpkncxQd98eaeYS0tHaUyzD7HQFJBFQOCmEh-ORdrJVoab1A36idPdzLusO0Tm1e.ZrEoUqMjNICG-4yAF6sAPw; AMP_7268c9db0f=JTdCJTIyZGV2aWNlSWQlMjIlM0ElMjJlMTcxNjRlMy0xMjU4LTQ3ZTYtYTJmYi1jN2JhM2FmNWRiZWUlMjIlMkMlMjJ1c2VySWQlMjIlM0ElMjJlYTNmNmY4NC0zNzNhLTQ0ODgtYTRjMi1mYjgxMzk1YzNiMzElMjIlMkMlMjJzZXNzaW9uSWQlMjIlM0ExNzM2Mzg0ODU2MzQxJTJDJTIyb3B0T3V0JTIyJTNBZmFsc2UlMkMlMjJsYXN0RXZlbnRUaW1lJTIyJTNBMTczNjM4NTAzMDcxOSUyQyUyMmxhc3RFdmVudElkJTIyJTNBNjElMkMlMjJwYWdlQ291bnRlciUyMiUzQTEyJTdE; _clsk=szrjt7%7C1736385030758%7C10%7C1%7Cq.clarity.ms%2Fcollect; _ga_ME15C3DGRL=GS1.1.1736384853.1.1.1736385031.0.0.0"
    token = "__Host-next-auth.csrf-token=b6b37b10948a6156a1a39d09bd43ab6d0867fcd6001987531fe6f86f802bb0aa%7C3afdfd56119e801c5cb80dc96670031c85a2d9a02e8205f38fc5d6128e1a4075; _gcl_au=1.1.386131236.1736384852; _ga=GA1.1.282109674.1736384854; AMP_MKTG_7268c9db0f=JTdCJTdE; _fbp=fb.1.1736384856672.571916090953259055; _clck=2fa0yj%7C2%7Cfsf%7C0%7C1835; x-recraft-referral-code=1f1xoKVYB9; __Secure-next-auth.callback-url=https%3A%2F%2Fwww.recraft.ai%2Fprojects; _uetsid=1d264620ce2611efaf8a0f99cb3bbb99; _uetvid=1d2649e0ce2611efb597376fda548d79; AMP_7268c9db0f=JTdCJTIyZGV2aWNlSWQlMjIlM0ElMjJlMTcxNjRlMy0xMjU4LTQ3ZTYtYTJmYi1jN2JhM2FmNWRiZWUlMjIlMkMlMjJ1c2VySWQlMjIlM0ElMjJlYTNmNmY4NC0zNzNhLTQ0ODgtYTRjMi1mYjgxMzk1YzNiMzElMjIlMkMlMjJzZXNzaW9uSWQlMjIlM0ExNzM2Mzg0ODU2MzQxJTJDJTIyb3B0T3V0JTIyJTNBZmFsc2UlMkMlMjJsYXN0RXZlbnRUaW1lJTIyJTNBMTczNjM4NTAzMTczNyUyQyUyMmxhc3RFdmVudElkJTIyJTNBNjQlMkMlMjJwYWdlQ291bnRlciUyMiUzQTEzJTdE; _clsk=szrjt7%7C1736385032306%7C11%7C1%7Cq.clarity.ms%2Fcollect; _ga_ME15C3DGRL=GS1.1.1736384853.1.1.1736385032.0.0.0; __Secure-next-auth.session-token.0=eyJhbGciOiJkaXIiLCJlbmMiOiJBMjU2R0NNIn0..SyUWD5O3-8Fu7f9K.jbfQGmUTAstB_wL4cyqA7QcbWKp4AFMnouf-WtJnwaPC4gIfu7iuNkXmrvbfp2YsqFJzSIl-5MvZrXt-bhk-DJtwqAdPzTw6sSa33I3IHWSS3TVlVFc9Ze-HT_6dIeMpIiN-rCSNGdpmtkEJLp_3WrCSGPB0NbJLLL_MGg6cQdS5WYz4trehD8sPSQUgYlTw_VaMImqVZOxKujLLgmGfgYdV8nl9p-JmFHMbpfcgn-yXqLca8E50sQOWldPw0p4RqsYyByUANX1POJAW33rm9fsRDHEKtVxOtlW5Hy1jev__V9UqSrhcvH_OQREngiQGYbtD0qLogeUg-vbL0VUAL-9USzXIn2Una3lP04lp3m_NKldiSShXsHJT8RW8IAl7K28ILGilA1fgx0V09JFIHhM4fX-hrPzqoh-BuxaaiF5czEHTtTPLXmnV1UiQgZVmfgliI2e_r9J3WtF-SgSc1Il2cvwxAsp66p5cjixFbpj7AULPXndQniHhTiU9zgDDdv-fEf0arKzW2w0--zwSmYizXMMpNblgxZ9k51CdOBCAM9YGtzDaB-NSA8I9RuHzmgXMvT5GMZSiezuoLdRRcVpuJBz-XF0v9QoQz7SQt6aMaCCTa-fxee--nfYZELu1Uhh90StcuT84VOAlx-wg6FxPEDI6cjlVtKuzcN_RMVYbWKO2z5xLw4zlqyGBleRjt7hNNt-IeCbGuaDxgbUViwhNr_qdh-_ZjQlz_FL4rzlJwPrl6puOsydFF8NIy0MU9oBdelGTtG8LwzNnOW_hGdqEfhXfDP9mzv4Fs4kqGNQxvT0PU2NQ5hIOTb540yHqTGb3kihXPaZL4YregR2-UPRxOM1qmWwgRZ93d9m0BUplhO9s9U2hYoLhp01ID8kiNi2AWp0hRcalh6PwgqSdzgbif3IH8AcHRJpnV2pRSbD7k883O6ukkItWPE-ysv-ak_Hl8FR046xjDaX1ITtyrJmTzFqQ627PGuOt01RmsVMOb1IFCcx4Fr4AYwOMDY0RDk1YxIUUqU4kyMZMVlMrI_ITcrYshdJwdr4k3hNk51gS3QUrhIDnUq93mvUSidSUy_jX47H-ORf9Al5poN3vNJPye9ogASdqRr2psn1UpceMzrejXz_xDSBllWGlSyAmHDlXniKfzGSbRtqET9xRZfy7X0iOGd0WW2Sb9BkI2OE6h2abFkeSmTXJTMaZXhQ244XkhvDVnps1QX4mdSIa1Js0Pb73DcWLV5TR1sTVxm5h9c1l5r-YxWQ9hjF3A43_V0Jp9ATDlcPIjewTqAcPuuNhcQRR6i7pt2CadiFpfT-h7DA1PvPRo7ReySBzDK9VhnlvodflQugnxj5gsRljH6r43s4OrgpJwCtENl-_yw4jDJCCXkJwHfLpSKhLR6CFSM52vrMa9fWg7iW1C4HIVVqyqIwC98-CTe5jYDMKrX_g40oDZL3XEhFCTfzl5o_UfqXJEWlDKZ0D_Aig7iNLDOEq3cwK9QDiP4-bX6jtM1zkltpCY-HPpwTXbtV4iIP6usg9lSJgCDgJjaS39rpBVYSrj-Y_PtPlPW5rJMVkSnp_f_J7uAwQWnluuEpxrb0Ap-vF4Vk4q9gBESbnk3PBg8wfFPC1GesPI4HyG8Jy3oIss8pDXba6D70soJiozgBcPTSxdeDIP1CXsRN2wiItYHeyslQE-_egn8oezT9__8LyVrY8guv14Nu-WGPx3R9xzpHn4TPY3nJQ6bU9H0PlB0qmJLsSh6tWtJ0Yl8-NMlEKr9WkcjOJB-QpFiDEyw3V7r65U5b_BOaNpzRA5OUJ_ZmCfufmyfnHm8R6mE5wqrwUfmxYBRfP_w8_ix58zwTzFsLe7Fii5_J411vqxFHefcljnpgFgf1UIOoAPBUfygBTVdpdJcWzA2QXNI9lKxUIC6pLme9rpNlXE2bCE1cn74qA974x1gBjZ5B_FVsmkYhFRwSboi8ypRFA1F6EWwSNO-LUQH8uVbrDisjjjAX19xq_Sibwq5P-dZMY6aLCuInQjfWic5NGsjjwh4xtBv3FTyt1nvt9SonxdsJi_wvcjEoCVyP7PfYy5Eo-MkOpznzGYc9slQscUhKPihaB7wlAJZxe99tBUHLJI6XoI1o2Z3G4KGRK6PTO_THOTVFBylKTMbg_jvHw63TL4-LNlhJ2efmSjnEZqpGkgIUb8wYSoG3OR-v3H7WPvvAtJAs-NfvQXSGaFZ3O-LnStvyT869zXwP9U6_NZjml7gB9iA0cZVw4o5tAFI5DPVstJAqSrjIW59cpTxxDo2zeBdl8aq5FoKIZ63w8QebUeibLT8_lejsWQtg8RX4WrSTbuZN-gtCsMY4Q-TY4gJtVygtjz44QMzYDXq0G5mlqnPanLvR9tOfZODm8z87e355KdmD7pI305NimlYjMAFECfAaQN4G3oDZiDb85KkO92JXlVwWbo1xfbx4FTikedjY-BI1ErQB5gxTgPo252aw5r9fItydPBE_nuZU211tc41k8IF2F_cbSZ9tUjZz14yb4Ux4RWUdtHs3y7Jh9_5Pj0dnS3dEgJ-7jlhz-v2tmrcgzcEKqDPQGdhKfLl__AMM_11LqMuvj0boYiiaDx8DHN95J_d48um0YvB5IU3sQucEXiRK2j8FpAXc9ptQqPTGdSzz4VhIE0EIzZIV3QqqaRqH6ZEXcNuV_DXwl6HOjui78yu-rpqz50E9fxePaV5LHPbzXp_ZEOLrWonqo9ZAIHzWhCbVM_vMxK7CnrfmhW4ow8l71maoD0ToyTW7J0KbegCnEVyVhAF-IqYc98gq0vEbfgH42JKk07-8v1gVNQ6TZpAbtgajdrRe9XCuR58f_dt7_y8xWLXw_tINMB-x5MLNbdomfSMsit9Vfl29Yr8yD4KIkYhsfhl-nH-7ntrx4KkkLdLoNhKbhdI7o7NO1zdJ22ur7op4YlAWSNq5q-q2uhF3bKTkYhAIJ2FnPZpYmv7NoldLkAML79C7xtbZTJ0ZgXCjxzbEI50-9qvhEMSNm5AjZLrE3tTp6GVJWfIvjb3HmTvEAxR3rRefzzTaKW-MO9t3OurUPood1vkMR7oQzQY_n6DaZKUcxA6L8sK8s2MfEb78h_ZKeKDRAFsnspHdVTYf4xEu_SbXyDYbx2vBU2beXYdhzcdLWff32f3jioAf_q8hk2wKAcj2Spik7Ng-HPbme3XPD0w1b6d266bJ8GIWCUoGmJ9Wm0UalL-ZnoX16yN9El_wfOEoXBFWRe56Ur1ih6ZwZkcuCMZcnUAlXaL3JGgrxtwQjUtuSPSAo7kBZGIS7xXzFL7aJOi9ctqBAJVH0C3g8TJcW7ilF-qzEwrOoo1zWfLQpxMXhg8XKLDzOPAFBwyEOlDaRdoj20aE6NTeWST-X3QEufdM0PE0uB3FAhYWTPyILrAulrIsMJphGU-9sABotQs9apb8Vvekzou3oQ02Nr8n_CHVdDfE7m9I1lOxnB8Yz78oJhBs0WAbcZL9Vy-c-RVBauUMgceqSyQJ3uHR3iWsze4yeVOb4LE4nUxsfBMHQhW-Via3wFpInCCJxS3je2wtiyDTztuMNN8Mxn_GuTJ1i-KkDdvWiAL9c4zg_6HQfsMpLXQXpJ4Ovk-wUAV_NaW9NnVXHR-ygTcsf-BUHEV6dm0EPEk3tNVdlOTMDzXeYmpXn7xSSPuHglNcLnCzbmiANoqs1N5knV9_gVx49MLkYzE2rK_xdAFZUgiR4uujQ16mWNHtzrUUZOWmPu0HrAt2cJsz0snCfakahNceO3di-MQCDppMUnoSlq2ZnRcsMYu_n7mjOP6suimdawk9Ik1y_RpJ1O92UjKl63SqTtknADbwywiDiLr62V59YEUxKhGIaNrg; __Secure-next-auth.session-token.1=q9Nx6cKkfa0ZpdMRs7aQg5BCEByRK-upafTx1BRw9yA7R30AXoMtQfz6ExKBqsbpyVHqJFnLBQuZqJEi_Bmk34FeYJrUjD1ddsPmEex0ftUACPSugpdrgsTxc8CN0f4a8t_m8wTHxhQWbE5_GT-A4Hb4T68U9pDkzA1kWMVHkQ6h1x7HyW_Ykh1KXejgZFJBhdvv4dAKpv0ckYCNXwJVgVwCKGCNikx-ubtZ-5XDX5ZquUNzVEGpx1cr-F4e0-aw8CDQmdZ0Zh7VHV5DKL7SkQW20FHjpiK-J6gdkkjGFX7EybuEM1KCZ-KI_9hna9JzZc52f_yyoN05hqTzWmfh4aFeQL3j1nErMn23uiava2BfKIoQ59dKWOO5zos66El2TtIFerhUFJDyt8sUOcybCWsmmf05oSeLzHeaJYBA8j7SP.FYyhM198a9ZP-Ep6hZRQNQ"
    token = "__Host-next-auth.csrf-token=14ca9d794219c34aca808cdc2a310d73ae76584a7bc746518742db0ac0baadd1%7C74c6e91fc8b1400a4035ce81d78e6a0516c8283e7c2a9104b3d75d93441a83ae; _gcl_au=1.1.526202796.1738463460; _ga=GA1.1.1626801434.1738463460; AMP_MKTG_7268c9db0f=JTdCJTdE; x-recraft-referral-code=7d7RbMefDM; __Secure-next-auth.callback-url=https%3A%2F%2Fwww.recraft.ai%2Fprojects; __Secure-next-auth.session-token.0=eyJhbGciOiJkaXIiLCJlbmMiOiJBMjU2R0NNIn0..GN6pvZZE1X-avzQn.7TBThGPGii6nH6hS8TWazy7XV9Mk22vd2sqPfoHKuEbesS_pITSQc1kUchGlB_HQ_Lx8EldQGvzeVbFil6mBb4tqjNxJFecSHeDgLubqE0u5ueA-ZF4rf6Xz44NGnx-zJr6iA_rD7319KiL4-WWm57Ds5UJ_jo410_018LlUuWme0G2RKMwPySVL3Jg8Zyma5Z-twK50W8WRkwp07xiCZFXIQK6wLu_TvBYBwjVFa0wNJmyRCirM9YHKOsqVMIKP38q679Cd8S9A0s2T7SjLDm_5rme6TtaGq7Xye0cZLuARf_h2oX79Rm3XDPWYXjEJ6OMpNnlB1uvslb8Lbq0GkVAEYJbgc5PgQ2aD7WjqX8omU1uj1HVIXxr3lxDuSyvBPz_16Fkf7wMOI_OVQDCujAh4hdyNGVJ-vBuybQ6yo0vYF0S5X2_lUJqcwchUtwDneBXUUl3kI8JiZf8YF0kROkqkW82bFycQDtaNNFtwdFWyVhC7_L7gYpYpk0QrFJ7MVN25J8xbggLVRKrl-9gZ-55I9IkmM-iAtSuvTzTvqc9NzzRnoRPBDuwPwyKok2TE93QnAPQIzUacXIdZdkjTue-jymc60QrjBRGTIsIC93KD67vYdEH8vb1V0fiiqS4MkGfSpMA4NFaTpRECwqGcNzLj6XTrLGzl8Z2RO9tBWxqtq2Qfggyb8Oxftsab8hTjarw2b8mSSeyy2mnh_sIZiwM5Pl4ZDSYX9TsCdqNnOXyIGEWZCb5fb1rKSALKHrt71QZJXRETZCfJB-ndqw8I3l8rOhKuW0iio58umegRJYyFsJ6UY___fjBLz-0AwqSecklqkt8WDSaymIqR79YiGVjHt_qKLS1M43nVnp5TFneV9yorWPL6Oa2R0TAjU2fWjiaUohlI4XPSNlRXSz9m5EvYKJvKxMdRnZdx7UeZn2rP-C7K5xcjURm0QwXrcWL883DhDiYWrE3Y0IoG-U1n4MhosGeVnJA7FYeOSlpHZs0Re7Aud9nrLo3lWxyRHM9mTjBOTnpRWP5xwAneyM52FT78-RkVBrcaXc60UyK8h1WIxmLDWPIIvDI-W4wlR0SYDRUP7t_8dFXT7NCZXSzskNFa9wmPPWvh4__CXXFWwW2J5X_x_6iLfsBX8C5KsPKeRNplhWJqKM-50Vwk5gM9JtYGjsguKWrAqPbacs-cuexbg-_WwU1trXv6hc28pMU2RJ8FNk4t7OCrhbuwt-PSdAO2bksP8QFKEez8w1mfptn3DN8mFaranAzgwdo-xD0v2Ew2C_oqoYUahxVrKMHqEYSd_bQnLylaftMfYGBNU0WuY7bcvRtJp3DGfQrHTF76ZA5AqgPKFwlmE_5pa-1xb5slX76bFAm1NKhgZZDpGyeqEobp_3u4yXhJTHVHYQuFHNFQm6ZDsepFh8SLR-dWlyrYsu3KHQUcZAMzOW4jiTc7SK37z03ONM5kgw2o_MRcdmvpIMBHCwuGjwLSUxCmora5cDKQY49gKWu778wfeUw-RJIdg4TZzsRM3OV3FnyN7koaWF-D5HdOP0H2v3zre9DtY5N-3_iIo1Fa9F1Pd59X3Oz1wpJ7Yjuam-mboCXgIfQ9q-dn4vGoxdqBqyvDM9IZV8N1MnjxoG6m3BOTdLR90aaYqHKSkDE3ks4oaE2CfGuhK0hHKcnXcEFXm81Mx-eJ90rFTmYOdlId0e19mk5tu-Cbj79MbBpx5cRfojiTqrQH-AIXXRa8aBr4QxAW_p1iDnAQ9owtX8dvbacg_VKhB0IOLlBaDfDmDAwBkvMWwBnaYThOsbIOWQhH-dPBndW8G7ycKJ2xtK0PHApsn0iAujAuPUTYeobNgKdfNHu5eXwaRltkuH8jvDbcxj5m4ajsVX7qA7N8uod6TIVyh_5Hvp1iRQHjtOC6_pI7hCnC_5B9mwaXsYPQqPiP-h7sv8CoG6KQ5UlE7_SkHXpfjEsI9RWETa8YPDTHek4k4bz0Y4VIIov_sBXsqLR3ZnNMdzsbCekfMqXtzgw6I1UqzzPVew4mA0J7qC3WHW6XK2a7sxnO4y-R4njEf7W6a8nEj4n6bwfKeozaQ_mvKVekVUR1ocjD94PYBzGb_DTpToeEz8f5RS6csXMWM1BORz2pF6N-mOH_H4g-0qGdIwh5rdRu2xcZX_VGR3_vVjvm2svnSvdKEsVn4cRcytt10iiDTPw-RQVW_DdkuXOK9CPN2WJDBtSkEEwLlNTHjRxPzamsnKB2fQe02suVPpU2dfF5qy4pKXLeKabT4Ky_Ih4Yb4ez6oy2fUknvKS2JKeorGk6lWrDGlyGX36IJO6fbDQogn5ba98E5IYWCKOknszOtT36QqAywyqja_dBRepAtI1YNN5DNNryH1AnF7d4q38l1O_PPbAXrk_taIAo225y-Cwsdp3f2hOINdAORsRa5GuFXeED1MOsFMpHX7C1atdGaZGi2ypZ6plvG70fxoVw9GLrWItUStCq5i8And6ZKXd815nI7yAW0lQv3RCBRqUuoWX5E3F8-bTv4aBlM4Q3gkh6_H2GhYYmRUwA8ASeCdEeOCw-kZ_wm742k99x2N65uBWLBe7T40zYWPGBafTxcPnBrcLw2xLlEIj2KeyZ7hYDhZdeoC5plS1Qxwxw2m53g8e8K_fOgELtMfB6mr32EdSjNqnx5WNZ7NNqq8ROj6vtfGK7y5cqC7ZkoKOkK6z9KO7pyDxZ9Mj221lQte7h7hzb676GiErrovAu2pCwWT9RVNUntK6mz2W7A97tjyKOz2VuLzhPBE_WAYyYSZ0Ykl4QKAU7cpmoaXNBs58YGm_H7cSOu3_4yEIuKh_O-pggiBfdxKKDiK3Mt7jeNV98-YCUlLmZEv5yWkjBsmm2LUEgX2w6DVUUUJwy5ongmXDktpViHLLMubj9PW5GGfJPsMuXEOfUTTL1C7wnMJzWzco4y11YmzRiSlCuKkPCMcT5_yhZvAZRyyrPUOBUftcOKUbBh4oBYIN3RbT1v4sMTjSGzYez52Sisb18InbQDM0zn0j88HRorWH6bxpKDb_PvmTebrhDIiWXbI3Zlm4NCQm7NZWicEFK-1fR46b5qRD80tp_cq8BWfECvvFfcT2NzO1rMhl6xIY5-TBWXIM6-qd1Pbd3xOdLRQPotxbZimS--dFBsLvrK3Ginax_mqc01AIXcjph23oQbQ9gnQzgtwicPafnQaOEcdR-moB9ca6oEShgymUyy_XcK6UdKpy4xI1yZsQ9omcquT_s8hzVrLEXwlwtUSzfqvH9pMCIjASWqMeRkfEojrjJd4th122hn2al7s2TbmPSXDOn0iHjh8N5aLcZbG_J9x6qwnpjMwDiGpU2Il3AlXuL0IaMFKukUbx_xKz4DoHsnJMMGsJfItAzyFbLPsPlVq3I97qwTZNUHqATjW3U9AO-PntTdK0OOSu3YbbJ2dk_A-SI1oK3O64Ie-u8rS2dFRmyUT_wYOcXL5cJ_-3HPz2xsO2SzRA7c8G-LsNCSSVSv9Vd5HBQhHA5IxsCptmFZ9OIkHFqeA5wcCYuhMHqSaC6kbPClyEExzaPsrJI6-SJUd86psoJn8dmn4I31WNf_5STzPBeii6qBYbLVIfiwXJckk0M-hvDeQfCyzRpKHeCslGkm6kziutEvfS0yZwZgDpBpGevyOcPCxYicpZSzUxEvsVCjtB9NBcIEHmm8Ho_JjiebQ3HcrchWFAYYU8XScsvkpfVqF71lut7ik7VOFcmQ3a35_zEA9kzYLKvmC49nyIMIkWDR5iCKW63rw2-6PzSTzSjf_xb_VADIYdat8a-i96mCbhtah6WH7Y5tTQKUYRWLUYib6kE8hwPy7jyHX0IMebioaklJKaU_G1tBYDsF4Q; __Secure-next-auth.session-token.1=12vFH4Zo9AA6uZzZrVWEaWBTWDlMDYiDUP5HUYoEOv3R3ksn-sPq93b2jISpNOW9RecN5E_5NXB76IfeH-VZauOwKzd4Kc37Mf6EM4gwXALfqMGsvFX8DlW6MkwbNqZ14WbE1pR_KhKVYrdB6ZX6J4ZlscRoqPB-A7GpvOtVPUComrZg00-evxSWcyKvLsCW1NNqqnXA-7J94rJJBdsS6j1c3s5KiCqB1Ptr1eTeWanjxkjNfSewVQqX6WVytsLnsVE9KqmJGZiz0zIFvnLPQwSv1Bg0IFzt8UF4J1PXrQaIbwIvqmNj7BU3589K2Rb58tarZoZ-ogxZG5ZneR1CWLSlRJDhsnOvAXubqD0EuT_POI7EXdrfsNiifr7knH_xxEu7iqxzpXsDMuaO_pxzwkPuKFtcxDkVOJH-TY5njugFS.Jodtt7brKicBj8c26v0T3A; _ga_ME15C3DGRL=GS1.1.1738463460.1.1.1738463490.0.0.0; _clck=1l7d1gy%7C2%7Cft3%7C0%7C1859; _clsk=1uwygz6%7C1738463492407%7C1%7C1%7Co.clarity.ms%2Fcollect; _uetsid=be5a5d90e10d11efbff71f781c6cba79; _uetvid=be5abc90e10d11ef9a96119e1652d011; AMP_7268c9db0f=JTdCJTIyZGV2aWNlSWQlMjIlM0ElMjI2ZTNiMzU3NC1lOThlLTQ2OWEtYWIzOS0xM2ZhM2M4NTdjNDglMjIlMkMlMjJ1c2VySWQlMjIlM0ElMjIyNzA0ZWQ4MC01YWExLTQ3YWUtOTRkYi0wNmQxZWZhODBjYTYlMjIlMkMlMjJzZXNzaW9uSWQlMjIlM0ExNzM4NDYzNDYxMjMzJTJDJTIyb3B0T3V0JTIyJTNBZmFsc2UlMkMlMjJsYXN0RXZlbnRUaW1lJTIyJTNBMTczODQ2MzUyMjQ1NSUyQyUyMmxhc3RFdmVudElkJTIyJTNBMTklMkMlMjJwYWdlQ291bnRlciUyMiUzQTMlN0Q="
    token = "__Host-next-auth.csrf-token=57a886df76b501a8467d75e3ea1c22afeac547c8d7a4ea3a54f4adb1f70a5953%7Cef1d0022dea0bdcd86790555817fc6c9862b563a388ea57c03ebfa073cdf2976; _gcl_au=1.1.643138976.1740644316; _ga=GA1.1.1825767211.1740644316; AMP_MKTG_7268c9db0f=JTdCJTdE; x-recraft-referral-code=xrTsvlkNBB; __Secure-next-auth.callback-url=https%3A%2F%2Fwww.recraft.ai%2Fprojects; __Secure-next-auth.session-token.0=eyJhbGciOiJkaXIiLCJlbmMiOiJBMjU2R0NNIn0..8f2HiURsmryfKBj5.eE15I7cyLAqMkb7m_0r2GhaiWdZlN9fq4hxdgZk88X5xxStF66xOFJqDZN3GGAWUwaA1ikliDDtkEBYVcVtx17hbcjDkw6DPKiPDwLzMZe-RNwJHliNWt3jAsW3UjtbPqaTyKTlOhiu5R70tKb4M8zD3v-nYeStZ_aQk36O22LTYURWddGoozjsDCwgIPnZ4gBCwK_DqOsK_TnTvZhshPaYWlwdvoxiH_WMiE1WGLlguSsXWnEaiXNcQlM5o4SpVeqfSqrv3uTapLagjHcZbx_fJtvruCW1ItXvyFNW89M1xdmaIodX8D_HKfsKZLyDknYkbLeXbVedLZm9zxfF7THlEavPKkihQkid7spBLxEl4uA4xX4-Wk19KXLiHAgbyj8eqRB8Md3Ru5qNwX4RUGRcLtSxMkyz-L2k11QtolHjeCSzCao0roh6nB3xDywKPiSorPcLKQ-OoErqu4VnW2YzLjngUfZiDo6MOEkAkbuF2vN_GV9cD2Lbskyu1dB8YTC0o0D3x1RJ544I3YfibP5FG6TNkXvYNBYisowyddpeQCuciaVyqjYDEFUosfN0Ro7hk8JN0Bcd3vgmEBbrJ2YovPTBnTqnf3FcX0YVtVqrpFWz3rJPM8u76g4UclwBSpV4BKsYrvrA1PlC11CGNgDADzmKr9F_kWRnya05SeZ5kZ8J6-BXfUKiRBKupUDK5A9qk7E6c5DzYxTvYsfXIlxubTs8PdR7dqSEoD1ZEsPglOvNWilz961vv6JEeWPFKx8kWfeeEE7EbgmriDcIzOwhdnUzsUlAQHAdk9w2SdZSAb17RuBm0--Ua58ChhCgpiiFl_P2cCrvRP7NuzqaD-2Jcs1yMC-YnYXbGzqQmOVlEwuAaszKwoirGbfQRIkHkrhCTFknHkcGu5iKzST0efJS-ymgOQSG9bBkpY237PDiC_Cfm-bOoSe0yGf3JQKwJvvY6Y1sruiEfTZqjawJ9RC0hPBluXzD8pnKm6qM1OlgI1J-tpzn8iG4E_b60eY4QeSwP8Xf7qodzAGhTtcLa4_vMffz0xH3jmEBzUCjNC4d0k8SFe9-2scg04AGFhFpQ9R__pNyte4I5OWYBm_6JBRFfSn8UrAAtoneyXbVts13MKieYZKwhYg2OoM1ggzVIjMqQntv0wQgsQhM9ecXYbOKj3C0IfsjC6IqhYCPmWHKvt-Kk0M13A2lSuym1NAwgV2CE3HvgYSDve17RP0AZpCIGrrtTacbDfIDA7stpYZSs852xr3BNhLo64Qnit6jU3yds02SxKlfAUBZvuEA8fViTObbGeylK5uS4nxpGOwFhiKp0oN3GH_VApw6jqPu5XnR8Zb7uXSgGQU23mJxuzVaOMPF92ZfXvirw2kQPUKo9y5sPCok-tqlh3YS6ed-WMBBO11Mnfahas4IoMvjceKfXJF9LlvoA4TZ43r2ZxfM1joI3cbxZGo7juJ_vbCh9858rY7ZYOdOl0ov9gRKPHoitH83zTP5FIKwcGSqkxwdFIkaeS7pkaNnC61nw6u_-eAKLpjt2z9yyyRTKVdihdfrTr_gkY9UUAPPp84R9UaYRYcviTsXQOx_TCAhFHb_CJMmvGmncb8pTQvxWiZnWiYlLd6CvFQDBqpYrjTs6WjPqVHNfejYJUdOWjv0soFdZngbos1BgPEw5umujqk0IOO3CyxJ6KHZDdbV-kKX1SgSdm5SLQ-DkQppx3AdeXiN1r0tvVzLguUJ8nS6MaoPYUZeSC4LYuAXcZf0LCbKIc8fmPdCDYq2ZDX9rYiAO7I9PoZdY9xLotBFlU6uYdVR8KvLemWEpnJq_08lMoOSNSkNY5Ofnr5A6BxEEmCYiBxU3zWRmUu2_KRq0oTODKBYYGktWsbzjCZKosgPNh2eD1FDw_r1S3dqE8kUWsxhrBptagB0v7ftvK2g1SH19W0Wda0lFsS-zLqAXYH2QLjzHci8rMyrSCsA8-bEB8gQd_q1uAhgiMP2wnObGoEzFCgIVIKJgylEaDE6RhNo4kO-wORl1_-AS0eDVohaTx_9_rVyvu-r82QsTJrjddUOKgr2D2rSoO0vOa-uy9jKSg9vAY5EOEeQww2_rCNmJfuaLGDIKMelWGr1H1Hd-dZ1BWncRFnRgduN5uRJWaMLCuDdAIqsv_k7xx0Zux9EkiFQwivEpRTHoEIzh1_a6i4zTua2uOCARGhFvScmkEnX0LBCjkbnK1H_0iJ7MWMVbIjq1YH07NxIbz0DV2bJ50Gavi87QAngRAAECOmL5oHuk-pNjSsMn7ZCguKozXivTNiaPHTSdOiTHzydPpX8vkvszoAEXcf3gadmiVROtpzz-nueExobACcU8Omlc1Vet_hlryV1P2OewpbnY9JAqZJfv5XYnKkGty_EQHMZepdJ2UAd7QIGixtM8ZeYjPth24dNH2oFR8lydTGVxCALzd4sgW3f8uPXmXxMZTTmO6j7GI2CWm6TLxQc4vIq_5NFu9jjIT2VLufzDCaevauZBP3li8w9difYCjVS5NGqE1JKLVmmrQTeiCd4rpsa2J6KOerCC7WdwjD3tRvYcOwz8u2i0_gP4RfKGuCeHJV3h5fa9Hp9HTPbVz1mhPjKQewhnuBvpX7ylL6fTFXj0DiKUR_oI8WIhxsNhGEvIxeitEwFIdpBhS1zkyp_9JYwu1BfFgnRFweNl15Zx_yLAQj4oVkN15RNOVgKsVkn0S9jaMT_L7vbzFkxdxYgtPyla95xS823hpQ0v5LbaoFDY-NKL7sXiRG_Bc1ujmnNcYysoL5DAWXfUnBf9Wh_DDqUFwpjaBRAuAGYEPz3BEXFJ60Hspax2OE_RKIw-mFACf4X0REqeeTy0AHvDqZ_fznRTH2bUCSuEPTXszr886FIGTe8mwmEgjRJfGvFuQmeABijIMTOYBDrcRD0vmjFrM-XG1cPckvrkmIND5szQQwCEw_QIXdH2KRfoBsWAH5rQUCnVGMftu4SWhiy6vL0Q1gEVFUk3GGxUaugSDgQKbibY7IYxXatqvdUISgYL5lmPGS6dYIN7mtjHdVDpt-4yG56ZbeVabhVzNxTlYZ5udm7eakwyMOog0nv2iGyWEP1f0kV1Q9VGA_r1f0zTioT1v_85nd4VVs8zM9jufuJdZhv4_OMrfzu9A9lOXAokKM2aQc5MWdhwyTsmBSaAt-73lp-UAtpyRrFY_4Ljqg5AQzYoIr8R2PHz9Xwe-h0_7Bt82NHYJhpJo8pwwUA9gneQsrK6y8RFLEYfp0_gEg_U0vdrw_hZaXQtaSJgHMSjdniPS0ubvbvrpWXNzy1SvclMYPEJS8KwfJ9rSgsfUqobaVFaZ6nwmo6-c2Cm4IZ2PmxPs8bOtgi_JeHLrG8fD1OP36_HHNlWA9_nxXpnQbwCiL6XJrBl1n6unEpsKtTSq4SOrLAhGsGP0fK9Y2IRvLAUpq1qgwGFVnSPUHmnIuQ7AIe5GzCXs_c7tdz1y0kJ-z2o1ZdIoBPlG8-p_CEb4iPHbMfR4_i00Bfox7HK--ajFgqKgxDhDp53wziW4MGaRYLfKiR9IGzMoMGj-wCqlWtasFqsbe2qWlmSaJGR6TtyWqb28D1H5WO44Z__DxwNcxCKsHi5nhgPTACObFrt02QAkcoxeQg6MRoQ2aJN9CnpstpIVuIcDk4wa0Ay1_l6FIKgJ5nucZaiLehrSiQQrK0LI_oIzEd2XDlao2Dx9vKEx65rTXYQ0KH1DPTkBynZbMY2uffOhYrC1YHZm4H4VPQ3hSJP9sQIcam7MrQADQLIXLO1ESYmEW4CUPQ7v9Z_yyDFfpudD_TkwJfhCpstNPB1Zqcuvm-Kwjk1rIUIVKmVsf8UebzbrQ5ACAWlrjGmuHlSnIeD-6c; __Secure-next-auth.session-token.1=nWFZ4KrnoE0thoRpHK7gAozIJCt3l7M8VkzPxSypdlUUPewpPu0mS6YMouSZhgu7i2M6jB2-fTwSmK0r7mLKUyzJsBHaQsmm7_ELVEPX5Wm1704a2ktPIAU9JTDfOC5kQzR6XFiO8PCyBOBIlJGJ4mz3qtLCYq48g8_ZYwdcLTcaQlDUuG0s5NF2CmC-7yHfIbePvYRTQL8I5bSwDjLKUl2geru6mURBhYNE6gvBLJfD6P7J1qT6gHZqeUqOtEgDG9dBIQPbyvgp7wdL0oqT7DHqsY2Ap0jFGspzCXzVri5AOHJ-JL9gf1cnz8AOBlqDVZyqvwLwDLHK5GrNBknSfHajQuI47imwmSOLJ_J_DLMzHivmvZeps4xYgdV6hSzKVLbOoqxOZEjaexqgOqVQ7fSphBPfhUWOd55opsEURinGY.4EDW8XkvsgX7oYL2QJIQsw; _clck=x6jacq%7C2%7Cfts%7C0%7C1884; _clsk=10ppugy%7C1740644423156%7C2%7C1%7Cj.clarity.ms%2Fcollect; _uetsid=711f1780f4e311efabc199bd18469bf3; _uetvid=711f3de0f4e311efaab61f90155799d0; AMP_7268c9db0f=JTdCJTIyZGV2aWNlSWQlMjIlM0ElMjJjMDBkNTMwZS05ODBmLTRiYTEtOWM5Yy03OTI1Yjk1YmNmMTklMjIlMkMlMjJ1c2VySWQlMjIlM0ElMjI3MGFjZDNhZS1lOTc0LTQ0NzktOWFiMy1mOTVjZjhmMDliMzAlMjIlMkMlMjJzZXNzaW9uSWQlMjIlM0ExNzQwNjQ0MzE2MzcxJTJDJTIyb3B0T3V0JTIyJTNBZmFsc2UlMkMlMjJsYXN0RXZlbnRUaW1lJTIyJTNBMTc0MDY0NDUxNzg4OCUyQyUyMmxhc3RFdmVudElkJTIyJTNBMjAlMkMlMjJwYWdlQ291bnRlciUyMiUzQTUlN0Q=; _ga_ME15C3DGRL=GS1.1.1740644316.1.1.1740644518.0.0.0"
    token = "_ga=GA1.1.435165527.1730362257; _fbp=fb.1.1730362257600.714008794112161913; AMP_MKTG_7268c9db0f=JTdCJTdE; _tt_enable_cookie=1; _pin_unauth=dWlkPU0yWmxPR1JsWkRJdE5qZGlZeTAwTWpNeUxXRmpNVEV0TlRrd1l6RTNZelEwTldZMw; __zlcmid=1OVn8OoYVNvKEWM; _ga_ME15C3DGRL=deleted; _ttp=412qSInHGw3jjdyNR6K4tBIYmNZ.tt.1; _ga_ME15C3DGRL=deleted; _uetvid=a8a766f0975f11ef9b7921e48a0cd258; _clck=uflztg%7C2%7Cfui%7C0%7C1765; cookie-consent-accepted=true; _gcl_au=1.1.772477802.1746667247.1156078987.1750674190.1750674262; R_DEVICE_ID=6915c253-c12c-4986-b376-1127cff11e28; __Host-next-auth.csrf-token=510b864a6b732433642c2c0fbf2ee4794f1f62dd9847afcf056c4b9aeb9887eb%7Cd83b49015ad5f6439fc3b90bda955f748c56814a82810bc82693fd39a0fd283c; R_DEVICE_ID=6915c253-c12c-4986-b376-1127cff11e28; __Secure-next-auth.callback-url=https%3A%2F%2Fwww.recraft.ai%2Fprojects; _ga_ME15C3DGRL=GS2.1.s1752460127$o91$g1$t1752460157$j30$l0$h0; AMP_7268c9db0f=JTdCJTIyZGV2aWNlSWQlMjIlM0ElMjI2OTE1YzI1My1jMTJjLTQ5ODYtYjM3Ni0xMTI3Y2ZmMTFlMjglMjIlMkMlMjJ1c2VySWQlMjIlM0ElMjI0MDQ5YWRmMi0yNWQ0LTRkNmUtYTFkMy01YmY3NmI3NDMwZDElMjIlMkMlMjJzZXNzaW9uSWQlMjIlM0ExNzUyNDYwMTI3NjIxJTJDJTIyb3B0T3V0JTIyJTNBZmFsc2UlMkMlMjJsYXN0RXZlbnRUaW1lJTIyJTNBMTc1MjQ2MDE1Nzk5MiUyQyUyMmxhc3RFdmVudElkJTIyJTNBMiUyQyUyMnBhZ2VDb3VudGVyJTIyJTNBMSU3RA==; __Secure-next-auth.session-token.0=eyJhbGciOiJkaXIiLCJlbmMiOiJBMjU2R0NNIn0..lhJ8wTCSS4SLeRAi.rJxgSxxBLu153hNI30lrEvj0D1zbPzc02FNYpPcYPyILmvoygyOXybQguB7Nd2jvQru0H_H2WY7nFYvQLsE_HFLcMytsrrPBV_qfk1nEutFtmUzQUn92LR1cjQw3sU4AQfF37thp-GYij4uaweD58Daep4aZG-Q0hO3f5y6BJZzwe7rr7Z_SGUy96k0oVpplbOG8RMi7UB8yFSxHBtQUVZDisLyWYOgRSoqanPlkU2w-5L3682BNBkzf7JNKe9KGW7pS-pATkNyY5PVh4d_N1x2GW_bEVN0vYpNLtxMjEDGdna4wiTDIINyfMLbWOhDG2hqciViI9MvO0j5sq_3cNUHslsLCX_b-X08K5YdR2Ba-tH31Pquj0qxAl2sZLmPvSHxupqxitHGRDHu5UIKu4SGImQfCrs3m4O0J6jIukbrZtJFVGcCX_f17_xwKuQsV3QILmrjCDOIWW55W2Cc--DpuhLSzmfofe3gUbOLWRIHPUD4G4j5A0md0fJQXDF4lFazxrRJYqbOam9BoJI9cQ4uFskLqBbPG-ofoCfISvDy2gku1Pq0iLPWqm4Q84Gayw5Q02Ur2HX0RXFdtOH8o1mmGrNFIJQxUaLjEZsBQ5aukPKB_9JRVVaqG6DKo2QhI6nXVEjfHXmhleteNgq0Gi8jBulk9JkVd23a6UWOrqf5o7S0oRA65E-feRerhppjixxPa8ejQY6M2AiKMGax7Dx0kLZZlt3DczHTqTmIylVgv2dT_aNV2HDU5JdHzNNBoNedp9LZK24F3XegRnbKt36IvaxP9D6G2OTy3KS1qe9GzMPxytehQkanywHqKQ44ujAbQ4QBgvXn8547gOsJCFXXRYt3uXpp49AAXj37k1pXGMtz-5UmwLPeT0SRSzPchaoQUua7zYCZBK-26h2ruPm8u75bEks1jrxW5nBH1y5hKcBcKMN9gPC_8svG4lXCMjr9J-m29DTjcfgYVaXV92-ePZcKBpwAMsnM9GdG2pjerWdLwUTxAUaJ0awyCwveALnQ91kO694JWmdEQ0tdYp90Yq9AQk2OdsHsf9SuM4ZuYvqmP2HKkzEzyYhJ1Lvct_ctSwvK2V1Gf-7tuWtNCAWnhf_FWjluHUN5FdIICUw7styR6z_9FoQjZSdq_DZBe4-dyIdvwGbpHTuAFXsT5nI5edpgq3ariE-0iccdEg1x0NtNY4bTnpEh8qpy8OLABPllIiLsvxf5XPx0CnQ19VliMyLRer18MIDMtUcVfUwcb2irKXPj1nk4ma3ZFataOAqx59cxjFG-l6BKNWglVH_fiCquvuZ7zvPq2VyqtCJtIGnZekh7gEMOYDP50BMNaUmErP0LOyW5cWsKOYI52QAsFw2nO4HhqItNzveCtqYbUvzA7CT09pKazunika4yxudgjZz6xlKvt6Iy7Z-cP4xr5CdOlc82YprgWhH4Pk2D0CZYbfyL0ue64V2CzAOXcaJpK4GoNH1MFFQxiRFbNTxMdldOyzsmIm7-VILcTUJKDi51FiCh3p5kNcaHgyJ_Sy3OtHaTGH0DQAbRitqk7LsZ8a4sYIHYARKZTVJ9lVGlpEXOl7m2lrB7geM2HqqjiUqbFDU8xwp53Oyb4bfjIUVOPJ6rWnUndWuyYNEImvRVGynpFcib89ke9JuvDDh2w6YtQ7XnZnHFjXHfGZR6xcEAD5J1F5N2dEKJNy3_63YmwkvPgz_oFNUNJgt2MBS6N1OrXjap9azsvR7s4iHwG_wEtl7iORT4VxOu8gggt9T7uYtZFjVaJHqTcZ7cXmpjbUuV2Y0aJ15cdwbR2ZgWZ2wT88hPNzyPeogooB1MQqd2Q1H9JGkq9NibQQxPG3QsDu3SiA11CsNs0baBRivjO4iWHpxJdJ28hnmFiw4dMcGfGEuvYKdCOsWGMuZSVX3Znt0c5DHevkMHJetKSMnOZSkQKJQ1fucyPmpTd9Yg1Jj2qRSgEvqAStT1PIh2hMjqBwMDhvActZRSmiQ699gBoJGN8JY2YfDSomU6dtEFxTl9y5TjC6e7AhcpBvKcWac3a29zJuRImi9yQ2vnL5x7xIW40tDScTaUc3qAuysg5G3HYzI_2vYXdnWXpirqBd1-idA1PRGT-j-0jBHQhlu-Llg871Qy9uXY0mJA66S2ReCEpn3_ikZuhPFoSVycEjVQAOGDOwddATCKEtdyYrywjfEguA6meB_dQU1Xg33qqiEAp7nhM2Ek9El9KgBEGbx1Dy0QsilevM9N6DQ3UBr0dM55sPZbefL1awB_U4T7WGxoK3X-3BEIJj8bz6XrdXF7jKrZfaCvwbBlgSwKA4aydBcjH2P0KGF_1gAVgnRRcOCeC3JMSX5Of6rdfp4KK1EAwwu4VUfiFfEKB3ueHL_GQs_VDdN9CDWE0mEmMnyskXGlw8toX_p37z7Z42r6N0jKpkeY6OAkE6H85MvDiTUi09pDpgpB8FLkQ8q3sfcUS9zSV8iWHFE81IPmQ0NB7iHd-iL7lshbGg6q_fn9Nw-s4bzRHssSmaoFEBlZ3pqecbWYYj9Xr0z4oItysfVMnHQ7w-29uAGpsSPhWzIjJjVxCJkJuIPJNsoY9F75rTU_XamrNcqYUs-3BM5k8HaNmqTgxPskMltJeT8Cv-byB1NdderCiV7vvd7pOsPTB_OG6ettwbpGhbjMeadftpi740nYb1PXbGu5QqQ192h9fBXFu-J5d_PIAGnz9NZcscbAFcvqx7LfxkhA4B_MZ9kJZMefEHgEmY4i6u6VHuLRX4Zbnt3j5Nx94Wpid5_lXx_F7ySrgxADPQHpSuWVSLm5FLF4STkExEygRGw6_kCZbUk3i701KmJdQXb-rH01PM3brtZr-g_M4NevUjGjFzVIFtUm2L-S3eT-r3fvqwIdCW128Bzbtx4jqUXevcHYWNJ_MobwmRgkhYBHxJ5hebGalSSeHth35gLd_IL1ODCsJCRGqMh6eVSHmly62Ct4mDmsO_AjaX5Px5Ltm1uQiX-oA3kMYqD9bUv3B-6km4sWtHIPLxasDemlKJpHN3_oy9JIMh3uexT6g1LUXsW8w2WsNWtd41Jn9onDAiRlb7cZERbXDYYcQeLvX3U1J8t9Jjp2mqICGri1Q3A4A0RhJBARx4aJYRHkIewUBofEJuTIegKQhw_jCoIvx6EyKGA4PDXtslLZp5wAvTDgLMWQ3YMRwPvnV8IK3bTqNI33WXQHH6eI3PMimutPUPXgio1FppnRnzoF_uuvcdys8h6KwDnx92N4niR2f6L5QOoOSbn3favnKc_cejeBz3MzvB7RZ-p8YTmMwW5SBGdSIfHmmtnfIlz-KhZI-v2dZaT4-UjaA2t63VdPtakuCcNpglw5vwwJyfuG-khPxHU6sqYbKYNfvZ3RWmJj26_CzapXdoQvjXJehOj0Ufo7YDE18ed9Fh2lHOZjBUSplC5j1NxaXaL-v-ClR9UFhQi1OiRJMgLCwp_HGdZeF49RLiDnJ4qDwgrgNFLYH5mXjvpl4nuVJIisOlD5mYpECQ_28vMbt_fCWjLW0N5Gpdgyq1LYUcz4xCgid_1GYnC_m-mwJEdAH4jqcmTfZ26MPiCvJfdBwPYpXln5VwFdinC83UFTZiV_iiaYyEXGemdZvEI-oS7OCXnFFYUn5icqwA43MNTsnTEWpCGfrs8GNJTkk9u-Gqaa0z7QYgknuw95NQhVS4WtW8AzWhlYUUemlWk_f4s1rNx4TbZc1W2IdV917bIT8QXuwoHXzbZiOOqgOXTtC4T4u4CCRyAP4XCrlve4OD-PEel71hbzEOsiUDwebv3GAq133XOkUhCBJhbMQig2PRK1o0pbuNJwjb7gPUNoW4g-l3jNPCE_J8Dn649xBMcrOd7I; __Secure-next-auth.session-token.1=gHRIDKSNzXK6mnBiL4Fz4KIPN6TpSeks-bjD0O5H1aSMXo0xdBgI75yeAV1LSc0w8MPxoSbmlClgwodyfuZ8-SehrbWaV--3TXaL9QO--UwAz4jmZX2SASooOY2x4yseRjXTmVqJ4ewohOTKqaO76z7W2EK51h9naryyS2olV-TzDOPs4CVCcF93EokXurYRMfu8iozt8GzZzwb3rWsiiQYfygFqKfuUeR1BpmyZymLJpM6F2G9dRUv17d9E2BMXJrGNL1nHEUpPGaKb-2jNSMgE5D5NyIZ1y7aDyW3V5oSDnC3o2CdlIjY9KqxlarvJqV1D3KVV7h57qRIdZ9HJ70BMTAIsITE3vgIRiGn1IWm8Wyd8fSkyIfj7hVyE4mdILmtu_aq3oSrdywsmzEFGovSGeKXjbs68AzNqnw_Va1sAXmxqKXMLrUKhWWf2jsqgEW3nndREHApw9K2TlgXdqyrR0jwUFXipqx5glM_raSUusHmFjIch8FO68m-SHXlcFJznQtX0hxO_ElGM7RIEgQ4VU7cN3XDETU1Uij-kPCYOhKJSqqpbd8CnYbnOKtB6DQmBYb-q-tWSxDDc-N-nMSg.I0uqyMPLHILf3zzHiAQ0Zw"
    # arun(get_access_token())
    data = {
        "model": "recraftv3",
        "prompt": "Draw an astronaut | Style: any (recraft-v3)",
        "style": "any",
        "response_format": "url",
        "size": "1024x1792",
        "n": 1,
    }
    request = RecraftImageRequest(
        # prompt='一条猫',
        **data
    )
    # token = None
    # with timer():
    #     arun(generate(request, token=token))

    # with timer():
    #     arun(edit_image("https://oss.ffire.cc/files/kling_watermark.png"))
    tokens = [token]
    # tokens = list(arun(aget_spreadsheet_values(feishu_url=FEISHU_URL, to_dataframe=True))[0]) | xfilter_
    r = arun(check_token(tokens))
