# generated by datamodel-codegen:
#   filename:  types.json
#   timestamp: 2025-03-12T12:59:26+00:00

from __future__ import annotations

from typing import Annotated, Any, Union, Dict, List, Literal, Optional

from pydantic import BaseModel, ConfigDict, Field, RootModel


class Model(RootModel[Any]):
    root: Any


class Rect(BaseModel):
    """
    The rectangle coordinates of the highlight
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    top: Annotated[float, Field(title='top')]
    """
    Top position of the highlight (relative to the page)
    """
    left: Annotated[float, Field(title='left')]
    """
    Left position of the highlight (relative to the page)
    """
    width: Annotated[float, Field(title='width')]
    """
    Width of the highlight (relative to the page width)
    """
    height: Annotated[float, Field(title='height')]
    """
    Height of the highlight (relative to the page height)
    """


class PDFHighlight(BaseModel):
    """
    Represents a highlight annotation in a PDF document.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    page: Annotated[int, Field(ge=1, title='page')]
    """
    The page number where the highlight appears. Page numbers are 1-based.
    """
    rect: Annotated[Rect, Field(title='rect')]
    """
    The rectangle coordinates of the highlight
    """


class UUID(RootModel[str]):
    root: Annotated[str, Field(pattern='^.*-.*-.*-.*-.*$', title='UUID')]
    """
    A UUID string in the format "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx".
    Used as unique identifiers for messages, sources, and other entities in the system.
    """


class Message(BaseModel):
    """
    Represents a chat message in the conversation.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[str, Field(title='id')]
    role: Annotated[Literal['assistant', 'user'], Field(title='role')]
    content: Annotated[str, Field(title='content')]


class Source(BaseModel):
    """
    Represents a source of information that can be displayed and referenced.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[str, Field(title='id')]
    title: Annotated[str, Field(title='title')]
    """
    Title of the source displayed in the SourcesDisplay component.
    """
    type: Annotated[Literal['html', 'markdown', 'pdf', 'text'], Field(title='type')]
    """
    Type of the source, used to determine the type of data to display in the ContentDisplay component.
    """
    description: Annotated[Optional[str], Field(title='description')] = None
    """
    Description of the source displayed in the SourcesDisplay component if provided.
    """
    relevance: Annotated[Optional[float], Field(ge=0.0, le=1.0, title='relevance')] = (
        None
    )
    """
    Relevance score of the source. It is displayed in the SourcesDisplay component as bar chart.
    Should be a value between 0 and 1.
    """
    href: Annotated[Optional[str], Field(title='href')] = None
    """
    Optional href to display a link to the source in the SourcesDisplay component.
    """
    data: Annotated[Optional[Union[str, bytes]], Field(title='data')] = None
    """
    Optional data to display in the ContentDisplay component. This can be set initially
    or lazily loaded when the `SET_SELECTED_SOURCE` action is handled. Simply return the data 
    from your `onAction()` function as `sourceData` in the response.

    For PDF sources, this should be a Uint8Array containing the binary PDF data.
    For text, markdown, and HTML sources, this should be a string.
    """
    metadata: Annotated[Optional[Dict[str, Any]], Field(title='metadata')] = None
    """
    Optional metadata associated with the source.

    If type='pdf', you can set the 'page' and '_page' properties to specify the page number to display in the SourcesDisplay component.
    Properties with a leading underscore (e.g., '_page') are hidden from display in the UI.
    """
    highlights: Annotated[Optional[List[PDFHighlight]], Field(title='highlights')] = (
        None
    )
    """
    Highlight annotations in the PDF document. Only applicable for PDF sources.
    These highlights will be visually displayed in the PDF viewer.
    """


class StreamChunk(BaseModel):
    """
    Represents a chunk of streamed content.
    Used for streaming responses from the assistant in real-time.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    content: Annotated[Optional[str], Field(title='content')] = None
    sources: Annotated[Optional[List[Source]], Field(title='sources')] = None
    done: Annotated[Optional[bool], Field(title='done')] = None
