# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: cosmos/app/v1alpha1/config.proto, cosmos/app/v1alpha1/module.proto, cosmos/app/v1alpha1/query.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class ModuleDescriptor(betterproto.Message):
    """ModuleDescriptor describes an app module."""

    go_import: str = betterproto.string_field(1)
    """
    go_import names the package that should be imported by an app to load the
    module in the runtime module registry. It is required to make debugging of
    configuration errors easier for users.
    """

    use_package: List["PackageReference"] = betterproto.message_field(2)
    """
    use_package refers to a protobuf package that this module uses and exposes
    to the world. In an app, only one module should "use" or own a single
    protobuf package. It is assumed that the module uses all of the .proto
    files in a single package.
    """

    can_migrate_from: List["MigrateFromInfo"] = betterproto.message_field(3)
    """
    can_migrate_from defines which module versions this module can migrate
    state from. The framework will check that one module version is able to
    migrate from a previous module version before attempting to update its
    config. It is assumed that modules can transitively migrate from earlier
    versions. For instance if v3 declares it can migrate from v2, and v2
    declares it can migrate from v1, the framework knows how to migrate from v1
    to v3, assuming all 3 module versions are registered at runtime.
    """


@dataclass(eq=False, repr=False)
class PackageReference(betterproto.Message):
    """
    PackageReference is a reference to a protobuf package used by a module.
    """

    name: str = betterproto.string_field(1)
    """name is the fully-qualified name of the package."""

    revision: int = betterproto.uint32_field(2)
    """
    revision is the optional revision of the package that is being used.
    Protobuf packages used in Cosmos should generally have a major version as
    the last part of the package name, ex. foo.bar.baz.v1. The revision of a
    package can be thought of as the minor version of a package which has
    additional backwards compatible definitions that weren't present in a
    previous version. A package should indicate its revision with a source code
    comment above the package declaration in one of its files containing the
    text "Revision N" where N is an integer revision. All packages start at
    revision 0 the first time they are released in a module. When a new version
    of a module is released and items are added to existing .proto files, these
    definitions should contain comments of the form "Since: Revision N" where N
    is an integer revision. When the module runtime starts up, it will check
    the pinned proto image and panic if there are runtime protobuf definitions
    that are not in the pinned descriptor which do not have a "Since Revision
    N" comment or have a "Since Revision N" comment where N is <= to the
    revision specified here. This indicates that the protobuf files have been
    updated, but the pinned file descriptor hasn't. If there are items in the
    pinned file descriptor with a revision greater than the value indicated
    here, this will also cause a panic as it may mean that the pinned
    descriptor for a legacy module has been improperly updated or that there is
    some other versioning discrepancy. Runtime protobuf definitions will also
    be checked for compatibility with pinned file descriptors to make sure
    there are no incompatible changes. This behavior ensures that: * pinned
    proto images are up-to-date * protobuf files are carefully annotated with
    revision comments which   are important good client UX * protobuf files are
    changed in backwards and forwards compatible ways
    """


@dataclass(eq=False, repr=False)
class MigrateFromInfo(betterproto.Message):
    """
    MigrateFromInfo is information on a module version that a newer module can
    migrate from.
    """

    module: str = betterproto.string_field(1)
    """
    module is the fully-qualified protobuf name of the module config object for
    the previous module version, ex: "cosmos.group.module.v1.Module".
    """


@dataclass(eq=False, repr=False)
class Config(betterproto.Message):
    """
    Config represents the configuration for a Cosmos SDK ABCI app. It is
    intended that all state machine logic including the version of baseapp and
    tx handlers (and possibly even Tendermint) that an app needs can be
    described in a config object. For compatibility, the framework should allow
    a mixture of declarative and imperative app wiring, however, apps that
    strive for the maximum ease of maintainability should be able to describe
    their state machine with a config object alone.
    """

    modules: List["ModuleConfig"] = betterproto.message_field(1)
    """modules are the module configurations for the app."""

    golang_bindings: List["GolangBinding"] = betterproto.message_field(2)
    """
    golang_bindings specifies explicit interface to implementation type
    bindings which depinject uses to resolve interface inputs to provider
    functions.  The scope of this field's configuration is global (not module
    specific).
    """


@dataclass(eq=False, repr=False)
class ModuleConfig(betterproto.Message):
    """ModuleConfig is a module configuration for an app."""

    name: str = betterproto.string_field(1)
    """
    name is the unique name of the module within the app. It should be a name
    that persists between different versions of a module so that modules can be
    smoothly upgraded to new versions. For example, for the module
    cosmos.bank.module.v1.Module, we may chose to simply name the module "bank"
    in the app. When we upgrade to cosmos.bank.module.v2.Module, the app-
    specific name "bank" stays the same and the framework knows that the v2
    module should receive all the same state that the v1 module had. Note:
    modules should provide info on which versions they can migrate from in the
    ModuleDescriptor.can_migration_from field.
    """

    config: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)
    """
    config is the config object for the module. Module config messages should
    define a ModuleDescriptor using the cosmos.app.v1alpha1.is_module
    extension.
    """

    golang_bindings: List["GolangBinding"] = betterproto.message_field(3)
    """
    golang_bindings specifies explicit interface to implementation type
    bindings which depinject uses to resolve interface inputs to provider
    functions.  The scope of this field's configuration is module specific.
    """


@dataclass(eq=False, repr=False)
class GolangBinding(betterproto.Message):
    """
    GolangBinding is an explicit interface type to implementing type binding
    for dependency injection.
    """

    interface_type: str = betterproto.string_field(1)
    """
    interface_type is the interface type which will be bound to a specific
    implementation type
    """

    implementation: str = betterproto.string_field(2)
    """
    implementation is the implementing type which will be supplied when an
    input of type interface is requested
    """


@dataclass(eq=False, repr=False)
class QueryConfigRequest(betterproto.Message):
    """QueryConfigRequest is the Query/Config request type."""

    pass


@dataclass(eq=False, repr=False)
class QueryConfigResponse(betterproto.Message):
    """QueryConfigRequest is the Query/Config response type."""

    config: "Config" = betterproto.message_field(1)
    """config is the current app config."""


class QueryStub(betterproto.ServiceStub):
    async def config(
        self,
        query_config_request: "QueryConfigRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryConfigResponse":
        return await self._unary_unary(
            "/cosmos.app.v1alpha1.Query/Config",
            query_config_request,
            QueryConfigResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class QueryBase(ServiceBase):

    async def config(
        self, query_config_request: "QueryConfigRequest"
    ) -> "QueryConfigResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_config(
        self, stream: "grpclib.server.Stream[QueryConfigRequest, QueryConfigResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.config(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/cosmos.app.v1alpha1.Query/Config": grpclib.const.Handler(
                self.__rpc_config,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryConfigRequest,
                QueryConfigResponse,
            ),
        }
