# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: ibc/core/channel/v1/channel.proto, ibc/core/channel/v1/channel_upgrade.proto, ibc/core/channel/v1/genesis.proto, ibc/core/channel/v1/query.proto, ibc/core/channel/v1/tx.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from .....cosmos.base.query import v1beta1 as ____cosmos_base_query_v1_beta1__
from ...client import v1 as __client_v1__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class State(betterproto.Enum):
    """
    State defines if a channel is in one of the following states: CLOSED, INIT,
    TRYOPEN, OPEN, FLUSHING, FLUSHCOMPLETE or UNINITIALIZED.
    """

    STATE_UNINITIALIZED_UNSPECIFIED = 0
    """Default State"""

    STATE_INIT = 1
    """A channel has just started the opening handshake."""

    STATE_TRYOPEN = 2
    """
    A channel has acknowledged the handshake step on the counterparty chain.
    """

    STATE_OPEN = 3
    """
    A channel has completed the handshake. Open channels are ready to send and
    receive packets.
    """

    STATE_CLOSED = 4
    """
    A channel has been closed and can no longer be used to send or receive
    packets.
    """

    STATE_FLUSHING = 5
    """
    A channel has just accepted the upgrade handshake attempt and is flushing
    in-flight packets.
    """

    STATE_FLUSHCOMPLETE = 6
    """A channel has just completed flushing any in-flight packets."""


class Order(betterproto.Enum):
    """Order defines if a channel is ORDERED or UNORDERED"""

    ORDER_NONE_UNSPECIFIED = 0
    """zero-value for channel ordering"""

    ORDER_UNORDERED = 1
    """
    packets can be delivered in any order, which may differ from the order in
    which they were sent.
    """

    ORDER_ORDERED = 2
    """packets are delivered exactly in the order which they were sent"""


class ResponseResultType(betterproto.Enum):
    """
    ResponseResultType defines the possible outcomes of the execution of a
    message
    """

    RESPONSE_RESULT_TYPE_UNSPECIFIED = 0
    """Default zero value enumeration"""

    RESPONSE_RESULT_TYPE_NOOP = 1
    """
    The message did not call the IBC application callbacks (because, for
    example, the packet had already been relayed)
    """

    RESPONSE_RESULT_TYPE_SUCCESS = 2
    """The message was executed successfully"""

    RESPONSE_RESULT_TYPE_FAILURE = 3
    """The message was executed unsuccessfully"""


@dataclass(eq=False, repr=False)
class Channel(betterproto.Message):
    """
    Channel defines pipeline for exactly-once packet delivery between specific
    modules on separate blockchains, which has at least one end capable of
    sending packets and one end capable of receiving packets.
    """

    state: "State" = betterproto.enum_field(1)
    """current state of the channel end"""

    ordering: "Order" = betterproto.enum_field(2)
    """whether the channel is ordered or unordered"""

    counterparty: "Counterparty" = betterproto.message_field(3)
    """counterparty channel end"""

    connection_hops: List[str] = betterproto.string_field(4)
    """
    list of connection identifiers, in order, along which packets sent on this
    channel will travel
    """

    version: str = betterproto.string_field(5)
    """opaque channel version, which is agreed upon during the handshake"""

    upgrade_sequence: int = betterproto.uint64_field(6)
    """
    upgrade sequence indicates the latest upgrade attempt performed by this
    channel the value of 0 indicates the channel has never been upgraded
    """


@dataclass(eq=False, repr=False)
class IdentifiedChannel(betterproto.Message):
    """
    IdentifiedChannel defines a channel with additional port and channel
    identifier fields.
    """

    state: "State" = betterproto.enum_field(1)
    """current state of the channel end"""

    ordering: "Order" = betterproto.enum_field(2)
    """whether the channel is ordered or unordered"""

    counterparty: "Counterparty" = betterproto.message_field(3)
    """counterparty channel end"""

    connection_hops: List[str] = betterproto.string_field(4)
    """
    list of connection identifiers, in order, along which packets sent on this
    channel will travel
    """

    version: str = betterproto.string_field(5)
    """opaque channel version, which is agreed upon during the handshake"""

    port_id: str = betterproto.string_field(6)
    """port identifier"""

    channel_id: str = betterproto.string_field(7)
    """channel identifier"""

    upgrade_sequence: int = betterproto.uint64_field(8)
    """
    upgrade sequence indicates the latest upgrade attempt performed by this
    channel the value of 0 indicates the channel has never been upgraded
    """


@dataclass(eq=False, repr=False)
class Counterparty(betterproto.Message):
    """Counterparty defines a channel end counterparty"""

    port_id: str = betterproto.string_field(1)
    """
    port on the counterparty chain which owns the other end of the channel.
    """

    channel_id: str = betterproto.string_field(2)
    """channel end on the counterparty chain"""


@dataclass(eq=False, repr=False)
class Packet(betterproto.Message):
    """
    Packet defines a type that carries data across different chains through IBC
    """

    sequence: int = betterproto.uint64_field(1)
    """
    number corresponds to the order of sends and receives, where a Packet with
    an earlier sequence number must be sent and received before a Packet with a
    later sequence number.
    """

    source_port: str = betterproto.string_field(2)
    """identifies the port on the sending chain."""

    source_channel: str = betterproto.string_field(3)
    """identifies the channel end on the sending chain."""

    destination_port: str = betterproto.string_field(4)
    """identifies the port on the receiving chain."""

    destination_channel: str = betterproto.string_field(5)
    """identifies the channel end on the receiving chain."""

    data: bytes = betterproto.bytes_field(6)
    """actual opaque bytes transferred directly to the application module"""

    timeout_height: "__client_v1__.Height" = betterproto.message_field(7)
    """block height after which the packet times out"""

    timeout_timestamp: int = betterproto.uint64_field(8)
    """block timestamp (in nanoseconds) after which the packet times out"""


@dataclass(eq=False, repr=False)
class PacketState(betterproto.Message):
    """
    PacketState defines the generic type necessary to retrieve and store packet
    commitments, acknowledgements, and receipts. Caller is responsible for
    knowing the context necessary to interpret this state as a commitment,
    acknowledgement, or a receipt.
    """

    port_id: str = betterproto.string_field(1)
    """channel port identifier."""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier."""

    sequence: int = betterproto.uint64_field(3)
    """packet sequence."""

    data: bytes = betterproto.bytes_field(4)
    """embedded data that represents packet state."""


@dataclass(eq=False, repr=False)
class PacketId(betterproto.Message):
    """
    PacketId is an identifer for a unique Packet Source chains refer to packets
    by source port/channel Destination chains refer to packets by destination
    port/channel
    """

    port_id: str = betterproto.string_field(1)
    """channel port identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""

    sequence: int = betterproto.uint64_field(3)
    """packet sequence"""


@dataclass(eq=False, repr=False)
class Acknowledgement(betterproto.Message):
    """
    Acknowledgement is the recommended acknowledgement format to be used by
    app-specific protocols. NOTE: The field numbers 21 and 22 were explicitly
    chosen to avoid accidental conflicts with other protobuf message formats
    used for acknowledgements. The first byte of any message with this format
    will be the non-ASCII values `0xaa` (result) or `0xb2` (error). Implemented
    as defined by ICS:
    https://github.com/cosmos/ibc/tree/master/spec/core/ics-004-channel-and-
    packet-semantics#acknowledgement-envelope
    """

    result: bytes = betterproto.bytes_field(21, group="response")
    error: str = betterproto.string_field(22, group="response")


@dataclass(eq=False, repr=False)
class Timeout(betterproto.Message):
    """
    Timeout defines an execution deadline structure for 04-channel handlers.
    This includes packet lifecycle handlers as well as the upgrade handshake
    handlers. A valid Timeout contains either one or both of a timestamp and
    block height (sequence).
    """

    height: "__client_v1__.Height" = betterproto.message_field(1)
    """block height after which the packet or upgrade times out"""

    timestamp: int = betterproto.uint64_field(2)
    """
    block timestamp (in nanoseconds) after which the packet or upgrade times
    out
    """


@dataclass(eq=False, repr=False)
class Params(betterproto.Message):
    """Params defines the set of IBC channel parameters."""

    upgrade_timeout: "Timeout" = betterproto.message_field(1)
    """the relative timeout after which channel upgrades will time out."""


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the ibc channel submodule's genesis state."""

    channels: List["IdentifiedChannel"] = betterproto.message_field(1)
    acknowledgements: List["PacketState"] = betterproto.message_field(2)
    commitments: List["PacketState"] = betterproto.message_field(3)
    receipts: List["PacketState"] = betterproto.message_field(4)
    send_sequences: List["PacketSequence"] = betterproto.message_field(5)
    recv_sequences: List["PacketSequence"] = betterproto.message_field(6)
    ack_sequences: List["PacketSequence"] = betterproto.message_field(7)
    next_channel_sequence: int = betterproto.uint64_field(8)
    """the sequence for the next generated channel identifier"""

    params: "Params" = betterproto.message_field(9)


@dataclass(eq=False, repr=False)
class PacketSequence(betterproto.Message):
    """
    PacketSequence defines the genesis type necessary to retrieve and store
    next send and receive sequences.
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    sequence: int = betterproto.uint64_field(3)


@dataclass(eq=False, repr=False)
class Upgrade(betterproto.Message):
    """
    Upgrade is a verifiable type which contains the relevant information for an
    attempted upgrade. It provides the proposed changes to the channel end, the
    timeout for this upgrade attempt and the next packet sequence which allows
    the counterparty to efficiently know the highest sequence it has received.
    The next sequence send is used for pruning and upgrading from unordered to
    ordered channels.
    """

    fields: "UpgradeFields" = betterproto.message_field(1)
    timeout: "Timeout" = betterproto.message_field(2)
    next_sequence_send: int = betterproto.uint64_field(3)


@dataclass(eq=False, repr=False)
class UpgradeFields(betterproto.Message):
    """
    UpgradeFields are the fields in a channel end which may be changed during a
    channel upgrade.
    """

    ordering: "Order" = betterproto.enum_field(1)
    connection_hops: List[str] = betterproto.string_field(2)
    version: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class ErrorReceipt(betterproto.Message):
    """
    ErrorReceipt defines a type which encapsulates the upgrade sequence and
    error associated with the upgrade handshake failure. When a channel upgrade
    handshake is aborted both chains are expected to increment to the next
    sequence.
    """

    sequence: int = betterproto.uint64_field(1)
    """the channel upgrade sequence"""

    message: str = betterproto.string_field(2)
    """the error message detailing the cause of failure"""


@dataclass(eq=False, repr=False)
class MsgChannelOpenInit(betterproto.Message):
    """
    MsgChannelOpenInit defines an sdk.Msg to initialize a channel handshake. It
    is called by a relayer on Chain A.
    """

    port_id: str = betterproto.string_field(1)
    channel: "Channel" = betterproto.message_field(2)
    signer: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class MsgChannelOpenInitResponse(betterproto.Message):
    """
    MsgChannelOpenInitResponse defines the Msg/ChannelOpenInit response type.
    """

    channel_id: str = betterproto.string_field(1)
    version: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class MsgChannelOpenTry(betterproto.Message):
    """
    MsgChannelOpenInit defines a msg sent by a Relayer to try to open a channel
    on Chain B. The version field within the Channel field has been deprecated.
    Its value will be ignored by core IBC.
    """

    port_id: str = betterproto.string_field(1)
    previous_channel_id: str = betterproto.string_field(2)
    """
    Deprecated: this field is unused. Crossing hello's are no longer supported
    in core IBC.
    """

    channel: "Channel" = betterproto.message_field(3)
    """
    NOTE: the version field within the channel has been deprecated. Its value
    will be ignored by core IBC.
    """

    counterparty_version: str = betterproto.string_field(4)
    proof_init: bytes = betterproto.bytes_field(5)
    proof_height: "__client_v1__.Height" = betterproto.message_field(6)
    signer: str = betterproto.string_field(7)

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("previous_channel_id"):
            warnings.warn(
                "MsgChannelOpenTry.previous_channel_id is deprecated",
                DeprecationWarning,
            )


@dataclass(eq=False, repr=False)
class MsgChannelOpenTryResponse(betterproto.Message):
    """
    MsgChannelOpenTryResponse defines the Msg/ChannelOpenTry response type.
    """

    version: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class MsgChannelOpenAck(betterproto.Message):
    """
    MsgChannelOpenAck defines a msg sent by a Relayer to Chain A to acknowledge
    the change of channel state to TRYOPEN on Chain B. WARNING: a channel
    upgrade MUST NOT initialize an upgrade for this channel in the same block
    as executing this message otherwise the counterparty will be incapable of
    opening.
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    counterparty_channel_id: str = betterproto.string_field(3)
    counterparty_version: str = betterproto.string_field(4)
    proof_try: bytes = betterproto.bytes_field(5)
    proof_height: "__client_v1__.Height" = betterproto.message_field(6)
    signer: str = betterproto.string_field(7)


@dataclass(eq=False, repr=False)
class MsgChannelOpenAckResponse(betterproto.Message):
    """
    MsgChannelOpenAckResponse defines the Msg/ChannelOpenAck response type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgChannelOpenConfirm(betterproto.Message):
    """
    MsgChannelOpenConfirm defines a msg sent by a Relayer to Chain B to
    acknowledge the change of channel state to OPEN on Chain A.
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    proof_ack: bytes = betterproto.bytes_field(3)
    proof_height: "__client_v1__.Height" = betterproto.message_field(4)
    signer: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class MsgChannelOpenConfirmResponse(betterproto.Message):
    """
    MsgChannelOpenConfirmResponse defines the Msg/ChannelOpenConfirm response
    type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgChannelCloseInit(betterproto.Message):
    """
    MsgChannelCloseInit defines a msg sent by a Relayer to Chain A to close a
    channel with Chain B.
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    signer: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class MsgChannelCloseInitResponse(betterproto.Message):
    """
    MsgChannelCloseInitResponse defines the Msg/ChannelCloseInit response type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgChannelCloseConfirm(betterproto.Message):
    """
    MsgChannelCloseConfirm defines a msg sent by a Relayer to Chain B to
    acknowledge the change of channel state to CLOSED on Chain A.
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    proof_init: bytes = betterproto.bytes_field(3)
    proof_height: "__client_v1__.Height" = betterproto.message_field(4)
    signer: str = betterproto.string_field(5)
    counterparty_upgrade_sequence: int = betterproto.uint64_field(6)


@dataclass(eq=False, repr=False)
class MsgChannelCloseConfirmResponse(betterproto.Message):
    """
    MsgChannelCloseConfirmResponse defines the Msg/ChannelCloseConfirm response
    type.
    """

    pass


@dataclass(eq=False, repr=False)
class MsgRecvPacket(betterproto.Message):
    """MsgRecvPacket receives incoming IBC packet"""

    packet: "Packet" = betterproto.message_field(1)
    proof_commitment: bytes = betterproto.bytes_field(2)
    proof_height: "__client_v1__.Height" = betterproto.message_field(3)
    signer: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class MsgRecvPacketResponse(betterproto.Message):
    """MsgRecvPacketResponse defines the Msg/RecvPacket response type."""

    result: "ResponseResultType" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class MsgTimeout(betterproto.Message):
    """MsgTimeout receives timed-out packet"""

    packet: "Packet" = betterproto.message_field(1)
    proof_unreceived: bytes = betterproto.bytes_field(2)
    proof_height: "__client_v1__.Height" = betterproto.message_field(3)
    next_sequence_recv: int = betterproto.uint64_field(4)
    signer: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class MsgTimeoutResponse(betterproto.Message):
    """MsgTimeoutResponse defines the Msg/Timeout response type."""

    result: "ResponseResultType" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class MsgTimeoutOnClose(betterproto.Message):
    """
    MsgTimeoutOnClose timed-out packet upon counterparty channel closure.
    """

    packet: "Packet" = betterproto.message_field(1)
    proof_unreceived: bytes = betterproto.bytes_field(2)
    proof_close: bytes = betterproto.bytes_field(3)
    proof_height: "__client_v1__.Height" = betterproto.message_field(4)
    next_sequence_recv: int = betterproto.uint64_field(5)
    signer: str = betterproto.string_field(6)
    counterparty_upgrade_sequence: int = betterproto.uint64_field(7)


@dataclass(eq=False, repr=False)
class MsgTimeoutOnCloseResponse(betterproto.Message):
    """
    MsgTimeoutOnCloseResponse defines the Msg/TimeoutOnClose response type.
    """

    result: "ResponseResultType" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class MsgAcknowledgement(betterproto.Message):
    """MsgAcknowledgement receives incoming IBC acknowledgement"""

    packet: "Packet" = betterproto.message_field(1)
    acknowledgement: bytes = betterproto.bytes_field(2)
    proof_acked: bytes = betterproto.bytes_field(3)
    proof_height: "__client_v1__.Height" = betterproto.message_field(4)
    signer: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class MsgAcknowledgementResponse(betterproto.Message):
    """
    MsgAcknowledgementResponse defines the Msg/Acknowledgement response type.
    """

    result: "ResponseResultType" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class MsgChannelUpgradeInit(betterproto.Message):
    """
    MsgChannelUpgradeInit defines the request type for the ChannelUpgradeInit
    rpc WARNING: Initializing a channel upgrade in the same block as opening
    the channel may result in the counterparty being incapable of opening.
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    fields: "UpgradeFields" = betterproto.message_field(3)
    signer: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class MsgChannelUpgradeInitResponse(betterproto.Message):
    """
    MsgChannelUpgradeInitResponse defines the MsgChannelUpgradeInit response
    type
    """

    upgrade: "Upgrade" = betterproto.message_field(1)
    upgrade_sequence: int = betterproto.uint64_field(2)


@dataclass(eq=False, repr=False)
class MsgChannelUpgradeTry(betterproto.Message):
    """
    MsgChannelUpgradeTry defines the request type for the ChannelUpgradeTry rpc
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    proposed_upgrade_connection_hops: List[str] = betterproto.string_field(3)
    counterparty_upgrade_fields: "UpgradeFields" = betterproto.message_field(4)
    counterparty_upgrade_sequence: int = betterproto.uint64_field(5)
    proof_channel: bytes = betterproto.bytes_field(6)
    proof_upgrade: bytes = betterproto.bytes_field(7)
    proof_height: "__client_v1__.Height" = betterproto.message_field(8)
    signer: str = betterproto.string_field(9)


@dataclass(eq=False, repr=False)
class MsgChannelUpgradeTryResponse(betterproto.Message):
    """
    MsgChannelUpgradeTryResponse defines the MsgChannelUpgradeTry response type
    """

    upgrade: "Upgrade" = betterproto.message_field(1)
    upgrade_sequence: int = betterproto.uint64_field(2)
    result: "ResponseResultType" = betterproto.enum_field(3)


@dataclass(eq=False, repr=False)
class MsgChannelUpgradeAck(betterproto.Message):
    """
    MsgChannelUpgradeAck defines the request type for the ChannelUpgradeAck rpc
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    counterparty_upgrade: "Upgrade" = betterproto.message_field(3)
    proof_channel: bytes = betterproto.bytes_field(4)
    proof_upgrade: bytes = betterproto.bytes_field(5)
    proof_height: "__client_v1__.Height" = betterproto.message_field(6)
    signer: str = betterproto.string_field(7)


@dataclass(eq=False, repr=False)
class MsgChannelUpgradeAckResponse(betterproto.Message):
    """
    MsgChannelUpgradeAckResponse defines MsgChannelUpgradeAck response type
    """

    result: "ResponseResultType" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class MsgChannelUpgradeConfirm(betterproto.Message):
    """
    MsgChannelUpgradeConfirm defines the request type for the
    ChannelUpgradeConfirm rpc
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    counterparty_channel_state: "State" = betterproto.enum_field(3)
    counterparty_upgrade: "Upgrade" = betterproto.message_field(4)
    proof_channel: bytes = betterproto.bytes_field(5)
    proof_upgrade: bytes = betterproto.bytes_field(6)
    proof_height: "__client_v1__.Height" = betterproto.message_field(7)
    signer: str = betterproto.string_field(8)


@dataclass(eq=False, repr=False)
class MsgChannelUpgradeConfirmResponse(betterproto.Message):
    """
    MsgChannelUpgradeConfirmResponse defines MsgChannelUpgradeConfirm response
    type
    """

    result: "ResponseResultType" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class MsgChannelUpgradeOpen(betterproto.Message):
    """
    MsgChannelUpgradeOpen defines the request type for the ChannelUpgradeOpen
    rpc
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    counterparty_channel_state: "State" = betterproto.enum_field(3)
    counterparty_upgrade_sequence: int = betterproto.uint64_field(4)
    proof_channel: bytes = betterproto.bytes_field(5)
    proof_height: "__client_v1__.Height" = betterproto.message_field(6)
    signer: str = betterproto.string_field(7)


@dataclass(eq=False, repr=False)
class MsgChannelUpgradeOpenResponse(betterproto.Message):
    """
    MsgChannelUpgradeOpenResponse defines the MsgChannelUpgradeOpen response
    type
    """

    pass


@dataclass(eq=False, repr=False)
class MsgChannelUpgradeTimeout(betterproto.Message):
    """
    MsgChannelUpgradeTimeout defines the request type for the
    ChannelUpgradeTimeout rpc
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    counterparty_channel: "Channel" = betterproto.message_field(3)
    proof_channel: bytes = betterproto.bytes_field(4)
    proof_height: "__client_v1__.Height" = betterproto.message_field(5)
    signer: str = betterproto.string_field(6)


@dataclass(eq=False, repr=False)
class MsgChannelUpgradeTimeoutResponse(betterproto.Message):
    """
    MsgChannelUpgradeTimeoutRepsonse defines the MsgChannelUpgradeTimeout
    response type
    """

    pass


@dataclass(eq=False, repr=False)
class MsgChannelUpgradeCancel(betterproto.Message):
    """
    MsgChannelUpgradeCancel defines the request type for the
    ChannelUpgradeCancel rpc
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    error_receipt: "ErrorReceipt" = betterproto.message_field(3)
    proof_error_receipt: bytes = betterproto.bytes_field(4)
    proof_height: "__client_v1__.Height" = betterproto.message_field(5)
    signer: str = betterproto.string_field(6)


@dataclass(eq=False, repr=False)
class MsgChannelUpgradeCancelResponse(betterproto.Message):
    """
    MsgChannelUpgradeCancelResponse defines the MsgChannelUpgradeCancel
    response type
    """

    pass


@dataclass(eq=False, repr=False)
class MsgUpdateParams(betterproto.Message):
    """MsgUpdateParams is the MsgUpdateParams request type."""

    authority: str = betterproto.string_field(1)
    """
    authority is the address that controls the module (defaults to x/gov unless
    overwritten).
    """

    params: "Params" = betterproto.message_field(2)
    """
    params defines the channel parameters to update. NOTE: All parameters must
    be supplied.
    """


@dataclass(eq=False, repr=False)
class MsgUpdateParamsResponse(betterproto.Message):
    """MsgUpdateParamsResponse defines the MsgUpdateParams response type."""

    pass


@dataclass(eq=False, repr=False)
class MsgPruneAcknowledgements(betterproto.Message):
    """
    MsgPruneAcknowledgements defines the request type for the
    PruneAcknowledgements rpc.
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)
    limit: int = betterproto.uint64_field(3)
    signer: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class MsgPruneAcknowledgementsResponse(betterproto.Message):
    """
    MsgPruneAcknowledgementsResponse defines the response type for the
    PruneAcknowledgements rpc.
    """

    total_pruned_sequences: int = betterproto.uint64_field(1)
    """
    Number of sequences pruned (includes both packet acknowledgements and
    packet receipts where appropriate).
    """

    total_remaining_sequences: int = betterproto.uint64_field(2)
    """Number of sequences left after pruning."""


@dataclass(eq=False, repr=False)
class QueryChannelRequest(betterproto.Message):
    """
    QueryChannelRequest is the request type for the Query/Channel RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""


@dataclass(eq=False, repr=False)
class QueryChannelResponse(betterproto.Message):
    """
    QueryChannelResponse is the response type for the Query/Channel RPC method.
    Besides the Channel end, it includes a proof and the height from which the
    proof was retrieved.
    """

    channel: "Channel" = betterproto.message_field(1)
    """channel associated with the request identifiers"""

    proof: bytes = betterproto.bytes_field(2)
    """merkle proof of existence"""

    proof_height: "__client_v1__.Height" = betterproto.message_field(3)
    """height at which the proof was retrieved"""


@dataclass(eq=False, repr=False)
class QueryChannelsRequest(betterproto.Message):
    """
    QueryChannelsRequest is the request type for the Query/Channels RPC method
    """

    pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(1)
    )
    """pagination request"""


@dataclass(eq=False, repr=False)
class QueryChannelsResponse(betterproto.Message):
    """
    QueryChannelsResponse is the response type for the Query/Channels RPC
    method.
    """

    channels: List["IdentifiedChannel"] = betterproto.message_field(1)
    """list of stored channels of the chain."""

    pagination: "____cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )
    """pagination response"""

    height: "__client_v1__.Height" = betterproto.message_field(3)
    """query block height"""


@dataclass(eq=False, repr=False)
class QueryConnectionChannelsRequest(betterproto.Message):
    """
    QueryConnectionChannelsRequest is the request type for the
    Query/QueryConnectionChannels RPC method
    """

    connection: str = betterproto.string_field(1)
    """connection unique identifier"""

    pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(2)
    )
    """pagination request"""


@dataclass(eq=False, repr=False)
class QueryConnectionChannelsResponse(betterproto.Message):
    """
    QueryConnectionChannelsResponse is the Response type for the
    Query/QueryConnectionChannels RPC method
    """

    channels: List["IdentifiedChannel"] = betterproto.message_field(1)
    """list of channels associated with a connection."""

    pagination: "____cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )
    """pagination response"""

    height: "__client_v1__.Height" = betterproto.message_field(3)
    """query block height"""


@dataclass(eq=False, repr=False)
class QueryChannelClientStateRequest(betterproto.Message):
    """
    QueryChannelClientStateRequest is the request type for the
    Query/ClientState RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""


@dataclass(eq=False, repr=False)
class QueryChannelClientStateResponse(betterproto.Message):
    """
    QueryChannelClientStateResponse is the Response type for the
    Query/QueryChannelClientState RPC method
    """

    identified_client_state: "__client_v1__.IdentifiedClientState" = (
        betterproto.message_field(1)
    )
    """client state associated with the channel"""

    proof: bytes = betterproto.bytes_field(2)
    """merkle proof of existence"""

    proof_height: "__client_v1__.Height" = betterproto.message_field(3)
    """height at which the proof was retrieved"""


@dataclass(eq=False, repr=False)
class QueryChannelConsensusStateRequest(betterproto.Message):
    """
    QueryChannelConsensusStateRequest is the request type for the
    Query/ConsensusState RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""

    revision_number: int = betterproto.uint64_field(3)
    """revision number of the consensus state"""

    revision_height: int = betterproto.uint64_field(4)
    """revision height of the consensus state"""


@dataclass(eq=False, repr=False)
class QueryChannelConsensusStateResponse(betterproto.Message):
    """
    QueryChannelClientStateResponse is the Response type for the
    Query/QueryChannelClientState RPC method
    """

    consensus_state: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(
        1
    )
    """consensus state associated with the channel"""

    client_id: str = betterproto.string_field(2)
    """client ID associated with the consensus state"""

    proof: bytes = betterproto.bytes_field(3)
    """merkle proof of existence"""

    proof_height: "__client_v1__.Height" = betterproto.message_field(4)
    """height at which the proof was retrieved"""


@dataclass(eq=False, repr=False)
class QueryPacketCommitmentRequest(betterproto.Message):
    """
    QueryPacketCommitmentRequest is the request type for the
    Query/PacketCommitment RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""

    sequence: int = betterproto.uint64_field(3)
    """packet sequence"""


@dataclass(eq=False, repr=False)
class QueryPacketCommitmentResponse(betterproto.Message):
    """
    QueryPacketCommitmentResponse defines the client query response for a
    packet which also includes a proof and the height from which the proof was
    retrieved
    """

    commitment: bytes = betterproto.bytes_field(1)
    """packet associated with the request fields"""

    proof: bytes = betterproto.bytes_field(2)
    """merkle proof of existence"""

    proof_height: "__client_v1__.Height" = betterproto.message_field(3)
    """height at which the proof was retrieved"""


@dataclass(eq=False, repr=False)
class QueryPacketCommitmentsRequest(betterproto.Message):
    """
    QueryPacketCommitmentsRequest is the request type for the
    Query/QueryPacketCommitments RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""

    pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(3)
    )
    """pagination request"""


@dataclass(eq=False, repr=False)
class QueryPacketCommitmentsResponse(betterproto.Message):
    """
    QueryPacketCommitmentsResponse is the request type for the
    Query/QueryPacketCommitments RPC method
    """

    commitments: List["PacketState"] = betterproto.message_field(1)
    pagination: "____cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )
    """pagination response"""

    height: "__client_v1__.Height" = betterproto.message_field(3)
    """query block height"""


@dataclass(eq=False, repr=False)
class QueryPacketReceiptRequest(betterproto.Message):
    """
    QueryPacketReceiptRequest is the request type for the Query/PacketReceipt
    RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""

    sequence: int = betterproto.uint64_field(3)
    """packet sequence"""


@dataclass(eq=False, repr=False)
class QueryPacketReceiptResponse(betterproto.Message):
    """
    QueryPacketReceiptResponse defines the client query response for a packet
    receipt which also includes a proof, and the height from which the proof
    was retrieved
    """

    received: bool = betterproto.bool_field(2)
    """success flag for if receipt exists"""

    proof: bytes = betterproto.bytes_field(3)
    """merkle proof of existence"""

    proof_height: "__client_v1__.Height" = betterproto.message_field(4)
    """height at which the proof was retrieved"""


@dataclass(eq=False, repr=False)
class QueryPacketAcknowledgementRequest(betterproto.Message):
    """
    QueryPacketAcknowledgementRequest is the request type for the
    Query/PacketAcknowledgement RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""

    sequence: int = betterproto.uint64_field(3)
    """packet sequence"""


@dataclass(eq=False, repr=False)
class QueryPacketAcknowledgementResponse(betterproto.Message):
    """
    QueryPacketAcknowledgementResponse defines the client query response for a
    packet which also includes a proof and the height from which the proof was
    retrieved
    """

    acknowledgement: bytes = betterproto.bytes_field(1)
    """packet associated with the request fields"""

    proof: bytes = betterproto.bytes_field(2)
    """merkle proof of existence"""

    proof_height: "__client_v1__.Height" = betterproto.message_field(3)
    """height at which the proof was retrieved"""


@dataclass(eq=False, repr=False)
class QueryPacketAcknowledgementsRequest(betterproto.Message):
    """
    QueryPacketAcknowledgementsRequest is the request type for the
    Query/QueryPacketCommitments RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""

    pagination: "____cosmos_base_query_v1_beta1__.PageRequest" = (
        betterproto.message_field(3)
    )
    """pagination request"""

    packet_commitment_sequences: List[int] = betterproto.uint64_field(4)
    """list of packet sequences"""


@dataclass(eq=False, repr=False)
class QueryPacketAcknowledgementsResponse(betterproto.Message):
    """
    QueryPacketAcknowledgemetsResponse is the request type for the
    Query/QueryPacketAcknowledgements RPC method
    """

    acknowledgements: List["PacketState"] = betterproto.message_field(1)
    pagination: "____cosmos_base_query_v1_beta1__.PageResponse" = (
        betterproto.message_field(2)
    )
    """pagination response"""

    height: "__client_v1__.Height" = betterproto.message_field(3)
    """query block height"""


@dataclass(eq=False, repr=False)
class QueryUnreceivedPacketsRequest(betterproto.Message):
    """
    QueryUnreceivedPacketsRequest is the request type for the
    Query/UnreceivedPackets RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""

    packet_commitment_sequences: List[int] = betterproto.uint64_field(3)
    """list of packet sequences"""


@dataclass(eq=False, repr=False)
class QueryUnreceivedPacketsResponse(betterproto.Message):
    """
    QueryUnreceivedPacketsResponse is the response type for the
    Query/UnreceivedPacketCommitments RPC method
    """

    sequences: List[int] = betterproto.uint64_field(1)
    """list of unreceived packet sequences"""

    height: "__client_v1__.Height" = betterproto.message_field(2)
    """query block height"""


@dataclass(eq=False, repr=False)
class QueryUnreceivedAcksRequest(betterproto.Message):
    """
    QueryUnreceivedAcks is the request type for the Query/UnreceivedAcks RPC
    method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""

    packet_ack_sequences: List[int] = betterproto.uint64_field(3)
    """list of acknowledgement sequences"""


@dataclass(eq=False, repr=False)
class QueryUnreceivedAcksResponse(betterproto.Message):
    """
    QueryUnreceivedAcksResponse is the response type for the
    Query/UnreceivedAcks RPC method
    """

    sequences: List[int] = betterproto.uint64_field(1)
    """list of unreceived acknowledgement sequences"""

    height: "__client_v1__.Height" = betterproto.message_field(2)
    """query block height"""


@dataclass(eq=False, repr=False)
class QueryNextSequenceReceiveRequest(betterproto.Message):
    """
    QueryNextSequenceReceiveRequest is the request type for the
    Query/QueryNextSequenceReceiveRequest RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""


@dataclass(eq=False, repr=False)
class QueryNextSequenceReceiveResponse(betterproto.Message):
    """
    QuerySequenceResponse is the response type for the
    Query/QueryNextSequenceReceiveResponse RPC method
    """

    next_sequence_receive: int = betterproto.uint64_field(1)
    """next sequence receive number"""

    proof: bytes = betterproto.bytes_field(2)
    """merkle proof of existence"""

    proof_height: "__client_v1__.Height" = betterproto.message_field(3)
    """height at which the proof was retrieved"""


@dataclass(eq=False, repr=False)
class QueryNextSequenceSendRequest(betterproto.Message):
    """
    QueryNextSequenceSendRequest is the request type for the
    Query/QueryNextSequenceSend RPC method
    """

    port_id: str = betterproto.string_field(1)
    """port unique identifier"""

    channel_id: str = betterproto.string_field(2)
    """channel unique identifier"""


@dataclass(eq=False, repr=False)
class QueryNextSequenceSendResponse(betterproto.Message):
    """
    QueryNextSequenceSendResponse is the request type for the
    Query/QueryNextSequenceSend RPC method
    """

    next_sequence_send: int = betterproto.uint64_field(1)
    """next sequence send number"""

    proof: bytes = betterproto.bytes_field(2)
    """merkle proof of existence"""

    proof_height: "__client_v1__.Height" = betterproto.message_field(3)
    """height at which the proof was retrieved"""


@dataclass(eq=False, repr=False)
class QueryUpgradeErrorRequest(betterproto.Message):
    """
    QueryUpgradeErrorRequest is the request type for the
    Query/QueryUpgradeError RPC method
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class QueryUpgradeErrorResponse(betterproto.Message):
    """
    QueryUpgradeErrorResponse is the response type for the
    Query/QueryUpgradeError RPC method
    """

    error_receipt: "ErrorReceipt" = betterproto.message_field(1)
    proof: bytes = betterproto.bytes_field(2)
    """merkle proof of existence"""

    proof_height: "__client_v1__.Height" = betterproto.message_field(3)
    """height at which the proof was retrieved"""


@dataclass(eq=False, repr=False)
class QueryUpgradeRequest(betterproto.Message):
    """
    QueryUpgradeRequest is the request type for the QueryUpgradeRequest RPC
    method
    """

    port_id: str = betterproto.string_field(1)
    channel_id: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class QueryUpgradeResponse(betterproto.Message):
    """
    QueryUpgradeResponse is the response type for the QueryUpgradeResponse RPC
    method
    """

    upgrade: "Upgrade" = betterproto.message_field(1)
    proof: bytes = betterproto.bytes_field(2)
    """merkle proof of existence"""

    proof_height: "__client_v1__.Height" = betterproto.message_field(3)
    """height at which the proof was retrieved"""


@dataclass(eq=False, repr=False)
class QueryChannelParamsRequest(betterproto.Message):
    """
    QueryChannelParamsRequest is the request type for the Query/ChannelParams
    RPC method.
    """

    pass


@dataclass(eq=False, repr=False)
class QueryChannelParamsResponse(betterproto.Message):
    """
    QueryChannelParamsResponse is the response type for the Query/ChannelParams
    RPC method.
    """

    params: "Params" = betterproto.message_field(1)
    """params defines the parameters of the module."""


class MsgStub(betterproto.ServiceStub):
    async def channel_open_init(
        self,
        msg_channel_open_init: "MsgChannelOpenInit",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgChannelOpenInitResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelOpenInit",
            msg_channel_open_init,
            MsgChannelOpenInitResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_open_try(
        self,
        msg_channel_open_try: "MsgChannelOpenTry",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgChannelOpenTryResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelOpenTry",
            msg_channel_open_try,
            MsgChannelOpenTryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_open_ack(
        self,
        msg_channel_open_ack: "MsgChannelOpenAck",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgChannelOpenAckResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelOpenAck",
            msg_channel_open_ack,
            MsgChannelOpenAckResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_open_confirm(
        self,
        msg_channel_open_confirm: "MsgChannelOpenConfirm",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgChannelOpenConfirmResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelOpenConfirm",
            msg_channel_open_confirm,
            MsgChannelOpenConfirmResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_close_init(
        self,
        msg_channel_close_init: "MsgChannelCloseInit",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgChannelCloseInitResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelCloseInit",
            msg_channel_close_init,
            MsgChannelCloseInitResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_close_confirm(
        self,
        msg_channel_close_confirm: "MsgChannelCloseConfirm",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgChannelCloseConfirmResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelCloseConfirm",
            msg_channel_close_confirm,
            MsgChannelCloseConfirmResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def recv_packet(
        self,
        msg_recv_packet: "MsgRecvPacket",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgRecvPacketResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/RecvPacket",
            msg_recv_packet,
            MsgRecvPacketResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def timeout(
        self,
        msg_timeout: "MsgTimeout",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgTimeoutResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/Timeout",
            msg_timeout,
            MsgTimeoutResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def timeout_on_close(
        self,
        msg_timeout_on_close: "MsgTimeoutOnClose",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgTimeoutOnCloseResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/TimeoutOnClose",
            msg_timeout_on_close,
            MsgTimeoutOnCloseResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def acknowledgement(
        self,
        msg_acknowledgement: "MsgAcknowledgement",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgAcknowledgementResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/Acknowledgement",
            msg_acknowledgement,
            MsgAcknowledgementResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_upgrade_init(
        self,
        msg_channel_upgrade_init: "MsgChannelUpgradeInit",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgChannelUpgradeInitResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelUpgradeInit",
            msg_channel_upgrade_init,
            MsgChannelUpgradeInitResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_upgrade_try(
        self,
        msg_channel_upgrade_try: "MsgChannelUpgradeTry",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgChannelUpgradeTryResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelUpgradeTry",
            msg_channel_upgrade_try,
            MsgChannelUpgradeTryResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_upgrade_ack(
        self,
        msg_channel_upgrade_ack: "MsgChannelUpgradeAck",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgChannelUpgradeAckResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelUpgradeAck",
            msg_channel_upgrade_ack,
            MsgChannelUpgradeAckResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_upgrade_confirm(
        self,
        msg_channel_upgrade_confirm: "MsgChannelUpgradeConfirm",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgChannelUpgradeConfirmResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelUpgradeConfirm",
            msg_channel_upgrade_confirm,
            MsgChannelUpgradeConfirmResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_upgrade_open(
        self,
        msg_channel_upgrade_open: "MsgChannelUpgradeOpen",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgChannelUpgradeOpenResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelUpgradeOpen",
            msg_channel_upgrade_open,
            MsgChannelUpgradeOpenResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_upgrade_timeout(
        self,
        msg_channel_upgrade_timeout: "MsgChannelUpgradeTimeout",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgChannelUpgradeTimeoutResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelUpgradeTimeout",
            msg_channel_upgrade_timeout,
            MsgChannelUpgradeTimeoutResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_upgrade_cancel(
        self,
        msg_channel_upgrade_cancel: "MsgChannelUpgradeCancel",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgChannelUpgradeCancelResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/ChannelUpgradeCancel",
            msg_channel_upgrade_cancel,
            MsgChannelUpgradeCancelResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_channel_params(
        self,
        msg_update_params: "MsgUpdateParams",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgUpdateParamsResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/UpdateChannelParams",
            msg_update_params,
            MsgUpdateParamsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def prune_acknowledgements(
        self,
        msg_prune_acknowledgements: "MsgPruneAcknowledgements",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgPruneAcknowledgementsResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Msg/PruneAcknowledgements",
            msg_prune_acknowledgements,
            MsgPruneAcknowledgementsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class QueryStub(betterproto.ServiceStub):
    async def channel(
        self,
        query_channel_request: "QueryChannelRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryChannelResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/Channel",
            query_channel_request,
            QueryChannelResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channels(
        self,
        query_channels_request: "QueryChannelsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryChannelsResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/Channels",
            query_channels_request,
            QueryChannelsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def connection_channels(
        self,
        query_connection_channels_request: "QueryConnectionChannelsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryConnectionChannelsResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/ConnectionChannels",
            query_connection_channels_request,
            QueryConnectionChannelsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_client_state(
        self,
        query_channel_client_state_request: "QueryChannelClientStateRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryChannelClientStateResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/ChannelClientState",
            query_channel_client_state_request,
            QueryChannelClientStateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_consensus_state(
        self,
        query_channel_consensus_state_request: "QueryChannelConsensusStateRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryChannelConsensusStateResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/ChannelConsensusState",
            query_channel_consensus_state_request,
            QueryChannelConsensusStateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def packet_commitment(
        self,
        query_packet_commitment_request: "QueryPacketCommitmentRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryPacketCommitmentResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/PacketCommitment",
            query_packet_commitment_request,
            QueryPacketCommitmentResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def packet_commitments(
        self,
        query_packet_commitments_request: "QueryPacketCommitmentsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryPacketCommitmentsResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/PacketCommitments",
            query_packet_commitments_request,
            QueryPacketCommitmentsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def packet_receipt(
        self,
        query_packet_receipt_request: "QueryPacketReceiptRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryPacketReceiptResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/PacketReceipt",
            query_packet_receipt_request,
            QueryPacketReceiptResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def packet_acknowledgement(
        self,
        query_packet_acknowledgement_request: "QueryPacketAcknowledgementRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryPacketAcknowledgementResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/PacketAcknowledgement",
            query_packet_acknowledgement_request,
            QueryPacketAcknowledgementResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def packet_acknowledgements(
        self,
        query_packet_acknowledgements_request: "QueryPacketAcknowledgementsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryPacketAcknowledgementsResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/PacketAcknowledgements",
            query_packet_acknowledgements_request,
            QueryPacketAcknowledgementsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def unreceived_packets(
        self,
        query_unreceived_packets_request: "QueryUnreceivedPacketsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryUnreceivedPacketsResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/UnreceivedPackets",
            query_unreceived_packets_request,
            QueryUnreceivedPacketsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def unreceived_acks(
        self,
        query_unreceived_acks_request: "QueryUnreceivedAcksRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryUnreceivedAcksResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/UnreceivedAcks",
            query_unreceived_acks_request,
            QueryUnreceivedAcksResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def next_sequence_receive(
        self,
        query_next_sequence_receive_request: "QueryNextSequenceReceiveRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryNextSequenceReceiveResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/NextSequenceReceive",
            query_next_sequence_receive_request,
            QueryNextSequenceReceiveResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def next_sequence_send(
        self,
        query_next_sequence_send_request: "QueryNextSequenceSendRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryNextSequenceSendResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/NextSequenceSend",
            query_next_sequence_send_request,
            QueryNextSequenceSendResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def upgrade_error(
        self,
        query_upgrade_error_request: "QueryUpgradeErrorRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryUpgradeErrorResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/UpgradeError",
            query_upgrade_error_request,
            QueryUpgradeErrorResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def upgrade(
        self,
        query_upgrade_request: "QueryUpgradeRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryUpgradeResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/Upgrade",
            query_upgrade_request,
            QueryUpgradeResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def channel_params(
        self,
        query_channel_params_request: "QueryChannelParamsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryChannelParamsResponse":
        return await self._unary_unary(
            "/ibc.core.channel.v1.Query/ChannelParams",
            query_channel_params_request,
            QueryChannelParamsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class MsgBase(ServiceBase):

    async def channel_open_init(
        self, msg_channel_open_init: "MsgChannelOpenInit"
    ) -> "MsgChannelOpenInitResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_open_try(
        self, msg_channel_open_try: "MsgChannelOpenTry"
    ) -> "MsgChannelOpenTryResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_open_ack(
        self, msg_channel_open_ack: "MsgChannelOpenAck"
    ) -> "MsgChannelOpenAckResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_open_confirm(
        self, msg_channel_open_confirm: "MsgChannelOpenConfirm"
    ) -> "MsgChannelOpenConfirmResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_close_init(
        self, msg_channel_close_init: "MsgChannelCloseInit"
    ) -> "MsgChannelCloseInitResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_close_confirm(
        self, msg_channel_close_confirm: "MsgChannelCloseConfirm"
    ) -> "MsgChannelCloseConfirmResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def recv_packet(
        self, msg_recv_packet: "MsgRecvPacket"
    ) -> "MsgRecvPacketResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def timeout(self, msg_timeout: "MsgTimeout") -> "MsgTimeoutResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def timeout_on_close(
        self, msg_timeout_on_close: "MsgTimeoutOnClose"
    ) -> "MsgTimeoutOnCloseResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def acknowledgement(
        self, msg_acknowledgement: "MsgAcknowledgement"
    ) -> "MsgAcknowledgementResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_upgrade_init(
        self, msg_channel_upgrade_init: "MsgChannelUpgradeInit"
    ) -> "MsgChannelUpgradeInitResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_upgrade_try(
        self, msg_channel_upgrade_try: "MsgChannelUpgradeTry"
    ) -> "MsgChannelUpgradeTryResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_upgrade_ack(
        self, msg_channel_upgrade_ack: "MsgChannelUpgradeAck"
    ) -> "MsgChannelUpgradeAckResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_upgrade_confirm(
        self, msg_channel_upgrade_confirm: "MsgChannelUpgradeConfirm"
    ) -> "MsgChannelUpgradeConfirmResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_upgrade_open(
        self, msg_channel_upgrade_open: "MsgChannelUpgradeOpen"
    ) -> "MsgChannelUpgradeOpenResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_upgrade_timeout(
        self, msg_channel_upgrade_timeout: "MsgChannelUpgradeTimeout"
    ) -> "MsgChannelUpgradeTimeoutResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_upgrade_cancel(
        self, msg_channel_upgrade_cancel: "MsgChannelUpgradeCancel"
    ) -> "MsgChannelUpgradeCancelResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_channel_params(
        self, msg_update_params: "MsgUpdateParams"
    ) -> "MsgUpdateParamsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def prune_acknowledgements(
        self, msg_prune_acknowledgements: "MsgPruneAcknowledgements"
    ) -> "MsgPruneAcknowledgementsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_channel_open_init(
        self,
        stream: "grpclib.server.Stream[MsgChannelOpenInit, MsgChannelOpenInitResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_open_init(request)
        await stream.send_message(response)

    async def __rpc_channel_open_try(
        self,
        stream: "grpclib.server.Stream[MsgChannelOpenTry, MsgChannelOpenTryResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_open_try(request)
        await stream.send_message(response)

    async def __rpc_channel_open_ack(
        self,
        stream: "grpclib.server.Stream[MsgChannelOpenAck, MsgChannelOpenAckResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_open_ack(request)
        await stream.send_message(response)

    async def __rpc_channel_open_confirm(
        self,
        stream: "grpclib.server.Stream[MsgChannelOpenConfirm, MsgChannelOpenConfirmResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_open_confirm(request)
        await stream.send_message(response)

    async def __rpc_channel_close_init(
        self,
        stream: "grpclib.server.Stream[MsgChannelCloseInit, MsgChannelCloseInitResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_close_init(request)
        await stream.send_message(response)

    async def __rpc_channel_close_confirm(
        self,
        stream: "grpclib.server.Stream[MsgChannelCloseConfirm, MsgChannelCloseConfirmResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_close_confirm(request)
        await stream.send_message(response)

    async def __rpc_recv_packet(
        self, stream: "grpclib.server.Stream[MsgRecvPacket, MsgRecvPacketResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.recv_packet(request)
        await stream.send_message(response)

    async def __rpc_timeout(
        self, stream: "grpclib.server.Stream[MsgTimeout, MsgTimeoutResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.timeout(request)
        await stream.send_message(response)

    async def __rpc_timeout_on_close(
        self,
        stream: "grpclib.server.Stream[MsgTimeoutOnClose, MsgTimeoutOnCloseResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.timeout_on_close(request)
        await stream.send_message(response)

    async def __rpc_acknowledgement(
        self,
        stream: "grpclib.server.Stream[MsgAcknowledgement, MsgAcknowledgementResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.acknowledgement(request)
        await stream.send_message(response)

    async def __rpc_channel_upgrade_init(
        self,
        stream: "grpclib.server.Stream[MsgChannelUpgradeInit, MsgChannelUpgradeInitResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_upgrade_init(request)
        await stream.send_message(response)

    async def __rpc_channel_upgrade_try(
        self,
        stream: "grpclib.server.Stream[MsgChannelUpgradeTry, MsgChannelUpgradeTryResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_upgrade_try(request)
        await stream.send_message(response)

    async def __rpc_channel_upgrade_ack(
        self,
        stream: "grpclib.server.Stream[MsgChannelUpgradeAck, MsgChannelUpgradeAckResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_upgrade_ack(request)
        await stream.send_message(response)

    async def __rpc_channel_upgrade_confirm(
        self,
        stream: "grpclib.server.Stream[MsgChannelUpgradeConfirm, MsgChannelUpgradeConfirmResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_upgrade_confirm(request)
        await stream.send_message(response)

    async def __rpc_channel_upgrade_open(
        self,
        stream: "grpclib.server.Stream[MsgChannelUpgradeOpen, MsgChannelUpgradeOpenResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_upgrade_open(request)
        await stream.send_message(response)

    async def __rpc_channel_upgrade_timeout(
        self,
        stream: "grpclib.server.Stream[MsgChannelUpgradeTimeout, MsgChannelUpgradeTimeoutResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_upgrade_timeout(request)
        await stream.send_message(response)

    async def __rpc_channel_upgrade_cancel(
        self,
        stream: "grpclib.server.Stream[MsgChannelUpgradeCancel, MsgChannelUpgradeCancelResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_upgrade_cancel(request)
        await stream.send_message(response)

    async def __rpc_update_channel_params(
        self, stream: "grpclib.server.Stream[MsgUpdateParams, MsgUpdateParamsResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.update_channel_params(request)
        await stream.send_message(response)

    async def __rpc_prune_acknowledgements(
        self,
        stream: "grpclib.server.Stream[MsgPruneAcknowledgements, MsgPruneAcknowledgementsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.prune_acknowledgements(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/ibc.core.channel.v1.Msg/ChannelOpenInit": grpclib.const.Handler(
                self.__rpc_channel_open_init,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelOpenInit,
                MsgChannelOpenInitResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelOpenTry": grpclib.const.Handler(
                self.__rpc_channel_open_try,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelOpenTry,
                MsgChannelOpenTryResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelOpenAck": grpclib.const.Handler(
                self.__rpc_channel_open_ack,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelOpenAck,
                MsgChannelOpenAckResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelOpenConfirm": grpclib.const.Handler(
                self.__rpc_channel_open_confirm,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelOpenConfirm,
                MsgChannelOpenConfirmResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelCloseInit": grpclib.const.Handler(
                self.__rpc_channel_close_init,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelCloseInit,
                MsgChannelCloseInitResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelCloseConfirm": grpclib.const.Handler(
                self.__rpc_channel_close_confirm,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelCloseConfirm,
                MsgChannelCloseConfirmResponse,
            ),
            "/ibc.core.channel.v1.Msg/RecvPacket": grpclib.const.Handler(
                self.__rpc_recv_packet,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgRecvPacket,
                MsgRecvPacketResponse,
            ),
            "/ibc.core.channel.v1.Msg/Timeout": grpclib.const.Handler(
                self.__rpc_timeout,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgTimeout,
                MsgTimeoutResponse,
            ),
            "/ibc.core.channel.v1.Msg/TimeoutOnClose": grpclib.const.Handler(
                self.__rpc_timeout_on_close,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgTimeoutOnClose,
                MsgTimeoutOnCloseResponse,
            ),
            "/ibc.core.channel.v1.Msg/Acknowledgement": grpclib.const.Handler(
                self.__rpc_acknowledgement,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgAcknowledgement,
                MsgAcknowledgementResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelUpgradeInit": grpclib.const.Handler(
                self.__rpc_channel_upgrade_init,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelUpgradeInit,
                MsgChannelUpgradeInitResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelUpgradeTry": grpclib.const.Handler(
                self.__rpc_channel_upgrade_try,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelUpgradeTry,
                MsgChannelUpgradeTryResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelUpgradeAck": grpclib.const.Handler(
                self.__rpc_channel_upgrade_ack,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelUpgradeAck,
                MsgChannelUpgradeAckResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelUpgradeConfirm": grpclib.const.Handler(
                self.__rpc_channel_upgrade_confirm,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelUpgradeConfirm,
                MsgChannelUpgradeConfirmResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelUpgradeOpen": grpclib.const.Handler(
                self.__rpc_channel_upgrade_open,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelUpgradeOpen,
                MsgChannelUpgradeOpenResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelUpgradeTimeout": grpclib.const.Handler(
                self.__rpc_channel_upgrade_timeout,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelUpgradeTimeout,
                MsgChannelUpgradeTimeoutResponse,
            ),
            "/ibc.core.channel.v1.Msg/ChannelUpgradeCancel": grpclib.const.Handler(
                self.__rpc_channel_upgrade_cancel,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgChannelUpgradeCancel,
                MsgChannelUpgradeCancelResponse,
            ),
            "/ibc.core.channel.v1.Msg/UpdateChannelParams": grpclib.const.Handler(
                self.__rpc_update_channel_params,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgUpdateParams,
                MsgUpdateParamsResponse,
            ),
            "/ibc.core.channel.v1.Msg/PruneAcknowledgements": grpclib.const.Handler(
                self.__rpc_prune_acknowledgements,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgPruneAcknowledgements,
                MsgPruneAcknowledgementsResponse,
            ),
        }


class QueryBase(ServiceBase):

    async def channel(
        self, query_channel_request: "QueryChannelRequest"
    ) -> "QueryChannelResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channels(
        self, query_channels_request: "QueryChannelsRequest"
    ) -> "QueryChannelsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def connection_channels(
        self, query_connection_channels_request: "QueryConnectionChannelsRequest"
    ) -> "QueryConnectionChannelsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_client_state(
        self, query_channel_client_state_request: "QueryChannelClientStateRequest"
    ) -> "QueryChannelClientStateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_consensus_state(
        self, query_channel_consensus_state_request: "QueryChannelConsensusStateRequest"
    ) -> "QueryChannelConsensusStateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def packet_commitment(
        self, query_packet_commitment_request: "QueryPacketCommitmentRequest"
    ) -> "QueryPacketCommitmentResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def packet_commitments(
        self, query_packet_commitments_request: "QueryPacketCommitmentsRequest"
    ) -> "QueryPacketCommitmentsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def packet_receipt(
        self, query_packet_receipt_request: "QueryPacketReceiptRequest"
    ) -> "QueryPacketReceiptResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def packet_acknowledgement(
        self, query_packet_acknowledgement_request: "QueryPacketAcknowledgementRequest"
    ) -> "QueryPacketAcknowledgementResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def packet_acknowledgements(
        self,
        query_packet_acknowledgements_request: "QueryPacketAcknowledgementsRequest",
    ) -> "QueryPacketAcknowledgementsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def unreceived_packets(
        self, query_unreceived_packets_request: "QueryUnreceivedPacketsRequest"
    ) -> "QueryUnreceivedPacketsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def unreceived_acks(
        self, query_unreceived_acks_request: "QueryUnreceivedAcksRequest"
    ) -> "QueryUnreceivedAcksResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def next_sequence_receive(
        self, query_next_sequence_receive_request: "QueryNextSequenceReceiveRequest"
    ) -> "QueryNextSequenceReceiveResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def next_sequence_send(
        self, query_next_sequence_send_request: "QueryNextSequenceSendRequest"
    ) -> "QueryNextSequenceSendResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def upgrade_error(
        self, query_upgrade_error_request: "QueryUpgradeErrorRequest"
    ) -> "QueryUpgradeErrorResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def upgrade(
        self, query_upgrade_request: "QueryUpgradeRequest"
    ) -> "QueryUpgradeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def channel_params(
        self, query_channel_params_request: "QueryChannelParamsRequest"
    ) -> "QueryChannelParamsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_channel(
        self, stream: "grpclib.server.Stream[QueryChannelRequest, QueryChannelResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel(request)
        await stream.send_message(response)

    async def __rpc_channels(
        self,
        stream: "grpclib.server.Stream[QueryChannelsRequest, QueryChannelsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channels(request)
        await stream.send_message(response)

    async def __rpc_connection_channels(
        self,
        stream: "grpclib.server.Stream[QueryConnectionChannelsRequest, QueryConnectionChannelsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.connection_channels(request)
        await stream.send_message(response)

    async def __rpc_channel_client_state(
        self,
        stream: "grpclib.server.Stream[QueryChannelClientStateRequest, QueryChannelClientStateResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_client_state(request)
        await stream.send_message(response)

    async def __rpc_channel_consensus_state(
        self,
        stream: "grpclib.server.Stream[QueryChannelConsensusStateRequest, QueryChannelConsensusStateResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_consensus_state(request)
        await stream.send_message(response)

    async def __rpc_packet_commitment(
        self,
        stream: "grpclib.server.Stream[QueryPacketCommitmentRequest, QueryPacketCommitmentResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.packet_commitment(request)
        await stream.send_message(response)

    async def __rpc_packet_commitments(
        self,
        stream: "grpclib.server.Stream[QueryPacketCommitmentsRequest, QueryPacketCommitmentsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.packet_commitments(request)
        await stream.send_message(response)

    async def __rpc_packet_receipt(
        self,
        stream: "grpclib.server.Stream[QueryPacketReceiptRequest, QueryPacketReceiptResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.packet_receipt(request)
        await stream.send_message(response)

    async def __rpc_packet_acknowledgement(
        self,
        stream: "grpclib.server.Stream[QueryPacketAcknowledgementRequest, QueryPacketAcknowledgementResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.packet_acknowledgement(request)
        await stream.send_message(response)

    async def __rpc_packet_acknowledgements(
        self,
        stream: "grpclib.server.Stream[QueryPacketAcknowledgementsRequest, QueryPacketAcknowledgementsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.packet_acknowledgements(request)
        await stream.send_message(response)

    async def __rpc_unreceived_packets(
        self,
        stream: "grpclib.server.Stream[QueryUnreceivedPacketsRequest, QueryUnreceivedPacketsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.unreceived_packets(request)
        await stream.send_message(response)

    async def __rpc_unreceived_acks(
        self,
        stream: "grpclib.server.Stream[QueryUnreceivedAcksRequest, QueryUnreceivedAcksResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.unreceived_acks(request)
        await stream.send_message(response)

    async def __rpc_next_sequence_receive(
        self,
        stream: "grpclib.server.Stream[QueryNextSequenceReceiveRequest, QueryNextSequenceReceiveResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.next_sequence_receive(request)
        await stream.send_message(response)

    async def __rpc_next_sequence_send(
        self,
        stream: "grpclib.server.Stream[QueryNextSequenceSendRequest, QueryNextSequenceSendResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.next_sequence_send(request)
        await stream.send_message(response)

    async def __rpc_upgrade_error(
        self,
        stream: "grpclib.server.Stream[QueryUpgradeErrorRequest, QueryUpgradeErrorResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.upgrade_error(request)
        await stream.send_message(response)

    async def __rpc_upgrade(
        self, stream: "grpclib.server.Stream[QueryUpgradeRequest, QueryUpgradeResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.upgrade(request)
        await stream.send_message(response)

    async def __rpc_channel_params(
        self,
        stream: "grpclib.server.Stream[QueryChannelParamsRequest, QueryChannelParamsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.channel_params(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/ibc.core.channel.v1.Query/Channel": grpclib.const.Handler(
                self.__rpc_channel,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryChannelRequest,
                QueryChannelResponse,
            ),
            "/ibc.core.channel.v1.Query/Channels": grpclib.const.Handler(
                self.__rpc_channels,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryChannelsRequest,
                QueryChannelsResponse,
            ),
            "/ibc.core.channel.v1.Query/ConnectionChannels": grpclib.const.Handler(
                self.__rpc_connection_channels,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryConnectionChannelsRequest,
                QueryConnectionChannelsResponse,
            ),
            "/ibc.core.channel.v1.Query/ChannelClientState": grpclib.const.Handler(
                self.__rpc_channel_client_state,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryChannelClientStateRequest,
                QueryChannelClientStateResponse,
            ),
            "/ibc.core.channel.v1.Query/ChannelConsensusState": grpclib.const.Handler(
                self.__rpc_channel_consensus_state,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryChannelConsensusStateRequest,
                QueryChannelConsensusStateResponse,
            ),
            "/ibc.core.channel.v1.Query/PacketCommitment": grpclib.const.Handler(
                self.__rpc_packet_commitment,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPacketCommitmentRequest,
                QueryPacketCommitmentResponse,
            ),
            "/ibc.core.channel.v1.Query/PacketCommitments": grpclib.const.Handler(
                self.__rpc_packet_commitments,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPacketCommitmentsRequest,
                QueryPacketCommitmentsResponse,
            ),
            "/ibc.core.channel.v1.Query/PacketReceipt": grpclib.const.Handler(
                self.__rpc_packet_receipt,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPacketReceiptRequest,
                QueryPacketReceiptResponse,
            ),
            "/ibc.core.channel.v1.Query/PacketAcknowledgement": grpclib.const.Handler(
                self.__rpc_packet_acknowledgement,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPacketAcknowledgementRequest,
                QueryPacketAcknowledgementResponse,
            ),
            "/ibc.core.channel.v1.Query/PacketAcknowledgements": grpclib.const.Handler(
                self.__rpc_packet_acknowledgements,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryPacketAcknowledgementsRequest,
                QueryPacketAcknowledgementsResponse,
            ),
            "/ibc.core.channel.v1.Query/UnreceivedPackets": grpclib.const.Handler(
                self.__rpc_unreceived_packets,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryUnreceivedPacketsRequest,
                QueryUnreceivedPacketsResponse,
            ),
            "/ibc.core.channel.v1.Query/UnreceivedAcks": grpclib.const.Handler(
                self.__rpc_unreceived_acks,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryUnreceivedAcksRequest,
                QueryUnreceivedAcksResponse,
            ),
            "/ibc.core.channel.v1.Query/NextSequenceReceive": grpclib.const.Handler(
                self.__rpc_next_sequence_receive,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryNextSequenceReceiveRequest,
                QueryNextSequenceReceiveResponse,
            ),
            "/ibc.core.channel.v1.Query/NextSequenceSend": grpclib.const.Handler(
                self.__rpc_next_sequence_send,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryNextSequenceSendRequest,
                QueryNextSequenceSendResponse,
            ),
            "/ibc.core.channel.v1.Query/UpgradeError": grpclib.const.Handler(
                self.__rpc_upgrade_error,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryUpgradeErrorRequest,
                QueryUpgradeErrorResponse,
            ),
            "/ibc.core.channel.v1.Query/Upgrade": grpclib.const.Handler(
                self.__rpc_upgrade,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryUpgradeRequest,
                QueryUpgradeResponse,
            ),
            "/ibc.core.channel.v1.Query/ChannelParams": grpclib.const.Handler(
                self.__rpc_channel_params,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryChannelParamsRequest,
                QueryChannelParamsResponse,
            ),
        }
