# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: ibc/lightclients/solomachine/v3/solomachine.proto
# plugin: python-betterproto
from dataclasses import dataclass

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf


@dataclass(eq=False, repr=False)
class ClientState(betterproto.Message):
    """
    ClientState defines a solo machine client that tracks the current consensus
    state and if the client is frozen.
    """

    sequence: int = betterproto.uint64_field(1)
    """latest sequence of the client state"""

    is_frozen: bool = betterproto.bool_field(2)
    """frozen sequence of the solo machine"""

    consensus_state: "ConsensusState" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class ConsensusState(betterproto.Message):
    """
    ConsensusState defines a solo machine consensus state. The sequence of a
    consensus state is contained in the "height" key used in storing the
    consensus state.
    """

    public_key: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(1)
    """public key of the solo machine"""

    diversifier: str = betterproto.string_field(2)
    """
    diversifier allows the same public key to be re-used across different solo
    machine clients (potentially on different chains) without being considered
    misbehaviour.
    """

    timestamp: int = betterproto.uint64_field(3)


@dataclass(eq=False, repr=False)
class Header(betterproto.Message):
    """Header defines a solo machine consensus header"""

    timestamp: int = betterproto.uint64_field(1)
    signature: bytes = betterproto.bytes_field(2)
    new_public_key: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(3)
    new_diversifier: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class Misbehaviour(betterproto.Message):
    """
    Misbehaviour defines misbehaviour for a solo machine which consists of a
    sequence and two signatures over different messages at that sequence.
    """

    sequence: int = betterproto.uint64_field(1)
    signature_one: "SignatureAndData" = betterproto.message_field(2)
    signature_two: "SignatureAndData" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class SignatureAndData(betterproto.Message):
    """
    SignatureAndData contains a signature and the data signed over to create
    that signature.
    """

    signature: bytes = betterproto.bytes_field(1)
    path: bytes = betterproto.bytes_field(2)
    data: bytes = betterproto.bytes_field(3)
    timestamp: int = betterproto.uint64_field(4)


@dataclass(eq=False, repr=False)
class TimestampedSignatureData(betterproto.Message):
    """
    TimestampedSignatureData contains the signature data and the timestamp of
    the signature.
    """

    signature_data: bytes = betterproto.bytes_field(1)
    timestamp: int = betterproto.uint64_field(2)


@dataclass(eq=False, repr=False)
class SignBytes(betterproto.Message):
    """SignBytes defines the signed bytes used for signature verification."""

    sequence: int = betterproto.uint64_field(1)
    """the sequence number"""

    timestamp: int = betterproto.uint64_field(2)
    """the proof timestamp"""

    diversifier: str = betterproto.string_field(3)
    """the public key diversifier"""

    path: bytes = betterproto.bytes_field(4)
    """the standardised path bytes"""

    data: bytes = betterproto.bytes_field(5)
    """the marshaled data bytes"""


@dataclass(eq=False, repr=False)
class HeaderData(betterproto.Message):
    """HeaderData returns the SignBytes data for update verification."""

    new_pub_key: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(1)
    """header public key"""

    new_diversifier: str = betterproto.string_field(2)
    """header diversifier"""
