# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: ibc-apps/packetforward/v1/genesis.proto, ibc-apps/packetforward/v1/query.proto, ibc-apps/packetforward/v1/tx.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


@dataclass(eq=False, repr=False)
class GenesisState(betterproto.Message):
    """GenesisState defines the packetforward genesis state"""

    params: "Params" = betterproto.message_field(1)
    in_flight_packets: Dict[str, "InFlightPacket"] = betterproto.map_field(
        2, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    """
    key - information about forwarded packet: src_channel
    (parsedReceiver.Channel), src_port (parsedReceiver.Port), sequence value -
    information about original packet for refunding if necessary: retries,
    srcPacketSender, srcPacket.DestinationChannel, srcPacket.DestinationPort
    """


@dataclass(eq=False, repr=False)
class Params(betterproto.Message):
    """Params defines the set of packetforward parameters."""

    fee_percentage: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class InFlightPacket(betterproto.Message):
    """
    InFlightPacket contains information about original packet for writing the
    acknowledgement and refunding if necessary.
    """

    original_sender_address: str = betterproto.string_field(1)
    refund_channel_id: str = betterproto.string_field(2)
    refund_port_id: str = betterproto.string_field(3)
    packet_src_channel_id: str = betterproto.string_field(4)
    packet_src_port_id: str = betterproto.string_field(5)
    packet_timeout_timestamp: int = betterproto.uint64_field(6)
    packet_timeout_height: str = betterproto.string_field(7)
    packet_data: bytes = betterproto.bytes_field(8)
    refund_sequence: int = betterproto.uint64_field(9)
    retries_remaining: int = betterproto.int32_field(10)
    timeout: int = betterproto.uint64_field(11)
    nonrefundable: bool = betterproto.bool_field(12)


@dataclass(eq=False, repr=False)
class MsgUpdateParams(betterproto.Message):
    """
    MsgUpdateParams is the Msg/UpdateParams request type. Since: cosmos-sdk
    0.47
    """

    authority: str = betterproto.string_field(1)
    """authority is the address of the governance account."""

    params: "Params" = betterproto.message_field(2)
    """
    params defines the x/packetforward parameters to update. NOTE: All
    parameters must be supplied.
    """


@dataclass(eq=False, repr=False)
class MsgUpdateParamsResponse(betterproto.Message):
    """
    MsgUpdateParamsResponse defines the response structure for executing a
    MsgUpdateParams message. Since: cosmos-sdk 0.47
    """

    pass


@dataclass(eq=False, repr=False)
class QueryParamsRequest(betterproto.Message):
    """
    QueryParamsRequest is the request type for the Query/Params RPC method.
    """

    pass


@dataclass(eq=False, repr=False)
class QueryParamsResponse(betterproto.Message):
    """
    QueryParamsResponse is the response type for the Query/Params RPC method.
    """

    params: "Params" = betterproto.message_field(1)
    """params defines the parameters of the module."""


class MsgStub(betterproto.ServiceStub):
    async def update_params(
        self,
        msg_update_params: "MsgUpdateParams",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MsgUpdateParamsResponse":
        return await self._unary_unary(
            "/packetforward.v1.Msg/UpdateParams",
            msg_update_params,
            MsgUpdateParamsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class QueryStub(betterproto.ServiceStub):
    async def params(
        self,
        query_params_request: "QueryParamsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryParamsResponse":
        return await self._unary_unary(
            "/packetforward.v1.Query/Params",
            query_params_request,
            QueryParamsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class MsgBase(ServiceBase):

    async def update_params(
        self, msg_update_params: "MsgUpdateParams"
    ) -> "MsgUpdateParamsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_update_params(
        self, stream: "grpclib.server.Stream[MsgUpdateParams, MsgUpdateParamsResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.update_params(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/packetforward.v1.Msg/UpdateParams": grpclib.const.Handler(
                self.__rpc_update_params,
                grpclib.const.Cardinality.UNARY_UNARY,
                MsgUpdateParams,
                MsgUpdateParamsResponse,
            ),
        }


class QueryBase(ServiceBase):

    async def params(
        self, query_params_request: "QueryParamsRequest"
    ) -> "QueryParamsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_params(
        self, stream: "grpclib.server.Stream[QueryParamsRequest, QueryParamsResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.params(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/packetforward.v1.Query/Params": grpclib.const.Handler(
                self.__rpc_params,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryParamsRequest,
                QueryParamsResponse,
            ),
        }
