# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: tendermint/abci/types.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import datetime
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from .. import (
    crypto as _crypto__,
    types as _types__,
)


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class CheckTxType(betterproto.Enum):
    NEW = 0
    RECHECK = 1


class MisbehaviorType(betterproto.Enum):
    UNKNOWN = 0
    DUPLICATE_VOTE = 1
    LIGHT_CLIENT_ATTACK = 2


class ResponseOfferSnapshotResult(betterproto.Enum):
    UNKNOWN = 0
    ACCEPT = 1
    ABORT = 2
    REJECT = 3
    REJECT_FORMAT = 4
    REJECT_SENDER = 5


class ResponseApplySnapshotChunkResult(betterproto.Enum):
    UNKNOWN = 0
    ACCEPT = 1
    ABORT = 2
    RETRY = 3
    RETRY_SNAPSHOT = 4
    REJECT_SNAPSHOT = 5


class ResponseProcessProposalProposalStatus(betterproto.Enum):
    UNKNOWN = 0
    ACCEPT = 1
    REJECT = 2


class ResponseVerifyVoteExtensionVerifyStatus(betterproto.Enum):
    UNKNOWN = 0
    ACCEPT = 1
    REJECT = 2
    """
    Rejecting the vote extension will reject the entire precommit by the
    sender. Incorrectly implementing this thus has liveness implications as it
    may affect CometBFT's ability to receive 2/3+ valid votes to finalize the
    block. Honest nodes should never be rejected.
    """


@dataclass(eq=False, repr=False)
class Request(betterproto.Message):
    echo: "RequestEcho" = betterproto.message_field(1, group="value")
    flush: "RequestFlush" = betterproto.message_field(2, group="value")
    info: "RequestInfo" = betterproto.message_field(3, group="value")
    init_chain: "RequestInitChain" = betterproto.message_field(5, group="value")
    query: "RequestQuery" = betterproto.message_field(6, group="value")
    check_tx: "RequestCheckTx" = betterproto.message_field(8, group="value")
    commit: "RequestCommit" = betterproto.message_field(11, group="value")
    list_snapshots: "RequestListSnapshots" = betterproto.message_field(
        12, group="value"
    )
    offer_snapshot: "RequestOfferSnapshot" = betterproto.message_field(
        13, group="value"
    )
    load_snapshot_chunk: "RequestLoadSnapshotChunk" = betterproto.message_field(
        14, group="value"
    )
    apply_snapshot_chunk: "RequestApplySnapshotChunk" = betterproto.message_field(
        15, group="value"
    )
    prepare_proposal: "RequestPrepareProposal" = betterproto.message_field(
        16, group="value"
    )
    process_proposal: "RequestProcessProposal" = betterproto.message_field(
        17, group="value"
    )
    extend_vote: "RequestExtendVote" = betterproto.message_field(18, group="value")
    verify_vote_extension: "RequestVerifyVoteExtension" = betterproto.message_field(
        19, group="value"
    )
    finalize_block: "RequestFinalizeBlock" = betterproto.message_field(
        20, group="value"
    )


@dataclass(eq=False, repr=False)
class RequestEcho(betterproto.Message):
    message: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class RequestFlush(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class RequestInfo(betterproto.Message):
    version: str = betterproto.string_field(1)
    block_version: int = betterproto.uint64_field(2)
    p2_p_version: int = betterproto.uint64_field(3)
    abci_version: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class RequestInitChain(betterproto.Message):
    time: datetime = betterproto.message_field(1)
    chain_id: str = betterproto.string_field(2)
    consensus_params: "_types__.ConsensusParams" = betterproto.message_field(3)
    validators: List["ValidatorUpdate"] = betterproto.message_field(4)
    app_state_bytes: bytes = betterproto.bytes_field(5)
    initial_height: int = betterproto.int64_field(6)


@dataclass(eq=False, repr=False)
class RequestQuery(betterproto.Message):
    data: bytes = betterproto.bytes_field(1)
    path: str = betterproto.string_field(2)
    height: int = betterproto.int64_field(3)
    prove: bool = betterproto.bool_field(4)


@dataclass(eq=False, repr=False)
class RequestCheckTx(betterproto.Message):
    tx: bytes = betterproto.bytes_field(1)
    type: "CheckTxType" = betterproto.enum_field(2)


@dataclass(eq=False, repr=False)
class RequestCommit(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class RequestListSnapshots(betterproto.Message):
    """lists available snapshots"""

    pass


@dataclass(eq=False, repr=False)
class RequestOfferSnapshot(betterproto.Message):
    """offers a snapshot to the application"""

    snapshot: "Snapshot" = betterproto.message_field(1)
    app_hash: bytes = betterproto.bytes_field(2)


@dataclass(eq=False, repr=False)
class RequestLoadSnapshotChunk(betterproto.Message):
    """loads a snapshot chunk"""

    height: int = betterproto.uint64_field(1)
    format: int = betterproto.uint32_field(2)
    chunk: int = betterproto.uint32_field(3)


@dataclass(eq=False, repr=False)
class RequestApplySnapshotChunk(betterproto.Message):
    """Applies a snapshot chunk"""

    index: int = betterproto.uint32_field(1)
    chunk: bytes = betterproto.bytes_field(2)
    sender: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class RequestPrepareProposal(betterproto.Message):
    max_tx_bytes: int = betterproto.int64_field(1)
    """the modified transactions cannot exceed this size."""

    txs: List[bytes] = betterproto.bytes_field(2)
    """
    txs is an array of transactions that will be included in a block, sent to
    the app for possible modifications.
    """

    local_last_commit: "ExtendedCommitInfo" = betterproto.message_field(3)
    misbehavior: List["Misbehavior"] = betterproto.message_field(4)
    height: int = betterproto.int64_field(5)
    time: datetime = betterproto.message_field(6)
    next_validators_hash: bytes = betterproto.bytes_field(7)
    proposer_address: bytes = betterproto.bytes_field(8)
    """address of the public key of the validator proposing the block."""


@dataclass(eq=False, repr=False)
class RequestProcessProposal(betterproto.Message):
    txs: List[bytes] = betterproto.bytes_field(1)
    proposed_last_commit: "CommitInfo" = betterproto.message_field(2)
    misbehavior: List["Misbehavior"] = betterproto.message_field(3)
    hash: bytes = betterproto.bytes_field(4)
    """hash is the merkle root hash of the fields of the proposed block."""

    height: int = betterproto.int64_field(5)
    time: datetime = betterproto.message_field(6)
    next_validators_hash: bytes = betterproto.bytes_field(7)
    proposer_address: bytes = betterproto.bytes_field(8)
    """address of the public key of the original proposer of the block."""


@dataclass(eq=False, repr=False)
class RequestExtendVote(betterproto.Message):
    """Extends a vote with application-injected data"""

    hash: bytes = betterproto.bytes_field(1)
    """the hash of the block that this vote may be referring to"""

    height: int = betterproto.int64_field(2)
    """the height of the extended vote"""

    time: datetime = betterproto.message_field(3)
    """info of the block that this vote may be referring to"""

    txs: List[bytes] = betterproto.bytes_field(4)
    proposed_last_commit: "CommitInfo" = betterproto.message_field(5)
    misbehavior: List["Misbehavior"] = betterproto.message_field(6)
    next_validators_hash: bytes = betterproto.bytes_field(7)
    proposer_address: bytes = betterproto.bytes_field(8)
    """address of the public key of the original proposer of the block."""


@dataclass(eq=False, repr=False)
class RequestVerifyVoteExtension(betterproto.Message):
    """Verify the vote extension"""

    hash: bytes = betterproto.bytes_field(1)
    """the hash of the block that this received vote corresponds to"""

    validator_address: bytes = betterproto.bytes_field(2)
    """the validator that signed the vote extension"""

    height: int = betterproto.int64_field(3)
    vote_extension: bytes = betterproto.bytes_field(4)


@dataclass(eq=False, repr=False)
class RequestFinalizeBlock(betterproto.Message):
    txs: List[bytes] = betterproto.bytes_field(1)
    decided_last_commit: "CommitInfo" = betterproto.message_field(2)
    misbehavior: List["Misbehavior"] = betterproto.message_field(3)
    hash: bytes = betterproto.bytes_field(4)
    """hash is the merkle root hash of the fields of the decided block."""

    height: int = betterproto.int64_field(5)
    time: datetime = betterproto.message_field(6)
    next_validators_hash: bytes = betterproto.bytes_field(7)
    proposer_address: bytes = betterproto.bytes_field(8)
    """
    proposer_address is the address of the public key of the original proposer
    of the block.
    """

    encrypted_random: "_types__.EncryptedRandom" = betterproto.message_field(9)
    commit: "_types__.Commit" = betterproto.message_field(10)


@dataclass(eq=False, repr=False)
class Response(betterproto.Message):
    exception: "ResponseException" = betterproto.message_field(1, group="value")
    echo: "ResponseEcho" = betterproto.message_field(2, group="value")
    flush: "ResponseFlush" = betterproto.message_field(3, group="value")
    info: "ResponseInfo" = betterproto.message_field(4, group="value")
    init_chain: "ResponseInitChain" = betterproto.message_field(6, group="value")
    query: "ResponseQuery" = betterproto.message_field(7, group="value")
    check_tx: "ResponseCheckTx" = betterproto.message_field(9, group="value")
    commit: "ResponseCommit" = betterproto.message_field(12, group="value")
    list_snapshots: "ResponseListSnapshots" = betterproto.message_field(
        13, group="value"
    )
    offer_snapshot: "ResponseOfferSnapshot" = betterproto.message_field(
        14, group="value"
    )
    load_snapshot_chunk: "ResponseLoadSnapshotChunk" = betterproto.message_field(
        15, group="value"
    )
    apply_snapshot_chunk: "ResponseApplySnapshotChunk" = betterproto.message_field(
        16, group="value"
    )
    prepare_proposal: "ResponsePrepareProposal" = betterproto.message_field(
        17, group="value"
    )
    process_proposal: "ResponseProcessProposal" = betterproto.message_field(
        18, group="value"
    )
    extend_vote: "ResponseExtendVote" = betterproto.message_field(19, group="value")
    verify_vote_extension: "ResponseVerifyVoteExtension" = betterproto.message_field(
        20, group="value"
    )
    finalize_block: "ResponseFinalizeBlock" = betterproto.message_field(
        21, group="value"
    )


@dataclass(eq=False, repr=False)
class ResponseException(betterproto.Message):
    """nondeterministic"""

    error: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ResponseEcho(betterproto.Message):
    message: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ResponseFlush(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ResponseInfo(betterproto.Message):
    data: str = betterproto.string_field(1)
    version: str = betterproto.string_field(2)
    app_version: int = betterproto.uint64_field(3)
    last_block_height: int = betterproto.int64_field(4)
    last_block_app_hash: bytes = betterproto.bytes_field(5)


@dataclass(eq=False, repr=False)
class ResponseInitChain(betterproto.Message):
    consensus_params: "_types__.ConsensusParams" = betterproto.message_field(1)
    validators: List["ValidatorUpdate"] = betterproto.message_field(2)
    app_hash: bytes = betterproto.bytes_field(3)


@dataclass(eq=False, repr=False)
class ResponseQuery(betterproto.Message):
    code: int = betterproto.uint32_field(1)
    log: str = betterproto.string_field(3)
    """bytes data = 2; // use "value" instead."""

    info: str = betterproto.string_field(4)
    index: int = betterproto.int64_field(5)
    key: bytes = betterproto.bytes_field(6)
    value: bytes = betterproto.bytes_field(7)
    proof_ops: "_crypto__.ProofOps" = betterproto.message_field(8)
    height: int = betterproto.int64_field(9)
    codespace: str = betterproto.string_field(10)


@dataclass(eq=False, repr=False)
class ResponseCheckTx(betterproto.Message):
    code: int = betterproto.uint32_field(1)
    data: bytes = betterproto.bytes_field(2)
    log: str = betterproto.string_field(3)
    info: str = betterproto.string_field(4)
    gas_wanted: int = betterproto.int64_field(5)
    gas_used: int = betterproto.int64_field(6)
    events: List["Event"] = betterproto.message_field(7)
    codespace: str = betterproto.string_field(8)


@dataclass(eq=False, repr=False)
class ResponseCommit(betterproto.Message):
    retain_height: int = betterproto.int64_field(3)


@dataclass(eq=False, repr=False)
class ResponseListSnapshots(betterproto.Message):
    snapshots: List["Snapshot"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ResponseOfferSnapshot(betterproto.Message):
    result: "ResponseOfferSnapshotResult" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class ResponseLoadSnapshotChunk(betterproto.Message):
    chunk: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class ResponseApplySnapshotChunk(betterproto.Message):
    result: "ResponseApplySnapshotChunkResult" = betterproto.enum_field(1)
    refetch_chunks: List[int] = betterproto.uint32_field(2)
    reject_senders: List[str] = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class ResponsePrepareProposal(betterproto.Message):
    txs: List[bytes] = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class ResponseProcessProposal(betterproto.Message):
    status: "ResponseProcessProposalProposalStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class ResponseExtendVote(betterproto.Message):
    vote_extension: bytes = betterproto.bytes_field(1)


@dataclass(eq=False, repr=False)
class ResponseVerifyVoteExtension(betterproto.Message):
    status: "ResponseVerifyVoteExtensionVerifyStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class ResponseFinalizeBlock(betterproto.Message):
    events: List["Event"] = betterproto.message_field(1)
    """set of block events emmitted as part of executing the block"""

    tx_results: List["ExecTxResult"] = betterproto.message_field(2)
    """
    the result of executing each transaction including the events the
    particular transction emitted. This should match the order of the
    transactions delivered in the block itself
    """

    validator_updates: List["ValidatorUpdate"] = betterproto.message_field(3)
    """
    a list of updates to the validator set. These will reflect the validator
    set at current height + 2.
    """

    consensus_param_updates: "_types__.ConsensusParams" = betterproto.message_field(4)
    """updates to the consensus params, if any."""

    app_hash: bytes = betterproto.bytes_field(5)
    """
    app_hash is the hash of the applications' state which is used to confirm
    that execution of the transactions was deterministic. It is up to the
    application to decide which algorithm to use.
    """


@dataclass(eq=False, repr=False)
class CommitInfo(betterproto.Message):
    round: int = betterproto.int32_field(1)
    votes: List["VoteInfo"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class ExtendedCommitInfo(betterproto.Message):
    """
    ExtendedCommitInfo is similar to CommitInfo except that it is only used in
    the PrepareProposal request such that CometBFT can provide vote extensions
    to the application.
    """

    round: int = betterproto.int32_field(1)
    """
    The round at which the block proposer decided in the previous height.
    """

    votes: List["ExtendedVoteInfo"] = betterproto.message_field(2)
    """
    List of validators' addresses in the last validator set with their voting
    information, including vote extensions.
    """


@dataclass(eq=False, repr=False)
class Event(betterproto.Message):
    """
    Event allows application developers to attach additional information to
    ResponseFinalizeBlock and ResponseCheckTx. Later, transactions may be
    queried using these events.
    """

    type: str = betterproto.string_field(1)
    attributes: List["EventAttribute"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class EventAttribute(betterproto.Message):
    """EventAttribute is a single key-value pair, associated with an event."""

    key: str = betterproto.string_field(1)
    value: str = betterproto.string_field(2)
    index: bool = betterproto.bool_field(3)


@dataclass(eq=False, repr=False)
class ExecTxResult(betterproto.Message):
    """
    ExecTxResult contains results of executing one individual transaction. *
    Its structure is equivalent to #ResponseDeliverTx which will be
    deprecated/deleted
    """

    code: int = betterproto.uint32_field(1)
    data: bytes = betterproto.bytes_field(2)
    log: str = betterproto.string_field(3)
    info: str = betterproto.string_field(4)
    gas_wanted: int = betterproto.int64_field(5)
    gas_used: int = betterproto.int64_field(6)
    events: List["Event"] = betterproto.message_field(7)
    codespace: str = betterproto.string_field(8)


@dataclass(eq=False, repr=False)
class TxResult(betterproto.Message):
    """
    TxResult contains results of executing the transaction. One usage is
    indexing transaction results.
    """

    height: int = betterproto.int64_field(1)
    index: int = betterproto.uint32_field(2)
    tx: bytes = betterproto.bytes_field(3)
    result: "ExecTxResult" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class Validator(betterproto.Message):
    address: bytes = betterproto.bytes_field(1)
    power: int = betterproto.int64_field(3)
    """PubKey pub_key = 2 [(gogoproto.nullable)=false];"""


@dataclass(eq=False, repr=False)
class ValidatorUpdate(betterproto.Message):
    pub_key: "_crypto__.PublicKey" = betterproto.message_field(1)
    power: int = betterproto.int64_field(2)


@dataclass(eq=False, repr=False)
class VoteInfo(betterproto.Message):
    validator: "Validator" = betterproto.message_field(1)
    block_id_flag: "_types__.BlockIdFlag" = betterproto.enum_field(3)


@dataclass(eq=False, repr=False)
class ExtendedVoteInfo(betterproto.Message):
    validator: "Validator" = betterproto.message_field(1)
    """The validator that sent the vote."""

    vote_extension: bytes = betterproto.bytes_field(3)
    """
    Non-deterministic extension provided by the sending validator's
    application.
    """

    extension_signature: bytes = betterproto.bytes_field(4)
    """Vote extension signature created by CometBFT"""

    block_id_flag: "_types__.BlockIdFlag" = betterproto.enum_field(5)
    """
    block_id_flag indicates whether the validator voted for a block, nil, or
    did not vote at all
    """


@dataclass(eq=False, repr=False)
class Misbehavior(betterproto.Message):
    type: "MisbehaviorType" = betterproto.enum_field(1)
    validator: "Validator" = betterproto.message_field(2)
    """The offending validator"""

    height: int = betterproto.int64_field(3)
    """The height when the offense occurred"""

    time: datetime = betterproto.message_field(4)
    """The corresponding time where the offense occurred"""

    total_voting_power: int = betterproto.int64_field(5)
    """
    Total voting power of the validator set in case the ABCI application does
    not store historical validators.
    https://github.com/tendermint/tendermint/issues/4581
    """


@dataclass(eq=False, repr=False)
class Snapshot(betterproto.Message):
    height: int = betterproto.uint64_field(1)
    format: int = betterproto.uint32_field(2)
    chunks: int = betterproto.uint32_field(3)
    hash: bytes = betterproto.bytes_field(4)
    metadata: bytes = betterproto.bytes_field(5)


class AbciStub(betterproto.ServiceStub):
    async def echo(
        self,
        request_echo: "RequestEcho",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ResponseEcho":
        return await self._unary_unary(
            "/tendermint.abci.ABCI/Echo",
            request_echo,
            ResponseEcho,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def flush(
        self,
        request_flush: "RequestFlush",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ResponseFlush":
        return await self._unary_unary(
            "/tendermint.abci.ABCI/Flush",
            request_flush,
            ResponseFlush,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def info(
        self,
        request_info: "RequestInfo",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ResponseInfo":
        return await self._unary_unary(
            "/tendermint.abci.ABCI/Info",
            request_info,
            ResponseInfo,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def check_tx(
        self,
        request_check_tx: "RequestCheckTx",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ResponseCheckTx":
        return await self._unary_unary(
            "/tendermint.abci.ABCI/CheckTx",
            request_check_tx,
            ResponseCheckTx,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def query(
        self,
        request_query: "RequestQuery",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ResponseQuery":
        return await self._unary_unary(
            "/tendermint.abci.ABCI/Query",
            request_query,
            ResponseQuery,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def commit(
        self,
        request_commit: "RequestCommit",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ResponseCommit":
        return await self._unary_unary(
            "/tendermint.abci.ABCI/Commit",
            request_commit,
            ResponseCommit,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def init_chain(
        self,
        request_init_chain: "RequestInitChain",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ResponseInitChain":
        return await self._unary_unary(
            "/tendermint.abci.ABCI/InitChain",
            request_init_chain,
            ResponseInitChain,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def list_snapshots(
        self,
        request_list_snapshots: "RequestListSnapshots",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ResponseListSnapshots":
        return await self._unary_unary(
            "/tendermint.abci.ABCI/ListSnapshots",
            request_list_snapshots,
            ResponseListSnapshots,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def offer_snapshot(
        self,
        request_offer_snapshot: "RequestOfferSnapshot",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ResponseOfferSnapshot":
        return await self._unary_unary(
            "/tendermint.abci.ABCI/OfferSnapshot",
            request_offer_snapshot,
            ResponseOfferSnapshot,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def load_snapshot_chunk(
        self,
        request_load_snapshot_chunk: "RequestLoadSnapshotChunk",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ResponseLoadSnapshotChunk":
        return await self._unary_unary(
            "/tendermint.abci.ABCI/LoadSnapshotChunk",
            request_load_snapshot_chunk,
            ResponseLoadSnapshotChunk,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def apply_snapshot_chunk(
        self,
        request_apply_snapshot_chunk: "RequestApplySnapshotChunk",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ResponseApplySnapshotChunk":
        return await self._unary_unary(
            "/tendermint.abci.ABCI/ApplySnapshotChunk",
            request_apply_snapshot_chunk,
            ResponseApplySnapshotChunk,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def prepare_proposal(
        self,
        request_prepare_proposal: "RequestPrepareProposal",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ResponsePrepareProposal":
        return await self._unary_unary(
            "/tendermint.abci.ABCI/PrepareProposal",
            request_prepare_proposal,
            ResponsePrepareProposal,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def process_proposal(
        self,
        request_process_proposal: "RequestProcessProposal",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ResponseProcessProposal":
        return await self._unary_unary(
            "/tendermint.abci.ABCI/ProcessProposal",
            request_process_proposal,
            ResponseProcessProposal,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def extend_vote(
        self,
        request_extend_vote: "RequestExtendVote",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ResponseExtendVote":
        return await self._unary_unary(
            "/tendermint.abci.ABCI/ExtendVote",
            request_extend_vote,
            ResponseExtendVote,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def verify_vote_extension(
        self,
        request_verify_vote_extension: "RequestVerifyVoteExtension",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ResponseVerifyVoteExtension":
        return await self._unary_unary(
            "/tendermint.abci.ABCI/VerifyVoteExtension",
            request_verify_vote_extension,
            ResponseVerifyVoteExtension,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def finalize_block(
        self,
        request_finalize_block: "RequestFinalizeBlock",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ResponseFinalizeBlock":
        return await self._unary_unary(
            "/tendermint.abci.ABCI/FinalizeBlock",
            request_finalize_block,
            ResponseFinalizeBlock,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class AbciBase(ServiceBase):

    async def echo(self, request_echo: "RequestEcho") -> "ResponseEcho":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def flush(self, request_flush: "RequestFlush") -> "ResponseFlush":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def info(self, request_info: "RequestInfo") -> "ResponseInfo":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def check_tx(self, request_check_tx: "RequestCheckTx") -> "ResponseCheckTx":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def query(self, request_query: "RequestQuery") -> "ResponseQuery":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def commit(self, request_commit: "RequestCommit") -> "ResponseCommit":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def init_chain(
        self, request_init_chain: "RequestInitChain"
    ) -> "ResponseInitChain":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list_snapshots(
        self, request_list_snapshots: "RequestListSnapshots"
    ) -> "ResponseListSnapshots":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def offer_snapshot(
        self, request_offer_snapshot: "RequestOfferSnapshot"
    ) -> "ResponseOfferSnapshot":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def load_snapshot_chunk(
        self, request_load_snapshot_chunk: "RequestLoadSnapshotChunk"
    ) -> "ResponseLoadSnapshotChunk":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def apply_snapshot_chunk(
        self, request_apply_snapshot_chunk: "RequestApplySnapshotChunk"
    ) -> "ResponseApplySnapshotChunk":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def prepare_proposal(
        self, request_prepare_proposal: "RequestPrepareProposal"
    ) -> "ResponsePrepareProposal":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def process_proposal(
        self, request_process_proposal: "RequestProcessProposal"
    ) -> "ResponseProcessProposal":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def extend_vote(
        self, request_extend_vote: "RequestExtendVote"
    ) -> "ResponseExtendVote":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def verify_vote_extension(
        self, request_verify_vote_extension: "RequestVerifyVoteExtension"
    ) -> "ResponseVerifyVoteExtension":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def finalize_block(
        self, request_finalize_block: "RequestFinalizeBlock"
    ) -> "ResponseFinalizeBlock":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_echo(
        self, stream: "grpclib.server.Stream[RequestEcho, ResponseEcho]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.echo(request)
        await stream.send_message(response)

    async def __rpc_flush(
        self, stream: "grpclib.server.Stream[RequestFlush, ResponseFlush]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.flush(request)
        await stream.send_message(response)

    async def __rpc_info(
        self, stream: "grpclib.server.Stream[RequestInfo, ResponseInfo]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.info(request)
        await stream.send_message(response)

    async def __rpc_check_tx(
        self, stream: "grpclib.server.Stream[RequestCheckTx, ResponseCheckTx]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.check_tx(request)
        await stream.send_message(response)

    async def __rpc_query(
        self, stream: "grpclib.server.Stream[RequestQuery, ResponseQuery]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.query(request)
        await stream.send_message(response)

    async def __rpc_commit(
        self, stream: "grpclib.server.Stream[RequestCommit, ResponseCommit]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.commit(request)
        await stream.send_message(response)

    async def __rpc_init_chain(
        self, stream: "grpclib.server.Stream[RequestInitChain, ResponseInitChain]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.init_chain(request)
        await stream.send_message(response)

    async def __rpc_list_snapshots(
        self,
        stream: "grpclib.server.Stream[RequestListSnapshots, ResponseListSnapshots]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.list_snapshots(request)
        await stream.send_message(response)

    async def __rpc_offer_snapshot(
        self,
        stream: "grpclib.server.Stream[RequestOfferSnapshot, ResponseOfferSnapshot]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.offer_snapshot(request)
        await stream.send_message(response)

    async def __rpc_load_snapshot_chunk(
        self,
        stream: "grpclib.server.Stream[RequestLoadSnapshotChunk, ResponseLoadSnapshotChunk]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.load_snapshot_chunk(request)
        await stream.send_message(response)

    async def __rpc_apply_snapshot_chunk(
        self,
        stream: "grpclib.server.Stream[RequestApplySnapshotChunk, ResponseApplySnapshotChunk]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.apply_snapshot_chunk(request)
        await stream.send_message(response)

    async def __rpc_prepare_proposal(
        self,
        stream: "grpclib.server.Stream[RequestPrepareProposal, ResponsePrepareProposal]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.prepare_proposal(request)
        await stream.send_message(response)

    async def __rpc_process_proposal(
        self,
        stream: "grpclib.server.Stream[RequestProcessProposal, ResponseProcessProposal]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.process_proposal(request)
        await stream.send_message(response)

    async def __rpc_extend_vote(
        self, stream: "grpclib.server.Stream[RequestExtendVote, ResponseExtendVote]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.extend_vote(request)
        await stream.send_message(response)

    async def __rpc_verify_vote_extension(
        self,
        stream: "grpclib.server.Stream[RequestVerifyVoteExtension, ResponseVerifyVoteExtension]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.verify_vote_extension(request)
        await stream.send_message(response)

    async def __rpc_finalize_block(
        self,
        stream: "grpclib.server.Stream[RequestFinalizeBlock, ResponseFinalizeBlock]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.finalize_block(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/tendermint.abci.ABCI/Echo": grpclib.const.Handler(
                self.__rpc_echo,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestEcho,
                ResponseEcho,
            ),
            "/tendermint.abci.ABCI/Flush": grpclib.const.Handler(
                self.__rpc_flush,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestFlush,
                ResponseFlush,
            ),
            "/tendermint.abci.ABCI/Info": grpclib.const.Handler(
                self.__rpc_info,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestInfo,
                ResponseInfo,
            ),
            "/tendermint.abci.ABCI/CheckTx": grpclib.const.Handler(
                self.__rpc_check_tx,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestCheckTx,
                ResponseCheckTx,
            ),
            "/tendermint.abci.ABCI/Query": grpclib.const.Handler(
                self.__rpc_query,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestQuery,
                ResponseQuery,
            ),
            "/tendermint.abci.ABCI/Commit": grpclib.const.Handler(
                self.__rpc_commit,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestCommit,
                ResponseCommit,
            ),
            "/tendermint.abci.ABCI/InitChain": grpclib.const.Handler(
                self.__rpc_init_chain,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestInitChain,
                ResponseInitChain,
            ),
            "/tendermint.abci.ABCI/ListSnapshots": grpclib.const.Handler(
                self.__rpc_list_snapshots,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestListSnapshots,
                ResponseListSnapshots,
            ),
            "/tendermint.abci.ABCI/OfferSnapshot": grpclib.const.Handler(
                self.__rpc_offer_snapshot,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestOfferSnapshot,
                ResponseOfferSnapshot,
            ),
            "/tendermint.abci.ABCI/LoadSnapshotChunk": grpclib.const.Handler(
                self.__rpc_load_snapshot_chunk,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestLoadSnapshotChunk,
                ResponseLoadSnapshotChunk,
            ),
            "/tendermint.abci.ABCI/ApplySnapshotChunk": grpclib.const.Handler(
                self.__rpc_apply_snapshot_chunk,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestApplySnapshotChunk,
                ResponseApplySnapshotChunk,
            ),
            "/tendermint.abci.ABCI/PrepareProposal": grpclib.const.Handler(
                self.__rpc_prepare_proposal,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestPrepareProposal,
                ResponsePrepareProposal,
            ),
            "/tendermint.abci.ABCI/ProcessProposal": grpclib.const.Handler(
                self.__rpc_process_proposal,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestProcessProposal,
                ResponseProcessProposal,
            ),
            "/tendermint.abci.ABCI/ExtendVote": grpclib.const.Handler(
                self.__rpc_extend_vote,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestExtendVote,
                ResponseExtendVote,
            ),
            "/tendermint.abci.ABCI/VerifyVoteExtension": grpclib.const.Handler(
                self.__rpc_verify_vote_extension,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestVerifyVoteExtension,
                ResponseVerifyVoteExtension,
            ),
            "/tendermint.abci.ABCI/FinalizeBlock": grpclib.const.Handler(
                self.__rpc_finalize_block,
                grpclib.const.Cardinality.UNARY_UNARY,
                RequestFinalizeBlock,
                ResponseFinalizeBlock,
            ),
        }
