# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: tendermint/state/types.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import datetime
from typing import List

import betterproto

from .. import (
    abci as _abci__,
    types as _types__,
    version as _version__,
)


@dataclass(eq=False, repr=False)
class LegacyAbciResponses(betterproto.Message):
    """
    LegacyABCIResponses retains the responses of the legacy ABCI calls during
    block processing. Note ReponseDeliverTx is renamed to ExecTxResult but they
    are semantically the same Kept for backwards compatibility for versions
    prior to v0.38
    """

    deliver_txs: List["_abci__.ExecTxResult"] = betterproto.message_field(1)
    end_block: "ResponseEndBlock" = betterproto.message_field(2)
    begin_block: "ResponseBeginBlock" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class ResponseBeginBlock(betterproto.Message):
    """
    ResponseBeginBlock is kept for backwards compatibility for versions prior
    to v0.38
    """

    events: List["_abci__.Event"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ResponseEndBlock(betterproto.Message):
    """
    ResponseEndBlock is kept for backwards compatibility for versions prior to
    v0.38
    """

    validator_updates: List["_abci__.ValidatorUpdate"] = betterproto.message_field(1)
    consensus_param_updates: "_types__.ConsensusParams" = betterproto.message_field(2)
    events: List["_abci__.Event"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class ValidatorsInfo(betterproto.Message):
    """
    ValidatorsInfo represents the latest validator set, or the last height it
    changed
    """

    validator_set: "_types__.ValidatorSet" = betterproto.message_field(1)
    last_height_changed: int = betterproto.int64_field(2)


@dataclass(eq=False, repr=False)
class ConsensusParamsInfo(betterproto.Message):
    """
    ConsensusParamsInfo represents the latest consensus params, or the last
    height it changed
    """

    consensus_params: "_types__.ConsensusParams" = betterproto.message_field(1)
    last_height_changed: int = betterproto.int64_field(2)


@dataclass(eq=False, repr=False)
class AbciResponsesInfo(betterproto.Message):
    legacy_abci_responses: "LegacyAbciResponses" = betterproto.message_field(1)
    height: int = betterproto.int64_field(2)
    response_finalize_block: "_abci__.ResponseFinalizeBlock" = (
        betterproto.message_field(3)
    )


@dataclass(eq=False, repr=False)
class Version(betterproto.Message):
    consensus: "_version__.Consensus" = betterproto.message_field(1)
    software: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class State(betterproto.Message):
    version: "Version" = betterproto.message_field(1)
    chain_id: str = betterproto.string_field(2)
    """immutable"""

    initial_height: int = betterproto.int64_field(14)
    last_block_height: int = betterproto.int64_field(3)
    """LastBlockHeight=0 at genesis (ie. block(H=0) does not exist)"""

    last_block_id: "_types__.BlockId" = betterproto.message_field(4)
    last_block_time: datetime = betterproto.message_field(5)
    next_validators: "_types__.ValidatorSet" = betterproto.message_field(6)
    """
    LastValidators is used to validate block.LastCommit. Validators are
    persisted to the database separately every time they change, so we can
    query for historical validator sets. Note that if s.LastBlockHeight causes
    a valset change, we set s.LastHeightValidatorsChanged = s.LastBlockHeight +
    1 + 1 Extra +1 due to nextValSet delay.
    """

    validators: "_types__.ValidatorSet" = betterproto.message_field(7)
    last_validators: "_types__.ValidatorSet" = betterproto.message_field(8)
    last_height_validators_changed: int = betterproto.int64_field(9)
    consensus_params: "_types__.ConsensusParams" = betterproto.message_field(10)
    """
    Consensus parameters used for validating blocks. Changes returned by
    EndBlock and updated after Commit.
    """

    last_height_consensus_params_changed: int = betterproto.int64_field(11)
    last_results_hash: bytes = betterproto.bytes_field(12)
    """Merkle root of the results from executing prev block"""

    app_hash: bytes = betterproto.bytes_field(13)
    """the latest AppHash we've received from calling abci.Commit()"""
