# cosmotech-api
Cosmo Tech Platform API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 5.0.1-SNAPSHOT
- Package version: 1.0.0
- Generator version: 7.13.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://github.com/Cosmo-Tech/cosmotech-api](https://github.com/Cosmo-Tech/cosmotech-api)

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import cosmotech_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import cosmotech_api
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import cosmotech_api
from cosmotech_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost:8080
# See configuration.py for a list of all supported configuration parameters.
configuration = cosmotech_api.Configuration(
    host = "http://localhost:8080"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]


# Enter a context with an instance of the API client
with cosmotech_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cosmotech_api.DatasetApi(api_client)
    organization_id = 'organization_id_example' # str | the Organization identifier
    workspace_id = 'workspace_id_example' # str | the Workspace identifier
    dataset_create_request = cosmotech_api.DatasetCreateRequest() # DatasetCreateRequest | 
    files = None # List[bytearray] | Notes:   - Each parts defined in dataset should have a file defined in this list   - Please ensure that upload files order match with data parts list defined     - First file uploaded will match with first dataset parts and so on  (optional)

    try:
        # Create a Dataset
        api_response = api_instance.create_dataset(organization_id, workspace_id, dataset_create_request, files=files)
        print("The response of DatasetApi->create_dataset:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DatasetApi->create_dataset: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8080*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DatasetApi* | [**create_dataset**](docs/DatasetApi.md#create_dataset) | **POST** /organizations/{organization_id}/workspaces/{workspace_id}/datasets | Create a Dataset
*DatasetApi* | [**create_dataset_access_control**](docs/DatasetApi.md#create_dataset_access_control) | **POST** /organizations/{organization_id}/workspaces/{workspace_id}/datasets/{dataset_id}/security/access | Add a control access to the Dataset
*DatasetApi* | [**create_dataset_part**](docs/DatasetApi.md#create_dataset_part) | **POST** /organizations/{organization_id}/workspaces/{workspace_id}/datasets/{dataset_id}/parts | Create a data part of a Dataset
*DatasetApi* | [**delete_dataset**](docs/DatasetApi.md#delete_dataset) | **DELETE** /organizations/{organization_id}/workspaces/{workspace_id}/datasets/{dataset_id} | Delete a Dataset
*DatasetApi* | [**delete_dataset_access_control**](docs/DatasetApi.md#delete_dataset_access_control) | **DELETE** /organizations/{organization_id}/workspaces/{workspace_id}/datasets/{dataset_id}/security/access/{identity_id} | Remove the specified access from the given Dataset
*DatasetApi* | [**delete_dataset_part**](docs/DatasetApi.md#delete_dataset_part) | **DELETE** /organizations/{organization_id}/workspaces/{workspace_id}/datasets/{dataset_id}/parts/{dataset_part_id} | Delete a Dataset part
*DatasetApi* | [**download_dataset_part**](docs/DatasetApi.md#download_dataset_part) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/datasets/{dataset_id}/parts/{dataset_part_id}/download | Download data from a dataset part
*DatasetApi* | [**get_dataset**](docs/DatasetApi.md#get_dataset) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/datasets/{dataset_id} | Retrieve a Dataset
*DatasetApi* | [**get_dataset_access_control**](docs/DatasetApi.md#get_dataset_access_control) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/datasets/{dataset_id}/security/access/{identity_id} | Get a control access for the Dataset
*DatasetApi* | [**get_dataset_part**](docs/DatasetApi.md#get_dataset_part) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/datasets/{dataset_id}/parts/{dataset_part_id} | Retrieve a data part of a Dataset
*DatasetApi* | [**list_dataset_parts**](docs/DatasetApi.md#list_dataset_parts) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/datasets/{dataset_id}/parts | Retrieve all dataset parts of a Dataset
*DatasetApi* | [**list_dataset_security_users**](docs/DatasetApi.md#list_dataset_security_users) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/datasets/{dataset_id}/security/users | Get the Dataset security users list
*DatasetApi* | [**list_datasets**](docs/DatasetApi.md#list_datasets) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/datasets | Retrieve a list of defined Dataset
*DatasetApi* | [**query_data**](docs/DatasetApi.md#query_data) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/datasets/{dataset_id}/parts/{dataset_part_id}/query | Get data of a Dataset
*DatasetApi* | [**replace_dataset_part**](docs/DatasetApi.md#replace_dataset_part) | **PUT** /organizations/{organization_id}/workspaces/{workspace_id}/datasets/{dataset_id}/parts/{dataset_part_id} | Replace existing dataset parts of a Dataset
*DatasetApi* | [**search_dataset_parts**](docs/DatasetApi.md#search_dataset_parts) | **POST** /organizations/{organization_id}/workspaces/{workspace_id}/datasets/{dataset_id}/parts/search | Search Dataset parts by tags
*DatasetApi* | [**search_datasets**](docs/DatasetApi.md#search_datasets) | **POST** /organizations/{organization_id}/workspaces/{workspace_id}/datasets/search | Search Datasets by tags
*DatasetApi* | [**update_dataset**](docs/DatasetApi.md#update_dataset) | **PATCH** /organizations/{organization_id}/workspaces/{workspace_id}/datasets/{dataset_id} | Update a Dataset
*DatasetApi* | [**update_dataset_access_control**](docs/DatasetApi.md#update_dataset_access_control) | **PATCH** /organizations/{organization_id}/workspaces/{workspace_id}/datasets/{dataset_id}/security/access/{identity_id} | Update the specified access to User for a Dataset
*DatasetApi* | [**update_dataset_default_security**](docs/DatasetApi.md#update_dataset_default_security) | **PATCH** /organizations/{organization_id}/workspaces/{workspace_id}/datasets/{dataset_id}/security/default | Set the Dataset default security
*DatasetApi* | [**update_dataset_part**](docs/DatasetApi.md#update_dataset_part) | **PATCH** /organizations/{organization_id}/workspaces/{workspace_id}/datasets/{dataset_id}/parts/{dataset_part_id} | Update existing dataset parts information of a Dataset
*MetaApi* | [**about**](docs/MetaApi.md#about) | **GET** /about | Get various information about the API
*OrganizationApi* | [**create_organization**](docs/OrganizationApi.md#create_organization) | **POST** /organizations | Create a new organization
*OrganizationApi* | [**create_organization_access_control**](docs/OrganizationApi.md#create_organization_access_control) | **POST** /organizations/{organization_id}/security/access | Add a control access to the Organization
*OrganizationApi* | [**delete_organization**](docs/OrganizationApi.md#delete_organization) | **DELETE** /organizations/{organization_id} | Delete an organization
*OrganizationApi* | [**delete_organization_access_control**](docs/OrganizationApi.md#delete_organization_access_control) | **DELETE** /organizations/{organization_id}/security/access/{identity_id} | Remove the specified access from the given Organization
*OrganizationApi* | [**get_organization**](docs/OrganizationApi.md#get_organization) | **GET** /organizations/{organization_id} | Get the details of an Organization
*OrganizationApi* | [**get_organization_access_control**](docs/OrganizationApi.md#get_organization_access_control) | **GET** /organizations/{organization_id}/security/access/{identity_id} | Get a control access for the Organization
*OrganizationApi* | [**get_organization_permissions**](docs/OrganizationApi.md#get_organization_permissions) | **GET** /organizations/{organization_id}/permissions/{role} | Get the Organization permissions by given role
*OrganizationApi* | [**get_organization_security**](docs/OrganizationApi.md#get_organization_security) | **GET** /organizations/{organization_id}/security | Get the Organization security information
*OrganizationApi* | [**list_organization_security_users**](docs/OrganizationApi.md#list_organization_security_users) | **GET** /organizations/{organization_id}/security/users | Get the Organization security users list
*OrganizationApi* | [**list_organizations**](docs/OrganizationApi.md#list_organizations) | **GET** /organizations | List all Organizations
*OrganizationApi* | [**list_permissions**](docs/OrganizationApi.md#list_permissions) | **GET** /organizations/permissions | Get all permissions per components
*OrganizationApi* | [**update_organization**](docs/OrganizationApi.md#update_organization) | **PATCH** /organizations/{organization_id} | Update an Organization
*OrganizationApi* | [**update_organization_access_control**](docs/OrganizationApi.md#update_organization_access_control) | **PATCH** /organizations/{organization_id}/security/access/{identity_id} | Update the specified access to User for an Organization
*OrganizationApi* | [**update_organization_default_security**](docs/OrganizationApi.md#update_organization_default_security) | **PATCH** /organizations/{organization_id}/security/default | Update the Organization default security
*RunApi* | [**delete_run**](docs/RunApi.md#delete_run) | **DELETE** /organizations/{organization_id}/workspaces/{workspace_id}/runners/{runner_id}/runs/{run_id} | Delete a run
*RunApi* | [**get_run**](docs/RunApi.md#get_run) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/runners/{runner_id}/runs/{run_id} | Get the details of a run
*RunApi* | [**get_run_logs**](docs/RunApi.md#get_run_logs) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/runners/{runner_id}/runs/{run_id}/logs | get the logs for the Run
*RunApi* | [**get_run_status**](docs/RunApi.md#get_run_status) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/runners/{runner_id}/runs/{run_id}/status | get the status for the Run
*RunApi* | [**list_runs**](docs/RunApi.md#list_runs) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/runners/{runner_id}/runs | get the list of Runs for the Runner
*RunApi* | [**query_run_data**](docs/RunApi.md#query_run_data) | **POST** /organizations/{organization_id}/workspaces/{workspace_id}/runners/{runner_id}/runs/{run_id}/data/query | query the run data
*RunApi* | [**send_run_data**](docs/RunApi.md#send_run_data) | **POST** /organizations/{organization_id}/workspaces/{workspace_id}/runners/{runner_id}/runs/{run_id}/data/send | Send data associated to a run
*RunnerApi* | [**create_runner**](docs/RunnerApi.md#create_runner) | **POST** /organizations/{organization_id}/workspaces/{workspace_id}/runners | Create a new Runner
*RunnerApi* | [**create_runner_access_control**](docs/RunnerApi.md#create_runner_access_control) | **POST** /organizations/{organization_id}/workspaces/{workspace_id}/runners/{runner_id}/security/access | Add a control access to the Runner
*RunnerApi* | [**delete_runner**](docs/RunnerApi.md#delete_runner) | **DELETE** /organizations/{organization_id}/workspaces/{workspace_id}/runners/{runner_id} | Delete a runner
*RunnerApi* | [**delete_runner_access_control**](docs/RunnerApi.md#delete_runner_access_control) | **DELETE** /organizations/{organization_id}/workspaces/{workspace_id}/runners/{runner_id}/security/access/{identity_id} | Remove the specified access from the given Runner
*RunnerApi* | [**get_runner**](docs/RunnerApi.md#get_runner) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/runners/{runner_id} | Get the details of a runner
*RunnerApi* | [**get_runner_access_control**](docs/RunnerApi.md#get_runner_access_control) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/runners/{runner_id}/security/access/{identity_id} | Get a control access for the Runner
*RunnerApi* | [**get_runner_security**](docs/RunnerApi.md#get_runner_security) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/runners/{runner_id}/security | Get the Runner security information
*RunnerApi* | [**list_runner_permissions**](docs/RunnerApi.md#list_runner_permissions) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/runners/{runner_id}/permissions/{role} | Get the Runner permission by given role
*RunnerApi* | [**list_runner_security_users**](docs/RunnerApi.md#list_runner_security_users) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/runners/{runner_id}/security/users | Get the Runner security users list
*RunnerApi* | [**list_runners**](docs/RunnerApi.md#list_runners) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/runners | List all Runners
*RunnerApi* | [**start_run**](docs/RunnerApi.md#start_run) | **POST** /organizations/{organization_id}/workspaces/{workspace_id}/runners/{runner_id}/start | Start a run with runner parameters
*RunnerApi* | [**stop_run**](docs/RunnerApi.md#stop_run) | **POST** /organizations/{organization_id}/workspaces/{workspace_id}/runners/{runner_id}/stop | Stop the last run
*RunnerApi* | [**update_runner**](docs/RunnerApi.md#update_runner) | **PATCH** /organizations/{organization_id}/workspaces/{workspace_id}/runners/{runner_id} | Update a runner
*RunnerApi* | [**update_runner_access_control**](docs/RunnerApi.md#update_runner_access_control) | **PATCH** /organizations/{organization_id}/workspaces/{workspace_id}/runners/{runner_id}/security/access/{identity_id} | Update the specified access to User for a Runner
*RunnerApi* | [**update_runner_default_security**](docs/RunnerApi.md#update_runner_default_security) | **PATCH** /organizations/{organization_id}/workspaces/{workspace_id}/runners/{runner_id}/security/default | Set the Runner default security
*SolutionApi* | [**create_solution**](docs/SolutionApi.md#create_solution) | **POST** /organizations/{organization_id}/solutions | Create a new solution
*SolutionApi* | [**create_solution_access_control**](docs/SolutionApi.md#create_solution_access_control) | **POST** /organizations/{organization_id}/solutions/{solution_id}/security/access | Create solution access control
*SolutionApi* | [**create_solution_parameter**](docs/SolutionApi.md#create_solution_parameter) | **POST** /organizations/{organization_id}/solutions/{solution_id}/parameters | Create solution parameter for a solution
*SolutionApi* | [**create_solution_parameter_group**](docs/SolutionApi.md#create_solution_parameter_group) | **POST** /organizations/{organization_id}/solutions/{solution_id}/parameterGroups | Create a solution parameter group
*SolutionApi* | [**create_solution_run_template**](docs/SolutionApi.md#create_solution_run_template) | **POST** /organizations/{organization_id}/solutions/{solution_id}/runTemplates | Create a solution run template
*SolutionApi* | [**delete_solution**](docs/SolutionApi.md#delete_solution) | **DELETE** /organizations/{organization_id}/solutions/{solution_id} | Delete a solution
*SolutionApi* | [**delete_solution_access_control**](docs/SolutionApi.md#delete_solution_access_control) | **DELETE** /organizations/{organization_id}/solutions/{solution_id}/security/access/{identity_id} | Delete solution access control
*SolutionApi* | [**delete_solution_parameter**](docs/SolutionApi.md#delete_solution_parameter) | **DELETE** /organizations/{organization_id}/solutions/{solution_id}/parameters/{parameter_id} | Delete specific parameter from the solution
*SolutionApi* | [**delete_solution_parameter_group**](docs/SolutionApi.md#delete_solution_parameter_group) | **DELETE** /organizations/{organization_id}/solutions/{solution_id}/parameterGroups/{parameter_group_id} | Delete a parameter group from the solution
*SolutionApi* | [**delete_solution_run_template**](docs/SolutionApi.md#delete_solution_run_template) | **DELETE** /organizations/{organization_id}/solutions/{solution_id}/runTemplates/{run_template_id} | Delete a specific run template
*SolutionApi* | [**get_run_template**](docs/SolutionApi.md#get_run_template) | **GET** /organizations/{organization_id}/solutions/{solution_id}/runTemplates/{run_template_id} | Retrieve a solution run templates
*SolutionApi* | [**get_solution**](docs/SolutionApi.md#get_solution) | **GET** /organizations/{organization_id}/solutions/{solution_id} | Get the details of a solution
*SolutionApi* | [**get_solution_access_control**](docs/SolutionApi.md#get_solution_access_control) | **GET** /organizations/{organization_id}/solutions/{solution_id}/security/access/{identity_id} | Get solution access control
*SolutionApi* | [**get_solution_parameter**](docs/SolutionApi.md#get_solution_parameter) | **GET** /organizations/{organization_id}/solutions/{solution_id}/parameters/{parameter_id} | Get the details of a solution parameter
*SolutionApi* | [**get_solution_parameter_group**](docs/SolutionApi.md#get_solution_parameter_group) | **GET** /organizations/{organization_id}/solutions/{solution_id}/parameterGroups/{parameter_group_id} | Get details of a solution parameter group
*SolutionApi* | [**get_solution_security**](docs/SolutionApi.md#get_solution_security) | **GET** /organizations/{organization_id}/solutions/{solution_id}/security | Get solution security information
*SolutionApi* | [**list_run_templates**](docs/SolutionApi.md#list_run_templates) | **GET** /organizations/{organization_id}/solutions/{solution_id}/runTemplates | List all solution run templates
*SolutionApi* | [**list_solution_parameter_groups**](docs/SolutionApi.md#list_solution_parameter_groups) | **GET** /organizations/{organization_id}/solutions/{solution_id}/parameterGroups | List all solution parameter groups
*SolutionApi* | [**list_solution_parameters**](docs/SolutionApi.md#list_solution_parameters) | **GET** /organizations/{organization_id}/solutions/{solution_id}/parameters | List all solution parameters
*SolutionApi* | [**list_solution_security_users**](docs/SolutionApi.md#list_solution_security_users) | **GET** /organizations/{organization_id}/solutions/{solution_id}/security/users | List solution security users
*SolutionApi* | [**list_solutions**](docs/SolutionApi.md#list_solutions) | **GET** /organizations/{organization_id}/solutions | List all Solutions
*SolutionApi* | [**update_solution**](docs/SolutionApi.md#update_solution) | **PATCH** /organizations/{organization_id}/solutions/{solution_id} | Update a solution
*SolutionApi* | [**update_solution_access_control**](docs/SolutionApi.md#update_solution_access_control) | **PATCH** /organizations/{organization_id}/solutions/{solution_id}/security/access/{identity_id} | Update solution access control
*SolutionApi* | [**update_solution_default_security**](docs/SolutionApi.md#update_solution_default_security) | **PATCH** /organizations/{organization_id}/solutions/{solution_id}/security/default | Update solution default security
*SolutionApi* | [**update_solution_parameter**](docs/SolutionApi.md#update_solution_parameter) | **PATCH** /organizations/{organization_id}/solutions/{solution_id}/parameters/{parameter_id} | Update solution parameter
*SolutionApi* | [**update_solution_parameter_group**](docs/SolutionApi.md#update_solution_parameter_group) | **PATCH** /organizations/{organization_id}/solutions/{solution_id}/parameterGroups/{parameter_group_id} | Update a solution parameter group
*SolutionApi* | [**update_solution_run_template**](docs/SolutionApi.md#update_solution_run_template) | **PATCH** /organizations/{organization_id}/solutions/{solution_id}/runTemplates/{run_template_id} | Update a specific run template
*WorkspaceApi* | [**create_workspace**](docs/WorkspaceApi.md#create_workspace) | **POST** /organizations/{organization_id}/workspaces | Create a new workspace
*WorkspaceApi* | [**create_workspace_access_control**](docs/WorkspaceApi.md#create_workspace_access_control) | **POST** /organizations/{organization_id}/workspaces/{workspace_id}/security/access | Add a control access to the Workspace
*WorkspaceApi* | [**create_workspace_file**](docs/WorkspaceApi.md#create_workspace_file) | **POST** /organizations/{organization_id}/workspaces/{workspace_id}/files | Upload a file for the Workspace
*WorkspaceApi* | [**delete_workspace**](docs/WorkspaceApi.md#delete_workspace) | **DELETE** /organizations/{organization_id}/workspaces/{workspace_id} | Delete a workspace
*WorkspaceApi* | [**delete_workspace_access_control**](docs/WorkspaceApi.md#delete_workspace_access_control) | **DELETE** /organizations/{organization_id}/workspaces/{workspace_id}/security/access/{identity_id} | Remove the specified access from the given Workspace
*WorkspaceApi* | [**delete_workspace_file**](docs/WorkspaceApi.md#delete_workspace_file) | **DELETE** /organizations/{organization_id}/workspaces/{workspace_id}/files/delete | Delete a workspace file
*WorkspaceApi* | [**delete_workspace_files**](docs/WorkspaceApi.md#delete_workspace_files) | **DELETE** /organizations/{organization_id}/workspaces/{workspace_id}/files | Delete all Workspace files
*WorkspaceApi* | [**get_workspace**](docs/WorkspaceApi.md#get_workspace) | **GET** /organizations/{organization_id}/workspaces/{workspace_id} | Get the details of a workspace
*WorkspaceApi* | [**get_workspace_access_control**](docs/WorkspaceApi.md#get_workspace_access_control) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/security/access/{identity_id} | Get a control access for the Workspace
*WorkspaceApi* | [**get_workspace_file**](docs/WorkspaceApi.md#get_workspace_file) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/files/download | Download the Workspace File specified
*WorkspaceApi* | [**get_workspace_security**](docs/WorkspaceApi.md#get_workspace_security) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/security | Get the Workspace security information
*WorkspaceApi* | [**list_workspace_files**](docs/WorkspaceApi.md#list_workspace_files) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/files | List all Workspace files
*WorkspaceApi* | [**list_workspace_role_permissions**](docs/WorkspaceApi.md#list_workspace_role_permissions) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/permissions/{role} | Get the Workspace permission by given role
*WorkspaceApi* | [**list_workspace_security_users**](docs/WorkspaceApi.md#list_workspace_security_users) | **GET** /organizations/{organization_id}/workspaces/{workspace_id}/security/users | Get the Workspace security users list
*WorkspaceApi* | [**list_workspaces**](docs/WorkspaceApi.md#list_workspaces) | **GET** /organizations/{organization_id}/workspaces | List all Workspaces
*WorkspaceApi* | [**update_workspace**](docs/WorkspaceApi.md#update_workspace) | **PATCH** /organizations/{organization_id}/workspaces/{workspace_id} | Update a workspace
*WorkspaceApi* | [**update_workspace_access_control**](docs/WorkspaceApi.md#update_workspace_access_control) | **PATCH** /organizations/{organization_id}/workspaces/{workspace_id}/security/access/{identity_id} | Update the specified access to User for a Workspace
*WorkspaceApi* | [**update_workspace_default_security**](docs/WorkspaceApi.md#update_workspace_default_security) | **PATCH** /organizations/{organization_id}/workspaces/{workspace_id}/security/default | Update the Workspace default security


## Documentation For Models

 - [AboutInfo](docs/AboutInfo.md)
 - [AboutInfoVersion](docs/AboutInfoVersion.md)
 - [ComponentRolePermissions](docs/ComponentRolePermissions.md)
 - [ContainerResourceSizeInfo](docs/ContainerResourceSizeInfo.md)
 - [ContainerResourceSizing](docs/ContainerResourceSizing.md)
 - [CreateInfo](docs/CreateInfo.md)
 - [CreatedRun](docs/CreatedRun.md)
 - [Dataset](docs/Dataset.md)
 - [DatasetAccessControl](docs/DatasetAccessControl.md)
 - [DatasetCreateRequest](docs/DatasetCreateRequest.md)
 - [DatasetPart](docs/DatasetPart.md)
 - [DatasetPartCreateRequest](docs/DatasetPartCreateRequest.md)
 - [DatasetPartTypeEnum](docs/DatasetPartTypeEnum.md)
 - [DatasetPartUpdateRequest](docs/DatasetPartUpdateRequest.md)
 - [DatasetRole](docs/DatasetRole.md)
 - [DatasetSecurity](docs/DatasetSecurity.md)
 - [DatasetUpdateRequest](docs/DatasetUpdateRequest.md)
 - [EditInfo](docs/EditInfo.md)
 - [LastRunInfo](docs/LastRunInfo.md)
 - [Organization](docs/Organization.md)
 - [OrganizationAccessControl](docs/OrganizationAccessControl.md)
 - [OrganizationCreateRequest](docs/OrganizationCreateRequest.md)
 - [OrganizationEditInfo](docs/OrganizationEditInfo.md)
 - [OrganizationRole](docs/OrganizationRole.md)
 - [OrganizationSecurity](docs/OrganizationSecurity.md)
 - [OrganizationUpdateRequest](docs/OrganizationUpdateRequest.md)
 - [QueryResult](docs/QueryResult.md)
 - [ResourceSizeInfo](docs/ResourceSizeInfo.md)
 - [Run](docs/Run.md)
 - [RunContainer](docs/RunContainer.md)
 - [RunData](docs/RunData.md)
 - [RunDataQuery](docs/RunDataQuery.md)
 - [RunEditInfo](docs/RunEditInfo.md)
 - [RunResourceRequested](docs/RunResourceRequested.md)
 - [RunState](docs/RunState.md)
 - [RunStatus](docs/RunStatus.md)
 - [RunStatusNode](docs/RunStatusNode.md)
 - [RunTemplate](docs/RunTemplate.md)
 - [RunTemplateCreateRequest](docs/RunTemplateCreateRequest.md)
 - [RunTemplateParameter](docs/RunTemplateParameter.md)
 - [RunTemplateParameterCreateRequest](docs/RunTemplateParameterCreateRequest.md)
 - [RunTemplateParameterGroup](docs/RunTemplateParameterGroup.md)
 - [RunTemplateParameterGroupCreateRequest](docs/RunTemplateParameterGroupCreateRequest.md)
 - [RunTemplateParameterGroupUpdateRequest](docs/RunTemplateParameterGroupUpdateRequest.md)
 - [RunTemplateParameterUpdateRequest](docs/RunTemplateParameterUpdateRequest.md)
 - [RunTemplateParameterValue](docs/RunTemplateParameterValue.md)
 - [RunTemplateResourceSizing](docs/RunTemplateResourceSizing.md)
 - [RunTemplateUpdateRequest](docs/RunTemplateUpdateRequest.md)
 - [Runner](docs/Runner.md)
 - [RunnerAccessControl](docs/RunnerAccessControl.md)
 - [RunnerCreateRequest](docs/RunnerCreateRequest.md)
 - [RunnerDatasets](docs/RunnerDatasets.md)
 - [RunnerEditInfo](docs/RunnerEditInfo.md)
 - [RunnerResourceSizing](docs/RunnerResourceSizing.md)
 - [RunnerRole](docs/RunnerRole.md)
 - [RunnerRunTemplateParameterValue](docs/RunnerRunTemplateParameterValue.md)
 - [RunnerSecurity](docs/RunnerSecurity.md)
 - [RunnerUpdateRequest](docs/RunnerUpdateRequest.md)
 - [RunnerValidationStatus](docs/RunnerValidationStatus.md)
 - [SendRunDataRequest](docs/SendRunDataRequest.md)
 - [Solution](docs/Solution.md)
 - [SolutionAccessControl](docs/SolutionAccessControl.md)
 - [SolutionCreateRequest](docs/SolutionCreateRequest.md)
 - [SolutionEditInfo](docs/SolutionEditInfo.md)
 - [SolutionRole](docs/SolutionRole.md)
 - [SolutionSecurity](docs/SolutionSecurity.md)
 - [SolutionUpdateRequest](docs/SolutionUpdateRequest.md)
 - [Workspace](docs/Workspace.md)
 - [WorkspaceAccessControl](docs/WorkspaceAccessControl.md)
 - [WorkspaceCreateRequest](docs/WorkspaceCreateRequest.md)
 - [WorkspaceEditInfo](docs/WorkspaceEditInfo.md)
 - [WorkspaceFile](docs/WorkspaceFile.md)
 - [WorkspaceRole](docs/WorkspaceRole.md)
 - [WorkspaceSecurity](docs/WorkspaceSecurity.md)
 - [WorkspaceSolution](docs/WorkspaceSolution.md)
 - [WorkspaceUpdateRequest](docs/WorkspaceUpdateRequest.md)
 - [WorkspaceWebApp](docs/WorkspaceWebApp.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="oAuth2AuthCode"></a>
### oAuth2AuthCode

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://example.com/authorize
- **Scopes**: N/A


## Author

platform@cosmotech.com


