"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API  # noqa: E501

    The version of the OpenAPI document: 3.1.13
    Contact: platform@cosmotech.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from cosmotech_api.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from cosmotech_api.exceptions import ApiAttributeError


def lazy_import():
    from cosmotech_api.model.workspace_security import WorkspaceSecurity
    from cosmotech_api.model.workspace_solution import WorkspaceSolution
    from cosmotech_api.model.workspace_web_app import WorkspaceWebApp
    globals()['WorkspaceSecurity'] = WorkspaceSecurity
    globals()['WorkspaceSolution'] = WorkspaceSolution
    globals()['WorkspaceWebApp'] = WorkspaceWebApp


class Workspace(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'key': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'solution': (WorkspaceSolution,),  # noqa: E501
            'id': (str,),  # noqa: E501
            'organization_id': (str,),  # noqa: E501
            'description': (str,),  # noqa: E501
            'linked_dataset_id_list': ([str],),  # noqa: E501
            'version': (str,),  # noqa: E501
            'tags': ([str],),  # noqa: E501
            'owner_id': (str,),  # noqa: E501
            'web_app': (WorkspaceWebApp,),  # noqa: E501
            'send_input_to_data_warehouse': (bool,),  # noqa: E501
            'use_dedicated_event_hub_namespace': (bool,),  # noqa: E501
            'dedicated_event_hub_sas_key_name': (str,),  # noqa: E501
            'dedicated_event_hub_authentication_strategy': (str,),  # noqa: E501
            'send_scenario_run_to_event_hub': (bool,),  # noqa: E501
            'send_scenario_metadata_to_event_hub': (bool,),  # noqa: E501
            'dataset_copy': (bool,),  # noqa: E501
            'security': (bool, date, datetime, dict, float, int, list, str, none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'key': 'key',  # noqa: E501
        'name': 'name',  # noqa: E501
        'solution': 'solution',  # noqa: E501
        'id': 'id',  # noqa: E501
        'organization_id': 'organizationId',  # noqa: E501
        'description': 'description',  # noqa: E501
        'linked_dataset_id_list': 'linkedDatasetIdList',  # noqa: E501
        'version': 'version',  # noqa: E501
        'tags': 'tags',  # noqa: E501
        'owner_id': 'ownerId',  # noqa: E501
        'web_app': 'webApp',  # noqa: E501
        'send_input_to_data_warehouse': 'sendInputToDataWarehouse',  # noqa: E501
        'use_dedicated_event_hub_namespace': 'useDedicatedEventHubNamespace',  # noqa: E501
        'dedicated_event_hub_sas_key_name': 'dedicatedEventHubSasKeyName',  # noqa: E501
        'dedicated_event_hub_authentication_strategy': 'dedicatedEventHubAuthenticationStrategy',  # noqa: E501
        'send_scenario_run_to_event_hub': 'sendScenarioRunToEventHub',  # noqa: E501
        'send_scenario_metadata_to_event_hub': 'sendScenarioMetadataToEventHub',  # noqa: E501
        'dataset_copy': 'datasetCopy',  # noqa: E501
        'security': 'security',  # noqa: E501
    }

    read_only_vars = {
        'id',  # noqa: E501
        'organization_id',  # noqa: E501
        'owner_id',  # noqa: E501
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, key, name, solution, *args, **kwargs):  # noqa: E501
        """Workspace - a model defined in OpenAPI

        Args:
            key (str): technical key for resource name convention and version grouping. Must be unique
            name (str): Workspace name. This name is display in the sample webApp
            solution (WorkspaceSolution):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): Workspace unique identifier generated by the API. [optional]  # noqa: E501
            organization_id (str): Organization unique identifier under which the workspace resides. [optional]  # noqa: E501
            description (str): the Workspace description. [optional]  # noqa: E501
            linked_dataset_id_list ([str]): list of dataset linked to this dataset. [optional]  # noqa: E501
            version (str): the Workspace version MAJOR.MINOR.PATCH.. [optional]  # noqa: E501
            tags ([str]): the list of tags. [optional]  # noqa: E501
            owner_id (str): the user id which own this workspace. set by the API from Authentification service receved id. [optional]  # noqa: E501
            web_app (WorkspaceWebApp): [optional]  # noqa: E501
            send_input_to_data_warehouse (bool): default setting for all Scenarios and Run Templates to set whether or not the Dataset values and the input parameters values are send to the DataWarehouse prior to the ScenarioRun. [optional]  # noqa: E501
            use_dedicated_event_hub_namespace (bool): Set this property to true to use a dedicated Azure Event Hub Namespace for this Workspace. The Event Hub Namespace must be named \\'<organization_id\\>-<workspace_id\\>\\' (in lower case). This Namespace must also contain two Event Hubs named \\'probesmeasures\\' and \\'scenariorun\\'.. [optional] if omitted the server will use the default value of False  # noqa: E501
            dedicated_event_hub_sas_key_name (str): the Dedicated Event Hub SAS key name, default to RootManageSharedAccessKey. Use the /secret endpoint to set the key value. [optional]  # noqa: E501
            dedicated_event_hub_authentication_strategy (str): the Event Hub authentication strategy, SHARED_ACCESS_POLICY or TENANT_CLIENT_CREDENTIALS. Default to the one defined for the tenant.. [optional]  # noqa: E501
            send_scenario_run_to_event_hub (bool): default setting for all Scenarios and Run Templates to set whether or not the ScenarioRun is send to the Event Hub. [optional] if omitted the server will use the default value of True  # noqa: E501
            send_scenario_metadata_to_event_hub (bool): Set this property to false to not send scenario metada to Azure Event Hub Namespace for this Workspace. The Event Hub Namespace must be named \\'<organization_id\\>-<workspace_id\\>\\' (in lower case). This Namespace must also contain two Event Hubs named \\'scenariometadata\\' and \\'scenariorunmetadata\\'.. [optional] if omitted the server will use the default value of False  # noqa: E501
            dataset_copy (bool): Activate the copy of dataset on scenario creation, meaning that each scenario created in this workspace will make this copy. when false, scenario use directly the dataset specified.. [optional] if omitted the server will use the default value of True  # noqa: E501
            security (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.key = key
        self.name = name
        self.solution = solution
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, key, name, solution, *args, **kwargs):  # noqa: E501
        """Workspace - a model defined in OpenAPI

        Args:
            key (str): technical key for resource name convention and version grouping. Must be unique
            name (str): Workspace name. This name is display in the sample webApp
            solution (WorkspaceSolution):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            id (str): Workspace unique identifier generated by the API. [optional]  # noqa: E501
            organization_id (str): Organization unique identifier under which the workspace resides. [optional]  # noqa: E501
            description (str): the Workspace description. [optional]  # noqa: E501
            linked_dataset_id_list ([str]): list of dataset linked to this dataset. [optional]  # noqa: E501
            version (str): the Workspace version MAJOR.MINOR.PATCH.. [optional]  # noqa: E501
            tags ([str]): the list of tags. [optional]  # noqa: E501
            owner_id (str): the user id which own this workspace. set by the API from Authentification service receved id. [optional]  # noqa: E501
            web_app (WorkspaceWebApp): [optional]  # noqa: E501
            send_input_to_data_warehouse (bool): default setting for all Scenarios and Run Templates to set whether or not the Dataset values and the input parameters values are send to the DataWarehouse prior to the ScenarioRun. [optional]  # noqa: E501
            use_dedicated_event_hub_namespace (bool): Set this property to true to use a dedicated Azure Event Hub Namespace for this Workspace. The Event Hub Namespace must be named \\'<organization_id\\>-<workspace_id\\>\\' (in lower case). This Namespace must also contain two Event Hubs named \\'probesmeasures\\' and \\'scenariorun\\'.. [optional] if omitted the server will use the default value of False  # noqa: E501
            dedicated_event_hub_sas_key_name (str): the Dedicated Event Hub SAS key name, default to RootManageSharedAccessKey. Use the /secret endpoint to set the key value. [optional]  # noqa: E501
            dedicated_event_hub_authentication_strategy (str): the Event Hub authentication strategy, SHARED_ACCESS_POLICY or TENANT_CLIENT_CREDENTIALS. Default to the one defined for the tenant.. [optional]  # noqa: E501
            send_scenario_run_to_event_hub (bool): default setting for all Scenarios and Run Templates to set whether or not the ScenarioRun is send to the Event Hub. [optional] if omitted the server will use the default value of True  # noqa: E501
            send_scenario_metadata_to_event_hub (bool): Set this property to false to not send scenario metada to Azure Event Hub Namespace for this Workspace. The Event Hub Namespace must be named \\'<organization_id\\>-<workspace_id\\>\\' (in lower case). This Namespace must also contain two Event Hubs named \\'scenariometadata\\' and \\'scenariorunmetadata\\'.. [optional] if omitted the server will use the default value of False  # noqa: E501
            dataset_copy (bool): Activate the copy of dataset on scenario creation, meaning that each scenario created in this workspace will make this copy. when false, scenario use directly the dataset specified.. [optional] if omitted the server will use the default value of True  # noqa: E501
            security (bool, date, datetime, dict, float, int, list, str, none_type): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.key = key
        self.name = name
        self.solution = solution
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
