# coding: utf-8

"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API

    The version of the OpenAPI document: 5.0.1-SNAPSHOT
    Contact: platform@cosmotech.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from cosmotech_api.models.organization_edit_info import OrganizationEditInfo
from cosmotech_api.models.organization_security import OrganizationSecurity
from typing import Optional, Set
from typing_extensions import Self

class Organization(BaseModel):
    """
    An Organization
    """ # noqa: E501
    id: StrictStr = Field(description="The Organization unique identifier")
    name: StrictStr = Field(description="The Organization name")
    create_info: OrganizationEditInfo = Field(description="The details of the Organization creation", alias="createInfo")
    update_info: OrganizationEditInfo = Field(description="The details of the Organization last update", alias="updateInfo")
    security: OrganizationSecurity
    __properties: ClassVar[List[str]] = ["id", "name", "createInfo", "updateInfo", "security"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Organization from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of create_info
        if self.create_info:
            _dict['createInfo'] = self.create_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of update_info
        if self.update_info:
            _dict['updateInfo'] = self.update_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of security
        if self.security:
            _dict['security'] = self.security.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Organization from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "createInfo": OrganizationEditInfo.from_dict(obj["createInfo"]) if obj.get("createInfo") is not None else None,
            "updateInfo": OrganizationEditInfo.from_dict(obj["updateInfo"]) if obj.get("updateInfo") is not None else None,
            "security": OrganizationSecurity.from_dict(obj["security"]) if obj.get("security") is not None else None
        })
        return _obj


