# coding: utf-8

"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API

    The version of the OpenAPI document: 3.3.4
    Contact: platform@cosmotech.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class OrganizationService(BaseModel):
    """
    a cloud service resource
    """ # noqa: E501
    cloud_service: Optional[StrictStr] = Field(default=None, description="the cloud service name", alias="cloudService")
    base_uri: Optional[StrictStr] = Field(default=None, description="the platform base uri for this service", alias="baseUri")
    platform_service: Optional[StrictStr] = Field(default=None, description="the Platform service associated to the resource", alias="platformService")
    resource_uri: Optional[StrictStr] = Field(default=None, description="the Organization specific uri for this service resource", alias="resourceUri")
    credentials: Optional[Dict[str, Any]] = Field(default=None, description="a freeform credentials object. Structure depends on service")
    __properties: ClassVar[List[str]] = ["cloudService", "baseUri", "platformService", "resourceUri", "credentials"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrganizationService from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrganizationService from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cloudService": obj.get("cloudService"),
            "baseUri": obj.get("baseUri"),
            "platformService": obj.get("platformService"),
            "resourceUri": obj.get("resourceUri"),
            "credentials": obj.get("credentials")
        })
        return _obj


