# coding: utf-8

"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API

    The version of the OpenAPI document: 5.0.1-SNAPSHOT
    Contact: platform@cosmotech.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from cosmotech_api.models.run_resource_requested import RunResourceRequested
from typing import Optional, Set
from typing_extensions import Self

class RunStatusNode(BaseModel):
    """
    status of a Run Node
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="the node id")
    name: Optional[StrictStr] = Field(default=None, description="the node unique name")
    container_name: Optional[StrictStr] = Field(default=None, description="the Run container name", alias="containerName")
    outbound_nodes: Optional[List[StrictStr]] = Field(default=None, description="the list of outbound nodes", alias="outboundNodes")
    resources_duration: Optional[RunResourceRequested] = Field(default=None, alias="resourcesDuration")
    estimated_duration: Optional[StrictInt] = Field(default=None, description="estimatedDuration in seconds", alias="estimatedDuration")
    host_node_name: Optional[StrictStr] = Field(default=None, description="HostNodeName name of the Kubernetes node on which the Pod is running, if applicable", alias="hostNodeName")
    message: Optional[StrictStr] = Field(default=None, description="a human readable message indicating details about why the node is in this condition")
    phase: Optional[StrictStr] = Field(default=None, description="high-level summary of where the node is in its lifecycle")
    progress: Optional[StrictStr] = Field(default=None, description="progress to completion")
    start_time: Optional[StrictStr] = Field(default=None, description="the node start time", alias="startTime")
    end_time: Optional[StrictStr] = Field(default=None, description="the node end time", alias="endTime")
    __properties: ClassVar[List[str]] = ["id", "name", "containerName", "outboundNodes", "resourcesDuration", "estimatedDuration", "hostNodeName", "message", "phase", "progress", "startTime", "endTime"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RunStatusNode from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "outbound_nodes",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of resources_duration
        if self.resources_duration:
            _dict['resourcesDuration'] = self.resources_duration.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RunStatusNode from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "containerName": obj.get("containerName"),
            "outboundNodes": obj.get("outboundNodes"),
            "resourcesDuration": RunResourceRequested.from_dict(obj["resourcesDuration"]) if obj.get("resourcesDuration") is not None else None,
            "estimatedDuration": obj.get("estimatedDuration"),
            "hostNodeName": obj.get("hostNodeName"),
            "message": obj.get("message"),
            "phase": obj.get("phase"),
            "progress": obj.get("progress"),
            "startTime": obj.get("startTime"),
            "endTime": obj.get("endTime")
        })
        return _obj


