# coding: utf-8

"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API

    The version of the OpenAPI document: 5.0.1-SNAPSHOT
    Contact: platform@cosmotech.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from cosmotech_api.models.run_template_resource_sizing import RunTemplateResourceSizing
from typing import Optional, Set
from typing_extensions import Self

class RunTemplateCreateRequest(BaseModel):
    """
    A Solution Run Template Create Request
    """ # noqa: E501
    id: Annotated[str, Field(min_length=1, strict=True, max_length=50)] = Field(description="The Solution Run Template id")
    name: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=50)]] = Field(default=None, description="The Run Template name")
    labels: Optional[Dict[str, StrictStr]] = Field(default=None, description="A translated label with key as ISO 639-1 code")
    description: Optional[StrictStr] = Field(default=None, description="The Run Template description")
    tags: Optional[List[StrictStr]] = Field(default=None, description="The list of Run Template tags")
    compute_size: Optional[StrictStr] = Field(default=None, description="The compute size needed for this Run Template", alias="computeSize")
    run_sizing: Optional[RunTemplateResourceSizing] = Field(default=None, alias="runSizing")
    parameter_groups: Optional[List[StrictStr]] = Field(default=None, description="The ordered list of parameters groups for the Run Template", alias="parameterGroups")
    execution_timeout: Optional[StrictInt] = Field(default=None, description="An optional duration in seconds in which a workflow is allowed to run", alias="executionTimeout")
    __properties: ClassVar[List[str]] = ["id", "name", "labels", "description", "tags", "computeSize", "runSizing", "parameterGroups", "executionTimeout"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RunTemplateCreateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of run_sizing
        if self.run_sizing:
            _dict['runSizing'] = self.run_sizing.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RunTemplateCreateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "labels": obj.get("labels"),
            "description": obj.get("description"),
            "tags": obj.get("tags"),
            "computeSize": obj.get("computeSize"),
            "runSizing": RunTemplateResourceSizing.from_dict(obj["runSizing"]) if obj.get("runSizing") is not None else None,
            "parameterGroups": obj.get("parameterGroups"),
            "executionTimeout": obj.get("executionTimeout")
        })
        return _obj


