# coding: utf-8

"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API

    The version of the OpenAPI document: 5.0.1-SNAPSHOT
    Contact: platform@cosmotech.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class RunTemplateParameterCreateRequest(BaseModel):
    """
    A Run Template Parameter for creation
    """ # noqa: E501
    id: Annotated[str, Field(min_length=1, strict=True, max_length=50)] = Field(description="The Parameter id")
    description: Optional[StrictStr] = Field(default=None, description="The parameter description")
    labels: Optional[Dict[str, StrictStr]] = Field(default=None, description="A translated label with key as ISO 639-1 code")
    var_type: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The variable type for the parameter. Basic types or special type %DATASETID%", alias="varType")
    default_value: Optional[StrictStr] = Field(default=None, description="The default value for this parameter", alias="defaultValue")
    min_value: Optional[StrictStr] = Field(default=None, description="The minimum value for this parameter", alias="minValue")
    max_value: Optional[StrictStr] = Field(default=None, description="The maximum value for this parameter", alias="maxValue")
    regex_validation: Optional[StrictStr] = Field(default=None, description="A regex to validate the value", alias="regexValidation")
    options: Optional[Dict[str, Any]] = Field(default=None, description="Freeform options")
    __properties: ClassVar[List[str]] = ["id", "description", "labels", "varType", "defaultValue", "minValue", "maxValue", "regexValidation", "options"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RunTemplateParameterCreateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RunTemplateParameterCreateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "description": obj.get("description"),
            "labels": obj.get("labels"),
            "varType": obj.get("varType"),
            "defaultValue": obj.get("defaultValue"),
            "minValue": obj.get("minValue"),
            "maxValue": obj.get("maxValue"),
            "regexValidation": obj.get("regexValidation"),
            "options": obj.get("options")
        })
        return _obj


