# coding: utf-8

"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API

    The version of the OpenAPI document: 5.0.1-SNAPSHOT
    Contact: platform@cosmotech.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from cosmotech_api.models.runner_resource_sizing import RunnerResourceSizing
from cosmotech_api.models.runner_run_template_parameter_value import RunnerRunTemplateParameterValue
from cosmotech_api.models.runner_security import RunnerSecurity
from typing import Optional, Set
from typing_extensions import Self

class RunnerCreateRequest(BaseModel):
    """
    Request object for creating a new runner
    """ # noqa: E501
    name: Annotated[str, Field(min_length=1, strict=True)] = Field(description="the Runner name")
    description: Optional[StrictStr] = Field(default=None, description="the Runner description")
    tags: Optional[List[StrictStr]] = Field(default=None, description="the list of tags")
    solution_id: Annotated[str, Field(strict=True)] = Field(description="the Solution Id associated with this Runner", alias="solutionId")
    parent_id: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="the Runner parent id", alias="parentId")
    run_template_id: Annotated[str, Field(min_length=1, strict=True)] = Field(description="the Solution Run Template Id associated with this Runner", alias="runTemplateId")
    dataset_list: Optional[List[StrictStr]] = Field(default=None, description="the list of Dataset Id associated to this Runner Run Template", alias="datasetList")
    run_sizing: Optional[RunnerResourceSizing] = Field(default=None, alias="runSizing")
    parameters_values: Optional[List[RunnerRunTemplateParameterValue]] = Field(default=None, description="the list of Solution Run Template parameters values", alias="parametersValues")
    owner_name: Annotated[str, Field(min_length=1, strict=True)] = Field(description="the name of the owner", alias="ownerName")
    solution_name: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(default=None, description="the Solution name", alias="solutionName")
    run_template_name: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(default=None, description="the Solution Run Template name associated with this Runner", alias="runTemplateName")
    security: Optional[RunnerSecurity] = None
    __properties: ClassVar[List[str]] = ["name", "description", "tags", "solutionId", "parentId", "runTemplateId", "datasetList", "runSizing", "parametersValues", "ownerName", "solutionName", "runTemplateName", "security"]

    @field_validator('solution_id')
    def solution_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^sol-\w{10,20}", value):
            raise ValueError(r"must validate the regular expression /^sol-\w{10,20}/")
        return value

    @field_validator('parent_id')
    def parent_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^r-\w{10,20}", value):
            raise ValueError(r"must validate the regular expression /^r-\w{10,20}/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RunnerCreateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of run_sizing
        if self.run_sizing:
            _dict['runSizing'] = self.run_sizing.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in parameters_values (list)
        _items = []
        if self.parameters_values:
            for _item_parameters_values in self.parameters_values:
                if _item_parameters_values:
                    _items.append(_item_parameters_values.to_dict())
            _dict['parametersValues'] = _items
        # override the default output from pydantic by calling `to_dict()` of security
        if self.security:
            _dict['security'] = self.security.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RunnerCreateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "tags": obj.get("tags"),
            "solutionId": obj.get("solutionId"),
            "parentId": obj.get("parentId"),
            "runTemplateId": obj.get("runTemplateId"),
            "datasetList": obj.get("datasetList"),
            "runSizing": RunnerResourceSizing.from_dict(obj["runSizing"]) if obj.get("runSizing") is not None else None,
            "parametersValues": [RunnerRunTemplateParameterValue.from_dict(_item) for _item in obj["parametersValues"]] if obj.get("parametersValues") is not None else None,
            "ownerName": obj.get("ownerName"),
            "solutionName": obj.get("solutionName"),
            "runTemplateName": obj.get("runTemplateName"),
            "security": RunnerSecurity.from_dict(obj["security"]) if obj.get("security") is not None else None
        })
        return _obj


