# coding: utf-8

"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API

    The version of the OpenAPI document: 5.0.1-SNAPSHOT
    Contact: platform@cosmotech.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from cosmotech_api.models.run_template import RunTemplate
from cosmotech_api.models.run_template_parameter import RunTemplateParameter
from cosmotech_api.models.run_template_parameter_group import RunTemplateParameterGroup
from cosmotech_api.models.solution_edit_info import SolutionEditInfo
from cosmotech_api.models.solution_security import SolutionSecurity
from typing import Optional, Set
from typing_extensions import Self

class Solution(BaseModel):
    """
    A version of a Solution
    """ # noqa: E501
    id: Annotated[str, Field(strict=True)] = Field(description="The Solution version unique identifier")
    organization_id: Annotated[str, Field(strict=True)] = Field(description="The Organization unique identifier", alias="organizationId")
    key: Annotated[str, Field(min_length=1, strict=True, max_length=50)] = Field(description="The Solution key which groups Solution versions")
    name: Annotated[str, Field(min_length=1, strict=True, max_length=50)] = Field(description="The Solution name")
    description: Optional[StrictStr] = Field(default=None, description="The Solution description")
    repository: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The registry repository containing the image")
    always_pull: Optional[StrictBool] = Field(default=False, description="Set to true if the runtemplate wants to always pull the image", alias="alwaysPull")
    version: Annotated[str, Field(min_length=1, strict=True)] = Field(description="The Solution version MAJOR.MINOR.PATCH. Must be aligned with an existing repository tag")
    create_info: SolutionEditInfo = Field(description="The details of the Solution creation", alias="createInfo")
    update_info: SolutionEditInfo = Field(description="The details of the Solution last update", alias="updateInfo")
    sdk_version: Optional[StrictStr] = Field(default=None, description="The full SDK version used to build this solution, if available", alias="sdkVersion")
    url: Optional[StrictStr] = Field(default=None, description="An optional URL link to solution page")
    tags: Optional[List[StrictStr]] = Field(default=None, description="The list of tags")
    parameters: List[RunTemplateParameter] = Field(description="The list of Run Template Parameters")
    parameter_groups: List[RunTemplateParameterGroup] = Field(description="The list of parameters groups for the Run Templates", alias="parameterGroups")
    run_templates: List[RunTemplate] = Field(description="List of Run Templates", alias="runTemplates")
    security: SolutionSecurity
    __properties: ClassVar[List[str]] = ["id", "organizationId", "key", "name", "description", "repository", "alwaysPull", "version", "createInfo", "updateInfo", "sdkVersion", "url", "tags", "parameters", "parameterGroups", "runTemplates", "security"]

    @field_validator('id')
    def id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^sol-\w{10,20}", value):
            raise ValueError(r"must validate the regular expression /^sol-\w{10,20}/")
        return value

    @field_validator('organization_id')
    def organization_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^o-\w{10,20}", value):
            raise ValueError(r"must validate the regular expression /^o-\w{10,20}/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Solution from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of create_info
        if self.create_info:
            _dict['createInfo'] = self.create_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of update_info
        if self.update_info:
            _dict['updateInfo'] = self.update_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in parameters (list)
        _items = []
        if self.parameters:
            for _item_parameters in self.parameters:
                if _item_parameters:
                    _items.append(_item_parameters.to_dict())
            _dict['parameters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in parameter_groups (list)
        _items = []
        if self.parameter_groups:
            for _item_parameter_groups in self.parameter_groups:
                if _item_parameter_groups:
                    _items.append(_item_parameter_groups.to_dict())
            _dict['parameterGroups'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in run_templates (list)
        _items = []
        if self.run_templates:
            for _item_run_templates in self.run_templates:
                if _item_run_templates:
                    _items.append(_item_run_templates.to_dict())
            _dict['runTemplates'] = _items
        # override the default output from pydantic by calling `to_dict()` of security
        if self.security:
            _dict['security'] = self.security.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Solution from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "organizationId": obj.get("organizationId"),
            "key": obj.get("key"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "repository": obj.get("repository"),
            "alwaysPull": obj.get("alwaysPull") if obj.get("alwaysPull") is not None else False,
            "version": obj.get("version"),
            "createInfo": SolutionEditInfo.from_dict(obj["createInfo"]) if obj.get("createInfo") is not None else None,
            "updateInfo": SolutionEditInfo.from_dict(obj["updateInfo"]) if obj.get("updateInfo") is not None else None,
            "sdkVersion": obj.get("sdkVersion"),
            "url": obj.get("url"),
            "tags": obj.get("tags"),
            "parameters": [RunTemplateParameter.from_dict(_item) for _item in obj["parameters"]] if obj.get("parameters") is not None else None,
            "parameterGroups": [RunTemplateParameterGroup.from_dict(_item) for _item in obj["parameterGroups"]] if obj.get("parameterGroups") is not None else None,
            "runTemplates": [RunTemplate.from_dict(_item) for _item in obj["runTemplates"]] if obj.get("runTemplates") is not None else None,
            "security": SolutionSecurity.from_dict(obj["security"]) if obj.get("security") is not None else None
        })
        return _obj


