# coding: utf-8

"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API

    The version of the OpenAPI document: 5.0.1-SNAPSHOT
    Contact: platform@cosmotech.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from cosmotech_api.models.run_template_create_request import RunTemplateCreateRequest
from cosmotech_api.models.run_template_parameter_create_request import RunTemplateParameterCreateRequest
from cosmotech_api.models.run_template_parameter_group_create_request import RunTemplateParameterGroupCreateRequest
from typing import Optional, Set
from typing_extensions import Self

class SolutionUpdateRequest(BaseModel):
    """
    Request object for updating a solution
    """ # noqa: E501
    key: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=50)]] = Field(default=None, description="Technical key for resource name convention and version grouping. Must be unique")
    name: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=50)]] = Field(default=None, description="The Solution name")
    description: Optional[StrictStr] = Field(default=None, description="The Solution description")
    repository: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(default=None, description="The registry repository containing the image")
    always_pull: Optional[StrictBool] = Field(default=None, description="Set to true if the runtemplate wants to always pull the image", alias="alwaysPull")
    version: Optional[Annotated[str, Field(min_length=1, strict=True)]] = Field(default=None, description="The Solution version MAJOR.MINOR.PATCH. Must be aligned with an existing repository tag")
    url: Optional[StrictStr] = Field(default=None, description="An optional URL link to solution page")
    tags: Optional[List[StrictStr]] = Field(default=None, description="The list of tags")
    parameters: Optional[List[RunTemplateParameterCreateRequest]] = Field(default=None, description="The list of Run Template Parameters")
    parameter_groups: Optional[List[RunTemplateParameterGroupCreateRequest]] = Field(default=None, description="The list of parameters groups for the Run Templates", alias="parameterGroups")
    run_templates: Optional[List[RunTemplateCreateRequest]] = Field(default=None, description="List of Run Templates", alias="runTemplates")
    __properties: ClassVar[List[str]] = ["key", "name", "description", "repository", "alwaysPull", "version", "url", "tags", "parameters", "parameterGroups", "runTemplates"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SolutionUpdateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in parameters (list)
        _items = []
        if self.parameters:
            for _item_parameters in self.parameters:
                if _item_parameters:
                    _items.append(_item_parameters.to_dict())
            _dict['parameters'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in parameter_groups (list)
        _items = []
        if self.parameter_groups:
            for _item_parameter_groups in self.parameter_groups:
                if _item_parameter_groups:
                    _items.append(_item_parameter_groups.to_dict())
            _dict['parameterGroups'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in run_templates (list)
        _items = []
        if self.run_templates:
            for _item_run_templates in self.run_templates:
                if _item_run_templates:
                    _items.append(_item_run_templates.to_dict())
            _dict['runTemplates'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SolutionUpdateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "key": obj.get("key"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "repository": obj.get("repository"),
            "alwaysPull": obj.get("alwaysPull"),
            "version": obj.get("version"),
            "url": obj.get("url"),
            "tags": obj.get("tags"),
            "parameters": [RunTemplateParameterCreateRequest.from_dict(_item) for _item in obj["parameters"]] if obj.get("parameters") is not None else None,
            "parameterGroups": [RunTemplateParameterGroupCreateRequest.from_dict(_item) for _item in obj["parameterGroups"]] if obj.get("parameterGroups") is not None else None,
            "runTemplates": [RunTemplateCreateRequest.from_dict(_item) for _item in obj["runTemplates"]] if obj.get("runTemplates") is not None else None
        })
        return _obj


