# coding: utf-8

"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API

    The version of the OpenAPI document: 5.0.1-SNAPSHOT
    Contact: platform@cosmotech.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from cosmotech_api.models.workspace_edit_info import WorkspaceEditInfo
from cosmotech_api.models.workspace_security import WorkspaceSecurity
from cosmotech_api.models.workspace_solution import WorkspaceSolution
from cosmotech_api.models.workspace_web_app import WorkspaceWebApp
from typing import Optional, Set
from typing_extensions import Self

class Workspace(BaseModel):
    """
    A Workspace
    """ # noqa: E501
    id: Annotated[str, Field(strict=True)] = Field(description="Workspace unique identifier generated by the API")
    organization_id: Annotated[str, Field(strict=True)] = Field(description="Organization unique identifier under which the workspace resides", alias="organizationId")
    key: Annotated[str, Field(min_length=1, strict=True, max_length=50)] = Field(description="Technical key for resource name convention and version grouping. Must be unique")
    name: Annotated[str, Field(min_length=1, strict=True, max_length=50)] = Field(description="Workspace name. This name is display in the sample webApp")
    description: Optional[StrictStr] = Field(default=None, description="The Workspace description")
    version: Optional[StrictStr] = Field(default=None, description="The Workspace version MAJOR.MINOR.PATCH.")
    tags: Optional[List[StrictStr]] = Field(default=None, description="The list of tags")
    create_info: WorkspaceEditInfo = Field(description="The details of the Workspace creation", alias="createInfo")
    update_info: WorkspaceEditInfo = Field(description="The details of the Workspace last update", alias="updateInfo")
    solution: WorkspaceSolution
    web_app: Optional[WorkspaceWebApp] = Field(default=None, alias="webApp")
    dataset_copy: Optional[StrictBool] = Field(default=True, description="Activate the copy of dataset on scenario creation, meaning that each scenario created in this workspace will make this copy. when false, scenario use directly the dataset specified.", alias="datasetCopy")
    security: WorkspaceSecurity
    __properties: ClassVar[List[str]] = ["id", "organizationId", "key", "name", "description", "version", "tags", "createInfo", "updateInfo", "solution", "webApp", "datasetCopy", "security"]

    @field_validator('id')
    def id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^w-\w{10,20}", value):
            raise ValueError(r"must validate the regular expression /^w-\w{10,20}/")
        return value

    @field_validator('organization_id')
    def organization_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^o-\w{10,20}", value):
            raise ValueError(r"must validate the regular expression /^o-\w{10,20}/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Workspace from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "organization_id",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of create_info
        if self.create_info:
            _dict['createInfo'] = self.create_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of update_info
        if self.update_info:
            _dict['updateInfo'] = self.update_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of solution
        if self.solution:
            _dict['solution'] = self.solution.to_dict()
        # override the default output from pydantic by calling `to_dict()` of web_app
        if self.web_app:
            _dict['webApp'] = self.web_app.to_dict()
        # override the default output from pydantic by calling `to_dict()` of security
        if self.security:
            _dict['security'] = self.security.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Workspace from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "organizationId": obj.get("organizationId"),
            "key": obj.get("key"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "version": obj.get("version"),
            "tags": obj.get("tags"),
            "createInfo": WorkspaceEditInfo.from_dict(obj["createInfo"]) if obj.get("createInfo") is not None else None,
            "updateInfo": WorkspaceEditInfo.from_dict(obj["updateInfo"]) if obj.get("updateInfo") is not None else None,
            "solution": WorkspaceSolution.from_dict(obj["solution"]) if obj.get("solution") is not None else None,
            "webApp": WorkspaceWebApp.from_dict(obj["webApp"]) if obj.get("webApp") is not None else None,
            "datasetCopy": obj.get("datasetCopy") if obj.get("datasetCopy") is not None else True,
            "security": WorkspaceSecurity.from_dict(obj["security"]) if obj.get("security") is not None else None
        })
        return _obj


