# coding: utf-8

"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API

    The version of the OpenAPI document: 5.0.1-SNAPSHOT
    Contact: platform@cosmotech.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from cosmotech_api.models.workspace_security import WorkspaceSecurity
from cosmotech_api.models.workspace_solution import WorkspaceSolution
from cosmotech_api.models.workspace_web_app import WorkspaceWebApp
from typing import Optional, Set
from typing_extensions import Self

class WorkspaceCreateRequest(BaseModel):
    """
    Request object for creating a new workspace
    """ # noqa: E501
    key: Annotated[str, Field(min_length=1, strict=True, max_length=50)] = Field(description="Technical key for resource name convention and version grouping. Must be unique")
    name: Annotated[str, Field(min_length=1, strict=True, max_length=50)] = Field(description="Workspace name. This name is displayed in the sample webApp")
    description: Optional[StrictStr] = Field(default=None, description="The Workspace description")
    version: Optional[StrictStr] = Field(default=None, description="The Workspace version MAJOR.MINOR.PATCH.")
    tags: Optional[List[StrictStr]] = Field(default=None, description="The list of tags")
    solution: WorkspaceSolution
    web_app: Optional[WorkspaceWebApp] = Field(default=None, alias="webApp")
    dataset_copy: Optional[StrictBool] = Field(default=True, description="Activate the copy of dataset on scenario creation", alias="datasetCopy")
    security: Optional[WorkspaceSecurity] = None
    __properties: ClassVar[List[str]] = ["key", "name", "description", "version", "tags", "solution", "webApp", "datasetCopy", "security"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkspaceCreateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of solution
        if self.solution:
            _dict['solution'] = self.solution.to_dict()
        # override the default output from pydantic by calling `to_dict()` of web_app
        if self.web_app:
            _dict['webApp'] = self.web_app.to_dict()
        # override the default output from pydantic by calling `to_dict()` of security
        if self.security:
            _dict['security'] = self.security.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkspaceCreateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "key": obj.get("key"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "version": obj.get("version"),
            "tags": obj.get("tags"),
            "solution": WorkspaceSolution.from_dict(obj["solution"]) if obj.get("solution") is not None else None,
            "webApp": WorkspaceWebApp.from_dict(obj["webApp"]) if obj.get("webApp") is not None else None,
            "datasetCopy": obj.get("datasetCopy") if obj.get("datasetCopy") is not None else True,
            "security": WorkspaceSecurity.from_dict(obj["security"]) if obj.get("security") is not None else None
        })
        return _obj


