# coding: utf-8

"""
    Cosmo Tech Platform API

    Cosmo Tech Platform API

    The version of the OpenAPI document: 5.0.1-SNAPSHOT
    Contact: platform@cosmotech.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class WorkspaceSolution(BaseModel):
    """
    The Workspace Solution configuration
    """ # noqa: E501
    solution_id: Annotated[str, Field(strict=True)] = Field(description="The Solution Id attached to this workspace", alias="solutionId")
    dataset_id: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="The Dataset Id attached to this workspace. This dataset will be used to store default values for Solution parameters with file's varType. ", alias="datasetId")
    default_parameter_values: Optional[Dict[str, StrictStr]] = Field(default=None, description="A map of parameterId/value to set default values for Solution parameters with simple varType (int, string, ...)", alias="defaultParameterValues")
    run_template_filter: Optional[List[StrictStr]] = Field(default=None, description="The list of Solution Run Template Id to filter", alias="runTemplateFilter")
    default_run_template_dataset: Optional[Dict[str, Any]] = Field(default=None, description="A map of RunTemplateId/DatasetId to set a default dataset for a Run Template", alias="defaultRunTemplateDataset")
    __properties: ClassVar[List[str]] = ["solutionId", "datasetId", "defaultParameterValues", "runTemplateFilter", "defaultRunTemplateDataset"]

    @field_validator('solution_id')
    def solution_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^sol-\w{10,20}", value):
            raise ValueError(r"must validate the regular expression /^sol-\w{10,20}/")
        return value

    @field_validator('dataset_id')
    def dataset_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^d-\w{10,20}", value):
            raise ValueError(r"must validate the regular expression /^d-\w{10,20}/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkspaceSolution from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkspaceSolution from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "solutionId": obj.get("solutionId"),
            "datasetId": obj.get("datasetId"),
            "defaultParameterValues": obj.get("defaultParameterValues"),
            "runTemplateFilter": obj.get("runTemplateFilter"),
            "defaultRunTemplateDataset": obj.get("defaultRunTemplateDataset")
        })
        return _obj


