# coding: utf-8
"""
<copyright company="Aspose" file="AboveAveragepy.cs">
  Copyright (c) 2025 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class AboveAverage(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'is_above_average' : 'bool',
        'is_equal_average' : 'bool',
        'std_dev' : 'int'
    }

    attribute_map = {
        'is_above_average' : 'IsAboveAverage' ,
        'is_equal_average' : 'IsEqualAverage' ,
        'std_dev' : 'StdDev' 
    }

    @staticmethod
    def get_swagger_types():
        return AboveAverage.swagger_types

    @staticmethod
    def get_attribute_map():
        return AboveAverage.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,is_above_average=None ,is_equal_average=None ,std_dev=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        AboveAverage - a model defined in Swagger
        """
        self.container['is_above_average'] = None 
        self.container['is_equal_average'] = None 
        self.container['std_dev'] = None 
        params = locals()
        self.is_above_average = is_above_average
        if 'is_above_average' in params:
            self.is_above_average = params["is_above_average"]


             
        self.is_equal_average = is_equal_average
        if 'is_equal_average' in params:
            self.is_equal_average = params["is_equal_average"]


             
        self.std_dev = std_dev
        if 'std_dev' in params:
            self.std_dev = params["std_dev"]


             

    @property
    def is_above_average(self):
        return self.container['is_above_average']

    @is_above_average.setter
    def is_above_average(self, is_above_average):
        self.container['is_above_average'] = is_above_average 
    @property
    def is_equal_average(self):
        return self.container['is_equal_average']

    @is_equal_average.setter
    def is_equal_average(self, is_equal_average):
        self.container['is_equal_average'] = is_equal_average 
    @property
    def std_dev(self):
        return self.container['std_dev']

    @std_dev.setter
    def std_dev(self, std_dev):
        self.container['std_dev'] = std_dev 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, AboveAverage):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    